/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-01-21 15:44:48 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wp_f4a5susers` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5susermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5scommentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5scomments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5sduplicator_activity_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sub_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `severity` int NOT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `version` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5sduplicator_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `archive_name` varchar(350) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` int NOT NULL,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `package` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `version` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5sduplicator_entities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value_1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `version` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5se_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5se_notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `route_post_id` bigint unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint unsigned DEFAULT NULL,
  `element_id` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `position` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `is_resolved` tinyint(1) NOT NULL DEFAULT '0',
  `is_public` tinyint(1) NOT NULL DEFAULT '1',
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5se_notes_users_relations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5se_submissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint unsigned NOT NULL,
  `referer` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip` varchar(46) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int DEFAULT '0',
  `actions_succeeded_count` int DEFAULT '0',
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5se_submissions_actions_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL,
  `action_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5se_submissions_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5sfea_submissions` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user` int NOT NULL,
  `fields` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=777 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5slinks` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5soptions` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=11920 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5spostmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=270902 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5sposts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=6169 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5sterm_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5sterm_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5stermmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5sterms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5stm_taskmeta` (
  `meta_id` bigint NOT NULL AUTO_INCREMENT,
  `task_id` bigint NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5stm_tasks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` bigint NOT NULL,
  `type` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `class_identifier` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '0',
  `attempts` int DEFAULT '0',
  `description` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_locked_at` bigint DEFAULT '0',
  `status` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5swpo_404_detector` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `request_timestamp` bigint unsigned NOT NULL,
  `request_count` bigint unsigned NOT NULL,
  `referrer` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `url` (`url`(75),`request_timestamp`,`referrer`(75)),
  KEY `url_timestamp_referrer` (`url`(75),`request_timestamp`,`referrer`(75)),
  KEY `timestamp_count` (`request_timestamp`,`request_count`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_f4a5sxyz_ips_short_code` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `short_code` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `insertionMethod` int NOT NULL DEFAULT '2',
  `insertionLocation` int NOT NULL DEFAULT '0',
  `insertionLocationType` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wp_f4a5susers` VALUES 
("1","ARC","$wp$2y$12$YpF6uwOi2H8v8lFr5lL1BeohjJYANBdoVbm91.1bERcsq7nooJOtS","arc","contact@arcpartnerssolutions.fr","https://nextgen.arcps.fr","2025-10-28 15:14:31","","0","ARC");

INSERT IGNORE INTO `wp_f4a5susermeta` VALUES 
("1","1","nickname","ARC"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","wp_f4a5scapabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","wp_f4a5suser_level","10"),
("14","1","dismissed_wp_pointers","theme_editor_notice"),
("15","1","show_welcome_panel","1"),
("17","1","wp_f4a5sdashboard_quick_press_last_post_id","6168"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:12:\"154.62.112.0\";}"),
("19","1","wp_f4a5suser-settings","libraryContent=browse&editor=tinymce&posts_list_mode=list"),
("20","1","wp_f4a5suser-settings-time","1768214596"),
("21","1","wp_f4a5selementor_connect_common_data","a:3:{s:9:\"client_id\";s:32:\"pgPEFgQ0tiMFQMWYgt5X2fukRe3RbJd1\";s:11:\"auth_secret\";s:32:\"amHLJNL7IzIhOEU31AEDiQVLTlZXGA7R\";s:5:\"state\";s:12:\"O0qQ8rZoVJaa\";}"),
("22","1","elementor_introduction","a:2:{s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;}"),
("24","1","search_filter_v3_coming_soon_ignore","1"),
("25","1","elementor_admin_notices","a:1:{s:20:\"ally_pages_promotion\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}}"),
("26","1","wp_f4a5spersisted_preferences","a:3:{s:4:\"core\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:10:\"openPanels\";a:2:{i:0;s:11:\"post-status\";i:1;s:23:\"taxonomy-panel-category\";}}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2025-11-28T08:46:43.009Z\";}"),
("27","1","closedpostboxes_page","a:1:{i:0;s:23:\"acf-group_6932a85c25046\";}"),
("28","1","metaboxhidden_page","a:0:{}"),
("29","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("30","1","metaboxhidden_nav-menus","a:1:{i:0;s:12:\"add-post_tag\";}"),
("31","1","submitted::elementor_6f3706d","21"),
("32","1","submitted::","943"),
("33","1","submitted::elementor_06e4d3b","2"),
("34","1","submitted::elementor_a175413","1"),
("35","1","nav_menu_recently_edited","2"),
("36","1","submitted::elementor_c0b47c4","6"),
("37","1","submitted::elementor_9092108","2"),
("38","1","submitted::elementor_b9dc4a7","40"),
("39","1","submitted::elementor_238c6e1","3"),
("40","1","submitted::elementor_e113d31","42"),
("41","1","submitted::elementor_0012a07","50"),
("42","1","submitted::elementor0012a07","-30"),
("43","1","submitted::elementor_eb5c8ea","6"),
("44","1","submitted::elementoreb5c8ea","-2"),
("45","1","submitted::elementor_8337c90","86"),
("61","1","submitted::elementor_14c788e","39"),
("62","1","manageedit-acf-ui-options-pagecolumnshidden","a:1:{i:0;s:7:\"acf-key\";}"),
("63","1","acf_user_settings","a:2:{s:23:\"options-pages-first-run\";b:1;s:20:\"taxonomies-first-run\";b:1;}"),
("64","1","closedpostboxes_acf-ui-options-page","a:0:{}"),
("65","1","metaboxhidden_acf-ui-options-page","a:2:{i:0;s:21:\"acf-advanced-settings\";i:1;s:7:\"slugdiv\";}"),
("66","1","manageedit-acf-taxonomycolumnshidden","a:1:{i:0;s:7:\"acf-key\";}"),
("72","1","_clients_non_archives_user","1"),
("73","1","_compte_contrats_actifs_user","1"),
("74","1","_conformite_totale_user","0"),
("75","1","elementor_dismissed_editor_notices","a:1:{i:0;s:19:\"ally_heading_notice\";}"),
("78","1","meta-box-order_toplevel_page_codes-conseillers","a:2:{s:4:\"side\";s:0:\"\";s:6:\"normal\";s:33:\"submitdiv,acf-group_69246deee70eb\";}"),
("79","1","screen_layout_toplevel_page_codes-conseillers","2"),
("80","1","_e_notifications_dismissed","a:17:{i:0;s:22:\"variables-manager-3.33\";i:1;s:15:\"custom-css-3.33\";i:2;s:15:\"blend-mode-3.33\";i:3;s:14:\"transform-3.32\";i:4;s:18:\"size-variable-3.32\";i:5;s:16:\"transitions-3.32\";i:6;s:14:\"variables-3.31\";i:7;s:12:\"filters-3.31\";i:8;s:14:\"ally-assistant\";i:9;s:12:\"classes-3.31\";i:10;s:15:\"attributes-3.31\";i:11;s:19:\"cloud-websites-3.30\";i:12;s:17:\"ally-notification\";i:13;s:15:\"ai-site-planner\";i:14;s:20:\"image-optimizer-3.19\";i:15;s:20:\"5-star-rating-prompt\";i:16;s:23:\"site-mailer-introducing\";}"),
("81","1","submitted::elementor_ba99f83","76"),
("82","1","submitted::elementorba99f83","-76"),
("83","1","submitted::elementor_721e5c7","1"),
("84","1","submitted::elementor_ab09e9c","396"),
("85","1","submitted::elementorab09e9c","-360"),
("86","1","_prospects_non_archives_user","1"),
("87","1","submitted::elementor_3a52ef1","5"),
("89","1","edit_conformite_per_page","100"),
("93","1","submitted::elementorb9dc4a7","-34"),
("95","1","edit_clients_per_page","100"),
("96","1","edit_contrats_per_page","100"),
("97","1","edit_contrats-avec-ucs_per_page","100"),
("98","1","submitted::elementor_03a8414","1"),
("100","1","session_tokens","a:1:{s:64:\"44fe3030b530948b0d5cfc5683a0d722096f437effa6a1408cfd34dc86d228d6\";a:4:{s:10:\"expiration\";i:1769182459;s:2:\"ip\";s:13:\"154.62.112.60\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";s:5:\"login\";i:1769009659;}}");

INSERT IGNORE INTO `wp_f4a5sduplicator_activity_logs` VALUES 
("35","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 13,\n    \"packageName\": \"20260121_nextgen\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 0,\n    \"dbSize\": 0,\n    \"dbRowCount\": 0\n}","0","4.5.24.3","2026-01-21 15:44:22","2026-01-21 15:44:22"),
("36","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 13,\n    \"packageName\": \"20260121_nextgen\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 48129,\n    \"dirCount\": 3946,\n    \"size\": 562911648,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 26,\n    \"dbSize\": 29884416,\n    \"dbRowCount\": 16782\n}","35","4.5.24.3","2026-01-21 15:44:30","2026-01-21 15:44:30"),
("37","backup_create","start","10","Backup creation: 20260121_nextgen","{\n    \"packageId\": 14,\n    \"packageName\": \"20260121_nextgen\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20260121_nextgen_49a8a2fdd7f5bfba9739_20260121154421\",\n    \"logFileName\": \"20260121_nextgen_49a8a2fdd7f5bfba9739_20260121154421_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 48129,\n    \"dirCount\": 3946,\n    \"size\": 562911648,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 26,\n    \"dbSizeDisplay\": \"28.5MB\",\n    \"execution_start_time\": 1769010287.644537\n}","0","4.5.24.3","2026-01-21 15:44:47","2026-01-21 15:44:47"),
("38","backup_create","db_dump","10","Backup creation: 20260121_nextgen - Database Dump","{\n    \"packageId\": 14,\n    \"packageName\": \"20260121_nextgen\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20260121_nextgen_49a8a2fdd7f5bfba9739_20260121154421\",\n    \"logFileName\": \"20260121_nextgen_49a8a2fdd7f5bfba9739_20260121154421_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 48129,\n    \"dirCount\": 3946,\n    \"size\": 562911648,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 26,\n    \"dbSizeDisplay\": \"28.5MB\",\n    \"execution_start_time\": 1769010287.644537\n}","37","4.5.24.3","2026-01-21 15:44:47","2026-01-21 15:44:47");

INSERT IGNORE INTO `wp_f4a5sduplicator_backups` VALUES 
("13","Standard","20260121_nextgen","49a8a2fdd7f5bfba9739_20260121154421","20260121_nextgen_49a8a2fdd7f5bfba9739_20260121154421_archive.zip","5","MANUAL,ZIP_ARCHIVE,TEMPORARY","{\n    \"ID\": 13,\n    \"VersionWP\": \"6.9\",\n    \"VersionDB\": \"8.4.6\",\n    \"VersionPHP\": \"8.4.10\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20260121_nextgen\",\n    \"hash\": \"49a8a2fdd7f5bfba9739_20260121154421\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/nextgen.arcps.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20260121_nextgen_49a8a2fdd7f5bfba9739_20260121154421_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/arcpsfk\\/nextgen\\/.opcache\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/.tmb\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/bps-backup\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/cache\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/old-cache\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/updraft\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/wfcache\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/.htaccess\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/.user.ini\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/php.ini\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/web.config\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-config.php\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20260121_nextgen_49a8a2fdd7f5bfba9739_20260121154421_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/arcpsfk\\/nextgen\\/\",\n        \"Size\": 562911648,\n        \"Dirs\": [],\n        \"DirCount\": 3946,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 48129,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 392638899,\n                        \"bytes\": \"374.45MB\",\n                        \"nodes\": 47427,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 501446358,\n                        \"bytes\": \"478.22MB\",\n                        \"nodes\": 48851,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-snapshots\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/.opcache\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/.tmb\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/old-cache\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/updraft\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/wfcache\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/cache\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 5841368,\n                        \"bytes\": \"5.57MB\",\n                        \"nodes\": 1,\n                        \"name\": \"Aegyptus.otf\",\n                        \"dir\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\",\n                        \"path\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\\/Aegyptus.otf\"\n                    },\n                    {\n                        \"ubytes\": 22993540,\n                        \"bytes\": \"21.93MB\",\n                        \"nodes\": 1,\n                        \"name\": \"Sun-ExtA.ttf\",\n                        \"dir\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\",\n                        \"path\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\\/Sun-ExtA.ttf\"\n                    },\n                    {\n                        \"ubytes\": 17632200,\n                        \"bytes\": \"16.82MB\",\n                        \"nodes\": 1,\n                        \"name\": \"Sun-ExtB.ttf\",\n                        \"dir\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\",\n                        \"path\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\\/Sun-ExtB.ttf\"\n                    },\n                    {\n                        \"ubytes\": 6937228,\n                        \"bytes\": \"6.62MB\",\n                        \"nodes\": 1,\n                        \"name\": \"UnBatang_0613.ttf\",\n                        \"dir\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\",\n                        \"path\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\\/UnBatang_0613.ttf\"\n                    },\n                    {\n                        \"ubytes\": 9651078,\n                        \"bytes\": \"9.2MB\",\n                        \"nodes\": 1,\n                        \"name\": \"GeoCountry.mmdb\",\n                        \"dir\": \"wp-content\\/plugins\\/hide-my-wp\\/models\\/geoip\",\n                        \"path\": \"wp-content\\/plugins\\/hide-my-wp\\/models\\/geoip\\/GeoCountry.mmdb\"\n                    },\n                    {\n                        \"ubytes\": 4567059,\n                        \"bytes\": \"4.36MB\",\n                        \"nodes\": 1,\n                        \"name\": \"jquery.emojipicker.tw.css\",\n                        \"dir\": \"wp-content\\/themes\\/woffice\\/css\\/emojis\",\n                        \"path\": \"wp-content\\/themes\\/woffice\\/css\\/emojis\\/jquery.emojipicker.tw.css\"\n                    },\n                    {\n                        \"ubytes\": 42321039,\n                        \"bytes\": \"40.36MB\",\n                        \"nodes\": 1,\n                        \"name\": \"woffice-core.zip\",\n                        \"dir\": \"wp-content\\/themes\\/woffice\\/inc\\/plugins\",\n                        \"path\": \"wp-content\\/themes\\/woffice\\/inc\\/plugins\\/woffice-core.zip\"\n                    },\n                    {\n                        \"ubytes\": 6841089,\n                        \"bytes\": \"6.52MB\",\n                        \"nodes\": 1,\n                        \"name\": \"DONE_Abeille_2026-11-04.xml\",\n                        \"dir\": \"wp-content\\/uploads\\/agregateur-inbox\",\n                        \"path\": \"wp-content\\/uploads\\/agregateur-inbox\\/DONE_Abeille_2026-11-04.xml\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/.htaccess\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/.user.ini\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/php.ini\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/web.config\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/debug.log\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"text\": \"\\/home\\/arcpsfk\\/nextgen <span class=\\\"size\\\" >536.83MB<\\/span> <span class=\\\"nodes\\\" >52075<\\/span>\",\n                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\",\n                \"type\": \"folder\",\n                \"state\": {\n                    \"opened\": true,\n                    \"disabled\": false,\n                    \"selected\": false,\n                    \"checked\": false,\n                    \"checkbox_disabled\": true\n                },\n                \"children\": [\n                    {\n                        \"text\": \"wp-content <span class=\\\"size\\\" >478.22MB<\\/span> <span class=\\\"nodes\\\" >48851<\\/span>\",\n                        \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"plugins <span class=\\\"size\\\" >374.45MB<\\/span> <span class=\\\"nodes\\\" >47427<\\/span>\",\n                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"conformite-pdf-generator <span class=\\\"size\\\" >97.8MB<\\/span> <span class=\\\"nodes\\\" >837<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/conformite-pdf-generator\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"vendor <span class=\\\"size\\\" >94.67MB<\\/span> <span class=\\\"nodes\\\" >816<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"mpdf <span class=\\\"size\\\" >94.3MB<\\/span> <span class=\\\"nodes\\\" >645<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\",\n                                                        \"type\": \"folder\",\n                                                        \"state\": {\n                                                            \"opened\": true,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": [\n                                                            {\n                                                                \"text\": \"mpdf <span class=\\\"size\\\" >94.27MB<\\/span> <span class=\\\"nodes\\\" >629<\\/span>\",\n                                                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\",\n                                                                \"type\": \"folder\",\n                                                                \"state\": {\n                                                                    \"opened\": true,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": [\n                                                                    {\n                                                                        \"text\": \"ttfonts <span class=\\\"size\\\" >86.88MB<\\/span> <span class=\\\"nodes\\\" >84<\\/span>\",\n                                                                        \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\",\n                                                                        \"type\": \"folder\",\n                                                                        \"state\": {\n                                                                            \"opened\": true,\n                                                                            \"disabled\": false,\n                                                                            \"selected\": false,\n                                                                            \"checked\": false,\n                                                                            \"checkbox_disabled\": false\n                                                                        },\n                                                                        \"children\": [\n                                                                            {\n                                                                                \"text\": \"Aegyptus.otf <span class=\\\"size\\\" >5.57MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\\/Aegyptus.otf\",\n                                                                                \"type\": \"file\",\n                                                                                \"state\": {\n                                                                                    \"opened\": false,\n                                                                                    \"disabled\": false,\n                                                                                    \"selected\": false,\n                                                                                    \"checked\": false,\n                                                                                    \"checkbox_disabled\": false\n                                                                                },\n                                                                                \"children\": null,\n                                                                                \"li_attr\": {\n                                                                                    \"class\": \" warning-node\"\n                                                                                },\n                                                                                \"a_attr\": []\n                                                                            },\n                                                                            {\n                                                                                \"text\": \"Sun-ExtA.ttf <span class=\\\"size\\\" >21.93MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\\/Sun-ExtA.ttf\",\n                                                                                \"type\": \"file\",\n                                                                                \"state\": {\n                                                                                    \"opened\": false,\n                                                                                    \"disabled\": false,\n                                                                                    \"selected\": false,\n                                                                                    \"checked\": false,\n                                                                                    \"checkbox_disabled\": false\n                                                                                },\n                                                                                \"children\": null,\n                                                                                \"li_attr\": {\n                                                                                    \"class\": \" warning-node\"\n                                                                                },\n                                                                                \"a_attr\": []\n                                                                            },\n                                                                            {\n                                                                                \"text\": \"Sun-ExtB.ttf <span class=\\\"size\\\" >16.82MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\\/Sun-ExtB.ttf\",\n                                                                                \"type\": \"file\",\n                                                                                \"state\": {\n                                                                                    \"opened\": false,\n                                                                                    \"disabled\": false,\n                                                                                    \"selected\": false,\n                                                                                    \"checked\": false,\n                                                                                    \"checkbox_disabled\": false\n                                                                                },\n                                                                                \"children\": null,\n                                                                                \"li_attr\": {\n                                                                                    \"class\": \" warning-node\"\n                                                                                },\n                                                                                \"a_attr\": []\n                                                                            },\n                                                                            {\n                                                                                \"text\": \"UnBatang_0613.ttf <span class=\\\"size\\\" >6.62MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\\/UnBatang_0613.ttf\",\n                                                                                \"type\": \"file\",\n                                                                                \"state\": {\n                                                                                    \"opened\": false,\n                                                                                    \"disabled\": false,\n                                                                                    \"selected\": false,\n                                                                                    \"checked\": false,\n                                                                                    \"checkbox_disabled\": false\n                                                                                },\n                                                                                \"children\": null,\n                                                                                \"li_attr\": {\n                                                                                    \"class\": \" warning-node\"\n                                                                                },\n                                                                                \"a_attr\": []\n                                                                            }\n                                                                        ],\n                                                                        \"li_attr\": {\n                                                                            \"data-full-loaded\": false,\n                                                                            \"class\": \" warning-childs\"\n                                                                        },\n                                                                        \"a_attr\": []\n                                                                    }\n                                                                ],\n                                                                \"li_attr\": {\n                                                                    \"data-full-loaded\": false,\n                                                                    \"class\": \" warning-childs\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            }\n                                                        ],\n                                                        \"li_attr\": {\n                                                            \"data-full-loaded\": false,\n                                                            \"class\": \" warning-childs\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    },\n                                    {\n                                        \"text\": \"hide-my-wp <span class=\\\"size\\\" >15.25MB<\\/span> <span class=\\\"nodes\\\" >277<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/hide-my-wp\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"models <span class=\\\"size\\\" >9.73MB<\\/span> <span class=\\\"nodes\\\" >85<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/hide-my-wp\\/models\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"geoip <span class=\\\"size\\\" >9.24MB<\\/span> <span class=\\\"nodes\\\" >15<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/hide-my-wp\\/models\\/geoip\",\n                                                        \"type\": \"folder\",\n                                                        \"state\": {\n                                                            \"opened\": true,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": [\n                                                            {\n                                                                \"text\": \"GeoCountry.mmdb <span class=\\\"size\\\" >9.2MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/hide-my-wp\\/models\\/geoip\\/GeoCountry.mmdb\",\n                                                                \"type\": \"file\",\n                                                                \"state\": {\n                                                                    \"opened\": false,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": null,\n                                                                \"li_attr\": {\n                                                                    \"class\": \" warning-node\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            }\n                                                        ],\n                                                        \"li_attr\": {\n                                                            \"data-full-loaded\": false,\n                                                            \"class\": \" warning-childs\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            },\n                            {\n                                \"text\": \"themes <span class=\\\"size\\\" >64.84MB<\\/span> <span class=\\\"nodes\\\" >553<\\/span>\",\n                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/themes\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"woffice <span class=\\\"size\\\" >64.84MB<\\/span> <span class=\\\"nodes\\\" >548<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/themes\\/woffice\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"css <span class=\\\"size\\\" >5.68MB<\\/span> <span class=\\\"nodes\\\" >18<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/themes\\/woffice\\/css\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"emojis <span class=\\\"size\\\" >4.42MB<\\/span> <span class=\\\"nodes\\\" >3<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/themes\\/woffice\\/css\\/emojis\",\n                                                        \"type\": \"folder\",\n                                                        \"state\": {\n                                                            \"opened\": true,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": [\n                                                            {\n                                                                \"text\": \"jquery.emojipicker.tw.css <span class=\\\"size\\\" >4.36MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/themes\\/woffice\\/css\\/emojis\\/jquery.emojipicker.tw.css\",\n                                                                \"type\": \"file\",\n                                                                \"state\": {\n                                                                    \"opened\": false,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": null,\n                                                                \"li_attr\": {\n                                                                    \"class\": \" warning-node\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            }\n                                                        ],\n                                                        \"li_attr\": {\n                                                            \"data-full-loaded\": false,\n                                                            \"class\": \" warning-childs\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            },\n                                            {\n                                                \"text\": \"inc <span class=\\\"size\\\" >41.24MB<\\/span> <span class=\\\"nodes\\\" >93<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/themes\\/woffice\\/inc\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"plugins <span class=\\\"size\\\" >40.51MB<\\/span> <span class=\\\"nodes\\\" >3<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/themes\\/woffice\\/inc\\/plugins\",\n                                                        \"type\": \"folder\",\n                                                        \"state\": {\n                                                            \"opened\": true,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": [\n                                                            {\n                                                                \"text\": \"woffice-core.zip <span class=\\\"size\\\" >40.36MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/themes\\/woffice\\/inc\\/plugins\\/woffice-core.zip\",\n                                                                \"type\": \"file\",\n                                                                \"state\": {\n                                                                    \"opened\": false,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": null,\n                                                                \"li_attr\": {\n                                                                    \"class\": \" warning-node\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            }\n                                                        ],\n                                                        \"li_attr\": {\n                                                            \"data-full-loaded\": false,\n                                                            \"class\": \" warning-childs\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-childs\"\n                                },\n                                \"a_attr\": []\n                            },\n                            {\n                                \"text\": \"uploads <span class=\\\"size\\\" >32.01MB<\\/span> <span class=\\\"nodes\\\" >575<\\/span>\",\n                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"agregateur-inbox <span class=\\\"size\\\" >6.52MB<\\/span> <span class=\\\"nodes\\\" >4<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/agregateur-inbox\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"DONE_Abeille_2026-11-04.xml <span class=\\\"size\\\" >6.52MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/agregateur-inbox\\/DONE_Abeille_2026-11-04.xml\",\n                                                \"type\": \"file\",\n                                                \"state\": {\n                                                    \"opened\": false,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": null,\n                                                \"li_attr\": {\n                                                    \"class\": \" warning-node\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-childs\"\n                                },\n                                \"a_attr\": []\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" warning-node\"\n                        },\n                        \"a_attr\": []\n                    }\n                ],\n                \"li_attr\": {\n                    \"data-full-loaded\": false,\n                    \"class\": \" root-node core-node warning-childs\"\n                },\n                \"a_attr\": {\n                    \"title\": \"Core WordPress directories should not be filtered. Use caution when excluding files.\"\n                }\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20260121_nextgen_49a8a2fdd7f5bfba9739_20260121154421_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"yZ5z4CUmF3PJ1wS7+ppE+Cwivhmz05cYaDFNuQxhfsDo1hbJXRNJ6PHysgS47+mMkRaE2yNgROfQJ9NAtpP2uuPQePUl3hj13opVo9uB5APOuaIWjImTltlW8IMPgUV9\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"arcpsfknextgen\",\n            \"tablesBaseCount\": 26,\n            \"tablesFinalCount\": 26,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 16782,\n            \"tablesSizeOnDisk\": 29884416,\n            \"tablesList\": {\n                \"wp_f4a5scommentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_f4a5scomments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_f4a5sduplicator_activity_logs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_f4a5sduplicator_backups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_f4a5sduplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_f4a5se_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_f4a5se_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"wp_f4a5se_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_f4a5se_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"wp_f4a5se_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_f4a5se_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_f4a5sfea_submissions\": {\n                    \"inaccurateRows\": \"524\",\n                    \"insertedRows\": 0,\n                    \"size\": 16269312\n                },\n                \"wp_f4a5slinks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_f4a5soptions\": {\n                    \"inaccurateRows\": \"730\",\n                    \"insertedRows\": 0,\n                    \"size\": 2654208\n                },\n                \"wp_f4a5spostmeta\": {\n                    \"inaccurateRows\": \"14390\",\n                    \"insertedRows\": 0,\n                    \"size\": 4620288\n                },\n                \"wp_f4a5sposts\": {\n                    \"inaccurateRows\": \"775\",\n                    \"insertedRows\": 0,\n                    \"size\": 4489216\n                },\n                \"wp_f4a5sterm_relationships\": {\n                    \"inaccurateRows\": \"204\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_f4a5sterm_taxonomy\": {\n                    \"inaccurateRows\": \"40\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_f4a5stermmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_f4a5sterms\": {\n                    \"inaccurateRows\": \"40\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_f4a5stm_taskmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_f4a5stm_tasks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_f4a5susermeta\": {\n                    \"inaccurateRows\": \"70\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_f4a5susers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_f4a5swpo_404_detector\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_f4a5sxyz_ips_short_code\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.4.6\",\n            \"versionComment\": \"Percona Server (GPL), Release \'6\', Revision \'9927a2fb\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20260121_nextgen_49a8a2fdd7f5bfba9739_20260121154421_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;6&#039;, Revision &#039;9927a2fb&#039;\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 5,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 562911648,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"isProcessing\": false,\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-01-21 15:44:21\",\n    \"updated\": \"2026-01-21 15:44:30\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"TEMPORARY\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 35,\n    \"mainActivityLogId\": 0\n}","4.5.24.3","2026-01-21 15:44:21","2026-01-21 15:44:30"),
("14","Standard","20260121_nextgen","49a8a2fdd7f5bfba9739_20260121154421","20260121_nextgen_49a8a2fdd7f5bfba9739_20260121154421_archive.zip","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 14,\n    \"VersionWP\": \"6.9\",\n    \"VersionDB\": \"8.4.6\",\n    \"VersionPHP\": \"8.4.10\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20260121_nextgen\",\n    \"hash\": \"49a8a2fdd7f5bfba9739_20260121154421\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/nextgen.arcps.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20260121_nextgen_49a8a2fdd7f5bfba9739_20260121154421_scan.json\",\n    \"timer_start\": 1769010287.644537,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/arcpsfk\\/nextgen\\/.opcache\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/.tmb\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/bps-backup\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/cache\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/old-cache\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/updraft\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/wfcache\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/.htaccess\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/.user.ini\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/php.ini\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/web.config\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-config.php\",\n            \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20260121_nextgen_49a8a2fdd7f5bfba9739_20260121154421_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/arcpsfk\\/nextgen\\/\",\n        \"Size\": 562911648,\n        \"Dirs\": [],\n        \"DirCount\": 3946,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 48129,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 392638899,\n                        \"bytes\": \"374.45MB\",\n                        \"nodes\": 47427,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 501446358,\n                        \"bytes\": \"478.22MB\",\n                        \"nodes\": 48851,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-snapshots\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/.opcache\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/.tmb\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/old-cache\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/updraft\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/wfcache\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/cache\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 5841368,\n                        \"bytes\": \"5.57MB\",\n                        \"nodes\": 1,\n                        \"name\": \"Aegyptus.otf\",\n                        \"dir\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\",\n                        \"path\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\\/Aegyptus.otf\"\n                    },\n                    {\n                        \"ubytes\": 22993540,\n                        \"bytes\": \"21.93MB\",\n                        \"nodes\": 1,\n                        \"name\": \"Sun-ExtA.ttf\",\n                        \"dir\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\",\n                        \"path\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\\/Sun-ExtA.ttf\"\n                    },\n                    {\n                        \"ubytes\": 17632200,\n                        \"bytes\": \"16.82MB\",\n                        \"nodes\": 1,\n                        \"name\": \"Sun-ExtB.ttf\",\n                        \"dir\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\",\n                        \"path\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\\/Sun-ExtB.ttf\"\n                    },\n                    {\n                        \"ubytes\": 6937228,\n                        \"bytes\": \"6.62MB\",\n                        \"nodes\": 1,\n                        \"name\": \"UnBatang_0613.ttf\",\n                        \"dir\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\",\n                        \"path\": \"wp-content\\/plugins\\/conformite-pdf-generator\\/vendor\\/mpdf\\/mpdf\\/ttfonts\\/UnBatang_0613.ttf\"\n                    },\n                    {\n                        \"ubytes\": 9651078,\n                        \"bytes\": \"9.2MB\",\n                        \"nodes\": 1,\n                        \"name\": \"GeoCountry.mmdb\",\n                        \"dir\": \"wp-content\\/plugins\\/hide-my-wp\\/models\\/geoip\",\n                        \"path\": \"wp-content\\/plugins\\/hide-my-wp\\/models\\/geoip\\/GeoCountry.mmdb\"\n                    },\n                    {\n                        \"ubytes\": 4567059,\n                        \"bytes\": \"4.36MB\",\n                        \"nodes\": 1,\n                        \"name\": \"jquery.emojipicker.tw.css\",\n                        \"dir\": \"wp-content\\/themes\\/woffice\\/css\\/emojis\",\n                        \"path\": \"wp-content\\/themes\\/woffice\\/css\\/emojis\\/jquery.emojipicker.tw.css\"\n                    },\n                    {\n                        \"ubytes\": 42321039,\n                        \"bytes\": \"40.36MB\",\n                        \"nodes\": 1,\n                        \"name\": \"woffice-core.zip\",\n                        \"dir\": \"wp-content\\/themes\\/woffice\\/inc\\/plugins\",\n                        \"path\": \"wp-content\\/themes\\/woffice\\/inc\\/plugins\\/woffice-core.zip\"\n                    },\n                    {\n                        \"ubytes\": 6841089,\n                        \"bytes\": \"6.52MB\",\n                        \"nodes\": 1,\n                        \"name\": \"DONE_Abeille_2026-11-04.xml\",\n                        \"dir\": \"wp-content\\/uploads\\/agregateur-inbox\",\n                        \"path\": \"wp-content\\/uploads\\/agregateur-inbox\\/DONE_Abeille_2026-11-04.xml\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/.htaccess\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/.user.ini\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/php.ini\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/web.config\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/debug.log\",\n                    \"\\/home\\/arcpsfk\\/nextgen\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20260121_nextgen_49a8a2fdd7f5bfba9739_20260121154421_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"P5dhbkBIBH6ePPwMsP01Z9eKh2XxRlzy1LY9C8m1G+7o1hbJXRNJ6PHysgS47+mMkRaE2yNgROeyimLBjnSE\\/xAvucPJsPsNbnTdORQFs6T+ZctYsZk\\/47WfH90S5ctf\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"arcpsfknextgen\",\n            \"tablesBaseCount\": 26,\n            \"tablesFinalCount\": 26,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 16782,\n            \"tablesSizeOnDisk\": 29884416,\n            \"tablesList\": {\n                \"wp_f4a5scommentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_f4a5scomments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_f4a5sduplicator_activity_logs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_f4a5sduplicator_backups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_f4a5sduplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_f4a5se_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_f4a5se_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"wp_f4a5se_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_f4a5se_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"wp_f4a5se_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_f4a5se_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_f4a5sfea_submissions\": {\n                    \"inaccurateRows\": \"524\",\n                    \"insertedRows\": 0,\n                    \"size\": 16269312\n                },\n                \"wp_f4a5slinks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_f4a5soptions\": {\n                    \"inaccurateRows\": \"730\",\n                    \"insertedRows\": 0,\n                    \"size\": 2654208\n                },\n                \"wp_f4a5spostmeta\": {\n                    \"inaccurateRows\": \"14390\",\n                    \"insertedRows\": 0,\n                    \"size\": 4620288\n                },\n                \"wp_f4a5sposts\": {\n                    \"inaccurateRows\": \"775\",\n                    \"insertedRows\": 0,\n                    \"size\": 4489216\n                },\n                \"wp_f4a5sterm_relationships\": {\n                    \"inaccurateRows\": \"204\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_f4a5sterm_taxonomy\": {\n                    \"inaccurateRows\": \"40\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_f4a5stermmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_f4a5sterms\": {\n                    \"inaccurateRows\": \"40\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_f4a5stm_taskmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_f4a5stm_tasks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_f4a5susermeta\": {\n                    \"inaccurateRows\": \"70\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_f4a5susers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_f4a5swpo_404_detector\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_f4a5sxyz_ips_short_code\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"Percona\",\n            \"version\": \"8.4.6\",\n            \"versionComment\": \"Percona Server (GPL), Release \'6\', Revision \'9927a2fb\'\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20260121_nextgen_49a8a2fdd7f5bfba9739_20260121154421_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"Percona Server (GPL), Release &#039;6&#039;, Revision &#039;9927a2fb&#039;\",\n        \"dbStorePathPublic\": \"\\/home\\/arcpsfk\\/nextgen\\/wp-content\\/backups-dup-pro\\/tmp\\/20260121_nextgen_49a8a2fdd7f5bfba9739_20260121154421_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 20,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1769010289,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 562911648,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_f4a5susers\",\n            \"wp_f4a5susermeta\",\n            \"wp_f4a5scommentmeta\",\n            \"wp_f4a5scomments\",\n            \"wp_f4a5sduplicator_activity_logs\",\n            \"wp_f4a5sduplicator_backups\",\n            \"wp_f4a5sduplicator_entities\",\n            \"wp_f4a5se_events\",\n            \"wp_f4a5se_notes\",\n            \"wp_f4a5se_notes_users_relations\",\n            \"wp_f4a5se_submissions\",\n            \"wp_f4a5se_submissions_actions_log\",\n            \"wp_f4a5se_submissions_values\",\n            \"wp_f4a5sfea_submissions\",\n            \"wp_f4a5slinks\",\n            \"wp_f4a5soptions\",\n            \"wp_f4a5spostmeta\",\n            \"wp_f4a5sposts\",\n            \"wp_f4a5sterm_relationships\",\n            \"wp_f4a5sterm_taxonomy\",\n            \"wp_f4a5stermmeta\",\n            \"wp_f4a5sterms\",\n            \"wp_f4a5stm_taskmeta\",\n            \"wp_f4a5stm_tasks\",\n            \"wp_f4a5swpo_404_detector\",\n            \"wp_f4a5sxyz_ips_short_code\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1769010287.655278,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 16782,\n            \"tables\": {\n                \"wp_f4a5susers\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5susermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5scommentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5scomments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5sduplicator_activity_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5sduplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5sduplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5se_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5se_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5se_notes_users_relations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5se_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5se_submissions_actions_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5se_submissions_values\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5sfea_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5slinks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5soptions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5spostmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5sposts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5sterm_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5sterm_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5stermmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5sterms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5stm_taskmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5stm_tasks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5swpo_404_detector\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_f4a5sxyz_ips_short_code\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"isProcessing\": false,\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-01-21 15:44:21\",\n    \"updated\": \"2026-01-21 15:44:49\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 35,\n    \"mainActivityLogId\": 37\n}","4.5.24.3","2026-01-21 15:44:21","2026-01-21 15:44:49");

INSERT IGNORE INTO `wp_f4a5sduplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"contact@arcpartnerssolutions.fr\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"contact@arcpartnerssolutions.fr\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"admin\",\n    \"custom_ajax_url\": \"https:\\/\\/nextgen.arcps.fr\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"purgeBackupRecords\": 0,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1767975216,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 1,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-01-09 16:13:36\",\n    \"updated\": \"2026-01-21 15:44:21\"\n}","4.5.24.3","2026-01-09 16:13:36","2026-01-21 15:44:21"),
("2","Dynamic_Entity","","","","","","{\n    \"data\": \"C3c4lT\\/dlEn7\\/vJ2VXV8UuMlTXUkcdXJro6ecOAC636k54tkMjn2O8OADQ\\/1NhtKVIa+tX7bqU2aGdoBb43ioCdus+jI3toR\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 2,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-01-09 16:13:36\",\n    \"updated\": \"2026-01-21 15:34:21\",\n    \"dataIsEncrypted\": true\n}","4.5.24.3","2026-01-09 16:13:36","2026-01-21 15:34:21"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"AcWnmduOAghkzKIyEIdcRYYbfMNRRZt4h66iAesJIkvJ3yZJsaxE1L4h7XQE8jPI3BR3MF0ApaCN07adqdCkN\\/q\\/tsn0W1LsbZ9en7h3WZH8cMVTS+ADcQd5okjdGDaZagwyF92950t+ZvzyCg\\/XVa8U4lC777YwWzGzRJyok6s+mN+oFSqQ09Lo0pGURSUAVR1cdh4+GpDqbJpino7dqPRgBzITZWhxAEx8qxSg2v6JKydcTFDUEg==\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 3,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-01-09 16:13:36\",\n    \"updated\": \"2026-01-21 15:34:21\"\n}","4.5.24.3","2026-01-09 16:13:36","2026-01-21 15:34:21"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 4,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"\",\n    \"updated\": \"2026-01-21 15:34:21\"\n}","4.5.24.3","2026-01-09 16:13:36","2026-01-21 15:34:21"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"btnoNoIzPzQs63m1\\/nXCAfgyWdQaLfNNftuzW564ecq\\/Vsql71BnoM53rTP0z7Qsq+dRaYbEOYYAzi5vvH2S5g==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 5,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-01-09 16:13:36\",\n    \"updated\": \"2026-01-09 16:13:36\"\n}","4.5.24.3","2026-01-09 16:13:36","2026-01-09 16:13:36"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"gGrB5CE4VpeY\\/D+eE+Z\\/KZBaLsnbE7TeSfZXeTzsZ5Lo1hbJXRNJ6PHysgS47+mMkRaE2yNgROfe9rb5zfk5yYfIQ3EkbvMB3qZdKm2idujwOJ6y4YdOJJDAz+Ztywew\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -1,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 6,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-01-09 16:13:36\",\n    \"updated\": \"2026-01-21 15:44:21\"\n}","4.5.24.3","2026-01-09 16:13:36","2026-01-21 15:44:21"),
("7","LicenseDataEntity","","","","","","{\n    \"licenseKey\": \"GXAXXpUC6ZPqVHvkYRsGpVp2fZCdQb6+JAyx4WutPN10avKDaTf7kwTweyL2gFXBxNjZNFnD9qnRMST9Bz59hA==\",\n    \"status\": \"WZkIUxQSMB7LeEnJ7Ka3nU18GmVmhQIRauWjcTwH6x3\\/1AQAKNOzb4dznJ1\\/afbGCeAZAE\\/IQZjC3IhgGAx+lievGBHUZmVx\",\n    \"type\": \"gmMkN8xU\\/k\\/z2RagMrmKKMK8OhY7t++Wxy\\/xuMrJQh4ZV8ex7ajmRph+Ml7CwyZGOFGj8Cw1BpK8S+JAhlbIWcvTteDpF5d5\",\n    \"data\": \"P7RqKjEAA+zGlAt05rAeIXet9ZoJyahju9NZRikXGMWBkhTAZFHqBKLoKvgsywakL0xeKFXv7Ry8S1NFy24ubd918Ht4x8BSlcE\\/NTWw3lipet1\\/Agp35qDuGpRwtu4YamFzVbe2hdgD4T\\/51iszw5VuSiMBUM+Id\\/Z7EMAMhohP+NHWtmqAMihd5bl0xpMP8GdnuacUYnaXZ+l06oMMi3ndRIcVB+HqVzZavTQrllVwd6\\/0TBFS+F+kza64oxS2r1YbACiiAIVr0E9MiAuI+jBJqIyBwpcFXeH8OwI65e8XnLNyTUqdwtzkIBP38g0YBEu7G+baLz4Whq6l8kmU69h7wdwvtOQeZhSNstF4Q54VGet85q1oo4XfPNynrmTXCxYQ82PQQqbQKIUHI4qD31LB+ftYvRxf\",\n    \"lastRemoteUpdate\": \"\",\n    \"lastFailureTime\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 7,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-01-09 16:13:36\",\n    \"updated\": \"2026-01-21 15:34:21\"\n}","4.5.24.3","2026-01-09 16:13:36","2026-01-21 15:34:21"),
("8","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1769010287,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 8,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-01-09 16:13:36\",\n    \"updated\": \"2026-01-21 15:44:47\"\n}","4.5.24.3","2026-01-09 16:13:36","2026-01-21 15:44:47");

INSERT IGNORE INTO `wp_f4a5sfea_submissions` VALUES 
("1","","2025-10-29 16:46:04","1","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","77:elementor_6f3706d","approved"),
("2","","2025-10-29 16:56:41","1","K3JNa1M0V3lBc0NMYUxST0ZHSEV2MElnVXVWNW1SNVd4Q244N2tIZEJUUzJUelR1THAxMXBLSFBFUnp1Q3RaSTFtVFMxdHU4MUVhTUJMTDQ2NXd0K2o4SGI0L3ZJUkdZRUY5Rko0emQ1OHNYNjcxQTV1OVJzZHRXbWtuZ2VRU2Z3MGJ2TEwvQ2IrOXo4QVBsODBEMzNMZkE0bmEwUkJiYzdrc3ptQTlmeUFqMjV2cFZPZ2tyRDFORXlEQjBKeStVMUUxeVdQZTh3SDhZbVhkbGI4LytPNTZzc0gvUk9aWldQdVNRV1NVcEF0RmVobiswa0FyVDVlOHRwUnQ5SkE4ejVrQU9tZ1FhcmdvNHIyTEFBWXN2bEpLMGxXczN4b2ZzN0ppelhORDFRMFV3QkU2eTdSc3FSWFNkaHI1UE1RaGFqdW9yaGJRTDlBU3RMWHBGc3VNckRMeU4zaWpLd1dJY2d1RUc1ZjRHUjRaV2NPbnlRUmlQdmxxOEpUTFFxQk01VXhoSnovS2ErZmREbmlTekxONER2ZmpXelpDTmV3aVUzTmRsZ2VqU2VqUWJJMjRZaXR3dFRHNXFVcW1adWYxSnU5Q3ZSRTNZbGR3RkxYVnBxUmx6UE4wS2xNNjRlNUE5MS9ORjUzNGJjSFp5TVl6WFRZMFY5NE1FY0cxeE1vV1hacSt5L2t4UWpoRFV3UWlqcWhVd01sZHhCQVpDTWwwdFZEUTg5WEw4TUMyOElDZm54clFJeDFhSGtHYk13Y3JpUisvZkh6OTVnOGRwREI4aEhHU0dIRmo2VTJDUzEyR3l0a1BneXRiR2JIQ1hqTTZ3ajIwVzhvc0dQUkI0bzV4TVp4cG94dFZDc3JGSEg5cVJWNm1BVkR4YW9vVGtmczRpSmpiQjd3ZzRlbnhndXJ3VGREUm1aOGFyQlZNa0JkMGpiaXM2dWRUL3ZVUitkWUJnQnhkYXFoaHk2Q1dFNnEzVEJUeWl6TTFzNUdtUGtjTFJLZlYvSlhON3VCclhza2pHeWVlbmZBdHJHNG1EdzErcURCUzZTcGFBZ2IzMmdCc2Uwczlka1lqZnA1UUNzU3RjalgxMnJCTnBmNFJFanFqTVFpN0ZaNzNNUWc3ZWFiVzJEWk1oTkRMcFVNTTNIRE9LcitQdUNudjVxMHQ1WkhCVmtpOGRacDE2Q0ovSmR1MW5EcktFZGdwTjJNUExYeDJtcDlTaGJLV20rV1RUbWZaV1VrZno4MHpOWkFNVW8zTHBFWlZScGdhY045Y2M4RENkZEk5d0gwZ0pibldmeEQ0Qk5XQTVka1k4QWpXZUQ5b1NRS0xpOEdDRDE1Sk5GV08wQW9wejlSNE5rbU5aTnhRbWtGNmVJUWE4UUkzTGhjaWF5dmpWSnlBS2xzUit3aWJaQlpPMG9XSEN3ZjZvL2ZsdDhBS2ZGMk9TdVZqMVVkV1Z1NUhVcWRIeVBEdnhCUGhWTHMzUkI4NHpJbUlaR1l2UHM0T2prTFp5SXIyd0JtOTRyZlZKM0grNy9GTXpma2pVQXBCSkJlQmd0Q1lXUnQveUpFbE43bGNzYjV5WXBzeHl6Mkp5akRiZWM5cU50Qk5SbTdTd2lITW5OMUlNVU80VnY5OXJtc1llT1JwYTdlMTBUS0FQa0I1M2ZGdWNaVDE1VWkxd25vQm5ER1VnNXpNY0VqWENmc3JLMUZCT1JCNHNWRkhLK04yU2JJaFRlUEFsOHUwdnRZN3ZIeFRtV2J4ODlwQWNKZmpnZFZ0WENyWCsxYnNhRUtOSktrUC80OU1VZ1pXdVgzZlNvWi9OSmhBUDB4U0JadWpEM1FDQlhBSzU2dE5tYWpNUXpPZVJKMkdZclEyZ05nVEcrbTRldTlJZ3d5VFk2K0k4YW9td2c1SzVVSC9ZVUE9PTo6Y5F2wnGBUXzSUfGkXRz1sQ==","77:elementor_6f3706d","approved"),
("3","","2025-10-29 16:56:48","1","R3FVbURmT0tIM3cwdG1oMFNLR3VvT2FUVXlnOTh1Y3FHNWJTRDFoZDc1UTZFUzFTa2xxcUYvSWduZkNlamFzdzNiUnhFbXVkMkxsOENvSWRtRXNKZDhQS2dJUjhMcHF1QnJUSmF4OHlvaWhzWUxDMjFOWU9MY3ZDUmNhV2ZKZG0zUkxxYURiN2JzY3hGckNCOURmc3JGNUM1YW5oTXdNZ3dLYmtMV0F6MTdWK21KRGVvT0NPd2FhbkUxRG5XT1dSbFZlSDBEbFBhdmhPRUo1RTlpZ21CVCtHTjdZU2hiRVRHaExsYTNKSnEySlRRUWF1U2hzNWl5QUx5c3FFYXpJdUNNTnRybmdiRDZmU1F1OVNIT0JWM1VRdDJTdzNEZkpRdytxNDg3ME1jZjRoQ3RSRDF2Q3BxVU8zUWM0ZDIwU0NwTHo4UUU1Wk1Od1g2TUw0dmF6TFFnOTVHM1cyVWd2R1hJbGRrTzZ2QU9WZ2M4ZHZ3OTlxYTZkMHJKNWhaZE01RGNJbXhaSG1ZckptOWJ4OWJsMjZsaVQ3b29YN25LVmE0ek9DbDlCckxtUVNtSTNJVkdxK2hQc0xZTC9lYmRpeXFzeURJNndVTFhqd0tUQ2FwODhONGVOZ1MyT082WDBpZHBnT041eTBJQUZSNHR3T0RTRlZEMEhwUUxkcXhjZ2daUzI4NFgzSXZ3TlE0ZmJFVkpWaWZhWkxlMnJablFhTTJET3MwNmRtdDhaUmZHVUYvT01YSnFUY3Y0OVdMYmVHZCtHZ3NjbUxaR2RoSUxQQjd3dWZacThzbndPRks1MmxBS0dMOGs5RVlVWT06OhBmqSU51fhsTi+y1EM+8lY=","77:elementor_06e4d3b","approved"),
("4","","2025-10-29 16:57:07","1","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","77:elementor_6f3706d","approved"),
("5","","2025-10-29 16:59:18","1","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","77:elementor_6f3706d","approved"),
("6","","2025-10-29 17:00:50","1","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","77:elementor_6f3706d","approved"),
("7","","2025-10-29 17:02:31","1","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","77:elementor_6f3706d","approved"),
("8","","2025-10-29 17:03:08","1","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","77:elementor_6f3706d","approved"),
("9","","2025-10-29 17:04:42","1","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","77:elementor_6f3706d","approved"),
("10","","2025-10-29 17:07:31","1","dTFLN1pKdWlSbzhlVngySW9oZDdaOVJNa05wZ0Zzd3FtVkxWUmhsTzBpU2hHaUJMK1dCcTNHQmNua2NKUXJhMlh1ano3WTcxVnhHR0plSVZabHBONWZrZUZCM2QwMnM3WTBWUkNXUzIzLy8rSFpOVEFzRitteEpHT1VmdEwzdWFFSXVXQ0RsclZEZ0JWOEg5NC9XK05VNDh0OXl3bEFJTzB1clo5VzI0MjVvQWpaV2RNVnpzYll2aVJQSG9vQlZKdWgxVlhjeHRvMXJxVkVNYmVrS0IyejQwMkR5L3IyaitzbURtRUV4T1YySXM5WkhiSnMrZFIvdHhGT1l5NXNwVzcyUWg3dFRydHNUR0ZuVUpwYVVLbytrTEFTR0c3YjJNa2hwaFVVa3ViWncrZkhSK1FXM2YzcXIwU2p5Z2hnWWtyaVk4bTM3QXZQZ1JwZTVDVVVkV0JVNVVBa0pnTW81ZW1hdURDYityS1dZMEI0N2w4RTBVQjExU1FnRCtqZzh1ZlJzQkEyV1UrdjI1c25ieTFGZXl4YWw0REwzenZzQ21zSjIwUUc2NThvSHNseXNlZWxJaFZsbEp1Q1VpZE9zQUdtY1pUN0QxQzkwaXczUVBBN3pkQXhaWTAvOUxmbWMvYlJSMGgrMktLUjVtYVFRRVhKN1prdjZQSDZKUEQ1SmFJVnErVWI3QXZORXVDRTBLTXBrYXFkek0zWDNoTXFpdUdjck1aeG9FOWNrTzV6dWtBMFYwTkUwNU1uQUppMm11c3ZNYTV2VE1xYW5CUit0b3ExYlAyS1BDaFhFdDJBeUVuNnVLdHYxMWp3VVJselBqbW14U0FReXJSRWNqOWp2cC9EWE9NUHJxN3dqdkt0emhLUVIraDVVUWFhaVhXVlZzUUZTbmRpcVR0Y2V5NnBXSHBDWmpsL1kxZks0eXRWUWR6TmxJWlZSNmZYaTBweTZvLzF2SWNpSGxhUXBzd1lUQUlYcXNlZHRWeUFGNEhqRjM5anNMOFRHTDA5YkI1OGNLYkttVWtZdnloWlFYS3RPb2cxL2pMdURRa3krUkxHcVQxZDdSbHl2Q2FRdTZaUGZkOWd2Nko1Ky81NThCOXVqYTNlR2t2UG9UTEQyVVovZWlWZnhUU245OSt4ek9FdTdXVkcvRzdaNXBLWDFUSUVTb3d0L3pubEdPU3ZvMW9pZ0M2QlJtY3ZkdXBpNXorKy9TMlRLQS9wZ1kxb1pYWmNnZklNdDBTdWpZeE1pNEtDdlE1WGFyWHIybWkzY2JCbXRvQVpBbHluNDd1bzM4RXBPdjF0Y1RRdGRmSGJxaEV2TEpJTEpOT3IwdW1DVkw2MTNRTjAyYnhGVFR6V2djVjFIR2Z0TVpycGFoanpLalp0SVNmd1BXUXU3THArbXBHQUorcGdYK0U0R0NhRjZaS3JSMUhnZTcrdWVaU09TOVRsQkg2T1Vkd1l0elVkcWVwQlR3blhrNzY3ZUc1dXJHUWZkclNXOGZUTnpnQXBRL1ovT0dEN3VlNEs5ZDdGd01yMEFmV2JxSkpzRVB0aGRwdk83VXJIQTVneng0R0dudHphdXFpMG1PTVVyQ1dKMHZVekJVd0M0TDhsT0NIbUJRcExzdzJFUFBkRk40UmVhTHpNQThseGo4Z0N5VTZpdnFlTDI2bjRUYWZOa2pLWGxCNnlzQlZvUFppYlVRRTVNNzRYazBoMkhyd0ttb3Q3VUNUbnQ0MC9SZ0tFcTBaSndnK2FSZXpiT2ZJZC9obzZmTXF5eDhqZi8yaWlEZWZ4a3VkNncyWkp4ODNnbzZXUU51ZEhUYzg0dXl2OGw2M3RwU2dROUFXdUxHQk00YmI1cllVQ21FcVI4QzYxeU1pZUVsd3hGbUdsazl4OVFpdk5UUzBQVStRZzRrTkZ3TWhxVHVuVzdvYlU1eVljc2UwNE9XT0VKc1dmL3VaTUtMRjlJdjhWeUFPMmxTLzJVTFJjc0lGanZTNE16RlcweUh0YmlnTGtNRUxaZFA5U2p6OWpRQ2tEaUdScWFIbWhyQ1lucncrM0x3ckovZXgvcjdsODRDZCtrMWFtNkNrbE5uUkZTcEpoSFY1OGlRYXFNRkkyRjNYb215d0hZRytpOW85V1lZUE5kYXIzUm1UK0c3V09oYXdZbFZQU09oSUE9PTo6qjWFbcRMiUYuiBHjCQIIxg==","77:elementor_6f3706d","approved"),
("11","","2025-10-29 17:11:00","1","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","77:elementor_6f3706d","approved"),
("12","(no name)","2025-10-29 17:13:28","1","aE9tNlczUWZPYjlaVDRsOUZKMVhhTFJGbkVLQUNRNGRhd2RvWFlDWUovV3hLaDZVRy8zVDJmS0ZIQ0cvZDlhUTQ1WWtacUtjZ0txdFUzWEU4NEkrL1gvOFcwaVZ6cERWSWZPc1dCYW5PRUNmTEJFRkR1VlNjQTlLVEx6MEpnNGhkeXlaZm12Yk9JRE9qdXhWT0d4V280czAvQitRMWE0Z1RWbjVJZzFpM3QxaE9nSU9zWVhkazVYcGw0SmlTNlg0WDNXcGlvb2pTdDhtbGo0Z2VCWkl3dz09OjrzInFO+uWWY16+v65taOTu","77:elementor_06e4d3b","approved"),
("13","","2025-10-29 17:13:49","1","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","77:elementor_6f3706d","approved"),
("14","","2025-10-29 17:15:59","1","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","77:elementor_6f3706d","approved"),
("15","","2025-10-29 17:17:25","1","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","77:elementor_6f3706d","approved"),
("16","","2025-10-29 17:18:38","1","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","77:elementor_6f3706d","approved"),
("17","","2025-10-29 17:27:58","1","MERSdmxwdjVlK1cyRkozdHRQd3RTckZNRllpdkdaS0N5YU03eXdtVVdDWnZlMURhUnFVTWN5cUdoMDJ5TkxYUCtHazJFdmg1YTYyMWErVWxyN0d0N1JhUVlUSlBBaDdKQW1jUE1VQlRhU2YrQm5XWVdzaTZNN0x4VnJ6bnhQeFJrVjE2YW1jYU90cEJWNTFvOTh4QWRiWEd2elJ5NWl5NDczMGh6aGlSNFQ5Q21YVHFXU3IrY3dWejI1Vms4dHZ3NXF5dXRTc09mbHdjNTNROC9TTkNWQ1pqTHdjN2tkOGJOQ01vVndFWVZzZWlJNEVDdVF3aEZkNHV1M3pvc1EwNkpGdThMOHIwOWcwZ0piUWRmV2JBc2R6OTBXMVpCU3Vka3I5djNLcWtwVkN4U2ZmMnIyMTlhRndMZWtFL1g1V1hxOGhKYjdPRVlsdWM3dGZYK2lDS3l1UzFmSXFZT2ZvVGJOdldWMWtkRkxySHdBa2ExMXZLWnZzcE1mQU9lZW16eEdPTndDeWtZN1FCZnZRM3JnZUhpNFJTbXhVb2V3M0o4TDlwZk5KcEc1VG9DQ3BicVNJUUdLeStrbi8rcFJocGFuVkFjVHA3c2JzYjN5b3BGakxtVHRaTXo4MVViVi9IOTZkVlBMMmR0a2hndUwrOTdJcU91UHVCSnFnaFBXUDJBd200dUNvWkthZGJiTUZ1SGdWQXNMdXNjd2pNNzdnamlCaVNPUms1S3pFVVN1N0tPQU1sMVNmWW5mcUxSKy9lWWJtRUlUbFNLZmpVeWwzckdoa011MmVNVE11aEhLeXJHZ3UzTnJaZU1tOXNzUlNleTFDU1FpSU43Qm1LQndzeWVycEZJUXdBeURTOVZscEp1YmczZU9ORWJ6SEkxU2tWd20vUnhQamVZVW5KVzNDaDlyVEp1Q2hOTGwwL2ZQbkk4cE5Kckw5d1k5dm9zSkhWaWtsRnRpcVFKd01SMHoxNm13OWR6SWd6OTFmS0cvd0E0bmpiQnhlS0ZnOEtCS2gzTWZscFBabWNJY0E2Z2tnaDBmM0tYTkRFTU1zUWdLRlp0d3B5elRvSCtQMjY2aGpGM0FoRUpYVlZKd1F1N3p2WTgwMmxlVVBtcW1HZ2wwbTNjWUJ2TXN1SGliOStleHFUL1NVeTYrSjU4ZldhemtJSGJWYm93K0VyK2FtRW5qOE5sanArZzhGNS9sYUp2dWd6MTdzOUVTNktPNFc1Vi8rcm9ld2JxUXZqTFdRRzFuS0l1bldUSEZWSjFISkpwMURWTlY1Y013cUVWNVBUM2c5R2lnR2d5elJnRjhBNkJDZ2RGS0RXWllJTktlQWsrRFJaMnV5SkZLNTR2Z1lHc3I4dXorN0I0allKVjJQclVPMFFLaVpkUVVnZFp2QmNLbnlweFJrcHBhcGIwR3ZNQTdRZCtXWWM0V0xPNEVlQUo0dGIrTjErZHh0SkY0cnZld2E4UUVrQlZuczk4NXZRZVlWb2ZLYmJqSjB4WUxMWGtUaVBQc0c3cXo1QzJZNFFPYjU2UFFzcGMyV1pRUWhrMkVuVjN2VFlUTjNrUjZJWWxrbVFYeUlKa3ZMY04weEYrZDZRVDN4bHNxeGh2alluSTNRT3VUeEJZTFE2UWRnTFRZMVN4NXNmVnAxRUhhYkJBZmVBTUZmZXdBVTJvWHpEUkxrZ2k0dVFDZExpaVE1czZiNmo5RS9PY05zRXZkV3FpZmJZUjF5cmUrdGliS3hGKzZEd25wWmtLaFgxZVhOdkV0RERhRkZ5enpXb1QzUEVrVmIzc3NhSkRHMm9LanVqek8zdk9XVzhVUFQrZnJudEtnYjFmSWk0QWZxZUtSMzFSTDRMTnBhTC9TSng1VHM2QVhRSkpVRS9kamNOZEs1YXhwU0V3aWZhT1E9PTo65wzYnisO6XD1Bxf84tqP6A==","77:elementor_6f3706d","approved"),
("18","","2025-10-29 17:28:53","1","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","77:elementor_6f3706d","approved"),
("19","","2025-10-30 10:50:23","1","MmhKMEIxdjFaRjFFbGxFZmF6VGlYaURtb1duUTRQRDdlVnQ2RW1ZcWpsSGNxMkxWZ0U3WTVKMFFzSDhrYy95TzkyaXhuVmVVK3ZtYUdKcHNIY1IxeCtBRi9hTkpqL2J2NlkrV1JNbERoaFEzTHFlRllBaGVqUmY5TVN2RTJ4eFZuQ0hTUnFVSWlGR3l6QnFGc1BDbUtzQVJYVFRPalpWT1lhVm82elVaOUJyRzIvNHZ0SlBDdFRkUUs2RXhuVCsrOHJ3R0RHOWtjbGsvaHlObjdjSEs1VTkzK2NiK2JsaHoyMDRkL0lqa25NU280dmtjN0Y0YXZrSHM5WGZoM1daaGlMNCtGdWU3UjBnSmcvdG4xM1RlbEtLaFBxU01hUElrdFkvMkNDYkUzWlc5M21rSkc2VU1TNEIydEhvbEZySDZ1U3ZvdWVnQ0VoWHNjc2pZM0VOV25mbGlVeU1Ua2F0N3ljRmlDcGovdXBoVUxpUENVMGx3Ky9ITnVoTDhMN2FxQXBramU5Z3ppYm94Vmp6ZEsybmR1QlNrOGR1NlVTQzAreGcySitwbjN3YU1qZDRaUEtPRmdVTVZId2hZbE1kdkdTNFFaV2phSlQxWUM2VnNDeHNPbmxDWnYzOE4weGM4QjVpK2ErSWhUZXVZKzRKZnljdWVWNklwRjltektTWmNXUThjcVk0K1Z2LzRMWkZPUlBKODhBWDhFcWpDZnpVODBzNGhabHYvbFBpTE1JVVp4WEh4SVQ2cXBJalh2OXgyMi9nZmQ4cjBoR1Q5OXRyYkZ0SDZpY1U3dHc0RERmUnNwb3Joa1E4U1lwOFJqNmNRSjBSWkZnZHc3SnQ5UGRjUFpSY1QvZXI2TnN3ajA2djl0V0hjd3hNdWtqUXE4eEhPVXpLSS8yYVFFMlg5bnYvNWUvSm5iS0lkSDhIVjhtZ01YSTdQL3p6REFIaldjMEgxN25IVkhIbVo2c1FVZzRVOXpDekMwbmJrWHJsWnBaNWRBTXM5bHBKNWFGOWpZbVZQRGx1cWRBMGVsWUJqR2RnMEplMGI1WWJSbjM5MHRuUzJ1MnlpSWRFL0V3MzVYTXZua0UvazNsZDdUaHYrNVVQbVRqRkN2U2wzMzR1OVdVWEtyRnVpN0pmNGpDcVVIMEpqcnVkMnF4V1ZVVDBwM21pS3dvcGNlNFU2S09wdW82SEEzRUtlYnArbHVKSkgwTnJFNk5kL2V3T1A5WmdoL0dML1RYUjVyWnhxa0psb0h2TG1JdUhaRUx0UEZQK2piZE1RVFVEekhZdXZmUnhod2IvYUJiYzZaOU90MnVjN0plb3dNL0p0d2dBcE0zVGUwTGsxZWRDZVhpTmtqcG5PK3o0Q2tLdGtMRkRpMXZJakZza05zcnJBYllnUWlLbG1GRnZkNEJLYTZUQW1ZKzV5dkV5RGpyR1BwZk9Fdmwwclh4aHYrV2RscU9la0hoWFpWbDMzTXVHdEpkQVBiQXZjUFNlL1g2WHptSnJmUjlMOUh3SXk5aEhCSDNsU1lPZmFRNTA0QlRpcnRLM0EwVUkrZ3NiQ3Y0VkVabVd6aDVtd0cvWjluSGFXaWp1eXo0b0lnWlNWVmFUVlNJTktqUFpKU2Fac000c3lNSElaYzN1K2hVWHBNYTF1WEF3WTFVTVJ4eVp4RUdKOFpjb0tLL1JpdkU0V2l1Y1YvUXpnNjVya3pKOUJvV3VGUHVmRFpOeXVreHY1VVR0djZELzNOYnJ2NU1ndmVpRUxYcmxOdGE1S2Z5alhxUlFSTGtWeFp0SmFrVlVmQytOME5zKzBaVTVhNlM0OUVmYmZNUlZKLzFpcU9Ud1MzVDVSR3hPeTVIZ3M3Ly9JRkxlRXJ2Z1AwOFc3SHhWSUdPK1p2aFNkRS8ySWNuSW1aQ3ZFR2c9PTo6NeAlfLj2B05hpkfp4XwdrQ==","77:elementor_6f3706d","approved"),
("20","","2025-10-30 14:03:07","1","bnlISldQWEdkSmUyWGF5R3doaUxNRWkxZ3I0T2xQV0Jrb21FbFdNZnJIU2hNM3dEWVNqdFNSUGFDRk54UkxQOXpFWE15d3hVNGkyVTBoM0FDR09NTVA2UXlURVpSMmRWbnJ3WEQxWGJybS83R0l2alJiWVVXcEtld29KQ1k4VDZlNkVhb0I3cEdBVm1PbDVqUXBCb3FQbUJSOGlBSGwxMCtBK1JrWXpIOEZoaTUvWUw3TWJ0KzRiWUhKZzlPTmd3ZVB2UmZlVEpuVnFvV3cwR0xyQ3hVV0w4SzJGckJ5S0xtVDZld0c0eGVld3RhOFZSWGZtdEVPT2k5TERUV09vREJNZ1JBUTFRRmNJN1MxaHZRQ1cyelAyZU80NlVPZy9rSGhpdDBKcmJqaVovd1lJS28yNFBLeXR5Z1NCOG5DT2sySmFiN0h3NzlLNWNYNDVydUFScG1JMnAySUhJeVpUV0ovN1F0MlF4SGNGZHpvTEQvUmRnS29VS2E0aER0amNwL0szdEdKY2JnWUdkZVNab3M5U0VpSnhicW1DWDhhaXVjQlFqSG5CeXVJQnVYRmFoUzNwaFFQc1dWRkhEUTJvYW9xU2ZIY1puM205V2t3RjF4b1UrejhQMkkwbDFSVzB4WGJybXkvWkJhckVCUjYvNEhyaDdmdEZNYnM1UHFNSHoxd1U2Y29JSHlrRzlYeXlCMkxPTFFIeDNHNW16NW15amlGSk5oTHNoTWtTTXptZ25NOWJtemc3eTZCLzhmcjl5cE43Y1dnQmNhSStEZ1JKOHdzOTk3MnRxWk9RLytwVlhEV2h2a1BaSVp0dVhrdG9vZmFpUlRuaWkwTkk4endHMWQ4NzZ1L2YzYmJpT1FBM1YyZmJCVWF6WFdwN0RaUzQ3U2tha3RJRUc1K0hJRlZmMXF0N0lRSHNKb2ZKcUJISEtlVk5wWURVa1U2cWFaWllDelIzWGJ4S0hsNURMKzVUdC9WN1NMdWF2eXQwL1ArQVEzVkN1d1pPaXd2dWhZZ0h0THNrNzNlSU9GUGh3bUpYSzVCTk9QelQ3VVlWTStvNWJCWnRHaWZlS1ZFbmdqeXJhVUhLYWk1SU9XQVlUQWVZOEI4ZTQxWFVEMkxJRGszS1lwN0NvNzBrOGhMM0ZweEpjQ1dJV3I1NXVxS3AzNDRwSGFTMzVHeU90TmJJbzdvd0ZhbW13cyttNC8ra3ArSDFMK0ovcmVqRlVRa2xJdGlnU29Cd0tzSGV5RVp0RzZJcDFqNHVXR1FXSFR0RXlIOTg5OU5jTGY4M1ZNdnpmNExuL0h2cUdzeVI4L2NxNTgxV1ArYUxQb2QwQ0RFcmpmTURLRkRlcUZEaEkxd0FBNWdjdmUzQ3VZQVJZeUlGa3BURHUxdVVFK2dCRnk1Vi80aEJ6bzduRW50RGI4UzBlZEsxdXRpVk5qdHU0U2xNcDNUZDNmTmVqN0t4ZlhRRmlKVGduT0psSUlyb0lXWWJuUkJZaXI2TzY4ZUdLejJXdTc4RHpmNnllc2RGaHhvL0g5NUM0b0sxd2hFZitiU2ZycndzNk5HV0xuSTl1UWlwSU9GTHJ0QVJ1SjRoM21la2xuSWtFMDFPVFM5RWtoVnNhSWFpTWY3amUrYWt2TEJ3Tk9jajErd0dUV0FhNStZaExybFVHS1V2dXc5dmh3U1A4ODRXbHRxTFV3NGhqVVdCdVp1aTYrSUVWc25VSDZpaHFrTC9ocjFuYk00ZndGM1MweFNFeHlPL3liS0pmWUlZUm9aTlpCdWZieGVtVktycENpakowQ0Q1Nm5ReHh5THdnVlY0VkMrb0FzVitqS0J1Y3hscnM5RVBhT3IrcGd2T1JHMnFoVFcvaWtwSndOMytwczhmelcwNndVd0E4TzVUM2w2eW94bS95c2c9PTo6cZag/sDyKyr1s5WVRmO7FA==","77:elementor_6f3706d","approved"),
("21","","2025-10-30 15:59:45","1","TDFleURyekRaMDhUSlliczNiTkRlSkpaZDFwc05PeGpycTllWERYdTZpcWFnUEJmTXlEL3MwU0l0RGVCamFiUUVhMzNJQjJET01uMSt6M0dlSkhYdFhLTUVtR29pWVViM2NRMExBYnY3RFBHamdXc2RkNmd5UkVZbXhwL0tRVGFHVmdpcUJtVXd1bHBJRHFIcmtHb1Jac3AyaDZaeXhyYUZTZVArWE9PMVUyNEpYVm5UYk9DTllZU0krZWlTZlFRbHRweW50aHJDaGZKMXBHUEYzQ21xRmlZNk1ENzlPSGVhbkJuNW81RlRZRkh1d0t3bVF3Vi9BMjdiZFNrN0FyNEROeTg5VlpaZmtDVXJkODA4VVZIakNWNzczMVk2b3ZGK2tkcm1JSnFLNTZDbVd3SWJtV3RzTzU1TTZlMzRnVyt6aHhBV3MzRXNCUFZkdEl0czZMbEFxMnFaTHdURDRDRVJ0SUNsbHltbHJOTnJ2NUMyWmIyOUJsMG52bXBUWC9uMlZSTnBXSEdPSTJnTXFpdVp0a0JId3FXTHduanliVTI1MGxUMmVWU2t5SHFYZ3BXY1RmUml6NkhUZHRkTHFRMEZOUUFzM2JtdldqMHkzQlVndDB6V09CYm1BajF2QzZTK1IxV3pRSEdLQXA0cG0vZVdPS2RvOUpOVW9WVCtQdlI5QUtDS3VFSGR6dHUrMHkvWEhwTDZhTUZTVGQrby94dEtyNURLRWtRNm02NEtRTTBJeERtWm5qNFdzcXlmV1djWUVFTms4N211OXJYQ3BnVGlqR200WE1CTmxKT2JqWTM0cHA1S3B0bE1VWnQxS1ZjejNleFczZ1NqSWxUK2JZRjZWWnFPYnI1Zkpyam1LbnlEQ3lQZ2hOY0x0YXovT01sdlFRaGJ1bGIrOEg4bWxPNGt1S2Q2L3hSTVZkNHoxZUN6NjBZcVdIQkJwTkJkR3E2RG1VekY2dTB6aEpKOVhMZndHZEMxNmJudTVMeTBkOEtsS1ZwRlplSXZYZjhTdmZMeEh4RUJuR1NQM1NLNVArRG5EMUQ3dG9VNnVaMDlMT0J0V2Uyd29NM2dKbzlaZVluOEZUekJlR2FIa0VsN3JCdTBCMEw4NEw4bURqVnhtbzR5REU1c1dZQWlMa1MzSGtxekphWENGNmxOTE5ybXlSVUlmckpWeXB3QitneFgzelpqWkRsVEE4bTQzUEI0Z0d6OHljU2F6bEpQZzNhWmJrSkRXbnRiUzd1TmRPTysybzBOUmJBVlo4RjZIemR4RFNJRUtoaldZZENHcDJ0V1B3aE40Nzh3SzJKZi9vNlRDZnFCcFBzdFllL2JnQXRoUXBnWUxDYzFlZWkwVXFNNmpCU3RKVGc5M29NNG9YcWRmRXl1QTk1eVQ3RXBwR2diMVl5bksxNFNWMUVyK01sSE1wSGVjOGdubTB0Z0lZNThRbUJ2S0pQdjc0aWVOY0xmaEZlR2hJTVROQUsrSHF3dGNEUDNNSXZCUG5WSndLeStCRXZ5L09SazdSYi9DclZsZmlyZFhJS2tFdWlpVldOUy9KVkJ3L3NNeDg3T1c0SGdBR29ITHVML1JFM1lQQjdQMER6TFkwQmVzbXVRRHJQNmlzZzo6whrpbACkKse7HAt1fxkzXg==","77:elementor_a175413","approved"),
("22","","2025-10-30 16:27:13","1","SXhMejhCUldoSDV3ZFJxdUFYWkRNYnpINGpwNlRScCtBblUyR2dnMlRMckRhOWdrVGNOaVo2T1RoU2hNMnZtZm1YZjFHTDFzUm1VcHNSR1MxbkdYV09xVHY2NjVEck0wdkR5OVFzYUV6U1lsRGE1MWN2d3RuTnhQQUFMZ1haMWliYjVpcnBhVm40T3VzRUxnQUFyQko0cXNBRnBiR0ZyMENubDZJU1JuYitVNTU0cjAyUXd6UzFGcklmdTUzZ2hnNEZFMUxEVUVLdGhEN0I5bm02YzBWaTh1RHZ2M3pKdHdqSUVYRHo5QmN0UEkvd0RGTnBIdnBrOFZLSzcvK3hidmM0YTZFb2NBazFpc3dOeDQxM1VKVkdxeFVKVklDMVd6RGpielVYb3FiNUNYRUFvcDVYTlpmb09lTDRsNUx3ZmQ1ei9ycUo3RGdBblhwbW91dmdZRzYvR29HNTBzRXF0VFVtU0M5Rk1vMnQ4QzdoMDV5M015ZStzMHphUDAvakhxODV1ZFBUaXpidlhYY2E2Z1V1UlM3Vkhnbm00YklBdHBuanNRU1gwVThXM29lNktVaVR0dzYyMkxzSGdhM1VZajFwcGlBTWdrZ0RVSjlyTlJnQUcvSkhlbUI5cVlvaXhJOEhEQUlFTWxWVzRUUlVnVE5nWTJLVDVSK1l2dEFJNVlJS2s0eXhCaWNlbDJid2NFZENPY3I0VTZOS3hjQmdQakpnWUhIV3dMWnhkV3JOdWZlWUFWTFB3LzZUazZZc2lVeFJLUS84SlNKWmc1My8yTlF3T2VLbGtBVStRREtLNVNuQyt5WURPV2pYTm8rdmdxVnN2UEhheWovR1MyTmxjTmVOWTMrVWdBK0JmSXR6WEVaTFZ6TW9jc3BOR2NMMnVvTlFCVEFoM1E0MHZuVklVdDFZaWcwR2s3M3VkVXNjazFOWUtGcWx4MEIrV0ZwSTFnT0FadkN1UzZRT2JIQ0xQL0IrZHF6dnRyRllGcWRISmZ5aWlUeWM2K2xOT0Evd2V6bVg1Z1g5VXdSdWU2YkRqc2pJU3hNZHFBdUxZMWNLd2ZMUnlZVjhFNG5iQ05HM2NPL0lUbzdHQzhocHB1TUdiWnF0MVBFRElkM1Bmc3BZa2g2SWhLQlNLQ0NiYXFFNklFZ0ZYWWRwaFB1b2NLYmF1WlN4ZzVQSnh3MWFMTktob0Y4c0pickdlRUdWUFJ0L0tvOXRnL2toZ3VlVXA4am9nYk8waXlYM3luSkZnc0dkQVd4L1FYOEd1eUp2NE9KeWwzODZPcEgrT3JwcmpNTTlnclkzK3U5ZWY2YmZ0ZDVPUGJuUWd3YzhDRGJBZTd3cmRkZVo2SGNrbzdOVUZrMFBxZVB6MG5aUGNUUExqcks3WkVsMzZHVUx3OHY3RkYzZGx4ZmVCeEFXYTRmazNPLzgwbW0xNy9DK00vZEFQRGZValE5eVU4Z3A4N0NQNkFJTXBvc20xb0lGalFOUCtkT1pjMGV6cG5GdU05S1E5Mkxxdzk2NytGVU5RNEh1Q1hhN2pyaFJEcFRCQ3g4aGlkcURvWHFBT1cyNnBKaldrRE9vSmpYbmlVTnpUVlJjVTdoYjVXTGpaTno4K3FiMnZLSG9tL3JWY2kwM3lPTnNoSVNxY1g3LzVQbVdZTXY0V282MWRLdjRJUjdXZzlGTllybnFhLy93dTd0VDJ4ZFF6RFhvWjdETnRYcGdUc3d5Tnc3NnVzTU83YzRoT3pUZ0NLejhpL01YNzFTQ2gySHVkVVF0czlncGkranVjcjJaN0owN1hRMmxBbXo5VjBadjBkcjhNSjNmaFFmRmZRMjVQWlcvMVpjNktUSC9qTW81RXEvM05zNmlrR0RsRG9oWWMyMTc3TTFaeE10YzZpRlAxSlkvb1FrYzliRXc9PTo66IZvZ9/CJ8Uu0bAO2Fnhqg==","77:elementor_6f3706d","approved"),
("23","","2025-10-31 10:11:47","1","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","77:elementor_c0b47c4","approved"),
("24","","2025-10-31 10:12:10","1","UkdtNGt4bjRGMWF1dml3RUxuNEtpdDh4ZFYyWVZaRFJxMFZ0b05McEJhb1pnS2NlNHZFeGtEZ2czV2ZNS3VqVVkrRUZzVGZnQjBuQW1ZT0w2cDBRV3l6Z01JRUFpRHlVaFcvaWsyd0QzRFYwTTBxa05vRjhrKzRSeHlKd25sSTkzOVVUSVRqdVJVSHNma1NhVHdHajQvN3Uxdi9pQ2Vad1pyQ3p4aU0rWWFwZ2NTV01ybnJTKzRoZUlPNXRmK1NJV2JFYnF0Nk1sTE96eWJyTlJOOXFOblRkZTBzZzhpZmMrOWU5V0VZb28zY0hjTUNZeFlNNWh1YTNlZ2Fvei9Vb0xsMW43Q1ZYemdlOGEycUQ3MHZ1QzVkaS95N1piYTZRQ2psNFg2clYzQ0R0UFhLcXFxYkJIMm9QOUEzajV4TGRNdGRGY1drckVqd2FvM0tiUWYwTVhkYzkyNU1LQVN4dUp2cTZoS0RTWGdZWVBOSzVGcFp5enJxcGhCK1FqMDNQcWFNSHdDUXFKMEYyeG9BZXVxWVIrWGx1VWlEUGViWmFXb3g0TzAyc25YK2NveEpIcTBBdWZ6MlFaSjRFR0xNVmxNU3hNeVN5M0crUUI0YTIzdjMrUnNva0tHemYzZGVqTEhYbzJSZkZpemdQZ3VDT2lRYk1KWWh1U2pRcDg4WWNJM1dIZ3dzSVJTdmlFenhUM0pObGhTUEZCbU8rVXVnRjcweEhtZVRjSkx4QTVyOTFNTEloNkdIQXEvdzVHalNpOEVMSWVOT0J4WVRpVStPMXpZa1h5bVJTMzAzRGlCL2pGVlJCYXg1UW8vSUN2V29XU0hjcjhQOGpJZmNNSS9oM1hGM3JoRW05cDlPVnp1WmZBeHlNUm8wMG9RUGF2VUoraWxzTktQZVYwdUNuZWRaSXkvTFZTQkJzanM4c0xhc2lrdmtTUmdMZWJmUisrYVB3N215bkxnTzBHbURvOU9IVDQ3ZXg5Z3ZwYXZxWTZhMHJCZ1lqRy9DZy9Kbyt5NURrZlp3d1dRNE1yaklUZ3BvQStRaXFXUDNKdENQMzFuY2pyV3BwMmFxTUNyVk0waGNZZlg3TjZRbzB3dklyKzl2K0I3Rk1hTDFaQXlzQnliL0NNMWFUc0dIbDZxZE1oL3NyajhvMVdHcVJNRW1sQzlSSGNpTmZnck1KcndmTTRSUGJJVWFmSStNZDNSVUdsbnBtY3ExWjVQZnJySGFqWDVyNERTM1NXejVuQW5ZSzJMaXNsKzlxems3dGZzaVgzdWUzLzYxQlB2YXdnSkJtWGxobkhLbndJZGxKOTZvblpBREgvazRrSldueFl1aExUc010dUlsUzMwdDdZSjF5dmVjK3VTdHcvMFRkOEdLcWJZUEJJOEhKdENFT3lsK0EyU24yVHlXbExqUVBHeWdldXlsei9TK04rWkhuNzYyZDdPZFU4S1NubUxCejlIcC8wRHB6dTB5Zm5hRWR5by9kMENKOHo1M05OOVJWQ25rR1k0aUdjQWdIY2xmQWhWQWJFeHNqcVFlNEw1R1g3QWYxUytYU2dQcW1Cd0VGNjU2bDhhRS9vK0t5NjFDbWtxOUR2RUtGNXg3UUZyazQ0c2M4Q3dVaWVRLzVxcmR4V2x5VlF5WWxkYXBEWnIzemdYSkpoaDRvWmV6MTA3RUxPa2ZPNmFPQU5HVldxL1BrM1EvQnZQVG1aZHNhakJUQS9TV2xzZGVnVmYvbTlvVGFlbHgrQitabVo1UFlVMGxDaHZuVlNOSWJpRmd2Yy9IeFpoTjc3MkVqUWFZejlOOURLNjYxTGpyR1lsbW5DTDdYSEJydTg1eDFhZ1NLWkpDWm5vVUdURmFrWnM0by9QR05nM1VMbzR0WDVLT21nTnRJQjZoaktGeE5IaHhkKzZucVZTenZUaXNmcUF3eWs2alUxR3lhRlFad2xLbDN5d2NrMHFYdHVUOE55MWV1ZFpKUmpnQllTVEZLSW9hcDIzUUorUDVHRysyVVZaZjdqYStFRVc3VHpSTnVQMUJKdzhPK0V2dEhhcTlrNHhPWFBtalZEd2pmVkoxVHUzL3VVYzFKRU5CbXlMYTVUVUxFNTRIM3ptWHpGdUVnYkNlZWxOblBzS1lpWWo1aWFuK01XNDFvaXpleExZekQrdDFMbXl0Ny8yOXhlaFpvdkQ3bUFnSkdPSTErak9WS0NEV21BN0tlU0g0U0h6MnhHbzdIZ1pvWXB6bjFIQXMvclRxOTNLVXMrTWRqdUNmNml0QzlQN3AyL094SnFCNXJnaE9TRCsvc3pWdGNyNDAzeitzb2E5VE0vbmM5YzNKQUJkQ1M1MGE0emkxemI1UUx2ZXRGK0NlRUxrejQxb01Gcis5aFpuaEZiMkd6RjFZVmRML1ZTYVo3b1ZyZDVobE1IWlVGaUQzWE0wQVhNVVdkVGF6SGZmaGZjMCsxOUQ5djl3aDlDYWNqUmxxdFYyUld4NDdleCtlU2YxWi9RUmZrSy95RWJNYm1vb2pxNlFaemlkbGVBNFJaWkVBckhjUE1WV29EYWJBTWZaZGp2bktNck9yNWNBN29zd0s4K0E5YzhuYkttSnNwM25VSCtNMHBHbFZNRm4wK244NDYyNDlaMVYxK1pQVXlEUXF0N1pxOGliT3kra0R5RG9yakh6OURPSXBUNWozUTdWSzIxcFhGYW9KN3VWSVlxYzdxK2s3QjB2dDZGY0VMWnBPcnNhYkt6VFVZM01Xa0k4YnkyVHkyK2RlWlF5NE5yZFgwRDBhOUphYVZoUHU2dDJGWVByOVVxL2JvK2x0WVRLZ1dvdUQ4Y3FIK29CNG0vdWNsT295b1VNQ1BWdFZrZlJ3MU96YVVOWnJkRkdCVFlYbTdtNTZGV2QzeEx1R3lzc0JadFQ2Z1NqeENOamZjcnVjOXpVdzJHaFc3MkVibGQ0Zy9qYjV4bnNEYlNLM2gxSHRySFVjQjFoeWJwbExnbXRUWUhlWDdvRWFrTXpkTnpDTnpKWTk0NkpzM1BtTTR4SmJQTkYxTnV2bkNFQjdjNGhvZCtDenl5TUJnZTU0OHRXT2g1b0g2Rm1ZZ3E1ODRTQWRsdlpWSmRUekloMFFrQ0FmZHlUUGk2ZmE1YXhNVURKT2Y2RVlldzMwcmt0Y3gzN0swOWppeWdjUlprcTNoYUFiUDUreTBPMlRsTDIwdDJUZ2E0c3crQkhKelZ4MDhLOEpZdXkxVWRDYUY3RVlpYUdpMC9jcjFadE00aGlxUzVaSTFabm14b1JGeUJzZXFrOU9CSlVmY1p1UjRzNTFUSkd0Ukhsb2w5TGpyZGF0RU80MklNcElVYzBuRThRU2dzU0xtY1Aza0h0bDBRQzcvM2srWm9odzV1bkQ1STZTeWg1dEJ0RGxTL2Y1azBHNTZtSnE0aGJxa01FcnREUlFCVVJEVytERDVWeUFyNGVyazNtMG1CRHpib0tIM2dUdUYvRElObHpTYVk2bFZFaVhZWEtucUJEQnVLeUFGY2ZvZERzQXhQNXVNekhBaDRoOEFNUElTZmNuR1FFOElCN2Mwbk5sVE95Y25RY0tzTnVKaGFkKzhDRE4reDVEV3c3d21XTU4waVdIdS9qMFJPSTFDTHVTZERkR1psQ2dQVnBnLyszMElYMGxaR2hodExDZGQ5Rzk5ZSs5S0VhZDZpMjdtTnVESW1vbGwyTC9HQzlja0hkUG1BNEdZSkVsQVZpcW5tRktVVG5mbzBCb3lLdXNwcXY4cnRTZkJuMXZNS0toWEttZjNtV28zVWZ1azNISTdHTW5vSUpnUG4vd0xOTThONFRyL25DdVhDZGdHNzFTbTJ3dXJuOHpIeWdaWlJNVy9pcFhnVHZUbTJsSTY1SHk0MGc1N1owQXRJT0g2d2ZzUDBQazlxTUhkenNqaU9rRU1pbllvZmxUR0FpUWZtTDFHQUZ4cVluQmNxQnE2RndlenZlRDdxZFFrYURIMEVqNFk5WWVuako3NHhoblVyRTZRaDNzQ2hOT0xBWU80UjlKckNFNytYUDVQQTliMXFHUVJ1dk4xMnUrNWNBWVQvdjJuZDgzMlZKMEM2RXNBTUpGNWx5MEZFMnQ4SWRQTDg4Sk5TclBjSzQ2VzQ2VzRxMXVHSmpqTUtENnNKT2J4bkF1Y0dGdkMzUzg5VUF0Z3JhQzdlS3BKRldkZUpEdVB2a1lWV3FNK3RXYStzdi82K2Nhcm9GZFdZeDVyWVJYQXcvU1VkN0NYYjhsUVZRTWdJWWJFR0NhQVZDYlJHZEFBTkc1cHAwQUZqTlNnSG1SdXU0K2tMV0NkaGVacEFIOXBXbllvMVg1emRlZE5zZXRTT2RBc1Rid09QZkZPQUFKdk85aEFnVEFLekJXMWRaOXBSZm5wUTlZUTRBeFBndUw2eU9JcDVZM255SFU1MW5GR0tmMG45VUhlVHluRTZmYUcvTWRRbXIyVWVBTHZJMkhhbkdqV21RRUQ0Mks2M1p3OWxLNnFDTlp6QlQzdzNnL2h1NW1sWEduOEtpNHdDYlRrL3BPQS94dDI1YUExRDFwVHBqY1BZLzBhN0YzRVFMUUc5aVpNcDFpbC9HZWFRU3ExVzhxUlkwMGRuY08vTVpZbGxpRGRNT2xJdUppZ2NnZzV2Sm5MWEo5UkFuakpVSWxxU2pQSFcwZXdxRkFiNGkwQ2RiaDdOWSt6NFd4eVBJK1dsNU5wY2V1MVIrVkJ6dU02QnRseFUzbEFCdkljSEhGZmNBK1QvWUdQSVhqeVBiVzladFliM1VJUGlkL3RFYklrcDFkNHNienkxR3FralpiaWRxRHEyaE1YU2hFRXNaRHMwVWdoajE1RFFGenhXSjlxS1J1akFDbFpmazVTUmpNd2hjT2twc2UzYVBhTk9DZVk1cm9odTY0VUFzeGtUV203eERjcWtKLzZkcnpGMlh1blNDb1YvYU51bVZVMnNLT2ZLZGpzMlpsakV5LzV3d1l3Ym5wTzNRVnR0WTU0azZFY2x6alRiNnM9Ojp6hkQ19RYsnerQ3RZ2YEDb","77:elementor_c0b47c4","approved"),
("25","","2025-10-31 10:14:29","1","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","77:elementor_c0b47c4","approved"),
("26","","2025-10-31 11:05:00","1","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","531:elementor_9092108","approved"),
("27","ARC","2025-10-31 11:24:11","1","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","378:elementor_b9dc4a7","approved"),
("28","(no name)","2025-11-03 15:42:04","1","TjhQYkVVZStSQTBMVFFodjk2UXEyTXhORnhpR0w0UjU3RlhzcXhxUHRlcVJjMXFia3dMTU5WV3ZPMXB6UkE5aGxpNWJpTUw0MTY2TlhxWXFjZDlxeEFYejBGZElnQzZ2U01sQnprRWJCY0xGd3hZZDBUbGhKQ1dLaytZZ1ZoWWlSRFR3dXQxZXExcHBRT2dzaG9XdXFCQlNSNE1lVkg2TlZwamluaUhCRmVMc005bFo1MUtTZUFqalk0Rkdiem1kdElhRlVScnhPUDhEZnUrYWhaS255ZmFtbHp3MHg2NDdaMStlaEFVK2ZFcHRTdmVhQkdUMWxHR20zaVpsTHVtcjhnMGpmSUNzNExyR1JhY1VRVVREUytqMUkxRzg5SGZXbWJIUlNoYkRmWHRRVjdCakMzYmtyLzNOOUpOeTh6Znczd1dEbmhKNzhheGJvYjE2OElLUmZEUnk1VVRqUFhwZFQvZzIzL1drajVDUlZPSnEvM0hlQ3B3ZjNqVzZLMHh5UWJJUGlNT0tuMmgwNEdja2d0NE02R2ZnS25oVkFvdnp6SjdqSU9aOEsrZ1JDMzJhYXlqUHBKVHBIcHdsbUJZK3hzVktNTDhIbmo3eGlmZU9yZFRRVEJ5WGdpQkZJaW5JRm9hSmtvRWpEc2RCaHpDZ1Q3bTYzdCtoa0hVQmlibSszUXRzQ1haTnpCOGd2L3JFWEw1RWg3eWpZb1psR0w2ZWhkeWhHODB5OWhMUG1KQXNsVEhMcWpDWERyeG9lM1BCMmpVSTdoVjI5UURvc2FCSzlsY093VFJQOVBKRTRLdytySFBITmtRUi9MT1Vnek1DL1oxejlIeWdZTXMxbWNGYmdSRXlRYXBqV3pkTkRtd2hFV0M3SVE9PTo6ZEkKhH5E9hzABbqXMG1exA==","774:elementor_238c6e1","approved"),
("29","aa","2025-11-03 15:42:14","1","SUlOUTJvNm1HZDhpTVkwRDFhQkJya1pnekhDc3BRSmhXSVN1REl1MU1raXJpVVkwOEovQXV3Zjd4TXhBa0ZTZ0xJa2xsMGpoLzYxSS9zaHU0UGJ6NlpzNzBPeU55OUE1anhYaGwxRFlyM05LSVpvaG5vY24vWFN2TXRVem5KV2ZFaEEvZ1NvdTU2UDBmMU80THB3NUw3RndqNjhvWWYvdVF2OUswOEdzcEF6cktOTE5yS1ZIc0JpelhNQjZGb0VnVkdPTU54MUlDeEhZTDJjOGZjL3VTelliUSt3eDJFQkdkcUlBVVhnSk5qMHVIeThCUEtlK2dLYmNuKzFsaWpkdEV4eElrbkRmcFlOUmd0UDVyUXowZDEydmx2QkRzeUtSV3o2cXk5OXQrUFVSclY3MW5KS2E0WnZ4MlNYWGFtZ3VZOFl4R0I4bHpQbTVrUllRTlZVdldnVVZsUEFjWXg2ZDNLL0xLcG1qNXByakk5UDFlS0xRencvWk41U1pkODREdDhHMGpwemVOb2hQN2phVkE5Wml3QVd0eG5TcUpSYWE4YU9kUnkzVGRsOTVFb1BzSy95bi9wbzNiaUVrM0JVZlUrdWpESjQyMXdpUk02MjFIb2t2UXdvNGxTcHFYMmdXSHJVelhhVGhXL1A5SU05WDRQdW92c1JzSzhIaWFPS0pkdURmazNXYWVmR1Y4bWNvNnpUUXd3Vy95ZUdTYjJIM0ZDTHJnd0U4ZExMSmoxbERoOTlWcXNYc1ljL3d0cy9keFZPNXBESnRzRG1uMjVnNEU5OUFNUEN3NzVkR1NTYTgxeTQyOUxPdHUyTTFwOVJwcklPWjZjdkswSmJFck9hZEt5amxpajdjeTU2eTM1cExUSlQ3Vmc9PTo6vrWW8dc88X+BbdW+XdFA3A==","774:elementor_238c6e1","approved"),
("30","aa","2025-11-03 15:42:19","1","ak93MEtuSEVNb1VxcUZuYSs0UThocVFVM25zU1VxTlJsNG1VRGVEcFl4a2RkNHpsbFJNNVYxVVpseFhrWHJ1RmczSUlUYXhUODFmaHBiUE5BTlMzVlpIdEpHVlhibFY5elplQkZoODBCRGhNcWV3YytoOXQvazBVMWE4TUtRbm5aSStXeFVDamNQdjQxdXlsQ1lYczl1YUZXZmozMnFVS0s4S0wwdHZQK3N6YmVlbkpxMnFPUFVKNXo5aWwybU8xOUlDVmVMbG14RmRQNTVwTnRsakFkT3FyVVZFMVNIYm5yaVNOUlJSMkRwc3d1UHVPaSs4QWlVQ1Z1N29mRElFQWxLYW5BcU80WGU2UU5SUUFLYWNiZml6R3FyekYzYkthaFVVaFFTL3BwQTZvVG9TeFNTWlRLeXJya2ZDbS8yR0kxU3hIMUtaeGxybjlYR3pnL0tsUm10Ym02SzZjVmkwNDVWT1hCeFpVS2NNMXBEWGduMjZLMW9UU2lKNVdTQ3VlTnJndVdycW4rUmtEQmRMTFFOVzFnaGc5ODAzYnFLUGpiLzdTclJCTm5TaFRtRWZvaXBNU3pDZlgvY1pVZkUwMCtid3JjQ1VFZllWeXZIcEdVbzZvN1Q1MThSYTQxS09MOTlpMUpYUXAzbUFYMlVUWmxrV25wMlZseEhXWnVpQ2REanNoS2pWWCtQb09PdXErM3B6ZnBrZzI5Q3hqYnROY1V5TVRDQlo5ay9OQWhGSTNMcE15Q0RhK2htWEIzK1FQQ2hKWGFSV3I1MEx0cVpNdi9ucDZoWFNWYXIrc2NHUER3Z0w4SUlIRzZVVXRFOWR4SlF1Ujh3cWgxc3BkUkcxcWprSGJaVWhxdUZRbFhHWnpPajlpNlE9PTo6bYB2+w4eS5EU8MC3l+Wuww==","774:elementor_238c6e1","approved"),
("31","(no name)","2025-11-03 16:03:53","1","S2NJRS9OazFCTHluZ3EvMFZMb0Q0NFowWEdERzU2Z25HUkNLL1lwM2IxV1FxR0VpOEs0ZlRMSnM3VDhJRFg2Mjo6K1tDorPfBu5Bo0vMKtNdVQ==","774:elementor_e113d31","approved"),
("32","(no name)","2025-11-03 16:04:10","1","eFJwbHpETFhzYm0vZkRiUEYwemE3MEZnQVFLLzN1cEtGcFdvem9rczhLWVljUUpYZnhObGlFMHkzck5IVm95QTo6RswOdVqovbPAFdrKSk+Y5g==","774:elementor_e113d31","approved"),
("33","QUESTEL","2025-11-03 16:23:15","1","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","774:elementor_e113d31","approved"),
("34","QUESTEL","2025-11-03 16:29:26","1","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","774:elementor_e113d31","approved"),
("35","Gallay","2025-11-04 09:59:47","1","UFRIenl4b1BxRzYwWXBqQVJLMnpuNlpOalVOOTdnbzFuaC92bHNXUnB2a1JyU1dFODAvTk84Q00veXhOY0hHdEhsdjgyWWFzeXdiK3UvN2xjL2w2RENXY28zdkcxZ2tsbjNuQ29YVDBJRE5Dd1ZuaUcyeTNUeEF5NHI4Q1BFb1dQMy9DSWtMb09ycThQUTF1T2diVzg0c1o0WS9VWFQzOVduakZJN09aT041eWtsVmRxQ2x2SWxNc256U3cwMjFDNDlHNExCSy93LzVucm56cU8yV1RhSU90YjNqYUh2WDJPR0J4S1MvTlM0elB1emdSd1VyQzlJMXZVdThYb2EzWGdpRkhzTm1ZUWtFRnJ6c2xXbVJ1L3Iwb015bHJNRENaNHlLTmFjbkorTDJib3FDbTA0Y3lGVU9YaVZmZ1kxN25xdWtkcnQ1a3FYT3NnZStuTEp5RlM4Mnp1L253QWhWSXdOK0NBOTA1ajZIOCtpNlZLa3JrRDNNSXM3SHRNWkpSWWlySDhYSU95NG9YeHNGdk9KakN5ZW5CSjRseW9zL1gyNFhxYUZpdGwwQlNwMk9JekNYZXB3dDBjT0xEMzFCQm51Z3hTalBiQ3U1UFZibUFoNGNnSU92QklrVk83NWNONXRsRW9GMnlTaFRlQ3lWL2lZc1FwKzg0L1ZJY2p5dVoxNnUzTUhKTkQ5aUU3ZFFxZ09QRVZ4Qm9hWllhbGowK1hIb1NDQVN6ak5QMElsd09sY1VKZERtWllJMUIrUGc5WUhpbWx0c2JKMGo2V29SYVQvYmNGZzFMcjJLSVh1bjRDNVdPMjhVRUNkZz06OjSfRRbZFes2/6Vayok6GmE=","831:elementor_0012a07","approved"),
("36","Gallay","2025-11-04 10:01:21","1","bUU2R3MrWWlnNDI0R0dEMEJmVVNuQ2Q3ZDFrK2FlMDBVcjI4SkhYdU5wVlBJaEhPdWFJcTh0NlVZb0VwTjk0SGdxNTNwSHBBZDRGK1Rkb2RkV2ZsRTh2dGN6dzUyTXROSzhJVi8xYUxhamliOGkyMDg2KzNHZHVDQndOV0grVktMOHErNzlQbU0vZmpablBBeEZxQm1IazdZZm5Qdy9YeU5iVThDWHFZTmFGY1NvdkNXYnYzSVdiNEtiUmFtS0Zma3JMN0VqYlRmQ1hJSVFnQXBUc3JGWk1IR1NXWG41UlJnR2RGcGFkVncvNklacTVWU1hvQjNpS21yN0hKcWZqd3lwd1hKQUJVcVFQNlMrdmlaVUdCUElBS3haeE1CMTVXdlZ3RnJ4dFFnaEhJbGo5T2w0VGpPM0dhcmc3Qzg5RW1sVmNtSGo5WTI0anlaTjY4N1RrL2J4SjBYOXZUZURZNTNmTDNDVDM4NG9tTFk4WGdhNEV6bzFSWFlsTmc1bjRuUC9seDUrMHdlRFFXbnJ0RjZpT25iLzhqdmsrY3czd3kzbDdubVFOenZROCt2Vk40MExvVmFlTmt1czkyK29qRVBnWXFyR3U4SFJ0R3ZFcGJQTlVBblo1bGQwamsvektwdWdsam4vOVJoVEJqNVpnSjMrd1lwM3ZDUEdSVi8wR2x5aVdBVElwQktwTVZyVURuTU5NanM0RDRsbXlrcXpadEZ3M0ZNYWF2eDZ6QnBKdVdHZFRYdjE5V1BtdU5YUkhoUHVQN0JibUdtbHpNdUt3Z2NDNWNqbkJkME1oTVBraFNiSHRxUEZZdWp5TT06OmIf08hZwt220/7Ep6idzN0=","831:elementor_0012a07","approved"),
("37","Gallay","2025-11-04 10:05:01","1","K21HZzVIVGtjYUxvODhNaCtpMWdQaXQzUHNBZ2FONVNaVEtzdzJlRG1RdERWdFRpTWtrbHVqYkZPT3ovOHlYYkVLK0czS1J6WHpPVTU3amRKNmVnVktBc0JGSENvWjdpYVZ6TXJyVFRLeHYzckVKZU8rcTVYSnR0MUNDSEpNUElvQmVodm4vRUk0R0h6c21RM2tEM2M0OWNuYktDSVplYU9MRDlVRk5XZkhJbUJ4TVJLVlIvMWVwWXExb2RwY3JVa1gxQlNGVWJHdkVETXhXMXRRYzdGaDE5eUwvemdqNHhqZjczU2x0dk41enlFRnJMTjFTL2tKek1VVXRFdlpaa2tGTWtjUldmVWhsbkpwcEFnYWZsOEViNDdrQStra0FpSmlvbmFmaUtNeHpvdXNQdE1aSTRUSW9hWDJxREN4OWs2c0dpc3pNQ1dzcy80a0ZqVlhYZ3hnTHhmbWV2Q200NXFERE1FZ2VTQlVYUkdDQkVEZ1ptZ1VMeERnOVVJQ3h4LzhHZW9YL2RPUHRhTzNWSW9GSkxxbE5FT3prTFo3OW9FZlpiaDF2Vzc2SnBlV3NVS3lWSU5EaDZlaEF3RW5rN3JCZ2xHTUgzVVRJR2owREJDL2t1UmVpMk0wRWdZRVh5WkV1VzlCTGlYRk1pK0xnOHE3dTNRT3oyVDZLYzd2VDJKVndIN2FvazJCTWZJSXRwWVBKaVhrOG5UaTRFUVpodEp6WjZUNE5vcU84bEcrUnQ5QkJVOGxlUjhDeDdkNU5wSEh0ZHhqQmpMSFptNlNNSktXSG9XTlBYcTBRVHRrSEdrU3lzak9xR3RpND06Ok2xwAj54CJqikHbxu/neL4=","831:elementor_0012a07","approved"),
("38","Gallay","2025-11-04 10:10:27","1","b0RSQ3ZxaWl6a3NuYjVBaTU3ZFFMR00rNDNGNnp5dEZtYkFuU2xxUWhieHZxTUNpR1ZXaVVKS1NJaGhCRVVkNzdiUWc3a1hvdG9xbk1Kc0tCRVpqdVVMYS9TU2x3dVdKNlkwbFpHRExSc2lTQzNOc3YzNHhtUGUrV3c4ZWFJcHJrZWJ3aE51cHlWVDFRYzJjZ2wvYmh0N25zdzNCQTdLbHFzT3V6Q29QdVZ5NGdxaXVZVUlHZGpFZGVoRXcrUGloZ3FvVDYvckRPbFFGNnVuZk03NW9QMTVFaTBoVGhteUtNMFpZaXkzeWRUZzQ2NUR5UTRiNm82TTUvVHJsdE9Yb21CbDZOUGFvOUpCSmoreWlseGxWeCtTSkFkb2g2dkU1dDVoYjcvM2p4TmVWeGY0eVcwdityWDU2SjZ4YS9YN0NUVzRZMWhsd0FWYVI0SEpNZHpic1BxbkEySFpXcmVqVUFSRjl0SXBBNXQ2bE9iR1dxbWE5RWV3TkwzaWRVUWo5T0ZLTlpqQTZndkE5RFJZSWJlbHN3cVVmR2ZMWG9KQ1FseDZjYVhHUFpuK0VjZjNtUEtOWFBNSWNaQUV1M2lBWHRldFl2YVNYZXZhZHN6RExwYzA0ZnNwenFJeUFSNG9CMk9uZEVoY3NzZUlyVHI4SGJxT0JqOFNUQW0zcFpnZ1FOb2xjWFR1cm9oMGwxVnZ5Q3pqMzJ4TFdIT0RWa3o1clVPRlZLYm1raTFOSUlsaEpnYkUybTJMTTJWVGRmYXdkWmZmbU1tUi9rcTdlQ2JjOEV3Y3JLYWFZOS9vdmRMMENLZUdLajk0cDVSUT06Oi6Wvyv1qHXH60tdFKAW7JA=","831:elementor_0012a07","approved"),
("39","Gallay","2025-11-04 10:11:08","1","WDVoM21idzFyNjlUMXo3ZzNDd1pQWVp0NG92S2ZsZS9uYzE0cm5uL1RGR21iUVRabXZpeGdkbGhiS3VIMlRWYkZqUVZ1K0NkbzFjM2RJemFzU1ZkRW9COFE3OVY4cEEycklkOHhhSEl6SGdHNS9COGpHM2F1ZENKRnliRVc4bDVVVGRNakF6MDRiOFBGbmY0dlYzd3RFRjJNK1pGNU04R3ptVXRHRkhXcUFrSnhXSTNzS25PUFIzTkdnakpaWkdHcmJOY0x4K20vOHFNSmpNMXE3OUs0dFNSMjR1ck55bUMzcmtEbXRiaytOaWMzUlNzRUI1Vm93ZnVPalBMK0lqRUx5emhWejBzakZPUVRjdlFuWW91MDBIT2Z2RDIwVUFZamptWFAyZThiYTlKN0dhSVE4V1RIdmFWRGh2VTBiWDNCRktBTi9ldGkxUXdNL3hjcno4aEhPVWQ4bEZ1MVllRGp4a2FMSDkxWjNqdS8wdU5tRnpzVThnT0UzRFhQbTcySVZJYVlrNUgzVUxKaUM5MDdOamI4c2Rjb0E2YTF1dWUrWHhDT21UUkNIbWR6YkhBbjVZaHF4NzlWYXprZlM2eXRuUVllTzFlNE5vV00zVjdLc29VQUZmdlZoc0RuYkJkd1NZZUJsTGlWTy9IbnFwWlM4QnFVc1NBMXVObFlXV0UwcTJuS2xZZmhEUjVySGZSRFliRHA0U3VHSkk0ZUtqMWQ0RW5QR0p6TEg0MDFuNlc1MS91RWhNNW4rZGVHYkVBRjhZVnJrL1ZVVnFpaDJLdDA5VGw2TUV4eS9Sb1luTUVFNFh0YmVUQnNlbz06OsKnkVmNZ/DYfCo6ff2gP2E=","831:elementor_0012a07","approved"),
("40","Gallay","2025-11-04 10:11:31","1","UStyNFA5b3hXSjU4ZW5hL3lpQkNWUlFDNnNsM2p3TlpLcmc1QloxdDMzL0hrZ3luVEZnQ1AzallIRWl0VlpUUjVjd1VrNGpoYndRMmZ1NTdBUUlnV1dKUlVFZGduQmxWc05xWW9KRXc4STVmSFZHN0ZyUDA2UCtwZGgwdlJJK3VpWjY1dDVxbXMzVUh6eUE1TG5ZRmtNaVhwcmE2WC8xWXR6aU1RN0FGRFNScytnZFRBclhVRXl3TXhuYnZtK1o4ejB4ZjVrNDhTNkd0RjEweTk5U3FwNkhrQmQzekVVM1Q4T3VTVTlYZmJkUzJKUWpPNlJtWHhHR0ZxT3ZqMG92aEpGcFp0YmVpQWxWbnRMdnJNM0RmTzFZSGdTc3p5KzV0QUNTb3NjR28rdGIyMWN5S09La05jc2VyaUFCOUpranM4QUQxU1IyQTMvZjg5M05lMnM2QjdrcHlFZDZGTGNaZExMYjF0WmlBV21WR2FSTXhwRTUyR084cEJPTUFjMGVUY2hsTjhRajlQYUFQNzNrVHZocHNpTEphL1BCN0lXK0VLRmh0U2M2YXp0aWdhZ3RZbFo5MW13cWZ6b2hnYTVjU1Uvc21URlZySnRJR2FSQWZvMk1XdS8xYWR4dFk4c3hsVzRVN0RQSmM2Z3NScHdNZ1hSb1VCRWxzcG5WMWFLUGpINzROZXJDZjBRSEE1ZHNOTU1zbDA4Q1NUZlE2UnBVRms1ZU5SSTNMbjJVcFROZzA1aTdhMHRNQTdPWXprcUtSQzhhdExHVTNWd1NsTlBnVG9OSTNzNlh2a1pXMUs2RmtBT2FBczZEUDY1bz06Ou8sb/9synsfHtLA9NJ5Nd0=","831:elementor_0012a07","approved"),
("41","Gallay","2025-11-04 10:20:55","1","ZjR2b0R1a3F6RENmWW1IWnV1ekcwVm02ZEM1aW5qbHZ0Z1BlemFnS3BJTzR1Z2JPYjBaM2cyQW9yS1R6VStyVUpPUVV6aEw5dVc4ZndhU3AzMWFxTWhlOTZZRTNUNHVjc0h5TXRISHpndTU2djRFR2xWelJabU5QNE03aDFlcGdFYUFOa3BkTU1vdVNCcmdTVW1RMkFxaUhtU1ZNM0hRVU9oUWVqaWdWcExaOVdWTkNScVB2QTNCMExpTDhEWmtBcmRZbWZJcnVIZndSRVZvSmpRd1ZOM1drRTdnMG9BaktFeUNtQ3BwOG5CVDdmUTY0TVhLaDR0RUcvRWtWd3BVaytNaitJNXcwcnFUSG9RcFRMUk95QjZtWHR0QmpITXg3dG9hWDdxUW8yUlEyNnhjRGhyQXFxUy9zdWxHeHhEK3FSQnhzN2NHU1h6V3hWNmVCVlQvd0VIUHJ1clhUVDFDSElWSmVSTnF3TnZHeVc1ejNiWjRzeklUbkxPeGQweitiMzlxS2pHQk1lZ2NIZC9HSGZtd2ZDZnEzSjhuaEptSHBHMWdIUGNXZk9QN0UrN09RaytjcDJCQWpLSnhJUW54WUJxN0RTaXRSRXFuWENUZ2x2Sm9wUU9hYnlpSll1cnoxTCtqWTFLT0wxV1QrZHJnRFhva0dveWpwbTVBZWFnTkh2R2VqWmMyNmc1emNNd0J1cGRMaUpzalJxRlowejZUYWtPaDdKTkdMWVovSFRQWkpEMkpRYWVmVFdMVTVHOVd4RFZaeTg1Mk1IQW8rejVXaE9keHpVb0VLRnFzaHdlZW12TW1Pd3hiMjFXdz06OiGe6B+Lifm4Exr6B7nwq/Q=","831:elementor_0012a07","approved"),
("42","Gallay","2025-11-04 10:21:53","1","Mm00ZWRJTThMQi9kVkE0aFVETHVJQnR0YkNBVE5jSmdMTlFhVmxIK3ZPb0VNbTRxb1VtMVVITUFNL2xhcEpYT3p6Nyt6NmZpaFRMUkh4RUZndEFrZmZEWFRqcTR0dmV2ZGg3VFJrUGhtbzZxZ3M5Qll6U3BWMm1hTmJsM2VjaGxqNUIvMlhMTUE2aG1TeUxyaFRRR0k4VjZKWWFKWWFCbExXSDFwQmZSL0F1ZHNjdkIvSi92eDBKSnFZSjBzSEUrMS8vNEx3c01HMkVjeGdWZ2FmWmh4VWNpN3NWQkdvck1RdGZsZldKZW9QT1M5SnRxWkpVSVVUVVVuL0crcGk0ZGVUUURtaHVjSXNmT041OVFhSUJBMHJkbTVNOWpDREU1QndFbUdOejNkYm9XYkpiN3VCcC9tRmtPS1ZyZFkrM0pDc0h2bi93bFUyeUFKT2Q3QW9URkd3QlJoYmtTRUlZMmFET2ZMOHFIMEllN0ovLzkzN3JPbWFreWRyQ1NUeE9EQUJnSmZWc0hoSi9SVEhMVjBpTTRuajJVRDliNk9vb2pZTXRhalFVS2tRUG02cEt5VjJYUXhValZhb0NYRk1ibFdsLzJJUE5FdGhvcE85bnd5ODJjU3JLS28rZU4yUjl3bXFUOVN0R01FMnF5VWFPajdOeWlsbXZGVjdxQVlvY1c5OFk3QStPUnVud1dXeWt5Zkp6b1JMaHg5NW90V1NIanFXSDJXMHVWM2ZwcEp4VnFPS2liOEl6ZDlEa2FCUVZ3d05tODlZSFlhTDFJZHlXWXFrNE93b0pBVnNkRTBQNVZjdnI4cjNqR2MyZz06On44VwK4k2irz4MmY7yW8sE=","831:elementor_0012a07","approved"),
("43","Gallay","2025-11-04 10:30:16","1","cjZ2THRHM3htNDJKeFJtZmp5MnNVcFo3ZC9qREE0KzNVTDF6U3FCTFJRZzZSNkk0UXJlYkMvblRUdTdqQUFXUFpDMTZnV093SlBISTUxVnYwcFZ6eFVZa21nSURXeDVxOTlEa3h4eGJSMkJlbDQ0ZVJrOWk4a2VwU3BIU0VTVWswS3JkVHFpcjFwQmVqYm5YUy96MTRlbGZhUjI2TkJsTTJnZXNuYVRRTmtWLzRKckMrQ1VUMW9rZVh0ZDI5ZzI3ZnhxVHpiWEtUZWNLOWY1d2dvMDRmV0llbStReTBLRTh0UTRXdll3Mk5KRGVzdzUwZVkwekllb2N2WjlmZ0lvTWtlNzBHL240U2E0Yi8vMVJFWERESDRyS2FibG1aWENtKzRTS2pIMncvQ01reDJURm8wOUxrVWxOZER6QzJRSG9QclNSUXZseUdLeG1BREtEZ2Y2UWdFazZQRnMyc3U0eCt1WnhFeUc2YTZsRzBIREppRTRyS3lERkxoSmpsVnNlajVQZlBNS210UExqZ0xJaDFVM0ZaMXJNdVJ1Uis5K05OendNZVNlOGh0Z3FCVHFiODhLNVNFN2VMM0xHZVozUHRoNkpZMjNia0xLRnFrSS9vN0l6R0ZPamIwTTNFOTFwdFgzRFBXYkpFM3RRRW5EdmQ1M1RsdWdHOWRnSkpYOWxqS1I5bm02ZXdQRHA5b1ZnSnhvU0pJMHViazVoWmErRmo3MFhtWnQ2eTc2bHJndG1KMG9SWnFmOGRxM1lwaUhuSHRGRzA4STJKYUVPa2tUck5vZE4zbHZtbVh3NDFhVE9tUTlVcVJJU3B1dz06OodT1Z0KdGm2IYfyWlN6UFU=","831:elementor_0012a07","approved"),
("44","Gallay","2025-11-04 10:30:37","1","dzliNzhEV0FlQjU4cXhhL2U4MUJScHkxSzJiZVhvMGw0Ny90WW4zSUI3R3VNMEw3NXExS2ZjWjNSenVVQm1PRWQ4V0FrTXVhSjVLRk5LdW53cWVON1NWVG5kN3ptbkNQU2JvTTM5M0lCZlAyVVN3cHNmc09qWHdrQ1o2S09COENWMWdzV28zaW91Rm5BYjNuNFMyWmk5WmdpaXFVZUtqUWlLais3QmtQRzVoNjNHOGFqRXBVa2xGbGZCTHpNNGYxbkNOMURVSExpaEZlaXBsNS9pemtFK3Zmc2ZOdzdaaHpQQ3JtNU5LeGRJVlozemhJZFhPUW1hdjdGd1dmZDFMTHllT3E0SnRYaTk3WDBYOFByaEFBQjBOWW1WRnA1TDVJeGxBaFNrWVhwWnBLdXI5emloaTIxa1BRNTVuSzhERGM5MWp2b1BuY0xDLzJKVlJ1VmJMZ1lLa3YvYUlLMzZ3bjZtbHNOU0lucjhlT1p6Q0RwS0lYSkpQVS8xdW1peDY3RE5MTUNjNTgwYjFES3BiS0FBOG1yOXl2TWhkNXV4VlV0dmZXM0pIZHU5MENzZ0ZHU2RicnV6cThFQUdRZFI0NWFzc2dsUHhpTWNldk5WdDRGdTVPNGkyM29FQk5RSGhmVGZIaXI3bHF4WkhFeENXQ3RYWmhLMjBwMkRtZUlLdUhCRmtuZzY1UDBDaUtDbktJL3FzbmZvNS81TEFmT2xFbGRxL0cxd3hlN3NPT3dKN3dwRXh4QUI1OE1CVkxRdDJ1ZVZHaTh1T0Y1MFFCMDc2ZVg4RzB6dW5nQVFNYkYvTXRxWmdBTGRvTkRycz06OnZFdbT89ZKEKLX3GQqCjsc=","831:elementor_0012a07","approved"),
("45","Gallay","2025-11-04 10:33:52","1","a2FJYmRxYjZvOFVVYVJHMmhMRVJjOWJrZ0VoQWRjV2Q2Y2JDUHNTTjZlSEdQRFRpUS9ZQ1ZjZVd4eFN1YjRpTlVMdDE1a0wwTXVMN3JtdVpROUNvd1V5VlVXZnRwRmxXTWVQVmdCZzhJL3FISFpMU3ZHcFBYNXVLczFFUitOVGdTV25DLzFpZjJ0ek5ESTNXaWNQSDRDZWQvMTRsd3hSWW9JQkhHTmE2SEpnMHByRVhqWUMvTVVVcE1Ua1V1SDNJMEw3Z2RDTHA0QThaRjFZRjVzYVVVeFdqcDVWeHZkK1NTdXozNHJQQXIrR2U3TW1IYy9HZDZGSWhHSmtpb0FaYTgySFd0cVlMOVYzN090bjEvTlJkU2I4ZHRRdlF3bEU0UFRzWWZuRlBXa3hNMmpyMGs2ejM2eUZhdmFpQXZJR0NKSHFHK3VFRDZNd1hSd1hOTS9sSWZWdklYYkE1YzAvQ0ZOZGpCOFJtZUE2aGswTDAxenQ2bWtMbytsVlIvdkkvcTZvTUZqSnlWQkliOTZQZGIyQk1XTStBVkNDcEUwNE12WWcxMlI5dHY2YmdSWmkrdUx3ZHBUcS8zMFJSN2VVT3FTRFQ4akVrSU9FQWp4M0lJKzFIMThQZnc1bHJDeDBTWEZPVGE2VjFya1JqQjdEMCtGT2pFSmxrSElqaEtBSHkrcDNpcEFVYXlFMDB5Q1lmV01nRmFFdERhcG5WVjE0TkdhRDVzdU1ERStyTkt6dDdVemZsclJVaUMrU1FvVnphVnBCZU5kdjB5ZlJrMVZsanhDV0ErY1FKT1UyaDBFOWFYdWxGWDFoMmtvMD06Oi7MPO6vQ2LA2ea8pDhsMT0=","831:elementor_0012a07","approved"),
("46","Gallay","2025-11-04 10:34:09","1","b2kwUStDUDk0LzJZbFRZUjBpNDRMS3RibFBYTzlLWmYzWTR4UlhnbCsveHorUVJ4bkJGai9QZDd4L2ZnMlZQTkUrQjBRSXV4dms0aiswRHF2bUxlQUIvVkNtT1NXWC9SdGtGYi93MGJYemxkUEFrUnRxSGxQR2UzTHBpd01WL3A0Ky9rNHpIMG1UaUptd1owRGJhNERNMkx0Sm9WL2cvTFM3QUhCNHVtbzBNZE96cnV3R3N3dHNYdSt0b3J3VElDZU9xdnVHNTY1VUtxd29WWmw1cC9rdHRHRWxOL3Y5eldBYVFoNCtxTUVlSnlqcU1OUW8vWWl6VHFqK0ZIcEtQSmVIWUZIU0RsTlA2SnRGNEs1L3JZVXROeFIxS3FxekdHQ2NQeUtCa3lDNmcrTDY2cmgzWjFsM09wc2JXMUxJdVBqS1Q2YlhlS3ZKajJmejBuSjlHZjI0RWlmR0NjMFRXTTdtbEdNR0ZmVlczSEtTenZkUkdUYUZhemxXM0lybGV1Y3Nyd3RJL3c0TFY4d1JnL05YTEVhcVN3OGgrdThscGc1MnRKUjZMNEkxMjQwRmp2MUxGTXR5ekxscTlLcWg2MStaSmpWUXJhNEx5dWVZUlRvL29HR0MvR1BySkVGeGwyUXdRa2h6TTZHZkFSZlJFdGpQRnh3MWZ5NXFxcG9GZyswWWdmeUJDa1psWFZzUWZ1NDZncTdBL05OTjJRNHU2VzBzUXlPNWk4ZUg1NCtZZlZiV05rajZkZ0dNTXhoRFFDMXZjQStkc3c1cDJXa0dwUmhkVkp6RmhBODNJeVhXQ21GcU9hSXNlTkR0WT06OiksEi99jsUak/mn+McFGbM=","831:elementor_0012a07","approved"),
("47","Gallay","2025-11-04 10:35:00","1","N3UxWEwrd3hVQUZzbmIrTTk1YU5RRHp0Tnd5VjFuSkxEallKRWlpcjNiT2c5RWFQQkQ4eW8rWmZmdWNWeUFXaWJ5NGt2eG1paWhsbjNGZzMxcEZOKzZWK2U0NXIrZVZoYkYyNktjMy9lc1pualV5UlhTTzdkZ3BIQjE0U3JhWElNSEZFUFVRMDhES1pod0tmWW85QjhxUXFUVGRNZFpOSHFBendqNWlrTXVmZEpXVE5nd1piREFjeFBYLzdNS1lrLzFkYThqRGpqUzFMUmFSUkJlQXBQYWk3bVpxZXNNSFEwKzQ4WDd4SS9HWEl3Y3g2c0VCTzRGWXJFR2lUZ3Q0Z08rN2h6aUZUWkFSejlpWk12UlgvRkZpTkYyczlSUEw0NnpLNUpwbEFaZldEY3dOK3Z4bE4zY252eFMzL0xDdWYxV2d2dERlUHRMbUJHVUMxVGdsSVhhcFJLQURSeGFiWDJKR1VMT0VBNW1YMnZ3dytnUU5XS1pTenRkdERueE44NkVBR2dWSVhwTEFFUjl1dThPc3BlZXBrNDZIL0VXVmZaOU83RjdPaHBGdEVRL1dkTGJEbXQ5cnJ4OFdIVHIyNllPdUFuUi9FblJIRGlHU1BRY0JiVGhraXNFQ0F3T0o3alhoSThoOE91WmFFQXFxWURGL2lDTVpjR0VJSnVmVWhIblhJbS9JWG56RzE5SlFmUW1MVW1TM0FjVC9kbEV2VjVXMXR1WWJ2U3RrbmRUWFlTZGVPZEVUUlpRemE3ZFVSckRoQ3RnbUhNa0ZHN3haYTVuV3VRV1dhbkxqMWdHaEpqeW4vYWJVN1hXRT06Os1UZQegxny6RcHub2Ya8W8=","831:elementor_0012a07","approved"),
("48","Gallay","2025-11-04 10:35:19","1","eGc5VGhVVHdRWTBCdVZwUEZzSVZ0N0x3bGRJRTNDQitwMm1HbmxaZVRSQ0dJdUpuNlVHQVFTQlVPSnpyZjJ6Nm5kL29hajhWSFB6K1o4RHBlMzZEaVBIZE1meFNDVVB0ZHhpT2JZT2JoNmo3dzdBL29VTnFyYnd2cXhhcVR6NzJxRVoxbDdRbHJYSW80U25yUjArS3EyRHc5TU45NDN1NUZHdDhTeDVHdGVlcmxWOWNyNEpFWHVKcXA0Unc5SXV5ZlB2UThZNjdCVFNpdVlROTh6OEpHcUoyZE5RL2lDYlBRR0w2eU5CMzd2NHFTZVM1UzU4c0xaMy9HcWRRVm9IUHF0czlWSXhyaU95K1FXNWZXY0VlMjNjckE4WVlXaTVKQkw3U3V0dlVaYlVZR0dRTnRRbHRER3ErUDNrV1E5NlgwM0k1NUIraHhIUDlDQ3lXSXdlSk9jRGs5UnQxWnMydkNjaXQ2U2hZSm8ybHluSWNkaitBRjFwQlhGbGxDenhFZ3BjR1RnYVhMT1k1V0xLakZ0UlVqTVlEWjg5ZEpNaGxJQWJLaU9McVBjY3RubnRxRmF1Q3kvSWI4L3dONUw3cDFhN24yaDEzK0lKUnprTzNEOTVPZkJRNlVTcGNFTW5qckQxRWJwaXBEQXRWQ1NldVRxWFdya2JXb1FyYTVPVGVSdElqNnRIZlYyeDBQYlB6b1V6ZmtOZ0FmSjJTNFUxSmRpZ1FlZjY0NS9xaWliRFhHNk8xbXRjbjdIeTN6dWthMndPTWtTcGwwaVRXZHV3R0JSWnhiNzRDL29ERlB3RlU5c1JkYUl0SGVXMD06OqKlO0Kf32Lfco7GLSVNA10=","831:elementor_0012a07","approved"),
("49","Gallay","2025-11-04 10:39:57","1","UUk3aFlpTi9rU2oxY2w2Z0U3aHF3eVREMnhnSVpMQTFNcEpvbkNTQXM2N2tvZG0yNnNsSUlsamtTdTFwVitwMlEySWFjR2lBekNJVm1ZNzJUN0w3NVN3b2dMcEowaU4xTXVZYmx3TzVnaXBHd0h3Z1I0MGtKNEN4NUs3SjBZSFJWSS9XSFFBclErdmZTTTVBdllrWnpSVi9EU2l6TVh0V3VwZ25BMm1aQmZ2TFAxSENqanVQdm9KOU5xUE5vbGlmeWM1Q3daSXJVczBaaENxbVhtSnpsSlBYZzFnalpRMUFnZVdETFYwNFlzMUd0QnQ0TGVxRVFLdWp4MGYwVTJyWmphU3d3bEViVFNMTUZFMDlmbGpaMVhNNmJNdWtXTnJXbmpuTFVzK2hjNjVENTM5L1pDbDNCeUJUVjhINmVwQjlnQnA1eEdpWmNhazFLK0xUUjJaNDR6c3lzdGpONGxUVkZDTnlYSVVGeHp3b05uZ3RzL0dsS2UxeFBsT252VFRnQkIxc2RpWkpnNDViUFBuNWZlYVlPbmRMQlRzRHJMSEVGMERUSEIxYVZZeGpxY3hFQmlDVEJ4bGxUcWIrUFFPWVJYZHJCc2N4Uk82WXAyb3d5MEE5d0Nwbzk2eDdPd2JGVTVLY2diWGtiRnN1R2F3anlFUXh6MlpoZ3d5dmhNamQ3SmI0d2hKYWYrVHR1Q0hiNFNmNWI0V0MvVDFOeWZ6WGpSZ2Jta0N6UXk1dGpFT2gvTGZqVlVEeEJPeURwYXZKMEpNN1FWZ0dYKzBISEx6RE50OGxUVHI3ZkpGNVZlZXNSaXhqK0lVZHZ4cz06Orvka9B6fYmwHQn+ekBrcbA=","831:elementor_0012a07","approved"),
("50","Gallay","2025-11-04 10:40:18","1","Z1hPYnk1TW1mZ05nVUJoL0tkeHorVXpJZ2hGNnZ3NFNBYVdrWS9BSEVMK3lPTG1zS3NxMVZtYTJja0MrQXZtdmlWNG1ndVhRMHBrRXNrdFlXdVZlcGk4VFlvOFkxa29uWkk3Qjk4cDVzbVovM3pEam03dEtyZTVCcWhkVmx2MlR1eCtMR1dobWI1WEtYRjBtS3k4VFZVL2YveDFkNStSZndjZWg0WGhoQzByNXROVDB6cFRkaEJ6YjRLYTNvQlVGdWc3dThXYWFLSldLWmh1c2h2S2h3L0htVXNmZXdwbm1TblNIeTB6ZXNJS0IwWnJCSTFPY1RKRytGbXFwUTBlSnpLMlBiZFVnV1BmVFJFR25XYm1TWDYvcFZ4cjVUekZvK0YyTHR1TFVqNzVJMVJ0aHoxMTZRU0RxUlR3TDVIdTRXN3diUGM4NHhQaHJFeWhCanFDMGFtNnpwL2JZN3JrNmhPNWwrUXBaSkw4cGlTQmNpR3JtbW52bWhFV2t3SGQ0TFREVkRrSm1HcytsTVBxdDVlTy9yQjV5V0hjUjM5ZTdDMzNZUVAydnp1cVJwSW1wNjVxMmpCZjhRQUszMHJmQXU1dnU0cmlrNElyTHdyN2JwSVRWU3psNzM3N0kwY25aZ1lBOVpGWHc1TUZ3U040ZGN3Tm5WLy9mMEdCZHVzNjFtb2NwRG8yMXVtaFZYQk1UL1MvTThXK0lZQi9tTFBhZWdjSEJlT0I3YzVSZlRjVWsyeGFTaC8xTXczV0RrdWpJOTlhMitOMjN6dllRYm1OdGdqSEtTQmN5dnJmUXMwbXFWS3gwdkpkZkJLUT06OtHZ+51CN9jNJK4271c5k20=","831:elementor_0012a07","approved"),
("51","Gallay","2025-11-04 10:40:33","1","MFR0TE9FTVBQbDZLU2xXOEVhM2JzekRSTTJCQm5JZHJTckI0cGsrM2hXNVJFcDU4SHY4OExhV3JwV2lGaEgwS3hpb0F4TGVyT2FDcGxHQXRwNjhsOFZSaEQrcytWa3lYMGZURTBOQ2xzUWlUaGx5dWpRQm1HL1lPRjBJTllXSHFuZ1YwaGNCMkd5c0ViUTdoVXFlU25YdHR2U1pRenJVK1BtZHh4Sk0zelNUSmpTdHpYNmEzR0srZDlhTDZjWFZ6UjhldTFmQ05QTUw0MG91UEExTFdCNWFFQWhOMmpUUElrQjM3K1ZVMHhpdC96blVTVjRKVDB0UEVuZjBDUDdtbDdkWUtES1FIYXVHSjFYQUVOUUxUU0VQQU00SlBvWGViMktXdDJVa0NNWEtURGtmZjI3NVY5a2JIdlBPS3hoVC9VSlBOc2gxVFBsNlcxMmhrWVZybldId0xNck9UMjVRckxnc2FueWtwWnVJaFYzZTN6YjQvcGs1TnJwUVA5MGJISEVLZTYwMWUvVmJtM0VIWUUxSVpTdGpZZENqR3hzMGhRYjlTSG9tc2FLOFVLR3V0M1BqVm9STkZTbDM1cDNkWDkxdm1rNTgxVnA5VjQyZHBGNFQxTjVjSjVZd1ZTMnU1WUpZNWwvTGM0RTZzWGN1SjdTNEJBdy9oODBYWkFaUEorVWZQOFhmQis5aFhXKzFCY1JvcktwdENYRzRvSVdXTkhjSmZvcStpeUFvMTVxR3B6bERneWhyaUd1dDlyQU1xT0pRS1ZZMnM4d3kwSWtjazdPUkY0bzhqZTNnVDNwQ1dkUFJtSlV1RmJYMD06Oq8+iaWVqZONlCYLpBFa3uI=","831:elementor_0012a07","approved"),
("52","Gallay","2025-11-04 10:47:34","1","SnVoVStzZE1GZWNBWDdudjlGODNRdnl0V3ZkTHNWSUpJcFNzSGhnK0NIK0szeFp5Q01vd1EvT3Z4dStEalRQOHVQemdDQ0tpZ1JlU05XdDRWRHVuNDZyWUc5czZja1dKQTdSS04yRVhyRVNvK05IOXFQblBNekFRRkxCNlZjUDhSUkI2NEMrQUtTUUMvWVJCcGIwcDNmekMrbisrZ1pKb0tXbXY2endiRkJscVJCZldpR1h5b3NhS09XQWpoQjl5aFNXUzVNem5EQ3dtOVhzc2ZHWVRIdE12d1d2OXBLYUpFdzBBVzhhdkR2aEhreDRRNzNDZjAwTUZMTDdMWlZGTU5sYUxUR3lXcjdDT3BKaFdIc3JLbkx1ZVBOOWNxMmRtczkvclZFME8xWElxeGVPeGJKaUNZbGcvcnlFRGZtM081cm9Gell2dTJMM1l2RzI1eG5lbzZTM2FJSEpaT3B4ZUxJM01BbDJTV2dBT1hVQ2ZkeS8wbUJpbkR2dnBNU1R0THN4QmFYSWhqVEJtNytGUG5vSUI0cjVSak1ocXJuSUlkN3E0TTBJem85L3h4Z2drRGJ0MUxOMWVPTkozdUhpS1IxWW9raFlFUFhCRDRmRHNYVlhmMzRSTGd6eVltd0dzQjRpMGhJcUU5Qms3Q2VCNTNyMU5lbmJjcnN0WnZ4UlNvL3JHYkdidVFXenVONmFYWm9Ga2pUVmVRYjlpNU5lNUFBS2Z5WlkxVFpXOFpmcXNyUmZRWXZwcEZ5a0ttS0pEcWl1MjBNcWM1QmVIL2w3KzRDRGFHeWg3Ui91NXY4WUtZajVveldvd3MyST06OsIfei0T6dNAHk8XFXd58UI=","831:elementor_0012a07","approved"),
("53","Gallay","2025-11-04 10:48:08","1","VENsVnl1ZWgvcTJDMHh6cHFkQ0NScTllY1cvU3NTT2ZvNTN4VnovOG1Idjd5bkt1VnI3MDB2R0dhczhWd2tPQzdhWHVvZVVqdnd6QlE0d3l0KzV6ZC9NdEF3V0FIT3hiU3VnTHB1UDNOalpLaW1QVzgvYXZFV1dLSmFXdU1lT2dkODcvVWN0VUhFTTI5SmRveDd2MVhLRUcvS2wxUUUrSVVGUW9nai9nTVRMRCtFYUZNY3RVWDJUUWROSlZvWW5rYzJYSlkzV0VlbXZEbXU5cXN3bzVTMkxZWlI3M1MrSmk1cGVadnJscVl5dDRkRnZweVlDRzVDOTZqNHRtazV3aml2WjQ4emMyWmwyTE1GeUxsOEFaSytwZTZpdjhiallxSnRRUHR6VzU3cmJnb1hCcnR4d0NuS1JXSGQxNmZMbFhCUjNqSE9Ob3pCQ2xkOEk2bnhGTHMzSHY3em5RUUx6QTc3eFV1c3JRd2dyeTMwQ0krck9YM3BIWWNIcU9IMjRxSUg2WFFRT01pUFZOK0RmMExKTXVDS2ZBL1JxNEIxSTcydnNtRDhqTndaaGdySDlUTm8zOGRMMEQzOFVQYkVRVlNkbGRoeGVaU1NzL29IeEpqZE8vbzRLbWZlQllrL2NVeU05R2NGVy9sMFNCQldOdk9FTVN3anVvV0hBbFl2UEowOVJuTVFXMDZuMVA3ekhQSS81anh6NDVsMmdNWDZYMVMyVXVWK0ExSklaYVhtdlRVdk1RbFdWb3lvejc3N3pVTUtsazJMdERIeDVzdW9oNGkvMzNvKytPV2JpS2tRWlVITmtSM3RUWEt6TT06OhZ2q8oWquRRn1jUtPwGgyA=","831:elementor_0012a07","approved"),
("54","Gallay","2025-11-04 10:48:28","1","Um1qTFE4bnYvS1NSejJXbXRNcGZXTFJieUUwMUdCOG9SbmZ4UThSdDlqNmNBTytkZ2FzU2xCZUFJeUV4UzVBYUlXV2Y3d0hxenVXWnNueTA0d2JhemRUeUdLc2NjU3hxRFJjcGdrWExSUUIrZ1JqbU9BR3NwK0lZS0E3cnZBQ3JLSjN1ckJ2bmtBUWlBcnFzaWJEUUttWTdGUnhjSk9qNmVxalMxbDRqdlg1RG1xS04va2N2b3VvdXl3K280TGFSSnNWQmNuY2M5YkpWdmpwYjJtTUpWSXJzQnI1MzdFUE9BVTc2VnMvYWg4bFg4QS9scDlkdCtEVTgvY3lCNHZFZW1VcVNvKy9QbHFXclFjYzg1blRPdmYvbXQ4RVpFYzlBZ1M4MDBJT1c2bW94ZjFLbHBHbzBhZXdnU0V2eTRNRHNHaXpaTGNtRjI4aFk3cExETWpDZ1FXZURyWDU2cmJ4dVdBTnRCeU41QUtKN3NxQWxpT2pqdXNyZlp0WXRMdmN4bEl1MGZRS05Sa2QzUlJ3aEsyaEFseXpOMVRwbWxua0VpRUFvNXBtaWQxSjB1TENzNTVMdno5VGw5UTh2ZnJCUzRPUkRnS1JsMDlJcVN5V1NIQzg1NmtaTWNFZ1pnVldGVGE1R0pLREFJQUZwQ0Y2c0dTRk11elZkUkRmVnVZL0k4L0pHT2YyNmFiUmF0dGV1YmRxb2YwdzdvYyt2SG9nM3ZaR010ZkFlakczeFpmc2xvanNmK040Z01IUEF4SGQwMktUSGI2b1NvYml5cktNcUFnOWpKbXRHc0FYK3RZT1FqcTdpTCtnK0F5dz06OtwH9FmuDXrDOIpQjn3vVSs=","831:elementor_0012a07","approved"),
("55","test nom prénom","2025-11-04 10:54:14","1","YlV1T2Iwd1pZWkFFUFMxWDFPVlA0bDJ5Y3dtTnBsSWpqRUZzSGo4L1dzYTZYdWNrSCtRQnUzbyt4cWcwcW9OZEVyRlpsVi9YR0RlcTZQaEQzNG9sWXJWV3NrM0tkakVreXFhRkhIUHY1eC94S3NjY1VHSTcvNnJBTy8wNnZhdTR2R1JCTjFINmRGQUNEa1J1SjVHRlA5dnY1MEFWYm1UWVg0czNiL04vaXoyTFljTjc1N2F2OU5maThGQUQ2NFJQVlk5aDY4eUREMVVaMGpkdURJbDFrL3A5U0JvdU1CdnpvaFcxVGxFN3N4Y1hFZ20vZHJHZWZwN01tUlFPL1Q4amFkR1FtUFZBb3lWNGtkSXkreWJCSWQ1djNySzhJSHJkLzVWYXF0WFdKZ3U2TjgwQmFrVm91STFwS0tpT2RZUG1JNWNkNjQxeW9qQlVud0M5bHN1MzltOWpmZVA2R1BzL3FmQlhpMHBkdFluNlkxcUdoQ1MvNVl1VGNnTFhLdnJBbVVFQ3dLTHVrTytnZ0l6OTVQM0JMc3hjdW5QSkRXVnhhVWFrb0JLRWNWVnA2TVlNWXFlUGhNanVDOGROMnlyaGdIaEVDS0YydncwWU5TRXZMTTF0bDZPYXF5VFNEblJ5dXYwWWFnOEk2QkRJemFIQUM3K1JuZ2MvMFAzNGQwMStmN3JvdEYzajJTU2pCdWtVWERBSTcxQXdHUmlLZnNQMnlIaENUalZ1TmExNzNuRWhFSzZaR3d4cUtybzY0elVYL2FOTlBVcHJSWDNpNWdac1p1WU83RVRTRnZoTzdyQTBCek85VHMxMTlMbnY2K3BueXBIREV5TndiM3RWVVNtYzo6dNf99SAr6aVNH4tc8vHCJw==","831:elementor_0012a07","approved"),
("56","VERONIQUE","2025-11-04 10:55:00","1","Z3FCKzM2VFRtWVFWSk9oK3JLN256Tnk1SFEyNm9YZStmb1JmTUlQREFNODYra0MrTFlHSVlMRVVHS3F3OTlWbm9pTU9uUmRvc2h1MHRLS3lZWXZyYlY0MXhES0tPd1A2TXpEdm9jN2ZTS2RxdUl2eGhtWW1BVzBNR3p6Q29KcTJEbFpSZTNmVFJqbnRaOVhMbm51cEwra2RXWlBiaWNzbEtTdW5PNlY0WFVxM0lUUnNBM0NPSklVMGt0ZDI5V3NLTHN4eXRMQkY4VWFSU0l5NmVLVEZDVTRyd2l5MXd1L2xKZnlwUnNCRnNZcVlMdXNXZ2hLY1BlZGt0ZnpaOFNpV0lVNTdhYjJqVUJIYmVNRmxWL3piY1JTVG9BS3dHbnBrNytFM09xamVHK1BpbWJlazNVMTZkbVRFa2w2SjVCZXBtOWNtYUJXMGFUS3pMMU5XemVRTFJzdytpdm11MEVoVmFiSGRHZ3REK3FYUXM5SVdvVitOV2V5Si9iSzE0QVV1bUtIR2ZpOEhOVGVKWmRMbFdXUExrb0xxaGtoM2QvMmZYUVdwMjFZdEFJTGJ3dEJTT0tZU0M5aUw4YlBreHMxKzVKU3BNM1k2VFMxZGU0YVpjSFEwNTRucXBGQUhpb2VYeWd2cmg1Z2lFME5EYlBqZDA2bGV6K3pnN2RzUUVEVHhpeEU2bDZsOWFrZE5CVVZxdGRZRWVGL0lVSUVvZmNja1F2WVNhaytCZ2luWUR6UEpaeGxjdmk4blhSMjRqMXJYdGhTMEc5UjRMZDVLOU9ld2xIdFFWWE55QlhacUk0WVBYZThEUmZBd1FEST06OmWzUwZmSqeYslfhrnvimf4=","831:elementor_0012a07","approved"),
("57","VERONIQUE","2025-11-04 10:55:11","1","K2gveU1sSTdHQTJ0SzNPVS9pSkxyeEZzd0RKZHVsUUg5NlZkRnphQ2ZoWkdNaW5YUksvM1ZmODFUTldLazZUWm13c0hNSDJMc21adm91SjcramxGVUNnbWd4dFh3ZGFOUjRNcUVaQVo1cjM0bGc5ZURUZ2hORUtyWXB4SmNvelF6MUtNcmo0c2tpclpXTGlFcG5XY1A5L2hjV3RCd2tJSGhHUnpKMDRGaTRxcFZRWUVwV2thejA5NnFoTEtkNXRhVmoyR1BWUzhXOVB2b2ZTekhNQzdUN3ZkTFZvU0ZzTHZFblNFZ1dtcVJvOHV5MHkwOHR6VUJjVXovTFVObWhGck5TS1ZSNjBTRXFHMHZlMC9aSG8yUmZmL1JZMTlSNE5QQ0ExT2k1U1RIYkJTeElFblpDcGVIT1ZYM0Y5YitsTEltSHFrSjQwWm1IUGY1RHMwU1NWUWd0OTNjQ3dYVkZMaGg0QU1xS3RZbGRTT0NPdUgreFB0OHM4Q1pYZzEvTlFkL0ZBeVcvYlY1ekhseU5zTkRWSGZyR2pRTEx2VnpqK25ra1FrcnR4ZFFxRk9QandjWlZzQ09LNGVmSUpYckFkTldMMi80dnlZRlN5ZFZrTUZjMkltd3hCSVNIM3M5T0FmNEt1Z1RNeDZoc3ViV25kcnlxVmFWMWhsVDlJK2VIMUFXWHIxeE1kREhHd3RMbGcyQS9naDVFL1RkZFlXS2ppQ0JCMzd0N2xHWUdTaXdPc0dqMGFTaFFJMW5KTzNNTC9Hc3lSZnN0MVhsTmxsYUtrNzBEcHAyZ0xRLzVWWmpnY2wrZVRzVlNpQU9SRT06OsuGOzh50SYqJczPRf6okbU=","831:elementor_0012a07","approved"),
("58","test","2025-11-04 11:07:36","1","bEVYbWJFYzQ0UlJ6SngrOTRNNDJRa3QrNndlRVZGZC8rWldrb3hqWDZZdFdJcTdRT29ldjllOGFQWEgrMjhEdUpoRGo4Tjd0K0pFenZuKzlyY29SQzhTN2d3Q0xkSGZNYnYvQmI2MUc4YXo1TWFsdENoK25TTysyQ2gwaTYvdlNxRDR0clVOajRBancyNFI2SWhUMWJJRm9oWC9McDV0YW1LTWFQdFpnSHVQT2YrdHlQd2piRktJdk5DVTRsMUlObnYvaTdEQlJhTTB4d1hrQWFTS0szeHVJY2xaKzhtUTQ2a1d2V3ZXdm1VU0pnUWlIZUJUclI0YloweGtQVlJINXFBWFZleWJWNG40N0xCazhCQUJqUGVoL1gvRGdvbHhWNS9VSG5CMzdlUHJ1SWdGSjNFdHRlYWRZSXZ5Nm9rUmgrc2dYMytNZVB1TmVJQTc4dDZJVjBvLzZKKzVqd2FUMWlCV2V3aTR6OEphdkxkRGV5bHpXeEJTUzlIYzZMM001K1hGSVFhTk1OTHlod0d5WnBUTTJndFVyYi9nQWZvbHdmUXJpMGVYVTNYN3lwM1RsRm9SVFV6eW92THFTUC94Y0hGNjVkWE1CTVQ5L3gzTnB6d29Ka2pRUWwwMDVmeXhHMEh4OHRySTc5NVZaR3Y2YW9KVEV6QXV4YUJKMk9NRE5LZWVGL3JJN3BmSzRreTRaMEF6V2Z1Z0ZhMXhMWjRGU25mcEVKaWlTM1ZQTDNYTnJFbThHRnVGS3pOS290UkU3QzhrcWtPbUd4d1REQWVzN1ZzdUhvQT09OjrHHZjb8mnBSiAunVGrhG1G","831:elementor_0012a07","approved"),
("59","VERONIQUE","2025-11-04 11:13:09","1","c3FMRHBQNlhCM29NWmdPNVFBejFKT3dNd09sd1dkS0Frbmc0cnFFQUNyaVJjUUdJV3FWamtvamduYVVPemVGbjZnWFhIOUFPbzNTRzlBNTF3UXJIWGFEK2drVGFtRTVFOWhTYW4yZWFVVFM4ek5TRFVUYVVKdVZ5eWRTVDhsV0xBT3pERGxMdm45TWErOU1ralJZeXoxM2czV0JFWjhNSlRYN3I4SVJjdVE0dEZlL1Y4bUJFdUUzWWkwaVZsS3JSb3d0V2ZSTlZ5QklyVlRDMkgvMGR4bU5rK09icnVXU3lLNkhsNnFZYTlqSUFxRlBNb29FMXBnWjQzZG1HUXdTWndSSXNUOEpxcWtoZHAzdUtXL0huZ1oxR25Na3V4UFVYR3g3YmE0aGJyUGtNL2x2WElyVmk3S0VCc3Nsb1pNTnhPUVNqSU50V0dMWGNTR2F4NlFtZjg3M1FKb2xkMEt1aFczYzhDR1VDeDNVTDJJd2drUmI3OWhPeGhLTGRoS0FvUHhmckNqZXV2WDhtZm9ETWdlNE10cE9iN0YzNkpJaW9odE8yUldGU1gyTTYrQ3RhZEtHOFE2S3ZyeXMzaUxrdXVkZHhUNFFHYnh1akZQRGhlaitJcU1OVVJKazcrS0NWak9ySmYzQWZmTjNaMWhiOVBERjBySUpmaEdLK1FkbFNsOU45cDhMVVFRRkFKN3FJOFBJUDloM1Nla1ZiOUR3Y0JYRmIwZWZJSC9CdHVRMHZ4SWlLTVQyZGdydEEyTVI5eTYzSzVPSXZWNEhUVyt6S1RGaTJQY0NYYmFMRGhTakRrVExuenB4MzdqZz06OryhMSgGkxrRZYOPGJZt+2g=","831:elementor_0012a07","approved"),
("60","VERONIQUE","2025-11-04 11:13:36","1","RkJnMFY3bkxNN3dZM3pmV2tSWnV1TytLY0V6RTJ2MjRTaHdOTkwyVnVlQzRWVzkwaUQ3VUEzVVJRVWZ5UzdpNDJialp2QmFsQlh5ZXJwaHYvLytldjYva1NpdVdpaU5xOEF6bGpMMW1IaGdqbDBBS3RQK0dJQy83SU9qbW4xbmJLRlF2ZGpaVWtHWG9EaENpSVk1V0k5T0lmVml5MDNLdWF0eHRKR3NjNkpLdzNNeGlYbG1XUjhVSEhENEp0bVNrOXlvbkRqei9NSjkxYmFiMmlXQkFGTTNlbFo2VmIra1MyVUZ4TTd4T2dLMythaXYxdThvZWR2TWw2TkRBSElUZDBFbk5kR3VzMWRYc1lRRlcxaS9LR1ZBeVpMTnVIY3l5YWVrclZLbGlONG1jUEE2N0hYaEhza0RKTDZJWndwNEZvMlFFUFJVMVZBS25hUm1rSEVpU1lYUVNWbEhwTjRkYVdKcFZPSmZnSG4rYlQrbnhWOS9GL0grQWlJUStwWW5EblhUc0w2RGIySC95SFFqdnFjZ3djREMvNHNYMXJkdUFrSTg1cTdCRnpZbmNtdzVsS0lmcEJlblFyUTgyZHN4Q2hYVGk1QVNRL0t3Tks4TzVLenUrUDJVY2szUlkvWTMvT2RyUGdUZjlyZWlNM2JIZCt0MElWWkM2V3VaNEQyQ0RTdkZwaVlBejE0V25ERHI3YWo1cXYydW1SNkFVUlpidFRSdlh6U0dycUZ3dFdTM2JjMDdGSmYwaG1WcitCNUFLTUhteFhLdlhTeGlsNGY0c1p1VE5MVkJkTHZwNkVRU0pOZ1pSOXB5MzcxWT06OvdPer2hmN+NCjBWLajtnj0=","831:elementor_0012a07","approved"),
("61","VERONIQUE","2025-11-04 11:18:32","1","dzNQOXVjTmVBZXV5aXNuUGxCRDFsclRDelQzYXpacUhpVjdjMm5HNXJvVFYzQlBCaXJlTXV6RGZERHFXbXpuQmVKampFMWpvQ0FvMzRtQlZ1eDNwTCtqamxCNkgrdnNwb09kdmxIZ1pneTUvM2ZRanZ4L2dKQ3huYjhWTFppZDRIeFFMaDluQlJFQ0U5SUtab2FxU0FXTkhOV0UxYnpheWg1M0NtTmlHT1RRS2I5OE1Dd0huZ0JBQStwTmxEUTlRTlFlZjdwWmtiRFY0TVo0cHpXOXUvQlhTa1JWUmsrUnNBaDJEdjE2azRlL01jMk5CbklkRys2anlsakZNMUVYN1VPYkoyeGV0YmgwL0FNWk1VK25xaEJHMGY1UXpYVytRRFp4TkROU2F3MzYzSGxiWmZ1dm5yTlkxb1d3eTlndVZJMWRscXNTSXpabHAyTldUNWVWQjZQUnlmbjNqamwyVVVwellrbXZqZEQ5MUlIUWl5SysrbFMrNVVwUDVZY1A1Ni9Ya1JUQWVzZFBDMitRUWdlMHk2NVJGeWFPMzRDU293U3BOZm1hV3l6WUd3WCtjbWpkY1RvNjNSbVB1VklGaFBHbS8zUFhSLzNqNDZsc2xqcXlXekpyOHdyZUZuUVpVZnIzdjVyV0tOTXJiVE8xNzBNRU1KbUlFYVFTRDFmZnFnN1FMUUQrclFuYVl4akZ4VnlvUmQ4VnJZRm50eDAvYURKV1dFV2czam9Xa3lxcUVlRFUrWmJNNjVoUmZ1dzFvOjp8HWqZO9+iJ+40gyIUjroY","831:elementor_0012a07","approved"),
("62","a","2025-11-04 11:26:48","1","WFdESEozYWp6Q1did0poa2tpcmJKTWtsQ3NXemZaYWsyV081cXVPU290dHpXeVcrRC9pak1ZK2ZPYlJNeVFhUFoxY2FhRFArWlUybGczRjhNNzJXdVBwYmcrUFJNWGVmcG5SQWtQeFJMekJwSEdqbEJYd0lZVXZXZUxRK3FzSjFxNGR4WlY5WktCQ1dsdFE2d08rMEtTdGRJK0VTR1FLTjV6ZDJIc2M0V1hIVEdSN1YwM2lsMWdXSmhsdVJtNXZYSkQ0V2sxYVBwSzZ6bC9VekpveXNKdUVXanJWYlo0MGd5OW5TRExhakJDejVZYm9scUJGRmQyRFA4RkNqVmg1THZMc1NYYStNTGhpSTZZbFdRZi8zOVRyL25LRnVtQ244TWxYbzloSzRtTktBQVArZWNFcS9PY2J1NmcyNjRrcTRCSHYvdFdlZ2Z6TFJvQWd4eXVWQXkwbnJoVURYaG1yUHRlT0k2UmlMYkM0UU9OeWxOT1dRSEUyUFE0eXlvdTh2UW8xYko5VlpMY1hJbVdENkN1UDd6WDVjci8zSFFtT054S0xnR1FvdWJQaTNVSEFUa2lyeEhCTVV2blBkZ3RTTXZLQVA5SWk1blZjWVhKU0M1ZjBIM0cvSGZFTHhuZnQwaHMwOXNESWE0LzRSL3B5ejExRHZHaHBWWThaQS9KRk9STXIyOFFnMlFVMzVRNlFtTmNMVFE5SUIwR1poOEoraFYrUW1CUFRjYStLejdGMHo5LzFsU1MzdFIwVldDMWZxcGdta29tZzBHbmxFU3F5T080K1ljeURMemxDVi9NNlRDQVVYT3YwZms5M3EwV08zbjI4RnJ4NWRXb000RmRzaFdFc1NHK2xxcy9OdVJlYm40WUpKdWxqaTVEeWxlN041ejI5VytrNjc5Tk5OVnhQUHY1dHhxQ3l0V2VEWXBkbGQ2RjJzcUFpU20wRStzenlIMmF5Sng2enJyWUhKYXNJNjJPL0tYTm80UllpWHo3Q1NlVFFYMDlHdnpEbW9zREUySXZKdFNSNTVFU1pPeGxmQmFlWU5NQUs5NzJ2VGxsYWprL2VFaVQxYmtKN0RRZmxKWUcvY0FUQUFIZENWMGFWdXg2K1YzMkkrUHMwNmpUMytSZmhQRWxWMU5HazUxZmFBbTZOWTBWYUcvWUE2V2wxWDJnUDZCbW85ZjkySVNJV1RyTmdKRGpVVzRwb21ENDVpNHBXakxOQzRWS0FTMWNJYjVUaXJ6VGNuZlFwVjJHOFhSNWJLT1RoczQ4Y1lJNVBpWm9qbGFSdGVudCtkWVJoM0t2ZUVGQm9uUk5XSmZ3UkxxdXo1WndKTXRXRDBxTWs0WkZwaThuclRrOTdIMkNHQkQyZVlhRmk0WkZnbXFtSG8wV0ViYnE5Y3ZpblNldDVZM3hHY3UvaWdkVWZ1eFpyOXB0bS82bTNrVGoxenM3WVNaRkZQTGZudVRVSFNXQ0txY2dCNk9OZEk2d1NleTkra0xoNzRKcmRyS3VZNlZ5c1dpdS9JUzkzZVZDdk9Id3I1UmtZNk1vM1hMT2MrZUN5S09RWm1NRFhtTUJoTWZvbGpuV3RTSmdKT1NiUWNVb3lWMkFoS0JXMFBxemRXYmIvS0pRbU9mWXpRYStPU3VVR1dKL29QOEdiMVN5elkvaUl5RTNlaG9DS1p2b2JPZmg0S1RLVk1PQlluM3NxL3A0cDdTTnk5dTBscU9RRDhhalBCZi91ODhocGdoNks5UTNtRnpDcFQ2TnI0QnMwTlNaMnZFQVo3RGFHL0hTT0c2YmY5QXdxMXg4eVVxdzQweGhkT0Q1VjVTeFlPbTFTa3FrV0NjNnhOV1Rib1ZaTT06Ov2gvuj7E6JJqgP0KReeISo=","831:elementor_0012a07","approved"),
("63","a","2025-11-04 11:27:55","1","NG5GYzdha2Y0TlU0ZlRweEdFd0FZUE5jRTFYZDB5ZUNtK2ZUTW9rK2R0UGVPaUVRQVhXQUtsY0ptODRXVFB1eXhPVXVmUzdvaHJEZnp6cGthTnVDWTFWZ2V3K1F0NWxaaENNNzcwcWlOWmtvVi9GL1p5YlZXRW1vcjhkNWM1TzZ2N1FiYlB0bS9peGFWZU9JOU5ybDVCL2FxV2lqUk1Ya1FPMGc0UG1oN3pLU3didkVGdWpxQVlDY2xlaGRCN1VQV3NIVjRXc3F5Z1cxb1V6Y01nVWVvUU56b3VGb0xkbGZwKzNHU2JrNTR3KzJ3VnFwbWxyeCt3Wis5V2thR2VDWjI0STZxTk43Q3M1ekpvL1FkTjR3L0FqN2R1U2dJd2dibVlCcUNZV1NTZEhJQ1RNbzdyb3ZlSTlGall1RCtTbnlRaFc2Q3hpektBQUFZR2hJNTYrclFYM0ZvbE1kU0M5NDNIN0pvUEFQbWloUjJlWEpRMkNSb2N0Q2tGdHJnekxVdC9wTVZ1VERXaW5HTzNqQWhLYW5md3NiRTZHWDZEZzdXUitVT0dhU3RWaDdzU1pIS2dMRUlWeXVCYWFjYXRTM1Z3NHBkNTRxQmkzZXFhWWF4WXd1VDBPaFQ5cHhTVFJUendBVGxQc1ZHcXNORDhTVHo4aTZuVm5HQnhxVGZNenJHSllab0JYWTUrNzBub0NYK3VhbFlycmZQSUQ5Rlo0b0NVSnBwNm5GSEM3WkM0dEo5eCs4cjUvZ05PVUV1U3FPL1NhRE5uYnVlUC9TUnBkN0drOUcyYUw0TWFGNnhzOTltTlNYY0dQNnN6QXJVdEFXcnNGQnY2VHRYZnZwejRDM29jS0hxaGlIWXR4RzFtZit1cDM1R09KQ2ZoTlJOdDVoa21tcnhrR3RGVHR4aFdtbjNJRGd5aUJHTWo1MWVpeU9icjRQQVJQbTBzYlN0V1NRSUJwcnJYYzNCajNlNFVJajZZdFFwSGlhMGdnYjUrUDQ5cVNqeHRuWHpWMktNMkNEQm9Vdk1Ody82OFY1azFkZzYvTzYxN2RvZG5UT0pxdERaYjdJQWdZZVZkWT06OsU5iuTWggPicikEdrYNnN4=","831:elementor_0012a07","approved"),
("64","VERONIQUE","2025-11-04 11:43:55","1","eStnL1ZJMDVWK2hGS2RkeTkvWlJDS0EwckMyMXJIelhTdnkwYUhtMTVTbTd5b2QyOWFPMTFuLys2dzV3MG9MZ2Y0ZEY3Slk4T01yTHc2d3RQSVM3UUdsb2E3cHgzSktrZTRkc0oyMDdzMURWRFpmUWhyOXJ5Q1J5U2Y4cS9hNHlvSStIdEljOU9rMHk3VkE5QVpWdVI1OGRnUUFtUkpJWGVFWnFOR1lqamIvdEFiTGpqT2ZEQ25mL2cxeG9pU1M3cmY1R01CZExuY0RXb3BxVXEyZzlIdm0weFFGajBYL2gzUWVVVW1SUVhCTkhKYWcyMjg1SzBzR3NaOWVvNys1ZUNhYWtUdjVYeEJEZ3dGcms1cXhiRWg1YlR4Slo2YldCcU5lbXNqUzRKS2R6bmRrM29iamwxa2k2Qk5uYXg5RWRWSHNUakdhZ2JlcGtKckFWQWhmb2haSUhyYVkwZW5lZDNIdjY0RnhLaTdkM3doKzZGNmpkSTUwaXhqNkcxV0t4UU9RcVljelZiVGxtUXZkcmZXeUVoZ2NIejlrcGVleERFZURmR0tRRDBObTg2UkFtcTNUbEtYelkvREsrdGswRGJ1Rm02cG5sMldQNlJDSU01MStNOVVQemU4SytDYmJCUDJpVUF6RFhKTENDd3h1aE9uTXFRRkQ3OWxpWTY1NytheW5iL01JNXI1U3ZHTG1CUm9YdGN5cnJ0WWhaVHpId2N6UU9oZmdYNWFaTFVwQlo1RU9EZENydnd1TEpKSmZxeGpZamNsMWdpUlA5VWtNYkhLSlpQVzN0RVU1RXg1V2xMMUV5ZDlGaVNlOVNuT1Z2OCtwZDl4SWxNMTVSTmhNMUZPK2VvR1hTTEhUaGEzSDJyTDZjUS9YeTJkZE11VUVoYzNFcUszLzlvTUVmWkdXM1pFQTVPZXgrbnJEQ0g5QzRuMU9YTlJuL2c1SVIrN1Qyazl3cUdIQ3VtUWp6eUpIdmlHMmlBVHBSZ1ZaN0xsdEFQelkyRWZCWWx2Q1c3RGhQaXlXazFTaWlQRy9yUDgrZk9PVDI0UU5Tekg5dERRdnRsLzd1b2UxbmhTU0pHQ2VmckVXREprTHZvT3dKellKaVB5TmRDVmduQ1pLeDlSaTdHVUVWY2NPblI4TGQ5eTBLM1JxRXl6ZzArMWh3aEdRU3QxV1FHM0FiUDNiblA2cks6Okb791oZwjlQYQZkjkG7MPc=","831:elementor_0012a07","approved"),
("65","xhgx","2025-11-04 11:46:20","1","UkUrek92Qm02QUJTZ0xZMFd5dTlQb2pQdElUM3ptZzMrdkwxSGk1bVZRRVVXNFlXdlZMdkZRZXVRUFZoRnBLbHpDR2t4L25uaEpsSGlMTGp4elQ3a01nUGNqeVBRVmVCdyt4S2xENVpIbU9nSmxLbC9wL2lreGdUelkrb2xSeWI0Tm1BbkhrYUVNTlJzZkpNRUxtSVdnL2o5RDFrbUp5NlV0a1dPT2hhMW5Eb0xZcGFBQzZweVRVRFRmR1dHMUIyekoxT0h1M1Fka094cmlJczEwdjdoMHN2ZHVIeWNHOTZjajZuck5BcWx0ZE1TNDJlakFNTEQ2c3p4NHozaG1iVko4b2V1TWk3RkZUME1RV1lrL2RDZDN5M3R1cldYQm5kSmFDRUJIZngrVHR0SmtmdlZPVGNSVXpFUnpXdExQcmlmanVtSVoyNm02RVVrZXBHa3lyUTYzQjE2ZGNZT3FjQnBrdHdNWXZYWDlnY0dCTnh6alUrL1BObHZISWlKeEkzc2IzRm13Q21TRkhoU1JHb25Ybk9velZQZWl6aDZVd3FGTUtqcDZjeGYyL2o3SVI4TzBlb3Ara3pLcnZNYjVqRFp5WWJSWXhRbHJRZkxlYmFyZGN4LzN6aEVyeWNhdE4xa3o4NTdaaXF0OC9RTWdPVE5heVl4VWJHWHNrOVNoaUFreGlOVWdnbEw0REhIUHR3am9UV3UwRlJFV1g4RVdFd1Q2MHJBb0k0eGRqV1p6YUU3UDZOdS9tMmpkazU5SEVGTDFPR2tNQ0dxcUZXVlJOSStWTXlNNnQ3Y1FyQWZJN2RIWGhVcUZTblArMWlCQ1BCdG0yd09HaDRLeHVyeUlJSTRDd1NscnJyakVTN2RXNm9mQWdFdjluVGMvUW1ZUlBSb0lZeVI4SXQ0cCtRcWN0SVE5S0lxZFFsMGJJMG45NTdvQk5CR2Z3YmFiMVY2cEcwNUdZb3Y2VllGZGpjVkFVaU52WmtldzN2b294Tjl3ZXBGY0lKamhlczliZVVsdzdIUE5qblUzdFV3M3hKaXBHRndtZk55bkY2R3BEVTlnb1ViM0pkMW8xNXVlRU1TVm9ORUFIMzFFalFZemZMa3RNZ0lCM29XMlBWRHlrenNjT1hldTVPUHc9PTo6zETuVjaArkP03hB4LOMYxQ==","831:elementor_0012a07","approved"),
("66","VERONIQUE","2025-11-04 11:53:02","1","cmNyd3lQZUFxYXBTOFFVY0ZUMDkrVnhkVGNFS1NsUS8xUmtpaktTYkpZNlhuQlBwcGpOYzVwUTVnaTN3NU5WMjFIYWtHTVgwcUtCcXUvOUtZRG9Scyt4S1U5WnFnbEFtajE1VTdEZ1lReEFSYURzRENkRGdLRmIwbWMyeDFPb1FrL0pGNkRwTHBCaHpsZ29NbzBmNnUrdXdWRVZtOXZhcURqNnN4ZUU5YTBCNWRkd0NnSVYvRUdpWG9lTHlGMFlkMWFtK2pJeE0weHpXLzBadkxWMk44K0NzWUJFYkg0dTdYQ3BMQ2loYldaeVkwdktUWjBQVk9xOUNvZlBUQUh5eVVnSGJ5bGVsMm5DYndaNTRiTjdXbmJ5RVB5ZStwWUo2YlEyaTJwSklYcUNBVlYyOEhMZlhNaVBTbEk2b0ZIalYybDl5OWY3Q084ekdXS1lJTWVzdGdKSVJFVTMvT1hIZXZlZFVaQVBGV2h6UDEyRmk4NlJId3VkVUtMUWdvT3lwY1VSd0lURDRQeUFhbDIrdWFOaStoTU5EUENtN1o0TStlQ2pZQUQxcXFWMGIwSXphZEFzeHFMMk9mR1BFYkgxS0IrK1YxbnRCUUw1aDdiSDRLN3hndCt1KzFtSVNOejVqYmRWeEg0SDh1V2diZXV1cGI4eWx5MC9od3RyM092U3Q3ZmpHTEtHb3pyTytOZG40MlJVaDZxM0xQYXdCZVBmQ2sxRVFUYVhKTU5uSWp6QklQL1JjMThsbkJIVE1vbjQ4d1Z3b0dRYlppZWZYYVJYT3laSnNweVRIZ0ZFa3J1Z1RZYVN5Ukg3Z0R4eTBSTVhaQnJKVHdoK1lkaW1aNnBiUFZ3a0ttc0lEK1JhMm5sRTdodGNYdUFzM3VQc3BxU3RaeDFwb2plK2NsRkdvKzlrb0dCT0l4LyswUDFUNGNvelJKMGhmTWovWXVjaVEwNmFWWmFFeDRVSDBPdSt4dGF6NHhYc1JQelQ0WldaNWlrZzAxWXFsU2NzaVc1Wk1rRU9vMkkxNnR6Z3k4Y3FuWGw2REhRaDhnMkdFUmNvRm5wWGFVdWpCa1R5MXlTREEyTlpMbmVkQ0NSRXVVL25qOTdLL2Y0bUYwRk1NNGFkVFF5Smh4cWVNeENiTDF3Wll2WkYxVjhQZzB4c3pEejZ3VUdFWk14MC93OWdvTGhBRmxXVXg6OlLKm9oYJshzEGAGfjvKHfc=","831:elementor_0012a07","approved"),
("67","Gallaya","2025-11-04 11:57:40","1","QzRDdVB6TDlka2FRK0xiQUZ6blZxWm1NQXhTSUxYMm1UeUpSbW5yS0loZ29oZXhQcnNhWEI1N1dXeTlRaUxTWFlKVzZqMmxLL1ovZTNaZWJsMS9qRDJMSjZ6RG42aC9ZZHhQVHJyNDFxYllZQVdIQVdCaWltMUxpdTFpOUtuV0w0a2ZSYStObWl3UWJGNWJ3T2lDTzZxaTVnVVJWd1d5bTBwc2ZZU1dtZUYzQzJlbi82aEx3djkzeGxjYm5XK1ViNXlnZlpxeWZGb1lkSW84b09GVDNQQkVOOTRtL2JCbmtGMFNDYVNUc2hHZ0lrTUVrUTU3WjBtTlJsUk14QTh4c3g1ODl1UU4xSXVESkZRRXNGWGtRd0tKS1JIazY4dTZ6ekZYZEF4dWZiSkR5TDNYVEo0NFBHZi9vbXhTOGFmV0d5ZC9Hak1IRk9iR1h2VkVIUU5QVDY4Uis5YSs0eUlaa2QrNGtWYVpENTJUOUVDRElJZ2Zsalgxc09GTTh2T1hyTGlPaXBUbmRabFZEazlIaEhFNU9vY3IxSzVUd2MwdlpRVGZ0cEN2cHIzWDZqS0FZRTZUSjVDeUFabEdidTM1YlQ0VjU3cHZJa2pXeTVzOWN0N0kyd2JHblJDTkx5R09PSzFoazU1S1RnZ3EwcGxzcXJqZDZ1VnF0RWc2Z1F3S3Z0SHNqWGZYbUVPV0dCY0M4U1NjWW9KNXN6a2g0Z3R4M1RDMHhsclZWVE5EbThKblhjNXU0WndMMFQxbC9aeUFQNk50bVZ6eWl3V05TcDd4YWpLK0hNVGh1TmZBUGdCNzVYYzE2ZTdPZUFTT1hPM3FWWUNpTHJvQUI1eUZvbmhlWUljOStBdlUrZXZPeUJhTXZrZm9NTjRDeUZjMTl1YU9Yclg3OVBxVndNZm1OMWhrV3VBVUh2bWtaTjFRd1EzdkdRd3k4eFk4UDJDMGtQRGl2VXlsWVpLMzIxLzlsT3pwVjV6Ly91N2Frd0dPV1dSRnJrZHZkekhDM0tUOGhyck5JSnhtdFNUazY1a0FFczErU3hxMG1UOHJOMlZFQVFMTkpJWFkzdFhpalNLNktIV1JqY2RwcTBHc24vWEJVbzBZeDl6eHIrN3FvWDhQY1pqQkpxZG1WRGYxL0c0N2ptUnNyL015WUFwTHllK1p0MW15ZjFROC9qZnNuMHBkSVFnNHhZYUp0elVIV0UrK2huVXZmRlphTzRjcCtYUXlIK1F0UDNkMFlvRE4xbzdRZ0gxOEc0UUNyVktNYy9mWG9qNjh3VUFMNnhPNUVJWERxRTlFckJic0wwdzIvUFoyUS9rcUczVzRYVnRHSE8yRT06Oi3jmYLTV/l9WL0lBJywN+c=","831:elementor_0012a07","approved"),
("68","aea","2025-11-04 11:59:39","1","ZmZmSjIycjBuWFRQcUN1OFhta3hOUWRaVkd3TFNZNlM5cllTeVE5WklOOEkxT0lrOVdxWUlPVy9GSUphYnpabGV3eTVYZXNodVA2SmFSVHNFSWN1T2p1WCtWRm8zZUhRKzR6OFBjTENTYjZ2ZWNxUUNyRTM0VHBjYzN2ckRQU0lraGJuVFc4bTUvT3Y3eWxWWnBqVWtPR1hsMk52dGNRYmZ0RkMyM1E0K3lRZXJtNURPUzFYZjB6UmxONGFjVk5PWkJUSHpRSUNIUERkK1pDK0lEQTIySVhIZ1NBTHF5dDdMeVFuT0pjbXdqQmNEZXBGRUdwZklPU0RJKzZkWFdNdStwbG9yN2tiU1l4bHVMWkREVkN4SHdXWDd2WjdhNkFXMDZOS0ZhaUpQTTI5Zk10ekZRT2tuUmc4Uk5ueVRsZ1FXRGxzY2QwU1JwSmVMUlpRUjN6VEtzL3FNNUJScW53d2pvT3E4TFIvTEtndEVPNXhxMU5oUTQyWTNNemFVZ2tTNWlYNHBYWmJjUkRBQkU1UnJLRnVNZ00wVmlCUHdBa2dOYXg5M0kxNjNFTlhTWUlLMTdxMW8yWXFNVk1HVFcrYlZJd1djWksrdUpPVlE4eURtdWVEVmpBaGRrTVpSMkh6bVpmQ2MxWmtkcG9IYnEvOGJtZnZSQVRzSzcxL0hIUTBYYmQwMWhnNTJLMm5Ib3IzdVlQWDNUdUZwalV0Z3lnc0VXWmhVRjcrblhlaUwyMXNFZ0tnVi8veldrSzhBekZLUElSUWtTbWxMWTk2N1E2QWVaUlRFcHIvOEFCL2ZIZjUvelQ5dUhOdkFQMlF1a0RzWWhjeTlSOVpPRFV5S0ZCSi9SaWt0ekVXTlFlSHFYUmttTDExVnBxV1o1Wm9VR29ha3MrNzcxZG5aSWpNcE9paUF5aStvb24zVmpxRG1JUW5GOG5HWHc3TjRFVm9nOUhaMjRtbkxLWjROaDFVQVhTcTh1M3R2d2JCbGdiTDVwckgwSWpiYW9pTUc1MklHZVlsNW5Ca3ZMck5iajJLNmJFK1J1ekxTQ3NCeWxZc0hxSFQ2SitETmw3L2NIZnk2K1AySS8rTHRXTzRldlYyTFNJdDF5ekdINkFyUmRUSG5vS2pyYWtHakVBeitvN1pzdWZIR2ZIbGw4Y3IzRUc2RUoyOXU3WTJlSHl2cVRCeXJtcDVhRFgrZVJTZm00U0RBVlhQd2tOUmdUSDJOU1RrWDF4YlBhL3c1Vjl6c0NpSHhDU0hnUGVmUXk3bS8zSk5CNTVZQ0QvbVVJd1ZxY2F1OGxHRVZONWRGQT09OjrJCKu3pl7PjNSzRGKspHmK","831:elementor_0012a07","approved"),
("69","erheh","2025-11-04 12:01:30","1","bXdrb0Z5MDFJWEFQcSttVmMvYThsWFlsV3o3dWthcmNoblRTalpUVVAwem8rSm5iSmt1c2Y2YlNMbnN2bzBabDhRQjlRTkwzNVJTRjVQWkNGNjFldXRHbFE0d0EvZWNBVDZLNUlLTWEvY1JkTGt4Y0x6Q2FZQVFocUtxRmg2anRBemV4WmpZV2dTSTZhYUlRbzdvbWRkOG9zNCtjUExqTkMrL3lTWkFLd012eFd1aWdOZ0s1bWZmeFFJcU9wY3o3KzhaQ1hwM2RmY0VWeVlTQ2M2VnczL0tkWkw1azNJZVBHdDJGR2pkanJIU2JvWHkySHptUFRMMWkvN3lLUFJYNXdDd1pUbDdFZEZZSk1zNUQwbzZLbWNQeEo3MHVTTGtXSldOQVhDdXFiSjNRNkZ1OXdWWUxRU1dMTmZYYUJkUVZnaWREblRueFY1ZzdvUnh0NmNNbHo1Vm9meEplWDRiZWRLaTlGcHFxamg4SGI5YnRNWERvU2NvZklzYys1b0JCcUpBdmxjUGFMVGVWN2lWb0RvYmhqSEZRb1labEpvc3Q5NjFPdEpIUzI2MTQ5aEl2Ym4wcVliNVJIZlFkM2xmMkFRcUNCVlZXVytsaHJWbk9xRXNVM2FRemM5RmRxMUEvVFhEcXVadktSYUlNSUdWeFNLRmpRZm5DSUJjYnlWUjlzRGZrcTRkUVRkUEN4U3FYcndCZnZzajEyZm43VmxOYWQwSEFVUDl6d3ZRb0lzNDVvV0VrWC8vZW05L2JEK3lpemVqbkN4dTc0K0t0QkNSM2pQRlZOT242WWJFczVlRFF3MDFaZUFia1Z4Zk9xUlVjS1l2cG1rR28vRmdyRFh2N29HQUpxalVNdURrOGlzV2hGNE5iNFM1VENhVGNhUlZOd003eEI2L040Y3pnRy83Sjc2OUhFdnV0bVFiZW4rZjVXcWpMSHlEckNreVY5QkdhUjBFdHIwZ2N0ZlIzYy9ZVW93WE5LQm5UL3VsUyszMGJxaXBFVTNwS1V6L3NZWW1YN2RLUHZqTUZCQ0xycEk4U1NJeXhtOXhrTEtlOWx4NTBnamlVUzNxeDltQ0VIZENmcnpISGVqMUtzU3lFMnVnWmpqSFdjeTU0d0dkZHlCc2ducFUybHdhVy9hYmYvVjF1bE8xcVp4SXdSKy9tMTVCOFpwbGMyMjVza3FxU0lHVzhzb1ROMlEwWjczRlAxUWJPS0lCeTRkcG1yMGxrUytySVdzLzNKaVNKL01aUzJGSzc5SE9sektPdVFETzFVVmlrbW4yWnRXUG9haTlsdy80MU1HR2w2SmEvZEFrQlpySG9wRy9YYk5DbWYxMD06OlncMG6/Ynid2IJjJR0FtUQ=","831:elementor_0012a07","approved"),
("70","ztZT","2025-11-04 12:05:48","1","UVZSa3dieWx2STFIc2IzNHNnNDlRcjk2WUF4L0o5d1ZSTzdxdkR2QVExSkt1SFlLOThBcHR5MTVGZm80OGJpTmErSDRaSGhETVdhQmtFZUJ1K2RLM1VwdGd1Vit5MXBJenB6S3RFT2U4Nks0U2RIR3JCdUtGSCt6d044dVNxVUlYVHJjeGNyVlNQYVFBMEM0MGN6RVVlR2IyUjBSdU5RQW04UnhQVUJTdVM4YndkNzZDanFVM3paTnZDYzJ5OVlVZ1R1VjhZRmt1Y0xzazBYVDV0cDZRUDFWVkVjZk53TWRQNXhLR2FwTUx5T3ZzZDVXK1B6bThQa1k4R2VTUDFhR0FLU1NxanF5enRHaVplY1lnRnFmZG9WWEQ2Vm5rZ0JRWEg0NEdqaFB2SUdEdHMwNjRVUUVBVElFR0dTRVp6VVA1ZER4bjFFcGt5aWZvbHhmbHFJVHZhVzFWS3NlNG1BTUEzUWlOS0dMNWJCc0dPNHZ2TU1ONENGZ1dyVzFBTEE1OUVMMzJPK2tWaUFhYUFWbzlxWGRUVDh1dWxRaVRRVW83VlNiajdYSU9vcDNVQ1AzQmN6ckZRUFpIZ2xtZ3huVDJlU2pBMnk4aXB6WVhOTW83dFA1OXAwM05vUGVVcndVSkFXVU0vcnNHU0YrKzJlN2w1dHg5c1RnVnh3RnF4Zi9WVUIvRUpsSzJqcVU0MHhvVGljcFRTMGRxWWwxN0Rnc09NdUM3Wk5UaldYZVE2d2gzWTFtMFE1cWZnQlh3TVdxNXE0RGMwNVd0S3BpVUVQTDR1aTJRZHBkeVZwb1NZcWt4WGYvcDZFVjVRSDBhdDZTUTNZR0pWbTQ4c3R0WGxYR0xzaE1YRGhtMWtXTDZkUTcxd2dEWGwybXRrMENjUUZleGJWQmtFZ1RaVFVxYjRSQ1lvdFUra3JXczhaeis0U2tLSmE0Yit4S0xwQU01NzdFbmluT0hwL0NrZUIxOVI2VFVvMFpieUdMdHRTcWFsalVMbHF3bC9nNHF3ZEF0K1hBaDFqNWpxSllibUN2cjdySjZIMjNQbXkzaUF1OEJPQlJGa1RqS3pkZU9Ibnk2VkVGS3RmZjVFQUNMUDdyV1crSE1lRVR5U0drTUpsV0dMYzlqazBiKzNtQXN2M1RIUURuVlJUQWkxNlJpVnBYcGZPWm5DcXJmdnZyUklac3NxQzViSTN3RVhibVZqRUE1RmJXQXhBTUo3aDJ1VzJSVDFYY1NKZ29vc0tvRGxFekhpa1FMT0NvWmlNdTFDMWV6TXBzeVBFSDRScXdpOWo4QzNmZE9HZlN6cEw3Vk1RVkxDcDMzd1lWSXVmaXNXWT06Olz+8p97C2P7DCgDvsE7olA=","831:elementor_0012a07","approved"),
("71","srt","2025-11-04 13:57:08","1","SXFIdTRULzdPMTJXbHhhRHU1ZURYU29NWUlqd3NEbi9MeHQzcXNQS0FNUzEvSVN6eENjWTNDSUFCOGdRWi9Fa0Y0eHQrS3hIWDBxSmdFRkxHMG1zcXNHVGNSenpkazlNWEVzR2Z5RDNaWks3c2VzSjBOYytIMWt2MUlvVktIWFRmc3U3UGhWcis0Nk9ZL25CNkxXVC9mTlZISlhEeWFtQVNOcUVqZkh3VjBJSE5NV3dEZjh2dUZEN2FXWTZjVEprLzlGMHJjenBMTUdmenpNVk40SG9wRE9PWG02bTd0UXIrOEJmemJqb1VIQVdMUFNCZnZzcTVWV1o3MHAxZWpUUHZtKzZDUkZ4bFdoYzZFKzl3Z2dGOE5SVnBRK3NjTlVhcjRLc0JScDB6eTJ4Rzc2dU4yaGxaKzZnNEV3cFEzdFRwbm1vL0JnMWpQc2xBNUNmblRGdnUwNXRramNlelJ5SmNoSzVZWjdoeSt4bHNYaUNzM25GV0ZPdHdhVGlpSTRVVkVzVksvVnpvT21hQlJ4R2M2SGcyNVNhRy8vTWxGWXM2OUZ4Ni9oQ2YwY0xkdGhXeHpIb3RUQ0c5MktyMmFjcjhtMVBiS3ZZek9JNnhGZnYwbHcrYko2TTVCWkdHNUdtcm1JVlhPSDgvczZldWtlTUp6bTNwRHBHNEsrODk2NFBaSVV5SnhCR0JNMk52OFY4ZGJsQWtadmV2UW9qQStVUGQvMzFjYmhxdFlOc25vRndrTmoxcFRJOGhrandtc25aeGorVTRtVGZtYkgvN3lVWU9SanhsYnkrcEFIVVpNUzUyVldBZUd1cy9NZUZ3SFNQYzQwdmRFMGtVR0l3clRFTjJORzFNbDJTUVRPWHpqcHZ2V0x6aVNGRXRKTG5MdWV2NkZLdXA1ZzlZYkRSbUVQek5LbWRxRXdLdnRhUmtudGVOeTNPYThEWVp4QkFMWWcxQW9hekZkSEpwZEZ4ZjdJWklPV3Z1dGlNOWgzOXpuR2JQdWNQV1VJV0c3L0p2ZXNxaWZlcE9aR25DTllQWFdrOVRoMW4zeExycXVGZlhyK1pDVTNOTVpYYmpRTSs2eGYrUWJGa3J1T2ZKL01mbml5RzI2YnFhblRyZ25XT0tJS20wMmYvcEltUGlGSEdFNS9weVhSV1ZabEVqTmZnYXpuM3M2UzlXbGJHWC9adU16Uk9tdTJlc0hiKzJDU3NMRjZYbXh0YTM2R2U0V0hBWTJ5SlRQOVV5bVNOZGhTMlpmTGRQcHlDN2ZobjIzdHV5Z0hFZlJkb3VCN0Q5Yk54SjVSQk1KcjFIUVJOQUdPWWRCWkN5M05ic2xBdXNmWT06OmFYC2Wyiv8/y0L9QMm/uzs=","831:elementor_0012a07","approved"),
("72","QUESTEL","2025-11-04 14:02:35","1","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","774:elementor_e113d31","approved"),
("73","QUESTEL","2025-11-04 14:03:24","1","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","774:elementor_e113d31","approved");

INSERT IGNORE INTO `wp_f4a5sfea_submissions` VALUES 
("74","zz","2025-11-04 14:03:35","1","ZElqNkVtQVJ5ZGY3ZThwbWUvaWgxYUJlaE5DNG5kSC9TRTlEWWUvazFaRUIybnRFRjA2WVNjN2NwTVJnRkt0b0dmMGFLa2ZEVjhqTU01ZVh6REQ4ZlNodGZTSVV1eWppMmNRdDNHdWN0YythUUkyaHpTVW9IWDJYWVczWDlIT2dkam1OV2dXVEhxMk5IR1kwNElZY1pkRkNXVEpQbytJMk16YWJUSUk0WWlHVWpLSjBOQ25PYlYwTTdjZ3VjbzBuR1p4aEttMS9kZnF4SUxkMG1WaUJJVHBsZUtCR1lQVkNjYXRrU21PZVFKdTVhRnFtY1pVQ2w0aXhnejRRWTYrQXhxTzFiNHZXK3VVc3MxcFVHbDZ2VjI0K000Z2p0NVArU3VZYldZTnZRUGZDdHNTaEc1NVVsWHRHN0ZnbzE3WTh1bnZkRlVOSW9mOFV5dTUzZzE4V2dvd3I2ajFqai9ZK0xzOG9hS0s0aDRHRk9HWDcxNFN4alE4cTVwUUlZVzNOOUtSL24xSnFIVCtxOUJIQ2JmcDN3M09Wb0xwb3JGTEtFdmJRN0ZwZ3YwWWVMWmc4M1FZSk1UNlZobzFTVWc4akxycFRyTGxwTy81VDM0cUVJU2pDT3NNMU40aDRwYUEvTEZJY1VLS1RRMUcrV0lnK0d0U0Z1Zm9hS09aUHBjWC84REFJK0RkK2hockFYR2llbEJ3d1pvTnhYWW1IN01RbmNUS1prWjVhYTBJUkU0a09Yd2lRdlVWTm5ORFU4Ym5NUW1ld214SkxUMVJ5SEFMWUNnUlBuckVydDR3RUV0eXF0VTJNZ2xDSU94ZDl6NWloRm1vcEw5ZzRCbDV0NDYrL0JtQjdrZ3dEMlZ2enV0TE1tUzM2OUFhSS8rQ1VQUnBMUVlsamx1MllDNFRHTHZ5RWlweWJaUVF2STA5T1ppRmFHVUpiMDNoV3JUbEdhU2JnQm1ZSzRvTXRSWGE5WEhobWZPbm1VOXpGbkpmbGNiRzM4WjFVNmtHZW92Y05rTm9Vd1I5V3dOTWNEK3ptc05lT2szdUg2Z01YYVBGNG1ib1EvSXp0ODN5WEJlN011WUUwclFDUkI4NGQ5U04zM3BVL3RnMHc5a2NOSm5zajhFampPQ1JTL2VrbzFRbGRBcUtDc1MwREptSjM3UmxvblY2VXNpYmFLR1gvc2Y5S1VIRUpxbVZ5UE01dkd3cUFnYThpbkdHUFNjamZpOEsybHRLQmRzQVhybENpZTlET1VUYkdwaC9xeCs1RDlKeTVDNXZoTnZIRnRRaWROcmxYNFFUeHlwQTh5RzNoSFQyQmNLM2NlQkZVSmFudWdSMD06OtpyJTp8HuX0yADFKLeaJWE=","831:elementor_0012a07","approved"),
("75","her","2025-11-04 14:03:51","1","RGxraHd1MWhKUXdrWmVmUHF1bnBpaUFhQThXeG1EVXJMdUFaeFJIRFppYWlmL3ZrdCtpRXM3UGgyR2xXYktJbEVOOHBZUUZGZ3JHaFUrVnIzSkJsbDlFTXo0ZWNCTzJLcXBpeFNoS3c2WlRpdVVSQXM3MjZzdkdLUWNSejJuQUJHT3AyT2tXR2hSam5DdVpIdUxOVGg2WVE5SW14RTA2dXo4RjByQm9mSzFHcTNCQWY1WFNaQWhqSXJrT1B5NkFaSkcwRnJvT01FUFhWMUpjYnJ2RE5aMVFZWnMrT1h3K3NOeGpsRjdlY20wRmJvV3l2azRjdzZhbTlSNmlQeE9tRWNIOWNFT1g1OWxJY292NHdsN2lZZFdlTTZEZjF5SDRNVkxKWFdvNU9zdHVwMGpabmN1SlNxYWJ4azNoNks1WlNNeUI3YkMxTU5FZlZWTndWOFB5THN1YTFvTHZ2TldQSzlOZnRhb1FhNENDQS9MR05vUFJWVUNybVgwRXk1L2NpZUlicW9qUS8xOFhTaWY0d1hQNGxtVldiZ09JbmE0NmVHc3pFbGZOVzdSRUU2UVVsVFcxY2QrMXBCOXFxVUt6MFQzSFRrbFJDNHB0UXdoZ2JoOG9qOVFnanBFZWdUbzVlWkp6VXhtSUtDRlpVS0kwYzhOa2FvdGlIbXlpYmMwQmFZVm1BSXh6K3ZSTUI0a2xDMXJMcE9PeEh1U0JsSnpjZ05Pd2hCZFBHNEd2VnhDUExQR3ZlZTVZWkhzRG5VdzNjYWszeXVJZjQ5TUUzWWQxWGNSVVVtQ2JmWW9EOXlZR1J0MXVieWFPYUpPbjlWd09JK3dGdWd2THAvRkM2Z2xHbjg1eXo3RHJ5b1U0MXVOZjM3R21sTmNQOVA0MkFPZWlnMzlqVzhEMEVHWVJ6dkhkbmtsWExVOTRiOXhtVWRXNWxCYlB2UkhWUlZqUTdMTXBZQ1lBU3FTTmRKdVRrNTJWSDJNUW0xNmY5dTBUWW5OVWFJWWx3cUJWanp0ckNjZ1Fmb0xwQ0F3VUljZE5XaGdYcmhVRzllbXBBdUtGN3FOSERiMU8yMGZwM2pBenFnWEN3SUxJVk02bjNzRVpwaEVUbURiSTc5R3c4cTlYTXZSSkpvbGt2aXM0TEdDYTJ1VzR6bmpKVUxjdHM1WEJMWUNzMDBGVGVKNXFrRFRadE1iaDBqaERMditPanNjRjVsR0FOZ1BEcitlWTV2RUtSUDczWWg3ZnJqZzJDblBYSzA0OGlVaVoyMlhoWEk0b1FaZnZ5TzBqOGRtNnNBbVlCR01YTzVMakNpWHdlNWJ2aDlkM0tyMER6aVJ3YVluVT06OiH3UWXs/oTUqNR8HADJXRo=","831:elementor_0012a07","approved"),
("76","QUESTEL","2025-11-04 14:04:40","1","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","774:elementor_e113d31","approved"),
("77","zzafar","2025-11-04 14:04:47","1","UGJiYlA5anNmcU82UEdLVUlaQ2FHYzBFcC9yU09QTEx6dzg5aTQrUzQ5THFCSDlEa1FWUi9mdk5ZZUY4U1ZVb3REc3FScmZMQktOQXp0UHBwMVJKZExwWEtkYnZob0h2bEZmaVFQdzViZzlEYXFCRjU1ZVhDdkRKYURuNDh0SXJSak5Xdld5MWlJUlAvdzhSSFYxeFhNUTdMY0RjVElKenJ6czF2MVJrZ3lvVmVwejFYck1DbEUzL3Q4RWFsUWdHVkdjYUVJVTJXZnJ6OVpTVFRvOXQ1anZMZ2RZQi85Z1ZaMmlyRjRWY0M0UWNaSndaelI2NURMMnF1M3JGSzNSQkFmSVRVNVU3Y0JKVEdZN2lpT3dZYm04QVVLaDEwOFZvWDFhdCtYUkFwRkQ1NldGMlNPVXpCbjdKOWtUM0xQM2V1a1h0WTg4OHc4V3FJWmNJNk5YS1ZCUnRDU1lZRHBPOCt4aWl1MGozdllCdFJIWUtmSWZzYlRwcVRTbndQcisydUpjMXFNaklDTUhxYWtzV2xsaVp6Wnl3MWd5akdBcE1lMmdNSzRYbUhsZm1QNHVpbTBrOTBxcFErSGRKdkRjU2RJcnA0UkRrSEZIZVExNkRuNnROT1RwT2IyMG9iZGtPa2lMd25zZkhVZm5uVWdPT3FTbDJPdjlaZ052Ym1LVnhJY0FGVkl6dTB5M08yR09WazZhbHlacDlhU0pNaWZ1aFRvcWh4eXlveDN0dnpsc0hGazRzZ0V1c2QrR3VjazZlUlRiMDhYWE9ld3FkUXpIY0QyWkgrUnc4ZTA2ZXlBeDJ5NUJDVFEwV0plQzJWZGtNSlE2TDl3c2NnTFFrekhwQ1BUUkgyTlZXMkpDTG1ZSHlnang1UWhweUIwamtLVDdCSThQaWluTUFsaDkrU3RVQjlCS1pMSXhUNDNZWWVXSXhxbnIzeHQvZWdpdXlxclNVT0NqNnc3OC9CZlAzSWdhdEpoV1FZaUFSN0FTWFpKbUNlN21zVlB6MGZkTEg4OFN4c0xPTGRXbDI3MVZDMVV3STk1S1JKUVlmbysreXNsdXNxQmdjYS9qbFlpTGw1ckpzbWtzNTJqRnBrRjJ1T3JNcVFhSVpoL3lFcmNWd2pyRzZmdTdVU1ZneHZwaUFTV25GY0U1RWF6cSsrY2xBMkhaT3dWWlZlMHdCS254YWhsN0NCaWNQOGVwWnFESUEwYSthKzR5bkkvd3ZOeGQyTE5ZV050aHRHaUpHQlcrNTByMHQ2TWhFZTErWTdrQnJyY2hmcmpVdFhDamcvNHB0aDFxTjMrMEdxYXhWeit3Ni84cFkrS0JacFp6d1Rybz06OjFqUunaNTJb7sBVQrhRerc=","831:elementor_0012a07","approved"),
("78","QUESTEL","2025-11-04 14:05:12","1","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","774:elementor_e113d31","approved"),
("79","ar","2025-11-04 14:05:20","1","MW52SC9wMmtjMVZ5bmZrMWNYeWMvVlFTSmErcGxyek1vSkRLOHpOV1RXdEo0MGVMZXZxbGZ5RndSOEJjeXByNHRPYU5jaUUwMjR2MmR4UW1Gd0FESFA5WnpOZ3dEcElPRlJOanRFU0FhWFVLMDR4SWw3NmhuNzZvVEZ2UlBtZGdqNlhocnBTYXJLSUtWelRnVFdFT05OQjFFQzhEYWFiNlhuSFBrdWVuTHowbi8rclRXbjBxRXF2dnhLNTVsS015Zlh5c0hOWExxWXNkTmxxKzdJVEhZeHoxRjYrQlc2Z2NpTVVwMDV6ZEMzb0o3emRUTmpRYk5ZQVNaMlFYWTNydzdabWFaVld0T0NsTU5wUGEzalIwR0p3NmFHbk9tU0tlK0RjS0tCV2F2MlA3RURnTzRTdjNVYWY1Uk9ubmFrQ3UrYlNkaEZiOFR5UFNCYTB1ZElMMHlBUTdPcXdPRm1FMUlWZDJqdjVlQ2lZaktweDBpdlZNK3M4UXE2R2puVDIwbzV1R2hzTFU3cEk3TDZQRWN4c1ZERjZpNzJjbUFLWjRrWWRoa2VDdHAwRldZWnRZYkp0T2E5LzFkalFEZzBWOVdOOVk2amdtR0s0Nno1b2VmTnBxUUh4UjNCa08wZFIzd1dxbURpcnh4RWtqVFJEL2RGaktRT3JzSUIwbWk2SzNzQkJuVEs2L2E5UVdRa3UwcGpCUllKTVQvU2J6WnJOajIxMFdjRHVXOG5xbzBBZ09MVUoydUFuRjZ1V1MrUGlCV1A3S2xVR0thN3JWd0FBQUJJY0tTN2JlWlNhVDIxczJySEpFVk0wRDBhWU80aDlGZm0xUDJETlhSZW1PSXVmOVg0R21oT3dSaXBET3NuTWpBektVR3RGS2JtN0dRb3lIQS96eHFwQlYzd1RscWc1NVJnMmpySE9MMDBRNGE5QTRZbW5Wa053SnB4dlEvWktuQURnNzN3MzdtdW5VMzRwKytybjJkT2ZWbW4xc1NvVkJUcElBbE5uZmFMY0t1R2pXY05zSGdJdm8yenN1dlR6TERXajJzaHE3YUxDTHZFOUxsaWU4MDR4SStzY2IwbkxQUkVMUTZ1QVRIcFI2WkVVblg5UDYzL0plbnF3YitSMkZiMm9yeVA1emNhT3hUV0lITnNhYmJVeFJKdGdLMHFvT3RTZkNnckRyN2cwV0JoOHBUcGZXUmZZa1lvN1pLZ1JhQnY2RzlaRVNyQW5vQ0pWNDUwc3NpcDl1MU1iR21pOVJlVkJoUWJmcFhIdlA4NlpGMVFVclUxRFQ4d25hTDE1MHI4MkQ3NFA3WTBJb2RMYmM5R2U4YlZSMnhLcz06OvfkNBbI7D9+hTiuC4FXhRg=","831:elementor_0012a07","approved"),
("80","QUESTEL","2025-11-04 14:05:31","1","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","774:elementor_e113d31","approved"),
("81","zzafar","2025-11-04 14:05:37","1","cm5ybi9iSmhjdXdTTW1rTXFiQWxEQzRMTHoveUpCSGlHREJwYjR3YUNuVVRtVURSOFptaDJrQnM5NUpDOEdTdkdVM0ZKTHAzenpqbU9iSU5nVVlWSUVjUzlyWmhpSFErQXZ1L3pPOUoxbU5waEhuN1hqNUZ1U25FOU1BVWh0enVtekpveFhaY2F3dnJZSjEzK3JiTmJuQ3h1SnRRTE9nWHZVUlByTDFjTEtydVYrVlpxOE5lSXhsZnErZWU5bHhGUXhYdGVnb2pyZkY1YUlRcmJzSHExZ3l1Q2JHSnJQMnhPa0Z4bGJtY3lVRjR5K3BBY204ckNManlxTm13VWhJelRnWUJFUXFhdDFkK21QcEhhcHNkeExoVWpSWm5LUHJJbFBEZms1RlBvNmFZVkFGYWtMc0RZZ3pXSGRBeElGSDJISkNpeU9mSVVGTmVIanpVZFQyTEM3SHdEbkV4YjdycHJaaUR2THpqRnJsbGVJT1YzOEJ1QnYvYnViL1BQOGVMeEI0aUJSRUpNa3NqN3VOYnFZcWlQNW9BOHl3OFJGY25CdmtRS2hSYVNDb20zWjIyclo1Qk5ZOG1uaGJMNmhzR0U4clBmR1QvWkdBMThiQUJKbUhsSDlpVlRuYUNYRUhtQU1XSy9sMWhuR3FYTTZkelgyam5wWjUrenpGbHJqQXpWQzVFZXkwNmwyT2VpL1lER3pKazY2ZkdwcCs0YXZhemU4UllSYUY1SkUwa0dIUVFoUXFxaWlRSG1MYVFVWm4vdzBvbUl2S2RDVXlINUpPZVIwMHVJWHpoQjU4MHBrdURpdFRvWDVWT2l6ZUdyU1dZbnI3RUFwS1I3c1Q4ZVRWRzhxZ0w0UWwwb0UvanY3clR4OEpsdDAzOFNWUis3cFZ6ZU13eHRFRlBtOUd2TjU5T3dKVWhKT0dJV1lET0hlazYrVUFKa0xHOWxPS21Mendwc0RHOW1STk44S2tkVXdtMGE5em5ZNVBaOG41cWIwK1lkL3pwa1hvejd6cHhkTm9kZXh3aVArWmcwb3ZGeXV6ZHNmNXpUVkJrYlNNSFlEZURicGtsdDhFK3E2eXAzbVp4anR0Z3lydVhXWk9qWVg0U1lMSG83bVJ0OHlxWk1rTHhUT2x6bVNiV0dkTzZyQTcyY282ZllyL1FST1pHeW1ZMmFBZU9GWHRZZkVkNDh0dXhkZ3Ntck55dEFnM3JBVEpGd3B5WG1hQkh0SFVRS3JwZjg4T0ppTTNoZHRtQVNvMnAzZzUzQlhLR2h1WmRZeGxteG5ma3hITkkvVURXRkQrSGxJRDI0QUt1T1FCcGIwL2lYTmN6aEt2RjV2Zz06OmXmHKG13AD88UPEOORRZk4=","831:elementor_0012a07","approved"),
("82","QUESTEL","2025-11-04 14:06:10","1","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","774:elementor_e113d31","approved"),
("83","zzafar","2025-11-04 14:06:17","1","YzhDSDBIZkhlMHY5N0JUYUxLd3N5bDJvR0tWd3JBNXdCOUFpU1lVZXl1UzIvM3NtckJDSUZjLzRNV25TU3RxTXVrWCttTEVJOHhLUE0zc0ZBVWYwQXM3Sm9vbEI2WTVUVmFkUEVyR1J6dWtZVmdHYWZENTZkdUQwN0dPS3NlbmZNR2FBY2Q0VFBXVnNjMldJcjhzQlNmazRTU3oxMXd4K2ttblN5WDNjbFJVYjZjVjMwZjhlNVBsakMwc2FHbVVTdHorUVRja3ZvOGkyMmZRWW9JOUJHY3FDamtUcHcxc2t6MGlhbzRYczJNa1cwYVRqRlhVNEplcHYzOGJyN3lWbnd3TGcwOElvbXUrVGoranpJTDVZNzdubEFYWWU1VCtEODBBNi9rOTExZ01rK25XYjl2aytwT2U2RS9JZXBpa3V5NVV4OEEranhzc2lia2pHekdzSU9lS2dJRG9UWURqNTVNc1VuYVBTK3R5bUV6c28wbllZOFMzSTZZbTc1RXBWSmVjdG5ia2dVbFNLR2NHSG9FZkZIM3F5VVFRNjBjZS81QVNCOUxseE1sZlM2QkU3VmNFMGthb0hPcHhIYzZnOFF2NDM5ZFF2bFdvalR6aldtVmFXSzcvZWJNL3N4SmpzOTV0OVRiYXFwdXFiNUYwa0pydjRNV2pUdHFkSkEvYytYZzdzSFE1VTBBekdQRWk4YndiZnR3RE1ZSWxUQ0NoOTBFZmFEckYxTHIvSWNnd0sxS2xzRE55U1ZFYzB6Q3hNOE1OZlVhVTF0VEl6UnVHcEROLzRsNmp2OTgxMXJyZk5xWkdPaTJjb3hoVVRaNXV5UDBRTHJ0NXV6M3NJcmh4ck1xRGZBOUVsMDlGL2dYT0dDTElESnNQRHlPbDlCZ24yNTVSb3ZtT0NpZnZuekErN20vUjVuRnFudXA4MG5HTmVHSzF5cHRSSkZyVnB0cFVJUTZCUng4YlJldW1rU1hIMnhXUXFjTXJ3QlgrcytFaHpRUWhHakJFRWxkeUFTd3pRMjVYUlFIWGQvMHFMblA3dG9FRTlvdC9Oa0ZDSW1PK3RBWUMvWmxvRStUWlhRZVpnbVdBSW8va3pzdjZ4UXRIc0hFWmY1Q1Q4bXNPS0JtU1F1eWpRU1pDVUZtZkJNdEp4T0hqYWMvVHdETC9YVWQwOUVHR09rRlQ0elh4eTFoNUVaRmxLdm5ZdDlzOVRROFkwQXhTWGZ2K2p5Y1FHdGh0dno2ckZPVFQ3QnFWeDAxemlUd0taV1U0VHgxWW5HZkJmV3A4c3ZCNXRJWExtWlE4SWs1dHpQYUpjeUFYTE5sdXV3UURaUHh2a1VUUT06OgdWs32+qBgFgNL4+paHuP0=","831:elementor_0012a07","approved"),
("84","rr","2025-11-04 14:14:37","1","UnJhbTZSNE5QSTFxQVJZSER3bjIvMSt6WTFNNm9pREI1NktDOEY2ZjFoTWRSaE5wTXRwdWFzL2lYcDg0b3BmNjdJTzJ1K2M5YzBVbzlnanlNVHdPS2pwN1h4Y0tENkpiNmcwUTFDY1FUNkVnT1U3eFovQzdTK2J3bXdjRHk4ZkJnVm9vQm8rMVlFclU1bnY4VjNGblo5ZGlNWTlJUTlzOUdpczZaUlhsbU1qRTdxcEliaFBhTjdobmFIMkxYNmQrZlBzSVIxSUZQcnBqWjN0RUtFRFhWSjJOM1lBR2RkeUJ4RkU2azdhanByOEt3clpBTFVzenlYaGFDMG53YW1IUzgzbzBlNnFtbzlZdXJValhacjNsOEdCU1JZcEFSOWg5eFd5R29YQlpNRzUvRjJoVmZsSDhKQzhaQXBhVWEvTkVNMTE0TGxObTZlUzA0M1RsRDNZSFpjeENkb3U5bzhMbit3VE5QK3FWbzBLY3J6NGR1L21LVERtY2RYbzRIOEVtaExvQXR0b2JBMGdQem16STArVHY0cTJtYjNqbUZQYWxrVitnS2wxK2dIQUxXYXhicnh4UjNtaDhFWmZ0dGR2KzJJKzZZaWtwZFVPVU1EZTFEUkREREdhUHpjR3VsMDJ4djJSejN2d1NGM2p2cXdYRDExWmpleGVVM203SWRNYUZhWXVnY28xb3ExNEc0ZWordHQ5YnRFS0paaElxUWM3ZzMrQjFqeitWS2FoRVJvcTlaa2l5Uk5LdTIzSlBWUm9mQWxtQm9hdXZOMXZVODhKakZrRFRva0VFVitrd3RqUHB4dWJiSXVTSUxUeGlrbm1NUHFMNm9qc2Q5OEVyQm1QT01YbDVTYUNIRG5ab3I0VVVSdEhVTU85Q3Y2dEFpNEc2K3pvT1hrR3ZOVGZOKzRpY09BRVdIVWdXZytWdElQMDdpNVlxNVNRclBvaWNycjEzRGFNanhOSGpERjlPT29wSGg2cEYvSWZqM1ZyTlN1RmlmK1hjTytVbjRvNkRWOERISnBKZUJqT0dUSzl2b1J5ZjA5M1EyWmJsZlpRRWJPT1N6NDA4allsaVgzOXdZOVFZMGlZbjUrbGhJTXFPWm5kbnZVYUgxT2JCbDE2bStvMzhjL3VsR3oxcUd0WEtPUVdNNVM4VDVJUnVod3loUzNibFpoN1ZJeE44SHk2WDRZZWIrb09NL0tGaDQyb1FseXpUVk5DbnZlVUlyV0lrYzk1SHU1WUdsNDE2S3hwM3YyYnhwdE5kaDh1aEN2eVY2MVJVUzJSeTlFZ3ZQRXlGVVE3NnBCUVV1MEFGb2h3c2hPbE5hVlY0cTNVa1dsOD06OuHzlsuePHu6mi0S6PnFTxY=","831:elementor_0012a07","approved"),
("85","QUESTEL","2025-11-04 14:21:44","1","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","774:elementor_e113d31","approved"),
("86","zzafar","2025-11-04 14:21:51","1","eld1SmhVbGpnbHk1RU5nY29PQnlQNFk5STB1OUJxUFVOekVVN0lKK3IrL0JwUVAyNWwxamhreVM0bGdTM1NTNisyNmVnTXp4VlN6OHJtSUloSkRIejZiM1RjbkxBWlphT0hTQ3M0QU1FUnplWm1od0w3bXBDMk9FR2gxZmtOU1hUbUIrVThpZ2JFWjQySGtqTVZrSXdoR1FUdENIYkdFb2hKZXZlaE9aZ0RTMEFNMm9wYU53SHE5TTFFdGZleDVJK1ZSK0hnM3BrWXNmRk9SbjFSTDR4T1RtL3RhTEhmeEtJTkhKaERUT3BGcXNub0FCL0piSjM5WGV0SG0zY3J0c1R4UXNmRFhVcllvUnhQaFlUd1JGcEt4Q3JIZEhlU0dyVUJuQ1lHcFNLdGIyVW9tc0c5VS9VUlZtOGhqQkxHQTg2WGdneEkrOEsrSG5zSnNrb3MwcFowVXR2RVAzT3VTUEQxV3UwY0hwWlFOV3Z0UkJaYUNXRy9XbGxiZEdDR1B6ckZzaE5uSnNOM1VmdnVxMk91b3VZVUFXbnFMbk05MjgxMnJKbUJ4ekcwM29MLy9FS1pzS2RjbG1CcUdncHdGV3gzNXAwM2ovY3h0VWE3YytXaGFYeDBTT0h5TzBBNnJTK0puaXB2aFNPaFZPU2gvRjg4WlZKTmFWeFFpb2dwL0I5S1RCQkdXc21oaWFDVzl1UVhUM1JveVBneFd3K0xNMjMwSkZHcGpvMVhmQ1o3ZWl0UWdqOEtxWklYVVZiakpNMDRCTVU0ZUdHWGFESFg0TnpGM05EZllPUDVUL3VUMjE3OTZQakpWVldrV3p5cWJkNHZka3NKWU5mV1laVDVYNjRlREN0Y3cxWW1WOTZOWjBlNk9VOUJJSUM4dTNvd1o2OGZKcXdQYlBkOFJ3TXh3K29sVk8wYVpNQit6QWtuYS9ZMkJTUFova1Q1empwVy94Ym9RbGJBTVBPQ0hSWEZiQldOUDhVdzByaFA4Q2JxcUY1NnB0Mks2S1o4NnpHRWVtZnovRXpGeVZtNk9kNzJXa0tFU3dBN3loNk9Yc0FXbVhKTW1FM2xaaU5HUGpoaWJCcjZNYlU1NTVOd3dZVXV5cnRmU1cyVXhCeTU0RERldzdCN2tHVGNyT09uRlJvSUpRZlZPWjFheWJRd1pjaHVqYXdzNWtBKzB0cWJnNFcwOG1Bckdzbzc5REsvVkRsVkJLanNmeS9jMlNYRHpIejYxakhPcmQyLytJeUZnSFFpRytLeTEyY3p5QVBNbXJOM0JBaHBFZlBBU2JhdFUwS3RBZVIwd050TmE3c2dPandXRDhITW9YTSt2UVFyYz06Ote1zQbj4m2BoD8x5Y+KJwc=","831:elementor_0012a07","approved"),
("87","GALLAY","2025-11-04 14:25:51","1","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","774:elementor_e113d31","approved"),
("88","a","2025-11-04 14:26:03","1","QSs1SXR1Um5hZEVVRUYveHZEalN0ZnpOaHJxa0NmMUNzT1lQeExPK2Z3Y1pYM0dBKzFIMjVNTEFYRUw0TVRsYTh3VzFPNkZjazg3WlJoZG92aytYZ2Y5Z25PZm1jVGdLckx4UEs4YTNOQzhnNnVUYTFqMkNTcWlnanB5anpiL3RLZXBzNnRiMWNRaHNJZnJ1UjZxYXI0WDllSUg2Y0tRTGN5QUZYaEQ2NHE2ZnNua29ET0JMOFczRklaMS9Uc2xaNjRtR091K0V2WlFpSXVSYVZBWlZDK3J2UGtZb3RpMndyTkZnUHQ1NkN3QXR1Z1cwdlZpWGk2cGhiVjdyY0lUWGxzL0FPTWpQekJYOVJyMUUxQkJDYnk5ZzJEa29XUzFUR1lCVjdBSnhPRVBoaHZ0L1dwRVozZGtWYXBIcTZhZy83N0ZPN1pkaFBHVllFaWhJNHhLZ3M5UVBya3RXSXJxN29HN0VFTmJPM3cyMlRPRVUrUGhMSFdXZTZnNlRDVk4yMWxGN0gzU1dzQkhzL3RQaWRveC9GcXF0Y21FSGZ6WWppTnYreC9KWFlpMWR6VVlNbTFQa0lWczdpWTZSK3F6UUZEbjNuU0tvamcwU3BvWHVvbUNVSG4rRHYzKzdIcGFnQ3p3NTBBTS9WT3FNR3dSRnJVaGZkNUpHTHYwMkZjcmg2R0o3ODdadzVMdUJEWmlhZGdmNmZDN2lvdWpKdmNaYzR2K3FSblRCNlAwcWcrTDM0RXEzcUxWbXVLc2tUVEZFdjVLZUFuZU1ZY0Ywc2JiMzd5Q1hiS09yVTE0VzZVYmtzYXZ0YitHZ08xaTM5OXFGTVY5WnJ0bFNqV2NLV25iVklkbWt1SUgrMHl5bWxlNjlsZUpQVHh2Ris2WHpCaUNjclhIUEtuL21vR2pyaEMwVFd1N0xJQmtTQ3gyQTJXVmord3ZyaXJINHk2cmk0SEdvRTdEM2dCeVdwSHdycmI1dm5QcXV3Rks5VUpvc2dON0pFRWIweXJUYWlvSkFKTzMwNDEyRDBuWXBuWHdiZUpLN0VSMGxsN1pjLzhnVlJmdTNvc2RJVWJuSk9mUWRTZEx2RER2K2RHRlNOcmZmVml2MDJGbnlrbmk2c2M4SHVsTklhM0JQaytNN29Uc2I4a3lwZXUwMVlBTWRCWFdtVGllM09QdUROSGk4MmxqWHpsSytmNFZlZ1ljZHdXc0w0QTZRNVZSQ3UxL05FeVNlaVBKeFFkQXRSOXJLMFR0Z3ZRVmZJcmhBRDV5eXdNQlZzWWdTTE5saVNlNFBLVDcyYXlGNzkrcnVZUT09OjpshKFmjJWDWDaItm/im/OH","831:elementor_0012a07","approved"),
("89","a","2025-11-04 14:27:01","1","d2cxbXhYQUZQVFQvS1NpKzBVVGI2QnZkT0JpVjR2Z2wrdFVDdkhkekRvblk3eDc4MUlmaDBIZUYzZzdpZHA3T0dqbmQ3OFhJemFsU1JST0NiSlJkaTFsL1U2YmIvOGZ2ak1DOW9nRldCK0dYbnBscitLTTdYMGRNK2M3MnF3RGJoNmpuM2RtTjBzYUdGcXoxMnRxcThSZ0RDRlVXSHcyQllhU09mWTRDYzdjWVhiSXM3Ni9KRjMvV0dTR1YwMlhVZzdVSTFCWXl5ZjMrYjJBZmxZa3VuNVRldUNDekxuRk9jWS9XbUNhdFd6RmI2Z1RlK1RIN0hweWxRS1g3alVWU21JMC9USHozWTdmeS9RRHpHYzZXSGtmdm1KNndrMHArQUJZNlpyT1BSc0JLd2FQQ1M3OWR1ZStVdnY5LzJ0d0luRkxGRnBCR1JvRGJobU52b2dwZjRYdDR0cC9qTnkxNDJrOS9HYjhhQXNITEw2RHlnSnQ0YnFyNGJUNDNrVVJWck50SFZTZDk1b3lPQmpBSHc0WTVnQ0VhcUxQV1Q1WVI2Y05HOStXcDN1WE5sVzZSdU1rZ1dWTmtML1FUQ25tUmtyYm9IdUdXZnNwMHdPUjV3ZHFxenpvd25Xb1VFY1ZtaVEvT0cyTGlwdTN1ZlZhdTBidEVhem05cmRUdXRFdWt3TnhKb2dpSFQ2M1VIVWFBUzlIRXhvWGZJYzgzODdwZVdFcWluT2ZnNGZ4S1NBeHVEVXhldEFOVFF0UGUzcHM3dVpRckRSbWJLMEt0SVZiUVA5cGlWNXppTzZxcWdHVzZvbk1aVFJZWnhaSmpLdFFlK3hjb0NlbWxzNXVpM2ttRnBWK3kwZm9YUWpldElQUmFKQ2FmcDh5UXErcnBkTi9FRllITlEzYWkyME51clpMV2ZKbFdGRXRRSXZPbzVhRUxNMWMrNkNZTGJNUEFSeVV3MzZDRVF5UEZ4R2l0UVZnZElqQ1R2Qm11WGMveGhCQzZucWtjM2JUWW4wbmRJOG1TcXNtbzV3SFh4R3pCeGR0Ri9tQWhxLzdFWGRlRVFyTnMydnVWYlhJT21GMDYvN1p4Ykk3Zy9KMGRtWnFHNWpVZjZKNm5JUXdDOVNSUEFkRWJjcm1NWWZLS3puZkluT0N1bGpBdzlmN1RUc1c2enZ4RFByTGp0SG9rbkJYbi8vQ2tJL2pFSGwwM1p2VDNUS3JqNWFIeTUwRHZuTDNQZFA5VHhvWTZ4ZHlxTld2bzBFdmxMTE80TjAraGk4TlowM2QvOW1hM1VTK0dsQ2lNRjlVZTYrcGZ5QT09OjoxTEQ+B3+Y3s3g1LLaJ9Pl","774:elementor_eb5c8ea","approved"),
("90","QUESTEL","2025-11-04 14:27:13","1","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","774:elementor_e113d31","approved"),
("91","zzafar","2025-11-04 14:27:17","1","dVhmaDJzSWZrb3VzUEZqczVvOFdLZSs1QmZiZzJHLzRabXRITWJoSkZSWlRCTjU1c2ZyaHI1ejg2RFpaTytKTEY2eVoyKzZRSU93cTNYV2pId0lwaWpBMFdyWnE5TDZWRHdWcDBwV0VGb0poc0NGajJCamx3WmJtZUJWV3BTMCtodVUvbk91RWR0VGp5bGdQZnFabUFSeEtSY0ZQWUVYdzAwREhEbExLNVhla053Sk4vc1lnaDd2dkdxbEdQYmgwOHJwVytEb1liaUxJZ1VObjJmZ0JjOFl1YVMzQndGZ2k2UHVsQkE2b1IxL3o2WTd5b0FSNEh3TXRzYk5kL1hUcGtPSVI1TmhqMDJieE5wT1U5N3VqMmM3cjNKbyt4Y0lqQjFvN0R1b0dCTHBpL1V5N1BEVFNlbmpxa1dPeDdra3JTUytNUUdLR1NFTFFMVmN3ZXF4R2o4L1l0Um95U1VVT0drYjl0VHkvUEIxMXNPRUU3VG9taVlVN2tsbGI3dUtjZjd4QmRsa2FzMXdsQW5pdWRqVGNjZHFlWjVNVjV1YzJKclJUTmowekh1bVdsUWpNZU81VUV6SlpNb0ptUmdHNkdrRDJhUVdpRjZLT1BJYjBVeDRrVXd2N25RTFlyMkdzUUlUOW5zNUdGYW5VaG9Xd0M2dERwWnRyTWpoQ1phNERScTNlZmNHSVAxZWFqWkhTNXdTc0VsRWFCbEVLWjc0OXN3LzAzd2tIb3VhZTZnZS8rd2ZPZTRCMStlTnZQSVlJS2gvTVNCYzRXQy9zT083d1ByRVVKN3oyN3FDbnFmam43VGNyWkxiN3BFVmNRSU9XVmZlODJkTGtWenNPK1VodkRSS0M4MHR1ajJGd0kxcjZ4Lzg3aHFqZTh3aFlWUDlHMDl0dW1hODBoR3RoZWJQTk5aVUtRZVQ0RXorblNzdzQyNUFIMG1Pc2FPcHRjdHdTQkh0N3gxYTNuQkhrRS94VDJuWHFGY2Z0YitLR0tBalZlRklEZFdpTWQwY2ZqcFNsc3VHVFIyeHUrbFJBYm11U2xlc3lNUllhaDUzS1lISnNnR3FrU2lyWGNZQUJPS2ZFNFhUUFc3VkZuczhNRjlzdTRjL2ZTRW56YXdWUnJHS0dGVjJhNlJOM1NoRCtMZFR5UGNEbU9zNTh0clJJNCt5Z1pZSzYyaGNOK2tHS3FrRTc2UHpDT3ZPeUF4SElGRFBWb2dETTRmOGE5WHpZS2xIcnprbFZwYjRXWVNZVTFST0wyNk9tT3dwMlNFUGpYUUIrSjFybGM1T2NMQkRKdzBuUFc4SWhkSTRNenptM2dwUnlzSDVyTnUyRGZMRT06OskePRRyQrZCdJDdOchRHEQ=","774:elementor_eb5c8ea","approved"),
("92","QUESTEL","2025-11-04 14:27:52","1","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","774:elementor_e113d31","approved"),
("93","zzafar","2025-11-04 14:27:59","1","bzVZLzhNQmVnVCsrc3RhZXVXajBOeXJoQXBpYmd4dlFFVjBrS2UzUnZ2dmE0NDdkc2owdjg0b1lDV1FHN1hOUjhYNHlZNU5ITFZwdG51WnBnbk12TlNTZ2srdnlON3RBY2VIR0hwTndLKzZlblAwNzMzS2NYSG9SdHAvNmx4YWY1WUdoK0QrNkoreXdvSDBtamVIY3RKV2VQZTlPWnV5MzE2d0dGUTU5TVBCeG1jSmFHS2swMGRoT1hGOTNCTS9Nait1b0x0em1QcEl1RUpCKzd2MXF6MktzMmpzeUgxcE8yUEh1c2NWbXI0RzVIeDFpRWFVaFp1NE9hTGxSc0ZNZWhlTEErL2svd0N2UkQvRXFNTExoSXlyT3dHRFhGU1g5dWJOOVVldmU4cmJFd1RkejlvWkhDV1orZXVWVmFBTmVnNmVQV1pwY01McklVa01pcjRFTHJrcWR6ZjZiaytKMXFtSzN1QVU2TGlheXFwR0Mzc2ZPQ1dnVENGV0FKNTNnOEY5dVYrbUdwWWNldzBJcmd3a29jaTBMNTNrY0RUZzFJd2wyZlRhb253YlpwVTAvalZOZTRSczNwNXhLS25xYzUwdExyTXRKdDE3cEN1alhCT1ZDUnUvc3Y1NUdXZ0xhallMWWM2SGE0RGtIU1QxSG1jSEpvTnczLzRDYXJac1Rob0hybC92SmVnOXRQck9qNTF6REFmcTdyK0xQV1dXTy95L0lZdU10WXVBb0ZMU2FISkprUjRlaFp6MVpQaHI2OTI2OEV3VnRMVlpLT0E4cWlxTzRnQkxXaStoRHJiNk93emZTMERGWXJrZS95VS90ZUNLRU1sMkZUZzhBbXlrSmRwY0VWOWNNKzZGRlNSR3NaS2w4QjcvWkJnWkJmVjFKa0dEZXJKSmJKR09oZDBIVHpmSXNrYUJySjZtNHo5RDhyS2t4WVJwUm1MbVJDU2s4LzJKVkVzSjY0VmdTZkpRTm9qd2t1V0VNOUtMYkZnR0E2ZDZNRFljSHNSclJETit6YndvTStVdm1YT3dUcEt0NmVQSE0xLzJ2Uk9xZG9YY294L1J1bmljdXV6RTRLRStjYnA4RDhiZ1JMYjVVVjRicDMza0FpOFhtRnhvOHB6VXlxeFowbFZQYm0vUUlyRjR6amNvVnduTkw4S2RINWw5dWJOaG1WdXh1bUV6OWswQ2djWHEyZitFNzVFOEw5WVM1UmI1OVBWSndpNmlLejc4clM1YW14U2lvRjJFekpGU2ZBTVVCTEF2ZGdkM2hsUkt2ZGd3VCt6WVdXd05FR3VucFo0R21OcVVKMjBTakZmbGh5U2t2bXFRdmIxMD06OpZWV9vYRQR5ChipFG1XIng=","774:elementor_eb5c8ea","approved"),
("94","[post:title]","2025-11-04 14:28:09","1","UWc1VjdkcUNKRmI1VmlZK0RtdU43V0dwOERIMmlSaUcwOXQzS1dSck9YVElDdFV2K0N2cUNjdjM0K0VBRDVnLzRnREExeVEvVVZXU296QTljaUN0aC9ndG9OMDhvMXM0aUhmbk5uNVQxViszYjRIcys1d3VSbUVGdWFQN0xKSUZubjJTeVB1VVNoN3BzWUpncElQcEExWmNoKzNna2pmQndjTjB5S2JlNlRKNW1zZEJxemEwYmVtSnl6RHFSUmhhSVpGWkVVMUM1SWJKV2Rxak1LTGM2em9pUW91ejliNzZET1FFMWlNclk1TW1xS1FrUEJ3Y0IrWnRMcU5xOUhrSWk2UjBmNFpxT01kVUJKcmEzTTFXYUhDdGFQL1B2WVhNYXZsRlp1cjlLbW9yVmlmaVNSZHZteHpaaWZaZ25UNjQxOEVLU1pZcWNTWVdCbitDczU1aFMyU2dyZFlidkNnb1U2SUV6WTJ2KytyZERhMUtCY09hNXFxUVBYNnhhcmwwZU1WK00rSWZGTVBvWUV2VU1nYXFMN2lPN2NhYnpFU0JUbjJrYk8wRWZLVHFpcldZWmh6RWJ2a2pIRkI1NDVQNkFBZWlqSzVqVWc3TEtXWFkvSVlxNDkxaTc0c21SREpQZHd6ZjdQSWpaM09FWU9SOC9zRTRya2RsaVJXY1VyaEw0UTdGYSt3aUNuQ1FXNm5hUkI2dkF2T0Y2NUhoUkltWDExd3pOYUtQWDNVcDFGNEQ5Kzh2cDh0TzBlcnd1N2hRekdlbThhRWRVbmVoaWp5elB3V0ZJTGttQmthd2JHMEJJbytOYituSXRQOWlPNzQ2MGNuVzZLbU1McHkrTGJqL1oweVlBTjBxdHAvdUpzUGt5QkVmN0pVWGttWjFSVmRGenNTY3ZlV1RwOHczTkxIVFk4eWVkVnAybVJ2TXAyamhlYlIzRDZCZTVUM29BZXg2NXlIR0hCZnBhNlZHUU12dnR4cXA3YjdONXcwc0UwakhLejE1TlA3QzF6VE9lbHpmVXh2OS9jc0FDMFJUSUZiOWVLeVoweEVDRkkwVk10RElVeHRPYThHT3U3MDE5TDM4WWJmMU1nbytJZFlMSS9rbU9aVnd6Q0JaY1c3ZmIyVVJvc1VYWFVmRS9KQXRSeTRVaFhTQ3BWWDR6MjhIUC9OOXk2UjJwdVZPR0VMN3A2WHlBR0I1elVuRkhqVWEvdFhUbkxja3o1OUVjNUFEWGJ3VC9lVDNDNkljamRTaWJOV201eVRoT0hLSytISHpqNHBsOjpJO0rD9oa0PXSUCCAbtWgM","774:elementor_eb5c8ea","approved"),
("95","aaa","2025-11-04 14:28:23","1","dUpiZTNpMkMybzVNbTBCL05zY3lwREhVemdCL0czdGltRUdrbnZnV0s2U3hwUkx2eG5sYjVNNWZ2VEV3TG90ZTVraVlKVkFscGovQXlYaitiY3ExSGtpUFpxbXdjSWs1RXRicWgvVUxZaTZJZnYybHl3QjlIdExkNDFQQmRZSnhzZWlBVzBhQlhRWFlKaWdtS2FGSDNyOTU1akJLYUJWSTI3WW9LRjhmUVBSS1Q2UHZaZ3ZXaG4vL1lod2VHYkdkeno2MSt0ZVcxRWdUb3BBVjdWZjkzN1JGbElqdEZGOStUZWlnQjM1Z0FuVlJtNE9iWlpBNDVXT1psSk9DTzhLSlZWZktULzlZS1NNQmNSbWU2a0VYVVRYUytwaHpWUGVBVCt5ZGw5M0dyVDV6M2t6bit3SXVqVjRkMWNFVWZOdnRnczVNU3JyOXZkWnQzbHFicFJXTU1jdlk5aC83WENsY29jbWEyN0RaUFN1TXo1cVpUOU91L2puSHlBdVpVeExEbk9GWFVmYmo2SHU5aUQvTHFDSWNlMFcvK1JObThwRElpTWV0WmFQSEZZbnlSOUJ1QXZ5alFBbjkrVXhGTmU3WVdEampyUUhRN3Z2TmJ2bmdIWFJJWDh0RlVSUzNWYTlBSVhQeFBxZmtrZk5FcUM4Z0lmUDQwUEdXc0JEc3lRdUFrUE9UQUp0V2l5VEh4RGlPZGFybTkvZ093eFl0V25vVGdNakt1cXhyRDZDWCtBWUxJT2ROaGNucVlybjZQZDNka21VSUcxSXQrQmt1TWRsNEdRWjNCd0dmbWJJaHJvUm1UUzVWbnZZajhnLzdPeHNMKzhXYi9PYzhEUWFObmo1bUhnb1FYWEhNcFZ1MmkvWkwrcUtiVUNLdEk1aDFvZG5TcTV4WWZmckpDYjltMUljM1psbzBzKzhPcVdZbnh1TzU0b1NmT3NpVXR3U3RPYTZSa1JTaXlaKzhHa1lzaThnQThuRUNjTFkvLzZ6TDkybmZkWWR5aEZ0ZTd3MC9kNUJ6V3FyTFpKWDRDNzhkSE80VXVqUXdHNUhOblQyaFRZVWE2ajNnNUh3MHQ0U3o2OUdneThyMEs3cUhkRjJTRXc2c1I1d1R1M001MzNPbjFDQXRPeGg1a3VhNFV2Z2ZTeStTT1hvenFENG9UYWVCRGpQQ1QybXA2SkwrV1Rpa1d6N3R0YlpjRzE0MXBJcnNPSit5R2ViYUNWTVR2RkZKU3hNQVlNdE1pTTF0Nmd3aW8rcUl5WnYyUTY4bTRHeTg1U2RnR3dLME1EQ0IybDZrazYrYzlKSmRXK0Q4dXdBR0daSjc0UkhObzBTWUlOUT06Om9cc3WWKfSyiPielwp24U0=","774:elementor_eb5c8ea","approved"),
("96","QUESTEL","2025-11-04 14:29:59","1","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","774:elementor_e113d31","approved"),
("97","zzafar","2025-11-04 14:30:02","1","cURSUHJBWCtzbDljQkZDYW5YOXZybThnS3h1RWRQNDU1RmNsVitSQTFPLzRpMkh1RTEvaS9mRmphQllidnBpL2IvaWVXeXRGYm4vcHdRbjRIQnQrOUtQSllOMnd2SWpBS1NVVUNha05iUEoxSUZzelFRS0hkWEZleVNvMmNUTkdJMUp4ZC9jQ0d2bHJYT1JCb1RkZmhoVG1CdmNONytIR3B0cGtWdngxU1p1UllWWjFPUDZRYno3Y0dwRmhtZFhETGQxZkV3MzNwTndrNlFQRjNVOER5Y1N5bnZQNmoyV0RLRHF5cGRPY3MrZU96WlZqb3ZxM3NRZ2FvSThtejYwVllnTkdqWlh1enpoaFN3Qm5JSTdXdktEeEl5WFVoQ2ZScWNQaHAvaXU2RVRTcGw3ZEVUbFY4MjhMdHhKa3Zkems4aWwyWjZuNTBVYlE0QlBWQURpQUVYZHE2d3VlMmNuSVljVXdrd1Vad0phQllSRUlqWDdTRXhRKy8vQ2pkeXNIbFJvSUkvSDMzRWxwcmFOWFdSOTkzTGdpUDMyU05NaTBXLzZEYTJ5SktTcFpEeWRsSzNydGNLeVh5dnE0WjFMaDlZK0dmZW5GZnJpdEwxcUp1TWhhU3ZRaGNxUFBtU3pmNEk1QTk3b1lLVnc0ZGl2VGcxNUdWTXRnZHlyQlo5alFiTTFvUTE1bVh6MS9xQ2szdUFiK2J1bVJzODExUkdkU3NLbGdETGxwRHA0M2EveGdzNnJnUHQyRkhtbHdDVDNuYjZPQ29rYlU5WXJsNkpwdFFDM1JVUzE3UXhwdmRSdlQrNU5VYzl3ZlQ5YWVVdHppZ3ZIb0x4MVZuMldsV095QWZZcU85Zk9uNFZDRGVyVXo3MHBjbjNZaDBxUDUvb0FVM2huSnJVYThPeDBFajY5N3FEdDFSR1FObW5mRlJoT25BT1FnOEtJNTZjQTZ0UGoyN1dteDJEb3B0YTJtbXNXU05wTGdLN3JqVjlFMk1xZlBGdW5ld1lHWVZrbnRRcDMzdTNyclJLN0M3dGJvZlVDT3JEdW9KcDM5Z3ZzSFFzOVlIOHQwMW5UY2FZeUpnTVR2Vm1FcEY1RG5nRnFYZkNJZ3FGOWhLMzZ0SFpYS3RWZ3pFSUpwYXdXNnNOSS9SdUxjTi9jVmJSWkpuMExIUlBRbFNJT3RFNUFVdkRXZlhBRC9Jd21XWStJOTRoUzhKcXRDdmZ1U2F4aHFld3BkMGcrNUZudGR6RUZMYWJLcG9wVGxZb2dGZFF0OW1nUnJ4RDE1ODBXLzFsUmkxSmlkWjlnTUVXRzFBNXpDWmhnNmE0Q3lpakJkeFJCb0tvbz06Om6NambEjoIu0tZm5iYUbf8=","774:elementor_eb5c8ea","approved"),
("98","zeg","2025-11-04 14:57:05","1","QmtNWldwRlBLT0xubnhWUnV6eVQrVS9uZW8xU202REs0UHg4Rmd1bDUxUFFLODMwU1pGTUlpdFVOVWw1OUFOajlIMVZkWGVFNysvZHNkNDRkZEJTSk9kY2VYTDYyRTd2Q05lWWc4dkxTVGpzOTB4NjdJTzhRbUx6TDUyTStPdExBeGo5NXMwSUJ4R3U3c3YzN0JUVS9MdklCWis3VVkxbjZjcVRlR0V2T3h3bFRoVGROZDRqaFpCRDhmMHVrRnNVa3l4b0JESnBmbTZlVzluRkx4L2ZHMjZsQS9IUjFibSs3M2ZzTUZIUzNKdE5nK0FMTU5zSzQ1Tkx6ckxNTHlIQmxBVGVDU1ZDNWh2WURyelMzc0xRMmF6TjBDRW4rV2FoSk4zSlRDaXVDVTdVYmdxT01yajFOWXNvRE5ybTZzeXJhZC8rM1hFZFRLVGFuWW9TRU1rR0FZQWgrQ2R0U1BqLzdkYURuWWRkbmg0cHFwaVNqeVVIQVc1ME15QWJRSEhPQ0VyY3hzVU1mOElzSWtTdWtpdCt3S0t3NFpTaGFHZGJYcmNlOE9ubDhNL0NuajRjdlc3a0VaNFdqcDUvOEk5T3hqNkJ6ZHc4b1lYN3JBVW42U3c4QmNGRklYNmRCaWVYekZ5Ynh3NGNMNlNyK01tTmlCY1RRZUZpRU1BMnlCZVhzcUpBUm5tTXByNHNUU3BFNExZaVNQQ0ZjbjJrT2cvd0JRdFgvTjgvTnFJdXhWalZlR3BGeTZXbTVrWnY4WmdQQWtHRzhoUWRkQUY0dVcrY2dnQlBFTUJEVWNrSE1YWk40TjgwU3ZOWHJpMjhUZm5ROHZSNjF6eE5iQmZqMFNlak5CeElOb096YUR4ZFZHK1BFZmtJYyt0dy9aaDM1QXRYTXZvTkZhK2ZkdFQ3NTQwU2ZKblZyc2lhSWFXSFJXZ1V4d1hCOXlZbnFiZ0xFYzVhQmtBOWNLQ3FjZVVNZEtYQm90OURUam8zM2hWUE5KWTJ6cTJ5bUtQSlo5VlZNRXpxeU8wY21qNXF1d0lOOW0yOVNyOHlNSE9lcWd1VEdNazQwdFhWOHg0M3BRZGxzT0R5Y2tNdmVhdWJDQURWUG5SdStUR2tUMldhUmVldUVJd0RRNEsrMjIzN1ArVVNUQXlCMFo4eEswYndwOURzVEt4QkpJcE9UbXRyYWU4RlFjR2hUZ2dpcDQ3UjZDV3pIUXhkNDc0QVFlRklCWVp6MUhsQzIwUlpYSWhUeGNRPTo6hzT4ZHhg3K9aTBS9auGmYw==","831:elementor_0012a07","approved"),
("99","QUESTEL","2025-11-04 14:58:07","1","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","774:elementor_e113d31","approved"),
("100","zzafar","2025-11-04 14:58:11","1","c0d0UXRRMzRzQTZRRU5jTStnNCtDb1BXSmRpUG9GbDg1TVVLY2xCdVk4azRjR3FCZ0pNSTNoTFdvK1Y3RXYvMFcveDBMNlNjS1dQdkR0RFF3cHF1QW5KVkRSTy9sRWJpeDJoYWFoRHUrb2JRbWo3eXlDZEZLc2wxRC85MFgwRTJKcVI5TmMyWSsyYzN2T0JYVGdEL0lUSElHMk9vTVF3RjBoRnFKTy9yTHY2ajBLM3kyQUVPMStwWWlucmVDODdLQ2E2dXVMM1dRWmwrdWJZbGlnQWg0ekl5Wi9NaHBNQ1VONUszNHR3K1QxRmxRbVo3QXM0VjBhWkpEVEMxY05FVzVOay9Eakt0anhrVHlPQUJrSmN5elVGRDZiZWdaLzJsR0k3VGdTWlNOSVkxTnJyZnRJVnBCcmZkRW1EeUIxOU9MZjhjZ0NxclJKMFZqcmgrd1NIdFcralNNVkVIVG9GVzc5SWVIQmNRYXlHTldhd21oTFh4M1I3SkR6Tm8vRUxaSVFNWVpGVHRYc3pwSC9jZ1FHRG4vbndGakNRZXlZSlQrSnFjcHBOZEYrWWRtZjFXWmd5ZVU0blNWMFlJWVhSN3JsRmJzYVRNZTd3NU5KdSthaGt0U2dJQ08yN2J3RnNBRHhGODBpWmNKOG4zUVBFUEhRZHI1N3h5UEw3U2tYT3hSRmZYUk04ZzRGNUNkaWgzaVd6dUU3c0RrQm5NU2ROdTlqaGhseTlabldUVFRjYUVFc0RDdmVTZ21QQTFwc3gxMzZjSDBMcFNzczRlNkwzQjEvV1V1aUxDUU9WMnVwVVp6b3RTblZ4WXd6b0tkeXNHTks3TWFIKzBkOFRzY1VIV1ZWZHZaQm9KcjMrVy9QWnZ6NnJCYkNBY2pOeGdONlRIeFFMakdheE5ocmVEYzNoZTJwcG1ZNU9HN0VDQmI4NHdzU1BoRHI3d1pGbC9vR29WWXB0SDhsdEJxdnpRNDg3N1ZMT0VEc3B5blA0S25QNEFmWFBPRjlQbnIrdkdUWnhpS1lrSnRCMG5PM25CUEh5aU55Tys1ZnpBRnhMcWpmRlRYbU1QWm1INFYzU3l3dkM3MytTakViUEM5RGVMR1dGK2hiOEYvd0NsMEN6NDhUVUFaMFdjdHdnOU41RGNUd2RJUUQzeGZLVDArcHBmTkdWSEc3anc4TnhHLzZQUzVhL3RqSi82WTFsUFJqSUFRa25qdmhTck5vczVac05IOWZzVVdEcTVrRnhJRDdCNzVSbGtYM0d0QmlUeFUzZU1vQmdmbEdBZUE3akpUcTJNUEJWbDVYaGhOWkZVV2RVQitTbjRTYktVRVJKVHQrST06Our3Ia5nwPuAECQ+nGflFM4=","831:elementor_0012a07","approved"),
("101","test","2025-11-04 14:59:06","1","S00vZnY2Mi9nWVltOTRYWE1xNm1CMzM1V0gxZWRmM2NsMXpTQXYwRHRldzR5aFhFbXk2YlBObXNpWjlVZkZlM0tmWTREdzJyZUpxeTdOcTVQdVRVT0pYc2R3KzE1ZSszdHRPL0JvY2dLZDI0endXMW5uMDNZbDM5QVdHK1MzM1QyRHY3Mmg3cUhUc0FuSUd2Nit3ME96cTFMTEEvOUVRamU0NE1iN3dwZjRST1ZaSXkva3lkdDRLR2g3dWxNcXZMQVhhZVRFYlFkR21MQUFjckxOaFJIOU8yQXRBMWJhMU1qNjZNWXpUWWpFVWg3dkcxelhaU0oxK1lZbkppSGJhL2NramZLWGJZRU94ZUhpbGlYK2sxWkhEV3FxRkxsOHVQRVQ0eEVsK2RBZUo5Yi90bFlJejNDZFUzWW5uZ3Y3WFgvT201T2toRlpFSS9oWEZzOVZBU0xEZGFNd1VSQlFsSEZhR2tFNmFxVWhBVzBFT0Y4TUdreHBBQ3czTWxkK0JLVVRnNjhEKzMzMk5MczdKL05mMjNXL3M5MVNFK3h0RC92d1JUSW10YkIxVmluS0l6MWp2Y0RFYVIwWDhYNFF0cUtPKzBEMzZNZE1aZi9xdkZyT2I3NFlMYUxNdU1yeFlZdFhDSHlPTGFnV3pqem5LYjA5UW1WTjVXbjVEbjBnak1IZ3VxTWdQS3pqeW9xOWJZUGJzMDhzTnN5cVI0Sk4rdUpWRVI1eE8wVE1iZ3NHMnUyb2dOQ05GL1VLVTA1RFJVNm1RRkZqcld3ZjkwQldIVzAxVTROOFhkaEdKdzBaZFhraVdma1U2MUtqZUZ4N3JjMXdIbmFERHR3WmNDYmx1WjNKdXRhdCtjQkFHZ1pLcXpXS3locS9xK0tWWlkyQkRXTXNrSUtDc05kVWQwSEpSTzhNZTI2SDRubjhpU0Y5cmRDVkhqZVo4YkloQ1Y5ekhlOSt6b3RnUGxzS1JXL0hMYTVySnJjUFV0Y0tSdGw0QW9GN0p6YzAyM0VNNmx5U1V5c2p2V1hEa1RVMFd3blRZY2ExVXdVbUM5TGtLQlhZTWhWaTlZb2w4WW9DZFpDTVViQW9PRkx2WTBudXdRcC8yN1ZJdlM0RitxUnRjSFpBVzRYRHdaTjJId1FpU0lVNDFsakJkbGo1VStLQUk3b3RYME9SZlBUSHpPSXRmMHROL1NsWHdFdFl3ZlQ0SDhERHhzc0lTenY5Z2JNUEQ2SWhEZWlLRGx5R3kwZTdiZnVFNkhuY0xtdkgvWXpQeUFkRmV2OEJNWExlTDNHcHZhTEtKN3dySkxWQzRJdCtCWTdzZXBUZktjdWFvYXRYbz06OgBZv+9Y7Nr4UhAjc1a++Hs=","831:elementor_0012a07","approved"),
("102","az","2025-11-04 15:20:34","1","cW1zWkRDYkE5Z3A2YjhxOGlPd3d4TjBJcDQxcCtpN2Z5b09OK1JBY0FCQm9GWThqSlh1NVJGaFh0RForaUJEMFdsSVpEdHZHdklRTEhNOHlzZWF3NkZEa2lweXN2bW5mMFhTcVUwQ0JpSDRmZUl5RGpSRkN6aEdMY1U4cGFjTk9mOUo0UHdQK2xpcjNpS2MzN3k3aTlnd01MbTRldGFLY0p1RTNQL2ZYUEZvRTlHeW55WGs2TFhEbTJlN2hFZGV3eFViZ1BlV3I0dnlIbm51QXl5azg0TXFyWVdQZFlBdFd5L1ovZkdCSWl0ZnBPdzhPTGpNQ3JlZHA5eUx6UzlITktiamFxRU5rOGhkZVJTczB0TFI0aWVWSnFpclpNc2MwOEZMVlZtZmtCclhneXZEQUFHcEg1ZnEra21BVWQzbEdVMTlkT3FEWWFMZ3ZvTEJoZHN5ZzIxakI0T1VtOVFubzFjRjFWOXBHRzM0aXZxZGNyelc4REpaTklFVnFBUDJlSVZUYWZ0Tk15VFZGanJJZHJEYlkvUHVoN2JFeFdBMUZBUjRpRFlNL1hMSTBhREV2SXdpVERLd2VyVzIvSEVCQWRhTHlrbTl5WkUrb0N4aGJicVh3RDJHb2Z6blJQOHlzUTNiSFdaaWMwL1JYamlSajRZbWw2aGZwZHd1REhMSTUrTFphR0VIUUh4clk4Tjd6MUhpbnVpUlBqQzRROUtuZ0taZ2QwRmtNeGNmdmE0NDFCOFoyNnJQWFh6WUtpZjEwVjl4b095OTBBTzY2dlI3TFN4NkZVTUZMTE02bFQwV1NwbHM5eFJDS0NEUWVBYzRKYUVUTkh2UzZ0c092K1FpNFZQYkFRMlNzK3o1aXpTS3NNVWdDa0V0alAvRkpZTEFHaUdQc2dBVkJaUG5JV3BaMkJ5R3lxUmxaVEQydmV1M295eEtoNUVCc3VvV0ZZSnloZUQ2Z3UrZEpjSDk3SjRQSzhqWlJQVG9aczBZUkZFZ3pFVkpMTVhmL2FUMWVwdmtZeU02bTdnY2E3NzZvRWdPM0hXekY5cXNac24vTnI1VkNXdldWRk1hM3F5dVREejBiZU1ybElqRksvQnM1NmlrTjFWbWJhdndCQWY5UExPNXB2OG5TT0krZ2FiUjB1SWdHQXY1RXBicTgzbmtNV2pkMmg1a1d5Q09nRzhYRTRlZ3lackJpK1JZcENLd0w0RExjSTRnOW9JMDFOL0o4MVMza29MZkJiRHRsUks0KzRqN2p2T1BUd0xubVh6blphQzk2Qy84SEpuY2ZjZXNFOWp6VXN5aHF0bG44bk03UHZ0NGxBakJsWDZWNkY1bz06OqUjiYmDGE3RdEbXTNxIEpc=","831:elementor_0012a07","approved"),
("103","","2025-11-04 17:08:43","1","N0RHSHVGNUg2TFpReHlyUlNHNWpweFBGSXRkb2JmWGhNcW5uT080MEwrYTJJSUd0SDhJTmtpdm5zaXBMNFhBOFo2RUljVERtVGtLRlozZEZQYUxjWmdTRUl1OStLVlpsbUZDOGpaaUhNRThKZ1VBeTN1SGdDUUFtMllUS28xYTBEeDRjUk9rRXAzZmlPZ3QxYkpsSnB4WGlqNG9kZFl4Ti82OVF3OGkvYXBCTHIrdXVwakZUQ3dzdXJtV1lrNTE5ZUJ5ZW9FNWtRQ3N1K3FZZStRZTRCamhyVFQwZjRETnZhdFBLejNUb1Z0dldzUGJzdHo2N0piclZ6Q2JLN3ZxOHp6VHpRODlWODloTHUvNzJ0VElYSGVyeXAzaEp3T3NBVXJtenZtUkFoVndkQW1xNFQ3a2xDRDZ3T1FOdFAzUDFDZm5MOUhVUmd3Zm8xM3hqUk0xV1JpeFF0R0tHYll5U3NCRENMOVMrVW5TRWFhb01PYWxOMWpPVnN5d0gvTWJCUzVtNnBxSVdnRHhHVUhyZ0l5Y0srSUsrV1dXM2dERFF3UElrQzhwQ251MFFwai9SbGRnNVhNNnFzeE1MQ3NnWWVBU0E3UldFRWtkV1IzOVVvYjJ3TW56eGV2eElCMFpRVHR4emh3MlB6VW5kdlI0MUplam9KRFZIMkFWR3JOQkoveTRZZVNMM2svWVYvYmU0QllLajlRV1YvYU1hTm42RU1BWUUzeG5tVTMxaXpPNUIxY3gwQ0lwVnJ5dUFzdjYrejlOcXB0bHErbU5qVklPNklqaXlIU29pTnJ3b2N6RU0vUWNXdEwrOTRUQzJEUTNpbm01YUhzR05Kb3U1cHBqZzd5OWMzQWQ3a1k1WXRtZ1dCOUhDOWN6RG9Kbll6TWpoMXh0bDNaQWd2dk45M091Ny9aQTAvVjJIN0tDQ0tZT3pKenlLTzJNTlJyNUJ0b1ZtaHY5a1hGbUFhUllBczVOWEI1WjFpU3ZjQ1NibFJPYUFYNmpYb0hoMW9JMGNSWFpYemZ0UnZVRlZSM2lHdGZJeGZQVjVuMC8wL0VEeXN4bENyWFhrcmkwcEJDYkowNU02T1pnREhnRWNzRnU0RjJqV0UwSkxpYzdzaXNuNVVndXFMaHR4cDBSWkN6eDdIa1dzUG5mYzV2NDFjTzF6WENGc3NFWnBDcmNVdGFNOHNtK1QxcnQ5ckNPWWlucUtnNUhKS0R4SjVTUytDQXdTcnNsNzJXU3c2MUUyK2s4PTo6w1Dv9nVmXh0aUoBNTzST5A==","774:elementor_8337c90","approved"),
("104","","2025-11-04 17:14:49","1","MndYVXByUS96dU8zUmc2cUtsa3pLL3d3Y2h6eWdpRFZWL0doWmpFb2tyRHVNeXNpbngxdmVQSC95RURYeTREOWlpNDFGRzBqV0dmbTNjS0FTTHE1dEdISEFIeFhFMG54TUhBWFI0VXcySzBHYXV4ZkN6aWxtZFZBYjJFYlNtRnllN21zVHBGWTlPZEJjR3I5Sy9GUUpjYjlyVGd0Wng5a3ZkY1JBUDFGNUk4aGNMY0RIblQvNEpvVHVvaTdnN2pNdnJoRlFHTkRlZG5JVWZBNExyazZDSlN1bHhZOWkyTldlMDFjUWZjdUZ0UVZmc2grSGkvKzBrTXgvNUxYYURSSFJkMHRvNTJPcDFnZlFPSUhjVGxiTTc5WldTNjdjdEJ0K3dkaEtrZ0lTdEd0L2lJYTVCWlEvRWp3Z2JGTWpQcERkaGoydzlUbkJOemc2WThQcVJXV0hCWVUvOTY0MTlDTFlrMlpHaUgxak1yV1RGQ2lsK1J4QmxtekRqQXdKQmEzcTZpeXRxajVwdHdJSkg4VENkOG9NM2tLemZGeWN0c0YxajRjMWRxQlVxcGRCdFF5QXB6ZEVwSUphd1Zic3d6SHlySFlWZnhCMURUWTUxTVkrNUJRNUdwVkpZeEM5Uk05L2JXbkxHQ3BxdHE0SVFEdWQ3Z1BreEZpb1ZncE5OYmU3MG44V2htQ0NqZjl0cVBqbVk3bWJrK2NwRHJveStoK1lOaEdrMTVVclBrLzREbDZIS0d4RHdNL002b1Ivc1NrTWRFVVV4QlBTR1B1cnQxYWN2RmZjbXdTZU1PRFBRSzZ4MzBVeC9lVkFUcVFDOWFVSmNtTUxuRU1IT0ljWEIvYVdCbjlBUENGZjJDN2Zwd0FzS05od05jUFlNa1c5dFNuTE44UU9IL3FrbGxKUzk2TjhaWDBkWW1US2NwcmNwdGNGYmVNMWlSN2QwVGJKdjRKWUx2Szlod25WUVF4Y0wrelI1NS96VnJ1MHB2Mm1kL2tPU080Rk5pK0lEYTU5S0pIc1E4WEtIOUM2Wlk2Zm5GNEhYY2lST3NpNHg1NEF1TVBnWXhCbUpkZWNoOFVEcDhqenh4TDRIVUZuZGxWdFpLZVVtUmYzSEtWcFFVVWVmR0hLMnVHN21mZ0dKUkxtQVhITSsyVTMrM2pkK01GeXFiQno3WDRuUWJITDg5d0s2Y3doSTIzUVUyMkRTYW5SRTFSL3dMaGNNRFdOMXVJTG1oNGRVcitzUUV1aTMzczhZaFpReDYvTGdhaC9GUDl5WFhRaml4TXVvRmdjOGI4ZHZzQzdvK3B4cyt4bXBQK3FWakg4N2dzYjVWYXpBb0V1WXF1ekpRenpQcUFGQURBZ2FCNWN2QXJOTENScy9iNGliV1B1V1JCNXc9PTo6aK+gvypSVC//9hPh+VGAkg==","774:elementor_8337c90","approved"),
("105","","2025-11-04 17:31:47","1","NmhEeFZvNnN5RTNKTmo5ZEF5dUdUMUFnQWhGdTQvVHU4VXloMEhWd2VkS0RpWkNvaWxDZ1o5dTlZQUROMi9KMERlN3pJNDZ5QVk5b1lpTGMyc0xYSnNDdmZ2WmJ4THBSaS9VTU5ndFkxVlc2K3VLQVpGVnpoUjVlRU9lMldtOVc0cHFseTM2RUxqckhienNKZzZpY1pQUDlzUzhOdXM0cDNNbDVwUEhTZ1J5RGY2bEs4WFVtaSszb0U5V0d0TmIwVzRISTRKREpoYlQvRTUzNDE0emFneGZoS0JxR1phM2hDOEJiYVI1a1JzY3ZOMlNFbWxoL3Q4Z0JGNkt2UWlTQldxQTdvSE96ZW9OZmVZVnZUNXhPY2NoaTNnZ0dNTnJGY256QU9zbE4yckowYWJnUWlQQW1kRTdwT0Y2MmdUaE9jTW16aC9zYzZZajhaMndxdjkzRElqeDc5ZE1rT2VnTTJQVy9xaTRKdDdLZkx5QUIwc3htTmY2cWg1aHBQbFNxcnBzazhHWC9CYWZiSHFRTlZMUFZpdFZXeW5BUk9NVWZYQmZmVmRmOHdxK21KM3JESWVkeDZHNWVIUERVVWpKbk9KWjM0OFk2R1AzdEloZ1lTQStvTzZaVHRENHA1dmM0Ykd3N1lTSkt4ek0yS1ZsMDVvWUdsVHdkWWpzaHNqQ0FmeG5vbXhPSFl6SVJHeXcxRjlEUlgvRUNGeXJJYzVQZnpEUE8wTFp3K0JpOHVQUFpGTTd3QWxIWGRWdW9VeXV6OTliWXp4S01vTThMVWRxSDlvaWxHdHpZRmNqbkh0bDRJK2JhZ2RIekpjUFh4MmdkaWQrZE81dG9BanFzY1J2czhsRytWcGdlVjZSK1kzdGVoWjg0T1VPQXFqcFlualkvWE5rcnBqZWZtUnVtTGp6c1ErZU8xdU5GOWRtODVMQWVlc29yMEo1bXJ6QW9wYVlXTC92TmpWSnJ2MkVWUUV1STFOdXZuRXNnRTZPWUpGTlJSY0l1UU1IQitJejN0ckkvYUp2ZW55STBUclBXN3dtQ2xQWTdIMW50RmFzNlFLT3lWNzFlWVloVlJRMzArcFlNVTZqWDcrVStpRS9STTJNRzQ3cnZmNFYvTlNqQlh3clF1UXJqbzlyWkN6ekNkaHFKaklodDI5cTFHZFFyMnk0OS9LbmkrNWFxczhSWENWSm1JcmdicStWSGMyTytnZWtYSWxnUXN0cVFBMXNZQzlIL0JxTDY2Y1owYWsxSGFzS2F5TTNRd3RKVUI3d3N5STJBNUNPOS8wMlBoUG14bXpMTThnM1ppYUFtMUw3WnJUZmY5RkpDRWVQNDZvNE5aMU9SY0R0Uks1QVhNZmd0RVRYTlhYYzVHR0RRMkpvWnJYclE1WGxpUSt1dWdvUEhOUkM2UHZEcEdmU0MzeDZUNVZvL0RndmtDNXdyZy9uRmIvM1N1aFVuK0hQQzdyQ252TmJjeTlsQUU4bFdFSGxHYW5FbnBzVXBWV1JJUFk1cG52TytyVkNNdkEyM0J5QzVVNldkeHVpbDJPUWZJZ0FrN3h6enN6b2Zkdz09Ojr+BcOovPUJlY/qBTH0uLwn","774:elementor_8337c90","approved"),
("106","","2025-11-05 09:29:40","1","OTA5MGo1OFJkMDhWNHpsNDJ5aVFzc0M4ZURQWFFVKzR6TXF5Nk9PT0JSY084ZGg0R203LzFEc0ZKblpKLzUzMlJmY0Jzd2R3RHFYcEI1Sm1WclBJTGwrblNDRE9iUWwrOExnQWxocEFCRUhjNUxTZVpkdG5rUlJQdHZiejVSTTF2N1RFQUdudDE0MHpIdU4wK3l3VEhrNk42emNDckQwczZxOUF4UGJhNXkyeitkOUU3WG5YYWJyaXNRTjdXSEduOXExMllhY01mN0paUkRzaGhwVHgwdm9vZzk1R3Y5UnBWRGFTK2RJbllkMzI2VUdaOVpTY1lxcENDOC85SERLTndEMU80OEg4Mm4xTTYxc1U1ODRjRDg4ajgxYi9RcjBZZXczVU5zd1pmS1IvZUFQN1Q2VktrK01yMDM1bFVDSjlDeVZzKzNacGtjMGgyWlplTlV2YnIzQ3dmWjZBRkRkQ0FGVTkxeUx0cnErZlVUQStnWlIxck8wYW5rZCt1dnQxTG5FZStnQ1JmcmhiQWtFQUNSVTk2U3l0bk92SzMxOWtFcWdJNzU3ZEtJWlZnc2FEMVRjZ0Z6ZldkQ080MDJEdC9Zd0FNM3NYSGptMzZWa096QmkxOVkyUFA1L1AzVDFiNjQreUJlc21XUGNYZ3FQLzE3Nm9NTHpkdGpVcm1FNkx6Qm04RlF6WElhd1ZSeldwTWdnS2diYnN0WTFieTJ0c3BiSTNPeDRRRGNBc0lnV2V6Tmk1dTdZRjFtalBrZyt3UXhmWVFyT0h4NzZHYVZEcmpBbFV5a0dQclIxTy9GNVgraEpVcGNjRGJ0NUpCK0MwVW9MZnJvTFRmanRVRHExWE11MXlkanp1eWVjTUxYaUUybkUvTWhlelB6dU9aT0ZmMEYzNStlbEllYWtMZEJZWWo1YXpSTVNRSDR2cWl5RHRZUkxsVWlPNjVTSjhwZXpIQTBsazU0UEliNE9nWVc4cGVnL3E2djhVTDJlWW1sSjFrZXpaejlNVTlmcTY4a0hqbzVrVkxNanVuUTAxdk1jVFp2SzdWNE1PV0V1TE1SNjF2a2JiRERKTUJZSFJGK3YwcEVxTVovaGViOGlHV1ZuVzh0Rjd0U3VrclNSbjkzck1HcGYvYnR5OWRoMzJPemZhdTA1Y2c3ZzlBWG4zREVPMVlZSWt4bzdQbVNFQVRrQ3VHd25DZkdndHFxeFQzZ1pUdjNQaW1IMmJZQlI1VjJRcDAwejYvbUtUS0hwYno4L2hwNFljZzB1aGgwTCtteS9wdjVpOURDUUJXN2tFM2tmQWtLM1VaZjdKYnFFQWRuRkI3M0MvL2dlOGsrSEFuUWJPY1FJbk1LUmJYbS9lYlk1ZHEzSEpVL1AyVzNLalNvckVtRWd1a0E9PTo634jRm6MlnYCaibY00uMzkQ==","774:elementor_8337c90","approved"),
("107","","2025-11-05 10:35:38","1","bEJrMThNdUx5UGM3elkzM29HOWRkOUpnTisxdEkwMU9oTXgvU0g0MkVDcWNZNTdJT3d0RCtvVnRybnhTQXAzNGtEd2JtV2xTVTNCRGpsaDM0dXJIUFo1YmtDTzlzMmsrUHNqR0NuVTlsR09sOVMxbWpNUTBEMzdXS1g0dWROcjVTcGxGWGYySTVyZjJXOWpFSkZITmRicXBseTlIdThGMDVIdmJHWEhmdzRmd2tjNEljemRGMEVrZWd3MXBESjBybE8zL2NVeGFZNS8zNzJQMGNDM0tTUEkveVZpSXJJYUMxUG9GZm5LNmpxaGpJZUJ0RUFudExKek9CSTh3eW9zWnJzVzkrSytBMDNFaXNxbFZnZHFaMklnU2hCU0orNThGRlF0UWo5L21aQXBIeXhTM1htemtOZWlmMUFOSm9NMmJCWG8yVGttemhaOFZob29tUXFicVIyNUlOTjZCTnhPTzQ3TENaajIzNUhweC9EQ01LNGZPbXlEU2UvZUdZNC8xK0tLTVdISFZVVHI3YmxERTZJRjFLN3NpZWttWUNZMUpXRHROR1RUcGVZSHpkdC95YmtzMGtsbkx2YXA2ODNnZDl4Zys3bW5PWmsxV1FudWhlaWovTUtOYk5wdThUZlZyU0x2cytzb3VWbGgyK0N4azI1K3hwd2RFVVVkVWwwMHVmbzE0czVxTXdNVktjU1l0a2laKzhTenkxZlVQVzJZTnQrTVRHeHl4STJWUm4yRHdleDM3WWJUSlM1blFjZjMwM1VLdGxQeTROK1BobStrK080bXZFMnpTWTFuMzJBQVBuZFNiSXg1ZHR5TkQyMDNnVzFSWEdQRncya3czY2Ywemo5Sm1zQWF5cjFWMlZHS2tYcnNMOUVDVFV0UVBmMy9GNTVqL256T2E5ME9LSW5QZmIxNUxaNE45eSs5TVI4K1hlQ1FlMUpVeVB3NExEY1pva29PSDZkV1BLc1BKRm43VW5pWlVaVEh4NFBJN0NDTjYzVGdoKzZjRG81NEloSjJTdng3QVlhY2lNRjE1TXNrdkRHa3QzUDNrSDI0V3QzLzVzWGxCQyt4Z24yZ2xBT05ObElTNjlJWWFHUFJiWnhEUy95b1JsQU4xMVBwN2RBM1hTdDFBcmV4ZGYxa0FDQ09INUgraXYyQ0FCT2FYVTBQeXBvakZFVHJUamhweDNNaGgvVVA3TnFYRWE5L3VBeUprWDExak8yRVowOHEzbjdUSmdqRzNHWXdTMllwaDc3YkZCZ2JIcVNJRE8vaHplb2ZTS0dRWVg4SThEMWxKTTRzMFlKYi9Bc0NOMVZVN1puR1Y2SUtlQTlBcmo4SG04aElIMmM5Y3hFTWFCdlJwb2h3WldyaXMxbFRvMUJGVDI5bFM3RHdNc0dMYnFxa05NZnhOS05MeVRBbDdpUkhxd3hQcm9DK0lpaUNvek0zZXBEU0UrenZpL2NwNTZBYmU2N2pUY2E3bk1IVGJwYnNVeHJXSkI4SFMwb3J2K1I5RktmZXkvNHQyYVV1dmxJRmRqOU5SdXlaMzVaTkRvUHB6dTZQK2RwY29KU2lpY1JRVW9NY1FiMlRYbEJMaGd5QjdVUCtyNFdZOEFIWVZQVFZFNzhONkw3cmpQUE56VXFMVlhBa3NVRDZKaEFGdThJcXJhRm1YT2c1ZXhLVTBxc1E9OjqknGzUO3yNV47k98ppv2Bk","774:elementor_8337c90","approved"),
("108","","2025-11-05 10:35:56","1","TkRsVUxNR0pOVkpVM0JYUzE4YjlhS3N2anp1MStzQ24xRjQ2YVNDNFJIeDNrVWYyTnR5NFBuM3prcTFHbjFoOVZZbzhhQ0hFTUg1bHUrVmViR1NGRnNqUDVHazRBRDhtR1dxVW9VVW1nYVNyQzRLeFZSMjQvMGMyMlJWVmJRNnVnbS9NZUdRY2dZTlBrRmNnUDkvcjhZOWtMK1B2WkExRGJ5UlpJTHFwbEo5NDFxSTJmUkluOFRNczQ2clVmZjVoVERXb3ROUHMvTkx2bXg5aFBEN29oUVBoVnJWNVFJbXZSZENNWHZKTWVhZzRPRDg4b01URW9jd0F6ekxmbXgwSjBrODBzV1hrNllqSHlWcGlPMmZzUW54OGliMEY3QkRzdUp0RVVxMGIrZXZudXU5ejlBbHgxdndmYXo2ZHRXeEJCV0poZGFlQ3Rkc0FQYU1GeFBCcjZ6NXhhTnJjQ3J2bTlEeUFKdTVNZWV1TitQWTk0bWtqeWIreDZFaVROcnVaODIvL3NlZnM4cytwTWw5SG94SndFcVhMSFE1Q3RFRWtRUWpCSGpzZ2dRVy9jVTZLc2xYbGlhalJ1cHNlS0tYQlBEc2x1NUw0d004ek01dW5sRXl3REVhYUxlWTdwZU1XbncxbHJQc1gyZG85UHFnckdZM0t1Z2JSbjFBRUJzTVlHVk1BZ0RYSW5lTm9HT2JBT3NLNElmT0xNM2V0ZmFvZkJHVEdBOC96T0RXRzl0ejg4RHcxRGt5dVV5MGh6Y1pXTUlPK2taUUY1M2J6WnY2RFlob3A2akdkZlN4NlpDRHRCbTl3c1Q4SENzRS9hWkNKekVEbmdNeFBPb1NUQlYzZTBnd2w0WkRSczc4REhHMDBramlIYWVkMC9uY05mRmtTYzFYWWRBV1FwRGVtVFpGcUsyU1dKRTdHQlZld1JhN1hSQlV5QkJuOWpzSitidDJEMHhyNzRRZFVMeGtWc1ZXMHFWMWhCaDNtRXJPcVM2RzFhT1pEZmRyTFdyN2lvSlBEM29Tc05Ta2VvYWFnWUR1ZTZTc2JUTk11QnlpM1NHVVhHeWdjbUcxRHQ5bTRXcXhEYVJDa3dFWHFVV0pqRFJqbDBvODF5T0ZYT1Zsd2xlZ29wTGl3Qkt6dUxwemVkc0V2ZUdxN09RazFMcDJOamIySHBXeTFhUFJiSmhJTjhOL1VSM3A3eEkzVFRpb2pKUmJBRFRQNTYvTGsvZWVtNHlVSU9wNksrbmN2MXltdUFob3cxTXdDTlpGM0JDSlJSbEd5MTh2M3RuM0IxOFI4RG5sVWhrQjlUNE1RTlRxbkVmZS9RbXBRSHpaZUl2UEg0d092Q3ltZFVFYWp0MVVWenVaUUxOUmZZZXNaUVVHODY2d0VhWjBvOVUzbEdrQ0hvdVc5M1NQWnVjNExzWHBrUjZNN2Q4MytLTXVjT1d1eUFDL0x3NVBJRzZnYUFiTkc0LzdRVkcrV0lRVllKR2hsZ3dXcU42c21MMEFWZGk0bEpZRVZkOWVkamw1d3NNWW5USWFnSzZLcUFRMmxDZzdYZHVIb2R5M0FvMUxDV2wrR1pBb1B4ZWkwVm1aeHg0TUVSSmtDcTV0eFVONXBlU0IrODhIWWpnQ09QNUM2MHdKbmNZNkN4OXJlYUxrenE5b0h2Slg4aE9hb1pIVnovSUpSd1VYODkrWnJGWHdwSlVmelFaaDE6OhZS3hQAOXWE8na/wL7DHe4=","774:elementor_8337c90","approved"),
("109","Non défini","2025-11-05 11:08:28","1","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","774:elementor_e113d31","approved"),
("110","Non défini","2025-11-05 11:16:51","1","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","774:elementor_e113d31","approved"),
("111","Non défini","2025-11-05 11:17:01","1","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","774:elementor_e113d31","approved"),
("112","","2025-11-05 11:17:07","1","dzlDQUhkdXNTVWd3NGM2RHVaVTFzUm1vUTNLMFg0MGFINnVTTVNjZzVIMkdzOExCSk9sNFdLaHRGLzNlaEt4c0JnaEVNbk0wK2hVWGdIbE04MWwzSmJvMzJJR3hhSlVYRE9UK2Eva2s2NDFtQXNEcitWM1YzVk1JT1R2UUUyUUFLSzNSM2ZTendCanFJaCtRRGV1dEtacmM0WmlFSFNUci9rUS9LOUlXTjE2SlU0OTJWekhSVVpjb2dNd0k5djB6bnhzeWxOREtiV1VYT0Z0NWJKOXc4TWpZazVaR2haQW1OaGRlV1hTUXlBL20zM2JlSmwzb0czekxqTVdaWkpWOEFheldMOVNLUUV5L0FlTHNKb1NBc0gzcWpJNFRhK0tNMy80VnZNYVAvZ1JLdjBPb3FIcEh6SVF3VGFUS1Rsck81WVZqcndScTZhQjB4QTV0VitndEU0cHlCaWlUNExsQ1EzQkJLSXJTODFLcmhxeFZFTER6VnhuWm4rYXJibGd4b3dIU0Q4VFVlVHo3Q1FaZ1dnOTVvYUx2dDdGUVpBcktOTm5uaVVEaHNrd3drWW1nWVUrbThNM1hGNmRDUzY5SlpOTFBBMG5RaCtMU1FOWFNiK3FaV3VLMTQ5OU9NQnZaMlhSUitzbjc0bmdMd0NZaE5ubnREaW9ZK2pjNW5kOXRLRDhFd1BJTzNUWGQyYXJ6eFJxM2Z0MURyS2NCemtQMitQNTdUN2gwbjUzTzN0WU4wM1A5Z1NWdTRlNDFKb1VuNW1EbmJ1eTlQamtRTzdjNUY5dTVWaWJWUGxtQjM2VmdGWVNJWEhkMHdad091SERFL1VTTWNJMVFLNGdqcytJcDhxMTBWYUdXOEYxMXkwNklxd3lLUkdzeTZxUUttT1ZUdllpRlNVbnczalo5VTFaZDU1ak9CcDZMWUhuM2F6RGMwLzA4OTViVFdjaDBtbmpabTNsQXhtb2U4S0dnanR4cGlrUXJ5V3AzMnk5ajgxc3E1T3Jaa2hUdS84SmNtSWY0YU92QVZOeHJqM1RvU0FzYmhZcjk0aVJUVjhTRmM4SldFbDlXdWhEcEhpWUNjVzZCVllMTDlMQlpLMHBUUmpiTmQ4LzVZSFkrRkJHUjNWZHQ5NzBNak4wTG81bk9pdlhld215cW9wU01Na0RKZ2xGWWh6VWtzUnA3OGk4WHZxWVlrVHZoUzJEbE9aSk5qLzRHOFB3VkdIaE1EazlMakFoUkZxZkN2NC8yVXNSQ2JuYUxzcTFYUWZxK2FsWThmOWNxa1VtS01pN213WTJoeXFUeHhCZ0dZQ25XT294K1c3eDVlK1ZVdjg1cWZ5ZGtLQ0lpWmJzdzRySVJiREFqUUFwQTFhOFJ2QWV0VGVUUzd3ZEprRi9STmFZZXdjSVZtdFZaVFFMNEY2ckc3SU9VaHdHbEkrYUN2K0l3cXp5U1Y4STRkV0ZzZXAxdDUyUDFQeWVXZ2hFRlFBT1M3Qi9hVkdLSkJhcXNyMzhjNExEMmxGVm5KaXlFclBlRXp3bmFydGNtdXZ0MGVqZ1cvREFsY0NxcDdvRC9rN2tPVG9pNkdBRWQwLzZXNW9Cam03OGRpN1lUc3FzYlZRWEU2cEdvODNBeWsveitkOUhRTXZQMElYZWtlS2xqZGU1ZFNteEJoWWU5MzlFNzNHajZubFBBeEZTY2dFRm1mczI5WUV5RzAyOHY6Ovosceoy4/HgdNEE7cOLyJw=","774:elementor_8337c90","approved"),
("113","Non défini","2025-11-05 11:25:13","1","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","774:elementor_e113d31","approved"),
("114","Non défini","2025-11-05 11:25:27","1","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","774:elementor_e113d31","approved"),
("115","Non défini","2025-11-05 11:29:28","1","ZW0zQTlvOEU5V0puaHJGeGlMV0FwVG15Q256OG9BVFk1a0NGZ29MSnFjUGtqTDUyNlRIWTlGSHdpbTRaTmJGVU14RUZPYmZRK0ZEdnVpS0xuYmlrRzA5MCtPeVNkOTRYcFJXdWJwUVp2anZGZVdHMFhTZVZvNG5nOXJCSE5pcUJGd3ZKZGJpNFU2WUdGbVM2OXhiUEtrOVMwcUw4azB2emEwZHFwc3lFcVNzbGxIajR5d3hLaURVazk3MVkyVHlmdWFrT2NZREJrVjRoa2hHazNqTkREZTF6RVRoOWg1cGlCaDBLRldtNkxrYURRQjFyRHp6RFhOdGNhblF4SW45dzlaTE8rYUw5V0dZTitlUzJVSC8xc3ZjWWFtOE9YZ3FxaE5SS2NGcWNkT3RxcU9RWXM2dWpBbkNRU045WGdOakpGMng2bmFsZkNnU3JSUkhYNVNSZVFJd2RVTzFqaityTTNRdis1YzFzM1I1ZXpZZnVUdjd0NVRNZmNzcmtOOEs4Y1llUWJicUprMmQvNUYzMVlJZzZXV2hubVpkYmdxUWY1RkFoWXV3eUdCOGt5Sm1hQzExK3AxeGFhKzNQMkJTRE5SV1RlLzVpZk5YM21kQy9aUk96ZVc4TU92aGJHTEdXeTFibEZHRUQ2eldqOXJBb0wvc05PcjZzUVRqRyttdkgzdjh6TENKczNkaUdzVlVUbUtzZURvUFlKWlczVzJjM29zSEJMeWpSSkxDUWt4S3FlbXU4RlE0c2gwN1Ryc1k5bU1LRUVuTlprVm55LzRMN04vMGliUnZxdlpMblRZZlVqOVNyckpPQ1poSEc4LzVaaTBzZU9uSjVhMW9PSXBQb1ltM2hpWG9aTkJOdG1EM1l4clN6Q2lVOUtGVEllVWI3UkZJK015M3hyZEkyYjVjZ0JRa01HVE1UZnJHaEMvc1lZZjZBZ3JaM1o1YUF6c0dBMkFsNjZOamxxbTVtUDJvT3M2cmNTMzJxN095VkNTd2ljcXJhZnhQMjJvRnhIbjI1Zkp5elEzYnN4anpDWXBYblFTV08wbFVWYkZmakc1TjVvek1WOVo4Y0FTbXJ1VEZZRE53VWNvV2N2U2kzQlBEekFFZXltQVZsOXFGWTUyeGhFbmhldk9oL3Rjd0RFODR1cHgvcDd5U3Z0ZEpxRWgxNjVnQ2hXbGdWNEpDVFY4dmovZkdiajRMVWZtc0FHNy9UOGJ5aXdwVllPR0ZuZXc0M0FRai9TbUs0MU9LU1M1VXJBNGR6T1ZkKzl4OHlFNldGcXVlTHlHTFJ6dnRFNExRRGtCd0JvdmdOZ1JUYnpPK21PQ3kxOXdSdytPb0NqOHhRNlFGTVhYcXVJTGczbzFDd3cyTjZERk42WWVxMnJPTEg3Q2lyQ3Q4Q1RXS1dVdnUxRXZYbWRCZHFtQ2ZHRGJjYTJzaWl0VTlTVFJTY2RSVUZPeTVBTThTeC9DR1piYzMxbDhVQ3FQd01tbUw0YWhDN2xpdm9XT29rLzR1WDl6NzJORnRBdDVaT0pEdDhuN0s1cXhtQ0xWM3IrdGg0cUw1cDNWMXNQM1orYlI3M2E4VkJUejJTWCsrckJFZkxPU1JSUUhVMXVlblBWWXJPL0ZuUGRZUDJlMjlKblQzMU9yeTBVemZBMHo2cWhaWDhoVXUwakRzNWR0WkZqMUVKZmJlVTdCY253eHVGVjRqQ0p4RlJXQnM3V0MxMkQ1SnF6QWRNZHZQM011L1BsdU1Dc2UzNG5jaDRXRFRIcktzckVtdFNiZXFHaUhaa0pndHE0d2xQTE9mWDVxSmhqTWFLQ0QrU0VBS2lzdHMxSUVZc2dLdzFvOVEvUmIzMVdaSzhJSUQ3ZTNsakhyYy9la0tVeFpzdWZNbDAzTTRnRWRSbFJLbHlyOHdCUXlacTBKL0N1NXA1aGY1YkF3eEp6YldpRExhU3hYakZNNWh0V1pRWEJuSzdUMUptZ1kvdzAwdytBMGZqajN3RWdpVTVDTm0zcThHTzgrWEJ4UUZ1aGVBRkU5NUw2UmI5ZStBZXBudGpJak42RDI1eW5iRGFwNkVlaWtFL0FPRkJjTVpHWGdrVCtpTEFQY1JIVkYrN2hNTDQrVk9EdVBKMjdZeC9qV0M4Q2c1Z3VidEo4eGorK2FSWXpKRHc4em8xanBDNU1TN0RvbXBxaXRiYU5HUWFNb0pJSEpQZ0d5dGlpZ1RzUFNVRHJjdW44Q25OUWxucm1lUTZEczdKcWlnWjhQSVFUZThnbHNXbHJJbnNiOWlTYndzdVVxa2Rua2dxb0JBOVUvOHBqWnM2RlU5eGpuaVozcDN3ZUtEdHd5aWEyV2JyNUFkTVp6czlPdFMyQXcwNlRlY05vNjdKclpGeW9qOXp6bWg2QTdUYkIxNjRjSXhndDhBNmNnaUQ2dVhZM1JFT2ZlcStJNHJydjU0VndySVJ2eTZpTmY1QUdGeFhlK25kRlBkeWs0UDlLQ1YwNkxtci9zUk9zVVR4a3hhREYyaXRYVjgrSHl3RFlmTFdBRDZxTHFQeEdxZjR4eEdmREkrMXR6aGl0UmFLd1Y4NkxWQXdZWjM0UStyOEVtZWdkWGhrTUZQVEZzZ2lLWjhZdXlqbFhYcTlLOVd1UkpGY1ozNEJCWjhmS1MrVkM0ellFeHNHdDlneW5NMklITDBSRFhzOUx6WEhEdzFnbDZoanFwdVBab2tqUEdTZXFSVGlJazV2QloxWXZPRm5ieHRtNXM5NHJCTndWTzhPa096OERLT29HRG52MElSNWd4RnJTaVloVUpObE1MNlRZYnBMeE5qcExZZ3laMndXKzY0alk3MnFwYmZHZnRCbndneEc4UFdsd0VmaDVlQTZsVjI5dk5UK2R4QTBJY1NRQ0xWM1VFbzJ4L1MwaVZ4aC84aGNDM1JlcUVEMHhxNjByRk9qZ0tQVnQrdkdaK3RKcWk1RVF3aWo2OXpGcldtRkpVNi8zWldCZlVNMzlWcVB6QVlQM0I1Y0Rvc2VKdWVmNUp3N1RKYS9HeEVBVCtsdkt4SEROWmE2T3FTQlA1M3hmZlF6aDd3V2xyTHViYUtHeStieVN3WXZQaEdVK2Fnc2dxR1RBYWxmSXVaZ2d6ZnhkOU1xZEpEcmZ2TnA3dkJzUzJ4YXJDSzA1THRhenRXSmZscjJJeHJwaWdrUlRNNnR1SlAyNld4WTdPbkd6Vm1MeDZYL094ejUvVHdGMGkzVTYvSFdFMVJXdU5ZZHY1dk1vYTM1bU5jTWMyMmZzaWtBeGxzTS9wSndXR3VFTHJhYWk3bUlEMTM5WDZiR1hUSWxkQ3Fodlgyb2UzTkNRQUhpMVRScVUwZzQ0MHdjZVc4VFFwNFR3ZVZNejBDd0R3V29zTUR0a2g1UHVYVnJJMEUxeEkwRHJwVmpDK0hiOTBDelNZWTJpaUgwM3FMaDFLZ1hmcHB5T0R0UkhDTjdKcjFTalRzcTU5SVJ5YXdGcExyakZmZ0wxUmxZOWdxVjUxUkFaNVBvcEM1YVYrNW1qZHRkYUNybFc0cGtsVXVKaGFTc0dRWWVnU2FyYjEyMlhIaC9obUpkallRTG94R2N2OFJSWjc2S0NZWnlwd2kyTk9IZmpDOUZhdFU4emJNcTI3RnRpRStrN1duK0VDd3ZDcEU4MDV1NjZ4Ukx4eVFMclpzQUJIMWpDY3dibjlLUGQ1MlFXejhLWVBLU3lpOFJWNlh1d0dpbE01QjM3VzNEazBGQ2V5dGs5c0FSWDhMOUxLbjJZSjVrQ0l5QTMxUGVJN25rNWxMRzRjZy9CbHpHYm1yKzFwM0FXY1NBOGVPR2dSMmlwUzFsV1BqK3piRldSMmpIeUxGVzc1aW1kbHlxMUIwRm1OUjdCcVl3YVBxZ2VvL3l0SS85ZkZzWnZZak1Hd1MwMStMZi94b0VzbTRZY2k1VDo6Um+Rdh4GY8BI3w224oaN3A==","774:elementor_e113d31","approved"),
("116","Non défini","2025-11-05 11:30:15","1","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","774:elementor_e113d31","approved"),
("117","Non défini","2025-11-05 11:35:49","1","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","774:elementor_e113d31","approved"),
("118","Non défini","2025-11-05 11:39:15","1","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","774:elementor_e113d31","approved"),
("119","","2025-11-05 17:17:34","1","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","774:elementor_8337c90","approved"),
("120","Non défini","2025-11-06 09:04:03","1","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","774:elementor_e113d31","approved"),
("121","","2025-11-06 09:04:57","1","OEgzRGlSeGRqU01kSzdqaVR0VDhQbmNOKy81VGhmNlpnM090MFVVcEs0SXNlU1VQQlNUYUVCamx5TmpJdjNuU1JKbVpBeVNYMWFoTDFveXFMV1N6eEtkTmhDcDVKV3V6NmtUNmhPeDRzYit5WVFwenFrR0F5S053TmphWFM3YWlqVmVrdERBdUNoZDQ5dkZneWtoSjJ5Zi9ISVdLMndZNisrVXhYcEQrS2VocklFV0FPZTB2Y3V2MDhaeWRsRTNSQnZaOXVmc3c0clJWSnpNQjNGS2ZwcmVIZlpWMFhQZ2ZKV0lNcWtZS3hXdWtQN0lJMlJ1VlVSZW1yY2FBVzFZNTFMS3IzQUt4RVRsRWEyZE9vaWk2MGdGSEZVZHM3dFZWOW9BZ3NveHlReXh6c2toR09RSFo3V0JqZmo3ZUF1dmlERXppWHJyN0RVNDdTcytDR3JNT3RQcmJnWGZEeUpiemxsMzhSN2EwdXZTaExQNGtCdS9HZDJzMGY2U0phN28yV3VjMGoxT2ZHbUlaU1kzTm5OWXduMzlBQUVSSGI4cnRzU3lMd3h2cG9jMUgvYTJheTR4dGNYUDhBT1QvaWc0c0ltOCszemNabGxHVDRrdWszdzlCZjkwQWxjM09obHdhR1JqejRoT1BJTG45NnBlNFVvS1M5ZkVWcDNkeERJSjFCUEF0YTRVNGlJdENJK2MrWHMyR3dRSFFEcXh6Y2UvcVNSeElIejl0c29pcGRXNi9ld1NNelhGaFNqdEpYN3A4T3hreTBoSlVSNHVNSFJnekRrSkplMEFJeStIUFQ0T1BGcmpBUWEzcDJwTUN3K2NsUWRETjBBOWFVOUlUVWQ0Uk8vV1E4WENleUtPVVkyVU1GanpmaVBRNjJZczM2aUNLRWNsSGJPTlVVWXFDUGVuL1FleGlidlBLcm82bUtIKzZoYzdPQ3MvVHFwanVsS3NoWVg2SGNpN3FpbUU4R2loYzB5dFJBOGtEQzE5dnRWaXA0N0hDUWx4cEVsclNiaUtMOEtzTi9GSzh3anVuSjR6SUVTK2RFbDBXMC9FYm00dkoweU1uZzRIR2R1dHhibnpISGNZUFgwMnJSeG16Y05acDFHNE14VUxDY1dsSW4ySVVvOUtwZE8rdU9kYlVjZzNNT0tKNlVpbWdEWU4wdVpaK2JnZzErWkdESVQvWmFnVVd0SjJpS2FxMzVHc1pVZlZaMGlzNnpYMlhXVmVQOHVmbGJ0OW5hMjQxNUN6MVEvVGx0R1RQOUtwaEFEN04zUXVjR2ozbXprVWEzWVlKVE90dTBFdkVxWENUVG95QWFWaGhHbENWZm42WkZCaFdDRDBGaDEyN1gwM0hXQXFrRHBxcitLTDFNWHZyMVphRUl3bEw3cWxDOUhjQmlKNmVqU0xRL3dvZUpSV3R6YUx6YUdLOVR1QW04OVVkUWJmaHY4a3ZMRjRuNjM4QlBUQ3VUNSsxUzBJTTNtSVNTcXhIVkdob2JWVW5CUWdyNk03cURWSStLeXRoUTJVSXFjMWtJMTlQMCtoT0dFNWtlZFFicURyUUZicm5RTWJoK3VoQjI4aFU5aGJVemo3bkxjSDJCK3pRd0VVcFV0OGF5N1BGbDdKak9YVDB5clNXWFVFWForQmlzMGJDUG1VY1Y0UHdBOHpPeE9lRE5hRWhOZ3o0UkdjNE9VRUQxemRSYXhRNmY3UmVtd0dNWGlLbzc1Z0RFUVhnNTJPRXM5anZUeHVER2FDeHN2VzFrcElIcFJVWUI0YzlNczhOMk5PZnBVWit1elhDTnRHcmRvWHhEeGNLY0UvVXdudTFlN3NPNWxXRXdBaGUwWmNBV3ZZQ1kwREJCelNQVnZ2SkpscHhGQVRPcnYyVjNQeEs2cDl3UHQwNmdlZTk0My9ZTC9aMlc1MXVBR3p1R1YzSnV6OHlFdlR5NEhqM1FKV3lwb1BiMWtHWXJzQjdwZC9rZ3J5cWlsWmdWeEprc1ZIR0gwdmdmckl5TEFoeFB0UGZSeks3WGRsU3BKWElBd0x0elB5bThxY2NEYVhBTFhBWk1GV0pVSVZiYWtJNTFjTEduK08rNlNoTzhWWm1DSHFVRnVnOHJRcHBncnhMejZhQ3pyWWs2YTF0RmpVbVovNys1WFRMY2hWU2ppUTJFV09uK0puWG5rWDI5bFJoMkk1clBsSWtLdkVDVHBRaSs0b2JuZXQ1cllaNDVyek8wdENFSDQ4aFRkdXBHRGFKNDFkalQzRUZoR3ZLellERjE4NlF1cU1Nb2sxVXRqdnNOU3Joa0xSR1RYRExjbk56UHpXU3ZyY2RnZHFTWGdlSlp5TVFSL0piUGJ4Ymc3RzdzcUxZV0J1S2pBWElnRHJ6L1pUd1FjWWFHaFB6UzU3VXR2RExJUFN1aWhIeDlFQXlIQ3A1a0E9PTo6ycZ6edxjgtSXINK0tFxGGg==","774:elementor_8337c90","approved");

INSERT IGNORE INTO `wp_f4a5sfea_submissions` VALUES 
("122","","2025-11-06 09:06:50","1","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","774:elementor_8337c90","approved"),
("123","","2025-11-06 09:46:20","1","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","774:elementor_8337c90","approved"),
("124","","2025-11-06 09:46:34","1","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","774:elementor_8337c90","approved"),
("125","","2025-11-06 09:50:09","1","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","774:elementor_8337c90","approved"),
("126","","2025-11-06 09:50:27","1","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","774:elementor_8337c90","approved"),
("127","","2025-11-06 10:49:17","1","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","774:elementor_8337c90","approved"),
("128","","2025-11-14 14:27:32","1","S0ZCcXczYzRydnVOTmJWM1N6VnNEelhLVk85SVNoRU9ueXE0OTJsaERTWUt0dE54MXhrclowd1lLb25MWHA4alBtSG96UUUzMy9SK2xIZTI4RmpPL2dLQ3kvOFZhZEt6SGxDcU43YmZndFlHcUZ1YUk1cmRvaEw5UlQ5Q1RxSU1TenM0cFRzSkQ1eXkyV2MvWkRJTG1NSFRFVmIrUXJVVUZLNThZNU0zdFZkNTNCTHJpaUdGR2tjdE1rdkMwRThmZFBDVEpMRFJpNUlsTDUwQ3Y3RTlndm9zNC92OGtqMFZ0WXZBV1pSc2NkSHhZRjRXMy9XUWc4RzJ6ZE9FY3p2a254eHVMV1czdmFSUTJoUVRzUlN0VGd3K2lXRFVPRVZjRHhhdDF3VkRJYzJYRGtpVm4xN3QwQ1AzWWxCZVZDZnU1SW9mRCtLZldLNi9aeTNIdUQ0OEYwOTU3S000UmlYNmsreEU0M29aZy94SjZteUZRWmhxWGtQcmxEcXlFR09UZjEveVljbGVVdGkrbEJQbExGMU1MeFB4UkZzQTdmNjIyeWtZeFVMTEg0ZzVwZU11VkVhQllBQXZrSmFUT1RJN1BSQ3p2L3hLd1dMQTJ6dnJmRzVidmNQeW1ETGZraFFibVcxK3U3VGFCM1F5Zzg4Q3dxVmZTWXJhOFdhaEx5OWFDdGt1QndCL1VNTmVrelFWdjRYSUN5MjZDNEtXaUp2dVJMVUVMVVc1QXRhVzNEdDdlSXhMSHR1SFhCRzVuOVBtSUlsRHF6RjZYZjJ0R1RLZzB1WTFXNHc4UWJxaHozRStrcG11V1NpZ2ovbGxMOVJ4SkZqWGlIMGt6YjNiMzl6aGN2ckQ5ZWtNNHpGNXFpNlRqdndpTkhkOHc1eGZ6NC9OdnNkVUdJRUdUaEQxK3pabERIVmExZ00xT2g4RGNLVW1oM0dMVzhFMFV4MnZJRFlUeGZnNXVONUsxRURuNkhzSFVicXI1a1pJMDZPWEpsNE5WbWt6Y1RDMERJYndrb1Rqc0l6ZlN1UE5pS0tiZk9MMlFmVldlUW9JNTU4aXhwTHpYZjBLeERObFV5V3pwcjdMNFFCbzhRV3RJN0tiMHA1TVJBYlROVitJWnorN3RyNVZwMCthd25SbXFtL3BMRTFYMTd0amxQeUEyK3FSUU1Hek9RbzJpSjBjUXhxckQxMTVsdThyZlIrTDM1cUkxVmdFM3NHN3ZDeG9nUDg1Y2xFTlozSVQzTk5lRzMwcEg1SGxHLytya3p4UEJSNlo0WitIOE9QVmxrWFdlYzJLd2l0T1lIMlZkNWNjSHlpVVBBY08zVzU1R2g0WUJ0dSswZ0NCNEdwZVhBb0dLNUxnRTRZdlpZdGlYZUhHeUdyK2V2R21SM0x5R2ZKcHoxT1FUSkF3d1ViTmRJYTV6ZERoRE9NYzd3aEM0NzFZUjVZK1p3ejBrc1plN0wxZTVQSFltTFk4ckt0c2JnMG1DTzNqWHA4cEg3R3hjOENJUDhUVGlROFdFdG9kY21DTUhQVWtZSFFnT21yc1ZPNVZBSWVUbTFoTGNOMnhCdDdWaGZ3L0pnNXNyMldyK3BOVlozYnFxWVF5SnRZS2NKOUV4ckFDMkNzM3YrL1lOaGRWNzZnOUxGVTFFd1k1ZEJsemVCYmFXZlV6RTlxelRTTURaeHR4STVxVXN0V01JMzhKcDg0SmxpbnZDY3FDbzVHUHRwM1FXRXhLMXFpTFRTZkd6T1lvcnNyam1wbEdqaFNnVUFheTZQTHVTZjNhd3pscEc5ak9sM2lacDhVMHBabmZkYXZRWmFmbEUrVGdzTUdyMGc0L3UrTUsrWUk5bHk2d3dOTFlSaldNbVIzSWxzV1ZLTHdHdUo2bGNKVjhHc0p1RER3VlpmeEQ3a1JJRDIrSVZ2OGl3NjBHQlpJeGYvelRYTmVsVVh3bHB4VmI3WlM2RlBzbUU1RlNLOEpKd1VSbjB3amdFRXRBcXJLOTRpb2dza0xsVkdRUGVrSmtvTysxamQ3UjFQQW5DTGQ2YndXQXMrSzNRcnlzSlUraEdFS09GSFliUFoxZ1lpTEx6Q3J1N1lSNHV0aW0xMTdQVi9DR281bmpDTDVBazFKTUFqSWNxVnovcHhuWjVDSzArMTlUSTh6aFFuMkJCY0lYYytCQUd6OXl3M0tZcjMzUTRLU1R1bkF6bnlaVDJ0V1RzdWQ3N25kQndad2k1MHNzYWYxY1E1bldvUElvZlJWcGtrRFdZSDN1dW5vOWtIU0ZkZkJCRk10bU5nSXMxeHAveWhOVldVbHFCQUpYM25oSWNaSHkzZHpCREdIcEhJQTRkaG9QZndHMDJFanNueTNkMGx1N0ticmhTZGFsSGxZa0p6SkthYkJ4NmVQb2JwT3JOQ2hDZjdrWHdQU3pwcEZFdkxMYU0zNzA4VDllVG8yTGh6UnJoeHA5THdvak9FRjVGd21namtNWWJWMHNXYlhnK01SQWRpOFRqcmpUWXVTNFN3PT06Oh0Ly9uhjX7bosfTh6SK6RU=","774:elementor_14c788e","approved"),
("129","","2025-11-19 09:21:51","1","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","774:elementor_14c788e","approved"),
("130","","2025-11-19 09:27:12","1","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","774:elementor_8337c90","approved"),
("131","","2025-11-19 09:27:44","1","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","774:elementor_14c788e","approved"),
("132","","2025-11-19 09:38:21","1","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","774:elementor_14c788e","approved"),
("133","","2025-11-19 10:08:42","1","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","774:elementor_14c788e","approved"),
("134","","2025-11-20 09:27:15","1","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","774:elementor_14c788e","approved"),
("135","","2025-11-20 09:32:33","1","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","774:elementor_14c788e","approved"),
("136","","2025-11-20 09:33:32","1","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","774:elementor_14c788e","approved"),
("137","","2025-11-20 09:33:41","1","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","774:elementor_14c788e","approved"),
("138","","2025-11-20 09:33:45","1","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","774:elementor_14c788e","approved"),
("139","GALLAY","2025-11-20 09:47:50","1","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","774:elementor_e113d31","approved"),
("140","","2025-11-20 09:47:57","1","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","774:elementor_8337c90","approved"),
("141","GALLAY","2025-11-20 13:48:33","1","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","774:elementor_e113d31","approved"),
("142","","2025-11-21 14:23:24","1","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","774:elementor_14c788e","approved"),
("143","","2025-11-21 14:23:35","1","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","774:elementor_14c788e","approved"),
("144","","2025-11-21 14:27:01","1","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","774:elementor_14c788e","approved"),
("145","","2025-11-21 14:31:51","1","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","774:elementor_14c788e","approved"),
("146","","2025-11-21 14:32:00","1","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","774:elementor_14c788e","approved"),
("147","GALLAY","2025-11-21 16:32:15","1","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","774:elementor_e113d31","approved"),
("148","GALLAY","2025-11-21 16:48:34","1","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","774:elementor_e113d31","approved"),
("149","GALLAY","2025-11-21 16:54:08","1","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","774:elementor_e113d31","approved"),
("150","GALLAY","2025-11-21 17:23:16","1","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","774:elementor_e113d31","approved"),
("151","QUESTEL","2025-11-21 17:23:30","1","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","774:elementor_e113d31","approved"),
("152","ARC","2025-11-24 11:33:32","1","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","378:elementor_b9dc4a7","approved"),
("153","Anthony Renaux","2025-11-24 11:37:45","2","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","378:elementor_b9dc4a7","approved"),
("154","","2025-11-25 08:52:31","1","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","774:elementor_8337c90","approved");

INSERT IGNORE INTO `wp_f4a5sfea_submissions` VALUES 
("155","","2025-11-25 08:52:52","1","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","774:elementor_8337c90","approved"),
("156","","2025-11-25 08:53:38","1","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","774:elementor_8337c90","approved"),
("157","","2025-11-26 11:34:03","1","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","774:elementor_8337c90","approved"),
("158","","2025-11-26 11:59:32","1","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","774:elementor_8337c90","approved"),
("159","","2025-11-26 12:02:21","1","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","774:elementor_8337c90","approved"),
("160","","2025-11-26 12:13:03","1","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","774:elementor_8337c90","approved"),
("161","","2025-11-26 12:17:38","1","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","774:elementor_8337c90","approved"),
("162","","2025-11-26 12:17:47","1","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","774:elementor_8337c90","approved"),
("163","","2025-11-26 12:22:00","1","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","774:elementor_8337c90","approved"),
("164","","2025-11-26 12:22:16","1","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","774:elementor_8337c90","approved"),
("165","","2025-11-26 12:23:41","1","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","774:elementor_8337c90","approved"),
("166","","2025-11-26 12:23:54","1","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","774:elementor_8337c90","approved"),
("167","","2025-11-26 12:27:47","1","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","774:elementor_8337c90","approved"),
("168","","2025-11-26 12:27:57","1","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","774:elementor_8337c90","approved"),
("169","","2025-11-26 12:29:00","1","R0RSdlE3V0MyY0JnKzdSSjBTTGlhQlAyanJyRFgzT2V5YWFyb3RsOEFaMGVva0pZbnFCRkdtOXFZUXdhZU8yUjJmVU02N1dKOHBGR3AycjVjM2tiMmxmVXNyYUFLTFIxSTR4aGFNUC82TndXRWpaRGgvWkdXYjE3RjlwczJ2TVI2SUZwejJ5cTFlUUtGWnoyTEdSQjZXb29mWHpYYlNienpvQ00wcWhUQ2ZZamFMUXR4SkZRZUxOQ01WZ3JoZGtHL2d6SXN0aWtQclN3NkxNTWdzWTNMVk90K2ZlWWhqWEJaOW1pVVRqeXhrN3VkNCtWNklTL01iWWtJRWZ5NC9rZ0w4Sm9FNDd5dUlUcHZQRVlXYjRSdyt2TUtTQU9VQ2FET3ZrUW1NTzcvZlpBdXBad3NsY3BPRm9raXh6NGdQdVdsS2swMko2N1UwcG1uOXdvbC85a2U5bmZaY2JMdTBMakJsNUZTTTlJU1R2Y2owUVdQQXhvbDZRN1hDcTZUaGU5SW1WclVZTUdsZkU4OEhwOGZkZ3hUTjRiZklZTUFQSlVBSDF3bWZuM2Z6aGxtOWZ0UGdEajFpdmRuOWZmNEtHQlAveVBLS09TRVRlekRMUkxaNnhsMTNYTFdUdWhCWmJHTFJUWWRZazg2UjY2VEhwQjRPMmxxK1B5U3gvYWljMVRmT3ZZR2Ewc0UvaDVqRUpPOEFybndVNHQrbnNDRWZEa0ZqbDY1STZOOEhrNTV3RmpZUFJUYitCMS91bFFWaVc1dk1XSEVIU0s3Wm0vNDhrb3hreHN1Y1J2MEl5cGRBbFdTR0dCREhRRVNaRnFvWnVBdjJpTDRJaTQvOENRdGN4NFo4Vk16aWlXOUk4c3VGNGFjZEFvU3g1YmV2RXBNQ3g3S0tZbmNEZXh0TFBtRVlVYmtDQ2dLN2F4VWt4OXlSWmZjTU1zT0tXN3hRTk1ZUWZNZE91NUlOUWtTdWNLYWd3d1dnY0VDSUpHWkxCdGtFcTJ6RVc5d3hOWVN1amIyMklJZmJ5Q1ExMm1GOVQvOTZ1SmhHaUs1aGt3Ly9DV2gvc2hmU2xGM2dxanBlNnNKakNuMmZ3amN5aytCclVuZ0ljRUNFMDdyQk1mOHpqYmZQeDMraHBBandjV1BwalltT2tQalBOdlNZM1FBdUg1VzViNTk0UTczYVVFaDFNZFZIcXVQdmduQVVwWkNNd3dQbXJNSmg1K05iNURhemo1M1plWXhPL0xxamxWQThBVkJDSE9KMnVNQkJjSUlhVXJlWmVMSHlhOVJiMzg4UFFqRVlTbmxnTXZHSThaSkpiYUJ5OTRuekdiUUZZR2czeWlpUkVIRTdPYnpMTElISHBjN2pvWFJ6cmVRNHh4dkJjSFRxaUN1dFFlSUR4K1l5a0Z1T2xHUmZObGMvUU9VMDl6QTBHRnFpdi9xYkdwZHMzd2orMzNuWWlnTUptMTZzQlhtenR2VEZPRzRmMzNFWDFvSjcrRHE2U1Z3TE9GanUrZkxHYWxsYURmN0YzblRuR3A1SnRvVkFiZSt6UmdUR0kzR0JYdDlzVWVMUitobzM5VDZtdzVWeUdPakx2aTczWTJJYzRBdHdnSmUxNk5sdDFGQ0VOMVZ1RlBwMC9GdEUxNHA2ZmNNb3JhdWErMFpna1B5UDVBSjc2cFdEclFiazlyVjZIa2FxNCs1OGhMSlZHMmZFZmNGUFN1U2pVVFR2YXpWdmFNT3YxUmpYaHFKQlVyMnFlV0JrQzlKSXQzeXdsQUpDK1dCdmFObVc0LzkrMVZyUTBjUFl6ZW9Ba2lhWDgyZ1lRTmtaYURHVHFQaTZZc0wzaVFRUnBKU2Z6SUNMVE9zTklzWXJpVm1pTVpDZjIwSHEvY1pJTThQSWhHWFVuekgxYk5ESHh3Uk03QjlNaDZrR0sxV2pvNWRYU3R1THAwdHBJT3JnL2plWnpiMjFaRTNzeTlLN3hnNVpzVnc2TGtVNlJnUC9kVlo0TU5vclZVMW9GdzRncUdLWHF3VSs5Vk1RSldSN0dFZ2ZWN1pGWmdJOG5kbmNscVNndDVTYVA1Y01COEZ0eVRTNXVSV3FVckNhcitVNVFWZ2tpNk1SMGlkVlFzRGxVSTMzbXZWbHJGMGliK05qcGJsc0VUMm16c212VXFwdk15NkVBUm5IV3pKaXdoSFZyLytZT2lGRzJ6VnJiY0syaFU0NTg2Vnd5QTRIV0lnNWdhek04UXdWYk1uKytTM1hWNm9hZCtPYUVGT1FxY2lpaVlUMlNlVFVxMXVReDlEeERMRG5HdlM1UGhTY25rajJ5eWxuL3FiWDNDS2svMXdMOGtEYjFoSGN2Q2l6U3B1c0M2Y25IdjhUbTFHV3VkbDRBM2pIamhWeW5oNXk0bzo6mHa7gcMReA7e6w7lQMnVeA==","774:elementor_8337c90","approved"),
("170","","2025-11-26 12:29:27","1","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","774:elementor_8337c90","approved"),
("171","","2025-11-26 12:29:53","1","cWE3NXNNbjZDVkxTeVUxZENud2JWS2VGL2F2YlJIWXJHYmdyOWJsc1ZKd0xDTENpYVJDOXpXRXErNmIwMHVLRkZDTkxqZjBtMWdHdU9oNkl2b3BGTnNqMmM3dnh1YTFDQVM3d2NJdUNtaklOcGNoS1Q0ZEdyZ082TlRUMlkzaU16aGg2cHRscGdUYUtEZTFBK21kSlgvQ3B0T1l5NVhMbE9lZUVQVjBXQkN3ZUNLL2p2NHI0YTNBc3Q3ckZVbXZFdXc2RDQxYUJSQW1LUjAzUFpNeDQ3UzArWnpoRFNnbWVKc1RSVnlZMlpkNHdwdXE1SjhjSVE3ZkJrbEtHajNhMXlqZ3lLUk1pSlhhb3FOWFdiQVpyYm5wdjU2OTBKaEZKT3F1dTlnbzIvSy83L29NcnllOWFoTUUxRENtNjZrZkFuY1RuekpuQndaVXg1SDNZWk9IM1VBNzkzZUVHSVROVGJhRmZZaVlrWmp0TDVYMFI5cS9SS1d4dlhBc0hIWTNLbTA4R0VrOW9sS3VKR29TdHpmSnlaVDFoSEk5UlNEYTgyc3Q0eDZCSWZydU5tYk1TQWpkdDhBTE5rQXVkUFQzakJYVUxrNkZ2cjFnTFdIanV5TWpjajVtNW43MkZyM2JNMkRmdlhaZmIycG5idytsZk55Nmlxd1VOL3NJUG5ZNTdZbFBhRVZFWnM1aXplTkNTWHlzVUtGMTRwWnYvREdneGY5MWxpRlZFVnhVMzllb3NNV2pZN1QxMmtPVmxCY25DWUhOaHZ1dVlIR2FPdndNV1R2Vk1LSktzczV1MVVRZlF0WUNQZHBlai9NWURrcjVPTFA4R29KdlI2djBSRkVWVVJoZ1p0dDA3L0NrNXdmeXBSWklXV3Q2bHNhOXIrTm42bUJSQy9nZUlXTFZnZG04TXJHR285YTUrU3g5QVlVakhKNFI3OFAyaFdUZ2FQTWZUQ2tteEpBelRjVFdtakI5bDEvWk9rdUVRM0ZTSGJ0aUhJSTdtWWYxOGF6VlFCZVAvVGZpa0YzWE45U0E4YXFIUjBEMmJZcGRmOUNSNDF0NnNFZW45ZkFXZ0hHWklDdVBGV1I3S3B0TWNFN0xsSDArNEU4alZzb00zZkl2SlJLVzg0THU1TTlYOEJKckNnRXhxUDVSUEtad05zVXpDR3U2TFE4Y3VtQU5RVVVDOEh2Zm9yYnlzc1NMR1ZZOTJaamYyVGt5Qk1RTlVBWTg4cG1oTE50c1BNRzdtRlJKNkI2T0tVQTdSUVBNWFU2b0wva0xiRDFHUlRjZG1jSVExUE1IbXBkZjNwL0lvcnJBSkVSN1lJZFNqd3R0OVU3VTlrVS9LODlOazlBUmF0Yk9oeHNVdmRCcDRrMGdhekhQbFNQRi9FWGZFcWhmRjVtSFRmTWJCV2UrMWdDOWlqRnNIbURJcThkbEExTW9MNnQ3N296b2lWM2NWVk9nSUJ4RnI4QzUzSWpadWdDS3BDV1BESittS3FvQXFSYU0wSDBrMmo2WkQ3R0hEdm1wYkRFSVVQWDQ0TFBiRTRPZzduYjl1MnJKUjcyMXM1U3pMYndCZjFhTXBqRStzTVVrY2M4dU9QbjJWcVViZEdYQ2tUUkwzWHFIaGJ2MHlnNktXQXYvVmY4RHYzazFtZkcwOE0yeUZYdTJJQ2p2R2paZzV5elpQR3krQWpONVYvN3BvbDQ5UmdBUlUwSzVZc3J1YlA1VDFjR3FVNy8vZk9jaUoyMk5LMzRXU3dISEx4THMvUE1wM0duOWFkT25kQ3NybGZpMzlYNlo5cHc0U05iSUFmb1VNZ1dhNmNqbktKSHNzeVVTY2VwWFk5K2hNQ2ZOOE8raWp6cXlPdml0TUZpUG1MeHpuL3JXWTVSYW1lYkFGMEJ5UDlHKzJhM0k3STVCTmYvVkwvY2hBRFc1NW8xN3RiKzJ3QXlGZVdsejA1MGZ6WkR4K3YweUY0N2VnVndrODE2Ny9mV0RMVXNqaFFmTDN2SGdvZTRXcUNWcFcrOTRsMlpqRVBmMWloRTZtQTVTZ3Q0bFZBRVBIQlpiRDc1V3hZZVJjcWlTNSs5emJtNnlVMWpIV1A5Y1RqeC9wYWJmTWVBMk93a1J6bEFxZ3g4aUE0d2dPWjBKWmZKOUFkcTFpeTloV0o2UHVoY1BSaWtRbEt5L3lQazVid0wyaU5GM1p4N21lTEkzejc3SmI3d3NidHd4UTVBL2ZLR05sWnB1SjJEcm5KOXorYjkxdm56RTZiY1M2NEdhaXlwYTIvRWg3NGpnUitaTGh2UnV0bXlPS3FQNmxENFRwL1hqcGNtZ09xRExJM2xRS2ZMVlh4MXF2SEEvZHIvNTVsNm54UUhDbW9TTHltWkc0V0k0RFYzSTlkdUVJZTJxSDo6M2kj2wRMoayIwXn9f0KZoA==","774:elementor_8337c90","approved"),
("172","","2025-11-26 12:32:09","1","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","774:elementor_8337c90","approved"),
("173","","2025-11-26 12:32:29","1","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","774:elementor_8337c90","approved"),
("174","","2025-11-26 12:32:40","1","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","774:elementor_8337c90","approved"),
("175","","2025-11-26 12:32:51","1","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","774:elementor_8337c90","approved"),
("176","","2025-11-26 12:34:17","1","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","774:elementor_8337c90","approved"),
("177","","2025-11-26 12:34:39","1","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","774:elementor_8337c90","approved"),
("178","","2025-11-26 12:35:41","1","RnhTMWlTSHJhR3RSRHYxZm0vRTJjU0hKZWgrOVVEREJYb2NJY0VJWmtRbkxTSXhhTDFXNGtvM2lwalV6OC9YTTVDNXJtN2ZOV2JhcWEwNklza0p0c0F1YWs5N3VSTDBCcXhvMytYcGFZREJoMlhmNUVDaWFxZjE2NjBqRXFsUlJEOWIyZU9nTjluZnRSY1dubk16d0ROMlVuNFEvS0kwWmN4a2ViaExLcy8zUlFKZXEyQldaaEh5N0wveXJsR2RRUzRBc0RpVk5Bbi94RU5zMVFWTlFVaG9aclRlb2JVR1ZaWWlVdlB5YkVaZTBoNkswRFJiNEtSQkhqdzIvYmJGb0V5SkhpMXZ0Vmkzc045NkQ2NVFITmFBd2xQTEdDTkl1RytIL01RMDlxRDVFMGtlNXlsQXRyM3ZDczhabFF6RUdMb2w2cVpUREZzb3MycjhVZkZ0SDF3VTFwQVgxZDU1WWtaL3U1QmtEcjh0Mk1La29VNmpYSmE3aXVITkVlVGhHclV0U2JYaHA2MmZ3cUYvc1ZnTExLTTVMb2VKNWI1UC9YVWlLczFjR1hLT2o5STVhTXI1amJXc1RLV1hsd205enFHbkNCeHVabG4rdFNvZGpTWjN1SDBOaDluTmxrSEVrd1IrczlybERlYUNub0RFR0VTT3lVWmV0eW5HNXdMRDVWVnNxMnJ5SGxBRVVibzFmT0wzQWswUFo0V2JiWDJoT2pSRGFHclBFR0xYeEFPdWtXem5mb3RzZUZRUkU5QktuU00xeklrTXZwMkc4YnYxLzN5TlVpK3dxYTRBUW1PbStxQzR4bGR5Z3RqSUx3SU1WMEFEUnlvdzNKQ2hNbU9SejV6MytpK0Jvd2FESi95VXZqZ3MvNVBROHZaR2h1b241dnpKU3NVKzJFbGhYZStJQ0tSbU9XT1lNY0pES0x3aXIrVENHV2kyZkFrT0ZJK1FWVWVTUHpsNzRJanFqZFhiM0Vjb1ZvdTdKNnNyemZYc09QeGJHTEZJSm11ZmJ5TWpGUHdkbWF3TldYVWFPZkxQQThaUFJiOUJhMjgrUzZBMFl6dTRURnozeWxLRjduMDl2dlB2Z0VHTFFKNC93NVVaNzh3eVkvbnl3blN4Y2FnVVR5YVoyVUQ4MUp0TlRyZTdOcGNpWk1RYlBUUlprcUp2VlUwbjhkeDhCZFVVVXVnNitieFBmWm10N3lvajFQMzdyS1QyTUxpRVoyZ0hrMjBqVVBxd0txNkRKQS9nSGFsd1ZMeEpod2J4WUo4eFgrcW12V1FoZytMaW44anI3ZERydnVFR25NdVg0VlpEc0NndWJZSzI3WW4wbUNBSGN6UVJNMmhhaXB3MHJKeGptWGF1ZE4xTzdFY3NqQmZneGZSYzFJZlRHMUhnV0ZEVk1pN0E0YzA5UEtkbjd3dGhYcGlYL0x2d1lzRWkwSndQdXZscXRjK01Pd3FzMnNEV3FFVkk0UmlGT09KeE9udjM2VVFLNXd6Y0N3ZngrZHEyVlVPZzd0UXRxam1XMU5rQXFqZlk3cVo2WEp3dElYeTIyd0hucGVIZzA0d1pGbWgzTCtsTWxwemN3bE9LYnp6YmdrbnZSRjJnZjE3NnFtVEViQy9TN0xwblM0TU5CV09BZnd1RmRXZzBEU0xaY280TWxsM3BVcUdCL05iQ3JkcEdycVRSYnRaenhYQmZVOTNHSHNZc24waGNQcHBEM0puK0JqbmZ4LzJMdnBtbzUrbmdmOExmejJBc1hQQmRnUWUwZ1RDOGoxZFFaUDFUZWl4UHNCMkpSZjBjNmNpVmxiUm9GOVR4Q0UxVDhKR3ZRV1BLalByWG5GdFp4KzAvd1dscU4yZk41b3dtaU9UU0tjQ2poWGpvWG9rbVlvTlNIQlk2cnRnMnNiemw2UVBwdGlENlAweDJ2cUQvVGRiSHFPRjBMQk5Ld29FUCtpaTdWUUw1RytES0pnRWVNZHY1NE5hSTNqbW16Y0JaUzdxK1I2VEdPcHBaWnRtNWlYSWFXaDBMQ09xRWZiTUlpSUlEeHhQTHJDcm1qNzdDUW1rOWZsV2RBZ0M4V291NUR3VXFvb0wyTjZsVjJMZWEzdm1NSnc4ZkZyQ2k5UTVyVDh1ZnUrRDFLMVNkMzhqTGhyKzdoMXd3NW1MaFlmYTM5NHFvV2xtcHpqYUFxQTlHVWdoRFVUNjViZ3JLL1ZLL3FKTE1CVTEwVWpBV1JReVV4Q2RnWEZrV2RrcGE1RWVrOHNldER0NUpOcVdOQlVxRVRQOGJjazFSN1dJL3hwQmZwaGVwcDZXQ2pCa1hWaGhaMnhFd1JMZjR3dWRFQi84SFhITXZ0Nmo5WHh5eGs4TlovZVU5Wkk5RzNyc2VpKzJBSHRNRktFaXFqd3Y4ajo6UQ2d/j8uYSqnZpUb2k4OSQ==","774:elementor_8337c90","approved"),
("179","","2025-11-26 12:37:35","1","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","774:elementor_8337c90","approved"),
("180","","2025-11-26 12:37:48","1","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","774:elementor_8337c90","approved"),
("181","","2025-11-26 12:38:50","1","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","774:elementor_8337c90","approved"),
("182","","2025-11-26 12:39:11","1","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","774:elementor_8337c90","approved"),
("183","","2025-11-26 12:39:28","1","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","774:elementor_8337c90","approved"),
("184","","2025-11-26 12:39:49","1","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","774:elementor_8337c90","approved"),
("185","ALQUIER","2025-11-26 12:39:57","1","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","774:elementor_e113d31","approved"),
("186","","2025-11-26 13:34:56","1","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","774:elementor_8337c90","approved"),
("187","ALQUIER","2025-11-26 13:35:05","1","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","774:elementor_e113d31","approved"),
("188","ALQUIER","2025-11-26 13:35:14","1","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","774:elementor_e113d31","approved"),
("189","","2025-11-26 13:35:27","1","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","774:elementor_8337c90","approved"),
("190","ALQUIER","2025-11-26 13:35:47","1","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","774:elementor_e113d31","approved"),
("191","","2025-11-26 13:35:56","1","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","774:elementor_8337c90","approved"),
("192","","2025-11-26 13:36:14","1","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","774:elementor_8337c90","approved"),
("193","PRENOM CONJOINT ALQUIER","2025-11-27 10:28:41","1","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","2816:elementor_ba99f83","approved"),
("194","prénom 1","2025-11-27 10:37:35","1","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","2816:elementor_ba99f83","approved");

INSERT IGNORE INTO `wp_f4a5sfea_submissions` VALUES 
("195","prénom 3","2025-11-27 10:42:33","1","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","2816:elementor_ba99f83","approved"),
("196","aaprenom","2025-11-27 10:44:13","1","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","2816:elementor_ba99f83","approved"),
("197","aa","2025-11-27 10:48:08","1","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","2816:elementor_ba99f83","approved"),
("198","aa","2025-11-27 10:49:33","1","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","2816:elementor_ba99f83","approved"),
("199","aa","2025-11-27 11:42:31","1","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","2816:elementor_ba99f83","approved"),
("200","bb","2025-11-27 11:44:48","1","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","2816:elementor_ba99f83","approved"),
("201","cc","2025-11-27 11:49:39","1","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","2816:elementor_ba99f83","approved"),
("202","dd","2025-11-27 11:51:26","1","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","2816:elementor_ba99f83","approved"),
("203","ee","2025-11-27 11:57:04","1","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","2816:elementor_ba99f83","approved"),
("204","ff","2025-11-27 11:57:49","1","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","2816:elementor_ba99f83","approved"),
("205","gg","2025-11-27 12:01:22","1","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","2816:elementor_ba99f83","approved"),
("206","hh","2025-11-27 13:54:18","1","RzV3ZTVvdHdpSU1TTXhPSitBT3EzanA5bVczWjRCZlZ4ZGk2bGR1ZnRSWFB0ZDhLY0x3NVZJRzRjZHM0RXl3VFBaQ0hraDd3VDM0SzhIczNPVk9NYmJwbmkrbnRGY0dGOEJEWHhDZEI4TXo0VkczRTNZUzVjRzRTVytjTVgyZTB2bVZxMm12VTVuZEllenBHbWZOMTVwUkZRd080TFRzck1jWXdlSGxtdUJsR25QSjA1aWJEMkI2ZWYva1hMb0V3MFA5MHpOU25PNmJVM2NKL01nSkZubm5RczRIeW52QS84dytWcVRhZDNHOVV5UEtSY3U5d21nRXVkRFFsaUFUMHRTb1NicFc2eGkyZzFrNUZnS0I3WlVnOUt0TU9pa2YyOStzTjlJcnJNWkJFVVgyL2UvK0JQcjBGM0NSVzlqVWVkZi9nUVU3eW84N3JmMkZVRHR6dDE1YWxTT0tuVEtYYVcxM09VWE53VHBqVW5TTXVXRWtYZGlsVk5qSTB4WEhaTEVsdG80UUlGWmV4aFJ6VE1YMllSL0xqcW9GOHJYU3FmWmlqUVhNaHNNTGFaSEZ4YlhmYnNacE0rVjRrczNrUkM4VVltMHFxdFE1TmY2VWFFWHdBRHBiWlNidDdiRlFISkxIV2dZbGtVVEg4NXI0UHZUU3diNFRnUktUbkdQOVdZbXUvdVFjOHpORWRuWXYvdDV0V3JoM3JzckkwN2VkMlVud05EQTF4eUFDRk1rQkk3eTBFeFFSd1p6eUxqVUNHa0Fkc1RBcUxVd3NYMU94N29oOWVnQ2xHYW1ZQ001YTFzSXFZZXJ5NmN2TlNNdCtaMUQzWW4rYXl1SXZTR3ZYbkp1QVNDdnZ3ZGRWY1BnTk9DRUFocTdwTFR0ZE1QSVozYThjWlp2SmdHcjFYT1lybENiQ3NzM2tZK1BQbThUQ1AzM1pwSHNRRDh6cy8zRDBoejJrVmhXakJlaHdkTnk3NHFadlEwTmE1VjZTMmpFd3pQTS9sc2hvTDNZR29Pd0o1K21EYjNWeWgrem5UU2tGU0o3QUE1SEN0bTBvL0ozbkpTdWkraGt0OUVaTTBNMFlWQVprQTZMeFo3SWVqZlR1Q2VPWWxlN0M1V1A4WXdMMm1lcDRtbDdhUkljcHBZZXhBaVpGYXIrNWw0RFh5SWVyRlVkVHJxbmh0QWk0ekpHQVdaREErZXRvVHY3U1RxaVdBSHE3U0R2KytHZkxGUUcxaWZmN2xHU29OVWFzKzVmZEMva2RYR0dsSTZvNU1uNE9ETHA3TDZiak9HTDhma2JTR2t5VDUrMjBXMVBEeWQrQkFPZ3RZWWRLWTNTc1R3QkEyS3ZKMGd6U0xMNzVQTDhlTnJQRWpXb2JVMUpNL0NLTXQ5dVlsa0NGbkVSV0Y3S2Q2MFI2ak1aU3k5ZDU0aDNhS1NKeVVRNFcvUWx0dk1XZkRzcnZMUUR3TFVRSXlnK3F3OTk5bHRQNUtRK2hBWkxuQTlicmx3QzVrb2RiOGdDUTZwSm5wQkpmVkdrLzFFcnJCZ2hjUXUwM2xMSjFGVTZHNUJhZlF5TXlOekMzQWhJY3lObnZ0TXVQV0ZBTXJDOUxQT2k4ZCt4d0pvS0dHYm5JaXlLTTRkWmNaOGtlbGU0dUVoMVdwTGkwZ0M1QWxtVlhkUStxcnNiMlVyYVA1dGRadWVFUWNXeDA0V2Z5b0Z2MDdVS1dMUjFaS1hqMEhLQjVRKytxYlEvcEhIRE5LamVFQzNxa1piRE56ZDA0SnlmVVZXT3hzYjBJcjUrZUh6a2swaFNZUC94Vjh2eUt6MmlsYk9uQjNqcmorSnJqYWowZFFYcWRBTVpyRlVRL29TT3g4UjRhUFNxZmd5WjdRN0MvTk1abUdQR21CU2FxNlF1ZE1kVDRqeW45cFdyaHhUS1ZxVnczL0ZRcmxtblVlNDZzM0FmbzJnMFgyajNvSDNadW5QNDVjcE9SRHpmR2lRNnFrYmdLTUJjOW5ld3FXOHIwa1JHampTeUFLRFJsZU5waC83VG1DYzN6aTBoQkJ2WTJnWkY4YzZndHF3cjREWHJxVmpNalVpZ0wyOUtMSGJYQysrWkg4NFp6cndvZFRSY2hzb1hIQ0ZaZnN5bFpmUDZWMWIxL1ZqNXAvTC9GZlM2cUY1S0FQUzZ6ZlIvbitta1EvSTVKVUpUWk5ORW1SMHJ4TWtGU1ltVzVISmFVMlNnZWNiZE91cHhITGZIR0x3bWlURWFhS3ZkQm0zb0szQS80TGUzSlBLN0lKMUtvcVc4MEZTWnNIQkg5VmcyYTlEY3I2YUZnbGpqUlIwWTJnQzB4SWU4NVZScE5YTkVOMlZ2VGhQK2ZNVEJ1Tyt4QkZSK0d2VEFOVW5VWkZ3c2RCaUllWVFmNHVRU0VPZHBqTlFBdmlSWlBIaGN4WWNod1ZjVHNTbHp3aDBKMlJtVlB4dDdZTzdGWWRxRjJyczhkT2JkbDBXaEdSbzV3WEZuQUhSUC80dnUzTy9qMDVMb0hCL2YxMXhudW1ad2JvYXRKNFhEYi9XZDFQdEMzdXN3dGh2T2x4MG43Vi9ETW5TSmhTZEFYV0hCQnR3NUFNdDZnWEVEN2trQmgzQU5oMnhaNjlPU3JabEhoR3Fmd05KaDY5K3VudHlFcmo5NkQxK09NSEQxVm12OWxaY25CZy9PZUhIa1FCS3RKM0pudHB1UkZ2cktuQUlHUTlGQkdiazkrQ1JaTGdraWdwTmhzcDhlbDJUNmtYTWJ3MVFTQzJ3ajdXMEhlbVd4RUxtOGY3WU14THBFUEhPU0U1ZjNsNmtTMlVrekJmcUFINlV4ZW04S3l2TTVlVVM4OXhBcTN6VmVNQlMvK0R6bzVaNC9OeE9ucE1hbFhCQ3FhUUtmZjR3cXp0clVFQnRVVUFhTGJxRFZlbW1zcURxMG9mSUxBZS9zajBXODkvL3ZtZjdoZkNnNkZrbW9tZGtnemdmbThpWndJYWpUdTFBeFllZnd1VWlidXpwQTNXSTBTV2sxVFE4WHdDN1RkWGhHY1lFRVR0TithQ1daaGI3STBFMFozdkp0ekpOeWpwWmRSWi9UUzNscWNXWnorSHBtdldPM0g1RjdtSXlMNkRtWFdkaktkUS9jLzQ3SGJsQWlYenBxdnk3NHFhcS90WlcrSXlza1dhMi82T2pDaEJuMXJ3WUtXL1BaUUxiQ0JXdkxUTnFQUHZTVjRiMVpZdWZ6eUp4bTZJNEVvWEozSldrZ1hPRTNwaFpMeVdYT3hZTmpaeXd5UGJqRUNrdDJCcSs5SFNlUk5CTjJLQUxaSjZZZGZUS1h3WU5adFc5Vk1hVWdaSWY3emJpdERMK244dzVCcFhqMG5uSHZNKzc3MFdDOHkwNFplVkFXZjNKeW9BdTV4UHNrZ2RYZE5CT2s3MERZcHF5OTlBSVIyeWxYcUJ0YUswVjJHcVNxWlEwWHNUZ21RbGxYSE1RZmtTWkkxZmhuT2J4WHpwTmhCQjdsMFBpZHFGOWRTbUNWaWUyZ1dJeUtwS3JsaTFSUXRqL3NBNUgrTGxHaEt5VjdWaUVRRkpxL1dDaWVpSDFlQTZTTTJtcG5wZGRWRXVMWStzWnp4Yys2RlBwcHhaVXN4VTJ3L1BsVC9CdDhodGJrTjJWekppc0dKY05JYU0yemJlMkF4REEyRUxXa2tqYnZNZUJwRC9LMjEwYVhlUjZOVnVaNG8wdW9zdldSM0JRVGNpM0luVXdnVEZUbUpvWmNIY2h2bVNIRTNVMDRMSTEzcUtSNWIvYmcxdlEvaElkSzhvYjhXbVlGRCsvOFVnL05JVEpFRlRQNld4bmV0VDBNL3FKcnlJZW56R002V243STdDNEh3bVV4d3VKZ1k0cVk1LzZESTlNczgzc2ZIYVd5Z01STDZpSTRxcXdMK1hoNWQxd01WZHVEOEozOU1QS29hVDQ3TmFPTmpnTW1pTHpqRVQraHVxcUtBRU5XSmNjQUpwZWx3WVVnM1VUQWdMcFBpVkVhN3pPQXlvTThCU0F2ejc1QWkyUGJNQWdoVjdzbEZSdGZpZnFwSWtDbTNRREp2MHErMEYwaENlYnM0YmhTVjFHelp5ZW5XUUR6VWg5SGJ4M1NFOC8rQjNWRUIwWXBEb2h3bWRaU1FNOXh4VHRKQ0pKWHB1aEp3YUZ1QlE4bmNISmVMdU1iQkxCdUpmenJadlljbkphL09xUnRBdGZwLzFIYnJ5N2pjVkdUb2JhVUk3UGF3b0hXT1lib2dnZlpJUHVST25rNjVxS25wMmpYbkRFQ1dBcHQwbmg4d2dlYzlsdEp2WnlJYnhYNUFuWGVwSyszRURkM2dIRGtUSTZZNGsxMC9PVUJJNGR3eHp3WElZaDlqaEprcFA1aS9MY0RHeXJieHZyT1B4SmxHWXFIbWdYMXJkVEptZTZmRmZ3SGtRaVJBNUJQWGY2RHJ5dGR1b0R6UVg2U0E4MVlpeTloM084d1ArQm1ZdU1vWVF3dTNINW13NExsU1FEMFl5MVVrczR5V2RVRGN4UHprTjBWaHlHTEZhSG84RUtYcE5UMTBSWklpZkI1aDYrdldzTExQMmNKQmx4L1dVYTk5RGxUS3BpbkxqWXFhc2tNK0cvOUlMZWZzVUIvQkpIK244Z0RCemZ4R2dIZWlPVis1Ym92NXdzbXV4RVowbUxmL2pmWVZBWWlCaFd5M2ZGQ1J2azZKY28yb0tlWEYxajMrcG1sTVB5OUk2c29FbkRLUFI4L3NRaXpqMDYrR2xCdEg4YlhCc2RGSUtHSnNZc0hOZm92QWQ4Z0RZOC9EcEVLVnl0Lzg1WmxRZDQrYThFOE9kTHBLbGgxTVJpckh2YWFiMFRndS9la2RPRUxwK29zWnpvbWlpUzJGWjVsS05CeVp2cUY0T2RBcng0WGt4S0ZjZGYzd21xN3BTREZwWnlaTldPTjlNcWNLdDVzbVdRNk9yOEVSV0hwVTBid0lvd1F4b1F1TGo0c1RNR0xuZU5rNTZqVFJPcEptWC9Hb3NHQ2ZrZjBVd1FDa0Q5Zmc1aTBBUnp6NnZ5YkJmMWZPRzA1bDF4U0gvTTU5RStUUS9jTUhUbFR0KzBzWVhBN3dsa1NXUGNVZ1dqMzN6UjcxWC9mWVdKRkZycUg2NjVwdTZocytaOUt5RFpBcHd6OC8xWjF2T1FjZkFKUFkwZWdOKytCTnRDOElYUmNXbm9jQnNPUEpDbHZRRVVudDluUVg4OC84RW5iNlk1ZnNoT0Y5R1lIcGJXbENpR3poNU0xenQxcU5iMW1VVE4zR3ZjYm5lLy9XL093MFJ2Tys1ZDZMUWFSaC9oODRNRWFTVVIvR1JNVnNXRzM0SHlxQ2JYdkhMcmtWaWQ1Mmk4Y3hnbmdVbXRnZUxaK1ZzNXd6Qk9zbmpneXhmVit3WmRKbkdmZXQrU3JWOHFFQ2lyWWllN1RNdFhsc3h4WmVKZHUxYmN0YWlyU2pDb3FEdnI0N3JWRWF4UHZOK0lubDhSVkpzNE11SHVvUzVNQ003KzNSelJUOVN5djRkK2dOeURiVlVWekNmMm1mRFMyTmNvN3FybUM2U0hWK3dadUU3YlRzWEZqWU15WDlVSHNXRWFsMldHMWIrcjQ3MEVWd0o5c0FkZVc2d0RwTDBiLzF0Q2d5VmxiVHNTZDNKcitUOW4wdEVKMjM5UWFCMUV4Ky8yUk5CbVFvZEo4bzFpUEFmSkZnQ2MvRjB1UWlwcVpPQUZINUVoYXZBek0zVUhHekg3eW9PNG10Sk1FanZMcjJRWmk1Z25mUWtOR01PUXA2NlM1UStqUHBxc3FPb3BLUGNVYXV4bTQrQkpJOGcrUWQrOGorUlBLeGNiTG1tUEQ0SkN4UU1oeEd1SU52S084THh3SW5jTWJBR2dkWkMzVllvTEVjTFVIWnprZXYwWWpsUTNmWW8vYkJVSnJ6Q1lySjJldE5vZWRETnpjeVhhaHljS1BDaXBvR05uWHp0NjB0ZXZGcDlFSFNvRTFHQVlLQzFYTitBLzA4b1pHTW9XUEorK3ZPblBUT3hxbWtjQ05HODJuRmV4NUpUelY5U1Iyd012QTA2cUJyRStwM0M3elpCbEdpbWZyQnUxTkxNdm5iNW83czI3eDFWSU9aUjQ4UFJKWWhlMHltY1RiSGdKMERLb2Q0NDc2Zlh5cHF3dUZHc1VZazFrUXBoMnNHKzN3aTJ4Ly8zS0MyRGd0b3d0NkVsWEsrRXo3RVMxNHp1MUVsQjRBbkRDRlltZ2ZmVVVYMVVZS1RXUDZZcGIxbG9oTmNVazVkbFhxU3p6bEtHWktYU2ZicEQ1U1VYcC9KM2tvY2ppZVRwTGx4cDNwUXg4K2NEYlNTa2tDc0J3d3lIS1UwK1NhNDNURlBvS0pCdDdxZ2ZXMVNwSitramNMZklxdDNVYVQvVUY1RXdqRktieEEwWUxQNXlMSG8vY0hoR0VZWEt3L2tzeUF2NGNhem81QnV0Z3QraVYwTkh2VG94cVdZa3VPbW1FWWRNdDY1WFJ2MC9ONEM5VGlJLzkvY2VTa1duVjJaanlQc0FtOGRHcFZNQmUraThUNCtkWGlSQzZ2WmpIRkM2a3I5YUtVNFV3eERmVnBiMVY3bXdrUnpWZWlCTnN6M0RwaFA1NUdHbDVOS28zRE1jQlVBZGFzVDBVbDM4aG1JalkvbklGMVZwb2dGbVlFNUxqM0Z2dE41MDFaRjlRNzVJU0hVMER6UjhkT3JtczFYZmtUV3o1UktXaG5uUklTOHYrSEJRSGRhUERrNGZQWDBXbXdXY0ozaGVPeVZZeVpZdjBqemhQbXBZVkVSL045dnRvNGVKUmxOby91Zkk1SGMzSnVDODJHdjJTZEVvMTMyUDkwR25PQWNHUGVudXlDTGcxcFd0UTFzQkJuMHpERjQ0SXRUWThDWm05VTlERnF0YlB1aWpPSlcycElWMHgwcXNtSTkxM3RtSWF1MDlLZzhWRlJ4T3R5eGN6ejBEaVpMZ1RHU0xCWS93Tk1jd2ZCYTVsb2hoZmlRa2x2V0ptS05zeVYzUW9PUlpEb2JVekRhZzdYMWRkT2x2Zm9DdWVjSFQ0d2xRelg5R3VMTUNKNFA1UFo4bFZlc3lGbTRkeVl0ZUJzZkc0OTU5K1ZSZ3J6Yk14aTdkcWNXTVBnTTdtSXVNQXRqY2h6cmlpZ1lLSnBUS0xFUkVocW93b3Q4R1NDYU14ZzRiRU9RenZhdEUyaXNmSHgzclFQSnRkczAveXVIKzZONTNCcVhUZ0U4TndHK09WeDdsZGVmVWxkSFF0T1dOWE9Kbm1XSFlpMWM4K3RJcWFlRi80QVZDRE5YWkxWYU5RQjJiRmt5dVg2SzVJSjg5aW1KK2xEKzFzamJHZFJHNWZ4a0lqT3lZeEZPRzlsc3hsajhZdkk1WFE5ZEJjTnhZQmhCejc5U1gyYXFCdytVT0dyT2t0V29jWWpId2NyK0dqNVkvVm1TeHZodUJxNGN0QTFubElRM1U2Y1k1cFlIN2JHTlpKMExZcEsvdi8rY2IvQjZaa3kwS1NuY1E2SS9VR2ZnUFdpRmorbzUvUXVzSU9HZE5XcjkwQ2hETVdvTFpvS1F4NlpxdXMvS0haM1VEUUhiOHdWbzFmbldvcmo0T1dQUDc0RVAzM2g5VXFYUVNkWlpoS1FNUlViY2FQd3RqYnNTb2NuK1ZaMHBzbDNhWGxBNTd3enJhemhBaGtwR2tEU3JKb01HZkJGN3VZMGExbnE1R2lZWTdybkdUcFYySDhudk5YNWlDQmMwaDIvQ0ZMSFpxMVZmcWxrRktaWGo3VW1hdk1PSHFJQWllVXZHb3dPYkd4WFNLOE83SjU5VVNaSkhUcElSd2FPRmdEaVVnMFJhQTJFcWo3WmpUYmN2YjJsZmdHbU1SMjMvOENLdzdFVnpQUVFaOGdtR2dwdFE4Mm1URDhWcGptbHBEbm9JV29IYzcyWVZIWjBPV1ZzM2FJemRUQ3ovMTNRTnVWZlcrTGhHSmpsYUdDSUlZSlJ6ak1WSGZieDJxVWI4UnJneHZ5dFU1SmI5dThqWEZvY2FZTTNFdlcwZWJDYi96OCtZN3BnVmpYRjV3TUxWOUszZDBpTFRwOWkxUlNNSFB6bFVpVGhtSEt1aUJzQmp1U0I5TC94TUV0WHh1VXFWaEd2RkhrQmxyM0ZCeisvcWRyVEJBZ0RZMEVJRWw5dEFYdmhwYkYybGxkWEdRdk9DT0tPaE1KejFGdXZPRUtNVWJyWHJ0Sy9kV3VNR0RzZk1Ba29BQXNZbWV2d21uclVTMGMyaDRtN0pFT3pqR252YnhmbHZSRHZKY0gxV1oyODVXYU5UMkQwd3NLWlNlSWVQL0crOXNTTWh4RXk5bi9sSm5JN0ZUN2NBVURvYkFBV2EzbVp4djhPbUVYWC93Z2pyZ2hvRG1IRzM0UCsreUdMRTIrd0tLbUxuZi9ubFoxRysyNUdRQ1JRVFV3ZFlzcTcxVitMcm1ERm5tZGpIZDdRVkl0YnR3NVgvOGlnUmoxMjlFVlNtRnVsOEZqbnNzRHhmdE1RZkFEUFQzN1BVSmpLV28xNHl0ZFZGNWhPUnVmMjRPVXNMRHNDaGFuTXBiVGR1c0c0QjRoVTg3M0pYVWxoV0tqWStCN1Nsa1NUM2xLYklJczVQRjA1Smo1QjBUREdPT2xsRUVyVzN3dlBZZFBjZmlFZXIzZnpOaC9HWUJsOERQNWFhalllYWN2T2JVRGxuRGF0TiszL3BscE00dS9yZlJLYVpUbjZXd1ZmWXpJNkx3ZWJvQm14bk5xT0cwV2ZMODBhNzJ3eGNpenpuSWxmZUszNDhjd2s1WFgwaW4yTzdMc25tdWdFYTBJY2RFRmgvM0YzMDdCa1ZEak9iQlFPZExIOWNnY1lmSDZ1MHZSaUlHb05jUzdJNlFOSUtRZUFXRWVoZ2xKQVArSWl0VG5FZDRvVkhJMlVyV0JvV2o5L3RidUhOMFFHZklBa3lBTm9FUXJzenlwMVNMUVdpRnVKWHdud29uRzFFWDFzdmlrTHpVczU0Si93NTZFcnRlSHF4TVZLZmJxNFRlZERlZEcyR0RUN1lyMi9PbXhQN2JIc0NraGNiVUpBazZBS3dEY1g5TWorY3RlaER1bE1lZVdZVHdqRmkyN1NsV094Zk9IOHlJL2VzZGJITmNBdldWL0FzcndMZFAyeXl4VWVrbXRRN0l6ZnVQOjq4NZeLZwk8IFYcAPJhFTg9","2816:elementor_ba99f83","approved"),
("207","ii","2025-11-27 14:05:41","1","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","2816:elementor_ba99f83","approved"),
("208","jj","2025-11-27 14:15:52","1","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","2816:elementor_ba99f83","approved"),
("209","kk","2025-11-27 14:19:02","1","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","2816:elementor_ba99f83","approved");

INSERT IGNORE INTO `wp_f4a5sfea_submissions` VALUES 
("210","aa","2025-11-27 15:08:26","1","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","2816:elementor_ba99f83","approved"),
("211","AA Enfant 1","2025-11-27 15:28:01","1","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","2929:elementor_ba99f83","approved"),
("212","enfant","2025-11-27 17:25:36","1","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","2929:elementor_ba99f83","approved"),
("213","efnat","2025-11-27 17:26:05","1","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","2929:elementor_ba99f83","approved"),
("214","arfzr","2025-11-27 17:30:36","1","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","2929:elementor_ba99f83","approved"),
("215","conjoint","2025-11-28 09:38:58","1","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","2816:elementor_ba99f83","approved"),
("216","enfant","2025-11-28 09:39:30","1","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","2929:elementor_ba99f83","approved"),
("217","test","2025-11-28 09:43:21","1","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","2929:elementor_ba99f83","approved"),
("218","test2","2025-11-28 09:43:43","1","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","2929:elementor_ba99f83","approved"),
("219","CONJOINT","2025-11-28 09:55:19","1","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","2816:elementor_ba99f83","approved"),
("220","ENFANT 1","2025-11-28 09:55:53","1","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","2929:elementor_ba99f83","approved"),
("221","conjoint","2025-11-28 10:10:04","1","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","2816:elementor_ba99f83","approved"),
("222","enfant ","2025-11-28 10:10:46","1","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","2929:elementor_ba99f83","approved"),
("223","conjoint","2025-11-28 10:15:35","1","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","2816:elementor_ba99f83","approved");

INSERT IGNORE INTO `wp_f4a5sfea_submissions` VALUES 
("224","enfant","2025-11-28 10:16:01","1","S09oZ0NJTTBkRGpyYWVnSTMyVWRlK1JaSDVSWnlxcHVsd284L01Qb3FDMEo0Y3pnRHRLNFh2Y2pUc2dxZEE5K2J5WklwQmgvbEZSUkIzWFZTa1lMYk5jTExzcU13NWpEa05TeWYvMzlQVVcrUUNEU0JUMXR0L0NaVFlFNWF0Q2txMHpuOU5oTFNmL0NCMm9rUlA5elZZb0JHc0RteVFVOGFFY2luMmE5NWtRZ2NTcDN3ekFFTVl2Q2VzMWdZZllxcGZrYUtEQkg3bXRwdk1Id2VuZFJBbllKTk9oMlFtWnNPclFzTXdzb0s0elRIbTc2bjcxVS9GYXBIYkxCQ1JaUW9vNkhwZVhpL3dHVHVTQml2Z0Faa2F3ZHpPS1RvbjlsVnhTUjl5L0dYT09icWVGRnhyY3hKdmttVk1rdGxRQW5FU3l2dHNzNm8xVFZaS0Z4ak9sWnRGeHR1WnB2aXFEYjljOUpydkVOWG1TUDBEZlpLemxiRXJaWUhYM0I3T2gvMlNaa1ZXcFFsRkU4dFd4NEJ0bmNlOE1ydlpuZGYrZWYwNkttUU1BMFdqZlQwYlE3SlJwMHkzaTVabnJYbndEMGN3cGFqOGNYZDV0SVFWOXJFYmFFeUlNN3E4VGx0cnR5aGRxcFc2eGhyc2xCN29NOXZ6cVArSUgxNWRoME8xSnZyK3U5dmdhcWFrSWZ5T3JoYVRBY2wzUC9yUXpYVmZmbjFGYTZzRXQ0YzBWcmRTQnJobTU0SytRUmhvUzRmOHpubmhJWTQ3U0h3UHlHZDNSV3c5SHBBWlZYVG5SQjBPdlYwSEhTd2tSR0ljSE84VHA0dnZkZGxCUkFJWGVseGRoNXJRTFFOZG5ZK1NaR2hpc1o3MnBHYUNSem5mU1UxcmowSU54MW5scDk3RmlTQXVPSlNOSC9jQlBNNmlmSkRzNXFkU3lYM3JFNm5aMEptNWRzMExNRmxoT05tanlUa01NWHhIRHQ0d3Y1WHRWaFhUdjF0UUhRd3YwZS9ndUg3OG5CQXJPenVMaUVkRDYxTU85RDFZOWM0dG1ReTFSaWdNdWpjaWplSkJKN2xYd0VLOHlFUUk2NjdZd0g0cXpoYUFGVGhOWkdvQjJzTGFIekZzdVRBaVkxUXl6a1ErZzJWSXp5NVdiVGFtaVo5TkhVSXFqbWFBaCtCSHpBYWkxVUI2VC9TZ0JWQWlZYjNTSjR0aXJMdDNuZHRra3ArOVRST0JpTGhMSTJmdk9EeWFBdkROVHNFam5JVTloa3gvdHlYcHBCY1gyWTdMQjhtK0d1WVZPZjM0VXgrWG9wY3pzRHZ6K1drZDZxSithMTRSVjQ4RHozV3YrQXpQa2FXeXVGYllseWtBYVZwYlE0T1p4Nk1WaTU3ZFZkbmV3K1lEZWdXZDlHNTYvb0J6ZjdERlpkZTBEMEk2ZTF5Yk12b3BCVGEwbVVBWEdyNVlMdjl2eXRneFR4T1NFNnd1c3FoRGVGSHk4MDRweUVNWERqc1NkNHVlWVdKMFN0NmJnUC9MbWxtQXFEMlNzaWx6U21qTXczNnF1aTIxOEJMZkRRTmV1UU92M0FURDVXMUN3MU1UTWQ1WVRoMEVSQmhEZWdHMjlxNjUxY3d4N1U3VGlIZTdSeSttanlObTluV3lDeVl2a3hJS0laaWFBOUJMWTIxeWJ6TUY3R0tZZFRUTU9OUDVMYUJ2MlFDbUduSVgxUGhGOHJwMFRuc0ZWb0o5bmhYL0U2ZmNtS0tLTEVZZ2R0UXcxZld5YnpEMmxkdHcxOEMvUnZ6OS93NjlzS24wSEdOTHRvblJteVVOdktzZFRTS0NrZWxnMC9zUjlIMlFCSXE0U0ptbFNZQWQzRnl2TXRoZ0JveVpwVytibEdXWVVXVEoycTRJYkt4T0hPODl2WTkyZmpBaTdYU0dmNnhJVkJZWkJ2ZjBpQzhxaUs5THRoUVhwNTJHK244TE54a3k3aU5VNGJYZEtYYVNTVEx3bGtEL1c2Mk5qY3dubWNmbkQ1azRlSW5TaEFoRURlaGhkWDVORXNJcnBLUXpjUjBsaEdMbzlzRHhrMTc2NkR2aVpmeVIwSHJmclZrL0loVlhjWXdPaFcxclNYQ282OHloUmdMQTFXd2tFYndMRHVFMUtzSkVxMW5kQ3FZWnU0UjBGUlhiQ3JvV09uT0ludzdDeTNKbGxDQ05hOFhmdkcvMW9JR3VRekhFZDZOZXMwZHFpOVlicWZxZ24xUVBUMmVMYWgwVzY0dFJmcjh2UGJUN1BsSzJZdnJQMk5uQmlhNmhiNFo3aVQ5MExQVEpRNGx2TWxaWGZoQVZNdkFabFN5SjZBZjB3RzBjSDhaMjZ3TDljRzkvRXpTWWdOakU4ejVIeWxKQnhUMnhBT0hrUUVDR2FzSHhOejgvQ3J0bVlSMDF1d3FFMUM2UXRiWk5XMzJhT2xLb3VJeVlvSmtsYmdpTCtVcktjbHQyRExOT2E1ZTdBR0ZyejlHMytqcXNqaTRLdDB3QU9JcHZscHRrSThBbkYvdXREOEUxZms0OFlWUlJVY0Y2ZkJxWUJYNERwd3VjVjBoR1JuemZLMy9FS0FFQlA4Si9KNHB5N2o2WTV1dG42ajhjQ1FOYmNCNGkvZnFmYzVKRWt5K290VTZPeGpVNkVTRFIrQTNSVlY1TGpYVXRoWFhEK1VXQlF6Slc1eVh6T0FOTGVuSzIxajN4Z2hWYzNSSGdyTVl4N0hJVUE4NWFVUWRJZ2h4U001YTZzU2Y0U2xrd0hKZk9EMFdDNTY1Ni96ckJUMU14WkhYQ0JKTDZzM0NRckFNamJhdlZ2YTZHalU1MnFpQzJGKy9HZTZjSmg0MFN5TUhDNWFKWGNIcHZYN3ZMUkJmVUdZQUhaQ2JzSGtlNFJHNjRGbXNtdmRKT3JwVDVkM2Vscm1DK3phRE1HaE1SVGRhOEtVODhyUkZEa2VFQzc2SmhWTDdwT216aEJZMjRSbWxCTDRjUUk2NnpqMkhaSjlqRFhtVUl4ZW1qeFhSd0w4TmdSWGdUeDk0ZTlKOVd1VFpBUXB0NHRlOEFON24xaGJlMkVyZkEvdHVkYXkwZ0FENVdsNjB0bGNmVmdBdWwwY1R6OWNCTHYyU3hNeFJ1bWRFUENSTE44b3NicWNhSE81SEdia0tYdlpOak9XdndaREt3Z3lvaTFwUGlyWnIzUGlMdmlJZVhFYVhSZDMrSzVNOU5aMVZ2Y0tkSXlRYzFMTHRQaTA1aEhHTTRYY3MwZHFiUDllRFNKdVJsa0o4aTRidExucFlYa1EvTjdha2lJVWU0OFdaMWczbVVlOVlUQWVYYm0wdnh5eEpiWFVPczJPcUFUWVZ0bTVxY1c0UW5DYXp5Y2E2ZzhydSswOXRyMGtJVnJaZk1tR0VIWUlFVVM1b0Q0d0EvQVBsbGdjd2lVSG1FYjFWczNBdnhvMzAweFBRK1Q3Y3kxV1hCaWRKSTVsZW94anhIdkd4Z3NwbmRWYWorZ3FwaG1BUHlVaFF0VXM3b2w4VGxIaEh5WnZUSFFlSWIwTHpFSVlrVFNEcnB1WVE5R0ZDWTRja29QWUplaFpSUjNuT1k1V3FOTlZEbER1ZmRMYnVIblJWYUMrSW5JYldLV1hqRnRYOS9pTmw2dE5Kd0o4Z0dyQTIvTC9wNXAyZFU5OXY0bjV6YnNwWDVtOFNodDdWNmYwak1pMFRjY0ZsSWdPQWp4TzlMVm1hRndFWTBDNnVTV3BhL1ZYSDlyQmlldlh6d0R4aVRsbThETnUyUi9Ta05XaHgwMWpYNlliWm9OZ1J5UEc3K2RYNUZkTFJpdzc5UnN2S0s2b1d3bGUxUDNHRkcyOGpEdlkvcXV0UmI3b2pFZGI1dXoxdGkwMDZ4Z3N6ZUJ0VjRwOUIyWlUrMWZPdU54S1pIclB1dGVUMjZUbmpRblNyWERSa1BlREZXNlZIQjI5bjE5ZjNkTnN6VVdudHozVzJhZDFDZFF4RHNXZVFkaUFNZUVvZEtVQWprcXNxdjBCV3ZzUWMrZ0QrSHdmUnNobGpSTmowOGlyQW4rWDNybVRTb0thK3EyRU83ZXpva0cwUHJ3R1djSHlscmN6em9rTjI0U1VUalViYW03RjhsU3UrcFRWc0Jsb2ZpanVqZ2hkRVljSm83S3o4VnFwSEkxOTVaZnJBZU50N1hmbHVMSkV5Tkg0T0FKMEY3T1dYMHAxRTZXQ1kxSmdCSWJ1Y1k3OUdEOWk3dHJvL1pzb0t0RXVFOWFqd2FXTU1jbVVMb2M2elRpUTBYOERIV0lhMnFieWMwbURMbmM0WGNqOWNScDd3SlM5M2RTZ2g2c1Q3WWtZckZWNEhieXRJSGptalRSd1BodWdvZWZiWlU1ZklPYVZzaStyR3V4NDQrNDlBNVc0eWx6SU1BanozQk5XMlFWSXB3Q2FockZVeHREUzc1NHJ6R3BKYlRFLzlZU2xLbktNUkU0SlhDZGdwaGhWZW8vb1g3OHo0UGRFdlIvK0piZnRwOHNhRVZwMU1NbldaRHJGdUQzRkhYc29CUnR1MkZFN3BjdGxyQ2pBUU1iUEpYRkp5VXgrRTdDdTFIbThWN0svbERxemlFcGIwbGJ0bDdQbzYxekE1cW83bnFiNHVXNGdISXNQOUdTWUE0Q1JNSDBpZGxoZUtZMVo0RDFIaUZpKytwRFFlai9peTZMOHZySVVTODF0Yk85YzRlbmFRdTNVaytsZDZneGhycmE3V0hKWlRJL2FSelJCQ1ExZElIZ1lLM0lXaDBDM1BucmdyUnZiZVVJcUxwWXlQTWRvVG5CMk96Q1BCc2RaUjA5aTRENkVCR1VnWDFDTEhOM3Q5aDVhalhSQ3AydG05WTZxMG4wclE5b3lFY0NBZjZVbTFibVY5WEhOWHl5K3gvWjJNbWNLdnNjQ2xpZUJqZXFjbTNwQVN5LzM5S3VWa0ppM2ExMWJJc25TNjAvSXFlK1JCcHQxWW45WlQ5Z0RNOVJrTWZDbExNZmVXRUptRmdIZ1NpU3R4MnpoZ0tvWm03V1ZJUnpUa0pSTGd4d29rSUxRSGFnR0F3UDBacDI3YlZzNytlWkZXU0QxSXlHdzkxNE1tVk8xZzNKSUUxZktJNFZ1OGcyK1dtUUJVY3ZqT3BHdFBWakRFNUFpd2Q4a0tHcU1Dd3AwdHlwTTRZYTBjZ2lJM3lTTml4RlExd2NmMGc1UFU0ZVFOS3R5K1NxVC8vMEd1Z00raDk5dnhYb2dvcnFwSDZEbS8yNUtnd091NjBRMS9pM2g2RFNaQkprMU82Z21aWExsRVlUTHBiazBCVlZRSk9CSFhXOXhkU1pVTml5NklQTmxoSHFhdmdCUGhFajJ1SHFucS9nSmpENEJaOFcxbWdEc2F0NkpqVSsrQzMyQ3VtNnV0bnFNbGJzRzJwb1Z4SjduRy9IbC94dVkycVorMnFWY1BTMTBMc1VRMmdqNVAydXVNdCtLN0hCTUl0VVdZMHhBMWRhSzZ4cE5UR0NCRzhCNStKaEZ2dHVSbUR6STkyYmU3S1pqeHdWRWtYeEEya2pjbklJNDJYeWgwM0doU2ZaaWZ6Yk12aVRUbUZSMSt1WFIyVUZ3MVE0WC9ZTEl6R1RodjNXOUFBWlRlSjRseDZJaWVHM2tFN1NJdEFUeG5POGFiQVNNWXN1c0JxZnpTTS9jYmtYU1ErQmpHUTdXMVNyYXpoWXVvMUZRbjl0dXBxaWRodEx3U1RRVzVmalp3L2pTOFhjbWNTeFAxcXovY2hBK3FyZlVCdVZSSU5rS3V0dHBEQVNSc1k0MXBMMUlUUlp6SUkyWlV0TEUyQTJjdFJJZjZTdUNQeklHS3hiR1ZISTBZSEN5aWY2aWpyNUc3bERrdy96U2JlRUJZWHNiSGM3ZEd5aGw3Wjk3L0o5UE95TEdFQ2pKZVhSL2ZtQ1dNR1FoRUF0ZXpTTDdjTFl1MDZtdDdBb0RHNGJOVDczanBxV205NXFrNmFhalNuemxpMktLNkJDL2NRNXZPZU5NM3hBNGJTUkIxYTFUT3VYTExJeTRmYnZzRmZGQnlLT1QwUWFpcS91NUVxLzEwSmNRcjBnYnNMQ2ZXSEN4OUNDUFFQSzR2SkxUd1Ezb08vRVZDYjg2RDFDVHlhTStjNVZhWGV2N2pPL0JiWExWNXNHSktEL2RvSUUzbVRENXZ6TXZ2VCtxVjJLY3pyaGhxd21kdW1CSzRvUEJ1Z1pBdFVRVkFPdDdFNEI3c09SaE9rMFcrWm1DK2ZPdnU3dzJ6S01rVmVVZ0dmcUd5dmhJTExwUjBHZEt5Rmo4SmxqTTFuUEovZXkwWmNxNE9xVStPa0Y2WStjNWVCWUQ1NjRJUGE5K2xxaksvYlo3MkNLaTNCNThHS2NvRzN1Q3ZpVCtQbWVmZDVmN0svb3VtYVFOY2RNNjljTnlTNVFCN2MxU0h1cTBzM1JlUXdOa1VMTnhIK3RIRUptWWNJTFNFTmhpSHA1QmJkbk9WUlJDSmpxejMyNE9mQzIvdzNuaGJadTh4TTRKUUMxWndtMEdjUXZQSWRJcUJCQjYrMmFoaVIrd2swK2padzFQbzVvZmlyNkZrUXJ1enhYU00vZElXbUo5SGtjdEZSVGFaRDFkV0RuQ3UzMHpCL1pSUWlzSkNmRnp5OXFSZTJ5SFdYLzZwZWlUaTRQbTR4WGd1RHBXK1hFckxNSmxBTXNEU3lzSlV6WnAxeEprTXkySVllWVBGTE1FTElRZUo5c2lBdFpBdXJ5OGQvYStYRUVmQWU2ZENubVBCQ2cxcmhYWHdLYy9tMTlON29WVWc4UnBkeXFqK0hjeFNBVjZ6THJWdHAvLzJHRWFOcjZvNGZSUWRjd3hNK1BVQzRLTHpIMXV4ZC91b1VyTHlIVUROQXVCWDhPOXRrT1N1c0xsTkpyeTRNMmV4ZitCL2VqakZLSWs0Z3V4U3puU1EwU25VYkVCNUZLS0FyR2kzWFFrQzVpVXgxOVFFMTd6akVGdnM3SVUyWUNwbEFjaGp2R2M3RjBpcXNpZTZpRExWM1pVRFdNNm9HYmhsYURwYVpwL216NnhnK09sMUxFdFMvS0UwWkttVHVXRWhzZVVWVjVDdFFteFpRcVp6YjBQMjdGRElzOEFwcW94QTY5WkZPVUFyQk83K3Y0dk14bDJVaENXWERHNmpvWkhqMTJRNHduVTNUMFAwYStlQWE0WGd6UVgxSFJUVnpUdmZEQ0J5OGdQZWtpSVA2cTBmYis4Y0Nlc0VxbTYrZ0xubU9qR2k1aW5hU2dCU3luYzNiZEJpVGRXR01Hb3JsZjZmRE45d3NGTEtEaE9kWE9JY3NxM1ZkYWViQjFaZzlZaC9KR2xLcGx3K0lXZlVzd2huZ0MxQ1d6MjZoYS9Ydm9YYkhZMTRmTE1WeXNLNTBHTVNOOVdRcWJMZnp4OExvd0djMnBwb1lhSlNyWnhIcExOdEdQdUtQc1NFM1FvQjhCdzRCeHpIVkRGNHRtTjUzN29oUnhQOEtSdU82R2kydTdVQXdBM2Z1aHdRU3BOb0NrN3paNWVFczF4Wi92Z0g3ejQzcUhvS0ExZmdUbi9WWXFsYk5GdCswVUhBZGphZ3dseWVTOGZLTVQwekU0ekdnL1Y0WUFMSWFPVzBLam9Vd2ZsU3JmV3VaUE5FbzlhRkhRd25kRzB6Ri9SYjZ4ZDRhaUdKK25LV1BWTkgwbzkrUGIwVHdWVittcGZaWGVmNndvNHY0bWxLS3VxdzRLZi9MeDlabStWdmNZMFBSeVhPMnNJL2pzWlluaVJNdzNhVW1JN0JNZVVBa2VYYWpWN29xdk1WRVJvQnRjMy9Lb2RDSFFBUXpCQnh0RnhIYXhCZEpvNitEaCsrYTV3U2FtSDB4T1pjK0c1R3dpb3R0R2pHT09jVk1FTW4zTE5ZZ2JpMEU1MElLanY2ZWYrRWVzTnhzYjZFK3N6THhDb0xRV3YvRGx2UEhOSmd1T0pJelZPQ0c5b01rTWNhdGZ2bWRqOE5LSDZGS2FQVkN2VlZMbHFJYnV6dUFLVmttckZzMGp3L21yMDRkMXR0SmlEOUl6aEx1MUZ6S1dpSkdCUmI0b1VxQlYrQjBhOGE3Q0h5MElodm01UUJSZjU1NVRtMVFmNmVmWmh1eC90U1JLR0t0TWVVNDMrWFpYZ1lFRkp1aXh3UWpOMHA2RzczUGtYY0hCcjR2ZVQ0WkdWTUREWWdzd2wxSnRWUTk3ZUN4OC9JQjJDbEpDRDVtWFJ3Y01QWnJiOG9uN1RaRGIrSWJIVmNoM0I2YzFQTzlHZDNlNk1HQllqYjBXZ3ZrT2REa2h5ck1vOGg2ZzJ2YThySHoxMStmK0F0UE0rMytmSlBFd3cxRXNNZE1Yc1g2ak5GaFh1bUJsblcyb3lGcDVyclBYNkliRnVOT0dVSUU1U0dUUmh1aE84SE5WYTJXM2M3YWNuMk1lUlhRNGovMVpVYnJJeDVuZG9Xd2ZYbHBObGVRZ2lmWGgrRXR0a0hZelFkZ0tWZmlQbHZzeVBSQ3NSNGw4bTRidzRFdHlxdzRneXpXS01LSkYyYXBZNm1yZ3pPWktNUmtweGpWUk4wMTFCSEg1SDQwNWJHZXJ1cnc0cXVwc3BuK1ROUVVmZ0RLMlp6dXhjNFBiQUhocEZGT2xIZFg1d1k4MUdVVW91WFR2aHdUTVF6dXNZTFFwZXR4UlNGQ3ZmQ3RKWHJVZ1Rjanl1MVRZVXJhYmsyR0hCVzIwTEJpdUpURlFEdG43b29SWHZ5RFpvNmMvMUROOVd6ajQ0Mmp4cHVhSjNGZ0NaOXNuWU01THNOemJLY3l4dld4ZXRqMEZ0a0pMOStGVXFNUHJyRy9zQ2pHZEV1L1ZBYmV6Y0JFa09xSkl1VTNQa0ZOVnVZRTRWb3B1ZzFjdGVydTVzdjc1dWIwaDBzMFZjYmhwV3JiR21NWHBzKzQvMXNlOTk1VlZmdVovcXVJNWtsYW1wZUhWUzR4OWVLWmhiT04xbUZBOGtnSHlXS0w2WmZnTUVaMmxpa2ZNV3VrVDk0NkZ5T1hxUG9hSG5jaUNocXh4QXkydW5iVVNuQzg5UjRkTHBoQnZ6ejA5NXJUUGVZSk5RdW1jcW9JSkhoUnBBUUUwa2xOaXpINzFKQTl4M2hLSFpBK1pFSW9PR2F0Zkdhc3ZFOGFJUHJMVVhTRkswYjBlRU5XV2krYmpaazFZTGQvenRJS21FLzNmVlh0alBXSWlSWCtXcXV3STdRQzJTN1JqTnk1QkxIbmcvUE50WVM3eEw5bk5yMmNvQXFFYVo4ZW55MFhhZW5YS3RobjNtQ3hOYTJmTE1BQ0U1WTdtemNmbFRFTU5QemxHN0U4T29aeG91OTMxMkRaN21uSW8yOVNZL242L1ozTUM1S29vWGYwNzJIdkd6Q3lkYm5ndmU4VlZqd2JJVU9reCtpV3NFWGxNbnd1VjFqWEM1NS95Tk50OEI2Z3NVSmJrVXcvWG5tQTkxMVhMOWloVHROdnhvWFNHMlh3Q3Brc0FQd0NzMS95RXcwSFJEajBVbHgzMnRvNGpiMjdQVlNJOURFYU9JK2NOOWl1d0x5Q1BTU1IxUjlmYWNCZnNTTWhJRFEvR0w5RXllLzdHWWw5UmZDK1FzTUNhaVZHRytsYWpnay8xc2RTL3EwbWp3ZGwrVlRLaWl2STV4RGZYVGdObW5GM0oybnc4PTo61wSRhSO2YIoLc+cDgw9lZg==","2929:elementor_ba99f83","approved"),
("225","CONJOINT TEST","2025-11-28 10:36:33","1","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","2816:elementor_ba99f83","approved"),
("226","enfant test","2025-11-28 10:37:13","1","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","2929:elementor_ba99f83","approved"),
("227","CONJOINT","2025-11-28 10:39:02","1","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","2816:elementor_ba99f83","approved"),
("228","ENFAIN","2025-11-28 10:39:31","1","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