<?php

add_action('wp_ajax_save_conseillers_manual', function(){
  $post_id = intval($_POST['post_id'] ?? 0);
  $nonce   = $_POST['nonce'] ?? '';

  if (!$post_id || !wp_verify_nonce($nonce, 'save_conseillers_manual_' . $post_id)) {
    wp_send_json_error(['message'=>'nonce_invalid']);
  }

  if (!current_user_can('edit_post', $post_id)) {
    wp_send_json_error(['message'=>'no_permission']);
  }

$raw = $_POST['conseillers'] ?? [];
if (!is_array($raw)) $raw = [];

$allowed_special = ['non_assigné', 'sans_effet'];

$clean = [];
foreach ($raw as $v) {
  $v = is_string($v) ? trim($v) : $v;

  if ($v === '' || $v === null) continue;

  // garde les statuts spéciaux
  if (is_string($v) && in_array($v, $allowed_special, true)) {
    $clean[] = $v;
    continue;
  }

  // garde les IDs users > 0
  $id = intval($v);
  if ($id > 0) $clean[] = $id;
}

// unique (en conservant l'ordre) + limite 3
$clean = array_values(array_unique($clean, SORT_REGULAR));
$clean = array_slice($clean, 0, 3);

$ok = update_post_meta($post_id, 'conseillers_manual', $clean);

if ($ok === false) {
  wp_send_json_error(['message'=>'update_failed']);
}

wp_send_json_success(['message'=>'saved','count'=>count($clean)]);

});