<?php

add_shortcode('commission_mensuelle', function($atts) {

    // ----- PARAMÈTRES -----
    $atts = shortcode_atts([
        'global' => '0'  // global="1" = total toutes ventes / sinon = user connecté
    ], $atts);

    $mode_global = ($atts['global'] === '1');

    // ----- ACF requis -----
    if (!function_exists('get_field')) {
        return '<p>ACF requis pour afficher la commission.</p>';
    }

    // ----- User check si pas global -----
    $user_id = get_current_user_id();
    if (!$mode_global && !$user_id) {
        return '<p>Utilisateur non connecté.</p>';
    }

    // ----- Récup ventes -----
    $ventes = get_posts([
        'post_type'      => 'post',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
        'meta_query'     => [
            ['key' => 'mandataire', 'compare' => 'EXISTS']
        ]
    ]);

    if (empty($ventes)) {
        return '<p style="color:white; text-align:center; padding:40px 0;
                          font-size:2rem; font-weight:bold;">0 €</p>';
    }

    // ----- Grille de taux -----
    $taux_data = get_field('taux_de_commission', 77);
    if (!is_array($taux_data)) $taux_data = [];

    // ----- Date actuelle -----
    $mois_actuel   = date('m');
    $annee_actuel  = date('Y');

    $total_commission = 0;

    // ------------------------------------------------
    //                BOUCLE DES VENTES
    // ------------------------------------------------
    foreach ($ventes as $vente) {
        $id = $vente->ID;

        // ----- Date de vente -----
        $date_str = get_field('date_du_jour', $id);
        if (!$date_str) continue;

        $date = DateTime::createFromFormat('d/m/Y', $date_str);
        if (!$date) continue;

        if ($date->format('m') !== $mois_actuel || $date->format('Y') !== $annee_actuel) {
            continue;
        }

        // ----- Contrat -----
        $contrat = get_field('veuillez_selectionner_le_contrat_souscrit', $id);

        // ----- Frais & Volume -----
        $frais  = floatval(str_replace([' ', ','], ['', '.'], get_field('frais', $id)));
        $volume = floatval(str_replace([' ', ','], ['', '.'], get_field('volume_total_signe', $id)));

        // ----- Conseillers -----
        $mandataire = get_field('mandataire', $id);
        $acc1 = get_field('accompagnant', $id);
        $acc2 = get_field('second_accompagnant', $id);

        $conseillers = array_filter([$mandataire, $acc1, $acc2], fn($c) => $c && $c !== '-');
        if (empty($conseillers)) continue;

        // ----- Si mode user → vérifier qu'il est dedans -----
        if (!$mode_global) {
            if (!in_array($user_id, $conseillers)) continue;
        }

        // ----- Trouver le bon taux -----
        $pct = null;
        foreach ($taux_data as $row) {
            if (!isset($row['nom_du_contrat'])) continue;
            if ($row['nom_du_contrat'] !== $contrat) continue;

            $taux = floatval($row['taux_commission']);
            $fmin = floatval($row['frais_min']);
            $fmax = floatval($row['frais_max']);

            if ($fmax > $fmin) {
                if ($frais >= $fmax) {
                    $pct = $taux;
                } elseif ($frais <= $fmin) {
                    $pct = 0;
                } else {
                    $pct = (($frais - $fmin) / ($fmax - $fmin)) * $taux;
                }
            } else {
                $pct = $taux;
            }

            break;
        }

        if ($pct === null) continue;

        // ----- Commission -----
        $commission_totale = round($volume * ($pct / 100), 2);

        // Global = totalité | User = split
        if ($mode_global) {
            $total_commission += $commission_totale;
        } else {
            $commission_user = $commission_totale / count($conseillers);
            $total_commission += $commission_user;
        }
    }

    // ----- AFFICHAGE -----
    return '<div style="text-align:center; font-size:2rem; font-weight:bold; color:white; padding-top:5px;">'
         . number_format($total_commission, 2, ',', ' ') . ' €</div>';
});








add_shortcode('commission_title', function() {
    setlocale(LC_TIME, 'fr_FR.UTF-8');
    $mois = ucfirst(strftime('%B'));
    $annee = date('Y');
    
    return '
    <div style="color: white; text-align: left; padding-top: 0; font-weight: bold; line-height: 1.1;">
       
        <span style="font-size: 12px; font-weight: normal; display: block;">' . '<br>' . $mois . ' ' . $annee . '</span>
    </div>';
});

