<?php
if (!defined('ABSPATH')) exit;

add_filter('acf/load_field/name=compagnie_vente', function($field) {

    // Réinitialise la liste
    $field['choices'] = [];
    $field['choices'][''] = '—'; // Valeur par défaut

    // ID dynamique de la page "administration"
    $source_id = function_exists('arc_get_administration_page_id')
        ? arc_get_administration_page_id()
        : 0;

    // Si pas de source ou ACF absent → on laisse juste le "—"
    if (!$source_id || !function_exists('get_field')) {
        return $field;
    }

    // Répétiteur contenant les compagnies
    $repeater = get_field('taux_de_commission', $source_id);

    if (!empty($repeater) && is_array($repeater)) {

        $compagnies = [];

        foreach ($repeater as $row) {
            if (!is_array($row)) continue;

            $compagnie = $row['compagnie'] ?? '';
            $compagnie = is_string($compagnie) ? trim($compagnie) : '';

            if ($compagnie !== '') {
                $compagnies[] = $compagnie;
            }
        }

        // Supprimer doublons + valeurs vides
        $compagnies = array_values(array_unique($compagnies));

        // Ajouter chaque compagnie comme choix
        foreach ($compagnies as $compagnie) {
            $field['choices'][$compagnie] = $compagnie;
        }
    }

    return $field;
});
