<?php

add_shortcode('contrat_detail', function() {
    ob_start();
    
    global $post;
    if (!isset($post) || !in_array($post->post_type, ['contrats','contrats-avec-ucs'])) {
        return '<p style="padding:10px;color:#777">Impossible de récupérer le contrat.</p>';
    }

    $post_id = $post->ID;
    if (!function_exists('get_field')) return '<p style="padding:10px;color:#777">ACF non disponible.</p>';

    $actions = get_field('actions', $post_id);
    $date_situation = get_field('date_situation', $post_id); // <-- remis
    $parse_number = function($raw) {
        if ($raw === null || $raw === '') return 0.0;
        $s = str_replace([' ', '%'], ['',''], trim($raw));
        $s = str_replace(',', '.', $s);
        $s = preg_replace('/[^\d\.\-]/', '', $s);
        return ($s === '' ? 0.0 : floatval($s));
    };

    if(empty($actions)): ?>
        <p class="placeholder">Aucune ligne d’action dans ce contrat.</p>
    <?php else: ?>
        <div class="contrats-table-container">
            <table class="contrats-table">
                <thead>
                    <tr>
                        <th>ISIN</th>
                        <th>Libellé</th>
                        <th>Nb parts</th>
                        <th>Prix achat</th>
                        <th>COURS</th>
                        <th>Évaluation</th>
                        <th>+/- value €</th>
                        <th>+/- value %</th>
                        <th>%</th>
                    </tr>
                </thead>
                <tbody>
                <?php 
                $total_eval = 0;
                $total_plus_value = 0;
                foreach($actions as $act):
                    $isin = $act['code_isin'] ?? '';
                    $libelle = $act['libelle_ref_id_support_info_generale'] ?? '';
                    $nb_parts = $parse_number($act['nombre_de_parts'] ?? 0);
                    $prix_achat = $parse_number($act['indicateur_de_pmv'] ?? 0);
                    $cours = $parse_number($act['valeur_cotation_euro'] ?? 0);
                    $evaluation = $parse_number($act['montant_en_euro'] ?? 0);
                    $plus_value_euro = $parse_number($act['plus_value_en_euros'] ?? 0);
                    $plus_value_pct = $parse_number($act['plus_value_en_pourcentage'] ?? 0);
                    $pourcentage = $parse_number($act['pourcentage_des_actions'] ?? 0);

                    $total_eval += $evaluation;
                    $total_plus_value += $plus_value_euro;
                ?>
                    <tr>
                        <td><?= esc_html($isin) ?></td>
                        <td><?= esc_html($libelle) ?></td>
                        <td><?= $nb_parts ?></td>
                        <td><?= number_format($prix_achat, 2, ',', ' ') ?> €</td>
                        <td><?= number_format($cours, 2, ',', ' ') ?> €</td>
                        <td><?= number_format($evaluation, 2, ',', ' ') ?> €</td>
                        <td><?= number_format($plus_value_euro, 2, ',', ' ') ?> €</td>
                        <td><?= number_format($plus_value_pct, 2, ',', ' ') ?> %</td>
                        <td><?= number_format($pourcentage, 2, ',', ' ') ?> %</td>
                    </tr>
                <?php endforeach; ?>
                <tr style="font-weight:700; background:#f3f6fa;">
                    <td colspan="4" style="text-align:right;">Total :</td>
                    <td></td>
                    <td><?= number_format($total_eval, 2, ',', ' ') ?> €</td>
                    <td><?= number_format($total_plus_value, 2, ',', ' ') ?> €</td>
                    <td>
                        <?php 
                        $total_plus_pct = ($total_eval - $total_plus_value != 0) ? ($total_plus_value / ($total_eval - $total_plus_value)) * 100 : 0;
                        echo number_format($total_plus_pct, 2, ',', ' ') . ' %';
                        ?>
                    </td>
                    <td></td>
                </tr>
                </tbody>
            </table>
        </div>

        <?php if ($date_situation): ?>
            <div style="margin-top:15px; text-align:right; font-size:14px; font-weight:600;">
                Situation du contrat au <?= esc_html($date_situation) ?>
            </div>
        <?php endif; ?>

    <?php endif; ?>

    <style>
    .contrats-table-container {overflow-x:auto; margin-top:12px;}
    .contrats-table { width:100%; border-collapse:collapse; font-family:inherit; font-size:14px; line-height:1.6; text-align:center; }
    .contrats-table th, .contrats-table td { padding:12px 14px; border-bottom:1px solid #eaeef2; }
    .contrats-table th { background:#2271b1; color:#fff; text-transform:uppercase; font-weight:700; }
    .contrats-table tbody tr:nth-child(even){background:#fbfdff;}
    .contrats-table tbody tr:hover{background:#f1f8ff;}
    </style>

    <?php
    return ob_get_clean();
});




add_action('rest_api_init', function() {

    register_rest_field(
        ['contrats','contrats-avec-ucs'],
        'conseillers',
        [
            'get_callback' => function($post_arr){

                $post_id = $post_arr['id'];
                $ref = get_post_meta($post_id, 'ref_id_personne', true);

                if (!$ref) return [];

                // Cherche les clients
                $clients = get_posts([
                    'post_type'      => 'clients',
                    'posts_per_page' => -1,
                    'fields'         => 'ids'
                ]);

                // Résultat
                $saved_conseillers = [];

                foreach ($clients as $cid) {

                    // lecture du répéteur nums_client
                    $rows = get_field('nums_client', $cid);

                    if ($rows && is_array($rows)) {
                        foreach ($rows as $r) {

                            // bonne valeur ?
                            if (!empty($r['numeros_client']) && $r['numeros_client'] === $ref) {

                                // on renvoie conseillers_manual directement
                                $saved_conseillers = get_post_meta($cid, 'conseillers_manual', true);

                                if (!is_array($saved_conseillers)) {
                                    $saved_conseillers = [];
                                }

                                return $saved_conseillers;
                            }
                        }
                    }
                }

                // si aucun client correspondant
                return [];
            },
            'schema' => null
        ]
    );
});









add_shortcode('contrat_graph', function() {
    ob_start();

    $post_id = get_the_ID();
    if (!$post_id) return '<p style="padding:10px;color:#777">Impossible de récupérer le contrat.</p>';

    $actions = get_field('actions', $post_id);
    if (empty($actions)) return '<p style="padding:10px;color:#777">Aucune action pour ce contrat.</p>';

    $isins = [];
    foreach ($actions as $a) {
        $isin = $a['code_isin'] ?? '';
        if ($isin) $isins[] = $isin;
    }
    if (empty($isins)) return '<p style="padding:10px;color:#777">Aucune action avec ISIN trouvée pour ce contrat.</p>';

    ?>
    <div id="graph-toolbar" style="display:flex;align-items:center;gap:12px;margin-bottom:8px;">
        <label id="isin-label" style="font-weight:600;font-size:14px;color:#111;margin-right:6px;">Choisir un ISIN</label>
        <select id="isin-select" style="font-size:13px;padding:6px 10px;border-radius:6px;border:1px solid #e2e8f0;">
            <?php foreach ($isins as $isin): ?>
                <option value="<?php echo esc_attr($isin); ?>"><?php echo esc_html($isin); ?></option>
            <?php endforeach; ?>
        </select>
    </div>

    <div id="chart-wrapper" style="position:relative; width:100%; max-width:100%;">
        <canvas id="chart-isin" style="width:100%; height:460px; display:block; margin:16px;"></canvas>
    </div>

    <?php
    $cotations_posts = get_posts([
        'post_type' => 'cotations',
        'posts_per_page' => -1,
        'orderby' => 'title',
        'order' => 'ASC'
    ]);

    $isin_data = [];
    $today = new DateTime();
    $first_day = (clone $today)->modify('-12 months')->modify('first day of this month');

    foreach ($cotations_posts as $post) {
        $date_title = $post->post_title;
        $date_obj = DateTime::createFromFormat('d/m/Y', $date_title);
        if (!$date_obj) continue;
        if ($date_obj < $first_day) continue;

        $rows = get_field('cotations', $post);
        if (!$rows) continue;

        foreach ($rows as $row) {
            $code = $row['isin'] ?? '';
            $val = $row['valeur_cotation_euro'] ?? 0;
            $val = floatval(str_replace(['€',' '], '', str_replace(',', '.', $val)));
            if (!$code) continue;

            $key = $date_obj->format('Y-m');
            if (!isset($isin_data[$code][$key]) || $date_obj > new DateTime($isin_data[$code][$key]['date'])) {
                $isin_data[$code][$key] = [
                    'date' => $date_obj->format('Y-m-d'),
                    'value' => $val
                ];
            }
        }
    }
    ?>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const isinData = <?php echo json_encode($isin_data); ?>;
        const select = document.getElementById('isin-select');

        const ctx = document.getElementById('chart-isin').getContext('2d');
        const chart = new Chart(ctx, {
            type: 'line',
            data: { labels: [], datasets: [] },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                animation: { duration: 900, easing: 'easeOutCubic' },
                interaction: { mode: 'nearest', axis: 'xy', intersect: false },
                plugins: {
                    legend: { display: false },
                    tooltip: { callbacks: { label: ctx => ctx.raw.toFixed(2) + ' €' } }
                },
                scales: {
                    x: { title: { display: true, text: 'Date' } },
                    y: {
                        title: { display: true, text: 'Valeur (€)' },
                        ticks: {
                            callback: v => parseFloat(v).toFixed(2) + ' €'
                        }
                    }
                }
            }
        });

        function updateChart(isin) {
            const raw = isinData[isin] || {};
            const keys = Object.keys(raw).sort();
            const labels = keys.map(k => {
                const d = new Date(raw[k].date);
                return ('0'+d.getDate()).slice(-2)+'/'+('0'+(d.getMonth()+1)).slice(-2)+'/'+d.getFullYear();
            });
            const data = keys.map(k => raw[k].value);
            if (!data.length) { chart.data.labels=[]; chart.data.datasets=[]; chart.update(); return; }

            chart.data.labels = labels;
            chart.data.datasets = [{
                label: isin,
                data: data,
                borderColor:'#2271b1',
                backgroundColor:'#2271b120',
                tension:0.2,
                pointRadius:6,
                pointHoverRadius:8,
                pointBackgroundColor:'#fff',
                pointBorderColor:'#2271b1',
                pointBorderWidth:2
            }];

            chart.update();
        }

        select.addEventListener('change', ()=>updateChart(select.value));
        updateChart(select.value);
    });
    </script>

    <style>
        #graph-toolbar label { display:inline-block; margin-bottom:0; }
        #chart-wrapper {
            border: 1px solid rgba(0,0,0,0.08);
            border-radius: 6px;
            background: linear-gradient(to bottom, rgba(34,113,177,0.03), rgba(34,113,177,0.06));
            padding: 4px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.03);
        }
        #chart-isin { outline:none; display:block; }
    </style>

    <?php
    return ob_get_clean();
});


add_shortcode('contrat_graph_total', function() {
    ob_start();

    $post_id = get_the_ID();
    if (!$post_id) return '<p style="padding:10px;color:#777">Impossible de récupérer le contrat.</p>';

    $actions = get_field('actions', $post_id);
    if (empty($actions)) return '<p style="padding:10px;color:#777">Aucune action pour ce contrat.</p>';

    $date_effet = get_field('date_deffet_contrat', $post_id);
    if ($date_effet) {
        $date_effet_obj = DateTime::createFromFormat('d/m/Y', $date_effet);
        if (!$date_effet_obj) {
            try { $date_effet_obj = new DateTime($date_effet); } catch (Exception $e) { $date_effet_obj = null; }
        }
    } else { $date_effet_obj = null; }

    ?>
    <div id="graph-toolbar" style="display:flex;align-items:center;gap:12px;margin-bottom:8px;margin-top:30px;"></div>
    <div id="chart-wrapper" style="position:relative; width:100%; max-width:100%;">
        <canvas id="chart-total" style="width:100%; height:460px; display:block; margin:16px;"></canvas>
    </div>

    <?php
    $cotations_posts = get_posts([
        'post_type' => 'cotations',
        'posts_per_page' => -1,
        'orderby' => 'title',
        'order' => 'ASC'
    ]);

    $contract_data = [];
    foreach ($cotations_posts as $post) {
        $date_obj = DateTime::createFromFormat('d/m/Y', $post->post_title);
        if (!$date_obj) {
            try { $date_obj = new DateTime($post->post_title); } catch (Exception $e) { continue; }
        }
        if ($date_effet_obj && $date_obj < $date_effet_obj) continue;

        $rows = get_field('cotations', $post);
        if (!$rows) continue;

        $total_val = 0;
        foreach ($actions as $action) {
            $isin = $action['code_isin'] ?? '';
            $parts = floatval($action['nombre_de_parts'] ?? 0);
            if (!$isin || !$parts) continue;

            foreach ($rows as $row) {
                if (($row['isin'] ?? '') === $isin) {
                    $val = floatval(str_replace(['€',' '], '', str_replace(',', '.', $row['valeur_cotation_euro'] ?? 0)));
                    $total_val += $val * $parts;
                }
            }
        }

        $key = $date_obj->format('Y-m');
        if (!isset($contract_data[$key]) || $date_obj > new DateTime($contract_data[$key]['date'])) {
            $contract_data[$key] = [
                'date' => $date_obj->format('Y-m-d'),
                'value' => $total_val
            ];
        }
    }
    ?>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const contractData = <?php echo json_encode($contract_data); ?>;

        const ctx = document.getElementById('chart-total').getContext('2d');
        const chart = new Chart(ctx, {
            type: 'line',
            data: { labels: [], datasets: [] },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                animation: { duration: 900, easing: 'easeOutCubic' },
                interaction: { mode: 'nearest', axis: 'xy', intersect: false },
                plugins: {
                    legend: { display: false },
                    tooltip: { callbacks: { label: ctx => ctx.raw.toFixed(2) + ' €' } }
                },
                scales: {
                    x: { title: { display: true, text: 'Date' } },
                    y: {
                        title: { display: true, text: 'Valorisation (€)' },
                        ticks: {
                            callback: v => parseFloat(v).toFixed(2) + ' €'
                        }
                    }
                }
            }
        });

        function updateChart() {
            const keys = Object.keys(contractData).sort();
            const labels = keys.map(k => {
                const d = new Date(contractData[k].date);
                return ('0'+d.getDate()).slice(-2)+'/'+('0'+(d.getMonth()+1)).slice(-2)+'/'+d.getFullYear();
            });
            const data = keys.map(k => contractData[k].value);
            if (!data.length) { chart.data.labels=[]; chart.data.datasets=[]; chart.update(); return; }

            chart.data.labels = labels;
            chart.data.datasets = [{
                label: 'Valorisation totale',
                data: data,
                borderColor:'#2271b1',
                backgroundColor:'#2271b120',
                tension:0.2,
                pointRadius:6,
                pointHoverRadius:8,
                pointBackgroundColor:'#fff',
                pointBorderColor:'#2271b1',
                pointBorderWidth:2
            }];

            chart.update();
        }

        updateChart();
    });
    </script>

    <style>
    #chart-wrapper {
        border: 1px solid rgba(0,0,0,0.08);
        border-radius: 6px;
        background: linear-gradient(to bottom, rgba(34,113,177,0.03), rgba(34,113,177,0.06));
        padding: 4px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.03);
    }
    #chart-total { outline:none; display:block; }
    </style>

    <?php
    return ob_get_clean();
});


