<?php

add_shortcode('contrats_client', function () {
    ob_start();

    $post_id = get_the_ID();
    if (!$post_id) return '<p style="padding:10px;color:#777">Impossible de déterminer le client.</p>';

    $prenom_client = trim(get_field('prenom_client_ag', $post_id));
    $nom_client    = trim(get_field('nom_client_ag', $post_id));
    if (!$prenom_client || !$nom_client) {
        return '<p style="padding:10px;color:#777">Informations client incomplètes.</p>';
    }

    $parse_number = function($raw) {
        if ($raw === null || $raw === '') return 0.0;
        $s = trim((string)$raw);
        $s = str_replace("\xc2\xa0", ' ', $s);
        $s = str_replace('%', '', $s);
        $s = str_replace(',', '.', $s);
        $s = preg_replace('/[^\d\.\-]/u', '', $s);
        if ($s === '' || $s === '-' || $s === '.') return 0.0;
        return floatval($s);
    };

    // ======== Création contrat hors agrégation ========
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (!current_user_can('edit_posts')) {
            echo '<p>Permission insuffisante.</p>';
            return '';
        }

        // Suppression
        if (!empty($_POST['delete_hag'])) {
            $del_id = intval($_POST['delete_hag']);
            wp_trash_post($del_id);
            wp_redirect(get_permalink());
            exit;
        }

        // Création
        if (!empty($_POST['create_hag'])) {
            $post_hag = wp_insert_post([
                'post_type' => 'contrats_hag',
                'post_status' => 'publish',
                'post_title' => sanitize_text_field($_POST['n_contrat'] ?? 'Contrat'),
            ]);

            if ($post_hag) {
                $fields_map = [
                  'type_de_vente' => 'type_de_vente_horsag',
                    'client' => 'client_horsag',
                    'n_client' => 'n°_client_horsag',
                    'etablissement' => 'etablissement_horsag',
                    'n_contrat' => 'n°_contrat_horsag',
                    'intitule' => 'intitule_horsag',
                    'versements' => 'versements_horsag',
                    'ouverture' => 'ouverture_horsag',
                    'date_situation' => 'date_situation_horsag',

                ];
                foreach ($fields_map as $input => $acf) {
                    if (isset($_POST[$input])) {
                        update_field($acf, sanitize_text_field($_POST[$input]), $post_hag);
                    }
                }
            }

            wp_redirect(get_permalink());
            exit;
        }
    }

    // ======== Query contrats via agrégation ========
$args = [
    'post_type' => ['contrats','contrats-avec-ucs'], // <-- ajout ici
    'posts_per_page' => -1,
    'post_status' => 'publish',
    'no_found_rows' => true,
    'update_post_meta_cache' => true,
    'cache_results' => true,
    'meta_query' => [
        'relation' => 'AND',
        ['key'=>'nom_client_contrat','value'=>$nom_client,'compare'=>'='],
        ['key'=>'prenom_client_contrat','value'=>$prenom_client,'compare'=>'=']
    ]
];

    $q = new WP_Query($args);
    $totaux = ['sommes_versees'=>0.0, 'evaluation_contrat'=>0.0];
    $has_contracts = $q->have_posts();

    // ======== Query contrats hors agrégation ========
    $args_hag = [
        'post_type' => 'contrats_hag',
        'posts_per_page' => -1,
        'post_status' => 'publish',
        'orderby' => 'date',
        'order' => 'ASC',
        'meta_query' => [
            'relation'=>'AND',
            ['key'=>'client_horsag', 'value'=>$prenom_client.' '.$nom_client,'compare'=>'=']
        ]
    ];
    $q_hag = new WP_Query($args_hag);
    $has_hag = $q_hag->have_posts();
    $total_versements = 0;
    ?>

<!-- ====== Toggle via agrégation ====== -->
<div class="contrats-toggle-wrapper">
    <div class="toggle-header-users open" id="toggleHeaderViaAgregation">
        <div class="toggle-left-users">
            <svg viewBox="0 0 24 24" fill="currentColor"><path d="M7 10l5 5 5-5H7z"/></svg>
            <span>Contrats via agrégation</span>
        </div>
    </div>

    <div id="formulaire-via-agregation" class="open" style="margin:20px">
        <?php if($has_contracts): ?>
        <div class="contrats-table-container">
            <table class="contrats-table">
                <thead>
                    <tr>
                        <th>N° Contrat</th>
                        <th>N° Client</th>
                        <th>Intitulé</th>
                        <th>Ouverture</th>
                        <th>Etablissement</th>
                        <th>Versements</th>
                        <th>Évaluation</th>
                        <th>Évolution</th>
                        <th>Date situation</th>
                    </tr>
                </thead>
                <tbody>
                <?php while($q->have_posts()): $q->the_post();
                    $cid = get_the_ID();
                    $fields = function_exists('get_fields') ? get_fields($cid) : [];
                    $numero_contrat = $fields['numero_contrat'] ?? get_post_meta($cid,'numero_contrat',true);
                    $ref_id_personne = $fields['ref_id_personne'] ?? get_post_meta($cid,'ref_id_personne',true);
                    $libelle_produit = $fields['libelle_produit'] ?? get_post_meta($cid,'libelle_produit',true);
                    $date_ouverture = $fields['date_deffet_contrat'] ?? get_post_meta($cid,'date_deffet_contrat',true);
                    $etablissement = $fields['etablissement'] ?? get_post_meta($cid,'etablissement',true);
                    $raw_versements = $fields['sommes_versees'] ?? get_post_meta($cid,'sommes_versees',true);
                    $raw_evaluation = $fields['evaluation_contrat'] ?? get_post_meta($cid,'evaluation_contrat',true);
                    $raw_evolution = $fields['plus_value_totale_en_pourcentage'] ?? get_post_meta($cid,'plus_value_totale_en_pourcentage',true);
                    $date_situation = $fields['date_situation'] ?? get_post_meta($cid,'date_situation',true);

                    $versements = $parse_number($raw_versements);
                    $evaluation = $parse_number($raw_evaluation);
                    $evolution_pct = $parse_number($raw_evolution);

                    $totaux['sommes_versees'] += $versements;
                    $totaux['evaluation_contrat'] += $evaluation;
                ?>
                    <tr>
                        <td><a href="<?= get_permalink($cid) ?>"><?= esc_html($numero_contrat) ?></a></td>
                        <td><?= esc_html($ref_id_personne) ?></td>
                        <td><?= esc_html($libelle_produit) ?></td>
                        <td><?= esc_html($date_ouverture) ?></td>
                        <td><?= esc_html($etablissement) ?></td>
                        <td><?= number_format($versements,2,',',' ') ?> €</td>
                        <td><?= number_format($evaluation,2,',',' ') ?> €</td>
                        <td>
                            <?php
                            if($raw_evolution!==''){
                                echo number_format($evolution_pct,2,',',' ') . ' %';
                            } elseif($versements!=0){
                                $calc = (($evaluation-$versements)/$versements)*100;
                                echo number_format($calc,2,',',' ') . ' %';
                            } else echo '-';
                            ?>
                        </td>
                        <td><?= esc_html($date_situation) ?></td>
                    </tr>
                <?php endwhile; wp_reset_postdata(); ?>
                </tbody>
                <?php if($has_contracts): ?>
                <tfoot>
                    <tr class="total-row">
                        <td colspan="5">TOTAL</td>
                        <td><?= number_format($totaux['sommes_versees'],2,',',' ') ?> €</td>
                        <td><?= number_format($totaux['evaluation_contrat'],2,',',' ') ?> €</td>
                        <td>
                            <?php
                            $evo = $totaux['sommes_versees']!=0 ? (($totaux['evaluation_contrat']-$totaux['sommes_versees'])/$totaux['sommes_versees'])*100 : 0;
                            echo number_format($evo,2,',',' ') . ' %';
                            ?>
                        </td>
                        <td></td>
                    </tr>
                </tfoot>
                <?php endif; ?>
            </table>
        </div>
        <?php else: ?>
        <p class="placeholder">Aucun contrat trouvé pour ce client.</p>
        <?php endif; ?>
    </div>
</div>

<!-- ====== Toggle hors agrégation ====== -->
<div class="contrats-toggle-wrapper">
    <div class="toggle-header-users open" id="toggleHeaderHorsAgregation">
        <div class="toggle-left-users">
            <svg viewBox="0 0 24 24" fill="currentColor"><path d="M7 10l5 5 5-5H7z"/></svg>
            <span>Contrats hors agrégation</span>
        </div>
    </div>

  <div id="formulaire-hors-agregation" class="open" style="margin:20px">
        <?php if($has_hag): ?>
        <div class="contrats-table-container">
            <form method="post">
            <table class="contrats-table">
                <thead>
                    <tr>
                        <th>N° Contrat</th>
                        <th>N° Client</th>
                        <th>Intitulé</th>
                        <th>Ouverture</th>
                        <th>Établissement</th>
                        <th>Versements</th>
                        <th>Date situation</th>
                        <th>Supprimer</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($q_hag->have_posts()): $q_hag->the_post();
                        $cid = get_the_ID();
                        $fields = function_exists('get_fields') ? get_fields($cid) : [];
                        $verse = floatval(str_replace(',', '.', $fields['versements_horsag'] ?? 0));
                        $total_versements += $verse;
                        ?>
                        <tr>
                            <td><?= esc_html($fields['n°_contrat_horsag'] ?? '') ?></td>
                            <td><?= esc_html($fields['n°_client_horsag'] ?? '') ?></td>
                            <td><?= esc_html($fields['intitule_horsag'] ?? '') ?></td>
                            <td><?= esc_html($fields['ouverture_horsag'] ?? '') ?></td>
                            <td><?= esc_html($fields['etablissement_horsag'] ?? '') ?></td>
                            <td><?= esc_html($fields['versements_horsag'] ?? '') ?></td>
                            <td><?= esc_html($fields['date_situation_horsag'] ?? '') ?></td>
                            <td>
                                <button type="submit" name="delete_hag" value="<?= $cid ?>" style="background:none;border:none;color:#e74c3c;cursor:pointer;margin:0;padding:0;">
                                    🗑️
                                </button>
                            </td>
                        </tr>
                    <?php endwhile; wp_reset_postdata(); ?>
                </tbody>
                <tfoot>
                    <tr class="total-row">
                        <td colspan="5">TOTAL</td>
                        <td><?= number_format($total_versements,2,',',' ') ?> €</td>
                        <td colspan="2"></td>
                    </tr>
                </tfoot>
            </table>
            </form>
        </div>
        <?php else: ?>
        <p class="placeholder">Aucun contrat trouvé pour ce client.</p>
        <?php endif; ?>
      </div>

              <button type="button" id="btnCreateHAG" style="margin-left:20px; display:flex; align-items:center; gap:6px; cursor:pointer;background-color:unset;color:black;border:unset;font-style: italic;">
            <svg width="20" height="20" viewBox="0 0 24 24" fill="#2271b1"><path d="M12 5v14m-7-7h14" stroke="#2271b1" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>
            CRÉER UN CONTRAT
        </button>
   <!-- <div id="formulaire-hors-agregation" class="open"> -->


        <!-- Modal -->
<!-- Modal -->
<div id="modalHAG" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.4); z-index:9999; justify-content:center; align-items:center; font-family:Arial,sans-serif;">
    <div style="background:#fff; padding:20px; border-radius:6px; width:900px; max-width:95%; position:relative; box-sizing:border-box;">
        <h3 style="text-align:center; margin-top:0; margin-bottom:20px;">Créer un contrat hors agrégation</h3>
        <form method="post" novalidate style="display:flex; flex-wrap:wrap; gap:10px;">
            <input type="hidden" name="create_hag" value="1">

<div style="flex:1 1 48%; display:flex; flex-direction:column;">
    <label style="font-weight:bold; text-transform:uppercase; margin-bottom:4px;margin-top:10px;">TYPE DE VENTE</label>
    <select name="type_de_vente" style="height:35px; padding:6px;">
        <option value="vie">VIE / RETRAITE</option>
        <option value="iard">IARD</option>
    </select>
</div>


            <div style="flex:1 1 48%; display:flex; flex-direction:column;">
                <label style="font-weight:bold; text-transform:uppercase; margin-bottom:4px;margin-top:10px;">Client</label>
                <input type="text" name="client" value="<?= esc_html($prenom_client.' '.$nom_client) ?>" readonly style="height:35px; padding:6px;">
            </div>

            <div style="flex:1 1 48%; display:flex; flex-direction:column;">
                <label style="font-weight:bold; text-transform:uppercase; margin-bottom:4px;margin-top:10px;">N° CLIENT</label>
                <input type="text" name="n_client" style="height:35px; padding:6px;">
            </div>

            <div style="flex:1 1 48%; display:flex; flex-direction:column;">
                <label style="font-weight:bold; text-transform:uppercase; margin-bottom:4px;margin-top:10px;">ÉTABLISSEMENT</label>
                <input type="text" name="etablissement" style="height:35px; padding:6px;">
            </div>

            <div style="flex:1 1 48%; display:flex; flex-direction:column;">
                <label style="font-weight:bold; text-transform:uppercase; margin-bottom:4px;margin-top:10px;">N° CONTRAT</label>
                <input type="text" name="n_contrat" style="height:35px; padding:6px;">
            </div>

            <div style="flex:1 1 48%; display:flex; flex-direction:column;">
                <label style="font-weight:bold; text-transform:uppercase; margin-bottom:4px;margin-top:10px;">INTITULÉ DU CONTRAT</label>
                <input type="text" name="intitule" style="height:35px; padding:6px;">
            </div>

            <div style="flex:1 1 48%; display:flex; flex-direction:column;">
                <label style="font-weight:bold; text-transform:uppercase; margin-bottom:4px;margin-top:10px;">MONTANT DES VERSEMENTS</label>
                <input type="text" name="versements" style="height:35px; padding:6px;">
            </div>

            <div style="flex:1 1 48%; display:flex; flex-direction:column;">
                <label style="font-weight:bold; text-transform:uppercase; margin-bottom:4px;margin-top:10px;">DATE D'EFFET</label>
                <input type="text" name="ouverture" style="height:35px; padding:6px;">
            </div>

            <div style="flex:1 1 48%; display:flex; flex-direction:column;">
                <label style="font-weight:bold; text-transform:uppercase; margin-bottom:4px;margin-top:10px;">DATE SITUATION</label>
                <input type="text" name="date_situation" style="height:35px; padding:6px;">
            </div>

            <div style="flex:1 1 100%; display:flex; justify-content:flex-end; gap:10px; margin-top:15px;">
                <button type="button" id="cancelHAG" style="padding:8px 16px; font-family:Arial,sans-serif;">Annuler</button>
                <button type="submit" style="padding:8px 16px; background:#2271b1; color:#fff; border:none; border-radius:4px; font-family:Arial,sans-serif;">Créer</button>
            </div>
        </form>
    </div>
</div>


    </div>
</div>

<style>
/* mêmes styles que précédemment */
.toggle-header-users { display:flex; align-items:center; cursor:pointer; user-select:none; padding:12px 14px; width:100%; font-weight:600; font-size:1.2rem; text-transform:uppercase; color:#000; background-color:#fff; border-bottom:1px solid #e2e8f0; transition: background-color 0.25s ease, box-shadow 0.25s ease;}
.toggle-header-users:hover {background-color: rgba(0,0,0,0.04); box-shadow:0 1px 4px rgba(0,0,0,0.08);}
.toggle-left-users {display:flex; align-items:center; gap:10px; flex:1 1 auto;}
.toggle-header-users svg {width:18px; height:18px; transition: transform 0.3s ease;}
.toggle-header-users.open svg {transform:rotate(180deg);}
.contrats-toggle-wrapper {border:1px solid #e2e8f0; border-radius:6px; overflow:hidden; margin-top:20px;}
#formulaire-via-agregation, #formulaire-hors-agregation {transition:max-height 0.4s ease, opacity 0.3s ease; overflow:hidden;}
#formulaire-via-agregation.open, #formulaire-hors-agregation.open {opacity:1; max-height:2000px;}
#formulaire-via-agregation:not(.open),#formulaire-hors-agregation:not(.open) {opacity:0;max-height:0;}
.contrats-table-container {overflow-x:auto; margin-top:12px;}
.contrats-table {width:100%; border-collapse:collapse; font-family:Arial,sans-serif; font-size:14px; line-height:1.6; text-align:center;}
.contrats-table th, .contrats-table td {padding:12px 14px; border-bottom:1px solid #eaeef2;}
.contrats-table th {background:#2271b1; color:#fff; text-transform:uppercase; font-weight:700;}
.contrats-table tbody tr:nth-child(even){background:#fbfdff;}
.contrats-table tbody tr:hover{background:#f1f8ff;}
.total-row {background:#f6f9fc; font-weight:700; text-align:center;}
.placeholder {padding:12px; background:#fafafa; border:1px dashed #ccc; text-align:center; color:#777; font-style:italic; margin-top:12px;}
</style>

<script>
document.addEventListener('DOMContentLoaded', function(){
    const headerVia = document.getElementById('toggleHeaderViaAgregation');
    const bodyVia = document.getElementById('formulaire-via-agregation');
    headerVia.addEventListener('click', ()=>{ const open=bodyVia.classList.toggle('open'); headerVia.classList.toggle('open',open); });

    const headerHors = document.getElementById('toggleHeaderHorsAgregation');
    const bodyHors = document.getElementById('formulaire-hors-agregation');
    headerHors.addEventListener('click', ()=>{ const open=bodyHors.classList.toggle('open'); headerHors.classList.toggle('open',open); });

    // Modal création HAG
    const btn = document.getElementById('btnCreateHAG');
    const modal = document.getElementById('modalHAG');
    const cancel = document.getElementById('cancelHAG');
    btn.addEventListener('click', ()=>{ modal.style.display='flex'; });
    cancel.addEventListener('click', ()=>{ modal.style.display='none'; });
    modal.addEventListener('click', e=>{ if(e.target===modal) modal.style.display='none'; });
});
</script>

<?php
    return ob_get_clean();
});