<?php

add_filter('acf/load_field/name=veuillez_selectionner_le_contrat_souscrit', function ($field) {
    $field['choices'] = ['' => '—']; // Valeur par défaut
    return $field;
});

add_action('acf/input/admin_footer', function () {
?>
<script>
(function($){
    $(document).ready(function(){

        /**
         * Fonction de mise à jour dynamique des contrats
         */
        function updateContratsForCompany(company) {
            const $contrat = $('select[name="acff[post][field_6903892a860ed]"]'); 
            // 🧠 Remplace ci-dessus par le field key de ton champ "veuillez_selectionner_le_contrat_souscrit"
            // (si différent, tu peux le retrouver dans ACF sous “Clé du champ”)

            if(!$contrat.length) return;
            $contrat.html('<option value="">—</option>');

            if(!company || company === '—') return;

            $.ajax({
                url: '<?php echo admin_url('admin-ajax.php'); ?>',
                type: 'POST',
                data: {
                    action: 'get_contrats_for_company',
                    compagnie: company
                },
                success: function(response){
                    $contrat.html(response);
                },
                error: function(xhr){
                    console.error('Erreur AJAX:', xhr.responseText);
                }
            });
        }

        // 🟢 Sélecteur spécifique à ton champ compagnie
        const $compagnie = $('select[name="acff[post][field_690388fc860eb]"]');
        if(!$compagnie.length) return;

        // 🔁 Événement sur changement
        $compagnie.on('change', function(){
            const company = $(this).val();
            updateContratsForCompany(company);
        });

        // 🕐 Préchargement si édition / valeur déjà existante
        setTimeout(() => {
            const initialCompany = $compagnie.val();
            if(initialCompany && initialCompany !== '—') {
                updateContratsForCompany(initialCompany);
            }
        }, 800);
    });
})(jQuery);
</script>
<?php
});


/**
 * 🔎 AJAX : retourne les contrats associés à la compagnie sélectionnée
 */
add_action('wp_ajax_get_contrats_for_company', 'ajax_get_contrats_for_company');
add_action('wp_ajax_nopriv_get_contrats_for_company', 'ajax_get_contrats_for_company');
function ajax_get_contrats_for_company() {
    $compagnie = isset($_POST['compagnie']) ? sanitize_text_field($_POST['compagnie']) : '';
    $post_source_id = 77;
    $taux = get_field('taux_de_commission', $post_source_id);

    $options = '<option value="">—</option>';

    if (!$taux || !is_array($taux) || !$compagnie || $compagnie === '—') {
        echo $options;
        wp_die();
    }

    foreach ($taux as $row) {
        if (!empty($row['compagnie']) && !empty($row['nom_du_contrat']) && $row['compagnie'] === $compagnie) {
            $nom = esc_html($row['nom_du_contrat']);
            $options .= "<option value='{$nom}'>{$nom}</option>";
        }
    }

    echo $options;
    wp_die();
}




add_filter('acf/load_field/name=veuillez_selectionner_lucs_souscrite_1', function($field) {
    // ID de la page UCS
    $post_id = 531;
    $rows = get_field('ucs_disponibles', $post_id);

    // Valeur par défaut
    $choices = ['—' => '—'];

    if ($rows && is_array($rows)) {
        foreach ($rows as $row) {
            if (!empty($row['statut_ucs']) && strtoupper($row['statut_ucs']) === 'COMMERCIALISATION') {
                $nom = trim($row['nom_ucs']);
                if ($nom && !in_array($nom, $choices, true)) {
                    $choices[$nom] = $nom;
                }
            }
        }
    }

    $field['choices'] = $choices;
    return $field;
});

add_filter('acf/load_field/name=veuillez_selectionner_lucs_souscrite_2', function($field) {
    // ID de la page UCS
    $post_id = 531;
    $rows = get_field('ucs_disponibles', $post_id);

    // Valeur par défaut
    $choices = ['—' => '—'];

    if ($rows && is_array($rows)) {
        foreach ($rows as $row) {
            if (!empty($row['statut_ucs']) && strtoupper($row['statut_ucs']) === 'COMMERCIALISATION') {
                $nom = trim($row['nom_ucs']);
                if ($nom && !in_array($nom, $choices, true)) {
                    $choices[$nom] = $nom;
                }
            }
        }
    }

    $field['choices'] = $choices;
    return $field;
});

add_filter('acf/load_field/name=veuillez_selectionner_lucs_souscrite_3', function($field) {
    // ID de la page UCS
    $post_id = 531;
    $rows = get_field('ucs_disponibles', $post_id);

    // Valeur par défaut
    $choices = ['—' => '—'];

    if ($rows && is_array($rows)) {
        foreach ($rows as $row) {
            if (!empty($row['statut_ucs']) && strtoupper($row['statut_ucs']) === 'COMMERCIALISATION') {
                $nom = trim($row['nom_ucs']);
                if ($nom && !in_array($nom, $choices, true)) {
                    $choices[$nom] = $nom;
                }
            }
        }
    }

    $field['choices'] = $choices;
    return $field;
});
