<?php
if (!defined('ABSPATH')) exit;

/**
 * Retourne l’ID de la page Administration.
 * Résout dynamiquement par slug, avec cache statique.
 */
function arc_get_administration_page_id(): int {

    static $id = null;
    if ($id !== null) {
        return $id;
    }

    // 1) Tentative via option (si déjà stockée)
    $stored = (int) get_option('arc_page_administration_id', 0);
    if ($stored && get_post($stored)) {
        return $id = $stored;
    }

    // 2) Fallback par slug
    $page = get_page_by_path('administration');
    if ($page) {
        $id = (int) $page->ID;
        update_option('arc_page_administration_id', $id); // cache persistant
        return $id;
    }

    // 3) Rien trouvé
    return $id = 0;
}
