<?php

if (!defined('ABSPATH')) exit;

if (!function_exists('arc_get_page_id_by_path_cached')) {
    /**
     * Retourne l'ID d'une page par slug (path) avec cache option + cache statique.
     */
    function arc_get_page_id_by_path_cached(string $path, string $option_key): int {

        static $mem = [];
        if (isset($mem[$option_key])) {
            return (int) $mem[$option_key];
        }

        $stored = (int) get_option($option_key, 0);
        if ($stored && get_post($stored)) {
            return $mem[$option_key] = $stored;
        }

        $page = get_page_by_path(trim($path, '/'));
        if ($page) {
            $id = (int) $page->ID;
            update_option($option_key, $id);
            return $mem[$option_key] = $id;
        }

        return $mem[$option_key] = 0;
    }
}

// Page cible du formulaire "Nouvelle vente"
$arc_page_nouvelle_vente_id = arc_get_page_id_by_path_cached('nouvelle-vente', 'arc_page_nouvelle_vente_id');


add_filter('acf/load_value/name=mandataire', function($value, $post_id, $field) {

    // 🧭 On vérifie qu’on est bien sur la page du formulaire "Nouvelle vente"
if (!$arc_page_nouvelle_vente_id || !is_page($arc_page_nouvelle_vente_id)) {
    return $value;
}

    // 🔐 Vérifie qu’un utilisateur est connecté
    $user_id = get_current_user_id();
    if (!$user_id) {
        return $value;
    }

    // 👤 Récupère les infos de l’utilisateur
    $user = get_userdata($user_id);
    if (!$user) {
        return $value;
    }

    $prenom = get_user_meta($user_id, 'first_name', true);
    $nom = get_user_meta($user_id, 'last_name', true);

    // 🏷️ Construit le nom complet proprement
    $full_name = trim("$prenom $nom");
    if (empty($full_name)) {
        $full_name = $user->display_name;
    }

    // 💾 Retourne cette valeur pour préremplir le champ
    return $full_name;

}, 10, 3);


add_filter('acf/prepare_field/name=mandataire', function($field){
    // s'assure qu'on a bien un champ texte (optionnel)
    if (!isset($field['type']) || in_array($field['type'], ['text','textarea','email','number'])) {
        // ajout de l'attribut readonly sur l'input HTML généré par ACF
        if (!isset($field['input_attributes']) || !is_array($field['input_attributes'])) {
            $field['input_attributes'] = [];
        }
        $field['input_attributes']['readonly'] = 'readonly';

        // ajout d'une classe wrapper pour styling si besoin
        if (!isset($field['wrapper']['class'])) $field['wrapper']['class'] = '';
        if (strpos($field['wrapper']['class'], 'mandataire-readonly') === false) {
            $field['wrapper']['class'] .= ' mandataire-readonly';
        }
    }
    return $field;
});



add_filter('acf/load_field/name=accompagnant', function($field) {

    // Réinitialise les choix du champ
    $field['choices'] = [];

    // Ajout d'une option vide par défaut
    $field['choices'][''] = '—';

    // Récupération de tous les utilisateurs
    $users = get_users([
        'orderby' => 'display_name',
        'order'   => 'ASC',
    ]);

    $current_user_id = get_current_user_id();

    foreach ($users as $user) {
        // Exclut l'utilisateur connecté et l'admin (ID 1)
        if ($user->ID == 1 || $user->ID == $current_user_id) {
            continue;
        }

        // Construit le nom complet : Prénom + Nom
        $prenom = get_user_meta($user->ID, 'first_name', true);
        $nom = get_user_meta($user->ID, 'last_name', true);
        $label = trim("$prenom $nom");

        // Si vide, on prend display_name
        if (empty($label)) {
            $label = $user->display_name;
        }

        // Ajout au champ
        $field['choices'][$user->ID] = $label;
    }

    return $field;
});


add_filter('acf/load_field/name=second_accompagnant', function($field) {

    // Réinitialise les choix du champ
    $field['choices'] = [];

    // Ajout d'une option vide par défaut
    $field['choices'][''] = '—';

    // Récupération de tous les utilisateurs
    $users = get_users([
        'orderby' => 'display_name',
        'order'   => 'ASC',
    ]);

    $current_user_id = get_current_user_id();

    foreach ($users as $user) {
        // Exclut l'utilisateur connecté et l'admin (ID 1)
        if ($user->ID == 1 || $user->ID == $current_user_id) {
            continue;
        }

        // Construit le nom complet : Prénom + Nom
        $prenom = get_user_meta($user->ID, 'first_name', true);
        $nom = get_user_meta($user->ID, 'last_name', true);
        $label = trim("$prenom $nom");

        // Si vide, on prend display_name
        if (empty($label)) {
            $label = $user->display_name;
        }

        // Ajout au champ
        $field['choices'][$user->ID] = $label;
    }

    return $field;
});