<?php
if (!defined('ABSPATH')) exit;

add_action('acf/update_value/name=objectifs_par_utilisateur', function($value, $post_id) {

    if (empty($value) || !is_array($value)) {
        return $value;
    }

    // ✅ ID dynamique de la page /administration/
    $source_id = function_exists('arc_get_administration_page_id')
        ? (int) arc_get_administration_page_id()
        : 0;

    if (!$source_id || !function_exists('get_field') || !function_exists('update_field')) {
        return $value;
    }

    // Source catégories + cible objectifs par catégorie = Administration (même page)
    $post_categories_source = $source_id;
    $post_objectifs_par_cat = $source_id;

    // Récupère les catégories
    $categories = get_field('categories_de_ventes', $post_categories_source);
    if (empty($categories) || !is_array($categories)) {
        return $value;
    }

    $nouveaux_objectifs = [];

    // Parcours des catégories
    foreach ($categories as $cat) {

        if (!is_array($cat)) continue;

        $acronyme_raw = $cat['acronyme_categorie_vente'] ?? '';
        $nom          = trim((string) ($cat['nom_categorie_vente'] ?? ''));

        // On garde ton fonctionnement: field_key basé sur l'acronyme si dispo
        $acronyme = sanitize_title((string) $acronyme_raw);

        // Si pas d'acronyme et pas de nom → skip
        if ($acronyme === '' && $nom === '') continue;

        // Si pas d'acronyme, fallback sur le nom (sinon val_ vide)
        if ($acronyme === '' && $nom !== '') {
            $acronyme = sanitize_title($nom);
        }

        $field_key = 'val_' . $acronyme;
        $total = 0;

        // Addition des valeurs par catégorie
        foreach ($value as $user_id => $valeurs) {
            if (isset($valeurs[$field_key]) && is_numeric($valeurs[$field_key])) {
                $total += (float) $valeurs[$field_key];
            }
        }

        // 🧩 Utilise le nom complet pour la colonne "categorie_vente_obj"
        $nouveaux_objectifs[] = [
            'categorie_vente_obj' => $nom,   // nom complet
            'objectif_cat_vente'  => $total, // somme
        ];
    }

    // Mise à jour du répéteur
    if (!empty($nouveaux_objectifs)) {
        update_field('objectifs_cat_vente', $nouveaux_objectifs, $post_objectifs_par_cat);
    }

    return $value;

}, 20, 2);
