<?php
if (!defined('ABSPATH')) exit;

function arc_install_menu() {

    $menu_name = 'Menu principal';
    $menu_exists = wp_get_nav_menu_object($menu_name);

    if (!$menu_exists) {
        $menu_id = wp_create_nav_menu($menu_name);
    } else {
        $menu_id = $menu_exists->term_id;
    }

    $page_keys = ['dashboard', 'profil'];

    foreach ($page_keys as $key) {
        $page_id = get_option('arc_page_' . $key . '_id');
        if (!$page_id) continue;

        wp_update_nav_menu_item($menu_id, 0, [
            'menu-item-title'  => get_the_title($page_id),
            'menu-item-object' => 'page',
            'menu-item-object-id' => $page_id,
            'menu-item-type'   => 'post_type',
            'menu-item-status' => 'publish',
        ]);
    }

    // Assigner au thème
    $locations = get_theme_mod('nav_menu_locations');
    $locations['primary'] = $menu_id;
    set_theme_mod('nav_menu_locations', $locations);
}
