(function($){

    console.log('cg/acf-client-selector loaded');

    const acfFieldMap = {
        civilite:               "field_6932a85c26fd2",
        nom_client:             "field_6932a85c27007",
        prenom_client:          "field_6932a85c2703d",
        date_naissance_client:  "field_6932a85c27072",
        lieu_naissance_client:  "field_6932a85c270a7",
        adresse:                "field_6932a85c270dc",
        ville:                  "field_6932a85c27112",
        cp:                     "field_6932a85c27147",
        mail:                   "field_6932a85c2717c",
        tel:                    "field_6932a85c271b2",
        profession_client:      "field_6932a85c271e7",
        situation_fam_client:   "field_6932a85c2721d",
        charge_client:          "field_6932a85c27252",
        statut_pat_client:      "field_6932a85c27288"
    };

    document.addEventListener('DOMContentLoaded', function () {

        console.log('cg/initCG – DOM ready');

        const ficheCree    = document.querySelector('[data-key="field_69381a19dd403"] select');
        const clientSelect = document.querySelector('[data-key="field_69381a7fdd404"] select');

        if (!ficheCree) {
            console.warn('cg: champ fiche_cree introuvable');
            return;
        }

        ficheCree.addEventListener('change', function() {
            console.log('cg/fiche_cree changed ->', this.value);

            if (this.value.toLowerCase().trim() === 'oui') {
                loadClients();
            }
        });

        if (clientSelect) {
            clientSelect.addEventListener('change', function() {
                console.log('cg/client_select changed ->', this.value);
                if (this.value) fetchClientData(this.value);
            });
        }
    });


function loadClients() {

    console.log('cg/loadClients()');

    fetch(cgAjax.url, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
        },
        body: new URLSearchParams({ action: 'get_user_clients' })
    })
    .then(r => r.json())
    .then(list => {

        console.log('cg/get_user_clients response:', list);

        const $select = $('[data-key="field_69381a7fdd404"] select');

        $select.empty();
        $select.append('<option value="">Sélectionner un client…</option>');

        if (!list || !list.length) {
            console.warn('cg: aucun client trouvé');
            return;
        }

        // 👉 TRI ALPHABÉTIQUE
        list.sort((a, b) => a.title.localeCompare(b.title, 'fr', { sensitivity: 'base' }));

        // Ajout dans le dropdown
        list.forEach(client => {
            $select.append(`<option value="${client.id}">${client.title}</option>`);
        });
    })
    .catch(err => {
        console.error('cg/loadClients ERROR:', err);
    });
}



    function fetchClientData(clientID) {

        fetch(cgAjax.url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            body: new URLSearchParams({
                action: 'get_client_data',
                client_id: clientID
            })
        })
        .then(r => r.json())
        .then(resp => {

            console.log('cg/get_client_data response:', resp);

            if (!resp || resp.success === false) {
                console.warn('cg:get_client_data ERROR:', resp);
                return;
            }

            const data = resp.data || resp;

            Object.entries(data).forEach(([acfKey, value]) => {

                const realKey = acfFieldMap[acfKey];

                if (!realKey) {
                    console.warn("cg: aucune data-key mappée pour", acfKey);
                    return;
                }

                const input = document.querySelector(
                    `[data-key="${realKey}"] input, 
                     [data-key="${realKey}"] textarea, 
                     [data-key="${realKey}"] select`
                );

                if (!input) {
                    console.warn('cg: champ non trouvé ->', realKey);
                    return;
                }

                input.value = value || '';
                input.dispatchEvent(new Event('change'));
            });
        });
    }

})(jQuery);
