<?php
/**
 * Template PDF Conformité – version PHP
 *
 * IMPORTANT :
 * - Attend une variable $post_id (ID du post de conformité)
 * - Utilise ACF pour récupérer les champs
 * - Définit $footer_html pour usage avec $mpdf->SetHTMLFooter($footer_html)
 */

if (!defined('ABSPATH')) {
    exit;
}


$source_id = function_exists('arc_get_administration_page_id') ? arc_get_administration_page_id() : 0;

if (!$source_id) {
    // soit tu retournes vide, soit tu mets un fallback
    $footer_html = '';
} else {

    $footer_html  = '<div class="divFooter">';
    $footer_html .= get_field('nom_du_cabinet', $source_id) . '<br>';
    $footer_html .= 'Siège social: ' . get_field('siege_social', $source_id)
        . ' - ' . get_field('forme_juridique', $source_id)
        . ' au capital de ' . get_field('capital_social', $source_id)
        . ' - RCS ' . get_field('rcs', $source_id)
        . ' N°' . get_field('n_rcs', $source_id)
        . ' - SIRET: ' . get_field('n_siret', $source_id)
        . ' - Code APE: 6622Z<br>';

    $footer_html .= 'Société de courtage en assurance (COA) - Conformément au code des assurances L.512-6: R.512-14<br>';

    $footer_html .= 'Enregistrée à l’ORIAS sous le n°' . get_field('n_orias_du_cabinet', $source_id)
        . ' - www.orias.fr - TVA INTRACOMMUNAUTAIRE: ' . get_field('n_tva_intracommunautaire', $source_id)
        . ' - Le Cabinet ' . get_field('nom_du_cabinet', $source_id) . ' applique la mention RGPD<br>';

    $footer_html .= 'Téléphone: ' . get_field('n_telephone_du_cabinet', $source_id)
        . ' - Mail: ' . get_field('adresse_mail_du_cabinet', $source_id);

    $footer_html .= '</div>';
}

$tab_niveau_img_id  = (int) get_option('arc_media_tab_niveau_id', 0);
$tab_niveau_img_url = $tab_niveau_img_id ? wp_get_attachment_image_url($tab_niveau_img_id, 'full') : '';


/**
 * Helper : champ ACF du dossier "Conformité" (post courant)
 */
function cpg_field($name, $post_id = null, $escape = true) {

    $post_id = $post_id ?: get_the_ID();

    // Récupération ACF normale ou meta classique
    $val = function_exists('get_field') 
        ? get_field($name, $post_id)
        : get_post_meta($post_id, $name, true);

    // Si vide → retour vide
    if ($val === null || $val === false || $val === '') {
        return '';
    }

    // Si tableau → formatage propre
    if (is_array($val)) {

        // Cas checkbox ACF → tableau simple
        if (!empty($val) && !is_array(reset($val))) {
            $val = implode(', ', $val);
        }

        // Cas repeater ou tableau profond
        else {
            $formatted = [];
            foreach ($val as $row) {
                if (is_array($row)) {
                    $formatted[] = implode(' - ', array_filter($row));
                } else {
                    $formatted[] = $row;
                }
            }
            $val = implode(', ', $formatted);
        }
    }

    // Échappement
    return $escape ? esc_html($val) : $val;
}

/**
 * Helper : email de l’utilisateur courant (équivalent {power:user-email})
 */
function cpg_user_email() {
    $user = wp_get_current_user();
    if ($user && $user->user_email) {
        return esc_html($user->user_email);
    }
    return '';
}

/**
 * Helper : vérifie si une valeur ACF (string ou array) contient au moins une des cibles
 */
function cpg_has_any($value, array $targets) {
    if (is_array($value)) {
        foreach ($value as $v) {
            if (in_array((string)$v, $targets, true)) {
                return true;
            }
        }
        return false;
    }
    return in_array((string)$value, $targets, true);
}

function ret_uc_row($label, $field, $horizon, $color, $risk){
    global $post_id;
    return "
    <tr>
        <td style='border:0.5px solid black;height:30px;'>$label</td>
        <td style='border:0.5px solid black;'><b>" . cpg_field($field, $post_id) . "</b></td>
        <td style='border:0.5px solid black;'><i>$horizon</i></td>
        <td style='border:0.5px solid black;background-color:$color;'>$risk</td>
    </tr>";
}

// Raccourcis pour certaines valeurs du formulaire
$date_du_jour          = cpg_field('date_du_jour', $post_id);
$civilite              = cpg_field('civilite', $post_id);
$prenom_client         = cpg_field('prenom_client', $post_id);
$nom_client            = cpg_field('nom_client', $post_id);
$conseiller_vie        = cpg_field('conseiller_vie', $post_id);
$cadre                 = cpg_field('cadre', $post_id, false);
$missions              = cpg_field('missions', $post_id, false);

$lettres  = (array) get_field('lettres', $post_id);
$rapports = (array) get_field('rapports', $post_id);
$suivis   = (array) get_field('suivis', $post_id);

// Pour la grosse condition sur le questionnaire
$questionnaire_triggers = array(
    'ASSURANCE VIE',
    'COMPLÉMENTAIRE SANTÉ',
    'PRÉVOYANCE',
    'SANTÉ'
);

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Conformité – PDF</title>

    <!-- Police proche de la version précédente -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro" rel="stylesheet" type="text/css">

    <style>
        body {
            font-family: roboto, "Source Sans Pro", sans-serif;
            font-size: 12px;
            text-align: justify;
        }

        .divFooter {
            position: fixed;
            bottom: 0;
            font-size: 7px;
            text-align: center;
            margin-left: auto;
            margin-right: auto;
            width: 100%;
        }

        table {
            border-collapse: collapse;
        }

        table td, table th {
            vertical-align: top;
        }
    </style>
</head>
<body>

<!-- PAGE ACCUEIL -->

<div style="text-align:right;font-size:12px;">
    <?= esc_html($date_du_jour); ?>
</div>

<br><br><br><br><br>

<div style="text-align:center;font-size:18px;">
    <i>À l'attention de <br>
        <?= esc_html($civilite . ' ' . $prenom_client . ' ' . $nom_client); ?>
    </i>
</div>

<br><br><br><br><br>

<div id="logo" style="text-align:center;">
<?php

// logo_cabinet = champ ACF "Fichier"
$logo = function_exists('get_field') && $source_id
    ? get_field('logo_cabinet', $source_id)
    : null;

// Selon ACF : $logo peut être un ID, une URL, ou un array
$logo_url = '';

if (is_array($logo)) {
    // Return format = Array
    $logo_url = $logo['url'] ?? '';
} elseif (is_numeric($logo)) {
    // Return format = ID
    $logo_url = wp_get_attachment_url((int) $logo);
} elseif (is_string($logo)) {
    // Return format = URL
    $logo_url = $logo;
}

if ($logo_url) : ?>
    <img width="30%" src="<?= esc_url($logo_url); ?>">
<?php endif; ?>
</div>

<br><br><br><br><br>

<div style="text-align:center;font-size:12px;">
    Votre conseiller et interlocuteur privilégié sera <br><?= esc_html($nom_conseiller); ?>
</div>

<p style="page-break-before:always;"></p>

<!-- PAGE : LETTRE DE MISSION GLOBALE -->

<div style="text-align:center;font-size:20px;">
    <b>Lettre de mission globale</b>
</div>

<br><br>

<div style="text-align:justify">
Madame, Monsieur,<br><br>

Vous avez bien voulu nous consulter en qualité de conseil et nous vous remercions de cette confiance.<br><br>

A l’occasion de notre entretien, nous vous avons remis le document d’entrée en relation comportant l’ensemble des informations légales de notre cabinet.<br><br>
<b>1. <u>CADRE DE NOTRE INTERVENTION</u></b><br><br>

Lors de notre entretien courant de ce jour, vous m’avez fait part des axes de réflexion qui vous semblent déterminants et sur lesquels vous souhaitez que nous portions l’accent compte tenu de vos objectifs patrimoniaux.<br><br>

<b><u>Afin de répondre à votre attente, nous vous proposons de :</u></b><br><br>

    <?php
    // Ancien bloc {if:{eqv:{form:cadre} 'Tous les points ci-dessus'} '...' {form:cadre} }
    $texte_cadre_defaut = "Réaliser un audit patrimonial global de votre situation patrimoniale actuelle sur les plans économiques, juridiques et fiscaux dans un objectif d’optimisation, réaliser un audit de protection sociale, évaluer votre politique de placement et d’épargne actuelle et mettre en place une stratégie de gestion à moyen long terme intégrant vos objectifs et critères de gestion personnels, vous conseiller dans les allocations d’actifs de vos placements financiers, assurance-vie, immobiliers, étudier les moyens de valoriser votre épargne, préparer la transmission de votre patrimoine, analyser votre situation fiscale et le cas échéant les modalités d’optimisation, étudier les moyens de préparer votre retraite, étudier les moyens de protéger vos proches, vous conseiller dans la recherche de solutions d’assurance prévoyance, étudier les modalités de financement de votre bien immobilier, réaliser un audit de complémentaire santé, établir un bilan de vos assurances de biens, vous conseiller dans la recherche de solutions d’assurance entreprise.";
    ?>

    <?php if (trim((string)$cadre) === "Tous les points ci-dessus") : ?>
        <?= esc_html($texte_cadre_defaut); ?>
    <?php else : ?>
        <?= esc_html($cadre); ?>
    <?php endif; ?>

    <br><br>

    <b><u>Votre patrimoine global ou vos objectifs de placement sont amenés à évoluer dans le temps. Pour cette raison, nous pourrons vous proposer de :</u></b><br><br>

    <?php
    // Ancien bloc {if:{eqv:{form:missions} 'Tous les points ci-dessus'} '...' {form:missions} }
    $texte_missions_defaut = "Examiner la situation consolidée des investissements réalisés par l’intermédiaire de notre cabinet et de votre exposition au risque, actualiser votre situation patrimoniale, vous tenir informé de tous les types de placements financiers / assurance-vie / immobiliers qui répondraient à votre problématique patrimoniale, convenir d’un rendez-vous, chaque fois que vous le jugerez nécessaire, pour faire le point sur votre situation patrimoniale, vous accompagner, à votre demande, dans vos démarches auprès des intermédiaires financiers, des autorités administratives ou de conseillers juridiques et fiscaux.";
    ?>

    <?php if (trim((string)$missions) === "Tous les points ci-dessus") : ?>
        <?= esc_html($texte_missions_defaut); ?>
    <?php else : ?>
        <?= esc_html($missions); ?>
    <?php endif; ?>

    <br><br>

   <b>2. <u>MODALITES DE NOTRE INTERVENTION</u></b><br><br>
Notre mission débutera à réception d’un exemplaire de la présente lettre de mission signée par vos soins.<br><br>
Nous collecterons l'ensemble des éléments patrimoniaux qui nous permettront d’avoir connaissance de votre situation financière, de votre expérience et de vos objectifs en matière d’investissement.<br><br>
Vous pourrez alors choisir de mettre en œuvre la stratégie que vous aurez retenue avec le ou les professionnels de votre choix. Nous espérons que vous nous accorderez votre confiance pour leur mise en œuvre.<br><br>
</div><div style="text-align:justify;">
<b>3. <u>REMUNERATIONS</u></b><br><br>
Concernant le budget relatif à cette mission et compte tenu des problématiques évoquées lors de notre entretien, nous estimons que cette mission pourra être rémunérée par des commissions et/ou des rétrocessions de commissions versées par les établissements promoteurs de produits liés aux investissements que vous réaliserez par l’intermédiaire de notre cabinet.<br><br>
Pour votre information, lorsque la prestation de conseil est suivie d’une prestation d’intermédiation sur des produits financiers, nous pourrons recevoir le cas échéant :<br><br>
• Frais uniques : frais de dépôt, de résiliation et coûts de transfert, de structuration...<br>
• Frais récurrents : frais de gestion, de conseil, de garde, de service, financiers...<br>
• Coûts relatifs aux transactions : commissions de courtage, frais d’entrée, frais de change...<br>
• Coûts marginaux et frais associés aux services auxiliaires : coûts de recherche et commissions liées aux résultats.<br><br>
Le client est informé que pour tout acte d’intermédiation le conseiller rémunéré par la totalité des frais d’entrée déduction faite de la part acquise à la société qui l’autorise à commercialiser le produit, auquel s’ajoute une fraction de frais de gestion qui est au maximum de 1,5 %. Au titre de l’accompagnement du client, une <b>information plus précise sera fournie à sa demande une fois connus les supports choisis.</b><br><br><br>
<p style="page-break-before:always;"></p>
<b>4. <u>CONFIDENTIALITE</u></b><br><br>
Tous les documents et éléments qui nous seront transmis seront traités avec la plus extrême confidentialité.<br>
Conformément aux articles 39 et 40 de la loi n° 78-17 du 6 janvier 1978 relative à l'informatique, aux fichiers et aux libertés, vous pourrez exercer un droit d’accès et de rectification de ces informations au siège social de notre cabinet.<br><br>

<b>5. <u>DISPOSITIONS DIVERSES</u></b><br><br>
Le conseiller doit disposer des informations patrimoniales et financières relatives à son client afin de pouvoir mener à bien ses missions et ses obligations de devoir d’information et de conseil.<br>
Vous certifiez la validité des informations que vous nous avez transmises, sachant que toute erreur ou omission de votre part peut conduire à des conclusions erronées sans pour autant que notre responsabilité puisse être engagée. Vous êtes invité à signaler les éléments qui vous paraissent présenter des incohérences.<br><br>
Le client reconnait alors avoir été averti des conséquences d'un refus de fournir les informations personnelles le concernant. Nous rappelons que le conseiller est tenu au respect du secret professionnel.<br><br>

<b>GESTION DES CONFLITS D’INTERETS</b><br><br>
Dans le cas où le cabinet <?= get_field('nom_du_cabinet', $source_id); ?> estimerait se trouver dans le cadre d’un conflit d’intérêts, ce dernier s’engage à en informer immédiatement le client.<br><br>
A défaut d’un accord écrit de la part du client, le cabinet <?= get_field('nom_du_cabinet', $source_id); ?> engagera une concertation avec ce dernier afin d’obtenir un accord dont les conclusions écrites seront signées par les deux parties.<br><br>
A défaut de l’obtention d’un accord avec le client, qui amènerait le cabinet <?= get_field('nom_du_cabinet', $source_id); ?>
   à estimer qu’il n’existe plus de conflit d’intérêts, le cabinet s’engage à proposer une solution qui permettrait de faire disparaître le conflit d’intérêts ou d’en faire disparaître les effets.<br><br>
En dernier recours, le cabinet <?= get_field('nom_du_cabinet', $source_id); ?> s’engage à refuser ou à abandonner la mission.<br><br>
Il est ici précisé que la présente mission implique une obligation de moyens et aucunement une obligation de résultats. En outre, vous vous engagez par la signature de ce document à un devoir d’information et de coopération sincère et exhaustive.<br><br>
Dans le cadre du suivi patrimonial, vous vous engagez à nous faire part de toute opération d’ores et déjà réalisée ou à venir qui affecterait votre situation patrimoniale, afin que nous puissions exercer notre devoir de conseil.<br><br>
Par la présente, vous autorisez les établissements dépositaires ou compagnies d’assurance à communiquer au cabinet
    <?= get_field('nom_du_cabinet', $source_id); ?> et le cas échéant à son prestataire de services informatiques, l’ensemble des informations concernant vos investissements et vos données personnelles d’ordre civil, patrimonial, financier ou autres.<br><br>
Cette communication facilite le respect de nos obligations en matière de suivi et d’archivage.<br><br>
Nous nous engageons à vous informer de l’actualisation de nos mandants et des partenaires avec lesquels nous pourrions entretenir une relation significative de nature capitalistique ou commerciale.<br><br>
Notre mission fera l’objet d’un renouvellement par tacite reconduction tous les ans. Chacune des parties pourra y renoncer avec un délai de préavis d’un mois.
</div>

<br><br>

<b>6. <u>LITIGES</u></b><br><br>
<div style="text-align:justify;">
    Pour l’exécution des présentes et d’une manière générale pour l’exécution de la mission confiée à la société 
    <?= get_field('nom_du_cabinet', $source_id); ?>, il sera fait application de la réglementation française.<br>
En cas de non-règlement amiable ou par intervention de médiateur, tous les litiges portant sur la souscription, la validité, l’interprétation ou l’exécution du présent contrat ou de ses suites seront soumis aux juridictions compétentes.<br><br>
<b>7. <u>CLAUSE DE DÉMARCHAGE</u></b><br><br>
Dans le cas où la lettre de mission serait le résultat d’un acte de démarchage, vous bénéficiez d’un délai de rétractation de 14 jours, à compter de la date de réception de la présente lettre de mission. Durant cette période, vous aurez la liberté de renoncer purement et simplement à votre engagement en nous faisant parvenir par courrier recommandé avec accusé de réception une lettre de renonciation suivant le modèle ci-après : <i>« Je, soussigné, [Nom Prénom] déclare renoncer au contrat de prestation de service en matière de conseil et d’accompagnement conclu le [Date] avec [Nom Prénom] représentant le Cabinet [Nom du cabinet] ».  </i></div>
<br><br>
<b>8. <u>DOCUMENT D'ENTRÉE EN RELATION (DER)</u></b><br><br>

Le client reconnait avoir pris connaissance du document intitulé « Document d’Entrée en Relation » présentant la société <?= get_field('nom_du_cabinet', $source_id); ?> et qu’un exemplaire de cette dernière lui a été remis.<br><br>

<b>9. <u>LUTTE CONTRE LE BLANCHIMENT DE CAPITAUX</u></b><br><br>
Conformément aux obligations relatives à la lutte contre le blanchiment de capitaux, nous sommes tenus de procéder à l'ensemble des contrôles et déclarations prévus par le Code monétaire et financier. En conséquence, nous avons mis en place des procédures internes relatives à la détection et à la gestion de toute opération dont l'origine des fonds concernés apparaît douteuse, qui pourront faire l'objet des déclarations prévues par la loi auprès de l'autorité instituée à l'article L. 562-4 du Code monétaire et financier.<br><br>





<b>10. <u>DELAI DE RENONCIATION</u></b><br><br>

<p>
Dans le cadre de la législation de protection du consommateur, vous pouvez renoncer à la mission décrite ci-dessus dans un délai de 14 jours, par lettre recommandée avec accusé de réception ou en inscrivant par écrit directement par le client la mention à la main :<br><br>
« Madame, Monsieur, .....................je souhaite faire la levée du délai de 14 jours de réflexion et renonce de mon plein gré et accorde à mon conseiller de procéder à la souscription sans délais d’attente ».<br><br>
Pour l’exécution des présentes et d’une manière générale pour l’exécution de la mission confiée à la société
    <?= cpg_field('nom_du_cabinet', $source_id); ?> il sera fait application de la réglementation française.<br><br>
En cas de non-règlement amiable ou par intervention de médiateur, tous les litiges portant sur la souscription, la validité, l’interprétation ou l’exécution du présent contrat ou de ses suites seront soumis aux juridictions compétentes.
</p>

<p style="page-break-before:always;"></p>



    <!-- QUESTIONNAIRE CONNAISSANCES ET EXPERIENCES FINANCIERES -->

    <p style="text-align:center; font-size:20px;">
        <b>QUESTIONNAIRE CONNAISSANCES ET EXPERIENCES FINANCIERES</b>
    </p>

    <p style="text-align:justify;">
        Vos informations patrimoniales inscrites ci-dessous sont enregistrées à la date du
        <?= esc_html($date_du_jour); ?>.
    </p>

       <table style="border: 2px solid black;margin:8px;padding:8px;">


<tr style="background-color:lightgrey"> <th style="width:320px;text-align:center;padding:10px;">Vos informations personnelles</th> <th style="width:320px;text-align:center;padding:10px;">Informations personnelles de votre conjoint(e)</th> </tr>
<tr> <td>Civilité: <b><?= cpg_field('civilite', $post_id); ?></b></td> <td>Civilité: <b><?= cpg_field('civilite_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Prénom: <b><?= cpg_field('prenom_client', $post_id); ?></b></td> <td>Prénom: <b><?= cpg_field('prenom_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Nom: <b><?= cpg_field('nom_client', $post_id); ?></b></td> <td>Nom: <b><?= cpg_field('nom_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Date et lieu de naissance: <b><?= cpg_field('date_naissance_client', $post_id); ?></b> à <b><?= cpg_field('lieu_naissance_client', $post_id); ?></b></td> <td>Date et lieu de naissance: <b><?= cpg_field('date_naissance_conjoint', $post_id); ?></b> à <b><?= cpg_field('lieu_naissance_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Profession: <b><?= cpg_field('profession_client', $post_id); ?></b></td> <td>Profession: <b><?= cpg_field('profession_conjoint', $post_id); ?></b></td> </tr>
<tr> <th style="text-align:left; padding:10px;background-color:lightgrey">Votre situation familiale / patrimoniale</th> </tr>
<tr> <td>Situation familiale: <b><?= cpg_field('situation_fam_client', $post_id); ?></b></td> </tr>
<tr> <td>Personne(s) à charge: <b><?= cpg_field('charge_client', $post_id); ?></b></td> </tr>
<tr> <td>Statut patrimonial: <b><?= cpg_field('statut_pat_client', $post_id); ?></b></td> </tr>
</table>

    <br>

    <b>1.&nbsp;&nbsp; <u>Sélectionnez l’intitulé correspondant à votre appétence au risque</u></b>
    <p style="color:darkblue;"><?= cpg_field('appetence_risque', $post_id); ?></p>

    <b>2.&nbsp;&nbsp; <u>Comment qualifieriez-vous vos connaissances en matière financière ?</u></b>
    <p style="color:darkblue;"><?= cpg_field('qualif_connaissances', $post_id); ?></p>

    <b>3.&nbsp;&nbsp; <u>Quels produits financiers connaissez-vous ?</u></b>
    <p style="color:darkblue;"><?= cpg_field('connaissances_prod', $post_id); ?></p>

    <b>4.&nbsp;&nbsp; <u>Parmi ces produits financiers, sur le(s)quel(s) avez-vous d’ores et déjà investis ?</u></b>
    <p style="color:darkblue;"><?= cpg_field('exp_prod', $post_id); ?></p>

    <b>5.&nbsp;&nbsp; <u>Depuis quand possédez-vous des investissements sur des placements financiers ?</u></b>
    <p style="color:darkblue;"><?= cpg_field('duree_invest', $post_id); ?></p>

    <b>6.&nbsp;&nbsp; <u>Réalisez-vous seul des opérations sur vos produits d’investissement ? Ex : PEA – CTO – Assurance-vie en ligne – Trading en ligne – Bitcoin ...</u></b>
    <p style="color:darkblue;"><?= cpg_field('op_seul', $post_id); ?></p>

    <b>7.&nbsp;&nbsp; <u>Avez-vous d’ores et déjà subi des pertes sur les marchés financiers ? (Y compris des pertes temporaires)</u></b>
    <p style="color:darkblue;"><?= cpg_field('pertes_subies', $post_id); ?></p>

    <b>8.&nbsp;&nbsp; <u>De quel niveau étaient ces baisses ?</u></b>
    <p style="color:darkblue;"><?= cpg_field('niveau_baisses', $post_id); ?></p>

    <b>9.&nbsp;&nbsp; <u>Qu’avez-vous fait suite à ces baisses ?</u></b>
    <p style="color:darkblue;"><?= cpg_field('reaction_baisse', $post_id); ?></p>

    <b>10.&nbsp;&nbsp; <u>Êtes-vous convaincu(e) que sur le long terme les valeurs mobilières ont un rendement supérieur aux supports à risque faible ?</u></b>
    <p style="color:darkblue;"><?= cpg_field('immo_vs_support', $post_id); ?></p>

    <b>11.&nbsp;&nbsp; <u>Si l’un de vos placements « long terme » (>10 ans) baisse sur 3 années consécutives que feriez-vous ?</u></b>
    <p style="color:darkblue;"><?= cpg_field('baisse_3_ans', $post_id); ?></p>

    <b>12.&nbsp;&nbsp; <u>Que feriez-vous en cas de crise sur les marchés financiers, avec une baisse supérieure au risque que vous étiez initialement prêt(e) à prendre ?</u></b>
    <p style="color:darkblue;"><?= cpg_field('reaction_crise', $post_id); ?></p>

    <p style="page-break-before:always;"></p>

    <!-- Analyse du conseiller -->

    <b>Analyse du conseiller</b><br><br>
    Suite à l’analyse des réponses fournis ci-avant, le courtier délivre ci-après son appréciation quant aux différentes expériences
et connaissances financières du client.<br><br>

    <table style="border: 2px solid black;margin:8px;padding:8px; border-collapse:collapse;">
        <tr>
            <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;"><b>Connaissances financières</b></td>
            <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;"><b>Expérience en Assurance-vie</b></td>
            <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;"><b>Expérience en unités de compte</b></td>
        </tr>
        <tr>
            <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;color:darkblue;height:50px;">
                <?= cpg_field('connaissances_prod', $post_id); ?>
            </td>
            <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;color:darkblue;">
                <?= cpg_field('exp_assurance_vie', $post_id); ?>
            </td>
            <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;color:darkblue;">
                <?= cpg_field('exp_uc', $post_id); ?>
            </td>
        </tr>
        <tr>
            <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;"><b>Expérience en produits retraite</b></td>
            <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;"><b>Expérience en contrat de capitalisation</b></td>
            <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;"><b>Expérience en investissement sur des supports immobiliers</b></td>
        </tr>
        <tr>
            <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;color:darkblue;height:50px;">
                <?= cpg_field('exp_retraite', $post_id); ?>
            </td>
            <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;color:darkblue;">
                <?= cpg_field('exp_capi', $post_id); ?>
            </td>
            <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;color:darkblue;">
                <?= cpg_field('exp_immo', $post_id); ?>
            </td>
        </tr>
    </table>

    <br><br>

    <table style="border: 2px solid black;margin:8px;padding:8px; border-collapse:collapse;">
        <tr>
            <td style="width:320px;text-align:center;padding:10px;border: 1px solid black;">
                <b>Acceptation maximale du risque pour de l’épargne</b>
            </td>
            <td style="width:320px;text-align:center;padding:10px;border: 1px solid black;">
                <b>Acceptation maximale du risque pour de l’épargne retraite</b>
            </td>
        </tr>
        <tr>
            <td style="width:320px;text-align:center;padding:10px;border: 1px solid black;color:darkblue;">
                <?= cpg_field('srri_epargne', $post_id); ?>
            </td>
            <td style="width:320px;text-align:center;padding:10px;border: 1px solid black;color:darkblue;">
                <?= cpg_field('srri_retraite', $post_id); ?>
            </td>
        </tr>
    </table>

    <br>

    <p style="text-align:justify;">
        Les informations recueillies sur ce formulaire sont enregistrées dans un fichier informatisé par
        <b><?= esc_html($nom_conseiller); ?></b> afin de déterminer votre acceptation à l’exposition aux risques concernant vos investissements en Épargne-Placement et Épargne-Retraite en particulier, et concernant la constitution de votre Patrimoine Mobilier en général.<br>
Elles seront conservées pendant une durée minimale de 5 ans (cinq ans) après la fin de la relation d’affaires. Vos informations seront destinées au(x) personnel(s) de ce cabinet en charge de votre accompagnement ou du suivi des solutions mises en place avec ce(s) dernier(s). Le cas échéant vos informations peuvent être transmises au(x) partenaire(s) de notre cabinet teneur(s) de vos solutions d’investissement.<br><br>

Conformément à la loi « informatique et libertés », vous pouvez exercer votre droit d'accès, d’opposition et de portabilité des
données vous concernant et les faire rectifier en contactant notre cabinet :</p><br><br>
- Soit par mail à : <br>
<p style="text-align:center"><b><?= cpg_field('conseiller_vie', $post_id); ?>></b></p><br>

    - Soit par courrier :<br>
    <p style="text-align:center">
        <b><?= get_field('nom_du_cabinet', $source_id); ?><br><?= get_field('siege_social', $source_id); ?></b>
    </p><br>

    Vous pouvez également introduire une réclamation au sujet du traitement de vos données auprès de la CNIL.

    <p style="page-break-before:always;"></p>








<?php if (in_array('ASSURANCE VIE', $lettres)) : ?>
    <div id="recto" style="text-align:center;vertical-align:middle;">
        <p style="text-align:left; font-size:20px;">
            <b>LETTRE DE MISSION - ASSURANCE VIE</b>
        </p>

        
    <?php
    $lettre_ass_vie_img_id  = (int) get_option('arc_media_lettre_ass_vie_id', 0);
    $lettre_ass_vie_img_url = $lettre_ass_vie_img_id ? wp_get_attachment_image_url($lettre_ass_vie_img_id, 'full') : '';

    if ($lettre_ass_vie_img_url) : ?>
        <img width="85%" src="<?= esc_url($lettre_ass_vie_img_url); ?>">
    <?php endif; ?>

    </div>

    <p style="text-align:center; font-size:20px;">
        <b>LETTRE DE MISSION <br>ASSURANCE-VIE</b>
    </p>

    <b><u>Assuré(e):</u> </b>
    <b style="color:darkblue;">
        <?= cpg_field('civilite', $post_id); ?>
        <?= cpg_field('prenom_client', $post_id); ?>
        <?= cpg_field('nom_client', $post_id); ?>
    </b>
    <br>
    <b><u>Situation familiale:</u></b>
    <b style="color:darkblue;"><?= cpg_field('situation_fam_client', $post_id); ?></b>

    <br><br>

    <b>CADRE DE LA MISSION</b><br><br>
    <div style="text-align:justify;">
        Conformément à nos échanges, et aux informations collectées sur votre situation, nous vous invitons à considérer la solution de l’Assurance vie pour l’investissement que vous envisagez de réaliser. Afin de mieux cerner vos attentes et vos objectifs nous allons préciser ensemble les orientations à évaluer, ainsi que les contours de votre projet.
    </div><br>

    <b>1. <u>Solution d'investissement envisagée:</u></b><br><br>

    Type de versement:<br>
    <div style="color:darkblue;"><?= cpg_field('type_versement_ass_vie', $post_id); ?></div><br>

    <i>Si versements périodiques, précisez la périodicité :</i>
    <div style="color:darkblue;"><?= cpg_field('periodicite_vers_lettre_ass_vie', $post_id); ?></div><br>

    Montant du versement initial:
    <div style="color:darkblue;"><?= cpg_field('vers_initial_ass_vie', $post_id); ?></div><br>

    Montant du versement périodique:
    <div style="color:darkblue;"><?= cpg_field('periodicite_vers_ass_vie', $post_id); ?></div><br>

    <b>2. <u>Concernant cet investissement précis, vous avez comme objectif(s) :</u></b><br><br>
    <div style="color:darkblue;"><?= cpg_field('obj_investissement', $post_id); ?></div><br>

    <b>3. <u>Concernant cet investissement précis, pourriez-vous préciser l’orientation à lui conférer ?</u></b><br><br>
    Merci de préciser l’intitulé qui correspondrait le mieux au risque que vous seriez capable de supporter à priori pour votre
    investissement.   <br>

<div style="text-align:center;">
    <?php
    if ($tab_niveau_img_url) : ?>
        <img width="85%" src="<?= esc_url($tab_niveau_img_url); ?>">
    <?php endif; ?>
</div>


    <br>

    Vous avez sélectionné la réponse :
    <?= cpg_field('orientation_investissement_lettre_ass_vie', $post_id); ?>
    <br><br><br>

    <b>4. <u>Concernant cet investissement précis, précisez l’horizon de temps que vous souhaitez lui consacrer :</u></b><br><br>
    <div style="color:darkblue;"><?= cpg_field('horizon_investissement_lettre_ass_vie', $post_id); ?></div><br>

    <b>5. <u>Concernant cet investissement précis, comment évaluez-vous un retrait anticipé et par conséquent le risque de ne pas respecter l’horizon de temps que vous venez de définir ?</u></b><br><br>
    <div style="color:darkblue;"><?= cpg_field('retrait_anticipe_lettre_ass_vie', $post_id); ?></div><br>

    <b>6. <u>Commentaires (garanties supplémentaires, vigilance particulière ...) :</u></b><br><br>
    <div style="color:darkblue;"><?= cpg_field('coms_lettre_ass_vie', $post_id); ?></div><br><br>

<b>COMPREHENSION DE LA MISSION</b>
<br><br><div style="text-align:justify;">
L'ensemble des informations que vous nous communiquez, vont nous permettre de procéder à l'analyse de votre situation financière et/ou patrimoniale, à l’analyse de vos connaissances et expériences et enfin à la prise en compte de vos objectifs afin d'adapter notre mission de conseil à votre profil et à vos attentes.<br><br>
Votre situation financière patrimoniale, ainsi que vos objectifs, votre connaissance des marchés financiers et votre tolérance aux risques en découlant, sont établis sur la base des informations communiquées par vos soins, figurant dans le document « Questionnaire client - Recueil d’informations » annexé à la présente lettre et qui en fait partie intégrante. Toute modification des informations figurant dans le questionnaire client pouvant affecter significativement la nature ou l'orientation de notre mission devra être portée à notre connaissance ; le « Questionnaire client-Recueil d’information » étant modifiée en conséquence.<br><br>


<b>NOTRE INTERVENTION ET MISSION</b><br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Vous assister dans l’analyse de votre situation.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Vous conseiller sur le profilage de risque concernant votre investissement.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Établir une liste de recommandation(s) et préconisation(s) relative à votre situation.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Étudier et présenter une sélection de contrat(s) d’assurance vie en adéquation avec vos objectifs, vos besoins &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;et votre situation particulière.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Rédiger un rapport d’adéquation entre la ou les solution(s) présentée(s).<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Vous assister dans la préparation des documents nécessaires à la souscription d’une solution et s’assurer de &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;la bonne fin de la souscription du contrat.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Assurer un suivi au minimum une fois par an pour valider que la ou les solution(s) mise(s) en place sont &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;toujours en bonne adéquation avec votre situation personnelle.<br></div>
<p style="page-break-before:always;"></p>
<?php endif; ?>

<?php if (in_array('COMPLÉMENTAIRE RETRAITE', $lettres)) : ?>
<div class="page-block">

    <div id="recto" style="text-align:center;vertical-align:middle;">
        <p style="text-align:left; font-size:20px;">
            <b>LETTRE DE MISSION - COMPLÉMENTAIRE RETRAITE</b>
        </p>

           <?php
    $lettre_retraite_img_id  = (int) get_option('arc_media_lettre_retraite_id', 0);
    $lettre_retraite_img_url = $lettre_retraite_img_id ? wp_get_attachment_image_url($lettre_retraite_img_id, 'full') : '';

    if ($lettre_retraite_img_url) : ?>
        <img width="85%" src="<?= esc_url($lettre_retraite_img_url); ?>">
    <?php endif; ?>
    </div>

    <!-- TITRE -->
    <p style="text-align:center; font-size:20px;">
        <b>LETTRE DE MISSION <br>COMPLÉMENTAIRE RETRAITE</b>
    </p>

    <!-- Informations assurés -->
    <b><u>Assuré(e):</u></b>
    <b style="color:darkblue;">
        <?= cpg_field('civilite', $post_id) ?>
        <?= cpg_field('prenom_client', $post_id) ?>
        <?= cpg_field('nom_client', $post_id) ?>
    </b>
    <br>

    <b><u>Situation familiale :</u></b>
    <b style="color:darkblue;"><?= cpg_field('situation_fam_client', $post_id) ?></b>

    <br><br>

<b>Solution(s) envisagé(e)(s) par vos soins, et objectifs poursuivis en nous sollicitant :</b><br><br>
<div style="text-align:jusitify;">Conformément à nos échanges, vous nous avez communiqué que vous souhaitiez privilégier la solution de l’Assurance vie pour l’investissement considéré. Afin de mieux cerner vos attentes et vos objectifs nous allons préciser ensemble les orientations à considérer, ainsi que les contours de ce nouvel investissement.</div><br>

    <!-- SECTION 1 -->
    <b>1. <u>Solution d'investissement envisagée :</u></b><br><br>

    Enveloppe fiscale :
    <div style="color:darkblue;"><?= cpg_field('env_fiscale_lettre_retraite', $post_id) ?></div><br>

    Type de versement :
    <div style="color:darkblue;"><?= cpg_field('type_vers_lettre_retraite', $post_id) ?></div><br>

    <i>Si versements périodiques… :</i>
    <div style="color:darkblue;"><?= cpg_field('periodicite_vers_lettre_retraite', $post_id) ?></div><br>

    Montant du versement initial :
    <div style="color:darkblue;"><?= cpg_field('vers_initial_retraite', $post_id) ?></div><br>

    Montant du versement périodique :
    <div style="color:darkblue;"><?= cpg_field('periodicite_vers_retraite', $post_id) ?></div><br>


  
    <b>2. <u>Concernant cet investissement précis, vous avez comme objectif(s) de vous constituer :</u></b><br><br>
    <div style="color:darkblue;"><?= cpg_field('montant_souhaite_lettre_retraite', $post_id) ?></div><br>
<p style="page-break-before:always;"></p>

    <b>3. <u>Concernant cet investissement précis, pourriez-vous préciser l’orientation à lui conférer ?</u></b><br>  <br>
Merci de préciser l’intitulé qui correspondrait le mieux au risque que vous seriez capable de supporter à priori pour votre
investissement.   <br>

<div style="text-align:center;">
    <?php
    if ($tab_niveau_img_url) : ?>
        <img width="85%" src="<?= esc_url($tab_niveau_img_url); ?>">
    <?php endif; ?>
</div><br>

    Vous avez sélectionné :
    <?= cpg_field('orientation_investissement_lettre_retraite', $post_id) ?>
    <br><br>

   
    <b>4. <u>Concernant cet investissement précis, précisez l’horizon de temps que vous souhaitez lui consacrer :</u></b><br>  <br>
    <div style="color:darkblue;"><?= cpg_field('horizon_investissement', $post_id) ?></div><br>

<b>5. <u>Concernant cet investissement précis, comment évaluez-vous un retrait anticipé et par conséquent le risque de ne pas respecter l’horizon de temps que vous venez de définir ?</u></b><br> <br>
    <div style="color:darkblue;"><?= cpg_field('retrait_anticipe_lettre_retraite', $post_id) ?></div><br>


<b>6. <u>Évaluation de vos connaissances et expériences personnelles</u></b><br><br>

    <table style="border: 2px solid black;margin:8px;padding:8px;border-collapse:collapse;">
        <tr>
            <td style="width:213px;text-align:center;padding:10px;border:1px solid black;">Connaissances financières</td>
            <td style="width:213px;text-align:center;padding:10px;border:1px solid black;">Expérience produit retraite</td>
            <td style="width:213px;text-align:center;padding:10px;border:1px solid black;">Expérience UC</td>
        </tr>
        <tr>
            <td style="text-align:center;color:darkblue;"><?= cpg_field('connaissances_prod', $post_id); ?></td>
            <td style="text-align:center;color:darkblue;"><?= cpg_field('exp_retraite', $post_id); ?></td>
            <td style="text-align:center;color:darkblue;"><?= cpg_field('exp_uc', $post_id); ?></td>
        </tr>
    </table>

<b>7. <u>Commentaires (garanties supplémentaires, vigilance particulière ...) :</u></b><br><br>

    <div style="color:darkblue;"><?= cpg_field('coms_lettre_retraite', $post_id) ?></div><br>


<b>COMPREHENSION DE LA MISSION</b><br><br><div style="text-align:justify;">
L'ensemble des informations que vous nous communiquez, vont nous permettre de procéder à l'analyse de votre situation financière et/ou patrimoniale, à l’analyse de vos connaissances et expériences et enfin à la prise en compte de vos objectifs afin d'adapter notre mission de conseil à votre profil et à vos attentes.<br><br>
Votre situation financière patrimoniale, ainsi que vos objectifs, votre connaissance des marchés financiers et votre tolérance aux risques en découlant, sont établis sur la base des informations communiquées par vos soins, figurant dans le document « Questionnaire client - Recueil d’informations » annexé à la présente lettre et qui en fait partie intégrante. Toute modification des informations figurant dans le questionnaire client pouvant affecter significativement la nature ou l'orientation de notre mission devra être portée à notre connaissance ; le « Questionnaire client-Recueil d’information » étant modifiée en conséquence.<br><br>
<b>NOTRE INTERVENTION ET MISSION</b><br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Vous assister dans l’analyse de votre situation.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Vous conseiller sur le profilage de risque concernant votre investissement.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Établir une liste de recommandation(s) et préconisation(s) relative à votre situation.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Étudier et présenter une sélection de contrat(s) d’assurance vie en adéquation avec vos objectifs, vos besoins &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;et votre situation particulière.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Rédiger un rapport d’adéquation entre la ou les solution(s) présentée(s).<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Vous assister dans la préparation des documents nécessaires à la souscription d’une solution et s’assurer de &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;la bonne fin de la souscription du contrat.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Assurer un suivi au minimum une fois par an pour valider que la ou les solution(s) mise(s) en place sont &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;toujours en bonne adéquation avec votre situation personnelle.<br>
</div>

</div>
<p style="page-break-before:always;"></p>
<?php endif; ?>

<?php if (in_array('PRÉVOYANCE', $lettres)) : ?>
<div class="page-block">


    <div id="recto" style="text-align:center;vertical-align:middle;">
        <p style="text-align:left; font-size:20px;">
            <b>MANDAT DE COURTAGE - PRÉVOYANCE</b>
        </p>

            <?php
    $lettre_prev_img_id  = (int) get_option('arc_media_lettre_prev_id', 0);
    $lettre_prev_img_url = $lettre_prev_img_id ? wp_get_attachment_image_url($lettre_prev_img_id, 'full') : '';

    if ($lettre_prev_img_url) : ?>
        <img width="85%" src="<?= esc_url($lettre_prev_img_url); ?>">
    <?php endif; ?>
    </div>

    <!-- TITRE -->
    <p style="text-align:center; font-size:20px;">
        <b>MANDAT DE COURTAGE <br>ASSURANCE PRÉVOYANCE</b>
    </p>

    <!-- TABLEAU 1 : ASSURÉ -->
    <table style="vertical-align: middle;border:0.5px solid black;border-collapse:collapse;">

        <tr>
            <th style="border:0.5px solid black;height:45px;width:640px;background-color:lightgrey;font-size:18px;">
                <b>ASSURÉ(E)</b>
            </th>
        </tr>

        <tr>
            <td style="border:0.5px solid black;height:35px;width:640px;">
                &nbsp;&nbsp;&nbsp;&nbsp;<u>Dirigeant :</u>
                <b style="color:darkblue;">
                    <?= cpg_field('civilite', $post_id) ?>
                    <?= cpg_field('prenom_client', $post_id) ?>
                    <?= cpg_field('nom_client', $post_id) ?>
                </b>
            </td>
        </tr>

        <tr>
            <td style="border:0.5px solid black;height:35px;width:640px;">
                &nbsp;&nbsp;&nbsp;&nbsp;<u>Situation familiale :</u>
                <b style="color:darkblue;"><?= cpg_field('situation_fam_client', $post_id) ?></b>
            </td>
        </tr>

        <tr>
            <th style="border:0.5px solid black;height:45px;background-color:lightgrey;font-size:18px;width:640px;">
                <b>CADRE DE LA MISSION</b>
            </th>
        </tr>

        <tr>
            <td style="border:0.5px solid black;height:70px;width:640px;">
                &nbsp;&nbsp;&nbsp;&nbsp;Vous souhaitez vous protéger dans le(s) domaine(s) suivant(s) :
                <br>&nbsp;&nbsp;&nbsp;&nbsp;<b style="color:darkblue;">
                    <?= cpg_field('couverture_prev', $post_id) ?>
                </b>
            </td>
        </tr>

        <tr>
            <td style="border:0.5px solid black;height:70px;width:640px;">
                &nbsp;&nbsp;&nbsp;&nbsp;Vous avez comme objectif(s) :
                <br>&nbsp;&nbsp;&nbsp;&nbsp;<b style="color:darkblue;">
                    <?= cpg_field('obj_couverture_prev', $post_id) ?>
                </b>
            </td>
        </tr>

        <tr>
            <th style="border:0.5px solid black;height:45px;background-color:lightgrey;font-size:18px;width:640px;">
                <b>ETUDE DE VOTRE DOSSIER</b>
            </th>
        </tr>

        <tr>
            <td style="border:0.5px solid black;height:60px;text-align:center;width:640px;">
                <b>Domaines envisagés pour l'étude de votre dossier</b><br>
            </td>
        </tr>

    </table>

    <!-- TABLEAU 2 : PRÉVOYANCE PRO / FAMILLE -->
    <table style="vertical-align: middle;border:0.5px solid black;border-collapse:collapse;">
        <tr>
            <td style="border-right:0.5px solid black;height:35px;width:320px;text-align:center;">
                <b><u>Prévoyance professionnelle</u></b>
            </td>

            <td style="height:45px;width:320px;text-align:center;">
                <b><u>Prévoyance individuelle famille</u></b>
            </td>
        </tr>

        <tr>
            <td style="border:0.5px solid black;height:120px;text-align:center;color:darkblue;">
                <?= cpg_field('garanties_prev_pro', $post_id) ?>
            </td>

            <td style="border:0.5px solid black;height:120px;text-align:center;color:darkblue;">
                <?= cpg_field('garanties_prev_perso', $post_id) ?>
            </td>
        </tr>
    </table>

    <!-- TABLEAU 3 : COMMENTAIRES -->
    <table style="vertical-align: middle;border:0.5px solid black;border-collapse:collapse;">
        <tr>
            <td style="border:0.5px solid black;height:55px;width:640px;">
                <b>Commentaires supplémentaires :</b>
                <b style="color:darkblue;">
                    <?= cpg_field('coms_lettre_prevoyance', $post_id) ?>
                </b>
            </td>
        </tr>
    </table>

    <!-- ESPACE (page break simulé) -->
    <br><br><br><br><br><br><br><br><br><br><br><br>

</div>
<p style="page-break-before:always;"></p>
<?php endif; ?>

<?php if (in_array('SANTÉ', $lettres)) : ?>
<div class="page-block">

    <div id="recto" style="text-align:center;vertical-align:middle;">
        <p style="text-align:left; font-size:20px;">
            <b>MANDAT DE COURTAGE - COMPLÉMENTAIRE SANTÉ</b>
        </p>

    <?php
    $lettre_mut_img_id  = (int) get_option('arc_media_lettre_mut_id', 0);
    $lettre_mut_img_url = $lettre_mut_img_id ? wp_get_attachment_image_url($lettre_mut_img_id, 'full') : '';

    if ($lettre_mut_img_url) : ?>
        <img width="85%" src="<?= esc_url($lettre_mut_img_url); ?>">
    <?php endif; ?>
    </div>

    <!-- TITRE PRINCIPAL -->
    <p style="text-align:center; font-size:20px;">
        <b>MANDAT DE COURTAGE <br>COMPLÉMENTAIRE SANTÉ</b>
    </p>

    <!-- ASSURÉ PRINCIPAL -->
    <table style="vertical-align: middle;border:0.5px solid black;border-collapse:collapse;">
        <tr>
            <th style="border:0.5px solid black;width:640px;height:45px;background-color:lightgrey;font-size:18px;">
                <b>ASSURÉ PRINCIPAL</b>
            </th>
        </tr>

        <tr>
            <td style="border:0.5px solid black;height:45px;width:640px;">
                &nbsp;&nbsp;&nbsp;&nbsp;<u>Assuré(e):</u>
                <b style="color:darkblue;">
                    <?= cpg_field('civilite', $post_id) ?>
                    <?= cpg_field('prenom_client', $post_id) ?>
                    <?= cpg_field('nom_client', $post_id) ?>
                </b>
            </td>
        </tr>

        <tr>
            <td style="border:0.5px solid black;height:45px;width:640px;">
                &nbsp;&nbsp;&nbsp;&nbsp;<u>Adresse:</u>
                <b style="color:darkblue;">
                    <?= cpg_field('adresse', $post_id) ?>,
                    <?= cpg_field('ville', $post_id) ?>,
                    <?= cpg_field('cp', $post_id) ?>
                </b>
            </td>
        </tr>
    </table>

    <table style="vertical-align: middle;border:0.5px solid black;border-collapse:collapse;">
        <tr>
            <td style="border-right:0.5px solid black;height:45px;width:320px;">
                &nbsp;&nbsp;&nbsp;&nbsp;<u>Mail:</u>
                <b style="color:darkblue;"><?= cpg_field('mail', $post_id) ?></b>
            </td>

            <td style="border:0.5px solid black;height:45px;width:320px;">
                &nbsp;&nbsp;&nbsp;&nbsp;<u>Mobile:</u>
                <b style="color:darkblue;"><?= cpg_field('tel', $post_id) ?></b>
            </td>
        </tr>
    </table>

    <table style="vertical-align: middle;border:0.5px solid black;border-collapse:collapse;width:640px;">
        <tr>
            <td style="border-right:0.5px solid black;height:45px;">
                &nbsp;&nbsp;&nbsp;&nbsp;<u>Date de naissance:</u>
                <b style="color:darkblue;"><?= cpg_field('date_naissance_client', $post_id) ?></b>
            </td>
        </tr>

        <tr>
            <th style="border:0.5px solid black;height:45px;background-color:lightgrey;font-size:18px;width:640px;">
                <b>CONJOINT(E) DE L'ASSURÉ</b>
            </th>
        </tr>

        <tr>
            <td style="border:0.5px solid black;height:45px;width:640px;">
                &nbsp;&nbsp;&nbsp;&nbsp;<u>Conjoint(e):</u>
                <b style="color:darkblue;">
                    <?= cpg_field('civilite_conjoint', $post_id) ?>
                    <?= cpg_field('prenom_conjoint', $post_id) ?>
                    <?= cpg_field('nom_conjoint', $post_id) ?>
                </b>
            </td>
        </tr>

        <tr>
            <td style="border:0.5px solid black;height:45px;width:640px;">
                &nbsp;&nbsp;&nbsp;&nbsp;<u>Date de naissance:</u>
                <b style="color:darkblue;"><?= cpg_field('date_naissance_conjoint', $post_id) ?></b>
            </td>
        </tr>

        <tr>
            <th style="border:0.5px solid black;height:45px;background-color:lightgrey;font-size:18px;width:640px;">
                <b>ENFANTS AYANTS DROITS</b>
            </th>
        </tr>
    </table>

    <!-- ENFANTS -->
    <table style="vertical-align: middle;border:0.5px solid black;border-collapse:collapse;">

        <?php for ($i = 1; $i <= 6; $i++) : ?>
        <?php
            $prenom = cpg_field("prenom_enfant_$i", $post_id);
            $nom = cpg_field("nom_enfant_$i", $post_id);
            $date = cpg_field("date_naissance_enfant_$i", $post_id);

            if (!$prenom && !$nom && !$date) continue;
        ?>
        <?php if ($i % 2 == 1) : ?><tr><?php endif; ?>

            <td style="border:0.5px solid black;height:45px;width:320px;">
                &nbsp;&nbsp;&nbsp;&nbsp;<u>Enfant <?= $i ?>:</u>
                <b style="color:darkblue;"><?= $prenom ?> <?= $nom ?> (<?= $date ?>)</b>
            </td>

        <?php if ($i % 2 == 0) : ?></tr><?php endif; ?>

        <?php endfor; ?>
    </table>

    <!-- DESCRIPTION GARANTIES -->
    <table style="vertical-align: middle;border:0.5px solid black;border-collapse:collapse;">
        <tr>
            <th style="border:0.5px solid black;height:45px;background-color:lightgrey;font-size:18px;width:640px;">
                <b>DESCRIPTION DU NIVEAU DES GARANTIES ET OPTIONS SOUHAITÉES</b>
            </th>
        </tr>
    </table>

    <table style="vertical-align: middle;border:0.5px solid black;border-collapse:collapse;text-align:center;">
        <tr>
            <td style="border:0.5px solid black;height:45px;width:160px;">Plafond dentaire</td>
            <td style="border:0.5px solid black;height:45px;width:160px;">Plafond optique</td>
            <td style="border:0.5px solid black;height:45px;width:160px;">Besoin appareillage</td>
            <td style="border:0.5px solid black;height:45px;width:160px;">Médecines douces</td>
        </tr>

        <tr>
            <td style="width:160px;border:0.5px solid black;height:45px;"><b style="color:darkblue;"><?= cpg_field('plafond_dentaire', $post_id) ?></b></td>
            <td style="width:160px;border:0.5px solid black;height:45px;"><b style="color:darkblue;"><?= cpg_field('plafond_optique', $post_id) ?></b></td>
            <td style="width:160px;border:0.5px solid black;height:45px;"><b style="color:darkblue;"><?= cpg_field('appareillage', $post_id) ?></b></td>
            <td style="width:160px;border:0.5px solid black;height:45px;"><b style="color:darkblue;"><?= cpg_field('plafond_med_douce', $post_id) ?></b></td>
        </tr>
    </table>

    <!-- EXIGENCES MINIMALES -->
    <table style="vertical-align: middle;border:0.5px solid black;border-collapse:collapse;">
        <tr>
            <th style="border:0.5px solid black;height:45px;background-color:lightgrey;width:640px;">
                <b>Exigences minimales des garanties souhaitées par le futur assuré. Montants exprimés en Base de remboursement de la sécurité sociale (BR), ou en euro.</b>
            </th>
        </tr>
    </table>

    <table style="vertical-align: middle;border:0.5px solid black;border-collapse:collapse;text-align:center;">
        <tr>
            <td style="width:213px;border:0.5px solid black;height:45px;">Besoins basiques</td>
            <td style="width:213px;border:0.5px solid black;height:45px;">Besoins confort</td>
            <td style="width:213px;border:0.5px solid black;height:45px;">Besoins étendus</td>
        </tr>

        <tr>
            <td style="width:213px;border:0.5px solid black;height:90px;color:darkblue;"><?= cpg_field('garanties_basiques', $post_id) ?></td>
            <td style="width:213px;border:0.5px solid black;height:90px;color:darkblue;"><?= cpg_field('garanties_confort', $post_id) ?></td>
            <td style="width:213px;border:0.5px solid black;height:90px;color:darkblue;"><?= cpg_field('garanties_etendues', $post_id) ?></td>
        </tr>
    </table>

    <!-- COMMENTAIRES -->
    <table style="vertical-align: middle;border:0.5px solid black;border-collapse:collapse;">
        <tr>
            <td style="border:0.5px solid black;height:55px;width:640px;">
                <b>Commentaires supplémentaires :</b>
                <b style="color:darkblue;"><?= cpg_field('coms_lettre_prev', $post_id) ?></b>
            </td>
        </tr>
    </table>

</div>
<p style="page-break-before:always;"></p>
<?php endif; ?>



<?php if (in_array('ASSURANCE VIE', $rapports)) : ?>
<!-- ============================= -->
<!-- RAV-1 : PAGE DE GARDE + DÉFINITION -->
<!-- ============================= -->

    <div id="recto" style="text-align:center;vertical-align:middle;">
        <p style="text-align:left; font-size:20px;">
            <b>RAPPORT DE MISSION - ASSURANCE VIE</b>
        </p>

    <?php
    $rapport_retraite_img_id  = (int) get_option('arc_media_rapport_retraite_id', 0);
    $rapport_retraite_img_url = $rapport_retraite_img_id ? wp_get_attachment_image_url($rapport_retraite_img_id, 'full') : '';

    if ($rapport_retraite_img_url) : ?>
        <img width="85%" src="<?= esc_url($rapport_retraite_img_url); ?>">
    <?php endif; ?>
    </div>

<p style="text-align:center; font-size:20px;">
    <b>RAPPORT DE MISSION <br>ASSURANCE VIE</b>
</p>

<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>DEFINITION «ASSURANCE-VIE»</b>
</p>

<div style="text-align:justify">


<b>1. <u>Qu’est-ce que l’« Assurance-vie » ?</u></b><br><br>
Nous tenons à vous formuler, ce à quoi correspond un contrat d’« Assurance-vie » et les garanties généralement qui lui sont associées.<br><br>
D’après l’institution <i>Assurance Banque Epargne Info Service</i>, site d’information public qui a pour but de protéger les clients dans ces secteurs d’activités, « Un contrat d’assurance vie permet au souscripteur ou à l’adhérent de se constituer une épargne ou de transmettre à son décès un capital à des personnes qu’il aura choisies, « les bénéficiaires ». Pour constituer cette épargne ou ce capital, le souscripteur/adhérent verse des primes à l’assureur. Ces primes sont investies sur des supports financiers (fonds en euros ou unités de compte) en fonction des objectifs d’investissement et des besoins exprimés par le client.<br><br>
Le contrat d’assurance vie prend fin :<br><br>
<b>• en cas de vie du souscripteur ou de l’adhérent :<br>
• soit au terme du contrat si celui-ci a été conclu pour une durée déterminée ;<br>
• soit en cas de rachat total du contrat ;<br>
• en cas de décès du souscripteur ou de l’adhérent : la valeur du contrat sera alors versée au(x) bénéficiaire(s) désigné(s) sous la forme de capitaux décès.</b><br><br>
</div>


<!-- - - - - - - - - - - - - - - - - -->
<div style="text-align:justify;">
<b>2. <u>Quelles sont les personnes intéressées au contrat d’assurance-vie ?</u></b><br><br>
Différentes personnes peuvent intervenir dans le cadre du contrat d’assurance vie :<br><br>
• <b>Le souscripteur du contrat ou l’adhérent au contrat :</b> le souscripteur est la personne, physique ou morale, qui conclut le contrat avec l’assureur.<br>
• <i>Dans les contrats dits « individuels »</i> : Le souscripteur est en principe celui qui verse la ou les primes sur le contrat et généralement l’assuré. Le souscripteur dispose de droits personnels tels que de désigner le(s) bénéficiaire(s), modifier la clause bénéficiaire, procéder à des rachats, des arbitrages ou demander des avances.<br>
• <i>Dans les contrats collectifs ou de groupe</i> : Le souscripteur est une personne morale ou un chef d’entreprise qui conclut un contrat au nom d’adhérents. L'adhérent dispose de droits personnels tels que de désigner le(s) bénéficiaire(s), modifier la clause bénéficiaire, procéder à des rachats, des arbitrages ou demander des avances.<br><br>
A noter : pour certains contrats collectifs, la possibilité de procéder à des rachats est limitée (ex : contrats de retraite)<br><br>
• <b>L’assuré</b> : l’assuré est la personne sur la tête de laquelle repose le risque de décès ou de survie. Le souscripteur/adhérent et l’assuré sont souvent la même personne.<br>
• <b>L’assureur</b> : l’assureur est l’organisme auprès duquel le contrat est conclu. Il devra au terme du contrat, en cas de rachat ou au décès du souscripteur/adhérent verser le capital ou la rente. L’organisme peut être une société d’assurance, une mutuelle ou une institution de prévoyance. Il doit être agréé par l’Autorité de contrôle prudentiel et de résolution (ACPR) ou autorisé à exercer son activité en France (pour les organismes d’assurance européens). Pour savoir si un organisme d'assurance est autorisé à exercer son activité en France, vous pouvez consulter le registre des organismes d'assurance.<br>
• <b>Le bénéficiaire</b> : le bénéficiaire d’un contrat d’assurance vie est la (ou les) personne(s) désignée(s) par le souscripteur/adhérent pour recevoir le capital ou la rente. La clause bénéficiaire d’un contrat d’assurance vie est rédigée par le souscripteur/adhérent. Il s’agit d’un acte important auquel il convient d’apporter une attention particulière.<br><br>
<b>3. <u>Quelle est l’obligation de conseil de l’assureur ou de son intermédiaire avant la souscription d’un contrat d’assurance vie ?</u></b><br><br>
Toute personne qui se voit proposer un contrat d’assurance vie a le droit d’être conseillée avant la souscription du contrat. L’assureur ou l’intermédiaire d'assurance doit vous questionner pour connaître vos exigences, vos besoins, votre situation financière, vos objectifs de souscription ainsi que vos connaissances et votre expérience en matière financière.<br><br>
Ce recueil d’informations par le professionnel est effectué dans votre intérêt. Il est destiné à vous délivrer un conseil adapté à votre situation et à la complexité du contrat proposé. Il est donc important de répondre à ces questions de façon complète et sincère. Ce conseil doit permettre de vous orienter au mieux de vos intérêts, non seulement sur le choix du contrat d’assurance vie mais aussi sur les supports financiers sur lesquels les primes versées seront investies. Au titre de son obligation d’information, le professionnel doit également vous remettre différents documents.<br><br>

<b>4. <u>Quels documents l’assureur ou l’intermédiaire d’assurance doit-il me remettre avant la souscription d’un contrat d’assurance vie ?</u></b><br><br>
Afin de vous permettre de vous décider en toute connaissance de cause, l’assureur ou l’intermédiaire d’assurance doit vous remettre avant la souscription du contrat plusieurs documents :<br><br>
• <b>Le Document d’Information Clé (DIC) du contrat et les documents d’information clé spécifiques à chaque support financier ou option d’investissement </b>: Depuis le 1er janvier 2018, l’assureur ou l’intermédiaire d’assurance doit remettre suffisamment tôt aux clients non professionnels un Document d’Information Clé (DIC) pour le contrat d’assurance vie ainsi que pour chacun des supports financiers (fonds euros, unité de compte) ou chacune des options d’investissement proposés. Le DIC est un document standardisé.<br><br>

• Il doit être court et doit notamment vous permettre de comprendre :<br>
&nbsp;&nbsp;&nbsp;• les caractéristiques et objectifs du contrat d’assurance vie et des supports financiers (Partie « En quoi consiste ce produit ? ») ;<br>
&nbsp;&nbsp;&nbsp;• les risques, gains potentiels ou pertes que pouvez avoir à supporter (Partie « Quels sont les risques et qu’est-ce que cela pourrait
me rapporter ») ;<br>
&nbsp;&nbsp;&nbsp;• les coûts ou frais liés au contrat d’assurance vie et aux supports financiers (Partie « Que va me coûter cet investissement ?).
• Il peut également vous permettre de comparer les différentes offres proposées.<br><br>

• <b>Informations sur les exigences et les besoins du client et la motivation du conseil fourni</b> : Avant la conclusion du contrat, le professionnel doit vous transmettre sur un support papier ou tout support durable un document reprenant les exigences et les besoins que vous aurez exprimés ainsi que les raisons qui l’ont conduit à vous conseiller un contrat en particulier.<br><br>
À noter : en cas de commercialisation par téléphone, ces informations sont transmises au souscripteur sur support papier ou tout
support durable dans les plus brefs délais suivant la conclusion du contrat.<br><br>
• <b>Les documents d’informations précontractuelle </b>: Avant la conclusion du contrat d’assurance vie, l’assureur doit en outre obligatoirement
vous remettre :<br>
• Une note d’information (pour les contrats individuels) ou notice d’information (pour les contrats collectifs) précisant les dispositions essentielles du contrat et les conditions d’exercice de la faculté de renonciation ;<br>
• Une proposition d’assurance / contrat comprenant notamment un modèle de lettre destiné à faciliter l'exercice de la faculté de renonciation.<br><br>

L’assureur peut toutefois remettre au souscripteur, un seul document regroupant la proposition d’assurance/contrat et la note d’information, si ce document unique comprend un encadré indiquant, en caractère très apparents, la nature du contrat et précisant ses caractéristiques essentielles (garanties, frais...).<br><br>
</div>


<!-- - - - - - - - - - - - - - - - - -->
<div style="text-align:justify;">
<b>5. <u>Quels supports financiers peuvent être proposés dans un contrat d’assurance vie ?</u></b><br><br>
Les supports financiers qui peuvent être proposés dans un contrat d’assurance vie appartiennent à des catégories différentes qui présentent des risques financiers plus ou moins importants. Ces supports peuvent être répartis en 3 grandes catégories :<br><br>
• <b>Le fond en euros </b>: Le fonds en euros est un support financier constitué d’actifs libellés en euros (obligations, placements immobiliers..) présentant peu de risques en contrepartie d’un rendement très faible. Les primes versées après application des frais prévus par le contrat sont valorisées par des intérêts capitalisés au fur et à mesure. Les modalités de calcul des intérêts et d’attribution d’une éventuelle participation aux bénéfices doivent être prévues par le contrat.<br><br>

• <b>Les unités de compte </b>Les montants investis sur les supports en unités de compte ne sont pas garantis. L’assureur s’engage uniquement à garantir le nombre d’unités de compte mais pas la valeur de chaque unité qui peut fluctuer à la hausse comme à la baisse. Ces supports présentent donc un risque de perte en capital pour le souscripteur / adhérent et soumis à des frais spécifiques. Ce risque varie selon la nature de l’unité de compte. Ces unités de compte peuvent être :<br><br>
• Des actions<br>
• Des obligations<br>
• Des parts d’Organismes de Placement Collectif (OPC) : SICAV ou FCP<br>
• Des parts de placements immobiliers : SCPI<br>
• Des instruments financiers complexes (fonds structurés, fonds à formule...) : Il s’agit d’unités de compte composées d’instruments financiers inhabituels ou dont la performance repose sur des indices évoluant selon des mécanismes complexes, à savoir :<br>
&nbsp;&nbsp;&nbsp;• Des OPCVM de droit français dit « à formule » ;<br>
&nbsp;&nbsp;&nbsp;• Des OPCVM structurés de droit étranger équivalents ;<br>
&nbsp;&nbsp;&nbsp;• Des titres de créance complexes et de titres financiers équivalents émis sur le fondement de droits étrangers<br><br>

Ces produits complexes peuvent être notamment appelés « fonds structurés », « fonds à formule ». Les sommes investies sur ce type de fonds sont en principe « immobilisées » pendant une durée déterminée. Attention : Il s’agit de produits difficilement compréhensibles par les investisseurs non professionnels et qui présentent un risque de perte financière élevé.<br><br>

• Le fonds euro-croissance : Il s’agit d’un support donnant lieu à la constitution « d'une provision de diversification » qui permet de participer au financement de l’économie. Il bénéficie d’une garantie en capital à l’échéance fixée par le contrat. Cette échéance ne peut être inférieure à 8 ans mais peut être plus longue; L’objectif du fonds euro-croissance est de procurer sur le long terme un rendement supérieur aux fonds en euros. Attention : les fonds intitulés « croissance » n’offrent qu’une garantie partielle en capital à l’échéance.<br><br>

<b>6. <u>Quels frais peuvent être appliqués à mon contrat d’assurance vie ?</u></b><br><br>
Dans le cadre d’un contrat d’assurance vie, les frais suivants peuvent vous être facturés :<br><br>
• <b>Les frais de dossier </b>: Il s’agit de frais fixe payables une seule fois lors de la souscription du contrat. Tous les contrats d’assurance vie ne prévoient pas ce type de frais.<br>
• <b>Les frais à l’entrée et sur versement </b>: Ces frais sont facturés à chaque versement effectués sur le contrat (versement effectué à la souscription/adhésion ainsi qu’aux versements suivants). Ils sont en principe exprimés en pourcentage du versement.<br>
• <b>Les frais de gestion sur encours </b>: Il s’agit de frais prélevés sur l’épargne constituée. Ils sont exprimés en pourcentage de cette épargne. Ils s’appliquent tant sur le fonds en euros que sur les unités de compte ou le fonds euro-croissance. Attention : Les supports financiers en unités de compte proposées dans le contrat d’assurance vie sont soumis à des frais de gestion supplémentaire qui doivent être mentionnés dans le DIC.<br>
• <b>Les frais d'arbitrage </b>: Ces frais peuvent être exprimés en pourcentage de la somme arbitrée ou faire l’objet d’un forfait. Ils sont facturés au souscripteur/adhérent quand il effectue un arbitrage entre les différents supports financiers de son contrat.<br>
• <b>Les autres frais :<br>
&nbsp;&nbsp;&nbsp;• Frais de transfert prélevés à l'occasion de la transformation d'un contrat en euros en un contrat multi-support ;<br>
&nbsp;&nbsp;&nbsp;• Frais prélevés sur les avances ;<br>
&nbsp;&nbsp;&nbsp;• Frais de mise en service de rachats partiels programmés. »   </b><br><br>
</div>


    <div style="text-align:center;">
    <?php
    $tab_gris_img_id  = (int) get_option('arc_media_tab_gris_id', 0);
    $tab_gris_img_url = $tab_gris_img_id ? wp_get_attachment_image_url($tab_gris_img_id, 'full') : '';

    if ($tab_gris_img_url) : ?>
        <img width="85%" src="<?= esc_url($tab_gris_img_url); ?>">
    <?php endif; ?>
    </div>


<p style="page-break-before:always;"></p>




<!-- ======================= -->
<!-- VOTRE SITUATION PATRIMOINE -->
<!-- ======================= -->

<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>VOTRE SITUATION PATRIMONIALE</b>
</p>

Vos informations patrimoniales inscrites ci-dessous sont enregistrées à la date du
<b><?= cpg_field('date_du_jour', $post_id); ?></b>.
<br><br>

    <table style="border: 2px solid black;margin:8px;padding:8px;">


<tr style="background-color:lightgrey"> <th style="width:320px;text-align:center;padding:10px;">Vos informations personnelles</th> <th style="width:320px;text-align:center;padding:10px;">Informations personnelles de votre conjoint(e)</th> </tr>
<tr> <td>Civilité: <b><?= cpg_field('civilite', $post_id); ?></b></td> <td>Civilité: <b><?= cpg_field('civilite_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Prénom: <b><?= cpg_field('prenom_client', $post_id); ?></b></td> <td>Prénom: <b><?= cpg_field('prenom_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Nom: <b><?= cpg_field('nom_client', $post_id); ?></b></td> <td>Nom: <b><?= cpg_field('nom_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Date et lieu de naissance: <b><?= cpg_field('date_naissance_client', $post_id); ?></b> à <b><?= cpg_field('lieu_naissance_client', $post_id); ?></b></td> <td>Date et lieu de naissance: <b><?= cpg_field('date_naissance_conjoint', $post_id); ?></b> à <b><?= cpg_field('lieu_naissance_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Profession: <b><?= cpg_field('profession_client', $post_id); ?></b></td> <td>Profession: <b><?= cpg_field('profession_conjoint', $post_id); ?></b></td> </tr>
<tr> <th style="text-align:left; padding:10px;background-color:lightgrey">Votre situation familiale / patrimoniale</th> </tr>
<tr> <td>Situation familiale: <b><?= cpg_field('situation_fam_client', $post_id); ?></b></td> </tr>
<tr> <td>Personne(s) à charge: <b><?= cpg_field('charge_client', $post_id); ?></b></td> </tr>
<tr> <td>Statut patrimonial: <b><?= cpg_field('statut_pat_client', $post_id); ?></b></td> </tr>
</table>

<br>

<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>NOS PRÉCONISATIONS</b>
</p>

Suite aux informations que vous nous avez fourni quant à vos exigences et à vos besoins dans le mandat, vous trouverez ci-dessous l’étude et les préconisations réalisées par le cabinet <b><?= get_field('nom_du_cabinet', $source_id); ?></b>.
<br><br>

<b><i><u>Nombre de compagnies d'assurances comparées :</u></i></b>
&nbsp;<b style="color:darkblue;"><?= cpg_field('nb_cie_rap_ass_vie', $post_id); ?></b><br>

<b><i><u>Nombre de devis effectués :</u></i></b>
&nbsp;<b style="color:darkblue;"><?= cpg_field('nb_simulation_rap_ass_vie', $post_id); ?></b><br>

<b><i><u>Montant du versement initial :</u></i></b>
&nbsp;<b style="color:darkblue;"><?= cpg_field('vers_initial_rap_ass_vie', $post_id); ?></b><br>

<b><i><u>Montant du versement périodique :</u></i></b>
&nbsp;<b style="color:darkblue;"><?= cpg_field('vers_period_rap_ass_vie', $post_id); ?></b><br>

<b><i><u>Origine des fonds :</u></i></b>
&nbsp;<b style="color:darkblue;"><?= cpg_field('origine_fonds_rap_ass_vie', $post_id); ?></b><br><br>


<b><u>Résultats des études lors de notre mission :</u></b>
<br><br>

<table style="border: 0.5px solid black; border-collapse: collapse; text-align:center;">

<tr>
    <td style="width:320px;border: 0.5px solid black;height:30px;"></td>
    <td style="width:320px;border: 0.5px solid black;height:30px;vertical-align: middle;"><b>Nom du contrat</b></td>
</tr>

<tr>
    <td style="border: 0.5px solid black;height:30px;"><b>Contrat n°1</b></td>
    <td style="border: 0.5px solid black;height:30px;"><?= cpg_field('contrat_1_rap_ass_vie', $post_id); ?></td>
</tr>

<tr>
    <td style="border: 0.5px solid black;height:30px;"><b>Contrat n°2</b></td>
    <td style="border: 0.5px solid black;height:30px;"><?= cpg_field('contrat_2_rap_ass_vie', $post_id); ?></td>
</tr>

<tr>
    <td style="border: 0.5px solid black;height:30px;"><b>Contrat n°3</b></td>
    <td style="border: 0.5px solid black;height:30px;"><?= cpg_field('contrat_3_rap_ass_vie', $post_id); ?></td>
</tr>

<tr>
    <td style="border: 0.5px solid black;height:30px;"><b>Contrat n°4</b></td>
    <td style="border: 0.5px solid black;height:30px;"><?= cpg_field('contrat_4_rap_ass_vie', $post_id); ?></td>
</tr>

</table>

<br>

Parmi les différents contrats proposés, voici ce que nous avons retenu (PU) :
<b style="color:darkblue;"><?= cpg_field('contrat_retenu_pu_rap_ass_vie', $post_id); ?></b><br>

Parmi les différents contrats proposés, voici ce que nous avons retenu (VERREG) :
<b style="color:darkblue;"><?= cpg_field('contrat_retenu_verreg_rap_ass_vie', $post_id); ?></b><br><br>
<p style="page-break-before:always;"></p>

<br><br><br><br>

<b><u>Avantages et inconvénients liés au produit :</u></b>
<br><br>

<table style="border: 0.5px solid black; border-collapse: collapse; text-align:center;">

<tr>
    <td style="width:320px;border: 0.5px solid black;"><b><u>Avantages</u></b></td>
    <td style="width:320px;border: 0.5px solid black;"><b><u>Inconvénients</u></b></td>
</tr>

<tr>
    <td style="border: 0.5px solid black;height:100px;color:darkblue;">
        <?= cpg_field('avantages_rap_ass_vie', $post_id); ?>
    </td>
    <td style="border: 0.5px solid black;height:100px;color:darkblue;">
        <?= cpg_field('limites_rap_ass_vie', $post_id); ?>
    </td>
</tr>

</table>

<b><u>Unités de compte présente dans votre allocation (tableau)</u></b><br><br>

<table style="border: 0.5px solid black;  border-collapse: collapse; text-align:center;">

<tr> <td style="width:160px;border: 0.5px solid black;height:30px;"><b><u>Unité de compte</u></b></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><u>Présence dans votre allocation</u></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><b><u>Horizon de temps*</u></b></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><u>Degré de risque**</u></b></td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">Titre vifs</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('titres_alloc_rap_ass_vie', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ff0000;">+++++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">Produits structurés</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('prod_rap_ass_vie', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ff0000;">+++++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">ETF</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('etf_rap_ass_vie', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ff0000;">+++++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">FIA (Fonds Investissements Alternatifs)</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('fia_rap_ass_vie', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ff0000;">+++++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">UC Actions</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('uca_rap_ass_vie', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ff4b4b;">++++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">UC Obligations</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('ucob_rap_ass_vie', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Moyen/Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ed7d31;">+++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">UC Diversifiées</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('uc_divers_rap_ass_vie', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Moyen/Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ed7d31;">+++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">OPCI (Organisme de Placement Collectif en Immobilier)</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('opci_rap_ass_vie', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Moyen terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ed7d31;">+++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">SCPI (Société Civile de Placement Immobilier)</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('scpi_rap_ass_vie', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Moyen/Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ffc000;">++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">Fonds €</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('fonds_rap_ass_vie', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Court terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#00b050;">+</td> </tr>

</table> <br><br>

<div style="font-size:12px;">
<i>*Il s’agit de durée de placement généralement conseillée. Court terme : 0 à 2 ans ; Moyen terme : De 3 à 8 ans ; Long terme : Strictement supérieur à 8 ans<br><br>
**+ : risque faible ; ++ : risque modéré ; +++ : risque moyen ; ++++ : risque élevé ; +++++ : risque très élevé</i>
</div><br><br> <br>


<b><u>Frais relatifs à la solution préconisée:</u></b><br><br>

<table style="border: 0.5px solid black;  border-collapse: collapse; text-align:center;">

<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">Frais d'entrée</td> <td style="width:480px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('frais_entree_rap_ass_vie', $post_id); ?></b> (prélèvement unique)</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">Frais de gestion (FG)</td> <td style="width:480px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('frais_gestion_rap_ass_vie', $post_id); ?></b> (Montant annuel estimé)</td> </tr>

</table>
<table style="border: 0.5px solid black;  border-collapse: collapse; text-align:center;">

<tr> <td style="width:160px;border: 0.5px solid black;height:30px;"><i>FG Année N+1</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><i>FG Année N+2</i></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>FG Année N+3</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><i>FG Année N+4</i></td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;"><b><?= cpg_field('frais_gestion_rap_ass_vie', $post_id); ?></b></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('frais_gestion_rap_ass_vie', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><b><?= cpg_field('frais_gestion_rap_ass_vie', $post_id); ?></b></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('frais_gestion_rap_ass_vie', $post_id); ?></b></td> </tr>
</table>


<p style="page-break-before:always;"></p>


<!-- - - - - - - - - - - - - - - - - -->

<b><u>A savoir:</u></b><br>
<p style="text-align:justify;">  En qualité d’intermédiaire en assurance, il existe plusieurs niveaux de conseils régis par le régulateur. Selon ce dernier, il y
a trois niveaux qui sont les suivants :<br><br>
<b>« Le niveau 1 (obligatoire) : proposer un contrat cohérent (approprié) avec les besoins et exigences du client.</b>
L’intermédiaire doit préciser par écrit les exigences et les besoins du client. Il lui apporte des informations objectives afin
que celui-ci puisse prendre une décision en connaissance de cause, conseille un contrat cohérent avec les exigences et les
besoins précisés et indique les raisons qui motivent ce conseil.<br><br>
<b>Le niveau 2 (facultatif) : recommander le contrat qui correspond le mieux (adéquat) aux besoins et exigences du
client.</b> Le niveau 2 revient à fournir au client un service de recommandation personnalisée consistant à lui expliquer
pourquoi, parmi plusieurs contrats, un ou plusieurs contrats correspondent « le mieux » à ses exigences et ses besoins. Un
tel service ne se conçoit que si le distributeur est en mesure de présenter au client plusieurs contrats (ou options au sein
d’un contrat) qui tous, sont cohérents avec ses exigences et ses besoins ; puis il doit mener un travail d’analyse
comparative afin de distinguer parmi ces contrats, un ou plusieurs qui apparaissent optimaux pour le client<br><br>
<b>Le niveau 3 (facultatif) : recommander, sur la base d’une analyse impartiale. </b>Cette modalité se distingue de la seconde
par le fait que la recommandation est fondée sur une analyse impartiale et personnalisée d’un nombre suffisant de contrats
offerts sur le marché. Une telle promesse de service ne se conçoit donc que basée sur l’analyse d’une pluralité de contrats,
émanant de différents producteurs, en nombre et d’une nature tels qu’ils sont représentatifs des contrats offerts sur le
marché. »<br>
Le niveau de conseil qui a été appliqué dans la réalisation de cette étude et de nos préconisations par le cabinet <?= get_field('nom_du_cabinet', $source_id); ?> a été le suivant : <b style="color:darkblue;"><?= cpg_field('conseil_rap_ass_vie', $post_id); ?></b></p><br><br><br>




<p style="text-align:center; font-size:20px;background-color:lightgrey;">
<b>COMPTE RENDU DE LA MISSION</b>
</p>


<div style="text-align:justify;">Notre accompagnement à vos côtés consiste à vous conseiller un contrat qui est cohérent avec les exigences et les besoins que vous avez exprimés.<br><br>
L’étude réalisée avec vous tient compte de votre situation familiale, professionnelle et de votre régime obligatoire. Le produit proposé répond aux besoins que vous avez exprimés en matière de couverture complémentaire santé, ainsi qu’au budget souhaité (voir votre recueil d’informations).<br><br>
L’estimation tarifaire, vous sera remise avec la présente. Il s’agit d’un devis qui présente le contrat et le niveau proposé, les garanties, les prestations et la cotisation TTC. Elle est complétée par la Notice valant Conditions Générales et le Document d’Information Produit relatifs au contrat proposé. Ces documents précisent le contenu de l’ensemble des garanties, leurs limites et les conditions de mise en œuvre.<br><br>
Aussi précis que soient les informations et les conseils qui vous ont été donnés, il est très important que vous lisiez attentivement ces documents. La Notice valant conditions générales et la demande d’adhésion constituent les documents juridiques contractuels exprimant les droits et obligations de l’assuré/adhérent et de l’assureur.<br><br>
Nous attirons votre attention sur l’importance de la sincérité des réponses que vous apportez aux questions posées par l’assureur lors de la souscription au contrat. Toute fausse déclaration peut vous exposer à une annulation de votre contrat et à l’absence de couverture en cas de sinistre.<br>

<!-- - - - - - - - - - - - - - - - - -->





<!-- ========================================= -->
<!-- RAV-5 : RAPPORT D'ADEQUATION — SUITE FINAL -->
<!-- ========================================= -->

<p style="page-break-before:always;"></p>

<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>RAPPORT D'ADEQUATION</b>
</p>

<div style="text-align:justify;">
    Dans le cadre de notre étude, nous avons réalisé (ci-dessous) un rapport d’adéquation à partir de votre situation initiale et nos préconisations. En qualité de conseil, ce rapport nous permet de formaliser le degré de concordance entre vos exigences et vos besoins dont vous n’avez fait part (rappel voir questionnaire client ) ainsi que les solutions que nous vous proposons de mettre en place pour y répondre.
    <br><br>

    <b><u>Le montant est-il cohérent avec le patrimoine du client ?</u></b><br>
    <div style="color:darkblue;"><?= cpg_field('montant_coherent_rap_ass_vie', $post_id); ?></div><br>

    <b><u>Le risque est-il compatible avec l’horizon de placement défini ?</u></b><br>
    <div style="color:darkblue;"><?= cpg_field('risque_comp_rap_ass_vie', $post_id); ?></div><br>

    <b><u>L’objectif est-il d’une part cohérent avec l’horizon de placement défini, et d’autre part avec le risque déterminé ?</u></b><br>
    <div style="color:darkblue;"><?= cpg_field('obj_cohe_rap_ass_vie', $post_id); ?></div><br>

    <b><u>Est-ce que la solution est adaptée aux connaissances financières et à l’expérience financière de votre client ?</u></b><br>
    <div style="color:darkblue;"><?= cpg_field('solution_adap_rap_ass_vie', $post_id); ?></div><br>

    <b><u>Votre client a-t-il suffisamment de liquidités pour faire face aux imprévus ?</u></b><br>
    <div style="color:darkblue;"><?= cpg_field('liquidites_rap_ass_vie', $post_id); ?></div><br>

    <b><i><u>Si oui, nous le mentionnerons dans nos observations complémentaires.</u></i></b><br><br>

    Ci-dessous, nous pouvons porter un certain nombre d’éléments à votre attention et qui ont motivé nos préconisations :<br>
    <div style="color:darkblue;"><?= cpg_field('coms_rap_ass_vie', $post_id); ?></div><br><br>
</div>

<p style="page-break-before:always;"></p>
<?php endif; ?>

<?php if (in_array('COMPLÉMENTAIRE RETRAITE', $rapports)) : ?>
    <div id="recto" style="text-align:center;vertical-align:middle;">
        <p style="text-align:left; font-size:20px;">
            <b>RAPPORT DE MISSION - COMPLÉMENTAIRE RETRAITE</b>
        </p>

        <?php
        $rapport_retraite_recto_id  = 4969; 
        $rapport_retraite_recto_url = $rapport_retraite_recto_id ? wp_get_attachment_image_url($rapport_retraite_recto_id, 'full') : '';
        if ($rapport_retraite_recto_url) : ?>
            <img width="85%" src="<?= esc_url($rapport_retraite_recto_url); ?>">
        <?php endif; ?>
    </div>

<p style="text-align:center; font-size:20px;">
    <b>RAPPORT DE MISSION <br>COMPLÉMENTAIRE RETRAITE</b>
</p>

<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>DEFINITION « COMPLÉMENTAIRE RETRAITE »</b>
</p>

<div style="text-align:justify">


<b>1. <u>Qu’est-ce que la « Complémentaire retraite » ?</u></b><br><br>
Nous tenons à vous formuler, ce à quoi correspond un contrat d’assurance « Complémentaire retraite » et les garanties généralement qui lui sont associées.<br><br>
D’après l’institution <b><i>Assurance Banque Epargne Info Service</i></b>, site d’information public qui a pour but de protéger les clients dans ces secteurs d’activités, « Les produits d’épargne retraite permettent d'épargner tout au long de sa carrière professionnelle en vue de bénéficier d'un complément de revenu pendant la retraite. Ce complément peut être versé sous forme de rente ou de capital.<br><br>
La loi dite PACTE a créé de nouveaux produits, appelés « Plans d’Épargne Retraite » ou « PER », afin de vous permettre d’épargner pour préparer votre retraite. Il peut s’agir de contrats d’assurance, de produits financiers (comptes-titres) ou de contrats proposés par les organismes de retraite professionnelle. Ces nouveaux produits peuvent vous être proposés depuis le 1er octobre 2019.<br><br>
À compter du 1er octobre 2020, il ne sera en principe plus possible de souscrire ou d’adhérer aux anciens produits d’épargne retraite. Toutefois, les contrats d’assurance conclus avant cette date pourront soit perdurer, soit être transformés en PER.<br><br>
Le montant total de la retraite peut être constitué de plusieurs niveaux de pensions :<br><br>
• Le 1er niveau : la retraite de base. Elle correspond à la pension qui est versée par le régime d’assurance vieillesse de base de la sécurité sociale (ou régimes spéciaux obligatoires). Il s’agit d’un régime obligatoire auquel tous les travailleurs cotisent ;<br>
• Le 2ème niveau : la retraite complémentaire obligatoire. Elle correspond à la pension qui est versée par les régimes de retraite complémentaires obligatoires (exemple : le régime AGIRC-ARRCO) ;
• Le 3ème niveau : l’épargne retraite. Il s’agit des sommes versées par un professionnel du secteur financier si vous avez adhéré à un produit d’épargne retraite (Plan d’épargne retraite, contrat de retraite supplémentaire...).<br><br>
<b>2. <u>Comment fonctionne l’épargne retraite en assurance ?</u></b><br><br>
Le mécanisme d’épargne retraite fonctionne en 2 temps :<br><br>
• Le 1er temps : La période d’épargne durant laquelle l’adhérent (et éventuellement son entreprise) verse des primes sur le contrat d’assurance afin de constituer son épargne retraite. <b><u>C’est ce qu’on appelle la phase de constitution des droits à la retraite ou du capital-rente.</u></b><br><br>
• Le 2nd temps : La période durant laquelle l’organisme d’assurance verse des prestations à l’adhérent. Cette période commence, au plus tôt, à l’âge de départ à la retraite de l’adhérent. Pendant cette période, l’adhérent perçoit, selon les produits, soit une rente viagère soit un capital (sous forme d’un versement unique ou de versements fractionnés). <b><u>C’est ce qu’on appelle la phase de liquidation des droits à la retraite.</u></b><br><br>
<b>3. <u>Quelles sont les deux catégories de Plan d’Epargne Retraite (PER) en assurance ?</u></b><br><br>
En assurance, il existe deux catégories de Plan d’Épargne Retraite (PER) :<br><br>
• le Plan Épargne Retraite Entreprise (PERE) mis en place par l’employeur. Il peut s’agir soit :<br>
- d’un PERE Collectif (adhésion facultative) ;<br>
- d’un PERE Obligatoire (adhésion obligatoire)<br><br>
• le Plan d’Épargne Retraite Individuel (PERI) auquel peut adhérer toute personne souhaitant se constituer une épargne retraite.<br><br><br><br><br>
<b>4. <u>Comment fonctionnent les PER en assurance ?</u></b><br><br></div>



<div style="text-align:jusitfy:">
<b><i>• Le Plan d’Épargne Retraite Entreprise Obligatoire (PERE Obligatoire)</i></b><br><br>
Tout salarié d’une entreprise qui a mis en place un PERE Obligatoire est tenu d’adhérer au contrat. L’employeur verse sur le contrat des cotisations (dont une partie peut être prélevée sur la rémunération du salarié). Le salarié peut également effectuer des versements volontaires sur le contrat.<br><br>

Si le salarié quitte l’entreprise, il pourra, s’il le souhaite, demander à l’organisme d’assurance que son épargne retraite soit transférée sur un autre PER. Cette demande de transfert ne pourra être refusée par l’organisme d’assurance à compter du 1er octobre 2020. Jusqu’à cette date, elle n’est possible que si l’organisme l’accepte. Si le salarié ne souhaite pas transférer de son épargne, celle-ci continuera d’être gérée dans les conditions prévues par le contrat jusqu’à la demande de liquidation des droits à la retraite.<br><br>
À la date de son départ à la retraite, le salarié pourra demander la mise en place d’une rente à vie (mode de liquidation imposé pour l’épargne retraite constituée par les cotisations obligatoires). Seule la part de l’épargne retraite constituée par des versements volontaires du salarié pourra être versée sous la forme d’un capital.<br><br>
<b><i>• Le Plan d’Épargne Retraite Entreprise Collectif (PERE Collectif)</i></b><br><br>
Tout salarié d’une entreprise qui a mis en place un PERE Collectif est adhérent au contrat sauf s’il le refuse (l’adhésion est facultative).<br><br>
L’employeur verse sur le contrat des cotisations (dont une partie peut être prélevée sur la rémunération du salarié). Le salarié peut également effectuer des versements volontaires sur le contrat.<br><br>
Si le salarié quitte l’entreprise, il pourra, s’il le souhaite, demander à l’organisme d’assurance que son épargne retraite soit transférée sur un autre PER. Cette demande de transfert ne pourra être refusée par l’organisme d’assurance à compter du 1er octobre 2020. Jusqu’à cette date, elle n’est possible que si l’organisme l’accepte. Si le salarié ne souhaite pas transférer son épargne, celle-ci continuera d’être gérée dans les conditions prévues par le contrat jusqu’à la demande de liquidation des droits à la retraite.<br><br>
À la date de son départ à la retraite, le salarié pourra demander la mise en place d’une rente viagère ou d’un capital versé en une seule fois ou de façon fractionnée.<br><br>
<b><i>• Le Plan d’Épargne Retraite individuel (PERI)</i></b><br><br>
Toute personne qui souhaite se constituer une épargne pour sa retraite peut adhérer à un Plan d’Épargne Retraite Individuel (PERI). Pendant la phase de constitution de l’épargne, l’adhérent verse des primes sur son contrat.<br><br>
Si, pendant la phase de constitution de l’épargne, l’adhérent, souhaite changer de produit, il pourra demander à l’organisme d’assurance que cette épargne soit transférée sur un autre PER. Cette demande de transfert ne pourra être refusée par l’organisme d’assurance à compter du 1er octobre 2020. Jusqu’à cette date, elle n’est possible que si l’organisme l’accepte.<br><br>
À la date de son départ à la retraite, l’adhérent pourra soit demander la mise en place d’une rente à vie soit le versement d’un capital (sous forme d’un versement unique ou de versements fractionnés).<br><br>
Attention : Sauf cas de déblocage anticipé limitativement prévus par la loi, les PER ne peuvent être liquidés qu’au moment de votre départ à la retraite, c’est-à-dire soit :<br><br>
• à la date à laquelle vous avez fait valoir vos droits à la retraite dans les régimes obligatoires d’assurance vieillesse;<br>
• à l’âge légal de départ à la retraite.<br><br>

<b>5. <u>Comment fonctionne les anciens contrats de retraite supplémentaire (« Article 83 », « PERP », « Madelin » et « Madelin agricole ») ?</u></b><br><br>
<b>• Les contrats dits « Article 83 »</b><br><br></div>


<div class="text-align:justify;">
Tout salarié d’une entreprise qui a mis en place un contrat dit « Article 83 » est tenu d’adhérer au contrat.
L’employeur verse sur le contrat des cotisations (dont une partie peut être prélevée sur la rémunération du salarié). Le salarié peut également effectuer des versements volontaires sur le contrat.<br><br>
Si le salarié quitte l’entreprise, il pourra, s’il le souhaite, demander à l’organisme d’assurance que son épargne retraite soit transférée sur un PER. Cette demande de transfert ne pourra être refusée par l’organisme d’assurance à compter du 1er octobre 2020. Jusqu’à cette date, elle n’est possible que si l’organisme l’accepte. Si le salarié ne souhaite pas transférer son épargne, celle-ci continuera d’être gérée dans les conditions prévues par le contrat jusqu’à la demande de liquidation des droits à la retraite.<br><br>
À la date de son départ à la retraite, le salarié devenu retraité doit demander à l’organisme d’assurance la mise en place d’une rente à vie.<br><br>
<b>• Le PERP</b><br><br>
Pendant la phase de constitution de l’épargne, l’adhérent verse des primes sur son contrat.<br><br>

Si, pendant la phase de constitution de l’épargne, l’adhérent souhaite changer de produit, il pourra demander à l’organisme d’assurance que cette épargne soit transférée sur un PER. Cette demande de transfert ne pourra être refusée par l’organisme d’assurance à compter du 1er octobre 2020. Jusqu’à cette date, elle n’est possible que si l’organisme l’accepte.<br><br>
Au moment de son départ à la retraite, l’adhérent devra demander expressément à l’assureur la mise en place d’une rente viagère. Si le contrat prévoit cette possibilité, l’adhérent peut percevoir une partie de son épargne retraite en capital (dans la limite de 20 % de la valeur de l’épargne constituée, le reste étant versé sous forme de rente viagère).<br><br>
<b>• Les contrats de retraite dits « Madelin » ou « Madelin agricole »</b><br><br>
Pendant la phase de constitution de l’épargne, l’adhérent verse des primes sur son contrat.<br><br>
Si, pendant la phase de constitution de l’épargne, l’adhérent, souhaite changer de produit, il pourra demander à l’organisme d’assurance que cette épargne soit transférée sur un PER. Cette demande de transfert ne pourra être refusée par l’organisme d’assurance à compter du 1er octobre 2020. Jusqu’à cette date, elle n’est possible que si l’organisme l’accepte.<br><br>
Au moment de son départ à la retraite, l’adhérent devra demander expressément à l’assureur la mise en place d’une rente viagère.<br><br>
Attention : Sauf cas de déblocage anticipé limitativement prévus par la loi, les contrats de retraite supplémentaire ne peuvent être liquidés qu’au moment de votre départ à la retraite, c’est-à-dire soit :<br><br>
• à la date à laquelle vous avez fait valoir vos droits à la retraite dans les régimes obligatoires d’assurance vieillesse;<br>
• à l’âge légal de départ à la retraite.<br><br>

<b>6. <u>Quelles sommes peuvent être versées sur un Plan d’Epargne Retraite Individuel (PERI) ?</u></b><br><br>
Un Plan d’Épargne Retraite Individuel (PERI) est alimenté par :<br><br>
• les primes versées par l’adhérent ;<br>
• les sommes provenant d’un transfert de l’épargne constituée au titre d’un autre produit de retraite ;<br>
• les sommes provenant d’un rachat d’un contrat d’assurance vie.<br><br>

<b>7. <u>Comment connaître la valeur de mon PER Assurance ?</u></b><br><br></div>

<div style="text-align:justify;">
Pendant la phase de constitution de l’épargne, l’organisme d’assurance doit, au moins une fois par an, apporter des informations claires à l’adhérent sur son PER. Cette information porte notamment sur :<br><br>
• la valeur des droits à la retraite en cours de constitution ;<br>
• la « performance » annuelle de chaque support sur lequel l’épargne est investie (cette valeur doit être mentionnée brute et nette des frais appliqués) ;<br>
• le montant des versements effectués ;<br>
• le montant des frais prélevés ;<br>
• la répartition de l’épargne quand elle est en gestion dite « pilotée ».<br>
Dans les 5 ans qui précèdent la date de départ à la retraite, l’adhérent peut interroger l’organisme d’assurance pour connaitre ses droits, les modalités de liquidation de l’épargne retraite et éventuellement modifier la gestion de cette épargne. En tout état de cause, l’organisme d’assurance doit obligatoirement communiquer ces informations à l’adhérent 6 mois avant la date de départ à la retraite.<br><br>

<b>8. <u>Quels frais peuvent être prélevés sur mon PER Assurance ?</u></b><br><br>
Les frais appliqués peuvent être de différente nature : frais sur versement, frais de gestion de l’épargne, frais de transfert, ...<br><br>
Avant la conclusion du PER, l’adhérent doit systématiquement être informé de l’ensemble des frais qui seront appliqués. Ces frais sont précisés dans le contrat et peuvent être indiqués en pourcentage (exemple : frais sur versement : 3% du montant de la prime).<br><br>
En tout état de cause, l’organisme d’assurance doit, au moins une fois par an, communiquer le montant total, en euros, des frais prélevés au titre du contrat. »<br><br>

Pour toute information complémentaire, nous vous invitons à bien lire les Notices d’Informations du Contrat proposés ainsi que les Conditions Générales. Aussi, vous pourrez également demander des informations supplémentaires auprès de votre Conseiller.<br><br>
<div style="font-size:10px;"><b>Source : ABE Info Service : Préparer sa retraite (<b style="color:darkblue;">https://www.abe-infoservice.fr/page-sommaire/assurance-et-contrats-de-retraite-supplementaire</b>)</b></div>

    <p style="text-align:center; font-size:20px;background-color:lightgrey;">
        <b>VOTRE SITUATION PATRIMONIALE</b>
    </p>

    Vos informations patrimoniales ci-dessous sont enregistrées à la date du
    <b><?= cpg_field('date_du_jour', $post_id); ?></b>.<br><br>

    <table style="border: 2px solid black;margin:8px;padding:8px;">


<tr style="background-color:lightgrey"> <th style="width:320px;text-align:center;padding:10px;">Vos informations personnelles</th> <th style="width:320px;text-align:center;padding:10px;">Informations personnelles de votre conjoint(e)</th> </tr>
<tr> <td>Civilité: <b><?= cpg_field('civilite', $post_id); ?></b></td> <td>Civilité: <b><?= cpg_field('civilite_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Prénom: <b><?= cpg_field('prenom_client', $post_id); ?></b></td> <td>Prénom: <b><?= cpg_field('prenom_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Nom: <b><?= cpg_field('nom_client', $post_id); ?></b></td> <td>Nom: <b><?= cpg_field('nom_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Date et lieu de naissance: <b><?= cpg_field('date_naissance_client', $post_id); ?></b> à <b><?= cpg_field('lieu_naissance_client', $post_id); ?></b></td> <td>Date et lieu de naissance: <b><?= cpg_field('date_naissance_conjoint', $post_id); ?></b> à <b><?= cpg_field('lieu_naissance_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Profession: <b><?= cpg_field('profession_client', $post_id); ?></b></td> <td>Profession: <b><?= cpg_field('profession_conjoint', $post_id); ?></b></td> </tr>
<tr> <th style="text-align:left; padding:10px;background-color:lightgrey">Votre situation familiale / patrimoniale</th> </tr>
<tr> <td>Situation familiale: <b><?= cpg_field('situation_fam_client', $post_id); ?></b></td> </tr>
<tr> <td>Personne(s) à charge: <b><?= cpg_field('charge_client', $post_id); ?></b></td> </tr>
<tr> <td>Statut patrimonial: <b><?= cpg_field('statut_pat_client', $post_id); ?></b></td> </tr>
</table>

</div>


<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>NOS PRÉCONISATIONS</b>
</p>

Suite aux informations que vous nous avez fournies quant à vos exigences et vos besoins dans le mandat, vous trouverez ci-dessous l’étude et les préconisations réalisées par le cabinet <b><?= get_field('nom_du_cabinet', $source_id); ?></b> :<br><br>

<b><i><u>Nombre de compagnies d'assurances comparées :</u></i></b>
&nbsp;&nbsp;<b style="color:darkblue;"><?= cpg_field('nb_cie_rap_retraite', $post_id); ?></b><br>

<b><i><u>Nombre de devis effectués :</u></i></b>
&nbsp;&nbsp;<b style="color:darkblue;"><?= cpg_field('nb_sim_rap_retraite', $post_id); ?></b><br>

<b><i><u>Montant du versement initial :</u></i></b>
&nbsp;&nbsp;<b style="color:darkblue;"><?= cpg_field('montant_initial_rap_retraite', $post_id); ?></b><br>

<b><i><u>Montant du versement périodique :</u></i></b>
&nbsp;&nbsp;<b style="color:darkblue;"><?= cpg_field('montant_periodique_rap_retraite', $post_id); ?></b><br>

<b><i><u>Origine des fonds :</u></i></b>
&nbsp;&nbsp;<b style="color:darkblue;"><?= cpg_field('origine_fonds_rap_retraite', $post_id); ?></b><br><br>


<b><u>Résultats des études lors de notre mission :</u></b><br><br>

<table style="border:0.5px solid black; border-collapse:collapse; text-align:center;">
    <tr>
        <td style="width:320px;border:0.5px solid black;height:30px;"></td>
        <td style="width:320px;border:0.5px solid black;"><b>Nom du contrat</b></td>
    </tr>

    <tr>
        <td style="border:0.5px solid black;height:30px;"><b>Contrat n°1</b></td>
        <td style="border:0.5px solid black;"><?= cpg_field('contrat_1_rap_retraite', $post_id); ?></td>
    </tr>

    <tr>
        <td style="border:0.5px solid black;height:30px;"><b>Contrat n°2</b></td>
        <td style="border:0.5px solid black;"><?= cpg_field('contrat_2_rap_retraite', $post_id); ?></td>
    </tr>

    <tr>
        <td style="border:0.5px solid black;height:30px;"><b>Contrat n°3</b></td>
        <td style="border:0.5px solid black;"><?= cpg_field('contrat_3_rap_retraite', $post_id); ?></td>
    </tr>

    <tr>
        <td style="border:0.5px solid black;height:30px;"><b>Contrat n°4</b></td>
        <td style="border:0.5px solid black;"><?= cpg_field('contrat_4_rap_retraite', $post_id); ?></td>
    </tr>
</table>

<br>

Parmi les différents contrats proposés, voici celui retenu (PU) :
<b style="color:darkblue;"><?= cpg_field('retenu_pu_rap_retraite', $post_id); ?></b><br>

Parmi les différents contrats proposés, voici celui retenu (VERREG) :
<b style="color:darkblue;"><?= cpg_field('retenu_verreg_rap_retraite', $post_id); ?></b><br><br>


<b><u>Avantages et inconvénients liés au produit :</u></b><br><br>

<table style="border:0.5px solid black; border-collapse:collapse; text-align:center;">
    <tr>
        <td style="width:320px;border:0.5px solid black;height:30px;"><b><u>Avantages</u></b></td>
        <td style="width:320px;border:0.5px solid black;"><b><u>Inconvénients</u></b></td>
    </tr>

    <tr>
        <td style="border:0.5px solid black;height:100px;color:darkblue;">
            <?= cpg_field('avantages_rap_retraite', $post_id); ?>
        </td>

        <td style="border:0.5px solid black;height:100px;color:darkblue;">
            <?= cpg_field('limites_rap_retraite', $post_id); ?>
        </td>
    </tr>
</table>

<br><br><br>



<b><u>Unités de compte présentes dans votre allocation</u></b> (tableau)<br><br>

<table style="border: 0.5px solid black;  border-collapse: collapse; text-align:center;">

<tr> <td style="width:160px;border: 0.5px solid black;height:30px;"><b><u>Unité de compte</u></b></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><u>Présence dans votre allocation</u></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><b><u>Horizon de temps*</u></b></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><u>Degré de risque**</u></b></td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">Titre vifs</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('titres_alloc_rap_retraite', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ff0000;">+++++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">Produits structurés</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('prod_rap_retraite', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ff0000;">+++++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">ETF</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('etf_rap_retraite', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ff0000;">+++++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">FIA (Fonds Investissements Alternatifs)</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('fia_rap_retraite', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ff0000;">+++++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">UC Actions</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('uca_rap_retraite', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ff4b4b;">++++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">UC Obligations</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('ucob_rap_retraite', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Moyen/Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ed7d31;">+++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">UC Diversifiées</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('uc_divers_rap_retraite', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Moyen/Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ed7d31;">+++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">OPCI (Organisme de Placement Collectif en Immobilier)</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('opci_rap_retraite', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Moyen terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ed7d31;">+++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">SCPI (Société Civile de Placement Immobilier)</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('scpi_rap_retraite', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Moyen/Long terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#ffc000;">++</td> </tr>
<tr> <td style="width:160px;border: 0.5px solid black;height:30px;">Fonds €</td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;"><b><?= cpg_field('fonds_rap_retraite', $post_id); ?></b></td><td style="width:160px;border: 0.5px solid black;height:30px;"><i>Court terme</i></td> <td style="width:160px;border: 0.5px solid black;  border-collapse: collapse;background-color:#00b050;">+</td> </tr>

</table>

<br><br>

<div style="font-size:12px;">
<i>*Il s’agit de durée de placement généralement conseillée. Court terme : 0 à 2 ans ; Moyen terme : De 3 à 8 ans ; Long terme : Strictement supérieur à 8 ans<br><br>
**+ : risque faible ; ++ : risque modéré ; +++ : risque moyen ; ++++ : risque élevé ; +++++ : risque très élevé</i>
</div>

<br><br><br>

<b><u>Frais relatifs à la solution préconisée :</u></b><br><br>

<table style="border:0.5px solid black; border-collapse:collapse; text-align:center;">
    <tr>
        <td style="width:160px;border:0.5px solid black;width:160px;height:30px;">Frais d'entrée</td>
        <td style="width:480px;border:0.5px solid black;width:160px;height:30px;">
            <b><?= cpg_field('frais_entree_rap_retraite', $post_id); ?></b> (prélèvement unique)
        </td>
    </tr>

    <tr>
        <td style="border:0.5px solid black;width:160px;height:30px;">Frais de gestion</td>
        <td style="border:0.5px solid black;width:160px;height:30px;">
            <b><?= cpg_field('frais_gestion_rap_retraite', $post_id); ?></b> (montant annuel estimé)
        </td>
    </tr>
</table>

<table style="border:0.5px solid black; border-collapse:collapse; text-align:center; margin-top:10px;">
    <tr>
        <td style="border:0.5px solid black;width:160px;height:30px;"><i>FG Année N+1</i></td>
        <td style="border:0.5px solid black;width:160px;height:30px;"><i>FG Année N+2</i></td>
        <td style="border:0.5px solid black;width:160px;height:30px;"><i>FG Année N+3</i></td>
        <td style="border:0.5px solid black;width:160px;height:30px;"><i>FG Année N+4</i></td>
    </tr>

    <?php $fg = cpg_field('frais_gestion_rap_retraite', $post_id); ?>

    <tr>
        <td style="border:0.5px solid black;width:160px;height:30px;"><b><?= $fg ?></b></td>
        <td style="border:0.5px solid black;width:160px;height:30px;"><b><?= $fg ?></b></td>
        <td style="border:0.5px solid black;width:160px;height:30px;"><b><?= $fg ?></b></td>
        <td style="border:0.5px solid black;width:160px;height:30px;"><b><?= $fg ?></b></td>
    </tr>
</table>

<p style="page-break-before:always;"></p>


<b><u>A savoir:</u></b><br>
<p style="text-align:justify;">  En qualité d’intermédiaire en assurance, il existe plusieurs niveaux de conseils régis par le régulateur. Selon ce dernier, il y
a trois niveaux qui sont les suivants :<br><br>
<b>« Le niveau 1 (obligatoire) : proposer un contrat cohérent (approprié) avec les besoins et exigences du client.</b>
L’intermédiaire doit préciser par écrit les exigences et les besoins du client. Il lui apporte des informations objectives afin
que celui-ci puisse prendre une décision en connaissance de cause, conseille un contrat cohérent avec les exigences et les
besoins précisés et indique les raisons qui motivent ce conseil.<br><br>
<b>Le niveau 2 (facultatif) : recommander le contrat qui correspond le mieux (adéquat) aux besoins et exigences du
client.</b> Le niveau 2 revient à fournir au client un service de recommandation personnalisée consistant à lui expliquer
pourquoi, parmi plusieurs contrats, un ou plusieurs contrats correspondent « le mieux » à ses exigences et ses besoins. Un
tel service ne se conçoit que si le distributeur est en mesure de présenter au client plusieurs contrats (ou options au sein
d’un contrat) qui tous, sont cohérents avec ses exigences et ses besoins ; puis il doit mener un travail d’analyse
comparative afin de distinguer parmi ces contrats, un ou plusieurs qui apparaissent optimaux pour le client<br><br>
<b>Le niveau 3 (facultatif) : recommander, sur la base d’une analyse impartiale. </b>Cette modalité se distingue de la seconde
par le fait que la recommandation est fondée sur une analyse impartiale et personnalisée d’un nombre suffisant de contrats
offerts sur le marché. Une telle promesse de service ne se conçoit donc que basée sur l’analyse d’une pluralité de contrats,
émanant de différents producteurs, en nombre et d’une nature tels qu’ils sont représentatifs des contrats offerts sur le
marché. »<br>
Le niveau de conseil qui a été appliqué dans la réalisation de cette étude et de nos préconisations par le cabinet
<b><?= get_field('nom_du_cabinet', $source_id); ?></b> a été le suivant :
<b style="color:darkblue;"><?= cpg_field('niveau_rap_retraite', $post_id); ?></b>
</p>

<br><br><br>

<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>COMPTE RENDU DE LA MISSION</b>
</p>

<div style="text-align:justify;">Notre accompagnement à vos côtés consiste à vous conseiller un contrat qui est cohérent avec les exigences et les besoins que vous avez exprimés.<br><br>
L’étude réalisée avec vous tient compte de votre situation familiale, professionnelle et de votre régime obligatoire. Le produit proposé répond aux besoins que vous avez exprimés en matière de couverture complémentaire santé, ainsi qu’au budget souhaité (voir votre recueil d’informations).<br><br>
L’estimation tarifaire, vous sera remise avec la présente. Il s’agit d’un devis qui présente le contrat et le niveau proposé, les garanties, les prestations et la cotisation TTC. Elle est complétée par la Notice valant Conditions Générales et le Document d’Information Produit relatifs au contrat proposé. Ces documents précisent le contenu de l’ensemble des garanties, leurs limites et les conditions de mise en œuvre.<br><br>
Aussi précis que soient les informations et les conseils qui vous ont été donnés, il est très important que vous lisiez attentivement ces documents. La Notice valant conditions générales et la demande d’adhésion constituent les documents juridiques contractuels exprimant les droits et obligations de l’assuré/adhérent et de l’assureur.<br><br>
Nous attirons votre attention sur l’importance de la sincérité des réponses que vous apportez aux questions posées par l’assureur lors de la souscription au contrat. Toute fausse déclaration peut vous exposer à une annulation de votre contrat et à l’absence de couverture en cas de sinistre.<br>

<p style="page-break-before:always;"></p>




<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>RAPPORT D'ADEQUATION</b>
</p>

Dans le cadre de notre étude, nous avons réalisé (ci-dessous) un rapport d’adéquation à partir de votre situation initiale et nos préconisations. En qualité de conseil, ce rapport nous permet de formaliser le degré de concordance entre vos exigences et vos besoins dont vous n’avez fait part (rappel voir questionnaire client ) ainsi que les solutions que nous vous proposons de mettre en place pour y répondre.<br><br>



<b><u>Le montant est-il cohérent avec le patrimoine du client ?</u></b><br>
<div style="color:darkblue;"><?= cpg_field('montant_coherent_rap_retraite', $post_id); ?></div><br>

<b><u>Le risque est-il compatible avec l’horizon de placement défini ?</u></b><br>
<div style="color:darkblue;"><?= cpg_field('risque_compatible_rap_retraite', $post_id); ?></div><br>

<b><u>L’objectif est-il d’une part cohérent avec l’horizon de placement défini, et d’autre part avec le risque déterminé ?</u></b><br>
<div style="color:darkblue;"><?= cpg_field('obj_cohe_rap_retraite', $post_id); ?></div><br>

<b><u>Est-ce que la solution est adaptée aux connaissances financières et à l’expérience financière de votre client ?</u></b><br>
<div style="color:darkblue;"><?= cpg_field('solution_adap_rap_retraite', $post_id); ?></div><br>

<b><u>Votre client a-t-il suffisamment de liquidités pour faire face aux imprévus ?</u></b><br>
<div style="color:darkblue;"><?= cpg_field('liquidites_rap_retraite', $post_id); ?></div><br>

<b><i><u>Si oui, cela sera mentionné dans les observations complémentaires.</u></i></b><br><br>

Ci-dessous, nous pouvons porter un certain nombre d’éléments à votre attention et qui ont motivé nos préconisations :<br>
<div style="color:darkblue;"><?= cpg_field('coms_rap_retraite', $post_id); ?></div><br><br>

<p style="page-break-before:always;"></p>

<?php endif; ?>

<?php if (in_array('PRÉVOYANCE', $rapports)) : ?>
    <div id="recto" style="text-align:center;vertical-align:middle;">
        <p style="text-align:left; font-size:20px;">
            <b>RAPPORT DE MISSION - PRÉVOYANCE</b>
        </p>

    <?php
    $rapport_prev_img_id  = (int) get_option('arc_media_rapport_prev_id', 0);
    $rapport_prev_img_url = $rapport_prev_img_id ? wp_get_attachment_image_url($rapport_prev_img_id, 'full') : '';

    if ($rapport_prev_img_url) : ?>
        <img width="85%" src="<?= esc_url($rapport_prev_img_url); ?>">
    <?php endif; ?>
    </div>

<p style="text-align:center; font-size:20px;">
    <b>RAPPORT DE MISSION <br>ASSURANCE PREVOYANCE</b>
</p>

<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>DEFINITION «ASSURANCE PREVOYANCE»</b>
</p>

<div style="text-align:justify;">

<b>1. <u>Qu’est-ce que l’Assurance «Prévoyance» ?</u></b><br><br>
Nous tenons à vous formuler, ce à quoi correspond un contrat d’assurance « Prévoyance» et les garanties généralement qui lui sont associées.<br><br>
D’après l’institution <b><i>Assurance Banque Epargne Info Service</i></b>, site d’information public qui a pour but de protéger les clients dans ces secteurs d’activités, ils définissent l’Assurance Prévoyance comme « un contrat permettant à une personne de se prémunir contre les conséquences d’une dégradation de son état de santé. Il peut s’agir de contrats d’assurance emprunteur, d’assurance garantie accident, d’assurance obsèques ou encore d’assurance dépendance. Un contrat de prévoyance individuel est souscrit par un assuré auprès d’un organisme d’assurance ou via un intermédiaire en assurance.<br><br>
Dans la pratique, la notion de contrat de prévoyance est réservée aux contrats par lesquels l’assureur garantit le versement de prestations en cas d’incapacité temporaire de travail, d’invalidité ou de décès de l’assuré. Il existe aussi une assurance prévoyance assez particulière, le plus souvent dénommé « IJH » (Indemnités Journalières en cas d’Hospitalisation) qui garantit à l’assuré le versement d’une indemnité forfaitaire par jour d’hospitalisation consécutive à une maladie et/ou un accident.<br><br>
Attention : un contrat de prévoyance n’est pas un produit d’épargne. Il s’agit d’un contrat dit « à fonds perdus » qui ne permet pas la constitution d’un capital.<br><br><br>

<b>2. <u>Exemple de garanties</u></b><br><br>
Le plus souvent les contrats d’assurance prévoyance couvrent, quelle qu’en soit la cause (accident ou maladie), les risques suivants :<br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; <b>L’incapacité temporaire de travail</b> (ITT) : Cette garantie couvre l’incapacité temporaire totale d’exercer son activité professionnelle et parfois l’incapacité temporaire partielle de travail (mi-temps thérapeutique). Elle vise à se prémunir contre le risque de perte de revenus à la suite d’un arrêt de travail. La mise en jeu de la garantie suppose donc en principe d’avoir une activité professionnelle au moment du sinistre ;<br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; <b>L’invalidité</b> : L’invalidité correspond à une réduction définitive de la capacité de travail de l’assuré, ce qui suppose une consolidation de son état de santé. Elle est appréciée selon un barème fixé par le contrat et qui n’est pas obligatoirement celui appliqué par le régime d’assurance obligatoire de l’assuré ;<br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; <b>La Perte Totale et Irréversible d’Autonomie</b> (PTIA) ou Invalidité Absolue et Définitive (IAD) : La PTIA (ou IAD) correspond à un état d’invalidité très aggravé. Ses critères de reconnaissance varient d’un contrat à l’autre et sont plus ou moins restrictifs. La plupart des contrats prévoit toutefois que seront considérés en état de PTIA (ou IAD) les assurés étant définitivement dans l’impossibilité totale d’exercer une profession, voire de se livrer à la moindre occupation, et dans l’obligation d’avoir recours à l’assistance d’une tierce personne pour effectuer les actes ordinaires de la vie (se déplacer, s’habiller, manger, se laver...) ;<br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; <b>Le décès</b> : Le décès est en principe couvert qu’il résulte d’un accident ou d’une maladie. Toutefois tous les contrats de prévoyance prévoient que les décès consécutifs à certains évènements ne sont pas garantis. Il convient donc de lire avec attention les clauses d’exclusion contractuelles. En cas de décès de l’assuré, l’assureur versera un capital au(x) bénéficiaire(s) désigné(s). Tous les contrats comportent une clause bénéficiaire type mais l’assuré est toujours libre de la remplacer en désignant les bénéficiaires de son choix.<br><br><br>

<!-- - - - - - - - - - - - - - - - - -->


<p style="page-break-before:always;"></p>


<!-- - - - - - - - - - - - - - - - - -->

<b>3. <u>Y-a-t-il des formalités médicales pour souscrire un contrat de prévoyance ?</u></b><br><br>
Deux situations doivent être distinguées :<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; <b>en cas d’adhésion à un contrat collectif souscrit par votre employeur au profit de ses salariés</b>, en principe il ne vous sera pas demandé d’informations relatives à votre état de santé. Le cas échéant, préalablement à la souscription du contrat, l’assureur aura interrogé votre employeur sur les caractéristiques de la population à assurer (âge, rémunération, statut, nombre d’arrêts de travail sur une période donnée ...).<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; <b>dans les autres cas,</b> il vous sera le plus souvent demandé de remplir un questionnaire de santé et parfois de réaliser des analyses ou examens médicaux.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <b>Au vu des informations qui lui seront transmises</b>, l’assureur pourra majorer le tarif et/ou prononcer des exclusions partielles ou totales de garanties, voire refuser votre demande.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Attention : <b>Une déclaration erronée peut avoir de lourdes conséquences</b> (réduction des prestations, nullité du contrat). Vous devez donc apporter une attention toute particulière au remplissage d’un questionnaire de santé.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Sachez que vous n’êtes pas obligé de le compléter en présence du professionnel qui vous propose le contrat et que vous avez toujours la possibilité de le retourner sous pli confidentiel à l’attention du Médecin conseil de l’organisme d’assurance concerné. Ne vous précipitez donc pas et, si besoin, n’hésitez pas à solliciter votre médecin. »<br>
</div>

<div style="text-align:justify;">
<b>4. <u>Attention aux exclusions de garantie</u></b><br>
Il existe des exclusions très répandues ou légales :<br><br>
&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; décès consécutif à un suicide intervenant durant la première année du contrat d’assurance ;<br>
&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; les conséquences d’une participation à des actes de terrorisme, d’attentat, d’émeute, de grève ;<br>
&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; les conséquences de l’usage de stupéfiants...<br>
Il existe des exclusions diverses et variées qui peuvent notamment porter sur :<br><br>
&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; les sinistres résultant de la pratique de certains sports (aériens, nautiques, mécaniques, de combat, alpins ...) ;<br>
&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; les séjours en cure (thermales, d’amaigrissement, désintoxication ...) ou en maison de repos ;<br>
&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; les conséquences de l’abus d’alcool (éthylisme) ;<br>
&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; les arrêts de travail consécutifs à certaines maladies psychopathologiques, psychiques, psychiatriques (dépression ou syndrome anxio-dépressif, syndrome de fatigue chronique, fibromyalgie ...) ;<br>
&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; les arrêts de travail consécutifs à des problèmes de dos (atteinte vertébrale, discale ou radiculaire : lumbago, lombalgie, sciatique, hernie discale ...).<br>
À noter : sauf en cas de souscription d’un contrat collectif par un employeur au profit de ses salariés, un assureur peut exclure les suites et conséquences d’une pathologie antérieure à la souscription de l’assuré mais uniquement si cette exclusion de garantie vise une (des) pathologie(s) clairement précisée(s) dans un document contractuel personnalisé (conditions particulières, certificat d’adhésion ou attestation d’assurance).<br><br><br>

<b>5. <u>Attention au montant, à la durée et aux règles de fixation de l’indemnisation</u></b><br>
Soyez particulièrement attentif :<br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; au délai de franchise applicable à la garantie incapacité de travail, c’est-à-dire le délai à l’issue duquel un sinistre commencera être indemnisé.<br><br>
Exemple : un délai de franchise de 30 jours signifie que vous ne serez indemnisé qu’à compter du 31ème jour d’arrêt de travail, les 30 premiers jours n’étant pas indemnisés.<br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; au caractère indemnitaire ou forfaitaire de l’indemnisation ;<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; aux évènements mettant fin au versement des prestations : âge limite, mise à la retraite, atteinte d’une durée maximale de
versement ...<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;•&nbsp;&nbsp;&nbsp;&nbsp; à la méthode d’évaluation de l’état d’invalidité tout particulièrement lorsque celle-ci consiste en un croisement d’un taux d’incapacité fonctionnelle et d’un taux d’incapacité professionnelle (méthode dite du « tableau croisé »).<br><br>
Pour toute information complémentaire, nous vous invitons à bien lire les Notices d’Informations du Contrat proposés ainsi que les Conditions Générales. Aussi, vous pourrez également demander des informations supplémentaires auprès de votre Conseiller.<br><br>
</div>
<div style="font-size:10px;">

<u>Source : ABE Info Service (22/08/2019) : Que faut-il savoir sur l’assurance prévoyance ? (<b style="color:darkblue;">

https://www.abe-infoservice.fr/assurance/assurance-prevoyance/que-faut-il-savoir-sur-lassurance-prevoyance</b>)</u><br><br><br>
</div>

<!-- - - - - - - - - - - - - - - - - -->


<p style="page-break-before:always;"></p>


<br><br>
<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>NOS PRECONISATIONS</b>
</p>

Suite aux informations que vous nous avez fourni quant à vos exigences et à vos besoins dans le mandat, vous trouverez ci-dessous l’étude et les préconisations réalisées par le cabinet
<b><?= get_field('nom_du_cabinet', $source_id); ?></b> :<br><br>

<b><i><u>Nombre de compagnies d'assurances comparées :</u></i></b>
&nbsp;<b style="color:darkblue;"><?= cpg_field('nb_cie_rap_prev', $post_id); ?></b><br><br>

<b><i><u>Nombre de devis effectués :</u></i></b>
&nbsp;<b style="color:darkblue;"><?= cpg_field('nb_sim_rap_prev', $post_id); ?></b><br><br>

<b><u>Résultats des études lors de notre mission:</u></b><br><br>

<table style="border: 0.5px solid black; border-collapse: collapse; text-align:center;">
    <tr>
        <td style="width:213px;border: 0.5px solid black;height:30px;"></td>
        <td style="width:213px;border: 0.5px solid black;height:30px;"><b>Nom du contrat</b></td>
        <td style="width:213px;border: 0.5px solid black;height:30px;"><b>Tarification</b></td>
    </tr>

    <tr>
        <td style="border:0.5px solid black;height:30px;"><b>Contrat n°1</b></td>
        <td style="border:0.5px solid black;height:30px;"><?= cpg_field('contrat_1_rap_prev', $post_id); ?></td>
        <td style="border:0.5px solid black;height:30px;">voir devis</td>
    </tr>

    <tr>
        <td style="border:0.5px solid black;height:30px;"><b>Contrat n°2</b></td>
        <td style="border:0.5px solid black;height:30px;"><?= cpg_field('contrat_2_rap_prev', $post_id); ?></td>
        <td style="border:0.5px solid black;height:30px;">voir devis</td>
    </tr>

    <tr>
        <td style="border:0.5px solid black;height:30px;"><b>Contrat n°3</b></td>
        <td style="border:0.5px solid black;height:30px;"><?= cpg_field('contrat_3_rap_prev', $post_id); ?></td>
        <td style="border:0.5px solid black;height:30px;">voir devis</td>
    </tr>
</table>

<br><br>

<b>Parmi les différents contrats proposés sur ce tableau, voici ce que nous avons retenu :</b>
<b style="color:darkblue;"><?= cpg_field('retenu_rap_prev', $post_id); ?></b><br><br>

<b><u>A savoir:</u></b><br>
<p style="text-align:justify;">  En qualité d’intermédiaire en assurance, il existe plusieurs niveaux de conseils régis par le régulateur. Selon ce dernier, il y
a trois niveaux qui sont les suivants :<br><br>
<b>« Le niveau 1 (obligatoire) : proposer un contrat cohérent (approprié) avec les besoins et exigences du client.</b>
L’intermédiaire doit préciser par écrit les exigences et les besoins du client. Il lui apporte des informations objectives afin
que celui-ci puisse prendre une décision en connaissance de cause, conseille un contrat cohérent avec les exigences et les
besoins précisés et indique les raisons qui motivent ce conseil.<br><br>
<b>Le niveau 2 (facultatif) : recommander le contrat qui correspond le mieux (adéquat) aux besoins et exigences du
client.</b> Le niveau 2 revient à fournir au client un service de recommandation personnalisée consistant à lui expliquer
pourquoi, parmi plusieurs contrats, un ou plusieurs contrats correspondent « le mieux » à ses exigences et ses besoins. Un
tel service ne se conçoit que si le distributeur est en mesure de présenter au client plusieurs contrats (ou options au sein
d’un contrat) qui tous, sont cohérents avec ses exigences et ses besoins ; puis il doit mener un travail d’analyse
comparative afin de distinguer parmi ces contrats, un ou plusieurs qui apparaissent optimaux pour le client<br><br>
<b>Le niveau 3 (facultatif) : recommander, sur la base d’une analyse impartiale. </b>Cette modalité se distingue de la seconde
par le fait que la recommandation est fondée sur une analyse impartiale et personnalisée d’un nombre suffisant de contrats
offerts sur le marché. Une telle promesse de service ne se conçoit donc que basée sur l’analyse d’une pluralité de contrats,
émanant de différents producteurs, en nombre et d’une nature tels qu’ils sont représentatifs des contrats offerts sur le
marché. »<br>
Le niveau de conseil qui a été appliqué dans la réalisation de cette étude et de nos préconisations par le cabinet <?= get_field('nom_du_cabinet', $source_id); ?> a été le suivant : <b style="color:darkblue;"><?= cpg_field('conseil_rap_prev', $post_id); ?></b></p><br><br><br>




<p style="page-break-before:always;"></p>

<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>COMPTE RENDU DE LA MISSION</b>
</p>

<div style="text-align:justify;">Notre accompagnement à vos côtés consiste à vous conseiller un contrat qui est cohérent avec les exigences et les besoins que vous avez exprimés.<br><br>
L’étude réalisée avec vous tient compte de votre situation familiale, professionnelle et de votre régime obligatoire. Le produit proposé répond aux besoins que vous avez exprimés en matière de couverture complémentaire santé, ainsi qu’au budget souhaité (voir votre recueil d’informations).<br><br>
L’estimation tarifaire, vous sera remise avec la présente. Il s’agit d’un devis qui présente le contrat et le niveau proposé, les garanties, les prestations et la cotisation TTC. Elle est complétée par la Notice valant Conditions Générales et le Document d’Information Produit relatifs au contrat proposé. Ces documents précisent le contenu de l’ensemble des garanties, leurs limites et les conditions de mise en œuvre.<br><br>
Aussi précis que soient les informations et les conseils qui vous ont été donnés, il est très important que vous lisiez attentivement ces documents. La Notice valant conditions générales et la demande d’adhésion constituent les documents juridiques contractuels exprimant les droits et obligations de l’assuré/adhérent et de l’assureur.<br><br>
Nous attirons votre attention sur l’importance de la sincérité des réponses que vous apportez aux questions posées par l’assureur lors de la souscription au contrat. Toute fausse déclaration peut vous exposer à une annulation de votre contrat et à l’absence de couverture en cas de sinistre.<br></div>

<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>RAPPORT D'ADEQUATION</b>
</p>

<div style="text-align:justify;">

<b><u>La solution préconisée est-elle conforme à mes objectifs et à mes attentes ?</u></b><br>
<b style="color:darkblue;"><?= cpg_field('solution_preco_confo_rap_prev', $post_id); ?></b><br><br>

<b><u>La solution préconisée est-elle en adéquation avec ma situation et mes besoins ?</u></b><br>
<b style="color:darkblue;"><?= cpg_field('solution_preco_adeq_rap_prev', $post_id); ?></b><br><br>

<b><u>Est-ce que la solution préconisée correspond au budget que j’ai initialement envisagé ?</u></b><br>
<b style="color:darkblue;"><?= cpg_field('solution_budget_rap_prev', $post_id); ?></b><br><br>

<b><u>Y a-t-il des demandes en garanties que j’ai exprimé auxquelles vous n’avez pas pu répondre ?</u></b><br>
<b style="color:darkblue;"><?= cpg_field('autres_demandes_rap_prev', $post_id); ?></b><br><br>

<b style="color:grey"><i><u>Si oui, nous le mentionnerons dans nos observations complémentaires</u></i></b><br><br>

Ci-dessous, nous pouvons porter un certain nombre d’éléments à votre attention et qui ont motivé nos préconisations :<br>
<div style="color:darkblue;"><?= cpg_field('coms_rap_prev', $post_id); ?></div>

</div>

<br><br><br>

<p style="page-break-before:always;"></p>

<?php endif; ?>

<?php if (in_array('SANTÉ', $rapports)) : ?>
    <div id="recto" style="text-align:center;vertical-align:middle;">
        <p style="text-align:left; font-size:20px;">
            <b>RAPPORT DE MISSION - COMPLENTAIRE SANTÉ</b>
        </p>

    <?php
    $rapport_mut_img_id  = (int) get_option('arc_media_rapport_mut_id', 0);
    $rapport_mut_img_url = $rapport_mut_img_id ? wp_get_attachment_image_url($rapport_mut_img_id, 'full') : '';

    if ($rapport_mut_img_url) : ?>
        <img width="85%" src="<?= esc_url($rapport_mut_img_url); ?>">
    <?php endif; ?>
    </div>



<p style="text-align:center; font-size:20px;">
    <b>RAPPORT DE MISSION <br>ASSURANCE COMPLEMENTAIRE SANTE</b>
</p>

<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>DEFINITION «COMPLEMENTAIRE SANTE »</b>
</p>

<div style="text-align:justify;">

<b>1. <u>Qu’est-ce que l’Assurance « Sante » ?</u></b><br><br>
Nous tenons à vous formuler, ce à quoi correspond un contrat d’assurance <b>« Complémentaire Sante »</b> et les garanties généralement qui lui sont associées.<br>
Ce produit d’assurance a pour but de prendre en charge, en partie ou en intégralité, vos dépenses de santé non-couvertes par votre assurance maladie obligatoire. La souscription d’une mutuelle est libre et optionnelle. Généralement, la cotisation pour la mutuelle ne dépend généralement pas des revenus du salarié.<br><br>
<b>2. <u>En tant que salarié, mon employeur a-t-il l’obligation de me proposer une assurance complémentaire santé ?</u></b><br><br>
D’après l’institution <b><i>Assurance Banque Epargne Info Service</i></b>, site d’information public qui a pour but de protéger les clients dans ces secteurs d’activités, il est précisé que « depuis le 1er janvier 2016 (loi n° 2013-504 du 14 juin 2013), toutes les entreprises, quel que soit leur nombre de salariés, sont tenues de proposer une assurance complémentaire santé. Et les salariés doivent adhérer au contrat, d’où son caractère obligatoire. La couverture des ayants-droits, enfants ou conjoint du salarié, n'est toutefois pas obligatoire par le biais de cette assurance santé. Chaque salarié bénéficie d’une couverture santé minimale.<br><br>
<b>3. <u>Quelles sont les garanties minimales que doit comporter l’assurance complémentaire proposée par un employeur ?</u></b><br><br>
Le panier de soins comprend :<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• la prise en charge de l’intégralité du ticket modérateur pour les consultations, les actes et les prestations remboursables par l’assurance maladie obligatoire (sauf cures thermales et médicaments remboursés à 30 % ou à 15 % par l’Assurance maladie) ;<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• la prise en charge sans limitation de durée du forfait journalier hospitalier (18 € par jour) ;<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• le remboursement des soins dentaires prothétiques et des soins d’orthopédie dentaire à hauteur de 125 % du tarif de responsabilité de l’Assurance maladie ;<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• la prise en charge des dépenses d’optique, de manière forfaitaire, par période de 2 ans (100 € pour les verres simples, 200 € pour les verres complexes et 150 € pour les équipements mixtes), sauf pour les mineurs ou lorsqu’il y a évolution de la vue.<br><br>
<b>4. <u>Un salarié peut refuser l’assurance complémentaire santé proposée par l’employeur ?</u></b><br><br>
Un certain nombre de cas de dispenses d’affiliation est prévu par le décret n° 2015-1883 du 30 décembre 2015 entré en vigueur le 1er janvier 2016. Ces dispenses de droit concernent :<br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Les salariés bénéficiaires de l’ACS ou de la CMU-C jusqu’à la fin de la couverture ou de l’aide ;<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Les salariés qui bénéficient d’une couverture obligatoire y compris en tant qu’ayants droit au titre :<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• D’un autre régime frais de santé collectif obligatoire ;<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• D’un contrat d’assurance de groupe dit « loi Madelin » ;<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Régime local d’Alsace Moselle ;<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Régime complémentaire relevant de la caisse d’assurance maladie des industries électriques et gazières (CAMIEG) ;<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Mutuelle des agents de l’État ou des collectivités territoriales. ;<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Les salariés en CDD d’une durée inférieure ou égale à 3 mois ;<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Les salariés couverts par un contrat individuel, lors de la mise en place du régime ou lors de l’embauche si elle est postérieure.<br><br>
Il est possible de bénéficier d’autres dispenses, qui ne sont pas de droit et qui doivent donc être indiqués dans le contrat :<br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Salariés et apprentis bénéficiaires d'un contrat à durée déterminée ou d'un contrat de mission d'une durée au moins égale à douze mois à condition de justifier par écrit, en produisant tous documents utiles, d'une couverture individuelle souscrite par ailleurs pour le même type de garanties ;<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Salariés et apprentis bénéficiaires d'un contrat à durée déterminée ou d'un contrat de mission d'une durée inférieure à douze mois, même s'ils ne bénéficient pas d'une couverture individuelle souscrite par ailleurs ;<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• Salariés à temps partiel et apprentis dont l'adhésion au système de garanties les conduirait à s'acquitter d'une cotisation au moins égale à 10 % de leur rémunération brute<br><br>

<b>5. <u>Un salarié peut bénéficier du maintien de l’assurance complémentaire après son départ de l’entreprise ?</u></b><br><br>
Un contrat d’assurance complémentaire santé collectif à adhésion obligatoire ne peut pas être résilié à l’initiative du salarié sauf en cas de licenciement ou de départ en retraite.<br><br>
Toutefois, <b>en cas de licenciement</b> et hors cas de faute lourde, un salarié peut continuer à bénéficier, à titre gratuit, de la complémentaire santé de l'entreprise pendant au maximum un an à condition de justifier de sa prise charge par Pôle Emploi (article L.911-8 du code de la sécurité sociale). Ses ayants droit bénéficient dans les mêmes conditions du maintien des garanties.<br><br>
<b>En cas de départ en retraite et en fin de période de portabilité</b>, les anciens salariés bénéficiaires d’une rente d’incapacité ou d’invalidité, d’une pension de retraite ou d’un revenu de remplacement (si chômage), peuvent demander à bénéficier d’un contrat dit « de sortie de groupe » qui doit leur être proposé par leur dernier employeur (article 4 de la loi n° 89-1009 du 31 décembre 1989 dite loi Evin). Ce contrat doit maintenir la même couverture à ses anciens salariés qui devront alors prendre en charge son financement.<br><br>
Les intéressés doivent en faire la demande dans les six mois qui suivent la rupture de leur contrat de travail ou dans les six mois qui précèdent l'échéance de la période de portabilité des garanties.La cotisation est toutefois limitée et ne pourra être supérieure de plus de 50% au tarif global applicable aux salariés actifs.<br><br>
<b>En cas de départ volontaire :</b> le contrat est résilié de plein droit.<br><br></div>


<div style="text-align:justify;">
<b>6. <u>L’assureur a-t-il le droit d’augmenter le montant des cotisations du contrat d’assurance complémentaire santé ?</u></b><br><br>
Oui, <b>les assureurs peuvent augmenter le montant de vos cotisations à l’échéance.</b> Ces majorations de cotisations doivent en principe être uniformes et peuvent être la conséquence : <br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• soit de <b>mécanismes de révision</b> de cotisation prévus au contrat (indices ou tranches d’âge),<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• soit <b>d’ajustements tarifaires à caractère technique</b> (équilibre général des comptes du contrat entre les cotisations
reçues et les prestations payées).<br><br>
En assurance complémentaire santé, les augmentations appliquées ne doivent pas être liées à l’évolution de l’état de santé de l’assuré ou de ses ayants droit mais aux résultats économiques du contrat couvrant un ensemble d’assurés, chacun d’entre eux subissant cette hausse de tarif. En tout état de cause, les organismes d’assurance déterminent leurs tarifs en fonction :<br><br>
<b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• du coût et de la fréquence des remboursements de frais de soins,<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• des modifications législatives, réglementaires ou contractuelles,<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;• de leur équilibre financier.</b><br><br>
<b>7. <u>Comment comparer plusieurs contrats d’assurance complémentaire santé avant de souscrire ?</u></b><br><br>
En matière d’assurance santé, il est très difficile de comparer plusieurs contrats, les tableaux de garanties ne reprenant pas toujours les mêmes <b>bases de remboursement.</b> Il convient donc d’être très vigilant sur les termes employés. Il est judicieux de comparer en priorité les remboursements <b>pour les postes sur lesquels vous avez le plus de dépenses</b> (optique, dentaire etc.).<br><br>
Quand un contrat indique un remboursement à 100 % du tarif de remboursement de la sécurité sociale, cela ne signifie pas que vous serez remboursé intégralement des frais que vous avez engagés, mais que l’assurance complémentaire santé vous remboursera le même montant que le remboursement de la sécurité sociale. Certains tableaux de garantie mentionnent les remboursements en y incluant le remboursement prévu de la sécurité sociale.<br><br>
Selon votre profil, il peut être important de considérer <b>les prestations prises en charge par l’assurance complémentaire santé</b> et tandis que celles-ci ne sont pas remboursées par l'Assurance maladie (par exemple l’ostéopathie, certains vaccins ou moyens contraceptifs, les traitements anti-tabac etc.). L’assurance complémentaire santé peut aussi proposer des services associés (par exemple en matière de prévention). Il convient enfin de souligner que le montant total du remboursement (Sécurité sociale + complémentaire santé) à percevoir ne pourra jamais être supérieur au montant des frais réellement engagés. »<br><br>

<p style="font-size:10px;">

<b>   Source : ABE Info Service (19/03/2019) : Que faut-il savoir sur le contrat d'assurance santé obligatoire ? (https://www.abe-
infoservice.fr/assurance/assurance-complementaire-sante/que-faut-il-savoir-sur-les-contrats-dassurance-sante-obligatoires)</b></p>

</div>

<p style="page-break-before:always;"></p>

<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>NOS PRECONISATIONS</b>
</p>

<p>
   
Suite aux informations que vous nous avez fourni quant à vos exigences et à vos besoins dans le mandat, vous trouverez ci-dessous l’étude et les préconisations réalisées par le cabinet
    <b><?= get_field('nom_du_cabinet', $source_id); ?></b> :
</p>

<b><i><u>Nombre de compagnies d'assurances comparées :</u></i></b>
<b style="color:darkblue;"><?= cpg_field('nb_cie_rap_sante', $post_id); ?></b><br><br>

<b><i><u>Nombre de devis effectués :</u></i></b>
<b style="color:darkblue;"><?= cpg_field('nb_sim_rap_sante', $post_id); ?></b><br><br>

<b><u>Résultats des études lors de notre mission:</u></b><br><br>

<table style="border:0.5px solid black; border-collapse: collapse; text-align:center;">
    <tr>
        <td style="width:213px;border:0.5px solid black;height:30px;"></td>
        <td style="width:213px;border:0.5px solid black;height:30px;"><b>Nom du contrat</b></td>
        <td style="width:213px;border:0.5px solid black;height:30px;"><b>Tarification</b></td>
    </tr>

    <tr>
        <td style="border:0.5px solid black;height:30px;"><b>Contrat n°1</b></td>
        <td style="border:0.5px solid black;height:30px;"><?= cpg_field('contrat_1_rap_sante', $post_id); ?></td>
        <td style="border:0.5px solid black;height:30px;">voir devis</td>
    </tr>

    <tr>
        <td style="border:0.5px solid black;height:30px;"><b>Contrat n°2</b></td>
        <td style="border:0.5px solid black;height:30px;"><?= cpg_field('contrat_2_rap_sante', $post_id); ?></td>
        <td style="border:0.5px solid black;height:30px;">voir devis</td>
    </tr>

    <tr>
        <td style="border:0.5px solid black;height:30px;"><b>Contrat n°3</b></td>
        <td style="border:0.5px solid black;height:30px;"><?= cpg_field('contrat_3_rap_sante', $post_id); ?></td>
        <td style="border:0.5px solid black;height:30px;">voir devis</td>
    </tr>
</table>

<br>
Parmi les différents contrats proposés sur ce tableau, voici ce que nous avons retenu : 
<b style="color:darkblue;"><?= cpg_field('retenu_rap_sante', $post_id); ?></b>
<br><br>

<p style="text-align:justify;">

<b><u>A savoir:</u></b><br>
<p style="text-align:justify;">  En qualité d’intermédiaire en assurance, il existe plusieurs niveaux de conseils régis par le régulateur. Selon ce dernier, il y
a trois niveaux qui sont les suivants :<br><br>
<b>« Le niveau 1 (obligatoire) : proposer un contrat cohérent (approprié) avec les besoins et exigences du client.</b>
L’intermédiaire doit préciser par écrit les exigences et les besoins du client. Il lui apporte des informations objectives afin
que celui-ci puisse prendre une décision en connaissance de cause, conseille un contrat cohérent avec les exigences et les
besoins précisés et indique les raisons qui motivent ce conseil.<br><br>
<b>Le niveau 2 (facultatif) : recommander le contrat qui correspond le mieux (adéquat) aux besoins et exigences du
client.</b> Le niveau 2 revient à fournir au client un service de recommandation personnalisée consistant à lui expliquer
pourquoi, parmi plusieurs contrats, un ou plusieurs contrats correspondent « le mieux » à ses exigences et ses besoins. Un
tel service ne se conçoit que si le distributeur est en mesure de présenter au client plusieurs contrats (ou options au sein
d’un contrat) qui tous, sont cohérents avec ses exigences et ses besoins ; puis il doit mener un travail d’analyse
comparative afin de distinguer parmi ces contrats, un ou plusieurs qui apparaissent optimaux pour le client<br><br>
<b>Le niveau 3 (facultatif) : recommander, sur la base d’une analyse impartiale. </b>Cette modalité se distingue de la seconde
par le fait que la recommandation est fondée sur une analyse impartiale et personnalisée d’un nombre suffisant de contrats
offerts sur le marché. Une telle promesse de service ne se conçoit donc que basée sur l’analyse d’une pluralité de contrats,
émanant de différents producteurs, en nombre et d’une nature tels qu’ils sont représentatifs des contrats offerts sur le
marché. »<br>
Le niveau de conseil qui a été appliqué dans la réalisation de cette étude et de nos préconisations par le cabinet <?= get_field('nom_du_cabinet', $source_id); ?> a été le suivant : <b style="color:darkblue;"><?= cpg_field('niveau_rap_sante', $post_id); ?></b></p>

<p style="page-break-before:always;"></p>

<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>COMPTE RENDU DE LA MISSION</b>
</p>

<div style="text-align:justify;">
Notre accompagnement à vos côtés consiste à vous conseiller un contrat qui est cohérent avec les exigences et les besoins que vous avez exprimés.<br><br>
L’étude réalisée avec vous tient compte de votre situation familiale, professionnelle et de votre régime obligatoire. Le produit proposé répond aux besoins que vous avez exprimés en matière de couverture complémentaire santé, ainsi qu’au budget souhaité (voir votre recueil d’informations).<br><br>
L’estimation tarifaire, vous sera remise avec la présente. Il s’agit d’un devis qui présente le contrat et le niveau proposé, les garanties, les prestations et la cotisation TTC. Elle est complétée par la Notice valant Conditions Générales et le Document d’Information Produit relatifs au contrat proposé. Ces documents précisent le contenu de l’ensemble des garanties, leurs limites et les conditions de mise en œuvre.<br><br>
Aussi précis que soient les informations et les conseils qui vous ont été donnés, il est très important que vous lisiez attentivement ces documents. La Notice valant conditions générales et la demande d’adhésion constituent les documents juridiques contractuels exprimant les droits et obligations de l’assuré/adhérent et de l’assureur.<br><br>
Nous attirons votre attention sur l’importance de la sincérité des réponses que vous apportez aux questions posées par l’assureur lors de la souscription au contrat. Toute fausse déclaration peut vous exposer à une annulation de votre contrat et à l’absence de couverture en cas de sinistre.<br>

<p style="text-align:center; font-size:20px;background-color:lightgrey;">
    <b>RAPPORT D'ADEQUATION</b>
</p>
Dans le cadre de notre étude, nous avons réalisé (ci-dessous) un rapport d’adéquation à partir de votre situation initiale et nos préconisations. En qualité de conseil, ce rapport nous permet de formaliser le degré de concordance entre vos exigences et vos besoins dont vous n’avez fait part (rappel voir questionnaire client ) ainsi que les solutions que nous vous proposons de mettre en place pour y répondre.</div><br><br>

<b><u>La solution préconisée est-elle conforme à mes objectifs et à mes attentes ?</u></b><br>
<b style="color:darkblue;"><?= cpg_field('solution_preco_confo_rap_sante', $post_id); ?></b><br><br>

<b><u>La solution préconisée est-elle en adéquation avec ma situation et mes besoins ?</u></b><br>
<b style="color:darkblue;"><?= cpg_field('solution_preco_adeq_rap_sante', $post_id); ?></b><br><br>

<b><u>Est-ce que la solution préconisée correspond au budget que j’ai initialement envisagé ?</u></b><br>
<b style="color:darkblue;"><?= cpg_field('solution_preco_budget_rap_sante', $post_id); ?></b><br><br>

<b><u>Y a-t-il des demandes en garanties que j’ai exprimé auxquelles vous n’avez pas pu répondre ?</u></b><br>
<b><u>Demandes non satisfaites ?</u></b><br>
<b style="color:darkblue;"><?= cpg_field('autres_demandes_rap_sante', $post_id); ?></b><br><br>

<div style="text-align:justify;">
<b style="color:grey"><i><u>Si oui, nous le mentionnerons dans nos observations complémentaires</u></i></b><br><br>

<div style="text-align:justify">Ci-dessous, nous pouvons porter un certain nombre d’éléments à votre attention et qui ont motivé nos préconisations :<br><?= cpg_field('coms_rap_sante', $post_id); ?>
</div>

<p style="page-break-before:always;"></p>


<?php endif; ?>


<?php if (in_array('ASSURANCE VIE', $suivis)) : ?>
    <div id="recto" style="text-align:center;vertical-align:middle;">
        <p style="text-align:left; font-size:20px;">
            <b>SUIVI DE MISSION - ASSURANCE VIE</b>
        </p>

    <?php
    $suivi_ass_vie_img_id  = (int) get_option('arc_media_suivi_ass_vie_id', 0);
    $suivi_ass_vie_img_url = $suivi_ass_vie_img_id ? wp_get_attachment_image_url($suivi_ass_vie_img_id, 'full') : '';

    if ($suivi_ass_vie_img_url) : ?>
        <img width="85%" src="<?= esc_url($suivi_ass_vie_img_url); ?>">
    <?php endif; ?>
    </div>

<p style="text-align:center; font-size:20px;">
    <b>DEVOIR DE SUIVI DE MISSION - ASSURANCE VIE</b>
</p>

<p>
<b><u>Objet:</u></b> Suivi de solution - Suivi d'adéquation
</p>

<p style="text-align:justify;">
<b><?= cpg_field('civilite', $post_id); ?> <?= cpg_field('prenom_client', $post_id); ?> <?= cpg_field('nom_client', $post_id); ?></b><br><br>

Vous avez souscrit à un contrat d’assurance-vie avec notre cabinet. Conformément à l’article L.132-22 du code des assurances,
l’assureur teneur de votre compte doit vous adresser chaque année un relevé de situation sur lequel vous pouvez mesurer
l’évolution de votre épargne.<br><br>
Notre qualité d’intermédiaire conseil nous oblige conformément à nos engagements, à vous fournir aujourd’hui à travers la
présente, un suivi de mission relatif à cet investissement. Il s’agit de réaliser ensemble un point d’avancement quant aux
évolutions éventuelles de vos attentes et objectifs concernant ce contrat. Aussi, nous vous invitons à nous signaler d’éventuels
changements concernant votre situation personnelle et patrimoniale. C’est aussi pour vous, l’occasion de procéder à des
modifications concernant votre contrat.   </p><br><br>
<b>DISPOSITIONS DIVERSES</b><br><br>

<b><u>Le conseiller doit disposer des informations patrimoniales et financières relatives à son client afin de pouvoir mener à bien
ses missions etses obligations de devoir d’information et de conseil.<br><br>
Vous certifiez la validité des informations que vous nous avez transmises, sachant que toute erreur ou omission de votre
part, peut conduire à des conclusions erronées sans pour autant que notre responsabilité puisse être engagée.
Vous êtes invité(e) à signaler les éléments qui vous paraissent présenter des incohérences.<br><br>
Vous reconnaissez alors avoir été averti(e) des conséquences d'un refus de fournir les informations personnelles vous
concernant.<br><br>
Nous rappelons que le conseiller est tenu au respect du secret professionnel.</u></b><br><br><br>

<b style="color:darkblue;">I. &nbsp;&nbsp;&nbsp;      RAPPEL DES CONDITIONS DE SOUSCRIPTION</b><br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   <b style="color:darkblue;"><i>   a. &nbsp;&nbsp;&nbsp;   Intervention et mission initiale</i></b><br><br>

• Vous assister dans l’analyse de votre situation<br>
• Vous conseiller sur le profilage de risque concernant votre investissement<br>
• Etablir une liste de recommandation(s) et préconisation(s) relative(s) à votre situation<br>
•Etudier et présenter une sélection de contrat(s) d’assurance-vie en adéquation avec vos objectifs, vos besoins et votre
situation particulière.<br>
• Rédiger un rapport d’adéquation entre la ou les solution(s) présentée(s)<br>
• Vous assister dans la préparation des documents nécessaires à la souscription d’une solution et s’assurer de la bonne
fin de la souscription du contrat.<br>
• Assurer un suivi au minimum une fois par an, pour valider que la ou les solution(s) mise(s) en place est/sont toujours
en adéquation avec votre situation personnelle.<br><br>

Conformément à nos engagements, nous vous fournissons à travers la présente un suivi de mission relatif à votre
investissement particulier :<br><br>

Contrat : <b><?= cpg_field('nom_suivi_ass_vie', $post_id); ?></b><br>
Référence numéro : <b><?= cpg_field('num_suivi_ass_vie', $post_id); ?></b><br>
Souscrit auprès de : <b><?= cpg_field('cie_suivi_ass_vie', $post_id); ?></b><br><br>

<b style="color:darkblue;"><i>b.&nbsp;&nbsp;&nbsp; Spécificités de nos recommandations</i></b><br><br>

Dans le cadre de notre gouvernance interne sur la sélection des produits distribués par notre cabinet, et conformément à
l’application de notre politique visant à maîtriser le risque de conflit d’intérêts, nous vous rappelons que le cabinet <?= get_field('nom_du_cabinet', $source_id); ?> décrit systématiquement dans son devoir de conseil et d’adéquation les choix et les raisons qui ont motivé ses
préconisations. Il organise également la gestion des portefeuilles de ses clients en parfaite adéquation avec leur profil de risque,
tout en respectant leurs objectifs, attentes et besoins.<br><br>
En cas de notification d’opposition de votre part, <?= get_field('nom_du_cabinet', $source_id); ?> s’engage à vous proposer une solution alternative, choisie
parmises partenaires conventionnés, en adéquation avec vos exigences et vos objectifs.<br><br>

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   <b style="color:darkblue;"><i>   c.&nbsp;&nbsp;&nbsp; Rappel de la situation financière et patrimoniale lors de la souscription</i></b><br><br>

Nous vous rappelons que toute modification des informations figurant dans le questionnaire client initial peut affecter
significativement la nature ou l'orientation de notre mission, et de votre investissement. Par conséquent, tout changement doit
et devra être porté à notre connaissance.<br><br>

<b style="color:darkblue;">II. &nbsp;&nbsp;&nbsp;     CADRE DE LA SOUSCRIPTION INITIALE</b><br><br>

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   <b style="color:darkblue;"><i>   a.&nbsp;&nbsp;&nbsp; Rappel des objectifs lors de la souscription</i></b><br><br>

<b><u>Solution d’investissement envisagée :</u></b><br><br>

<b>Valorisation de l’encours :</b>
<div style="color:darkblue;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?= cpg_field('valorisation_suivi_ass_vie', $post_id); ?> €</div><br>

<b>Montant des versements périodiques :</b>
<div style="color:darkblue;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?= cpg_field('montant_per_suivi_ass_vie', $post_id); ?> €</div><br>

<b>Horizon de temps restant :</b>
<div style="color:darkblue;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?= cpg_field('horizon_suivi_ass_vie', $post_id); ?></div><br>

<b>Si versements périodiques, précisez la périodicité :</b>
<div style="color:darkblue;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?= cpg_field('periodicite_suivi_ass_vie', $post_id); ?></div><br><br>

<b><u>Concernant cet investissement précis, vous avez comme objectif(s) :</u></b><br>
<div style="color:darkblue;"><?= cpg_field('obj_lies_suivi_ass_vie', $post_id); ?></div>
<p style="page-break-before:always;"></p>


<b><u>Concernant cet investissement précis, pourriez-vous préciser l’orientation à lui conférer ?</u></b><br>  <br>
Merci de préciser l’intitulé qui correspondrait le mieux au risque que vous seriez capable de supporter à priori pour votre
investissement.   <br>

        <div style="text-align:center;">
    <?php
    if ($tab_niveau_img_url) : ?>
        <img width="85%" src="<?= esc_url($tab_niveau_img_url); ?>">
    <?php endif; ?>
</div><br><br>

Vous avez sélectionné : <b><?= cpg_field('orientation_suivi_ass_vie', $post_id); ?></b><br><br>

<b><u>Évaluation de vos connaissances et expériences personnelles</u></b><br><br>

<table style="border:2px solid black;margin:8px;padding:8px;border-collapse:collapse;">
<tr>
    <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;border-collapse:collapse;">Connaissances financières</td>
    <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;border-collapse:collapse;">Expérience Assurance-vie</td>
    <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;border-collapse:collapse;">Expérience unités de compte</td>
</tr>
<tr>
    <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;border-collapse:collapse;color:darkblue;"><?= cpg_field('connaissances_financieres_suivi_ass_vie', $post_id); ?></td>
    <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;border-collapse:collapse;color:darkblue;"><?= cpg_field('exp_ass_vie_suivi_ass_vie', $post_id); ?></td>
    <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;border-collapse:collapse;color:darkblue;"><?= cpg_field('exp_uc_suivi_ass_vie', $post_id); ?></td>
</tr>
</table>

<p style="text-align:justify;">  En qualité d’intermédiaire en assurance, il existe plusieurs niveaux de conseils régis par le régulateur. Selon ce dernier, il y
a trois niveaux qui sont les suivants :<br><br>
<b>« Le niveau 1 (obligatoire) : proposer un contrat cohérent (approprié) avec les besoins et exigences du client.</b>
L’intermédiaire doit préciser par écrit les exigences et les besoins du client. Il lui apporte des informations objectives afin
que celui-ci puisse prendre une décision en connaissance de cause, conseille un contrat cohérent avec les exigences et les
besoins précisés et indique les raisons qui motivent ce conseil.<br><br>
<b>Le niveau 2 (facultatif) : recommander le contrat qui correspond le mieux (adéquat) aux besoins et exigences du
client.</b> Le niveau 2 revient à fournir au client un service de recommandation personnalisée consistant à lui expliquer
pourquoi, parmi plusieurs contrats, un ou plusieurs contrats correspondent « le mieux » à ses exigences et ses besoins. Un
tel service ne se conçoit que si le distributeur est en mesure de présenter au client plusieurs contrats (ou options au sein
d’un contrat) qui tous, sont cohérents avec ses exigences et ses besoins ; puis il doit mener un travail d’analyse
comparative afin de distinguer parmi ces contrats, un ou plusieurs qui apparaissent optimaux pour le client<br>
<b>Le niveau 3 (facultatif) : recommander, sur la base d’une analyse impartiale. </b>Cette modalité se distingue de la seconde
par le fait que la recommandation est fondée sur une analyse impartiale et personnalisée d’un nombre suffisant de contrats
offerts sur le marché. Une telle promesse de service ne se conçoit donc que basée sur l’analyse d’une pluralité de contrats,
émanant de différents producteurs, en nombre et d’une nature tels qu’ils sont représentatifs des contrats offerts sur le
marché. »<br><br>
Le niveau de conseil qui a été appliqué dans la réalisation de cette étude et de nos préconisations par le cabinet <?= get_field('nom_du_cabinet', $source_id); ?> a été le suivant :<b style="color:darkblue;"><?= cpg_field('niveau_suivi_ass_vie', $post_id); ?></b>
</p>

<b style="color:darkblue;"><i>Actualisation de votre situation patrimoniale</i></b><br><br>

Vos informations patrimoniales sont enregistrées à la date du <b><?= cpg_field('date_du_jour', $post_id); ?></b>.<br><br>

 <table style="border: 2px solid black;margin:8px;padding:8px;">


<tr style="background-color:lightgrey"> <th style="width:320px;text-align:center;padding:10px;">Vos informations personnelles</th> <th style="width:320px;text-align:center;padding:10px;">Informations personnelles de votre conjoint(e)</th> </tr>
<tr> <td>Civilité: <b><?= cpg_field('civilite', $post_id); ?></b></td> <td>Civilité: <b><?= cpg_field('civilite_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Prénom: <b><?= cpg_field('prenom_client', $post_id); ?></b></td> <td>Prénom: <b><?= cpg_field('prenom_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Nom: <b><?= cpg_field('nom_client', $post_id); ?></b></td> <td>Nom: <b><?= cpg_field('nom_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Date et lieu de naissance: <b><?= cpg_field('date_naissance_client', $post_id); ?></b> à <b><?= cpg_field('lieu_naissance_client', $post_id); ?></b></td> <td>Date et lieu de naissance: <b><?= cpg_field('date_naissance_conjoint', $post_id); ?></b> à <b><?= cpg_field('lieu_naissance_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Profession: <b><?= cpg_field('profession_client', $post_id); ?></b></td> <td>Profession: <b><?= cpg_field('profession_conjoint', $post_id); ?></b></td> </tr>
<tr> <th style="text-align:left; padding:10px;background-color:lightgrey">Votre situation familiale / patrimoniale</th> </tr>
<tr> <td>Situation familiale: <b><?= cpg_field('situation_fam_client', $post_id); ?></b></td> </tr>
<tr> <td>Personne(s) à charge: <b><?= cpg_field('charge_client', $post_id); ?></b></td> </tr>
<tr> <td>Statut patrimonial: <b><?= cpg_field('statut_pat_client', $post_id); ?></b></td> </tr>
</table>
<br>

<b style="color:darkblue;"><u><i>Actualisation de vos informations et objectifs</i></u></b><br><br>

<b><u>Y a-t-il des changements significatifs dans la situation du client ?</u></b><br>
<div style="color:darkblue;"><?= cpg_field('changements_suivi_ass_vie', $post_id); ?></div><br>

<b><u>Y a-t-il des éléments qui justifieraient un ou plusieurs arbitrages de l’allocation d’actifs du contrat ?</u></b><br>
<div style="color:darkblue;"><?= cpg_field('elements_suivi_ass_vie', $post_id); ?></div><br>

<b><u>Quelles sont les modifications à apporter au contrat ?</u></b><br>
<div style="color:darkblue;"><?= cpg_field('modifs_suivi_ass_vie', $post_id); ?></div><br>

<b>En cas de de réalisation / modification de versements, veuillez décrire le cadre dans lesquels ils seront effectués
(Préciser le montant, la périodicité, les supports d’investissement sur lesquels les versements vont être réalisés ou
réorientés ... )</b><br>
<div style="color:darkblue;"><?= cpg_field('versements_suivi_ass_vie', $post_id); ?></div><br>

<b>Informations complémentaires et descriptions des informations</b><br>
<div style="color:darkblue;"><?= cpg_field('coms_suivi_ass_vie', $post_id); ?></div><br>

<b>Suivi de l'adéquation :</b><br>
<div style="color:darkblue;"><?= cpg_field('adeq_suivi_ass_vie', $post_id); ?></div>

<p style="page-break-before:always;"></p>

<?php endif; ?>

<?php if (in_array('COMPLÉMENTAIRE RETRAITE', $suivis)) : ?>
    <div id="recto" style="text-align:center;vertical-align:middle;">
        <p style="text-align:left; font-size:20px;">
            <b>SUIVI DE MISSION - COMPLÉMENTAIRE RETRAITE</b>
        </p>

    <?php
    $suivi_retraite_img_id  = (int) get_option('arc_media_suivi_retraite_id', 0);
    $suivi_retraite_img_url = $suivi_retraite_img_id ? wp_get_attachment_image_url($suivi_retraite_img_id, 'full') : '';

    if ($suivi_retraite_img_url) : ?>
        <img width="85%" src="<?= esc_url($suivi_retraite_img_url); ?>">
    <?php endif; ?>
    </div>

<p style="text-align:center; font-size:20px;">
    <b>DEVOIR DE SUIVI DE MISSION - COMPLÉMENTAIRE RETRAITE</b>
</p>

<p><b><u>Objet:</u></b> Suivi de solution - Suivi d'adéquation</p>

<p style="text-align:justify;">
<b><?= cpg_field('civilite', $post_id); ?> <?= cpg_field('prenom_client', $post_id); ?> <?= cpg_field('nom_client', $post_id); ?> </b><br><br>

Vous avez souscrit à un contrat complémentaire retraite avec notre cabinet. Conformément à l’article L.132-22 du code des
assurances, l’assureur teneur de votre compte doit vous adresser chaque année un relevé de situation sur lequel vous pouvez
mesurer l’évolution de votre épargne.<br><br>
Notre qualité d’intermédiaire conseil nous oblige conformément à nos engagements, à vous fournir aujourd’hui à travers la
présente, un suivi de mission relatif à cet investissement. Il s’agit de réaliser ensemble un point d’avancement quant aux
évolutions éventuelles de vos attentes et objectifs concernant ce contrat. Aussi, nous vous invitons à nous signaler d’éventuels
changements concernant votre situation personnelle et patrimoniale. C’est aussi pour vous, l’occasion de procéder à des
modifications concernant votre contrat.  </p> <br><br>
<b>DISPOSITIONS DIVERSES</b><br><br>

<b><u>Le conseiller doit disposer des informations patrimoniales et financières relatives à son client afin de pouvoir mener à bien
ses missions etses obligations de devoir d’information et de conseil.<br><br>
Vous certifiez la validité des informations que vous nous avez transmises, sachant que toute erreur ou omission de votre
part, peut conduire à des conclusions erronées sans pour autant que notre responsabilité puisse être engagée.
Vous êtes invité(e) à signaler les éléments qui vous paraissent présenter des incohérences.<br><br>
Vous reconnaissez alors avoir été averti(e) des conséquences d'un refus de fournir les informations personnelles vous
concernant.<br><br>
Nous rappelons que le conseiller est tenu au respect du secret professionnel.</u></b><br><br><br>

<b style="color:darkblue;">I. &nbsp;&nbsp;&nbsp;      RAPPEL DES CONDITIONS DE SOUSCRIPTION</b><br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   <b style="color:darkblue;"><i>   a. &nbsp;&nbsp;&nbsp;   Intervention et mission initiale</i></b><br><br>

• Vous assister dans l’analyse de votre situation<br>
• Vous conseiller sur le profilage de risque concernant votre investissement<br>
• Etablir une liste de recommandation(s) et préconisation(s) relative(s) à votre situation<br>
•Etudier et présenter une sélection de contrat(s) d’assurance-vie en adéquation avec vos objectifs, vos besoins et votre
situation particulière.<br>
• Rédiger un rapport d’adéquation entre la ou les solution(s) présentée(s)<br>
• Vous assister dans la préparation des documents nécessaires à la souscription d’une solution et s’assurer de la bonne
fin de la souscription du contrat.<br>
• Assurer un suivi au minimum une fois par an, pour valider que la ou les solution(s) mise(s) en place est/sont toujours
en adéquation avec votre situation personnelle.<br><br>

Conformément à nos engagements, nous vous fournissons à travers la présente un suivi de mission relatif à votre
investissement particulier :<br><br>

Contrat : <b><?= cpg_field('nom_contrat_suivi_retraite', $post_id); ?></b><br>
Référence numéro : <b><?= cpg_field('num_contrat_suivi_retraite', $post_id); ?></b><br>
Souscrit auprès de : <b><?= cpg_field('nom_cie_suivi_retraite', $post_id); ?></b><br><br>


<b style="color:darkblue;"><i>b.&nbsp;&nbsp;&nbsp; Spécificités de nos recommandations</i></b><br><br>

Dans le cadre de notre gouvernance interne sur la sélection des produits distribués par notre cabinet, et conformément à
l’application de notre politique visant à maîtriser le risque de conflit d’intérêts, nous vous rappelons que le cabinet
<b><?= cpg_field('nom_du_cabinet', $source_id); ?></b>
décrit systématiquement dans son devoir de conseil et d’adéquation les choix et les raisons qui ont motivé ses
préconisations. Il organise également la gestion des portefeuilles de ses clients en parfaite adéquation avec leur profil de risque,
tout en respectant leurs objectifs, attentes et besoins.<br><br>
En cas de notification d’opposition de votre part, <?= cpg_field('nom_du_cabinet', $source_id); ?> s’engage à vous proposer une solution alternative, choisie
parmises partenaires conventionnés, en adéquation avec vos exigences et vos objectifs.<br><br>

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   <b style="color:darkblue;"><i>   c.&nbsp;&nbsp;&nbsp; Rappel de la situation financière et patrimoniale lors de la souscription</i></b><br><br>

Nous vous rappelons que toute modification des informations figurant dans le questionnaire client initial peut affecter
significativement la nature ou l'orientation de notre mission, et de votre investissement. Par conséquent, tout changement doit
et devra être porté à notre connaissance.<br><br>

<b style="color:darkblue;">II. &nbsp;&nbsp;&nbsp; CADRE DE LA SOUSCRIPTION INITIALE</b><br><br>

<b style="color:darkblue;"><i>a.&nbsp;&nbsp;&nbsp; Rappel des objectifs lors de la souscription</i></b><br><br>

<b><u>Solution d’investissement envisagée :</u></b><br><br>

<b>Enveloppe fiscale :</b><br>
<div style="color:darkblue;"><?= cpg_field('enveloppe_suivi_retraite', $post_id); ?></div><br>

<b>Valorisation de l’encours :</b><br>
<div style="color:darkblue;"><?= cpg_field('valo_suivi_retraite', $post_id); ?> €</div><br>

<b>Montant des versements périodiques :</b><br>
<div style="color:darkblue;"><?= cpg_field('montant_vers_suivi_retraite', $post_id); ?> €</div><br>

<b>Horizon de temps restant :</b><br>
<div style="color:darkblue;"><?= cpg_field('horizon_suivi_retraite', $post_id); ?></div><br>

<b>Si versements périodiques, précisez la périodicité :</b><br>
<div style="color:darkblue;"><?= cpg_field('periodicite_suivi_retraite', $post_id); ?></div><br>

<b><u>Concernant cet investissement précis, vous avez comme objectif(s) :</u></b><br>
<?= cpg_field('obj_lies_suivi_retraite', $post_id); ?><br><br>
<p style="page-break-before:always;"></p>
<b><u>Concernant cet investissement précis, pourriez-vous préciser l’orientation à lui conférer ?</u></b><br>  <br>
Merci de préciser l’intitulé qui correspondrait le mieux au risque que vous seriez capable de supporter à priori pour votre
investissement.   <br>


        <div style="text-align:center;">
    <?php
    if ($tab_niveau_img_url) : ?>
        <img width="85%" src="<?= esc_url($tab_niveau_img_url); ?>">
    <?php endif; ?>
</div><br>

Vous avez sélectionné : <b><?= cpg_field('orientation_suivi_retraite', $post_id); ?></b><br><br>


<b><u>Évaluation de vos connaissances et expériences personnelles</u></b><br><br>

<table style="border: 2px solid black;margin:8px;padding:8px; border-collapse:collapse;">

<tr> <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;border-collapse:collapse;">Connaissances financières</td> <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;border-collapse:collapse;">Expérience en produits Retraite</td> <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;border-collapse:collapse;">Expérience en unités de compte</td> </tr>

<tr> <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;border-collapse:collapse;color:darkblue;"><?= cpg_field('connaissances_suivi_retraite', $post_id); ?></td > <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;border-collapse:collapse;color:darkblue;"><?= cpg_field('exp_ass_vie_suivi_retraite', $post_id); ?></td> <td style="width:213px;text-align:center;padding:10px;border: 1px solid black;border-collapse:collapse;color:darkblue;"><?= cpg_field('exp_uc_suivi_retraite', $post_id); ?></td> </tr>

</table>


<p style="text-align:justify;">  En qualité d’intermédiaire en assurance, il existe plusieurs niveaux de conseils régis par le régulateur. Selon ce dernier, il y
a trois niveaux qui sont les suivants :<br><br>
<b>« Le niveau 1 (obligatoire) : proposer un contrat cohérent (approprié) avec les besoins et exigences du client.</b>
L’intermédiaire doit préciser par écrit les exigences et les besoins du client. Il lui apporte des informations objectives afin
que celui-ci puisse prendre une décision en connaissance de cause, conseille un contrat cohérent avec les exigences et les
besoins précisés et indique les raisons qui motivent ce conseil.<br><br>
<b>Le niveau 2 (facultatif) : recommander le contrat qui correspond le mieux (adéquat) aux besoins et exigences du
client.</b> Le niveau 2 revient à fournir au client un service de recommandation personnalisée consistant à lui expliquer
pourquoi, parmi plusieurs contrats, un ou plusieurs contrats correspondent « le mieux » à ses exigences et ses besoins. Un
tel service ne se conçoit que si le distributeur est en mesure de présenter au client plusieurs contrats (ou options au sein
d’un contrat) qui tous, sont cohérents avec ses exigences et ses besoins ; puis il doit mener un travail d’analyse
comparative afin de distinguer parmi ces contrats, un ou plusieurs qui apparaissent optimaux pour le client<br>
<b>Le niveau 3 (facultatif) : recommander, sur la base d’une analyse impartiale. </b>Cette modalité se distingue de la seconde
par le fait que la recommandation est fondée sur une analyse impartiale et personnalisée d’un nombre suffisant de contrats
offerts sur le marché. Une telle promesse de service ne se conçoit donc que basée sur l’analyse d’une pluralité de contrats,
émanant de différents producteurs, en nombre et d’une nature tels qu’ils sont représentatifs des contrats offerts sur le
marché. »<br><br>
Le niveau de conseil qui a été appliqué dans la réalisation de cette étude et de nos préconisations par le cabinet <?= cpg_field('nom_du_cabinet', $source_id); ?> a été le suivant : <b style="color:darkblue;"><?= cpg_field('niveau_suivi_retraite', $post_id); ?></b></p><br><br>

<b style="color:darkblue;"><i>Actualisation de votre situation patrimoniale</i></b><br><br>

Vos informations patrimoniales sont enregistrées à la date du :
<b><?= cpg_field('date_du_jour', $post_id); ?></b><br><br>

      <table style="border: 2px solid black;margin:8px;padding:8px;">


<tr style="background-color:lightgrey"> <th style="width:320px;text-align:center;padding:10px;">Vos informations personnelles</th> <th style="width:320px;text-align:center;padding:10px;">Informations personnelles de votre conjoint(e)</th> </tr>
<tr> <td>Civilité: <b><?= cpg_field('civilite', $post_id); ?></b></td> <td>Civilité: <b><?= cpg_field('civilite_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Prénom: <b><?= cpg_field('prenom_client', $post_id); ?></b></td> <td>Prénom: <b><?= cpg_field('prenom_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Nom: <b><?= cpg_field('nom_client', $post_id); ?></b></td> <td>Nom: <b><?= cpg_field('nom_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Date et lieu de naissance: <b><?= cpg_field('date_naissance_client', $post_id); ?></b> à <b><?= cpg_field('lieu_naissance_client', $post_id); ?></b></td> <td>Date et lieu de naissance: <b><?= cpg_field('date_naissance_conjoint', $post_id); ?></b> à <b><?= cpg_field('lieu_naissance_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Profession: <b><?= cpg_field('profession_client', $post_id); ?></b></td> <td>Profession: <b><?= cpg_field('profession_conjoint', $post_id); ?></b></td> </tr>
<tr> <th style="text-align:left; padding:10px;background-color:lightgrey">Votre situation familiale / patrimoniale</th> </tr>
<tr> <td>Situation familiale: <b><?= cpg_field('situation_fam_client', $post_id); ?></b></td> </tr>
<tr> <td>Personne(s) à charge: <b><?= cpg_field('charge_client', $post_id); ?></b></td> </tr>
<tr> <td>Statut patrimonial: <b><?= cpg_field('statut_pat_client', $post_id); ?></b></td> </tr>
</table>

<br><br>

<b style="color:darkblue;"><u><i>Actualisation de vos informations et objectifs</i></u></b><br><br>

<b><u>Y a-t-il des changements significatifs dans la situation du client ?</u></b><br>
<div style="color:darkblue;"><?= cpg_field('changements_suivi_retraite', $post_id); ?></div><br>

<b><u>Y a-t-il des éléments qui justifieraient un ou plusieurs arbitrages de l’allocation d’actifs du contrat ?</u></b><br>
<div style="color:darkblue;"><?= cpg_field('justifs_suivi_retraite', $post_id); ?></div><br>

<b><u>Quelles sont les modifications à apporter au contrat ?</u></b><br>
<div style="color:darkblue;"><?= cpg_field('modifs_suivi_retraite', $post_id); ?></div><br>

<b>En cas de de réalisation / modification de versements, veuillez décrire le cadre dans lesquels ils seront effectués
(Préciser le montant, la périodicité, les supports d’investissement sur lesquels les versements vont être réalisés ou
réorientés ... )</b><br>
<div style="color:darkblue;"><?= cpg_field('versements_suivi_retraite', $post_id); ?></div><br>

<b>Informations complémentaires et descriptions des informations</b><br>
<div style="color:darkblue;"><?= cpg_field('coms_suivi_retraite', $post_id); ?></div><br>

<b>Suivi de l’adéquation :</b><br>
<div style="color:darkblue;"><?= cpg_field('adeq_suivi_retraite', $post_id); ?></div><br>
<p style="page-break-before:always;"></p>
<?php endif; ?>

<?php if (in_array('PRÉVOYANCE', $suivis)) : ?>
   <div id="recto" style="text-align:center;vertical-align:middle;">
        <p style="text-align:left; font-size:20px;">
            <b>SUIVI DE MISSION - PRÉVOYANCE</b>
        </p>

           <?php
    $suivi_prev_img_id  = (int) get_option('arc_media_suivi_prev_id', 0);
    $suivi_prev_img_url = $suivi_prev_img_id ? wp_get_attachment_image_url($suivi_prev_img_id, 'full') : '';

    if ($suivi_prev_img_url) : ?>
        <img width="85%" src="<?= esc_url($suivi_prev_img_url); ?>">
    <?php endif; ?>
    </div>


<p style="text-align:center; font-size:20px;">
    <b>DEVOIR DE SUIVI DE MISSION – PRÉVOYANCE</b>
</p>

<p><b><u>Objet:</u></b> Suivi de solution - Suivi d'adéquation</p>

<p style="text-align:justify;">
    <b><?= cpg_field('civilite', $post_id).' '.cpg_field('prenom_client', $post_id).' '.cpg_field('nom_client', $post_id); ?></b><br><br>
Vous avez souscrit à un contrat de prévoyance avec notre cabinet. Conformément à l’article L.132-22 du code des
assurances, l’assureur teneur de votre compte doit vous adresser chaque année un relevé de situation sur lequel vous
pouvez mesurer l’évolution de votre épargne.<br><br>
Notre qualité d’intermédiaire conseil nous oblige conformément à nos engagements, à vous fournir aujourd’hui à travers
la présente, un suivi de mission relatif à ce contrat. Il s’agit de réaliser ensemble un point d’avancement quant aux
évolutions éventuelles de vos attentes et objectifs concernant ce contrat. Aussi, nous vous invitons à nous signaler
d’éventuels changements concernant votre situation personnelle et patrimoniale. C’est aussi pour vous, l’occasion de
procéder à des modifications concernant votre contrat. 
</p>

<br><br>
<b>DISPOSITIONS DIVERSES</b><br><br>

<b><u>Le conseiller doit disposer des informations patrimoniales et financières relatives à son client afin de pouvoir mener à
bien ses missions et ses obligations de devoir d’information et de conseil.<br><br>
Vous certifiez la validité des informations que vous nous avez transmises, sachant que toute erreur ou omission de
votre part, peut conduire à des conclusions erronées sans pour autant que notre responsabilité puisse être engagée.
Vous êtes invité(e) à signaler les éléments qui vous paraissent présenter des incohérences.<br><br>
Vous reconnaissez alors avoir été averti(e) des conséquences d'un refus de fournir les informations personnelles vous
concernant.<br><br>
Nous rappelons que le conseiller est tenu au respect du secret professionnel.</u></b><br><br><br>

<b style="color:darkblue;">I. &nbsp;&nbsp;&nbsp;      RAPPEL DES CONDITIONS DE SOUSCRIPTION</b><br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   <b style="color:darkblue;"><i>   a. &nbsp;&nbsp;&nbsp;   Intervention et mission initiale</i></b><br><br>

•     Vous assister dans l’analyse de votre situation<br>
•     Etablir une liste de recommandation(s) et préconisation(s) relative(s) à votre situation<br>
•     Etudier et présenter une sélection de contrat(s) de prévoyance en adéquation avec vos objectifs, vos besoins et votre
situation particulière.<br>
•     Rédiger un rapport d’adéquation entre la ou les solution(s) présentée(s)<br>
•     Vous assister dans la préparation des documents nécessaires à la souscription d’une solution et s’assurer de la bonne
fin de la souscription du contrat.<br>
•     Assurer un suivi au minimum une fois par an, pour valider que la ou les solution(s) mise(s) en place est/sont toujours
en adéquation avec votre situation personnelle.<br><br>

Conformément à nos engagements, nous vous fournissons à travers la présente un suivi de mission relatif à votre contrat :<br><br>

Contrat : <b><?= cpg_field('nom_contrat_suivi_prev', $post_id); ?></b><br>
Référence numéro : <b><?= cpg_field('num_contrat_suivi_prev', $post_id); ?></b><br>
Souscrit auprès de : <b><?= cpg_field('nom_cie_suivi_prev', $post_id); ?></b><br><br>

<b style="color:darkblue;"><i>b.&nbsp;&nbsp;&nbsp; Spécificités de nos recommandations</i></b><br><br>

Dans le cadre de notre gouvernance interne sur la sélection des produits distribués par notre cabinet, et conformément à
l’application de notre politique visant à maîtriser le risque de conflit d’intérêts, nous vous rappelons que le cabinet <?= get_field('nom_du_cabinet', $source_id); ?> décrit systématiquement dans son devoir de conseil et d’adéquation les choix et les raisons qui ont motivé
ses préconisations. Il organise également la gestion des portefeuilles de ses clients en parfaite adéquation avec leur profil
de risque, tout en respectant leurs objectifs, attentes et besoins.<br><br>
En cas de notification d’opposition de votre part, <?= get_field('nom_du_cabinet', $source_id); ?> s’engage à vous proposer une solution alternative,
choisie parmi ses partenaires conventionnés, en adéquation avec vos exigences et vos objectifs.<br><br>

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   <b style="color:darkblue;"><i>   c.&nbsp;&nbsp;&nbsp; Rappel de la situation financière et patrimoniale lors de la souscription</i></b><br><br>

Nous vous rappelons que toute modification des informations figurant dans le questionnaire client initial peut affecter
significativement la nature ou l'orientation de notre mission, et de votre investissement. Par conséquent, tout changement
doit et devra être porté à notre connaissance.<br><br>

<b style="color:darkblue;">II. &nbsp;&nbsp;&nbsp;     CADRE DE LA SOUSCRIPTION INITIALE</b><br><br>

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   <b style="color:darkblue;"><i>   a.&nbsp;&nbsp;&nbsp; Rappel des objectifs lors de la souscription</i></b><br><br>

<b><u>Solution envisagée :</u></b>
<br><br>

<b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Domaine(s) de couverture initialement souhaitée(s) :</b>
<div style="color:darkblue;"><?= cpg_field('couverture_suivi_prev', $post_id); ?></div><br>

<b>Objectifs initiaux :</b><br>
<div style="color:darkblue;"><?= cpg_field('obj_couv_suivi_prev', $post_id); ?></div><br>

<b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Prévoyance professionnelle envisagée :</b>
<div style="color:darkblue;"><?= cpg_field('ganraties_pro_prev_suivi_prev', $post_id); ?></div><br>

<b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Prévoyance individuelle famille envisagée :</b>
<div style="color:darkblue;"><?= cpg_field('garanties_perso_suivi_prev', $post_id); ?></div><br>

<b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Y a-t-il des demandes en garanties exprimées auxquelles nous n’avions pas pu répondre ?</b>
<div style="color:darkblue;"><?= cpg_field('demandes_suivi_prev', $post_id); ?></div><br>

<b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Tarif de la solution initiale :</b> 
<u style="color:darkblue;"><?= cpg_field('tarif_suivi_prev', $post_id); ?> €</u>

<br><br><br>

<p style="text-align:justify;">  En qualité d’intermédiaire en assurance, il existe plusieurs niveaux de conseils régis par le régulateur. Selon ce dernier, il y
a trois niveaux qui sont les suivants :<br><br>
<b>« Le niveau 1 (obligatoire) : proposer un contrat cohérent (approprié) avec les besoins et exigences du client.</b>
L’intermédiaire doit préciser par écrit les exigences et les besoins du client. Il lui apporte des informations objectives afin
que celui-ci puisse prendre une décision en connaissance de cause, conseille un contrat cohérent avec les exigences et les
besoins précisés et indique les raisons qui motivent ce conseil.<br><br>
<b>Le niveau 2 (facultatif) : recommander le contrat qui correspond le mieux (adéquat) aux besoins et exigences du
client.</b> Le niveau 2 revient à fournir au client un service de recommandation personnalisée consistant à lui expliquer
pourquoi, parmi plusieurs contrats, un ou plusieurs contrats correspondent « le mieux » à ses exigences et ses besoins. Un
tel service ne se conçoit que si le distributeur est en mesure de présenter au client plusieurs contrats (ou options au sein
d’un contrat) qui tous, sont cohérents avec ses exigences et ses besoins ; puis il doit mener un travail d’analyse
comparative afin de distinguer parmi ces contrats, un ou plusieurs qui apparaissent optimaux pour le client<br><br>
<b>Le niveau 3 (facultatif) : recommander, sur la base d’une analyse impartiale. </b>Cette modalité se distingue de la seconde
par le fait que la recommandation est fondée sur une analyse impartiale et personnalisée d’un nombre suffisant de contrats
offerts sur le marché. Une telle promesse de service ne se conçoit donc que basée sur l’analyse d’une pluralité de contrats,
émanant de différents producteurs, en nombre et d’une nature tels qu’ils sont représentatifs des contrats offerts sur le
marché. »<br><br>
Le niveau de conseil qui a été appliqué dans la réalisation de cette étude et de nos préconisations par le cabinet <?= cpg_field('nom_du_cabinet', $source_id); ?> a été le suivant : <b style="color:darkblue;"><?= cpg_field('niveau_suivi_prev', $post_id); ?></b></p><br><br>

<br><br>

<b style="color:darkblue;"><i>Actualisation de votre situation patrimoniale</i></b><br><br>

Vos informations patrimoniales inscrites ci-dessous sont enregistrées à la date du
<b><?= cpg_field('date_du_jour', $post_id); ?></b>

<br><br>

<table style="border: 2px solid black;margin:8px;padding:8px;">


<tr style="background-color:lightgrey"> <th style="width:320px;text-align:center;padding:10px;">Vos informations personnelles</th> <th style="width:320px;text-align:center;padding:10px;">Informations personnelles de votre conjoint(e)</th> </tr>
<tr> <td>Civilité: <b><?= cpg_field('civilite', $post_id); ?></b></td> <td>Civilité: <b><?= cpg_field('civilite_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Prénom: <b><?= cpg_field('prenom_client', $post_id); ?></b></td> <td>Prénom: <b><?= cpg_field('prenom_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Nom: <b><?= cpg_field('nom_client', $post_id); ?></b></td> <td>Nom: <b><?= cpg_field('nom_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Date et lieu de naissance: <b><?= cpg_field('date_naissance_client', $post_id); ?></b> à <b><?= cpg_field('lieu_naissance_client', $post_id); ?></b></td> <td>Date et lieu de naissance: <b><?= cpg_field('date_naissance_conjoint', $post_id); ?></b> à <b><?= cpg_field('lieu_naissance_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Profession: <b><?= cpg_field('profession_client', $post_id); ?></b></td> <td>Profession: <b><?= cpg_field('profession_conjoint', $post_id); ?></b></td> </tr>
<tr> <th style="text-align:left; padding:10px;background-color:lightgrey">Votre situation familiale / patrimoniale</th> </tr>
<tr> <td>Situation familiale: <b><?= cpg_field('situation_fam_client', $post_id); ?></b></td> </tr>
<tr> <td>Personne(s) à charge: <b><?= cpg_field('charge_client', $post_id); ?></b></td> </tr>
<tr> <td>Statut patrimonial: <b><?= cpg_field('statut_pat_client', $post_id); ?></b></td> </tr>
</table>

<br><br>

<b style="color:darkblue;"><i>Actualisation de vos informations et objectifs</i></b><br><br>

<b><u>Changements significatifs dans la situation du client :</u></b><br><br>
<div style="color:darkblue;"><?= cpg_field('changement_suivi_prev', $post_id); ?></div><br>

<b><u>Quels sont les nouveaux besoins du client ? :</u></b><br><br>
<div style="color:darkblue;"><?= cpg_field('nv_besoin_suivi_prev', $post_id); ?></div><br>

<b><u>Informations complémentaires et descriptions des informations</u></b><br><br>
<div style="color:darkblue;"><?= cpg_field('coms_suivi_prev', $post_id); ?></div><br>

<b><u>Suivi de l'adéquation</u></b><br><br>
<div style="color:darkblue;"><?= cpg_field('adeq_suivi_prev', $post_id); ?></div><br>

<p style="page-break-before:always;"></p>

<?php endif; ?>

<?php if (in_array('SANTÉ', $suivis)) : ?>
   <div id="recto" style="text-align:center;vertical-align:middle;">
        <p style="text-align:left; font-size:20px;">
            <b>SUIVI DE MISSION - COMPLÉMENTAIRE SANTÉ</b>
        </p>

    <?php
    $suivi_mut_img_id  = (int) get_option('arc_media_suivi_mut_id', 0);
    $suivi_mut_img_url = $suivi_mut_img_id ? wp_get_attachment_image_url($suivi_mut_img_id, 'full') : '';

    if ($suivi_mut_img_url) : ?>
        <img width="85%" src="<?= esc_url($suivi_mut_img_url); ?>">
    <?php endif; ?>
    </div>

<p style="text-align:center; font-size:20px;">
    <b>DEVOIR DE SUIVI DE MISSION – COMPLÉMENTAIRE SANTÉ</b>
</p>

<p>
    <b><u>Objet :</u></b> Suivi de solution – Suivi d’adéquation
</p>

<p style="text-align:justify;">
    <b><?= cpg_field('civilite', $post_id) . ' ' . cpg_field('prenom_client', $post_id) . ' ' . cpg_field('nom_client', $post_id); ?></b><br><br>

 Vous avez souscrit à un contrat de complémentaire santé avec notre cabinet. Conformément à l’article L.132-22 du code
des assurances, l’assureur teneur de votre compte doit vous adresser chaque année un relevé de situation sur lequel vous
pouvez mesurer l’évolution de votre épargne.<br><br>
Notre qualité d’intermédiaire conseil nous oblige conformément à nos engagements, à vous fournir aujourd’hui à travers
la présente, un suivi de mission relatif à ce contrat. Il s’agit de réaliser ensemble un point d’avancement quant aux
évolutions éventuelles de vos attentes et objectifs concernant ce contrat. Aussi, nous vous invitons à nous signaler
d’éventuels changements concernant votre situation personnelle et patrimoniale. C’est aussi pour vous, l’occasion de
procéder à des modifications concernant votre contrat.   </p><br><br>
<b>DISPOSITIONS DIVERSES</b><br><br>

<b><u>Le conseiller doit disposer des informations patrimoniales et financières relatives à son client afin de pouvoir mener à
bien ses missions et ses obligations de devoir d’information et de conseil.<br><br>
Vous certifiez la validité des informations que vous nous avez transmises, sachant que toute erreur ou omission de
votre part, peut conduire à des conclusions erronées sans pour autant que notre responsabilité puisse être engagée.
Vous êtes invité(e) à signaler les éléments qui vous paraissent présenter des incohérences.<br><br>
Vous reconnaissez alors avoir été averti(e) des conséquences d'un refus de fournir les informations personnelles vous
concernant.<br><br>
Nous rappelons que le conseiller est tenu au respect du secret professionnel.</u></b><br><br><br>

<b style="color:darkblue;">I. &nbsp;&nbsp;&nbsp;      RAPPEL DES CONDITIONS DE SOUSCRIPTION</b><br><br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   <b style="color:darkblue;"><i>   a. &nbsp;&nbsp;&nbsp;   Intervention et mission initiale</i></b><br><br>

•     Vous assister dans l’analyse de votre situation<br>
•     Etablir une liste de recommandation(s) et préconisation(s) relative(s) à votre situation<br>
•     Etudier et présenter une sélection de contrat(s) de prévoyance en adéquation avec vos objectifs, vos besoins et votre
situation particulière.<br>
•     Rédiger un rapport d’adéquation entre la ou les solution(s) présentée(s)<br>
•     Vous assister dans la préparation des documents nécessaires à la souscription d’une solution et s’assurer de la bonne
fin de la souscription du contrat.<br>
•     Assurer un suivi au minimum une fois par an, pour valider que la ou les solution(s) mise(s) en place est/sont toujours
en adéquation avec votre situation personnelle.<br><br>

Conformément à nos engagements, nous vous fournissons à travers la présente un suivi de mission relatif à votre contrat :<br><br>

Contrat : <b><?= cpg_field('nom_contrat_suivi_sante', $post_id); ?></b><br>
Référence numéro : <b><?= cpg_field('num_contrat_suivi_sante', $post_id); ?></b><br>
Souscrit auprès de : <b><?= cpg_field('nom_cie_suivi_sante', $post_id); ?></b><br><br>

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   <b style="color:darkblue;"><i>   b.&nbsp;&nbsp;&nbsp;    Spécificités de nos recommandations</i></b><br><br>

Dans le cadre de notre gouvernance interne sur la sélection des produits distribués par notre cabinet, et conformément à
l’application de notre politique visant à maîtriser le risque de conflit d’intérêts, nous vous rappelons que le cabinet <?= get_field('nom_du_cabinet', $source_id); ?> décrit systématiquement dans son devoir de conseil et d’adéquation les choix et les raisons qui ont motivé
ses préconisations. Il organise également la gestion des portefeuilles de ses clients en parfaite adéquation avec leur profil
de risque, tout en respectant leurs objectifs, attentes et besoins.<br><br>
En cas de notification d’opposition de votre part, <?= get_field('nom_du_cabinet', $source_id); ?> s’engage à vous proposer une solution alternative,
choisie parmi ses partenaires conventionnés, en adéquation avec vos exigences et vos objectifs.<br><br>

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   <b style="color:darkblue;"><i>   c.&nbsp;&nbsp;&nbsp; Rappel de la situation financière et patrimoniale lors de la souscription</i></b><br><br>

Nous vous rappelons que toute modification des informations figurant dans le questionnaire client initial peut affecter
significativement la nature ou l'orientation de notre mission, et de votre investissement. Par conséquent, tout changement
doit et devra être porté à notre connaissance.<br><br>

<b style="color:darkblue;">II. &nbsp;&nbsp;&nbsp;     CADRE DE LA SOUSCRIPTION INITIALE</b><br><br>

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   <b style="color:darkblue;"><i>   a.&nbsp;&nbsp;&nbsp; Rappel des objectifs lors de la souscription</i></b><br><br>

<b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Type de contrat santé souscrit :</b>
<div style="color:darkblue;"><?= cpg_field('type_suivi_sante', $post_id); ?></div><br>

<b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Y a-t-il des demandes en garanties exprimées auxquelles nous n’avions pas pu répondre ?</b>
<div style="color:darkblue;"><?= cpg_field('demandes_suivis_sante', $post_id); ?></div><br>

<b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Tarif de la solution initiale :</b> <u style="color:darkblue;"><?= cpg_field('tariff_suivi_sante', $post_id); ?> €</u>

<br><br>

<p style="text-align:justify;">  En qualité d’intermédiaire en assurance, il existe plusieurs niveaux de conseils régis par le régulateur. Selon ce dernier, il y
a trois niveaux qui sont les suivants :<br><br>
<b>« Le niveau 1 (obligatoire) : proposer un contrat cohérent (approprié) avec les besoins et exigences du client.</b>
L’intermédiaire doit préciser par écrit les exigences et les besoins du client. Il lui apporte des informations objectives afin
que celui-ci puisse prendre une décision en connaissance de cause, conseille un contrat cohérent avec les exigences et les
besoins précisés et indique les raisons qui motivent ce conseil.<br><br>
<b>Le niveau 2 (facultatif) : recommander le contrat qui correspond le mieux (adéquat) aux besoins et exigences du
client.</b> Le niveau 2 revient à fournir au client un service de recommandation personnalisée consistant à lui expliquer
pourquoi, parmi plusieurs contrats, un ou plusieurs contrats correspondent « le mieux » à ses exigences et ses besoins. Un
tel service ne se conçoit que si le distributeur est en mesure de présenter au client plusieurs contrats (ou options au sein
d’un contrat) qui tous, sont cohérents avec ses exigences et ses besoins ; puis il doit mener un travail d’analyse
comparative afin de distinguer parmi ces contrats, un ou plusieurs qui apparaissent optimaux pour le client<br><br>
<b>Le niveau 3 (facultatif) : recommander, sur la base d’une analyse impartiale. </b>Cette modalité se distingue de la seconde
par le fait que la recommandation est fondée sur une analyse impartiale et personnalisée d’un nombre suffisant de contrats
offerts sur le marché. Une telle promesse de service ne se conçoit donc que basée sur l’analyse d’une pluralité de contrats,
émanant de différents producteurs, en nombre et d’une nature tels qu’ils sont représentatifs des contrats offerts sur le
marché. »<br><br>
Le niveau de conseil qui a été appliqué dans la réalisation de cette étude et de nos préconisations par le cabinet <?= cpg_field('nom_du_cabinet', $source_id); ?> a été le suivant : <b style="color:darkblue;"><?= cpg_field('niveau_suivi_sante', $post_id); ?></b></p>


<p style="page-break-before:always;"></p>

<br><br><br>

<b style="color:darkblue;"><i>Actualisation de votre situation patrimoniale</i></b><br><br>

Vos informations patrimoniales inscrites ci-dessous sont enregistrées à la date du :
<b><?= cpg_field('date_du_jour', $post_id); ?></b><br><br>

<table style="border: 2px solid black;margin:8px;padding:8px;">


<tr style="background-color:lightgrey"> <th style="width:320px;text-align:center;padding:10px;">Vos informations personnelles</th> <th style="width:320px;text-align:center;padding:10px;">Informations personnelles de votre conjoint(e)</th> </tr>
<tr> <td>Civilité: <b><?= cpg_field('civilite', $post_id); ?></b></td> <td>Civilité: <b><?= cpg_field('civilite_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Prénom: <b><?= cpg_field('prenom_client', $post_id); ?></b></td> <td>Prénom: <b><?= cpg_field('prenom_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Nom: <b><?= cpg_field('nom_client', $post_id); ?></b></td> <td>Nom: <b><?= cpg_field('nom_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Date et lieu de naissance: <b><?= cpg_field('date_naissance_client', $post_id); ?></b> à <b><?= cpg_field('lieu_naissance_client', $post_id); ?></b></td> <td>Date et lieu de naissance: <b><?= cpg_field('date_naissance_conjoint', $post_id); ?></b> à <b><?= cpg_field('lieu_naissance_conjoint', $post_id); ?></b></td> </tr>
<tr> <td>Profession: <b><?= cpg_field('profession_client', $post_id); ?></b></td> <td>Profession: <b><?= cpg_field('profession_conjoint', $post_id); ?></b></td> </tr>
<tr> <th style="text-align:left; padding:10px;background-color:lightgrey">Votre situation familiale / patrimoniale</th> </tr>
<tr> <td>Situation familiale: <b><?= cpg_field('situation_fam_client', $post_id); ?></b></td> </tr>
<tr> <td>Personne(s) à charge: <b><?= cpg_field('charge_client', $post_id); ?></b></td> </tr>
<tr> <td>Statut patrimonial: <b><?= cpg_field('statut_pat_client', $post_id); ?></b></td> </tr>
</table>

<br><br>

<b style="color:darkblue;"><i>Actualisation de vos informations et objectifs</i></b><br><br>

<b><u>Changements significatifs dans la situation du client :</u></b><br><br>
<div style="color:darkblue;"><?= cpg_field('changement_suivi_sante', $post_id); ?></div><br>

<b><u>Quels sont les nouveaux besoins du client ? :</u></b><br><br>
<div style="color:darkblue;"><?= cpg_field('nouveaux_besoins_suivi_sante', $post_id); ?></div><br>

<b><u>Informations complémentaires et descriptions des informations</u></b><br><br>
<div style="color:darkblue;"><?= cpg_field('coms_suivi_sante', $post_id); ?></div><br>

<b>Suivi de l’adéquation :</b>
<div style="color:darkblue;"><?= cpg_field('adeq_suivi_sante', $post_id); ?></div><br>

<?php endif; ?>




<p style="page-break-before:always;"></p>


<p>Fait en deux exemplaires.</p>
Le <?= esc_html($date_du_jour); ?>.<br><br>

<table>
    <tr>
        <td style="width:320px;">Le client</td>
        <td style="width:320px;">Le conseiller</td>
    </tr>
    <tr>
        <td><br><?= esc_html(cpg_field('civilite', $post_id) . ' ' . $prenom_client . ' ' . $nom_client); ?></td>
        <td><br><?= esc_html($nom_conseiller); ?></td>
    </tr>
    <tr>
        <td><br>Signature</td>
        <td><br>Signature</td>
    </tr>
    <tr>
        <td style="padding-top:25px;">
            <!-- 🔥 Balise Docusign pour signature du client -->
            <span style="font-size:1px; color:white;">/signature_client/</span>
        </td>
        <td style="padding-top:25px;">
            <!-- 🔥 Balise Docusign pour signature du conseiller -->
            <span style="font-size:1px; color:white;">/signature_conseiller/</span>
        </td>
    </tr>
</table>


<br><br><br><br>
<p style="text-align:center;"><b>Bon pour acceptation</b></p>

</body>
</html>
