"use strict";
(function () {
	function normalize(text) {
		return text ? String(text).toLowerCase() : "";
	}

	function toArray(listLike) {
		try {
			return Array.prototype.slice.call(listLike);
		} catch (e) {
			var arr = [];
			for (var i = 0; i < listLike.length; i++) {
				arr.push(listLike[i]);
			}
			return arr;
		}
	}

	function applyFilter(items, query, getText, toggle, onEmpty) {
		var q = normalize(query || "");
		var total = 0;
		var visibleCount = 0;
		if (!items) {
			if (onEmpty) onEmpty(false, 0);
			return;
		}
		var arr = typeof items.length === "number" ? toArray(items) : [items];
		for (var i = 0; i < arr.length; i++) {
			var el = arr[i];
			if (!el) {
				continue;
			}
			total++;
			var visible = true;
			if (q) {
				var hay = getText ? String(getText(el)) : (el.textContent || "");
				visible = normalize(hay).indexOf(q) !== -1;
			}
			if (typeof toggle === "function") {
				toggle(el, visible);
			} else {
				el.style.display = visible ? "" : "none";
			}
			if (visible) {
				visibleCount++;
			}
		}
		if (typeof onEmpty === "function") {
			onEmpty(visibleCount > 0, total);
		}
	}

	window.DSHFilters = {
		applyFilter: applyFilter,
		normalize: normalize,
	};
})();
