<?php

// SPDX-FileCopyrightText: 2022-2025 Ovation S.r.l. <help@dynamic.ooo>
// SPDX-License-Identifier: LicenseRef-GPL-3.0-with-dynamicooo-additional-terms
namespace DynamicShortcodes\Core\Settings\AdminPages;

use DynamicShortcodes\Plugin;
use DSHDeps\DynamicOOO\PluginUtils\AdminPages\Pages\Base;

class GettingStarted extends Base {

	public function render_content() {

		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}
		update_option( 'dsh_onboarding_done', true );
		$backend_types = Plugin::instance()->demo_manager->get_backend_types();

		// translators: specifiers are html tags.
		$info  = esc_html__( 'This plugin is a tool that allows you to create and use "shortcodes" within your content. You can think of Dynamic Shortcodes as a placeholder for a dynamically generated value.', 'dynamic-shortcodes' );
		$info .= '<h2>' . esc_html__( 'Examples of Dynamic Shortcodes', 'dynamic-shortcodes' ) . '</h2>';
		// translators: %1$s: Dynamic Shortcode,
		$info .= '<p>' . sprintf( esc_html__( 'The %1$s shortcode can be used to retrieve and display the title of the current post. When you insert this shortcode into your content, the Dynamic Shortcodes plugin will recognize it and automatically replace the shortcode with the title of the post where it\'s located.', 'dynamic-shortcodes' ), '<code>{post:title}</code>' ) . '</p>';
		$info .= '<p>' . esc_html__( 'Examples of use', 'dynamic-shortcodes' ) . '</p>';
		$info .= '<pre>
		Hello, you\'re reading "{post:title}"!
		</pre>';
		$info .= '<p>' . esc_html__( 'If the current post\'s title was "Snorkeling Guide", the result would be:', 'dynamic-shortcodes' ) . '</p>';
		$info .= '<pre>
		Hello, you\'re reading "Snorkeling Guide"!
		</pre>';
		// translators: %1$s: Dynamic Shortcode code,
		$info     .= '<p>' . sprintf( esc_html__( 'The %1$s shortcode can be used to retrieve and display the nickname of the current user. When you insert this shortcode into your content, the Dynamic Shortcodes plugin will recognize it and automatically replace the shortcode with the nickname of the user viewing the content.', 'dynamic-shortcodes' ), '<code>{user:nickname}</code>' ) . '</p>';
		$info     .= '<p>' . esc_html__( 'Examples of use', 'dynamic-shortcodes' ) . '</p>';
		$info     .= '<pre>
		Welcome, {user:nickname}!
		</pre>';
		$info     .= '<p>' . esc_html__( 'If the current user\'s nickname was "Charles", the result would be:', 'dynamic-shortcodes' ) . '</p>';
		$info     .= '<pre>
		Welcome, Charles!
		</pre>';
		$info     .= '<p>' . esc_html__( 'These are just a few examples of how you can use the Dynamic Shortcodes plugin to create dynamic and customized content. ', 'dynamic-shortcodes' ) . '</p>';
		$demos_url = esc_attr( admin_url( '/admin.php?page=dynamic-shortcodes-demo' ) );
		// translators: 1 and 2 are html tags.
		$to_demos = esc_html__( 'You can check the %1$sDemo Shortcodes%2$s page for more examples.', 'dynamic-shortcodes' );
		$info    .= '<p>' . sprintf( $to_demos, "<a href=$demos_url>", '</a>' );

		$help_links = [
			[
				'title' => __( 'Where Dynamic Shortcodes Can Be Used', 'dynamic-shortcodes' ),
				'url' => 'https://dnmc.ooo/dsh-doc-where',
			],
			[
				'title' => __( 'The Syntax of Dynamic Shortcodes', 'dynamic-shortcodes' ),
				'url' => 'https://dnmc.ooo/dsh-doc-syntax',
			],
		];

		$html = <<<END
<div class=wrap>
	<div class="content-wrapper">
	<div class=dynamic-shortcodes-tab>$info</div>
	<div id="dsh-help">
		<h2>Documentation</h2>
		<ul>
		{help_links}
		</ul>
	</div>
</div>
END;

		$link_html = '';

		foreach ( $help_links as $link ) {
			$link_html .= '<li><a href="' . $link['url'] . '">' . $link['title'] . '</a></li>';
		}

		$html = str_replace( '{help_links}', $link_html, $html );

		//phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo $html;
	}
}
