<?php

// SPDX-FileCopyrightText: 2022-2025 Ovation S.r.l. <help@dynamic.ooo>
// SPDX-License-Identifier: LicenseRef-GPL-3.0-with-dynamicooo-additional-terms

namespace DynamicShortcodes\Core\Settings\AdminPages;

use DynamicShortcodes\Plugin;

class Manager {
	/**
	 * @var License;
	 */
	public $license;

	/**
	 * @var Notices;
	 */
	public $notices;

	/**
	 * @var Bar;
	 */
	public $bar;

	/**
	 * @var Collection;
	 */
	public $collection;

	/**
	 * @var GettingStarted;
	 */
	public $getting_started;

	/**
	 * @var Demos;
	 */
	public $demo;

	/**
	 * @var Settings;
	 */
	public $settings;

	/**
	 * @var PowerShortcodes;
	 */
	public $power_shortcodes;

	public function __construct() {
		$this->notices          = Plugin::instance()->plugin_utils->admin_pages->admin_notices;
		$this->license          = Plugin::instance()->plugin_utils->admin_pages->add_new_page( License::class );
		$this->bar              = new Bar();
		$this->collection       = Plugin::instance()->plugin_utils->admin_pages->add_new_page( Collection::class );
		$this->getting_started  = Plugin::instance()->plugin_utils->admin_pages->add_new_page( GettingStarted::class );
		$this->demo             = Plugin::instance()->plugin_utils->admin_pages->add_new_page( Demo::class );
		$this->settings         = Plugin::instance()->plugin_utils->admin_pages->add_new_page( Settings::class );
		$this->power_shortcodes = Plugin::instance()->plugin_utils->admin_pages->add_new_page( PowerShortcodes::class );
	}
}
