<?php
/*
Plugin Name: Import UCS
Description: Importe un fichier CSV “ISIN UCS” et remplit le répéteur ACF de la page d’options UCS.
Version: 1.0
Author: Kyllian GALLAY
*/



add_shortcode('import_isin_ucs', 'ucs_isin_importer_shortcode');
function ucs_isin_importer_shortcode() {

    if (empty($_FILES['ucs_csv']['tmp_name'])) {
        ob_start(); ?>
        
        <form method="post" enctype="multipart/form-data">
            <label>Importer le fichier CSV ISIN UCS :</label><br><br>
            <input type="file" name="ucs_csv" accept=".csv" required>
            <br><br>
            <button type="submit">Importer</button>
        </form>

        <?php
        return ob_get_clean();
    }

    $file = $_FILES['ucs_csv']['tmp_name'];
    $rows = array_map('str_getcsv', file($file));

    // Supprimer l'en-tête "UCS"
    if (!empty($rows[0][0]) && strtolower(trim($rows[0][0])) === 'ucs') {
        array_shift($rows);
    }

    $new_data = [];

    foreach ($rows as $row) {
        if (empty($row[0])) continue;

        // Ajoute chaque ISIN dans le répéteur
        $new_data[] = [
            'field_691b25ab4cb2d' => trim($row[0]) // sous champ 'isin_ucs'
        ];
    }

    // ENREGISTREMENT DANS UNE PAGE D'OPTIONS ACF
    update_field('field_691b25934cb2c', $new_data, 'option');

    return "<strong>Import terminé ! ".count($new_data)." ISIN ajoutés.</strong>";
}
