[![Plugin Version](https://img.shields.io/wordpress/plugin/v/loggedin.svg?style=flat-square)](https://wordpress.org/plugins/loggedin/)
[![License](https://img.shields.io/badge/license-GPL_v2%2B-blue.svg?style=flat-square)](https://opensource.org/license/GPL-2.0)
[![WordPress Tested](https://img.shields.io/wordpress/v/loggedin.svg?style=flat-square)](https://wordpress.org/plugins/loggedin/)
[![Build Status](https://img.shields.io/badge/tests-passing-brightgreen.svg?style=flat-square)](https://github.com/Joel-James/loggedin/actions)

# Loggedin - Limit Concurrent Sessions

Loggedin is a lightweight WordPress plugin that lets you easily limit the number of simultaneous active sessions a user can have. This is a crucial feature for membership sites, online courses, and other platforms where you need to prevent users from sharing their accounts.

## Features

- **Set Global Limits**: Define a maximum number of concurrent logins for all users.
- **Flexible Login Behavior**: Choose to either block new logins when the limit is reached or automatically log out the oldest session to allow a new one.
- **Prevent Account Sharing**: By limiting sessions, you can effectively stop users from sharing their login credentials with others.
- **Admin Control**: Easily force log out a user from the admin dashboard, giving you full control over active sessions.
- **Developer-Friendly**: The plugin is built with a hook-based architecture, making it highly customizable and extensible for developers.

## Addons

There are [several add-ons](https://duckdev.com/addons/loggedin/) available to make LoggedIn more powerful.

## Useful Links

* [See the FAQ](https://wordpress.org/plugins/loggedin/#faq-header).
* [See the documentation](https://docs.duckdev.com/loggedin/general-settings).
* [See the changelog](https://wordpress.org/plugins/loggedin/changelog/).
* [See the contributing guidelines](https://github.com/Joel-James/loggedin?tab=contributing-ov-file).
