<?php 

defined( 'ABSPATH' ) || exit;

class Woffice_Extension_Woffice_Poll{

	/**
	 * @internal
	 */

	 function __construct() {
		$this->_init();
	 }

	/**
	 * @internal
	 */
	public function _init() {

		$enable_woffice_poll_extenstion = get_option('woffice_theme_options');
		if ( isset($enable_woffice_poll_extenstion['enable_woffice_poll_extenstion']) || isset($enable_woffice_poll_extenstion['enable_woffice_poll_extenstion']) && $enable_woffice_poll_extenstion['enable_woffice_poll_extenstion'] ) {
				/* ADD ACTIONS */
			add_action('admin_init', array($this, 'woffice_poll_save_users'), 2);
			add_action('admin_init', array($this, 'woffice_poll_add_answers'), 2);
			add_action('admin_init', array($this, 'woffice_poll_refresh_users'));
			add_action('admin_init', array($this, 'woffice_poll_create_table'), 1);
			// $this->woffice_poll_mirgrate();
		} else {
			add_action('admin_init', array($this, 'woffice_poll_delete_table'));
		}

		
		/* DEFINE CONSTANT */
		global $wpdb;
		// We check for multisite : 
	    if (is_multisite() && is_main_site()) {
		    $prefix = $wpdb->base_prefix;
	    } else {
	    	$prefix = $wpdb->prefix;
	    }
		define( 'WOFFICE_POLL_TABLE', $prefix . 'woffice_poll');
	}
	
	/**
	 * CREATE FUNCTIONS TO GET THE VALUES FROM THE EXTENSION'S SETTINGS
	 * @return string
	 */
	/* THE POLL QUESTION */
	public static function woffice_get_poll_name() {
		return woffice_get_theming_option('woffice_poll_question' );
	}
	/* THE POLL TYPE -> CHECKBOX OR RADIO BUTTONS */
	public static function woffice_get_poll_type() {
		return get_option('woffice_poll_type' );
	}
	/* THE QUESTIONS */
	public static function woffice_get_poll_answers() {
		return woffice_get_theming_option('woffice_poll_answers');
	}
	
	/**
	 * CREATE NEW TABLE IN THE DATABASE
	 */	
	public function woffice_poll_create_table() {
	
		/* ONLY IF IT's the POLL extension */
		$enable_woffice_poll_extenstion = get_option('woffice_theme_options');
	
		if ( isset($enable_woffice_poll_extenstion['enable_woffice_poll_extenstion']) && !$enable_woffice_poll_extenstion['enable_woffice_poll_extenstion'] ) {
			return;
		}

		// We return nothing if the table doesn't exist
		if(self::woffice_table_exists()){
			return;
		}
	    
		/* GET GLOBAL FOR DATABASE */
        global $wpdb;
        
		/* CHARSET */
		$charset_collate = $wpdb->get_charset_collate();
		
		/* SQL CODE */
		$table_name = WOFFICE_POLL_TABLE;
		$sql = "CREATE TABLE $table_name (
		  id MEDIUMINT NOT NULL AUTO_INCREMENT,
		  label VARCHAR(255) NOT NULL,
		  reps INT  NOT NULL,
		  UNIQUE KEY id (id)
		) $charset_collate;";
		
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
		
		dbDelta( $sql );
		
	}
	
	/**
	 * DELETE TABLE IN THE DATABASE
	 */	
	public function woffice_poll_delete_table($extensions) {
	
		$enable_woffice_poll_extenstion = get_option('woffice_theme_options');

		if ( isset($enable_woffice_poll_extenstion['enable_woffice_poll_extenstion']) && !$enable_woffice_poll_extenstion['enable_woffice_poll_extenstion'] ) {
			// We return nothing if the table doesn't exist
			
			if(!self::woffice_table_exists())
				return;
			
			/* GET GLOBAL FOR DATABASE */
			global $wpdb;
			delete_option('woffice_poll_users');
			delete_option('woffice_poll_added_default_ans');
			/* SQL CODE */
			$table_name = WOFFICE_POLL_TABLE;
			$sql = "DROP TABLE IF EXISTS $table_name;";
			$wpdb->query($sql);
		}
	}
	
	/**
	 * SAVE DEFAULT VALUE TO THE DATABASE
	 */
	public function woffice_poll_default_answer() {
	
		global $wpdb;

        // We return nothing if the table doesn't exist
        if(!self::woffice_table_exists())
            return;
		
		/*IN THE POLL TABLE*/		
	    $wpdb->insert( 
			WOFFICE_POLL_TABLE, 
			array('label' => 'Answer 1'), 
			array('%s') 
		);
	}
	
	
	/**
	 * ADD DATA FROM THE SETTINGS TO THE DATABASE
	 */
	public function woffice_poll_add_answers() {
	
		global $wpdb;
		
		/* GET THE NEW DATA */
		$data_new = self::woffice_get_poll_answers();
		$woffice_poll_added_default_ans = get_option('woffice_poll_added_default_ans');
		
		/* GET ALL THE TABLE WHEN NEW OPTION LABEL IF NOT THERE DELETE! */
		$results = $wpdb->get_results("SELECT label FROM ".WOFFICE_POLL_TABLE . " ORDER BY label ASC",ARRAY_A);

		if($results){
			foreach($results as $label){
				$the_label = $label['label'];
				// $present = FALSE;
				if(is_array($data_new) && !in_array($the_label,$data_new)){
					$wpdb->delete( WOFFICE_POLL_TABLE, array( 'label' => $the_label));
				}
			}
		}
		
		/* UPDATE DATA */
		if(!empty($data_new)){
			foreach ($data_new as $single){
				/* IF THE DATA DOESN'T EXISTS */
				$exists = $wpdb->get_var( $wpdb->prepare("SELECT COUNT(*) FROM ".WOFFICE_POLL_TABLE." WHERE label = %s", $single ) );
				if ( ! $exists ) {
					/* THEN, LET SAVE IT */
					$wpdb->insert( 
						WOFFICE_POLL_TABLE, 
						array('label' => $single), 
						array('%s') 
					);
				}
			}
		}
	}
	
	/**
	 * GENERATE RESULTS FRONTEND
	 */
	public static function woffice_poll_get_results() {
	
		global $wpdb;
		
		$html = '';

		$html .= '<div id="woffice-poll-result">';
			$answers = self::woffice_get_poll_answers();
			foreach ($answers as $answer) {
				$html .= '<div class="woffice-poll-result-answer">';
					// We check first that the table exists
					$check = $wpdb->get_results("SELECT 1 FROM ".WOFFICE_POLL_TABLE." LIMIT 1");
					if ($check != FALSE) {
						$reps = $wpdb->get_var( $wpdb->prepare( "SELECT reps FROM ".WOFFICE_POLL_TABLE." WHERE label = %s",$answer) );
						$all_reps = $wpdb->get_var( "SELECT SUM(reps) FROM ".WOFFICE_POLL_TABLE );
						$rep_percentage = ($all_reps!=0) ? round(($reps/$all_reps)*100,1) : 0;
						$html .= '<p>'.esc_html($answer).'</p>';
						$html .= '<div class="progress-custom">
							<div class="progress">
								<div class="progress-bar" role="progressbar" aria-valuenow="' . esc_attr($rep_percentage) . '" aria-valuemin="0" aria-valuemax="100"  style="width: ' .esc_attr($rep_percentage) . '%"></div>
							</div>
							<div class="progress-value">
								' . esc_attr($rep_percentage) . '%
							</div>
						</div>';
					}
					$html .='</div>';
			}
		$html .='</div>';
	

		return $html;

	}
	
	/**
	 * CREATE/UPDATE/DELETE USER ID
	 */
	public function woffice_poll_save_users($extensions) {
		/* ONLY IF IT's the POLL extension */
		$enable_woffice_poll_extenstion = get_option('woffice_theme_options');

		if ( isset($enable_woffice_poll_extenstion['enable_woffice_poll_extenstion']) && !$enable_woffice_poll_extenstion['enable_woffice_poll_extenstion'] ) {
			return;
		}
		$defaultvalue = array(0);
		add_option('woffice_poll_users', $defaultvalue);
	}
	public static function woffice_poll_add_user($id) {
		// GET OPTION
		$the_saved_users = (is_array(get_option('woffice_poll_users'))) ? get_option('woffice_poll_users') : array();
		// ADD NEW USER
		$newvalue = array_merge($the_saved_users,array($id));
		// UPDATE
		update_option('woffice_poll_users', $newvalue);
	}
	public function woffice_poll_refresh_users($extensions) {
		/* ONLY IF IT's the POLL extension */
		$enable_woffice_poll_extenstion = get_option('woffice_theme_options');

		if ( isset($enable_woffice_poll_extenstion['enable_woffice_poll_extenstion']) && !$enable_woffice_poll_extenstion['enable_woffice_poll_extenstion'] ) {
			delete_option( 'woffice_poll_users' );
		}
		
	}
	
	/**
	 * GENERATE RESULTS BACKEND
	 */
	public static function woffice_poll_get_results_backend($export_poll) {
	
		global $wpdb;

		// We return an empty array if empty
		if(!self::woffice_table_exists())
		    return array();
	
		$answers = self::woffice_get_poll_answers();
		
		$options_answers = array();
		$html = '';
		if (empty($answers)){
			return array('information' => array('label' => __( 'No results :', 'woffice' ),'type'  => 'html','html'  => 'There is not any result yet.'));
		}
		$export_poll = isset($_GET["export_poll"]) ? $_GET["export_poll"] : 'no';

		if($export_poll == 'yes') {
			$html = array();
			foreach ($answers as $answer) {
				$reps = $wpdb->get_var( $wpdb->prepare( "SELECT reps FROM ".WOFFICE_POLL_TABLE." WHERE label = %s",$answer) );
				$all_reps = $wpdb->get_var( "SELECT SUM(reps) FROM ".WOFFICE_POLL_TABLE );
				$rep_percentage = ($all_reps!=0) ? round(($reps/$all_reps)*100,1) : 0;
				$slug_answer = sanitize_title($answer);

				$html[] = array(
					'label' => $slug_answer,
					'html' => $rep_percentage
				);
			}
		} else if($export_poll == 'no') {

			foreach ($answers as $answer) {
		
				$reps = $wpdb->get_var( $wpdb->prepare( "SELECT reps FROM ".WOFFICE_POLL_TABLE." WHERE label = %s",$answer) );
				$all_reps = $wpdb->get_var( "SELECT SUM(reps) FROM ".WOFFICE_POLL_TABLE );
				$rep_percentage = ($all_reps!=0) ? round(($reps/$all_reps)*100,1) : 0;
				$slug_answer = sanitize_title($answer);
				
				$html .= "<div>";
				$html .= "<label><b>" . $slug_answer . '</b></label> :: ' . $rep_percentage;
				$html .= "</div>";
			}
			
	
			$html .= "<div>";
			$html .= "<label><b>Total answers number</label></b> :: " . $all_reps;
			$html .= "</div>";
		}

		return $html;
	}

    /**
     * Checks if the poll table is created
     *
     * @return bool
     */
    public static function woffice_table_exists() {
        global $wpdb;
        return ($wpdb->get_var("SHOW TABLES LIKE '".WOFFICE_POLL_TABLE."'") == WOFFICE_POLL_TABLE);
    }
	
	/**
	 * ADD A REFRESH BUTTON TO THE PAGE
	 */
	public function woffice_poll_add_delete_button() {
		
		echo fw_html_tag('a', array(
			'href'  => admin_url('admin.php?page=fw-extensions&sub-page=extension&extension=woffice-poll&delete_poll=yes'),
			'class' => 'button-secondary',
			'style' => 'margin-bottom: 20px;',
			'onclick' => 'return confirm("'.__('Are you sure you want to delete this poll ?', 'woffice').'");'
		), __('Delete Poll', 'woffice'));
		
	}
	
	/**
	 * ADD AN EXPORT BUTTON
	 */
	public function woffice_poll_export_button() {
		
		echo fw_html_tag('a', array(
			'href'  => admin_url('admin.php?page=fw-extensions&sub-page=extension&extension=woffice-poll&export_poll=yes'),
			'class' => 'button-secondary',
			'style' => 'margin-bottom: 20px;margin-left:10px;',
		), __('Export results', 'woffice'));
		
	}

	public function woffice_poll_mirgrate(){

		$woffice_poll_old_option = get_option('fw_ext_settings_options:woffice-poll');
		$woffice_poll_mirgrate = get_option('woffice_poll_mirgrate');
		$woffice_migrated_option = woffice_get_theming_option('woffice_poll_answers');
		if (isset($woffice_poll_old_option['answers']) && !empty($woffice_poll_old_option['answers']) && !empty($woffice_migrated_option)) {
			if(class_exists('Redux') && !$woffice_poll_mirgrate){
				$woffice_poll_question = isset($woffice_poll_old_option['name']) ? sanitize_text_field($woffice_poll_old_option['name']) : '';
				Redux::set_option('woffice_theme_options', 'woffice_poll_question', $woffice_poll_question);
				Redux::set_option('woffice_theme_options', 'woffice_poll_answers', $woffice_poll_old_option['answers']);
				update_option('woffice_poll_mirgrate',true);
			}
		}
	}
	
}

new Woffice_Extension_Woffice_Poll();