<?php
// Add filter to override 'ocdi/register_plugins' to return empty array
add_filter('ocdi/register_plugins', function($plugins) {
    return array();
});

// Clear frontend error messages after all import execution to hide warning notice
add_action('ocdi/after_all_import_execution', function($selected_import_files, $import_files, $selected_index) {
    $ocdi_instance = \OCDI\OneClickDemoImport::get_instance();
    if ($ocdi_instance) {
        $ocdi_instance->frontend_error_messages = [];
    }
}, 20, 3);

add_filter('gettext', function($translated_text, $text, $domain) {
    if ($domain === 'one-click-demo-import') {
        if ($text === 'Your import completed, but some things may not have imported properly.') {
            return 'Your import completed successfully.';
        }
    }
    return $translated_text;
}, 10, 3);

add_filter('gettext', function($translated_text, $text, $domain) {
    if ($domain === 'one-click-demo-import') {
        if ($text === 'To ensure the best experience, installing the following plugins is strongly recommended, and in some cases required.') {
            //remove this text as we have override recommended plugins.
            return '';
        }
    }
    return $translated_text;
}, 10, 3);


add_filter('ocdi/plugin_page_display_callback_function', function($callback) {
    return function() use ($callback) {
        ob_start();
        call_user_func($callback);
        $output = ob_get_clean();

       
        // Remove the plugins list block from the output using regex
        $pattern_plugins = '/<div class="ocdi-install-plugins-content-content">.*?<div class="ocdi-install-plugins-content-footer">/s';

         $replacement_plugins = '<div class="ocdi-install-plugins-content-content">';
  
        $replacement_plugins .= '<div class="ocdi-content-notice"><p>';
        $replacement_plugins .= sprintf(
        __('<strong>Important:</strong> To ensure your site functions smoothly, please make sure all required plugins are activated. Need help? <a href="%s">Click here</a> to activate all recommended plugins.', 'woffice'), esc_url( admin_url( 'themes.php?page=tgmpa-install-plugins' ) ));
        $replacement_plugins .= '</p></div>';

        $replacement_plugins .= '<div class="ocdi-content-notice"><p>';
        $replacement_plugins .= sprintf(
        __('<strong>Important:</strong> To ensure everything works as expected, please make sure all required <strong>Theme extensions</strong> are activated in the  Woffice Theme Options.
        Need assistance? <a href="%s">Click here</a> to activate all recommended Theme Extensions.', 'woffice'), esc_url( admin_url( 'themes.php?page=woffice_theme_options' ) ));
        $replacement_plugins .= '</p></div>';

        $replacement_plugins .= '<div class="ocdi-content-notice"><p>';
        $replacement_plugins .= 
        __('<strong>Note:</strong> If BuddyPress is active, please note that its menus are generated dynamically and cannot be imported automatically You’ll need to create those menus manually.', 'woffice');
        $replacement_plugins .= '</p></div>';


        $replacement_plugins .= '</div><div class="ocdi-install-plugins-content-footer">';
        $output = preg_replace($pattern_plugins, $replacement_plugins, $output);

        echo $output;
    };
});

/*
*ICDI: custom import success message.
*/
add_action('admin_enqueue_scripts', function($hook) {
    if (isset($_GET['page']) && $_GET['page'] === 'woffice-demo-import') {
        $inline_js = "
        jQuery(document).ready(function($) {
            function appendCustomMessage() {
                var headerDiv = $('.ocdi-imported-header');
                if (headerDiv.length && !$('#ocdi-import-success-message').length) {
                    $('<div id=\"ocdi-import-success-message\" class =\"ocdi-content-notice\" ><strong>Note:</strong> If BuddyPress is active, please note that its menus are generated dynamically and cannot be imported automatically You’ll need to create those menus manually.</div>').insertAfter(headerDiv);
                }
            }
            $(document).ajaxComplete(function(event, xhr, settings) {
                if (settings.data && settings.data.indexOf('action=ocdi_after_import_data') !== -1) {
                    appendCustomMessage();
                }
            });
            appendCustomMessage();
        });
        ";
        wp_add_inline_script('jquery-core', $inline_js);
    }
});

/**
 * Replace old URLs in imported menu items with current site URL after import.
 *
 * @param array $selected_import_files The import files used.
 * @param array $import_files All import files.
 * @param int $selected_index The selected import index.
 */
function replace_menu_item_urls_with_current_site_url($selected_import_files, $import_files, $selected_index) {
    global $wpdb;

    // Security: Verify user capability and nonce
    if (!current_user_can('manage_options')) {
        return;
    }
    if (!isset($_POST['security']) || !wp_verify_nonce($_POST['security'], 'ocdi-ajax-verification')) {
        return;
    }

    // Get current site URL
    $current_site_url = untrailingslashit(get_site_url());

    // Use fixed old site URL to replace
    $old_site_url = 'https://import.woffice.io';

    if ($old_site_url === $current_site_url) {
        // Old and current site URLs are the same, no replacement needed
        return;
    }

    // Get all menu item post IDs
    $menu_item_ids = $wpdb->get_col(
        $wpdb->prepare(
            "SELECT ID FROM {$wpdb->posts} WHERE post_type = %s",
            'nav_menu_item'
        )
    );

    if (empty($menu_item_ids)) {
        return;
    }

    // Meta keys that may contain URLs in menu items
    $menu_meta_keys = ['_menu_item_url'];

    foreach ($menu_item_ids as $menu_item_id) {
        foreach ($menu_meta_keys as $meta_key) {
            $meta_value = get_post_meta($menu_item_id, $meta_key, true);
            if (!empty($meta_value) && strpos($meta_value, $old_site_url) !== false) {
                $new_meta_value = str_replace($old_site_url, $current_site_url, $meta_value);
                update_post_meta($menu_item_id, $meta_key, $new_meta_value);
            }
        }
    }
}
