<?php
/**
 * Woffice Blog options
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

 defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux' ) ) {
	return;
}

 $blog_number = woffice_get_settings_option('blog_number');
 $index_title = woffice_get_settings_option('index_title');
 $blog_fullwidth = woffice_get_settings_option('blog_fullwidth');
 $blog_listing_content = woffice_get_settings_option('blog_listing_content');
 $hide_author_box_single_post = woffice_get_settings_option('hide_author_box_single_post');
 $hide_like_counter_inside_author_box = woffice_get_settings_option('hide_like_counter_inside_author_box');
 $auto_height_featured_image = woffice_get_settings_option('auto_height_featured_image');
 $hide_image_single_post = woffice_get_settings_option('hide_image_single_post');
 
 Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Blog', 'woffice' ),
		'id'         => 'blog-options-blog_select',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
            array(
                'id'       => 'blog_number',
                'type'     => 'text', 
                'title'    => esc_html__('Number of posts displayed per page', 'woffice'),
                'desc' => esc_html__('A number please.', 'woffice'),
                'default'  => $blog_number,
            ),
            array(
                'id'       => 'index_title',
                'type'     => 'text', 
                'title'    => esc_html__('Blog Page Title', 'woffice'),
                'desc' => esc_html__('It is the default Wordpress page here.', 'woffice'),
                'default'  => $index_title,
            ),
            array(
				'id'       => 'blog_fullwidth',
				'type'     => 'switch',
				'title'    => esc_html__( 'Sidebar on Blog pages ?', 'woffice' ),
				'on'       => esc_html__('With Sidebar','woffice'),
				'off'      => esc_html__('Full Width','woffice'),
                'default'  => $blog_fullwidth
			),
            array(
				'id'       => 'blog_listing_content',
				'type'     => 'select',
				'title'    => esc_html__( 'Blog Listing Context', 'woffice' ),
                'desc'     => esc_html__('Define what show in blog listing.','woffice'),
				'default'  => $blog_listing_content,
			    'options'  => array(
					'excerpt' => esc_html__( 'Excerpt', 'woffice' ),
					'content'  => esc_html__( 'Content', 'woffice' ),
                    'none'  => esc_html__( 'none', 'woffice' ),
            	),
        	),
            array(
                'id'       => 'post_excerpt_lenght',
                'type'     => 'text', 
                'title'    => esc_html__('Excerpt Length', 'woffice'),
                'desc' => esc_html__('Length of post excerpt.', 'woffice'),
                'required' => array('blog_listing_content','equals','excerpt'),
                'default'  => 30,
            ),
            array(
				'id'       => 'blog_layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Blog Layout', 'woffice' ),
                'desc'     => esc_html__('Blog layout in blog listing page.','woffice'),
				'default'  => 'grid',
			    'options'  => array(
					'grid' => esc_html__( 'Grid', 'woffice' ),
					'masonry'  => esc_html__( 'Masonry', 'woffice' ),
            	),
        	),
            array(
				'id'       => 'masonry_columns',
				'type'     => 'select',
				'title'    => esc_html__( 'Blog masonry Columns', 'woffice' ),
                'desc'     => esc_html__('Number of columns for masonry layout','woffice'),
				'default'  => 'grid',
			    'options'  => array(
					'1' => esc_html__( '1 Column', 'woffice' ),
					'2'  => esc_html__( '2 Columns', 'woffice' ),
                    '3'  => esc_html__( '3 Columns', 'woffice' ),
            	),
                'default'  => '3',
                'required' => array('blog_layout','equals', 'masonry')
        	),
            array(
                'id'       => 'hide_image_single_post',
                'type'     => 'switch', 
                'title'    => esc_html__('Hide featured image', 'woffice'),
                'desc'     => esc_html__('Hide featured image in opened post page.', 'woffice'),
                'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
                'default'  => $hide_image_single_post
            ),
            array(
                'id'       => 'hide_author_box_single_post',
                'type'     => 'switch', 
                'title'    => esc_html__('Hide Author Box', 'woffice'),
                'desc'     => esc_html__('Hide author box section below blog posts.', 'woffice'),
                'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
                'default'  => $hide_author_box_single_post
            ),
            array(
                'id'       => 'hide_like_counter_inside_author_box',
                'type'     => 'switch', 
                'title'    => esc_html__('Hide Like Counter', 'woffice'),
                'desc'     => esc_html__('It is the default Wordpress page here.', 'woffice'),
                'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
                'default'  => $hide_like_counter_inside_author_box
            ),
            array(
                'id'       => 'auto_height_featured_image',
                'type'     => 'switch', 
                'title'    => esc_html__('Height of featured image of elements', 'woffice'),
                'desc'     => esc_html__('This is the featured image of elements like as blog posts, projects, etc. This option does not work in masonry layout.', 'woffice'),
                'on'       => esc_html__('Auto','woffice'),
				'off'      => esc_html__('Fixed','woffice'),
                'default'  => $auto_height_featured_image
            ),
            
        ),
	),
);