<?php
/**
 * Redux Framework font family select config.
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

 defined( 'ABSPATH' ) || exit;

 if ( ! class_exists( 'Redux' ) ) {
	 return;
 }
$plugins_url = plugins_url();

$page_loading = woffice_unyson_switch_to_bool(woffice_get_settings_option('page_loading'));
$hide_seo = woffice_unyson_switch_to_bool(woffice_get_settings_option('hide_seo'));
$gmap_api_key = woffice_get_settings_option('gmap_api_key');

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Main Options', 'woffice' ),
		'id'         => 'general-options_main',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
            array(
				'id'       => 'page_loading',
				'type'     => 'switch',
				'title'    => esc_html__( 'Page loading', 'woffice' ),
				'desc'     => esc_html__( 'Show the page loading bar above the navbar.', 'woffice' ),
                'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $page_loading,
			),
            array(
				'id'       => 'hide_seo',
				'type'     => 'switch',
				'title'    => esc_html__( 'Hide website ?', 'woffice' ),
				'desc'     => esc_html__( 'Do you want to hide the website from Search engines, so it is only accessible by URL.', 'woffice' ),
                'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $hide_seo,
			),
            array(
				'id'       => 'gmap_api_key',
				'type'     => 'text',
				'title'    => esc_html__( 'Google MAP API Key', 'woffice' ),
				'default'  => $gmap_api_key,
				'desc'     => esc_html__( 'This key is used for all the Google MAPs (Not the members map creation)', 'woffice' ),
                'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
			),
		),
	)
);
