<?php
/**
 * Redux Framework header bar config.
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

 defined( 'ABSPATH' ) || exit;

 if ( ! class_exists( 'Redux' ) ) {
	 return;
 }
 
$plugins_url = plugins_url();

$header_logo = woffice_get_settings_option('header_logo');
$header_width = woffice_get_settings_option('header_width');
$header_logo_hide = woffice_get_settings_option('header_logo_hide');
$header_search = woffice_unyson_switch_to_bool(woffice_get_settings_option('header_search'));
$header_user = woffice_unyson_switch_to_bool(woffice_get_settings_option('header_user'));
$header_login = woffice_unyson_switch_to_bool(woffice_get_settings_option('header_login'));

$header_logo_url ='';
if(isset($header_logo['url']) && !empty($header_logo['url'])){
	$header_logo_url = $header_logo['url'];
}

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Header Bar', 'woffice' ),
		'id'         => 'select-header-bar-options',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
		    array(
                'id'       => 'header_logo',
                'type'     => 'media', 
                'url'      => true,
                'title'    => esc_html__('Main logo', 'woffice'),
                'desc'     => esc_html__('Upload your image for the logo', 'woffice'),
                'default'  => array(
                    'url'=> $header_logo_url
                ),
            ),
            array(
                'id'       => 'header_width',
                'type'     => 'text', 
                'title'    => esc_html__('Logo Width', 'woffice'),
                'desc'     => esc_html__('A number please', 'woffice'),
                'default'  => $header_width,
            ),
            array(
				'id'       => 'header_logo_hide',
				'type'     => 'switch',
				'title'    => esc_html__( 'Do you want to hide the logo ?', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $header_logo_hide,
			),
            array(
				'id'       => 'header_search',
				'type'     => 'switch',
				'title'    => esc_html__( 'Search icon in the menu ?', 'woffice' ),
                'subtitle' => esc_html__( 'Do you want to show the seacrh icon at the end of the menu.', 'woffice'),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $header_search,
			),
            array(
				'id'       => 'header_user',
				'type'     => 'switch',
				'title'    => esc_html__( 'User Box', 'woffice' ),
                'subtitle' => esc_html__( 'Do you want to show the user box in the navbar ?', 'woffice'),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $header_user,
			),
			array(
				'id'       => 'header_user_position',
				'type'     => 'select',
				'title'    => esc_html__( 'User box position', 'woffice' ),
				'subtitle' => esc_html__( 'Show user box in topbar or left sidebar', 'woffice' ),
				'options'  => array(
					'in_topbar' => esc_html__( 'Inside Topbar', 'woffice' ),
					'in_rightsidebar'  => esc_html__( 'Inside Right sidebar', 'woffice' ),
                ),
				'default'  => 'in_rightsidebar',
				'required' => array('header_user','equals', true)
			),
            array(
				'id'       => 'header_login',
				'type'     => 'switch',
				'title'    => esc_html__( 'Login Link', 'woffice' ),
                'subtitle' => esc_html__( 'If the page is accessible do you want to display a link to your login page ?', 'woffice'),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $header_login,
			),
			array(
				'id'       => 'show_mini_Cart',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Mini cart', 'woffice' ),
				'subtitle' => esc_html__( 'Show mini cart icon in topbar when Woocommerce is active.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => true,
			),
			array(
				'id'       => 'show_notification_icon',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show notification icon', 'woffice' ),
				'subtitle' => esc_html__( 'Show notification icon in topbar when BuddyPress is active.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => true,
			),
		),
	)
);