<?php

defined('ABSPATH') || exit;

/* Roles array ready for options */
global $wp_roles;
$tt_roles_tmp = array();
foreach ($wp_roles->roles as $key => $value) {
    $tt_roles_tmp[$key] = $value['name'];
}

/* Admin user array ready for options */
$users = get_users( array('role' => 'administrator','cache_results' => false) );
$user_list = array();

foreach ( $users as $user ) {
	$user_list[$user->ID] = ucfirst($user->data->user_nicename);
}

$post_create = woffice_get_settings_option('post_create');
$post_edit = woffice_get_settings_option('post_edit');
$override_post_by_caps = woffice_get_settings_option('override_post_by_caps');

// Old wiki options from unyson

$wiki_create = woffice_get_settings_option('wiki_create');
$wiki_edit = woffice_get_settings_option('wiki_edit');
$override_wiki_by_caps = woffice_get_settings_option('override_wiki_by_caps');

// Old event options from unyson
$event_create = woffice_get_settings_option('event_create');

// Old directory options from unyson
$directory_create = woffice_get_settings_option('directory_create');

// Old directory options from unyson
$projects_create = woffice_get_settings_option('projects_create');
$projects_public = woffice_get_settings_option('projects_public');

// Old buddypress options from unyson
$buddy_members_state = woffice_get_settings_option('buddy_members_state');
$buddy_groups_state = woffice_get_settings_option('buddy_groups_state');
$buddy_activity_state = woffice_get_settings_option('buddy_activity_state');
$buddy_members_excluded = woffice_get_settings_option('buddy_members_excluded');
$buddy_groups_excluded = woffice_get_settings_option('buddy_groups_excluded');
$buddy_activity_excluded = woffice_get_settings_option('buddy_activity_excluded');
$buddy_manage_signups = woffice_get_settings_option('buddy_manage_signups');

// Old general options from unyson
$public = woffice_unyson_switch_to_bool(woffice_get_settings_option('public'));
$excluded_pages = woffice_get_settings_option('excluded_pages');
$products_public = woffice_unyson_switch_to_bool(woffice_get_settings_option('products_public'));
$feeds_private = woffice_get_settings_option('feeds_private');
$frontend_state = woffice_get_settings_option('frontend_state');
$privacy_post = woffice_get_settings_option('privacy_post');
$privacy_project = woffice_get_settings_option('privacy_project');
$privacy_wiki = woffice_get_settings_option('privacy_wiki');
$privacy_directory = woffice_get_settings_option('privacy_directory');

/* End */

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Permissions', 'woffice' ),
		'id'         => 'options-permissions',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
            array(
                'id'        => 'prm-accordion-begin-1',
                'type'      => 'accordion',
                'title'     => 'General options',
                'position'  => 'start',    
            ),
            array(
				'id'       => 'public',
				'type'     => 'switch',
				'title'    => esc_html__( 'Do you want to make this website public ?', 'woffice' ),
				'desc'     => esc_html__( 'As an Intranet, every visitor have to login to access to the content and the wbesite, with this option your Website will be free to be reached by everyone...', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
                'default'  => $public,
			), 
            array(
				'id'       => 'excluded_pages',
				'type'     => 'select',
				'data'     => 'pages',
				'multi'    => true,
				'title'    => esc_html__( 'Excluded pages', 'woffice' ),
				'desc'     => esc_html__( 'If the website is private you can still make some pages public with this option. That means that the pages selected will not be affected by the redirection to the login page. For Buddypress pages please see : Buddypress sections', 'woffice' ),
                'default' => $excluded_pages ? $excluded_pages : ''
            ),
            array(
				'id'       => 'products_public',
				'type'     => 'switch',
				'title'    => esc_html__( 'Woocomerce products excluded ?', 'woffice' ),
				'desc'     => esc_html__( 'IF your website is private and you want your WooCommerce products to be public, select Yes', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
                'default'  => $products_public,
			), 
            array(
				'id'       => 'feeds_private',
				'type'     => 'switch',
				'title'    => esc_html__( 'Do you want to make the feeds private?', 'woffice' ),
				'desc'     => esc_html__( 'Some feeds of your site make still be available also if you make your site or some pages private. If you enable this option, all feeds will be turned off.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
                'default'  => $feeds_private,
			), 
            array(
                'id'       => 'frontend_state',
                'type'     => 'select',
                'multi'    => false,
                'title'    => __('Post Status on frontend creation', 'woffice'), 
                'desc'     => __('When the post is submitted, you can choose if it is directly published or need you approval first.', 'woffice'),
                'options'  => array(
					'draft' => __('Draft', 'woffice'),
					'publish' => __('Publish', 'woffice'),
                    'pending' => __('Pending', 'woffice')
				),
                'default'  => $frontend_state ? $frontend_state : 'publish'
            ),
            array(
                'id'       => 'privacy_post',
                'type'     => 'select',
                'multi'    => false,
                'title'    => __('Posts Privacy', 'woffice'), 
                'desc'     => __('The default value is the one set above for the whole site. Regarding single items.', 'woffice'),
                'options'  => array(
					'default' => __('Default', 'woffice'),
					'publish' => __('Publish', 'woffice'),
                    'pending' => __('Pending', 'woffice')
				),
                'default'  => $privacy_post ? $privacy_post : 'default'
            ),
            array(
                'id'       => 'privacy_project',
                'type'     => 'select',
                'multi'    => false,
                'title'    => __('Projects Privacy', 'woffice'), 
                'desc'  => __( 'The default value is the one set above for the whole site. Regarding single items.', 'woffice' ),
                'options'  => array(
					'default' => __('Default', 'woffice'),
					'publish' => __('Publish', 'woffice'),
                    'pending' => __('Pending', 'woffice')
				),
                'default'  => $privacy_project ? $privacy_project : 'default'
            ),
            array(
                'id'       => 'privacy_wiki',
                'type'     => 'select',
                'multi'    => false,
                'title'    => __('Wiki articles Privacy', 'woffice'), 
                'desc'  => __( 'The default value is the one set above for the whole site. Regarding single items.', 'woffice' ),
                'options'  => array(
					'default' => __('Default', 'woffice'),
					'publish' => __('Publish', 'woffice'),
                    'pending' => __('Pending', 'woffice')
				),
                'default'  => $privacy_wiki ? $privacy_wiki : 'default'
            ),
            array(
                'id'       => 'privacy_directory',
                'type'     => 'select',
                'multi'    => false,
                'title'    => __('Directory items Privacy', 'woffice'), 
                'desc'  => __( 'The default value is the one set above for the whole site. Regarding single items.', 'woffice' ),
                'options'  => array(
					'default' => __('Default', 'woffice'),
					'publish' => __('Publish', 'woffice'),
                    'pending' => __('Pending', 'woffice')
				),
                'default'  => $privacy_directory ? $privacy_directory : 'default'
            ),
            array(
                'id'        => 'prm-accordion-end-1',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
            array(
                'id'        => 'prm-accordion-begin-2',
                'type'      => 'accordion',
                'title'     => 'Buddypress Pages options',
                'position'  => 'start',    
            ),
            array(
                'id'       => 'buddy_members_state',
                'type'     => 'select',
                'multi'    => false,
                'title'    => __('Members restriction (redirection)', 'woffice'), 
                'desc'     => __('Members directory & profile pages. If it is set as "private", the non-logged users will be redirected to the login page.', 'woffice'),
                'options'  => array(
					'private' => __('Private', 'woffice'),
					'public' => __('Public', 'woffice'),
				),
                'default'  => $buddy_members_state ? $buddy_members_state : 'private'
            ),
            array(
                'id'       => 'buddy_groups_state',
                'type'     => 'select',
                'multi'    => false,
                'title'    => __('Groups restriction (redirection)', 'woffice'), 
                'desc'     => __('It is only affecting a front end button on the main projects page. The roles with post edit capabilities will still be able to create Projects from the backend.', 'woffice'),
                'options'  => array(
					'private' => __('Private', 'woffice'),
					'public' => __('Public', 'woffice'),
				),
                'default'  => $buddy_groups_state ? $buddy_groups_state : 'private'
            ),
            array(
                'id'       => 'buddy_activity_state',
                'type'     => 'select',
                'multi'    => false,
                'title'    => __('Activity restriction (redirection)', 'woffice'), 
                'desc'     => __('Activity page. If it is set as "private", the non-logged users will be redirected to the login page.', 'woffice'),
                'options'  => array(
					'private' => __('Private', 'woffice'),
					'public' => __('Public', 'woffice'),
				),
                'default'  => $buddy_activity_state ? $buddy_activity_state : 'private'
            ),
            array(
                'id'       => 'buddy_members_excluded',
                'type'     => 'select',
                'multi'    => true,
                'title'    => __('Members restriction (excluded roles)', 'woffice'), 
                'desc'     => __('Do you want to exclude some roles from the members pages (directory & profiles) ?', 'woffice'),
                'options'  => $tt_roles_tmp,
                'default'  => $buddy_members_excluded ? $buddy_members_excluded :  array('nope')
            ),
            array(
                'id'       => 'buddy_groups_excluded',
                'type'     => 'select',
                'multi'    => true,
                'title'    => __('Groups restriction (excluded roles)', 'woffice'), 
                'desc'     => __('Do you want to exclude some roles from the groups pages (directory & single) ?', 'woffice'),
                'options'  => $tt_roles_tmp,
                'default'  => $buddy_groups_excluded ? $buddy_groups_excluded :  array('nope')
            ),
            array(
                'id'       => 'buddy_activity_excluded',
                'type'     => 'select',
                'multi'    => true,
                'title'    => __('Activity restriction (excluded roles)', 'woffice'), 
                'desc'     => __('Do you want to exclude some roles from the Activity pages ?', 'woffice'),
                'options'  => $tt_roles_tmp,
                'default'  => $buddy_activity_excluded ? $buddy_activity_excluded :  array('nope')
            ),
            array(
                'id'       => 'buddy_manage_signups',
                'type'     => 'select',
                'multi'    => true,
                'title'    => __('User Approval', 'woffice'), 
                'desc'     => __('Select admins who are able to manage signups.', 'woffice'),
                'options'  => $user_list,
                'default'  => $buddy_manage_signups ? $buddy_manage_signups :  array('nope')
            ),
            array(
                'id'        => 'prm-accordion-end-2',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
            array(
                'id'        => 'prm-accordion-begin-3',
                'type'      => 'accordion',
                'title'     => 'Wiki options',
                'position'  => 'start',    
            ),
            array(
                'id'       => 'wiki_create',
                'type'     => 'select',
                'multi'    => true,
                'title'    => __('Who can create a wiki article ?', 'woffice'), 
                'desc'     => __('It is only affecting a front end button on the main Blog page. The roles with post edit capabilities will still be able to create Blog article from the backend.', 'woffice'),
                'options'  => $tt_roles_tmp,
                'default'  => $wiki_create ? $wiki_create :  array('administrator')
            ),
            array(
                'id'       => 'wiki_edit',
                'type'     => 'select',
                'multi'    => true,
                'title'    => __('Who can edit a wiki article ?', 'woffice'), 
                'subtitle' => __('No validation can be done on this field type', 'woffice'),
                'desc'     => __('The roles selected here will be able to edit and delete all blog posts, also if they are not the author of that post (This only affect the frontend).', 'woffice'),
                'options'  => $tt_roles_tmp,
                'default'  => $wiki_edit ? $wiki_edit : array('administrator')
            ),   
            array(
				'id'       => 'override_wiki_by_caps',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use meta capabilities by frontend', 'woffice' ),
				'desc'     => esc_html__( 'If you enable this option, the settings above will be overrided by more specific meta capabilities of the post. You have to use the plugin User Role Editor (or others) to change them.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
                'default'  => $override_wiki_by_caps,
			),        
            array(
                'id'        => 'prm-accordion-end-3',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
            array(
                'id'        => 'prm-accordion-begin-4',
                'type'      => 'accordion',
                'title'     => 'Project options',
                'position'  => 'start',    
            ),
            array(
                'id'       => 'projects_create',
                'type'     => 'select',
                'multi'    => true,
                'title'    => __('Who can create a project article ?', 'woffice'), 
                'desc'     => __('It is only affecting a front end button on the main projects page. The roles with post edit capabilities will still be able to create Projects from the backend.', 'woffice'),
                'options'  => $tt_roles_tmp,
                'default'  => $projects_create ? $projects_create :  array('administrator')
            ),
            array(
				'id'       => 'projects_public',
				'type'     => 'switch',
				'title'    => esc_html__( 'Are the projects public by default?', 'woffice' ),
				'desc'     => esc_html__( 'If enabled, every users can view the projects but only the members assigned to the projects can edit them (this option can be overrided in every single project).', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
                'default'  => $projects_public,
			),
            array(
                'id'        => 'prm-accordion-end-4',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
            array(
                'id'        => 'prm-accordion-begin-5',
                'type'      => 'accordion',
                'title'     => 'Blog Posts options',
                'position'  => 'start',    
            ),
            array(
                'id'       => 'post_create',
                'type'     => 'select',
                'multi'    => true,
                'title'    => __('Who can create a Blog article ?', 'woffice'), 
                'desc'     => __('It is only affecting a front end button on the main Blog page. The roles with post edit capabilities will still be able to create Blog article from the backend.', 'woffice'),
                'options'  => $tt_roles_tmp,
                'default'  => $post_create ? $post_create :  array('administrator')
            ),
            array(
                'id'       => 'post_edit',
                'type'     => 'select',
                'multi'    => true,
                'title'    => __('Who can edit a Blog article ?', 'woffice'), 
                'subtitle' => __('No validation can be done on this field type', 'woffice'),
                'desc'     => __('The roles selected here will be able to edit and delete all blog posts, also if they are not the author of that post (This only affect the frontend).', 'woffice'),
                'options'  => $tt_roles_tmp,
                'default'  => $post_edit ? $post_edit : array('administrator')
            ),   
            array(
				'id'       => 'override_post_by_caps',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use meta capabilities by frontend', 'woffice' ),
				'desc'     => esc_html__( 'If you enable this option, the settings above will be overrided by more specific meta capabilities of the post. You have to use the plugin User Role Editor (or others) to change them.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
                'default'  => $override_post_by_caps,
			),        
            array(
                'id'        => 'prm-accordion-end-5',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
            array(
                'id'        => 'prm-accordion-begin-6',
                'type'      => 'accordion',
                'title'     => 'Directory options',
                'position'  => 'start',    
            ),
            array(
                'id'       => 'directory_create',
                'type'     => 'select',
                'multi'    => true,
                'title'    => __('Who can create a directory item ?', 'woffice'), 
                'desc'     => __('It is only affecting a front end button on the main directory page. The roles with post edit capabilities will still be able to create an item from the backend.', 'woffice'),
                'options'  => $tt_roles_tmp,
                'default'  => $directory_create ? $directory_create :  array('administrator')
            ),    
            array(
                'id'        => 'prm-accordion-end-6',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
            array(
                'id'        => 'prm-accordion-begin-7',
                'type'      => 'accordion',
                'title'     => 'Event options',
                'position'  => 'start',    
            ),
            array(
                'id'       => 'event_create',
                'type'     => 'select',
                'multi'    => true,
                'title'    => __('Who can create an event?', 'woffice'), 
                'desc'     => __('IIt is only affecting a front end button on the main event page. The roles with post edit capabilities will still be able to create an item from the backend.', 'woffice'),
                'options'  => $tt_roles_tmp,
                'default'  => $event_create ? $event_create :  array('administrator')
            ),    
            array(
                'id'        => 'prm-accordion-end-7',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
        ),
	),
);