<?php 

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux' ) ) {
	return;
}


$recatpcha_enable = woffice_unyson_switch_to_bool(woffice_get_settings_option('recatpcha_enable'));
$recatpcha_enable_default = ($recatpcha_enable) ? $recatpcha_enable : false;

$recatpcha_key_site = woffice_get_settings_option('recatpcha_key_site');

$recatpcha_key_secret = woffice_get_settings_option('recatpcha_key_secret');

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Recaptcha Options', 'woffice' ),
		'id'         => 'login-register-recaptcha_options',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,

		'fields'     => array(
			array(
		        'id'       => 'recatpcha_enable',
		        'type'     => 'switch',
		        'title'    => esc_html__('Google ReCaptcha on Register form ?', 'woffice'),
		        'desc'     => esc_html__('Do you want to see a Recaptcha2 checkbox on the register page, if you select "yep" please fill the fields below. Very first thing you need to do is register your website on Google recaptcha to do that click :','woffice'). '<a href="https://www.google.com/recaptcha/">https://www.google.com/recaptcha/</a>',
		        'default'  => $recatpcha_enable_default,
		    ),
			array(
		        'id'    => 'recatpcha_key_site',   
		        'type'  => 'text',
		        'title' => __( 'Recaptcha Site Key', 'woffice' ),
		        'desc'  => __('When you register your site on Google\'s website, you\'ll have 2 keys, a secret key and a site key.','woffice'),
		        'value' => $recatpcha_key_site,
		    ),
			array(
		        'id'    => 'recatpcha_key_secret',   
		        'type'  => 'text',
		        'title' => __( 'Recaptcha Secret Key', 'woffice' ),
		        'desc'  => __('When you register your site on Google\'s website, you\'ll have 2 keys, a secret key and a site key.','woffice'),
		        'value' => $recatpcha_key_secret,
		    ),
		),
	)
);
