<?php
/**
 * Redux Framework font family select config.
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

defined( 'ABSPATH' ) || exit;
$plugins_url = plugins_url();

// PHP VERSION :
$php_version_class = (PHP_VERSION > 5.3) ? 'yes' : 'no';
$php_version = '<i class="dashicons dashicons-'.$php_version_class.'"></i><b>'.PHP_VERSION.'</b>';
// WP VERSION :
$wordpress_version_class = (get_bloginfo('version')  > 4.3) ? 'yes' : 'no';
$wordpress_version = '<i class="dashicons dashicons-'.$php_version_class.'"></i><b>'.get_bloginfo('version').'</b>';
// WP_DEBUG :
$wordpress_debug_label = (defined('WP_DEBUG') && true === WP_DEBUG) ? 'Enabled' : 'Disabled';
$wordpress_debug = '<i class="dashicons dashicons-admin-tools"></i><b>'.$wordpress_debug_label.'</b>';
// WP PLUGINS :
$wordpress_plugins_number = count(get_option('active_plugins'));
$wordpress_plugins_class = ($wordpress_plugins_number < 20) ? 'yes' : 'no';
$wordpress_plugins = '<i class="dashicons dashicons-'.$wordpress_plugins_class.'"></i><b>'.$wordpress_plugins_number.'</b>';
// Woffice Pro
$woffice_key = get_option('woffice_key');
$woffice_key = (!empty( $woffice_key )) ? $woffice_key : 'N/A';


Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Wordpress Status', 'woffice' ),
		'id'         => 'system-status_wordpress_status',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
		    array( 
		        'id'       => 'wordpress_version',
		        'type'     => 'raw',
		        'full_width' => 'true',
		        'title'    => esc_html__('Wordpress Version', 'woffice'),
		        'desc'     => esc_html__('This is the description field for additional info.', 'woffice'),
		        'content'  => $wordpress_version
		    ),
		    array( 
		        'id'       => 'wordpress_debug',
		        'type'     => 'raw',
		        'full_width' => 'true',
		        'title'    => esc_html__('Wordpress Debug', 'woffice'),
		        'desc'     => esc_html__('If enabled all PHP errors will be displayed, if you have an issue like a white page, make sure it\'s enabled.', 'woffice'),
		        'content'  => $wordpress_debug
		    ),
		    array( 
		        'id'       => 'wordpress_path',
		        'type'     => 'raw',
		        'full_width' => 'true',
		        'title'    => esc_html__('Wordpress Path', 'woffice'),
		        'desc'     => esc_html__('The path on your FTP where you\'ve installed your Wordpress files.', 'woffice'),
		        'content'  => '<i class="dashicons dashicons-archive"></i><b> '.ABSPATH.'</b>'
		    ),
		    array( 
		        'id'       => 'wordpress_db_name',
		        'type'     => 'raw',
		        'full_width' => 'true',
		        'title'    => esc_html__('Wordpress Database', 'woffice'),
		        'desc'     => esc_html__('Name of the database where Wordpress has been installed.', 'woffice'),
		        'content'  => '<i class="dashicons dashicons-location"></i><b> '.DB_NAME.'</b>'
		    ),
		    array( 
		        'id'       => 'wordpress_plugins',
		        'type'     => 'raw',
		        'full_width' => 'true',
		        'title'    => esc_html__('Plugins Enabled', 'woffice'),
		        'desc'     => esc_html__('Too many plugins installed can impact heavily your site\'s speed performances.', 'woffice'),
		        'content'  => $wordpress_plugins
		    ),
		    array( 
		        'id'       => 'woffice_key',
		        'type'     => 'raw',
		        'full_width' => 'true',
		        'title'    => esc_html__('Woffice key', 'woffice'),
		        'desc'     => esc_html__('Too many plugins installed can impact heavily your site\'s speed performances.', 'woffice'),
		        'content'  => '<span class="highlight">'.$woffice_key.'</span>',
		    ),
		),
	)
);
