<?php

defined('ABSPATH') || exit;

$enable_wiki_extenstion = $enable_woffice_event = $enable_directory_extention = $enable_birthday_extention = $enable_funfacts_extention = $enable_autofriends_extention = false;

if (woffice_is_extension_active('woffice-wiki')) {
    $enable_wiki_extenstion = true;
}

if (woffice_is_extension_active('woffice-event')) {
    $enable_woffice_event = true;
}

if (woffice_is_extension_active('woffice-directory')) {
    $enable_directory_extention = true;
}

if (woffice_is_extension_active('woffice-birthdays')) {
    $enable_birthday_extention = true;
}

if (woffice_is_extension_active('woffice-funfacts')) {
    $enable_funfacts_extention = true;
}

if (woffice_is_extension_active('woffice-auto-friends')) {
    $enable_autofriends_extention = true;
}

if (!function_exists('redux_icon_select_fa_5_free')) {
    require_once WOFFICE_CORE_PATH . 'libs/redux-framework/redux-core/inc/extensions/icon_select/font-awesome-5-free.php';
}

$directory_option_default = get_option('woffice_theme_options');
$default_fields = get_option('fw_ext_settings_options:woffice-directory');
//
if (!empty($default_fields)) {
    $new_field = array();
    foreach ($default_fields['default_fields'] as $key => $field) {
        $new_field['redux_repeater_data'][]['title'] = '';
        $new_field['directory_default_title'][] = $field['title'];
        $new_field['directory_default_icon'][] = $field['icon'];
    }
    if (!empty($new_field) && isset($directory_option_default['directory_default_fields']) && !empty($directory_option_default['directory_default_fields'])) {
        Redux::set_option($opt_name, 'directory_default_fields', $new_field);
    }
}

$woffice_calendar_old_option = get_option('fw_ext_settings_options:woffice-event');
$woffice_birthday_old_option = get_option('fw_ext_settings_options:woffice-birthdays');
$woffice_cover_old_option = get_option('fw_ext_settings_options:woffice-cover');

$woffice_autofriend_info = '';
$woffice_autofriend_info .= '<b>'. __('Once enabled, any new user registered will be automatically made "friend" with all other users.', 'woffice') .'</b>';

if (!woffice_bp_is_active('friends')) {
	$woffice_autofriend_info .= '<div class="error notice is-dismissable">';
		$woffice_autofriend_info .= sprintf( '<p>%s <a href="'. admin_url('admin.php?page=bp-components') .'">%s</a>.</p>',
			__( 'This extension requires BuddyPress and the Friends component enabled. You can activate them from your', 'woffice' ),
			__( 'BuddyPress settings', 'woffice' )
		);
	$woffice_autofriend_info .= '</div>';
} else {
	$woffice_autofriend_info .= '<hr>';
	$woffice_autofriend_info .= '<p>'. __('You can re-create them with button underneath. It is an expensive operation for your server and might take more than 1 minute.','woffice') .'</p>';
	$woffice_autofriend_info .= sprintf('<a href="%s" class="button-secondary">Run relationships</a>',admin_url('themes.php?page=woffice_theme_options&woffice-extension=woffice-auto-friends&woffice-auto-friends-run=true'));
}

$woffice_autofriends_status = get_option('fw_ext_settings_options:woffice-auto-friends');

$auto_friend_status = isset($woffice_autofriends_status['status']) && $woffice_autofriends_status['status'] == 'disabled' ? false : true; 

$woffice_maintenance_old_option = get_option('fw_ext_settings_options:woffice-maintenance');

$woffice_member_map_old_option = get_option('fw_ext_settings_options:woffice-map');

$woffice_poll_old_option = get_option('fw_ext_settings_options:woffice-poll');

$woffice_migrated_option = woffice_get_theming_option('woffice_poll_answers');
if(isset($woffice_poll_old_option['answers']) && !empty($woffice_poll_old_option['answers']) && !empty($woffice_migrated_option)) {
	// Redux::set_option( 'woffice_theme_options', 'woffice_poll_answers', $woffice_poll_old_option['answers']);
}

$test_coordinates = array();
$status = 'No status found';
if(class_exists('Woffice_Extension_Map')){
	$test_coordinates = Woffice_Extension_Map::mapApiTest();
	if(isset($test_coordinates['status']) ){
		$status .= __('This is the status of your GeoCoding API connection (helps for debugging)', 'woffice') . ' :<br> <span class="highlight">'.$test_coordinates['status'].'</span>';}
	if(isset($test_coordinates['error_message'])){
		$status .= '<br>' . __('Google API also returned the following message', 'woffice') . ' :<br> <span class="highlight">'.$test_coordinates['error_message'].'</span>';}
}

$days = [
    'monday'    => __('Monday', 'woffice'),
    'tuesday'   => __('Tuesday', 'woffice'),
    'wednesday' => __('Wednesday', 'woffice'),
    'thursday'  => __('Thursday', 'woffice'),
    'friday'    => __('Friday', 'woffice'),
    'saturday'  => __('Saturday', 'woffice'),
    'sunday'    => __('Sunday', 'woffice')
];

$status = get_option('woffice_license');
$status_ready = ($status == "checked") ? "Checked" : "Not Checked";

$url = get_site_url() . "/wp-admin/admin-ajax.php?action=slack_callback";
$slack_status = $slack_button = $slack_notice = '';
if(!class_exists('Woffice_Extension_Woffice_Slack')){
    include_once(WOFFICE_CORE_PATH . '/extensions/woffice-slack/functions.php');
}
if(class_exists('Woffice_Extension_Woffice_Slack')){
	Woffice_Extension_Woffice_Slack::initialize_slack_interface();

	if(Woffice_Extension_Woffice_Slack::is_authenticated()){
		$slack_button = sprintf('<a class="button-secondary" href="%s">Choose another Slack channel</a>',admin_url('admin.php?page=woffice_theme_options&extension=woffice-slack&clear-channel=yes'));
		$slack_status = '<span class="highlight">'. __('Authenticated', 'woffice') .'</span><br><br>'.$slack_button;
	} else {
		$slack_button = '<a href="https://slack.com/oauth/authorize?scope=incoming-webhook,commands&client_id='. Woffice_Extension_Woffice_Slack::get_client_id() .'"><img alt="Add to Slack" height="40" width="139" src="https://platform.slack-edge.com/img/add_to_slack.png" srcset="https://platform.slack-edge.com/img/add_to_slack.png 1x, https://platform.slack-edge.com/img/add_to_slack@2x.png 2x"></a>';
		$slack_status = '<span class="highlight">'. __('Not authenticated', 'woffice') .'</span><br><br>'. $slack_button;
	}

	$slack_notice = __('You need to create a new application on Slack','woffice').' <a href="https://api.slack.com/apps" target="_blank">'. __('Create a new application','woffice') .'</a>.<br><br>';
	$slack_notice .= '<a href="https://docs.woffice.io/" target="_blank">'. __('First time ? Follow our tutorial','woffice') .'</a>';
}

$notice = __('You need to create a new application on Slack','woffice').' <a href="https://api.slack.com/apps" target="_blank">'. __('Create a new application','woffice') .'</a>.<br><br>';
$notice .= '<a href="https://docs.woffice.io/" target="_blank">'. __('First time ? Follow our tutorial','woffice') .'</a>';
$html = '';
if (!woffice_bp_is_active('notifications')) {
    $html = '<div>';
    $html .= '<h4>' . __('Live push notificatons are not enabled...', 'woffice') . '</h4>';
    $html .= '<p>' . __('The BuddyPress live push notifications component must be enabled in order to use this plugin. Enable it on',
            'woffice');
    $html .= ' <a href="' . get_admin_url() . 'options-general.php?page=bp-components">' . __('the BuddyPress settings page here',
            'woffice') . '</a>.</p>';
    $html .= '</div>';
} elseif (empty(woffice_get_https_protocol()) || strpos($_SERVER['SERVER_NAME'], 'localhost') !== false) {
    $html = '<div class="is-dismissable">';
    $html .= '<h4>' . __('Push notification will not work without SSL', 'woffice') . '</h4>';
    $html .= '<p>' . __('The BuddyPress live notifications component will only work if you have SSL enabled.',
            'woffice') . '</p>';
    $html .= '</div>';
}

$fields = array();

$wiki_directory_field[] = array(
    'id' => 'wiki-ext-accordion-begin-1',
    'type' => 'accordion',
    'title' => 'Wiki',
    'position' => 'start',
);
$wiki_directory_field[] = array(
    'id' => 'enable_wiki_extenstion',
    'type' => 'switch',
    'title' => esc_html__('Enable Wiki Extension', 'woffice'),
    'on' => esc_html__('Yes', 'woffice'),
    'off' => esc_html__('No', 'woffice'),
    'default' => function_exists('woffice_is_extension_active') ? woffice_is_extension_active('woffice-wiki') : false,
);
$wiki_directory_field[] = array(
    'id' => 'wiki-ext-accordion-end-1',
    'type' => 'accordion',
    'position' => 'end',
);
$wiki_directory_field[] = array(
    'id' => 'directory-ext-accordion-begin-2',
    'type' => 'accordion',
    'title' => 'Directory',
    'position' => 'start',
);
$wiki_directory_field[] = array(
    'id' => 'enable_directory_extenstion',
    'type' => 'switch',
    'title' => esc_html__('Enable Directory Extension', 'woffice'),
    'on' => esc_html__('Yes', 'woffice'),
    'off' => esc_html__('No', 'woffice'),
    'default' => function_exists('woffice_is_extension_active') ? woffice_is_extension_active('woffice-directory') : false,
);
$wiki_directory_field[] = array(
    'id' => 'directory_custom_post_name',
    'type' => 'text',
    'title' => esc_html__('Directory item name', 'woffice'),
    'desc' => esc_html__('This is the name in the Wordpress menus, like Job, Partners, Corporates...', 'woffice'),
    'default' => '',
);
$wiki_directory_field[] = array(
    'id' => 'directory_map_zoom',
    'type' => 'slider',
    'title' => esc_html__('Slider Example 1', 'woffice'),
    'desc' => esc_html__('Just the level of zooming in the map (Main directory page).', 'woffice'),
    'default' => 1,
    'min' => 0,
    'step' => 1,
    'max' => 21,
    'display_value' => 'label',
);
$wiki_directory_field[] = array(
    'id' => 'directory_map_center',
    'type' => 'google_maps',
    'title' => esc_html__('Google Maps', 'woffice'),
    'subtitle' => esc_html__('This map is set using only address information with a zoom factor of 3.  Lat/Long is returned automatically.', 'woffice'),
    'show_api_key' => true,
    'show_marker_info' => false,
    'api_key' => isset($default_fields['map_key']) ? $default_fields['map_key'] : woffice_get_theming_option('gmap_api_key'),
    'default' => array(
        'zoom' => '17', // Zoom far: 3 zoom close 17.
        'street_number' => '1600', // Address.
        'route' => 'Pennsylvania Avenue', // STREET.
        'locality' => 'Washington', // CITY.
        'administrative_area_level_1' => 'DC', // STATE.
        'postal_code' => '20500',
        'country' => 'United States',
        'latitude' => 38.8976758,
        'longitude' => -77.03648229999999,
    ),
);
$wiki_directory_field[] = array(
    'id' => 'directory_filter',
    'type' => 'switch',
    'title' => esc_html__('Enable category filter', 'woffice'),
    'on' => esc_html__('Yes', 'woffice'),
    'off' => esc_html__('No', 'woffice'),
    'default' => '',
);
$wiki_directory_field[] = array(
    'id' => 'directory_default_fields',
    'type' => 'repeater',
    'title' => esc_html__('Default fields', 'woffice'),
    'full_width' => false,
    'subtitle' => '',
    'item_name' => '',
    'sortable' => true,
    'active' => false,
    'collapsible' => false,
    'group_values' => true,
    'fields' => array(
        array(
            'id' => 'directory_default_title',
            'type' => 'text',
            'title' => esc_html__('Name', 'woffice'),
            'default' => '',
        ),
        array(
            'id' => 'directory_default_value',
            'type' => 'text',
            'title' => esc_html__('Default value', 'woffice'),
            'default' => '',
        ),
        array(
            'id' => 'directory_default_icon',
            'type' => 'icon_select',
            'title' => esc_html__('Legacy Icon Select', 'woffice'),
            'default' => '',
            'options' => redux_icon_select_fa_5_free(),
            'enqueue' => true,
            'enqueue_frontend' => true,
            'stylesheet' => 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.9.0/css/all.css',
            'prefix' => 'fa',
        ),
    ),
);

$wiki_directory_field[] = array(
    'id' => 'directory-ext-accordion-end-2',
    'type' => 'accordion',
    'position' => 'end',
);

$fields = array_merge($fields, $wiki_directory_field);

$woffice_evenet_ext = array();

$woffice_evenet_ext[] = array(
    'id' => 'event-ext-accordion-begin-2',
    'type' => 'accordion',
    'title' => 'Woffice Event',
    'position' => 'start',
);
$woffice_evenet_ext[] = array(
    'id' => 'enable_woffice_event_extenstion',
    'type' => 'switch',
    'title' => esc_html__('Enable Woffice Event Extension', 'woffice'),
    'on' => esc_html__('Yes', 'woffice'),
    'off' => esc_html__('No', 'woffice'),
    'default' => $enable_woffice_event,

);
$woffice_evenet_ext[] = array(
    'id' => 'woffice_calendar_days',
    'type' => 'select',
    'multi' => true,
    'title' => esc_html__('Days', 'woffice'),
    'desc' => esc_html__("Select the days that'll show up in the calendar.", 'woffice'),
    'options' => $days,
    'default' => isset($woffice_calendar_old_option['woffice_calendar_days']) ? $woffice_calendar_old_option['woffice_calendar_days'] : array_keys($days),

);
$woffice_evenet_ext[] = array(
    'id' => 'woffice_calendar_starting_day',
    'type' => 'select',
    'title' => esc_html__('Starting day', 'woffice'),
    'desc' => esc_html__('Select starting day.', 'woffice'),
    'options' => $days,
    'default' => isset($woffice_calendar_old_option['woffice_calendar_starting_day']) ? $woffice_calendar_old_option['woffice_calendar_starting_day'] : 'monday',

);
$woffice_evenet_ext[] = array(
    'id' => 'woffice_calendar_status',
    'type' => 'select',
    'title' => esc_html__('Default status', 'woffice'),
    'options' => array(
        'publish' => esc_html__('Publish', 'woffice'),
        'draft' => esc_html__('Draft', 'woffice'),
        'pending' => esc_html__('Pending', 'woffice'),
    ),
    'default' => isset($woffice_calendar_old_option['woffice_calendar_status']) ? $woffice_calendar_old_option['woffice_calendar_status'] : 'publish',
);
$woffice_evenet_ext[] = array(
    'id' => 'event-ext-accordion-end-1',
    'type' => 'accordion',
    'position' => 'end',
);

$fields = array_merge($fields, $woffice_evenet_ext);

$birtday_ext = array();

$birtday_ext[] = array(
    'id' => 'woffice-birthday-ext-accordion-begin-1',
    'type' => 'accordion',
    'title' => 'Woffice Birthdays',
    'position' => 'start',
);
$birtday_ext[] = array(
    'id' => 'enable_woffice_birthday_extenstion',
    'type' => 'switch',
    'title' => esc_html__('Enable Woffice Bithdays', 'woffice'),
    'on' => esc_html__('Yes', 'woffice'),
    'off' => esc_html__('No', 'woffice'),
    'default' => $enable_birthday_extention,
);
$birtday_ext[] = array(
    'id' => 'display_age',
    'type' => 'switch',
    'title' => esc_html__('Show the age of the person', 'woffice'),
    'desc' => esc_html__('In the widget beside the name', 'woffice'),
    'on' => esc_html__('Yes', 'woffice'),
    'off' => esc_html__('No', 'woffice'),
    'default' => isset($woffice_birthday_old_option['display_age']) ? $woffice_birthday_old_option['display_age'] : '',
);
$birtday_ext[] = array(
    'id' => 'birthday_date_format',
    'type' => 'text',
    'title' => esc_html__('Date Format', 'woffice'),
    'desc' => esc_html__('In the widget beside the name', 'woffice'),
    'default' => isset($woffice_birthday_old_option['birthday_date_format']) ? $woffice_birthday_old_option['birthday_date_format'] : '',
);
$birtday_ext[] = array(
    'id' => 'birthdays_range_limit',
    'type' => 'select',
    'title' => esc_html__('Birthday range limit', 'woffice'),
    'desc' => esc_html__('Select birthday range.', 'woffice'),
    'options' => array(
        'no_limit' => esc_html__('No Limit', 'woffice'),
        'weekly' => esc_html__('Weekly', 'woffice'),
        'monthly' => esc_html__('Monthly', 'woffice'),
    ),
    'default' => isset($woffice_birthday_old_option['birthdays_range_limit']) ? $woffice_birthday_old_option['birthdays_range_limit'] : 'no_limit',
);
$birtday_ext[] = array(
    'id' => 'birthday_field_name',
    'type' => 'text',
    'title' => esc_html__("Field's name", 'woffice'),
    'desc' => esc_html__("This is the name of the field available in the user's profile", 'woffice'),
    'default' => isset($woffice_birthday_old_option['birthday_field_name']) ? $woffice_birthday_old_option['birthday_field_name'] : '',
);
$birtday_ext[] = array(
    'id' => 'birthdays_to_display',
    'type' => 'text',
    'title' => esc_html__("Number of birthdays to show", 'woffice'),
    'desc' => esc_html__("The max number of elements to show in the list.", 'woffice'),
    'validate' => 'numeric',
    'default' => isset($woffice_birthday_old_option['birthdays_to_display']) ? $woffice_birthday_old_option['birthdays_to_display'] : '',
);
$birtday_ext[] = array(
    'id' => 'woffice-birthday-ext-accordion-end-1',
    'type' => 'accordion',
    'position' => 'end',
);

$fields = array_merge($fields, $birtday_ext);

$funcfact_ext = array();

$funcfact_ext[] = array(
    'id' => 'woffice-funfacts-ext-accordion-begin-1',
    'type' => 'accordion',
    'title' => 'Woffice Fun Facts',
    'position' => 'start',
);
$funcfact_ext[] = array(
    'id' => 'enable_woffice_funfacts_extenstion',
    'type' => 'switch',
    'title' => esc_html__('Enable Fun Facts', 'woffice'),
    'on' => esc_html__('Yes', 'woffice'),
    'off' => esc_html__('No', 'woffice'),
    'default' => $enable_funfacts_extention,
);
$funcfact_ext[] = array(
    'id' => 'woffice_funfacts_fields',
    'type' => 'repeater',
    'title' => esc_html__('Fun Facts', 'woffice'),
    'full_width' => false,
    'subtitle' => '',
    'item_name' => '',
    'sortable' => true,
    'active' => false,
    'collapsible' => false,
    'group_values' => true,
    'limit' => 10,
    'fields' => array(
        array(
            'id' => 'fact_content',
            'type' => 'textarea',
            'title' => esc_html__('Fact content', 'woffice'),
            'default' => '',
        ),
        array(
            'id' => 'fact_icon',
            'type' => 'icon_select',
            'title' => esc_html__('Fact icon', 'woffice'),
            'default' => '',
            'options' => redux_icon_select_fa_5_free(),
            'enqueue' => true,
            'enqueue_frontend' => true,
            'stylesheet' => 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.9.0/css/all.css',
            'prefix' => 'fa',
        ),
    ),
);
$funcfact_ext[] = array(
    'id' => 'woffice-funfacts-ext-accordion-end-1',
    'type' => 'accordion',
    'position' => 'end',
);

$fields = array_merge($fields, $funcfact_ext);

$cover_ext = array();

$cover_ext[] = array(
    'id' => 'woffice-cover-ext-accordion-begin-1',
    'type' => 'accordion',
    'title' => 'Woffice Cover',
    'position' => 'start',
);
$cover_ext[] = array(
    'id' => 'enable_woffice_cover_image_extenstion',
    'type' => 'switch',
    'title' => esc_html__('Enable Woffice Cover', 'woffice'),
    'on' => esc_html__('Yes', 'woffice'),
    'off' => esc_html__('No', 'woffice'),
    'default' => $enable_funfacts_extention,
);
$cover_ext[] = array(
    'id' => 'cover_default',
    'type' => 'media',
    'url' => true,
    'title' => esc_html__('Default Cover', 'woffice'),
    'desc' => esc_html__("It is an optional option, it's not required", 'woffice'),
    'compiler' => 'true',
    'preview_size' => 'thumbnail',
    'default' => array(
        'url' => isset($woffice_cover_old_option['cover_default']['url']) ? $woffice_cover_old_option['cover_default']['url'] : '',
        'id' => isset($woffice_cover_old_option['cover_default']['attachment_id']) ? $woffice_cover_old_option['cover_default']['attachment_id'] : '',
    ),
);
$cover_ext[] = array(
    'id' => 'woffice-cover-ext-accordion-end-1',
    'type' => 'accordion',
    'position' => 'end',
);

$fields = array_merge($fields, $cover_ext);

$auto_friend_ext = array();

$auto_friend_ext[] = array(
    'id' => 'woffice-auto-friends-ext-accordion-begin-1',
    'type' => 'accordion',
    'title' => 'Woffice Auto Friends',
    'position' => 'start',
);
$auto_friend_ext[] = array(
    'id' => 'enable_woffice_cover_image_extenstion',
    'type' => 'switch',
    'title' => esc_html__('Enable Woffice Auto Friends', 'woffice'),
    'desc' => esc_html__('Please select status after activating this extension', 'woffice'),
    'on' => esc_html__('Yes', 'woffice'),
    'off' => esc_html__('No', 'woffice'),
    'default' => $enable_autofriends_extention,
);
$auto_friend_ext[] = array(
    'id' => 'woffice_autofriend_info',
    'type' => 'raw',
    'full_width' => 'true',
    'title' => esc_html__('Info', 'woffice'),
    'content' => $woffice_autofriend_info,
);
$auto_friend_ext[] = array(
    'id' => 'woffice_autofriends_status',
    'type' => 'switch',
    'title' => esc_html__('Status', 'woffice'),
    'desc' => esc_html__('You can switch between "Enable" / "Disable"', 'woffice'),
    'on' => esc_html__('Enable', 'woffice'),
    'off' => esc_html__('Disable', 'woffice'),
    'default' => $auto_friend_status,
);
$auto_friend_ext[] = array(
    'id' => 'woffice-auto-friends-ext-accordion-end-1',
    'type' => 'accordion',
    'position' => 'end',
);

$fields = array_merge($fields, $auto_friend_ext);

$maintenance_ext = array();

$maintenance_ext[] = array(
    'id' => 'woffice-maintenance-ext-accordion-begin-1',
    'type' => 'accordion',
    'title' => 'Woffice Maintenance',
    'position' => 'start',
);
$maintenance_ext[] = array(
    'id' => 'enabe_woffice_maintenance',
    'type' => 'switch',
    'title' => esc_html__('Status', 'woffice'),
    'desc' => esc_html__('You can switch between "Enable" / "Disable"', 'woffice'),
    'on' => esc_html__('Enable', 'woffice'),
    'off' => esc_html__('Disable', 'woffice'),
    'default' => '',
);
$maintenance_ext[] = array(
    'id' => 'woffice-maintenance-tabbed-1',
    'type' => 'tabbed',
    'title' => 'Woffice Maintenance Settings',
    'tabs' => array(
        array(
            'title' => 'Content',
            'icon' => 'fas fa-gear',
            'fields' => array(
                array(
                    'id' => 'woffice_maintenance_info',
                    'type' => 'raw',
                    'full_width' => 'true',
                    'title' => esc_html__('Important', 'woffice'),
                    'content' => '<b>Please note that when this option is activated, it creates a new page with the name "Maintenance</b>".
					That said, please make sure this page was created, or else, simply create it with the default template. We simply need the name to be right.',
                ),
                array(
                    'id' => 'woffice_maintenance_status',
                    'type' => 'switch',
                    'title' => esc_html__('Status', 'woffice'),
                    'desc' => esc_html__("Once enabled it'll redirects all the visitors/members to the maintenance page.", 'woffice'),
                    'on' => esc_html__('Enable', 'woffice'),
                    'off' => esc_html__('Disable', 'woffice'),
                    'default' => isset($woffice_maintenance_old_option['maintenance_status']) && $woffice_maintenance_old_option['maintenance_status'] == 'on' ? true : false,
                ),
                array(
                    'id' => 'maintenance_headline',
                    'type' => 'text',
                    'title' => esc_html__('Headline', 'woffice'),
                    'desc' => esc_html__('This is the headline displayed on the page.', 'woffice'),
                    'default' => isset($woffice_maintenance_old_option['maintenance_headline']) ? $woffice_maintenance_old_option['maintenance_headline'] : '',
                ),
                array(
                    'id' => 'maintenance_text',
                    'type' => 'editor',
                    'title' => esc_html__('Content', 'woffice'),
                    'desc' => esc_html__('This is the content of the email before the task name. Dynamic variables that will be replaced automatically: {user_name}, {project_url}, {project_title}, {todo_title}', 'woffice'),
                    'default' => isset($woffice_maintenance_old_option['maintenance_text']) ? $woffice_maintenance_old_option['maintenance_text'] : '',
                    'args' => array(
                        'media_buttons' => false,
                        'teeny' => false,
                        'textarea_rows' => 5,
						'quicktags'     => false,
                    ),
                ),
            ),
        ),
        array(
            'title' => 'Style',
            'icon' => 'fas fa-font',
            'fields' => array(
                array(
                    'id' => 'maintenance_color',
                    'type' => 'color',
                    'title' => esc_html__('Text color', 'woffice'),
                    'subtitle' => esc_html__('This is the text color over the image.', 'woffice'),
                    'default' => isset($woffice_maintenance_old_option['maintenance_color']) ? $woffice_maintenance_old_option['maintenance_color'] : '',
                    'transparent' => false,
                    'color_alpha' => false,
                ),
                array(
                    'id' => 'maintenance_bg_color',
                    'type' => 'color',
                    'title' => esc_html__('Background color', 'woffice'),
                    'subtitle' => esc_html__('This is the background color and the image will be over it.', 'woffice'),
                    'default' => isset($woffice_maintenance_old_option['maintenance_bg_color']) ? $woffice_maintenance_old_option['maintenance_bg_color'] : '',
                    'transparent' => false,
                    'color_alpha' => false,
                ),
                array(
                    'id' => 'maintenance_bg_image',
                    'type' => 'media',
                    'url' => true,
                    'title' => esc_html__('Background Image', 'woffice'),
                    'desc' => esc_html__("Large Image on fullscreen.", 'woffice'),
                    'compiler' => 'true',
                    'preview_size' => 'thumbnail',
                    'default' => array(
                        'url' => isset($woffice_maintenance_old_option['maintenance_bg_image']['url']) ? $woffice_maintenance_old_option['maintenance_bg_image']['url'] : '',
                        'id' => isset($woffice_maintenance_old_option['maintenance_bg_image']['attachment_id']) ? $woffice_maintenance_old_option['maintenance_bg_image']['attachment_id'] : '',
                    ),
                ),
                array(
                    'id' => 'maintenance_layer_opacity',
                    'type' => 'slider',
                    'title' => esc_html__('Layer Opacity', 'woffice'),
                    'desc' => esc_html__('This is the opacity of the layer with the color over the background image.', 'woffice'),
                    'min' => 0,
                    'step' => .1,
                    'max' => 1,
                    'resolution' => 0.1,
                    'display_value' => 'label',
                    'default' => isset($woffice_maintenance_old_option['maintenance_layer_opacity']) ? $woffice_maintenance_old_option['maintenance_layer_opacity'] : '',
                ),
                array(
                    'id' => 'maintenance_icon',
                    'type' => 'icon_select',
                    'title' => esc_html__('icon', 'woffice'),
                    'desc' => esc_html__('This is an extra icon so it looks better.', 'woffice'),
                    'default' => isset($woffice_maintenance_old_option['maintenance_icon']) ? $woffice_maintenance_old_option['maintenance_icon'] : '',
                    'options' => redux_icon_select_fa_5_free(),
                    'enqueue' => true,
                    'enqueue_frontend' => true,
                    'stylesheet' => 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.9.0/css/all.css',
                    'prefix' => 'fa',
                ),
            ),
        ),
    ),
);
$maintenance_ext[] = array(
    'id' => 'woffice-maintenance-accordion-end-1',
    'type' => 'accordion',
    'position' => 'end',
);

$fields = array_merge($fields, $maintenance_ext);

$member_map_ext = array();

$member_map_ext[] = array(
	'id'        => 'woffice-member-map-ext-accordion-begin-1',
	'type'      => 'accordion',
	'title'     => 'Members Map',
	'position'  => 'start',    
);
$member_map_ext[] = array(
	'id'       => 'enable_woffice_member_map_extenstion',
	'type'     => 'switch',
	'title'    => esc_html__( 'Enable Members Map', 'woffice' ),
	'on'       => esc_html__('Yes','woffice'),
	'off'      => esc_html__('No','woffice'),
	'default'  => function_exists('woffice_is_extension_active') ? woffice_is_extension_active('woffice-map') : false,
);
$member_map_ext[] = array(
	'id'       => 'woffice_map_api',
	'type'     => 'text',
	'title'    => esc_html__( 'Map api', 'woffice' ),
	'desc'     => __( 'We are using the GeoCoding Google API to get coordinates from users locations. By default it is working with our API key but as there are many Woffice around, the Quota (2500 requests per day) may be reached really quickly so the map will no longer be available. That is why it is important to use you own Google API key. Please see <a href="https://docs.woffice.io/">: Tutorial</a>', 'woffice' ),
	'default'  =>isset($woffice_member_map_old_option['map_api']) ? $woffice_member_map_old_option ['map_api'] : '',
);
$member_map_ext[] = array( 
	'id'       => 'refresh_all_coordinates',
	'type'     => 'raw',
	'full_width' => 'true',
	'title'    => esc_html__('Refresh All Coordinates', 'woffice'),
	'content'  => sprintf(sprintf('<a href="%s" class="button-secondary">Run relationships</a>',admin_url('admin.php?page=woffice_theme_options&extension=woffice-map&refresh_all_coordinates=done'))),
);
$member_map_ext[] = array( 
	'id'       => 'woffice_map_status',
	'type'     => 'raw',
	'full_width' => 'true',
	'title'    => esc_html__('Map status', 'woffice'),
	'content'  => $status,
);
$member_map_ext[] = array(
	'id'       => 'woffice_member_map_field_name',
	'type'     => 'text',
	'title'    => esc_html__( "Field's name", 'woffice' ),
	'desc'     => __( "This is the name of the field available in the user's profile", 'woffice' ),
	'default'  => isset($woffice_member_map_old_option['map_field_name']) ? $woffice_member_map_old_option ['map_field_name'] : '',
);
$member_map_ext[] = array(
	'id'            => 'woffice_member_map_zoom',
	'type'          => 'slider',
	'title'         => esc_html__( 'Zoom level', 'woffice' ),
	'desc'          => esc_html__( 'Just the level of zooming in the map.', 'woffice' ),
	'default'       => isset($woffice_member_map_old_option['map_zoom']) ? $woffice_member_map_old_option ['map_zoom'] : '',
	'min'           => 0,
	'step'          => 1,
	'max'           => 21,
	'display_value' => 'label',
);
$member_map_ext[] = array(
	'id'           => 'woffice_map_center',
	'type'         => 'google_maps',
	'title'        => esc_html__( 'Center', 'woffice' ),
	'subtitle'     => esc_html__( 'This is the center of the map.', 'woffice' ),
	'show_api_key' => false,
	'show_marker_info' => false,
	'api_key' => isset($woffice_member_map_old_option['map_api']) ? $woffice_member_map_old_option ['map_api'] : '',
	'default'      => array(
		'zoom'                        => '17', // Zoom far: 3 zoom close 17.
		'street_number'               => '1600', // Address.
		'route'                       => 'Pennsylvania Avenue', // STREET.
		'locality'                    => 'Washington', // CITY.
		'administrative_area_level_1' => 'DC', // STATE.
		'postal_code'                 => '20500',
		'country'                     => 'United States',
		'latitude'  => 38.8976758,
		'longitude' => - 77.03648229999999,
	),
);
$member_map_ext[] = array(
	'id'       => 'woffice_map_localization',
	'type'     => 'switch',
	'title'    => esc_html__( 'Show localization button', 'woffice' ),
	'on'       => esc_html__('Yes','woffice'),
	'off'      => esc_html__('No','woffice'),
	'default'  => isset($woffice_member_map_old_option['map_localization']) ? $woffice_member_map_old_option ['map_localization'] : '',
);
$member_map_ext[] = array(
	'id'        => 'woffice-member-map-ext-accordion-end-1',
	'type'      => 'accordion',
	'position'  => 'end'
);

$fields = array_merge($fields,$member_map_ext);

$poll_ext = array();
if(!class_exists('Woffice_Extension_Woffice_Poll')) {
	include_once(WOFFICE_CORE_PATH . '/extensions/woffice-poll/functions.php');
}
$poll_ext[] = array(
	'id'        => 'woffice-poll-ext-accordion-begin-1',
	'type'      => 'accordion',
	'title'     => 'Woffice Poll',
	'position'  => 'start',    
);
$poll_ext[] = array(
	'id'       => 'enable_woffice_poll_extenstion',
	'type'     => 'switch',
	'title'    => esc_html__( 'Enable Woffice Poll', 'woffice' ),
	'on'       => esc_html__('Yes','woffice'),
	'off'      => esc_html__('No','woffice'),
	'default'  => function_exists('woffice_is_extension_active') ? woffice_is_extension_active('woffice-poll') : false,
);

$poll_nonce = wp_create_nonce('poll_nonce');
$poll_ext[] = array(
	'id'    => 'woffice-poll-tabbed-1',
	'type'  => 'tabbed',
	'title' => 'Woffice Poll Settings',
	'tabs'  => array(
		array(
			'title'  => 'Build Poll',
			'icon'   => 'fas fa-gear',
			'fields' => array(
				array(
					'id'       => 'woffice_poll_info',
					'type'     => 'raw',
					'full_width' => 'true',
					'title'    => esc_html__( 'Information', 'woffice' ),
					'desc'     => esc_html__( 'This is the name in the Wordpress menus, like Job, Partners, Corporates...', 'woffice' ),
					'content'  => 'All the answers, results and users votes can be refreshed when you deactivate/activate the poll extension.',
				),
				array(
					'id'       => 'woffice_poll_question',
					'type'     => 'text',
					'title'    => esc_html__( 'Poll Question', 'woffice' ),
					'desc'     => esc_html__( 'This is the name in the Wordpress menus, like Job, Partners, Corporates...', 'woffice' ),
					'default'  => '',
				),
				array(
					'id'       => 'woffice_poll_answers',
					'type'     => 'multi_text',
					'title'    => esc_html__( 'Poll answers', 'woffice' ),
					'desc'     => esc_html__( 'These questions will be displayed within the widget in Woffice.', 'woffice' ),
				),
				array(
					'id'       => 'woffice_poll_logged_only',
					'type'     => 'switch',
					'title'    => esc_html__( 'Only for logged Users', 'woffice' ),
					'on'       => esc_html__('Yes','woffice'),
					'off'      => esc_html__('No','woffice'),
					'default'  => '',
				),
				
				array(
					'id'       => 'woffice_poll_result',
					'type'     => 'raw',
					'full_width' => 'true',
					'title'    => esc_html__( 'Export/Delete', 'woffice' ),
					'desc'     => esc_html__( 'This is the name in the Wordpress menus, like Job, Partners, Corporates...', 'woffice' ),
					'content'  => sprintf( '<a class="button-secondary" style="margin-right:10px;" href="%1$s">Export results</a><a class="button-secondary" onClick="return confirm('.__("'Are you sure you want to delete?'",'woffice').')" href="%2$s">Delete Poll</a>',admin_url('admin.php?page=woffice_theme_options&extension=woffice-poll&export_poll=yes&nonce='.$poll_nonce),admin_url('admin.php?page=woffice_theme_options&delete_poll=yes&nonce='.$poll_nonce)),
				),
			)
		),
		array(
			'title'  => 'Results',
			'icon'   => 'fas fa-score',
			'fields' => array(
				array(
					'id'       => 'woffice_poll_result',
					'type'     => 'raw',
					'full_width' => 'true',
					'title'    => esc_html__( 'Results', 'woffice' ),
					'desc'     => esc_html__( 'This is the name in the Wordpress menus, like Job, Partners, Corporates...', 'woffice' ),
					'content'  => class_exists('Woffice_Extension_Woffice_Poll') ? Woffice_Extension_Woffice_Poll::woffice_poll_get_results_backend('no') : '',
				),
			),
		),
	),
);
$poll_ext[] = array(
	'id'        => 'woffice-poll-accordion-end-1',
	'type'      => 'accordion',
	'position'  => 'end'
);

$fields = array_merge($fields,$poll_ext);

$time_track_ext = array();

$time_track_ext[] = array(
	'id'        => 'woffice-time-tracking-ext-accordion-begin-1',
	'type'      => 'accordion',
	'title'     => 'Woffice Time Tracking',
	'position'  => 'start',    
);
$time_track_ext[] = array(
	'id'       => 'enable_woffice_timetrack_extenstion',
	'type'     => 'switch',
	'title'    => esc_html__( 'Enable Woffice Time Tracking', 'woffice' ),
	'on'       => esc_html__('Yes','woffice'),
	'off'      => esc_html__('No','woffice'),
	'default'  => function_exists('woffice_is_extension_active') ? woffice_is_extension_active('woffice-time-tracking') : false,
);
$time_track_ext[] = array(
	'id'       => 'woffice_timetrack_user',
	'type'     => 'raw',
	'full_width' => 'true',
	'title'    => esc_html__( 'Select an user', 'woffice' ),
	'content'  => sprintf('%s',woffice_render_widget_view(WOFFICE_CORE_PATH. '/extensions/woffice-time-tracking/views/log.php')),
);
$time_track_ext[] = array(
	'id'       => 'woffice_timetrack_export',
	'type'     => 'raw',
	'full_width' => 'true',
	'title'    => esc_html__( 'Export/Delete', 'woffice' ),
	'desc'     => esc_html__( 'This is the name in the Wordpress menus, like Job, Partners, Corporates...', 'woffice' ),
	'content'  => sprintf( '<p><a class="button-secondary" style="margin-right:10px;" href="%1$s">Empty all tracking logs</a><a class="button-secondary" onClick="return confirm('.__('Are you sure you want to delete?','woffice').')" href="%2$s">Export Tracking Log</a></p>',admin_url('admin.php?page=woffice_theme_options&extension=woffice-time-tracking&flush=true'),admin_url('admin.php?page=woffice_theme_options&extension=woffice-time-tracking&export=true')),
);
$time_track_ext[] = array(
	'id'        => 'woffice-time-tracking-ext-accordion-end-1',
	'type'      => 'accordion',
	'position'  => 'end'
);

$fields = array_merge($fields,$time_track_ext);

$updater_ext = array();

$updater_ext[] = array(
	'id'        => 'woffice-updater-ext-accordion-begin-1',
	'type'      => 'accordion',
	'title'     => 'Woffice Updater',
	'position'  => 'start',    
);
$updater_ext[] = array(
	'id'       => 'enable_woffice_updater_extenstion',
	'type'     => 'switch',
	'title'    => esc_html__( 'Enable Woffice Updater', 'woffice' ),
	'on'       => esc_html__('Yes','woffice'),
	'off'      => esc_html__('No','woffice'),
	'default'  => function_exists('woffice_is_extension_active') ? woffice_is_extension_active('woffice-updater') : false,
);
$updater_ext[] = array(
	'id'       => 'woffice_tf_username',
	'type'     => 'text',
	'title'    => esc_html__( 'Envato Username', 'woffice' ),
	'desc'     => esc_html__( 'Your Envato (Themeforest) Username goes here.', 'woffice' ),
	'default'  => '',
);
$updater_ext[] = array(
	'id'       => 'woffice_tf_purchasecode',
	'type'     => 'text',
	'title'    => esc_html__( 'Woffice Purchase code', 'woffice' ),
	'desc'     => esc_html__( "The Purchase code of this license. You can find it in the Themeforest's download page (it's a large number).", 'woffice' ),
	'default'  => '',
);
$updater_ext[] = array(
	'id'       => 'woffice_tf_status',
	'type'     => 'raw',
	'full_width' => 'true',
	'title'    => esc_html__( 'Purchase code status.', 'woffice' ),
	'desc'     => esc_html__( 'The license works for one site only and if you are not on Localhost. Otherwise, your license will be activated when your site will be online. Feel free to get in touch if you need to change that.', 'woffice' ),
	'content'  => $status_ready
);
$updater_ext[] = array(
	'id'       => 'woffice_tf_beta',
	'type'     => 'switch',
	'title'    => esc_html__( 'Beta tester', 'woffice' ),
	'desc'     => esc_html__( "Beta releases will be updated as well. You can report any issue, and we'll fix them. You'll get updates first though.", 'woffice' ),
	'on'       => esc_html__('Yes','woffice'),
	'off'      => esc_html__('No','woffice'),
	'default'  => '',
);
$updater_ext[] = array(
	'id'       => 'woffice_tf_note',
	'type'     => 'raw',
	'full_width' => 'true',
	'title'    => esc_html__( 'Note', 'woffice' ),
	'content'  => esc_html__( 'For security purpose we collect your admin email address and attach it to the license in our server. This is done in order to provide a better and safer service to our customers.', 'woffice' )
);
$updater_ext[] = array(
	'id'        => 'woffice-updater-accordion-end-1',
	'type'      => 'accordion',
	'position'  => 'end'
);

$fields = array_merge($fields,$updater_ext);

$slack_ext = array();

$slack_ext[] = array(
	'id'        => 'woffice-slack-accordion-begin-1',
	'type'      => 'accordion',
	'title'     => 'Woffice Slack',
	'position'  => 'start',    
);
$slack_ext[] = array(
	'id'       => 'enable_woffice_slack_extenstion',
	'type'     => 'switch',
	'title'    => esc_html__( 'Enable Woffice slack', 'woffice' ),
	'on'       => esc_html__('Yes','woffice'),
	'off'      => esc_html__('No','woffice'),
	'default'  => function_exists('woffice_is_extension_active') ? woffice_is_extension_active('woffice-slack') : false,
);
$slack_ext[] = array(
	'id'    => 'woffice-slack-tabbed-1',
	'type'  => 'tabbed',
	'title' => 'Woffice slack Settings',
	'tabs'  => array(
		array(
			'title'  => 'Slack Config',
			'icon'   => 'fas fa-gear',
			'fields' => array(
				array(
					'id'       => 'woffice_poll_info',
					'type'     => 'raw',
					'full_width' => 'true',
					'title'    => esc_html__( 'Important :', 'woffice' ),
					'desc'     => esc_html__( 'This is the name in the Wordpress menus, like Job, Partners, Corporates...', 'woffice' ),
					'content'  => $notice,
				),
				array(
					'id'       => 'woffice_slack_callback',
					'type'     => 'raw',
					'full_width' => 'true',
					'title'    => esc_html__( 'Your callback URL :', 'woffice' ),
					'content'  => __('When enabling Slack API, plesase click "OAuth & Permissions" and copy/paste :<code>'. esc_url($url).'</code>','woffice'),
				),
				array(
					'id'       => 'woffice_slack_client_id',
					'type'     => 'text',
					'title'    => esc_html__( 'Client Secret', 'woffice' ),
					'desc'     => esc_html__( 'Your Slack API client ID for this app.', 'woffice' ),
					'default'  => '',
				),
				array(
					'id'       => 'woffice_slack_client_secret',
					'type'     => 'text',
					'title'    => esc_html__( 'Client Secret', 'woffice' ),
					'desc'     => esc_html__( 'Your Slack API Secret key for this app.', 'woffice' ),
					'default'  => '',
				),

			)
		),
		array(
			'title'  => 'Slack Notifications',
			'icon'   => 'fas fa-score',
			'fields' => array(
				array(
					'id'       => 'woffice_slack_status',
					'type'     => 'raw',
					'full_width' => 'true',
					'title'    => esc_html__( 'Status  :', 'woffice' ),
					'content'  => $slack_status,
				),
				array(
					'id'       => 'woffice_enable_comments',
					'type'     => 'switch',
					'title'    => esc_html__( 'Trigger notification on new comments', 'woffice' ),
					'on'       => esc_html__('Yes','woffice'),
					'off'      => esc_html__('No','woffice'),
					'default'  => '',
				),
				array(
					'id'       => 'woffice_enable_posts',
					'type'     => 'switch',
					'title'    => esc_html__( 'Trigger notification on new posts', 'woffice' ),
					'desc'    => esc_html__("Whether it's a post, project, wiki, page, event...",'woffice'),
					'on'       => esc_html__('Yes','woffice'),
					'off'      => esc_html__('No','woffice'),
					'default'  => '',
				),
				array(
					'id'       => 'woffice_enable_tasks',
					'type'     => 'switch',
					'title'    => esc_html__( 'Trigger notification on new project tasks', 'woffice' ),
					'desc'    => esc_html__("Project privacy won't be handled here, all tasks will be fetched.",'woffice'),
					'on'       => esc_html__('Yes','woffice'),
					'off'      => esc_html__('No','woffice'),
					'default'  => '',
				),
				array(
					'id'       => 'woffice_enable_registration',
					'type'     => 'switch',
					'title'    => esc_html__( 'Trigger notification on new user creation and registration', 'woffice' ),
					'on'       => esc_html__('Yes','woffice'),
					'off'      => esc_html__('No','woffice'),
					'default'  => '',
				),
				array(
					'id'       => 'woffice_enable_activities',
					'type'     => 'switch',
					'title'    => esc_html__( 'Trigger notification on new public BuddyPress activities', 'woffice' ),
					'on'       => esc_html__('Yes','woffice'),
					'off'      => esc_html__('No','woffice'),
					'default'  => '',
				),
			),
		),
	),
);
$slack_ext[] = array(
	'id'        => 'woffice-slack-ext-accordion-end-1',
	'type'      => 'accordion',
	'position'  => 'end'
);

$fields = array_merge($fields,$slack_ext);

$firebase_ext = array();

$firebase_ext[] = array(
	'id'        => 'woffice-notifications-accordion-begin-1',
	'type'      => 'accordion',
	'title'     => 'Woffice Push Notifications',
	'position'  => 'start',    
);
$firebase_ext[] = array(
	'id'       => 'enable_woffice_notification_extenstion',
	'type'     => 'switch',
	'title'    => esc_html__( 'Enable Woffice Notifications', 'woffice' ),
	'on'       => esc_html__('Yes','woffice'),
	'off'      => esc_html__('No','woffice'),
	'default'  => function_exists('woffice_is_extension_active') ? woffice_is_extension_active('woffice-live-notifications') : false,
);
$firebase_ext[] = array(
	'id'    => 'woffice-notifications-tabbed-1',
	'type'  => 'tabbed',
	'title' => 'Woffice Push Notifications Settings',
	'tabs'  => array(
		array(
			'title'  => 'Notification Content Setting',
			'icon'   => 'fas fa-gear',
			'fields' => array(
				array(
					'id'       => 'woffice_notifications_title',
					'type'     => 'text',
					'title'    => esc_html__( 'Notification title', 'woffice' ),
					'desc'     => esc_html__( 'Title of the notification box. You can use variable {component_name} inside title. {component_name} will be replaced by the component name.', 'woffice' ),
					'default'  => '',
				),
				array(
					'id'       => 'woffice_notifications_content',
					'type'     => 'textarea',
					'title'    => esc_html__( 'Notification content', 'woffice' ),
					'desc'     => esc_html__( 'Content of the notification box. You can use variable {component_name} inside content. {component_name} will be replaced by the component name.', 'woffice' ),
					'default'  => '',
				),
				array(
					'id'           => 'woffice_notifications_icon',
					'type'         => 'media',
					'url'          => true,
					'title'        => esc_html__( 'Notification icon', 'woffice' ),
					'desc'     	   => esc_html__("Upload your image for the icon	", 'woffice' ),
					'compiler'     => 'true',
					'preview_size' => 'thumbnail',
					'default'  => array(
						'url'=> '',
						'id'=> '',
					),
				),
			)
		),
		array(
			'title'  => 'Firebase Account Setting',
			'icon'   => 'fas fa-score',
			'fields' => array(
				array(
					'id'       => 'woffice_notificatios_status',
					'type'     => 'raw',
					'full_width' => 'true',
					'title'    => esc_html__( 'Info  :', 'woffice' ),
					'content'  => $html,
				),
				array(
					'id'       => 'woffice_notifications_fcm_apikey',
					'type'     => 'text',
					'title'    => esc_html__( 'Firebase API Key', 'woffice' ),
					'desc'     => esc_html__( 'Get the “apiKey” attribute from the “Add Firebase to your web app” screen. See this article for more details.', 'woffice' ),
					'default'  => '',
				),
				array(
					'id'       => 'woffice_notifications_fcm_authDomain',
					'type'     => 'text',
					'title'    => esc_html__( 'Firebase Auth Domain', 'woffice' ),
					'desc'     => esc_html__( 'TitlGet the “authDomain” attribute from the “Add Firebase to your web app” screen. See this article for more details.', 'woffice' ),
					'default'  => '',
				),
				array(
					'id'       => 'woffice_notifications_fcm_databaseURL',
					'type'     => 'text',
					'title'    => esc_html__( 'Firebase Database URL', 'woffice' ),
					'desc'     => esc_html__( 'Get the “databaseURL” attribute from the “Add Firebase to your web app” screen. See this article for more details.', 'woffice' ),
					'default'  => '',
				),
				array(
					'id'       => 'woffice_notifications_fcm_projectId',
					'type'     => 'text',
					'title'    => esc_html__( 'Firebase Project Id', 'woffice' ),
					'desc'     => esc_html__( 'Get the “projectId” attribute from the “Add Firebase to your web app” screen.', 'woffice' ),
					'default'  => '',
				),
				array(
					'id'       => 'woffice_notifications_fcm_storageBucket',
					'type'     => 'text',
					'title'    => esc_html__( 'Firebase Storage Bucket', 'woffice' ),
					'desc'     => esc_html__( 'Get the “storageBucket” attribute from the “Add Firebase to your web app” screen.', 'woffice' ),
					'default'  => '',
				),
				array(
					'id'       => 'woffice_notifications_fcm_messagingSenderId',
					'type'     => 'text',
					'title'    => esc_html__( 'Firebase Messaging SenderId', 'woffice' ),
					'desc'     => esc_html__( 'Get the “messagingSenderId” attribute from the “Add Firebase to your web app” screen', 'woffice' ),
					'default'  => '',
				),
				array(
					'id'       => 'woffice_notifications_fcm_legacyServerKey',
					'type'     => 'text',
					'title'    => esc_html__( 'Firebase legacyServerKey', 'woffice' ),
					'desc'     => esc_html__( 'Get “Legacy server key” from the “Cloud Messaging” setting.', 'woffice' ),
					'default'  => '',
				),
				array(
					'id'       => 'woffice_notifications_fcm_webPushCertificate',
					'type'     => 'text',
					'title'    => esc_html__( 'Firebase Web Push Certificate', 'woffice' ),
					'desc'     => esc_html__( 'Get “Web Push certificates” from the “Cloud Messaging” setting.', 'woffice' ),
					'default'  => '',
				),
			),
		),
	),
);

$fields = array_merge($fields,$firebase_ext);

$recent_post_ext = array();

$recent_post_ext[] = array(
	'id'        => 'woffice-recentposts-ext-accordion-begin-1',
	'type'      => 'accordion',
	'title'     => 'Woffice Recent Posts',
	'position'  => 'start',    
);
$recent_post_ext[] = array(
	'id'       => 'enable_woffice_recentpost_extenstion',
	'type'     => 'switch',
	'title'    => esc_html__( 'Enable Woffice Recent Posts', 'woffice' ),
	'on'       => esc_html__('Yes','woffice'),
	'off'      => esc_html__('No','woffice'),
	'default'  => function_exists('woffice_is_extension_active') ? woffice_is_extension_active('woffice-recent-posts') : false,
);
$recent_post_ext[] = array(
	'id'        => 'woffice-recentposts-ext-accordion-end-1',
	'type'      => 'accordion',
	'position'  => 'end'
);

$fields = array_merge($fields,$recent_post_ext);

$project_fields[] = array(
	'id'        => 'woffice-project-ext-accordion-begin-1',
	'type'      => 'accordion',
	'title'     => 'Woffice Project',
	'position'  => 'start',    
);
$project_fields[] = array(
	'id'       => 'enable_woffice_project_extenstion',
	'type'     => 'switch',
	'title'    => esc_html__( 'Enable Woffice Project', 'woffice' ),
	'on'       => esc_html__('Yes','woffice'),
	'off'      => esc_html__('No','woffice'),
	'default'  => function_exists('woffice_is_extension_active') ? woffice_is_extension_active('woffice-projects') : false,
);
$project_fields[] = array(
	'id'        => 'woffice-project-ext-accordion-end-1',
	'type'      => 'accordion',
	'position'  => 'end'
);

$fields = array_merge($fields,$project_fields);

$file_management_fields[] = array(
	'id'        => 'woffice-file-management-ext-accordion-begin-1',
	'type'      => 'accordion',
	'title'     => 'Woffice File Management',
	'position'  => 'start',    
);
$file_management_fields[] = array(
	'id'       => 'enable_woffice_file_management',
	'type'     => 'switch',
	'title'    => esc_html__( 'Enable Woffice File Management', 'woffice' ),
	'on'       => esc_html__('Yes','woffice'),
	'off'      => esc_html__('No','woffice'),
	'default'  => false,
);

$file_management_fields[] = array(
    'id' => 'woffice_file_extensions',
    'type' => 'textarea',
    'title' => esc_html__('Allowed File Type', 'woffice'),
    'desc' => esc_html__('Allow file type like jpg,png,pdf etc. Please add comma seprated value', 'woffice'),
    'default' => 'jpg,jpeg,png,pdf',
);

global $wp_roles;
$tt_roles = array();
foreach ($wp_roles->roles as $key=>$value){
$tt_roles[$key] = $value['name']; }
$tt_roles_tmp = array('nope' => __("Everyone","woffice"),'project_members' => __("Project or Tasks Nembers","woffice")) + $tt_roles;

$file_management_fields[] = array(
	'id'       => 'woffice_file_include_members',
	'type'     => 'select',
	'multi'    => true,
	'title'    => __('Who can upload file?', 'woffice'),
	'desc'     => __('The included members will able to upload files.', 'woffice'),
	'hint' => array(
			'title'   => '',
			'content' => __('Help tip : Hold Ctrl to select multiple users.', 'woffice')
	),
	'default' => array('administrator'),
	'options'  => $tt_roles,
);

$server_filesize_limit = wp_max_upload_size();

if(function_exists('woffice_formatbyte_to_size')) {
	$server_filesize_limit = woffice_formatbyte_to_size('outputsize',$server_filesize_limit);
}

$file_management_fields[] = array(
    'id' => 'woffice_file_size',
    'type' => 'text',
    'title' => esc_html__('Maximum file size', 'woffice'),
    'desc' => esc_html__('Allow maximum file upload size. by defult it is 2MB. Max allowed filesize in your server is '.$server_filesize_limit.'', 'woffice'),
	'validate' => 'numeric',
    'default' => '2048'
);

$file_management_fields[] = array(
    'id' => 'woffice_file_unit',
    'type' => 'select',
    'title' => esc_html__('File Upload Unit', 'woffice'),
	'hint'     => array(
		'title'   => esc_html__( 'File Upload Unit & Maximum file size', 'woffice' ),
		'content' => wp_kses_post(__('This limit is calculated by multiplying the specified maximum file size (2048 KB) by 1024 (as 1 MB equals 1024 KB).','woffice')),
	),
    'options' => array(
        'KB' => esc_html__('KB', 'woffice'),
		'MB' => esc_html__('MB', 'woffice'),
    ),
	'default' => 'MB',
	'validate' => 'not_empty',
	'select2'  => array('select2' => array( 'allowClear' => False ) ),
);

$file_management_fields[] = array(
    'id' => 'woffice_file_upload_path',
    'type' => 'select',
    'title' => esc_html__('File Upload path', 'woffice'),
    'desc' => esc_html__('File Upload path.Dynamic will create new file path based on post slug', 'woffice'),
	'select2'  => array('select2' => array( 'allowClear' => False ) ),
    'options' => array(
        'default' => esc_html__('Default', 'woffice'),
        'dynamic' => esc_html__('Dynamic', 'woffice'),
    ),
	'validate' => 'not_empty',
    'default' => 'default',
);


$file_management_fields[] = array(
	'id'        => 'woffice-file-management-ext-accordion-end-1',
	'type'      => 'accordion',
	'position'  => 'end'
);

$fields = array_merge($fields,$file_management_fields);

Redux::set_section(
	$opt_name,
	array(
		'title' => esc_html__('Extentions', 'woffice'),
		'id' => 'option-theme_extentions',
		'desc' => esc_html__('For full documentation on this, visit: ', 'woffice') . '<a href="https://docs.woffice.io/" target="_blank">' . esc_html__('Woffice documentation', 'woffice') . '</a>',
		'subsection' => true,
		'fields' => $fields,
	),
);
