<?php
/**
 * Redux Framework image select config.
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

defined( 'ABSPATH' ) || exit;
$plugins_url = plugins_url();

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Title Box', 'woffice' ),
		'id'         => 'title-hero-options-title_box_select',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
            array(
				'id'       => 'show_title_box',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show', 'woffice' ),
				'default'  => 'off',
                'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
			),
            array(
				'id'       => 'section-hero-start',
				'type'     => 'section',
				'title'    => esc_html__( 'Title Box', 'woffice' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
            array(
				'id'       => 'title_box_height',
				'type'     => 'text',
				'title'    => esc_html__( 'Box Height', 'woffice' ),
				'validate' => array( 'numeric', 'not_empty' ),
				'default'  => '240',
			),
			array(
				'id'       => 'title_box_fontsize',
				'type'     => 'select',
				'title'    => esc_html__( 'Heading Size', 'woffice' ),
				'options'  => array(
					'16' => esc_html__( 'Small', 'woffice' ),
					'26'  => esc_html__( 'Medium', 'woffice' ),
                    '26'  => esc_html__( 'Large', 'woffice' ),
					'46'  => esc_html__( 'Extra Large', 'woffice' ),
					'56'  => esc_html__( 'Giant', 'woffice' ),
					'custom'  => esc_html__( 'Custom', 'woffice' ),
				),
                'default'  => '46',
				'validate' => 'not_empty'
			),
            array(
				'id'       => 'title_box_custom_fontsize',
				'type'     => 'text',
				'title'    => esc_html__( 'Heading Custom Size', 'woffice' ),
				'validate' => array( 'numeric'),
				'default'  => '56',
				'required' => array('title_box_fontsize','equals','custom')
			),
            array(
				'id'       => 'title_box_transform',
				'type'     => 'select',
				'title'    => esc_html__( 'Text Transform', 'woffice' ),
				'options'  => array(
					'capitalize' => esc_html__( 'Capitalize', 'woffice' ),
					'uppercase'  => esc_html__( 'Uppercase', 'woffice' ),
                    'lowercase'  => esc_html__( 'Lowercase', 'woffice' ),
				),
                'default'  => 'uppercase',
				'validate' => 'not_empty'
			),
            array(
				'id'       => 'title_box_bold',
                'type'     => 'select',
				'title'    => esc_html__( 'Font Weight', 'woffice' ),
				'options'  => array(
					'normal' => esc_html__( 'Normal', 'woffice' ),
					'bold'  => esc_html__( 'Bold', 'woffice' ),
                    'bolder'  => esc_html__( 'Bolder', 'woffice' ),
                    'lighter'  => esc_html__( 'Lighter', 'woffice' ),
                    '100'  => esc_html__( '100', 'woffice' ),
                    '200'  => esc_html__( '200', 'woffice' ),
                    '300'  => esc_html__( '300', 'woffice' ),
                    '400'  => esc_html__( '400', 'woffice' ),
                    '500'  => esc_html__( '500', 'woffice' ),
                    '600'  => esc_html__( '600', 'woffice' ),
                    '700'  => esc_html__( '700', 'woffice' ),
                    '800'  => esc_html__( '800', 'woffice' ),
                    '900'  => esc_html__( '900', 'woffice' ),
				),
                'default'  => 'bold',
				'validate' => 'not_empty'
			),
			array(
                'id'       => 'title_box_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Title Color', 'woffice' ),
                'default'  => '#ffffff',
                'transparent' => false,
                'color_alpha' => true
            ),
            array(
				'id'       => 'section-hero-end',
				'type'     => 'section',
                'indent'   => false,
			),
            array(
				'id'       => 'section-img-start',
				'type'     => 'section',
				'title'    => esc_html__( 'Title Background Image', 'woffice' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
            array(
				'id'           => 'title_boxbg_image',
				'type'         => 'background',
				'background-color' => false,
				'url'          => true,
				'title'        => esc_html__( 'Default Image', 'woffice' ),
				'desc'          => esc_html__( 'If featured image is not added then default image is used.', 'woffice' ),
				'default'  => array(
					'background-repeat' => 'no-repeat',
					'background-attachment' => 'inherit',
					'background-position' => 'center center',
					'background-size' => 'cover',
				),			
				'compiler'     => 'true',
				'preview_size' => 'full',
			),
            array(
                'id'       => 'title_box_overlay',
                'type'     => 'color',
                'title'    => esc_html__( 'Overlay Color', 'woffice' ),
                'default'  => 'rgba(49,70,197,0.52)',
                'transparent' => false,
                'color_alpha' => true
            ),
            array(
				'id'       => 'section-img-end',
				'type'     => 'section',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
			),
            array(
				'id'       => 'section-th-br-start',
				'type'     => 'section',
                'title'    => esc_html__( 'Bottom Border', 'woffice' ),
				'subtitle' => esc_html__( 'This border is visible below this title hero.', 'woffice' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
            array(
				'id'       => 'show_title_box_border',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show', 'woffice' ),
				'default'  => '1',
                'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
			),
            array(
                'id'       => 'title_box_bordercolor',
                'type'     => 'color',
                'title'    => esc_html__( 'Border Color', 'woffice' ),
                'default'  => '#3146c5',
                'transparent' => false,
                'color_alpha' => true
            ),
            array(
				'id'       => 'section-th-br-end',
				'type'     => 'section',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
			),
		),
	)
);
