<?php

defined( 'ABSPATH' ) || exit;

$plugins_url = plugins_url();

if (!function_exists('redux_icon_select_fa_5_free')) {
    require_once WOFFICE_CORE_PATH . 'libs/redux-framework/redux-core/inc/extensions/icon_select/font-awesome-5-free.php';
}

$old_options = get_option('fw_theme_settings_options:woffice');

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Woffice Team View', 'woffice' ),
		'id'         => 'option-woffice_team_view_options',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
            array(
				'id'       => 'team_progress_notification',
				'type'     => 'switch',
				'title'    => esc_html__( 'Team Progress Notification For Users', 'woffice' ),
                'desc'    => esc_html__( 'Team Progress Daily/Weekly Notification Reminder', 'woffice' ),
				'default'  => isset($old_options['team_progress_notification']) ? $old_options['team_progress_notification'] : false,
                'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
			),
            array(
				'id'       => 'team_notification_type',
				'type'     => 'select',
				'title'    => esc_html__( 'Notification Frequency for Users', 'woffice' ),
                'desc'    => esc_html__( 'Send notification daily or weekly', 'woffice' ),
				'options'  => array(
					'daily' => esc_html__( 'Daily', 'woffice' ),
					'weekly'  => esc_html__( 'Weekly', 'woffice' ),
          		),
                'default'  => isset($old_options['team_notification_type']) ? $old_options['team_notification_type'] : 'weekly',
			),
            array(
				'id'       => 'team_progress_admin_notification',
				'type'     => 'switch',
				'title'    => esc_html__( 'Team Progress Notification for Admin', 'woffice' ),
                'desc'    => esc_html__( 'Team Progress Daily/Weekly Notification Reminder to admin', 'woffice' ),
				'default'  => isset($old_options['team_progress_admin_notification']) ? $old_options['team_progress_admin_notification'] : false,
                'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
			),
            array(
				'id'       => 'team_notification_type_admin',
				'type'     => 'select',
				'title'    => esc_html__( 'Notification Frequency for admin', 'woffice' ),
                'desc'    => esc_html__( 'Send notification daily or weekly to admin', 'woffice' ),
				'options'  => array(
					'daily' => esc_html__( 'Daily', 'woffice' ),
					'weekly'  => esc_html__( 'Weekly', 'woffice' ),
          		),
                'default'  => isset($old_options['team_notification_type_admin']) ? $old_options['team_notification_type_admin'] : 'weekly',
			),
		),
	)
);