<?php
// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux' ) ) {
	return;
}
$post_id = isset($_GET['post']) ? $_GET['post'] : 0;

global $wp_roles;
    $tt_roles_tmp = array();
foreach ($wp_roles->roles as $key=>$value){
    $tt_roles_tmp[$key] = $value['name'];
}

$woffice_wiki_meta = "woffice_wiki_meta";
$exclude_roles = function_exists('woffice_get_post_option') ? woffice_get_post_option($post_id,'exclude_roles') : '';
$everyone_edit = function_exists('woffice_get_post_option') ? woffice_get_post_option($post_id,'everyone_edit') : '';
$featured_wiki = function_exists('woffice_get_post_option') ? woffice_get_post_option($post_id,'featured_wiki') : '';
if(function_exists('woffice_get_post_rdx_option')){
    $exclude_roles = woffice_get_post_rdx_option($post_id,'exclude_roles');
    if(empty(woffice_get_post_rdx_option($post_id,'exclude_roles'))) {
        $exclude_roles = $exclude_roles;
    } else {
        $exclude_roles = woffice_get_post_rdx_option($post_id,'exclude_roles');
    }
}

$post_top_featured_default = array();

if(!empty($post_top_featured)) {
    $post_top_featured_default['id'] = $post_top_featured['attachment_id'];
    $post_top_featured_default['url'] = $post_top_featured['url'];
}

    Redux_Metaboxes::set_box(
        $opt_name,
        array(
            'id'         => 'opt-woffice_wiki_meta',
            'post_types' => array('wiki'),
            'title'      => esc_html__( 'Wiki Settings', 'woffice' ),
            'position'   => 'normal', // normal, advanced, side.
            'priority'   => 'high', // high, core, default, low.
            'sections'   => array(
                array(
                    'id'   =>'divider_wiki_meta',
                    'desc' => '',
                    'type' => 'divide'
                ),
                array(
                    'icon_class' => 'icon-large',
                    'icon'       => 'el-icon-home',
                    'title'      => esc_html__( 'Wiki Settings', 'woffice' ),
                    'fields'     => array(
                        array(
                            'id'       => 'disable_wiki_sidebar',
                            'type'     => 'switch',
                            'title'    => esc_html__( 'Disable Right Sidebar ?', 'woffice' ),
                            'desc'     => esc_html__( 'If this is checked, this will disbale the right sidebar for this page.', 'woffice' ),
                            'on'       => esc_html__('Yes','woffice'),
                            'off'      => esc_html__('No','woffice'),
                            'default'  => false,
                        ),
                        array(
                            'id'       => 'exclude_roles',
                            'type'     => 'select',
                            'multi'    => true,
                            'title'    => __('Exclude Roles', 'woffice'), 
                            'desc'     => __('The excluded roles will not be able to see that wiki article, they will receive an error message instead.', 'woffice'),
                            'options'  => $tt_roles_tmp,
                            'default'  => $exclude_roles ? $exclude_roles :  ''
                        ),
                        array(
                            'id'       => 'everyone_edit',
                            'type'     => 'switch',
                            'title'    => esc_html__( 'Everyone can edit ?', 'woffice' ),
                            'desc'     => esc_html__( 'If this is checked, all loggedin members with editing permissions on posts will be able to edit this post, otherwise only the author of the post and the administrators will be able to do it (This affect only the frontend).', 'woffice' ),
                            'on'       => esc_html__('Yes','woffice'),
                            'off'      => esc_html__('No','woffice'),
                            'default'  => $everyone_edit,
                        ),
                        array(
                            'id'       => 'featured_wiki',
                            'type'     => 'switch',
                            'title'    => esc_html__( 'This is a featured wiki', 'woffice' ),
                            'desc'     => esc_html__( 'This will display a star before the wiki name, in the listing.', 'woffice' ),
                            'on'       => esc_html__('Yes','woffice'),
                            'off'      => esc_html__('No','woffice'),
                            'default'  => $featured_wiki,
                        ),        
                    ),
                ),
            ),
        )
    );