<?php
/**
 * Woffice custom member template
 *
 * @since 2.8.0
 */

/**
 * You can hide the role of users displayed in the members loop page
 *
 * @param bool
 */
$members_role_enabled = apply_filters('woffice_enable_member_role_on_members_page', true);

/**
 * You can hide the last activity of users displayed in the members loop page
 *
 * @param bool
 */
$last_activity_enabled = apply_filters('woffice_enable_member_last_activity_on_members_page', true);
$grid_class = 'col-md-4';

if(function_exists('bbp_is_single_user') && bbp_is_single_user() || function_exists('bp_is_member') && bp_is_member()){
    $grid_class = 'col-md-6';
}
?>

<ul id="members-list" class="<?php bp_nouveau_loop_classes(); ?>">
	<div class="row members_card_row">
	<?php while ( bp_members() ) : bp_the_member(); 

		$user_id   = (int) bp_get_member_user_id();
		$the_cover = woffice_get_cover_image($user_id);
		$class = '';
		if(!empty($the_cover)){
			$class = 'has-cover-image';
		}
				
	?>
		<div class="members_card col-xs-12 col-sm-12 <?php echo esc_attr($grid_class)?>">
			<li <?php bp_member_class(array($class)); ?> data-bp-item-id="<?php bp_member_user_id(); ?>" data-bp-item-component="members">
				<div class="card border-0">
					<div class="member-header" style="background-image: url(<?php echo esc_url($the_cover); ?>)" data-template="woffice">
						<?php 
							$role = woffice_get_user_role($user_id); 
							if ($members_role_enabled && !empty($role)): ?>
							<span class="profile-card-badge is-<?php echo esc_html($role); ?>" data-template="woffice"><?php echo esc_html($role); ?></span>
						<?php endif; ?>
						<div class="member-header-content">
							<div class="row align-items-center">
								<div class="col-auto">
									<a href="<?php bp_member_permalink(); ?>">
										<?php bp_member_avatar(array('height' => 64, 'width' => 64)); ?>
									</a>
								</div>
								<div class="col pl-1">
									<h5 class="m-0 pb-2">
										<a class="member-name" href="<?php bp_member_permalink(); ?>">
											<?php echo woffice_get_name_to_display($user_id); ?>
										</a>
									</h5>
									<?php if ( bp_nouveau_member_has_meta() && $last_activity_enabled ) : ?>
										<p class="item-meta last-activity mb-0">
											<?php bp_nouveau_member_meta(); ?>
										</p><!-- #item-meta -->
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
					<div class="member-content-body">
						<?php
							/**
							 * Before the list of custom member fields, in the members page (card layout)
							 */
							do_action('woffice_before_list_xprofile_fields');

							woffice_list_xprofile_fields(bp_get_member_user_id());

							/**
							 * After the list of custom member fields, in the members page (card layout)
							 */
							do_action('woffice_after_list_xprofile_fields'); 
						?>
					</div>
					<div class="member-footer bg-transparent border-0">
						<?php
							bp_nouveau_members_loop_buttons(
								array(
									'container'      => 'ul',
									'button_element' => 'a',
								)
							);
						?>
					</div>
				</div>
			</li>
		</div>
		<?php endwhile; ?>
	</div>
</ul>