<?php
    $start_date = esc_html(get_post_meta(get_the_ID(), 'woffice_event_date_start',true));
    $end_date   = esc_html(get_post_meta(get_the_ID(), 'woffice_event_date_end',true));

    $event = array(
        'woffice_event_title'           => get_post_meta(get_the_ID(), 'woffice_event_title',true),
        'woffice_event_date_start_i18n' => date_i18n(get_option('date_format'), strtotime($start_date)) . ', ' . date('h:i A', strtotime($start_date)),
        'woffice_event_date_end_i18n'   => date_i18n(get_option('date_format'), strtotime($end_date)) . ', ' . date('h:i A', strtotime($end_date)),
        'woffice_event_repeat'          => get_post_meta(get_the_ID(), 'woffice_event_repeat',true),
        'woffice_event_color'           => get_post_meta(get_the_ID(), 'woffice_event_color',true),
        'woffice_event_visibility'      => get_post_meta(get_the_ID(), 'woffice_event_visibility',true)
    );


if (woffice_is_user_visible_event($event['woffice_event_visibility'])) : ?>
    <div class="event-box font-weight-normal bg-<?php echo esc_attr($event['woffice_event_color']);?>">
        <a class="text-dark" target="_blank" href="<?php echo get_post_permalink(get_the_ID());?>">
        <span class="name font-weight-bold"><?php echo esc_html($event['woffice_event_title']);?></span>

        <span class="pr-3 date-time">
            <i class="text-light fa fa-calendar-alt pr-1"></i>
                <?php echo esc_html($event['woffice_event_date_start_i18n'] . ' - '.  $event['woffice_event_date_end_i18n'] ); ?>
        </span>
        <span class="pr-3 date-time">
            <i class="text-light fa fa-sync pr-1"></i>
            <?php echo esc_html($event['woffice_event_repeat']);?>
        </span>
        <span class="pr-3 date-time">
            <i class="text-light fa fa-user-shield pr-1"></i>
            <?php echo ucfirst(explode('_', $event['woffice_event_visibility'])[0]);?>
        </span>
        </a>
    </div>
<?php
endif;
