<?php
$project_status = (function_exists('get_post_meta')) ? get_post_meta(get_the_ID(), 'project_current_status',true) : 'planned';

if ($project_status == 'archived') {
	$project_status_icon = 'fa-archive';
	$project_status_label = __('Archived','woffice');
} else if ($project_status == 'done') {
	$project_status_icon = 'fa-check-square';
	$project_status_label = __('Done','woffice');
} else if ($project_status == 'in_progress') {
	$project_status_icon = 'fa-sync';
	$project_status_label = __('In progress','woffice');
} else if ($project_status == 'in_review') {
	$project_status_icon = 'fa-cog';
	$project_status_label = __('In review','woffice');
} else {
	$project_status_icon = 'fa-book';
	$project_status_label = __('Planned','woffice');
}
$projects_layout = woffice_get_theming_option('projects_layout');

	$projects_gird_class = "item col-md-6 col-xl-4";
?>

<li class="content <?php echo (isset($archived_class)) ? $archived_class : ''; echo (isset($projects_gird_class)) ? $projects_gird_class : ''; ?>">
	<div class="card-wrapper">
			<div class="card_inner">
				<div class="card-body ">
					<div class="card_head">
						<h2 class="project-title"><?php the_title() ?></h2>
						<?php echo '<span class="project-status badge badge-pill '. esc_attr($project_status) . '">'. esc_html($project_status_label) . '</span>';?>
					</div>
					<ul class="list-group list-group-horizontal-sm p-0">
						<li class="list-group-item date_list">
							<?php
								// DATE
								woffice_projects_loop_render_dates( $post->ID );
							?>
						</li>
						<li class="list-group-item members_count_li">
							<?php
								// MEMBERS
								$project_members = woffice_get_project_members();
								if(is_array($project_members)){
									echo '<span class="project-members"><i class="woffice-icon woffice-icon-member"></i> '.count($project_members).'</span>';
								}
							?>
						</li>
						<li class="list-group-item comment_list">
							<?php
								if (get_comment_count(get_the_ID()) > 0):
									echo '<span class="project-comments"><i class="woffice-icon woffice-icon-comment"></i> '.get_comments_number( '0', '1', '%' ).'</span>';
								endif;
							?>
						</li>
					</ul>
					<div class="progress_bar_wrapper">
						<?php // THE PROGRESS BAR 
							woffice_project_progressbar();
						?>
					</div>
					<div class="user_avatar_wrapper">
						
					<?php // GET MEMBERS
                     $project_members = woffice_get_project_members( get_the_ID() ); if (!empty($project_members)): ?>
                        <div class="user_avatar_inner">
                            <div class="project-members">
								<?php
								/**
								 * In the single project page, this is performed before the list of project members
								 */
								do_action('woffice_before_project_meta_members');

								woffice_loop_project_members($project_members);

								/**
								 * In the single project page, this is performed after the list of project members
								 */
								do_action('woffice_after_project_meta_members');
								?>
                            </div>
                        </div>
					<?php endif; ?>
					</div>
					<div class="post-category project-category row">
					<div class="col-6">
					<?php
							// CATEGORY
							if( has_term('', 'project-category')):
								echo '<span class="project-cateogry-badge">';
								echo wp_strip_all_tags(get_the_term_list( $post->ID, 'project-category', '', ', ' ));
								echo '</span>';
							endif;
						?>
					</div>
					<div class="col-6">
					<a href="<?php the_permalink(); ?>" class="project_view"><?php esc_html_e("View","woffice")?> <i class="woffice-icon woffice-icon-arrow-down "></i></a>

					</div>
					</div>
				</div>
			</div>
		
	</div>
</li>