<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

class Woffice_Employee_Anniversary {

	/**
	 * @internal
	*/

	 public function __construct() {
		$this->_init();
	}

	/**
	 * @internal
	*/
	public function _init() {
		
		add_action('show_user_profile', array($this,'woffice_emp_anniversary_form')); // editing your own profile
		add_action('edit_user_profile', array($this,'woffice_emp_anniversary_form')); // editing another user
		add_action('user_new_form', array($this,'woffice_emp_anniversary_form')); // creating a new user

		add_action('personal_options_update', array($this,'woffice_emp_anniversary_save'));
		add_action('edit_user_profile_update', array($this,'woffice_emp_anniversary_save'));
		add_action('user_register', array($this,'woffice_emp_anniversary_save'));

	}

	public function woffice_emp_anniversary_form($user) {
		$anniversary_date = isset($user->ID) ? esc_attr(get_user_meta($user->ID, 'employee_anniversary', true)) : '';
	?>
		<h2><?php _e('(Woffice) Employee Anniversary','woffice');?></h2>
		<table class="form-table">
			<tr>
				<th><label for="employee_anniversary"><?php _e('Employee Anniversary','woffice');?></label></th>
				<td>
					<input
						type="date"
						value="<?php echo $anniversary_date; ?>"
						name="employee_anniversary"
						id="employee_anniversary"
					>
					<p class="description"><?php _e('Your Anniversary Date','woffice');?></p>
				</td>
			</tr>
		</table>
	<?php
	}
		
	public function woffice_emp_anniversary_save($userId) {
		if (!current_user_can('edit_user', $userId)) {
			return;
		}
	
		update_user_meta($userId, 'employee_anniversary', sanitize_text_field($_REQUEST['employee_anniversary']));
	}

	public static function woffice_anniversary_get_anniversary($limit,$order){

		$current_date = date('Y-m-d'); 
		$args = array(
			'number' 		=> $limit,
			'meta_key'     => 'employee_anniversary', 
			'orderby'      => 'meta_value',
			'order'        => $order,
			'meta_type'    => 'DATE',
			'meta_query'   => array(
				array(
					'key'     => 'employee_anniversary',
					'value'   => array('0000-00-00', ''), 
					'compare' => 'NOT IN',
					'type'    => 'DATE'
				),
				array(
					'key'     => 'employee_anniversary',
					'value'   => $current_date,
					'compare' => '>=',
					'type'    => 'DATE'
				)
			),
		);

		$user_query = new WP_User_Query($args);
		$users = $user_query->get_results();

		$users_anniversary = array();

		if(!empty($users)) {
			foreach($users as $key => $user) {
				$user_id = $user->ID;
				
				$anniversary_date = get_user_meta($user_id, 'employee_anniversary',true);
				$anniversary_string = date('Y-m-d H:i:s', strtotime($anniversary_date));
				// We transform the string in a date
				$anniversary = DateTime::createFromFormat('Y-m-d H:i:s', $anniversary_string);
			
				/**
				 * Filter if the current anniversary (in the anniversary widget) can be displayed
				 *
				 * @param bool $is_displayed
				 * @param int $user_id
				 * @param DateTime $anniversary
			 	*/
					$celebration_year = (date('md', $anniversary->getTimestamp()) >= date('md') ) ? date('Y') : date('Y', strtotime('+1 years') );

					$years_old = (int) $celebration_year - (int)date("Y", $anniversary->getTimestamp());

					// If gone for this year already, we remove one year
					if (date('md', $anniversary->getTimestamp()) > date('md')) {
						$years_old = $years_old;
					} else if (date('md', $anniversary->getTimestamp()) == date('md')) {
						$years_old = $years_old;
					}

					/**
					 * Filter `woffice_anniversary_date_format`
					 *
					 * Let you change the date format in which the anniversary is displayed
					 * See: http://php.net/manual/en/function.date.php
					 *
					 * @param string - the date format PHP value
					 *
					 * @return string
					 */
					$format = apply_filters('woffice_anniversary_date_format', 'md');

					$celebration_string = $celebration_year . date($format, $anniversary->getTimestamp());
					$name_to_display = woffice_get_name_to_display($user_id);

					$users_anniversary[$user_id] = array(
						'user' => $user_id,
						'name' => $name_to_display,
						'datetime' => $anniversary,
						'date' => $anniversary_date,
						'next_celebration_comparable_string' => $celebration_string,
						'years_old' => $years_old
					);
				// }
			}
 		}

		return $users_anniversary;
	}

	/**
	 * It will generate the content for the front viw
	 *
	 * @param array $all_bithdays
	 */
	public static function woffice_anniversary_content($users_anniversary) {

		if (empty($users_anniversary)) {
			return;
		}

		$date_ymd = date('Y-m-d');
		$html = '';
		foreach($users_anniversary as $key => $anniversary) {
          	
			$mem_domain = function_exists('bp_members_get_user_url') ? bp_members_get_user_url($anniversary['user']) : bp_core_get_user_domain($anniversary['user']);
			// We don't display negative ages
			$html .= '<li class="clearfix">';
			if (function_exists('bp_is_active')):
				$html .= '<a href="' . $mem_domain . '">';
				$html .= get_avatar($anniversary['user']);
				$html .= '</a>';
			else :
				echo get_avatar($anniversary['user']);
			endif;
			$html .= '<span class="anniversary-item-content">';
			$html .= '<strong>' . $anniversary['name'] . '</strong>';
			
			$html .= ' '. _x('on', 'happy anniversary ON 25-06', 'woffice');
			$date_format = (!empty($date_format)) ? $date_format : 'F d';

			$html .= ' <span class="badge badge-primary badge-pill">' . date_i18n( $date_format, strtotime($anniversary['date'])) . '</span>';
	
			$happy_anniversary_label = '';
			if(strtotime($anniversary['date']) === strtotime($date_ymd)){
				$happy_anniversary_label = '<br/><span class="badge badge-primary badge-pill">' . __( 'Happy Anniversary!', 'woffice') . '</span>';
			}

			/**
			 * The label "Happy anniversary", if today is the anniversary of an user
			 *
			 * @param string $happy_anniversary_label The text of the label (contains some HTML)
			 * @param int $user_id
			 */
			$html .= apply_filters( 'woffice_today_happy_anniversary_label', $happy_anniversary_label, $anniversary['user'] );

			$html .= '</span>';
			$html .= '</li>';
        }

		echo wp_kses($html,true);
	}

	/**
	 * Used for order array of object, containing dates
	 *
	 * @param array $a
	 * @param array $b
	 *
	 * @return boolean
	*/
	public static function date_comparison($a, $b) {
		$string_one = isset($a['next_celebration_comparable_string']) ? $a['next_celebration_comparable_string'] : false;
		$string_two = isset($b['next_celebration_comparable_string']) ? $b['next_celebration_comparable_string'] : false;
		return strcmp($string_one, $string_two);
	}
}

new Woffice_Employee_Anniversary();