<?php 

defined( 'ABSPATH' ) || exit;

/**
 * LOAD THE JAVASCRIPT FOR THE FORM
 */
function woffice_cover_image_load_scripts() {
	if ( !is_admin() ) {

		$enable_woffice_cover_image_extenstion = get_option('woffice_theme_options');
        
		if ( isset($enable_woffice_cover_image_extenstion['enable_woffice_cover_image_extenstion']) && !$enable_woffice_cover_image_extenstion['enable_woffice_cover_image_extenstion']) {
			return;
		}

		if (function_exists('bp_is_active')):

			if (bp_is_my_profile() || (bp_is_user() && woffice_current_is_admin())):
				
				wp_localize_script('fw-extension-woffice-cover-ajax', 'fw-extension-woffice-cover-ajax', array('ajaxurl' =>  admin_url('admin-ajax.php')));
			
				wp_enqueue_script(
					'woffice-cover-simple-ajax-uploader',
					WOFFICE_CORE_URL .'extensions/woffice-cover/static/js/SimpleAjaxUploader.min.js',
					array( 'jquery' ),
					WOFFICE_THEME_VERSION,
					true
				);

			endif;
			
		endif;
		
	}
}

add_action( 'wp_enqueue_scripts', 'woffice_cover_image_load_scripts');