<?php
defined( 'ABSPATH' ) || exit;
/**
 * Load js and css for events
 */
function woffice_event_load_scripts(){

    $enable_woffice_event_extenstion = get_option('woffice_theme_options');

    if ( !isset($enable_woffice_event_extenstion['enable_woffice_event_extenstion']) || isset($enable_woffice_event_extenstion['enable_woffice_event_extenstion']) && !$enable_woffice_event_extenstion['enable_woffice_event_extenstion'] ) {
        return;
    }

    if (!is_admin() && defined('WOFFICE_THEME_VERSION')) {

        $user_id = get_current_user_id();
        $event_create = woffice_get_theming_option('event_create');

        if (Woffice_Frontend::role_allowed($event_create)) {

            $group_options = [];
            if (woffice_bp_is_active('groups')) {
                $groups_query = BP_Groups_Group::get(array('show_hidden' => true,'update_meta_cache'  => false));
                foreach ($groups_query['groups'] as $group) {
                    if (groups_is_user_member($user_id, $group->id)) {
                        $group_options['group_' . $group->id] = $group->name;
                    }
                }
            }
            $args = array(
                'post_type' => 'project',
                'posts_per_page' => '-1',
            );

            $user_posts = get_posts($args);
            $project_options = array();
            foreach ($user_posts as $project) {
                if ($user_id && $user_id !== (int) $project->post_author) {
                    $project_members = (function_exists('get_post_meta')) ? get_post_meta($project->ID,'project_members',true) : '';

                    if (!empty($project_members) && !in_array($user_id, $project_members)) {
                        continue;
                    }
                }

                $project_options['project_' . $project->ID] = $project->post_title;
            }

            $visibility = array(
                'personal' => __('Personal', 'woffice'),
                'general' => __('General', 'woffice'),
                array(
                    'attr' => array('label' => __('Project', 'woffice')),
                    'choices' => $project_options,
                ),
                array(
                    'attr' => array('label' => __('Group', 'woffice')),
                    'choices' => $group_options,
                ),
            );
        } else {
            $visibility = array(
                'personal' => __('Personal', 'woffice'),
            );
        }

        $repeat_options = array(
            'No' => __('No', 'woffice'),
            'Daily' => __('Daily', 'woffice'),
            'Weekly' => __('Weekly', 'woffice'),
            'Monthly' => __('Monthly', 'woffice'),
            'Yearly' => __('Yearly', 'woffice'),
        );

        $color_options = array(
            'default' => __('default', 'woffice'),
            'blue' => __('blue', 'woffice'),
            'orange' => __('orange', 'woffice'),
            'red' => __('red', 'woffice'),
            'green' => __('green', 'woffice'),
            'grey' => __('grey', 'woffice'),
            'light-blue' => __('light blue', 'woffice'),
            'dark-blue' => __('dark blue', 'woffice'),
            'fushia' => __('fushia', 'woffice'),
            'brown' => __('brown', 'woffice'),
            'black' => __('black', 'woffice'),
            'light-grey' => __('light grey', 'woffice'),
        );

        // Post options used in front end for translations and settings
        $post_options = array(
            'woffice_event_title' => array(
                'type' => 'text',
                'label' => __('Title','woffice'),
                'desc' => __('Set event name.','woffice')
            ),
            'woffice_event_date_start' => array(
                'type' => 'datetime-picker',
                'label' => __('Event Starting Date','woffice'),
                'desc' => __('Will be used to display this event in the calendar.','woffice'),
                'min-date' => '1-0-2000',
                'datetime-picker' => array(
                    'format' => 'Y-m-d H:i:s',
                    'timepicker' => 1,
                    'datepicker' => 1,
                    'minDate' => '2023-11-03'
                )
            ),
            'woffice_event_date_end' => array(
                'type' => 'datetime-picker',
                'label' => __('Event Ending Date','woffice'),
                'desc' => __('Will be used to display this event in the calendar.','woffice'),
                'datetime-picker' => array(
                    'format' => 'Y-m-d H:i:s',
                    'timepicker' => '1',
                    'datepicker' => '1',
                    'minDate' => '2023-11-03'
                )
            ),
            'woffice_event_repeat' => array(
                'type' => 'select',
                'label' => __('Repeat','woffice'),
                'desc' => __('Select repeat type, Choose no if not repeatable event.','woffice'),
                'choices' => array(
                    'No' => 'No',
                    'Daily' => 'Daily',
                    'Weekly' => 'Weekly',
                    'Monthly' => 'Monthly',
                    'Yearly' => 'Yearly'
                )
            ),
            'woffice_event_repeat_date_end' => array(
                'type' => 'datetime-picker',
                'label' => __('Repeat Ending Date','woffice'),
                'desc' => __('Will be used to display this event in the calendar.','woffice'),
                'datetime-picker' => array(
                    'format' => 'Y-m-d H:i:s',
                    'timepicker' => '1',
                    'datepicker' => '1',
                    'minDate' => '2023-11-03'
                )
            ),
            'woffice_event_color' => array(
                'type' => 'select',
                'label' => __('Event Color','woffice'),
                'desc' => __('Event color in calendar.','woffice'),
                'choices' => array(
                    'default' => 'default',
                    'blue' => 'blue',
                    'orange' => 'orange',
                    'red' => 'red',
                    'green' => 'green',
                    'grey' => 'grey',
                    'light-blue' => 'light blue',
                    'dark-blue' => 'dark blue',
                    'fushia' => 'fushia',
                    'brown' => 'brown',
                    'black' => 'black',
                    'light-grey' => 'light grey'
                )

            ),
            'woffice_event_visibility' => array(
                'type' => 'select',
                'label' => __('Event Visibility','woffice'),
                'desc' => __('Set Event Visibility.','woffice'),
                'choices' => $visibility
            ),
            'woffice_event_description' => array(
                'type' => 'textarea',
                'label' => __('Description','woffice')
            ),
            'woffice_event_location' => array(
                'type' => 'text',
                'label' => __('Location','woffice'),
                'desc' => __('Location of the event.','woffice')
            ),
            'woffice_event_link' => array(
                'type' => 'text',
                'label' => __('Event URL','woffice'),
                'desc' => __('URL of the event.','woffice')
            )
        );

        $post_options = $post_options;
        $post_options['new_event_label'] = __('Add a new event', 'woffice');
        $post_options['event_repeat_end_date_label'] = __('Repeat until', 'woffice');
        $post_options['edit_event_label'] = __('Edit event', 'woffice');
        $post_options['new_event_btn_save'] = __('Create event', 'woffice');
        $post_options['event_btn_save'] = __('Save event', 'woffice');
        $post_options['woffice_event_image_label'] = __('Event image', 'woffice');
        $post_options['create_event_label'] = __('Create a New Event', 'woffice');
        $post_options['event_chose_file_label'] = __('Upload event image', 'woffice');
        $post_options['import_ics_file_label'] = __('Import .ics file instead', 'woffice');
        $post_options['user'] = get_current_user_id();
        $post_options['advanced_settings'] = __('Advanced settings', 'woffice');
        $post_options['less_settings'] = __('Collapse', 'woffice');
        $post_options['create_or_import_seprator_text'] = __('or', 'woffice');

        wp_enqueue_script(
            'woffice-events-main',
            woffice_get_extension_uri('event', 'static/js/events.vue.js'),
            array('jquery', 'woffice-theme-script'),
            WOFFICE_THEME_VERSION,
            true
        );

        /**
         * Filter `woffice_events_frontend_config`
         *
         * Let you configure the Woffice Events config passed to the Frontend
         *
         * @param array
         */
        $events_config = apply_filters('woffice_events_frontend_config', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('woffice_events'),
            'fetch_action' => 'woffice_events_fetch',
            'add_action' => 'woffice_events_create',
            'edit_action' => 'woffice_events_edit',
            'events_download' => 'woffice_events_download',
            'previous_month' => __('Previous month', 'woffice'),
            'next_month' => __('Next month', 'woffice'),
            'export_events' => __('Export events', 'woffice'),
            'full_day' => __('Full day', 'woffice'),
            'day_names' => array(
                __('Sunday', 'woffice'),
                __('Monday', 'woffice'),
                __('Tuesday', 'woffice'),
                __('Wednesday', 'woffice'),
                __('Thursday', 'woffice'),
                __('Friday', 'woffice'),
                __('Saturday', 'woffice'),
            ),
            'day_names_assoc' => array(
                'Sunday' => __('Sunday', 'woffice'),
                'Monday' => __('Monday', 'woffice'),
                'Tuesday' => __('Tuesday', 'woffice'),
                'Wednesday' => __('Wednesday', 'woffice'),
                'Thursday' => __('Thursday', 'woffice'),
                'Friday' => __('Friday', 'woffice'),
                'Saturday' => __('Saturday', 'woffice'),
            ),
            'short_day_names' => array(
                __('Sun', 'woffice'),
                __('Mon', 'woffice'),
                __('Tue', 'woffice'),
                __('Wed', 'woffice'),
                __('Thu', 'woffice'),
                __('Fri', 'woffice'),
                __('Sat', 'woffice'),
            ),
            'month_names' => array(
                __('January', 'woffice'),
                __('February', 'woffice'),
                __('March', 'woffice'),
                __('April', 'woffice'),
                __('May', 'woffice'),
                __('June', 'woffice'),
                __('July', 'woffice'),
                __('August', 'woffice'),
                __('September', 'woffice'),
                __('October', 'woffice'),
                __('November', 'woffice'),
                __('December', 'woffice'),
            ),

            'starting_day' => __(ucfirst(woffice_get_theming_option('woffice_calendar_starting_day','Monday')), 'woffice'),
            'month' => date('m'),
            'year' => date('Y'),
            'day' => date('d'),
            'time_format' => woffice_date_php_to_moment_js(get_option('time_format')),
            'date_format' => woffice_date_php_to_moment_js(get_option('date_format')),
            'available_days' => woffice_get_theming_option('woffice_calendar_days'),
            'fields' => array_keys($post_options),
            'enable_event' => (!function_exists('bp_is_active') || empty(bp_displayed_user_id())) ? 1 : get_current_user_id() === bp_displayed_user_id(),
            'field_options' => $post_options,
            'datepicker' => array(
                'format' => 'YYYY-MM-DD H:mm',
                'format_time' => 'H:mm',
                'format_date' => 'YYYY-MM-DD',
                'default_time' => '09:00',
            ),
        ));

        wp_localize_script(
            'woffice-events-main',
            'WOFFICE_EVENTS',
            $events_config
        );

    }
}

add_action( 'wp_enqueue_scripts', 'woffice_event_load_scripts');