<?php

defined('ABSPATH') || exit;



class Woffice_Extension_File_Manager{

    /**
     * @internal
     */

    public function __construct(){
        $this->init();
    }

    public function init(){
		add_action('wp_ajax_woffice_file_manager_upload', array($this,'woffice_file_manager_upload'));
		add_action("wp_ajax_nopriv_woffice_file_manager_upload", array($this,"woffice_file_manager_upload"));

		add_action('wp_ajax_woffice_file_updater', array($this,'woffice_file_update'));
		add_action("wp_ajax_nopriv_woffice_file_updater", array($this,"woffice_file_update"));

		add_action('wp_ajax_woffice_file_manager_delete', array($this,'woffice_file_manager_delete'));
		add_action('wp_ajax_nopriv_woffice_file_manager_delete', array($this,'woffice_file_manager_delete'));

		add_action('wp_ajax_woffice_file_manager_rename_file', array($this,'woffice_file_manager_rename_file'));
		add_action('wp_ajax_nopriv_woffice_file_manager_rename_file', array($this,'woffice_file_manager_rename_file'));

		add_action('wp_footer',array($this,'woffice_file_manager_modal'));

    }

	public static function woffice_file_manager_modal() {
		if(!is_singular('project')){
			return;
		}
	?>
		<div class="woffice-file-rename-modal modal fade" id="woffice-file-rename-modal" data-bs-toggle="woffice-file-rename-modal" aria-labelledby="woffice-file-rename-modal" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="woffice-file-rename-title"><?php _e('Rename File','woffice');?></h5>
					<button type="button" class="btn-close woffice-file-modal-close" data-bs-dismiss="woffice-file-rename-modal" aria-label="Close">
						<i class="woffice-icon woffice-icon-Cross"></i>
					</button>
				</div>
				<div class="modal-body">
					<div class="file-loader d-none">
						<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
						Loading...
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn woffice-file-modal-close" data-bs-dismiss="woffice-file-rename-modal"><?php _e('Close','woffice');?></button>
					<button type="button" class="btn btn-primary woffice-file-rename-btn"><?php _e('Rename File','woffice');?></button>
					<button class="bg-transparent border-0 text-black-50 woffice-file-rename-spinner" type="button" disabled="">
						<span class="spinner-border spinner-border-sm" aria-hidden="true"></span>
					</button>
				</div>
				</div>
			</div>
		</div>
	<?php
	}

	public function woffice_file_update(){
		$posted_data = isset($_POST) ? $_POST : array();
		$post_id = isset($_POST['id']) ? intval($_POST['id']) : 0;
		$has_project_files = get_post_meta($post_id, 'woffice_project_files', true);
		$fileurl = isset($posted_data['fileurl']) ? esc_url($posted_data['fileurl']) : false;
		$filename = sanitize_file_name(basename($fileurl));
		$upload_dirs = $this->generate_upload_path($post_id);
		$upload_path = $upload_dirs['upload_path'] . $filename;
		$file_caps = $file_auth = '';
		
		if(!empty($has_project_files)){
			foreach($has_project_files as $key => $project_file) {
				if(esc_url($project_file['file_url']) == esc_url($fileurl) && file_exists($upload_path) ){
					$file_caps = $project_file['file_caps'];
					$file_auth = $project_file['file_auth'];
				}
			}
		}
	ob_start();
	?>
	<form method="post" class="m-0">
		<div class="row mb-3">
			<div class="col-12 woffice-file-col mb-2">
				<label for="woffice-file-rename-input" class="col-form-label"><?php _e('New file name','woffice');?></label>
				<input type="text" class="form-control woffice-file-rename-input" id="woffice-file-rename-input" required>
			</div>
			<div class="col-12 woffice-file-col mb-2">
				<label class="d-block" for=""><?php _e('Who can access the file?','woffice')?></label>
				<select class="woffice-file-capabilities form-control" name="woffice_file_owner[]" id="">
					<option value="everyone" <?php selected( $file_caps, 'everyone' ); ?>><?php _e('Everyone','woffice');?></option>
					<option value="project_members" <?php selected( $file_caps, 'project_members' ); ?>><?php _e('Project Members','woffice'); ?></option>
					<option value="task_members" <?php selected( $file_caps, 'task_members' ); ?>><?php _e('Task Members','woffice'); ?></option>
					<option value="project_author" <?php selected( $file_caps, 'project_author' ); ?>><?php _e('Project Author Only','woffice');?></option>
					<option value="specific_members" <?php selected( $file_caps, 'specific_members' ); ?>><?php _e('Specific Members','woffice'); ?></option>
				</select>	
			</div>
			<div class="col-12 mb-2 woffice-file-col woffice-file-specific-members-inp d-none">
				<label for=""><?php __('Please Select The Members','woffice');?></label>
				<select class="woffice-file-specific-members" multiple name="specific_members_select">
						<?php echo sprintf('%s',self::woffice_file_manager_get_users($file_auth)); ?>
				</select>
			</div>
		</div>
	</form>
	<?php
	$response = ob_get_contents();
	ob_get_clean();
	wp_send_json($response);
	die;
	}

    public static function woffice_file_manager_list_files(){
        $post_id = get_the_ID();
        ob_start();
        ?>
    <div class="row file_tab_row">
        <div class="col-md-12 p-0 file_tab_table_contenet">
            <div class="list-group file_main_table">
                <div class="row file_table_head">
                    <div class="col-2 file_th"><?php _e('Type', 'woffice');?></div>
                    <div class="col-4 file_th"><?php _e('Files', 'woffice');?></div>
                    <div class="col-2 file_th"><?php _e('Date Modified', 'woffice');?></div>
                    <div class="col-2 file_th"><?php _e('Size', 'woffice');?></div>
					<?php if(self::woffice_file_manager_validate_auth()) { ?>
                    	<div class="col-2 file_th"><?php _e('Actions', 'woffice');?></div>
					<?php } ?>
                </div>
				<div class="list-group woffice-files-data">
					<?php echo self::woffice_file_manager_get_files_list($post_id);?>
				</div>
            </div>
			<?php if(self::woffice_file_manager_validate_auth()) { ?>
				<div class="pt-3  file_add_btn">
					<a class="btn btn-sm woffice-files-create"><i class="woffice-icon woffice-icon-plus"></i></a>
				</div>
			<?php } ?>
        </div>
        <div class="col-md-12 p-0 woffice-files-upload-wrapper">
			<form action="" method="POST" id="woffice_file_manager__form" class="woffice_file_manager__form" enctype="multipart/form-data">
				<div id="woffice_file_manager_upload" class="file-upload">
					<div class="mb-3">
						<label for="upload file" class="form-label">Upload File</label>
						<div id="woffice_file_inputs_container">
							<div class="woffice-file-input-wrapper">
								<div class="row woffice-file-input-row">
									<div class="col-3 woffice-file-col">
										<label class="d-block">File</label>
										<input type="file" name="woffice_files[]" class="woffice_file_manager_input"/>
									</div>
									<div class="col-3 woffice-file-col">
										<label><?php _e('Who can access the file?','woffice');?></label>
										<select class="woffice-file-capabilities" name="woffice_file_owner[]" id="">
											<option value="everyone"><?php _e('Everyone','woffice'); ?></option>
											<option value="project_members"><?php _e('Project Members','woffice');?></option>
											<option value="task_members"><?php _e('Task Members','woffice'); ?></option>
											<option value="project_author"><?php _e('Project Author Only','woffice');?></option>
											<option value="specific_members"><?php _e('Specific Members','woffice');?></option>
										</select>	
									</div>
									<div class="col-3 woffice-file-col woffice-file-specific-members-inp d-none">
										<label for="">Please Select The Members</label>
										<select class="woffice-file-specific-members" multiple name="specific_members_select">
												<?php echo sprintf('%s',self::woffice_file_manager_get_users(0)); ?>
										</select>
									</div>
									<div class="col-3 woffice-file-col"></div>
								</div>
							</div>
						</div>
					</div>
					<button type="button" class="btn btn-default add_more_btn"><i class="woffice-icon woffice-icon-plus"></i> <?php _e('Add More','woffice');?></button>
					<button type="submit" class="btn btn-primary woffice_file_manager_upload_btn"><i class="fa fa-file-upload pr-2"></i><?php _e('Upload Files','woffice');?></button>
					<button class="bg-transparent border-0 text-black-50 woffice-file-upload-spinner" type="button" disabled>
						<span class="spinner-border spinner-border-sm" aria-hidden="true"></span>
					</button>
				</div>
			</form>
		</div>
		<div class="woffice_file_manager__message pt-3"></div>
    </div>
    <?php
		return ob_get_contents();
    }

	/** 
     * List out all users
     * @param $uid int
     * @return if uid is exist then retun with options with selected else return plain options
    */
    public static function woffice_file_manager_get_users($uid) {
        
        $available_user = get_users();
        $user_list = '';
        
        foreach ( $available_user as $user ) {
            if(is_array($uid)) {
                $user_list .= sprintf('<option %3$s value="%1$s">%2$s</option>',$user->ID,$user->display_name,selected(true,in_array($user->ID,$uid),false));
            } else {
                $user_list .= sprintf('<option %3$s value="%1$s">%2$s</option>',$user->ID,$user->display_name,selected($uid, $user->ID,false));
            }
        }

        return $user_list;
    }

	public function woffice_file_manager_upload() {
		$posted_data = isset($_POST) ? $_POST : array();
		$file_data = isset($_FILES) ? $_FILES : array();
		$post_id = isset($posted_data['id']) ? intval($posted_data['id']) : 0;
		$nonce = isset($posted_data['nonce']) ? sanitize_text_field($posted_data['nonce']) : 0;
		$item_content = isset($posted_data['itemContent']) ? json_decode(stripslashes(html_entity_decode($posted_data['itemContent'])),true) : '';
		$data = array_merge($posted_data, $file_data);
		$project_files = array();
		$has_project_files = get_post_meta($post_id, 'woffice_project_files', true);

		if (empty($has_project_files)) {
			$has_project_files = $project_files;
		}
		
		if(!self::woffice_file_manager_validate_auth() || !wp_verify_nonce($nonce,'woffice-file-manager-actions')) {
			$response["response"] = "error";
			$response["error"] = $this->get_file_messages('invalid_auth','');
			
			$responses['uploaded_files'][] = $response;
			$responses['updated_list'] = $this->woffice_file_manager_get_files_list($post_id);

			echo wp_json_encode($responses);
			die();
		}

		$upload_path = $this->generate_upload_path($post_id);
		
		if(is_array($data['woffice_file_manager_upload']) && !empty($data['woffice_file_manager_upload'])){	
			foreach ($data['woffice_file_manager_upload']["name"] as $key => $value) {
				$response = array();
				$fileName = $data["woffice_file_manager_upload"]["name"][$key];
				$fileNameChanged = sanitize_file_name($fileName);

				$temp_name = $data["woffice_file_manager_upload"]["tmp_name"][$key];
				$file_size = $data["woffice_file_manager_upload"]["size"][$key];
				$fileError = $data["woffice_file_manager_upload"]["error"][$key];
				$targetPath = $upload_path['upload_path'];
				$response["filename"] = $fileName;
				$response["file_size"] = $file_size;

				$targetFilePath = $targetPath . $fileNameChanged;

				$fileInfo = pathinfo($targetFilePath);
				$extension = isset($fileInfo["extension"]) ? $fileInfo["extension"] : false;
				$validate_extension = $validate_size = $file_exists = true;
				if (!$extension || !$this->validate_file_extension($extension)) {
					$response["response"] = "error";
					$response["error"] = $this->get_file_messages('invalid_extension','');
					$responses['uploaded_files'][] = $response;
					$validate_extension = false;
				} else if(!$this->validate_file_size($file_size)){
					$response["response"] = "error";
					$response["error"] = $this->get_file_messages('invalid_filesize',self::formatSize('outputsize',$this->convertToBytes($this->get_file_size())),self::formatSize('outputsize',$file_size));
					$responses['uploaded_files'][] = $response;
					$validate_size = false;
				}if (file_exists($targetFilePath)) {
					$response["response"] = "error";
					$response["error"] = $this->get_file_messages('file_exist','');
					$responses['uploaded_files'][] = $response;
					$file_exists = false;
				}else if ($validate_extension && $validate_size && $file_exists && move_uploaded_file($temp_name, $targetFilePath)) {
					$response["response"] = "success";
					$response["error"] = $this->get_file_messages('file_uploaded',$response["filename"]);
					$response["url"] = $upload_path['upload_url'].$fileNameChanged;
					$response["type"] = $extension;
					$current_datetime = date_i18n('Y-m-d H:i:s');
					$updateMeta = array(
						'file_name' => sanitize_text_field($fileName),
						'file_url' => $response["url"],
						'file_size' => intval($file_size),
						'file_type' => sanitize_text_field($extension),
						'file_uploaded_date' => sanitize_text_field($current_datetime),
						'file_uploaded_by' => get_current_user_id(),
						'file_modified_date' => '',
						'file_modified_by' => '',
						'file_caps' => isset($item_content[$key]['capabilities']) ? $item_content[$key]['capabilities'] : '',
						'file_auth' => isset($item_content[$key]['members']) ? $item_content[$key]['members'] : '',
					);
					array_push($has_project_files, $updateMeta);
				}
				$responses['uploaded_files'][] = $response;
			}
			update_post_meta($post_id, 'woffice_project_files', $has_project_files);
			$responses['uploaded_files'] = $this->filter_uploaded_response($responses['uploaded_files']); 
			$responses['updated_list'] = $this->woffice_file_manager_get_files_list($post_id);
		}
				
		echo wp_json_encode($responses);
		die();

	}

	public function get_file_messages($type,...$params){
		$message = '';
		
		switch ($type) {
			case 'invalid_auth':
			  $message = __("You don't have permission to perform this actions. Please contact to admin.",'woffice');
			  break;
			case 'invalid_extension':
				$message = __("Upload Failed, File extension is not allowed.",'woffice');
			  break;
			case 'invalid_filesize':
				$message = sprintf(__("Upload Failed, File size is not allowed greater than %s. Your file size is %s",'woffice'), ...$params);
			  break;
			case 'file_exist':
				$message = __("File already exists.",'woffice');
				break;
			case 'file_renamed':
				$message = __("File renamed successfully.",'woffice');
				break;
			case 'file_uploaded':
				$message = sprintf(__("Your File %s uploaded successfully.",'woffice'), ...$params);
				break;
			case 'file_deleted':
				$message = sprintf(__("File deleted successfully.",'woffice'));
				break;
			case 'file_delete_error':
				$message = sprintf(__("Failed to delete file.",'woffice'));
				break;
			default:
				$message = __("Something went wrong! Try again.",'woffice');
		  }

		return $message;
	}

	public function filter_uploaded_response($uploaded_files) {
		$merged_files = [];
		foreach ($uploaded_files as $file) {
			$filename = $file['filename'];
			if (!isset($merged_files[$filename])) {
				$merged_files[$filename] = $file;
			} else {
				if ($file['response'] === 'success') {
					$merged_files[$filename]['response'] = 'success';
					$merged_files[$filename]['url'] = $file['url'];
				} else {
					$merged_files[$filename]['response'] = 'error';
					$merged_files[$filename]['error'] = $file['error'];
				}
			}
		}

		$merged_files = array_values($merged_files);
		
		return $merged_files;
	}

	public function woffice_file_manager_rename_file() {
		$responses = array();
		$fileurl = isset($_POST['fileurl']) ? esc_url($_POST['fileurl']) : false;
		$post_id = isset($_POST['id']) ? intval($_POST['id']) : 0;
		$old_name = isset($_POST['old_name']) ? sanitize_text_field($_POST['old_name']) : false;
		$new_name = isset($_POST['new_name']) ? sanitize_text_field($_POST['new_name']) : false;
		$fileNameChanged = sanitize_file_name( $new_name );
		$nonce = isset($_POST['nonce']) ? sanitize_text_field($_POST['nonce']) : false;
		
		if(!self::woffice_file_manager_validate_auth() || !wp_verify_nonce($nonce,'woffice-file-manager-actions')) {
			$response["response"] = "error";
			$response["error"] = $this->get_file_messages('invalid_auth','');
			
			$responses['uploaded_files'][] = $response;
			
			echo wp_json_encode($responses);
			die();
		}

		$filename = basename($fileurl);
		$upload_dirs = $this->generate_upload_path($post_id);
		$upload_path = $upload_dirs['upload_path'];

		$fileExtension = pathinfo($upload_path . $filename, PATHINFO_EXTENSION);

		$newFileName = $fileNameChanged . "." . $fileExtension;
		$old_file_name = $upload_path.$filename;
		$new_file_name = $upload_path.$newFileName;
		$project_files = get_post_meta($post_id,'woffice_project_files',true);

		if(file_exists($old_file_name)){
			$file_renamed = false;
			if($new_name && rename($old_file_name, $new_file_name)) {
				$file_renamed = true;
			}
			
			$renamed_project_files = $response = array();
			foreach($project_files as $key => $project_file) {
				
				if($file_renamed && $project_file['file_url'] === $upload_dirs['upload_url'].$filename){
					$project_file['file_url'] = $upload_dirs['upload_url'] .$newFileName;
					$project_file['file_name'] = $new_name;
				} else{
					$response['response'] = "error";
					$response["error"] = $this->get_file_messages('file_exist','');
				}

				$project_file['file_modified_date'] = date_i18n('Y-m-d H:i:s');
				$project_file['file_modified_by'] = get_current_user_id();
				$project_file['file_caps'] = isset($_POST['file_caps']) ? sanitize_text_field($_POST['file_caps']) : false;
				$project_file['file_auth'] = isset($_POST['file_auth']) ? $_POST['file_auth'] : false;
				$response['response'] = "success";
				$response["error"] = $this->get_file_messages('file_renamed','');
					
				array_push($renamed_project_files,$project_file);
			}
			update_post_meta($post_id, 'woffice_project_files',$renamed_project_files);
			
		} else {
			$response['response'] = "error";
			$response['error'] = __('File does not exist','woffice');
		}

		$responses['uploaded_files'][] = $response;
		$responses['updated_list'] = $this->woffice_file_manager_get_files_list($post_id);

		echo wp_json_encode($responses);
		exit();
	}

	public function validate_file_extension($extension) {
		$woffice_file_extensions = woffice_get_theming_option('woffice_file_extensions');
		$is_allowed = false;
		if(!empty($woffice_file_extensions)){
			$allowed_extensions = explode(',',$woffice_file_extensions);
			if(in_array($extension,$allowed_extensions)) {
				$is_allowed = true;
			}
		}
		return $is_allowed;
	}

	public function get_file_size(){

		$woffice_file_size = woffice_get_theming_option('woffice_file_size');
		$woffice_file_unit = woffice_get_theming_option('woffice_file_unit');

		return intval($woffice_file_size).$woffice_file_unit;
	}


	public function validate_file_size($filesize) {

		$allowed_size = $this->get_file_size();
		$max_size_bytes = $this->convertToBytes($allowed_size);
		
		if($filesize < $max_size_bytes) {
			return true;
		}
		return false;
	}

	public function woffice_file_manager_delete() {
		if( isset( $_POST ) ){
			$fileurl = isset($_POST['fileurl']) ? esc_url($_POST['fileurl']) : false;
			$filename = sanitize_file_name(basename($fileurl));
			$upload_dir = wp_upload_dir();
			$post_id = isset($_POST['id']) ? intval($_POST['id']) : false;
			$nonce = isset($_POST['nonce']) ? sanitize_text_field($_POST['nonce']) : false;

			if(!self::woffice_file_manager_validate_auth() || !wp_verify_nonce($nonce,'woffice-file-manager-actions')) {
				
				$response["response"] = "error";
				$response["error"] = $this->get_file_messages('invalid_auth','');
				$responses['uploaded_files'][] = $response;
				
				echo wp_json_encode($responses);
				die();
			}


			$file_removed = $this->remove_file_from_list($post_id,$fileurl);
			$upload_path = $this->generate_upload_path($post_id);
			$upload_path = $upload_path['upload_path'] . $filename;
			
			if(file_exists($upload_path)){
				@unlink($upload_path);
				$response['response'] = "success";
				$response['error'] =  $this->get_file_messages('file_deleted','');
				$response['updated_list'] = $this->woffice_file_manager_get_files_list($post_id);
			} else {
				$response['response'] = "error";
				$response['error'] =  $this->get_file_messages('file_delete_error','');
			}
			
			echo wp_json_encode( $response );
		} 
		die();
	}

	public function remove_file_from_list($post_id,$file_url){
		$project_files = get_post_meta($post_id,'woffice_project_files',true);
		$filename = sanitize_file_name(basename($file_url));
		$upload_path = $this->generate_upload_path($post_id);
		$upload_path = $upload_path['upload_path'] . $filename;
		$file_removed = false;
		if(!empty($project_files)){
			foreach($project_files as $key => $project_file) {
				if($project_file['file_url'] == $file_url){
					unset($project_files[$key]);
					$file_removed = true;
				}
			}
			update_post_meta($post_id, 'woffice_project_files', $project_files);
		}
		return $file_removed;
	}


    public static function woffice_file_manager_get_files_list($post_id) {
		// $post_id = get_the_ID();
		ob_start();
		$project_files = get_post_meta($post_id,'woffice_project_files',true);
		$result = '';
		if(!empty($project_files)){
			
			foreach($project_files as $key => $project_file){
				$validate_auth = self::woffice_file_validate_visibility($project_file);
				if(!$validate_auth){
					continue;
				}
		?>		
				<div class="row woffice-file-list-parent">
					<div class="col-2 file_td">
						<?php echo sanitize_text_field($project_file['file_type']);?>
					</div>
					<div class="col-4 woffice-file-name file_td">
						<?php echo sanitize_text_field($project_file['file_name']);?>
					</div>
					<div class="col-2 file_td">
						<?php echo sanitize_text_field($project_file['file_uploaded_date']);?>
					</div>
					<div class="col-2 file_td">
						<?php echo self::formatSize('outputsize',intval($project_file['file_size']));?>
					</div>
					<div class="col-2 file_td action_td">
						<a href="<?php echo esc_url($project_file['file_url']);?>" download class="woffice-download-file"><i class="fa fa-download"></i></a>
						<a href="javascript:void(0);" class="woffice-file-rename"><i class="woffice-icon woffice-icon-edit"></i></a>
						<a href="javascript:void(0);" class="woffice-remove-file"><i class="woffice-icon woffice-icon-trash"></i></a>
					</div>
				</div>

		<?php	
			}
			
		}
		$result = ob_get_contents();
		ob_end_clean();
		return $result;
    }

	public static function woffice_file_validate_visibility($file) {
		$current_user = get_current_user_id();
		$post_id = get_the_ID();
		$is_admin = current_user_can('manage_options');
		$has_visibility = false;
		if(!empty($file)) {
			$file_caps = isset($file['file_caps']) ? $file['file_caps'] : '';
			
			if($file_caps == 'everyone' || $is_admin){
				$has_visibility = true;
			}elseif($file_caps == 'project_members'){
				$project_members = get_post_meta( $post_id, 'project_members',true);

				if(in_array($current_user,$project_members) || $is_admin){
					$has_visibility = true;
				}

			} elseif($file_caps == 'task_members'){
				$project_metas = woffice_get_project_todos_lists($post_id);

				if(in_array($current_user,$project_metas['assigned']) || $is_admin){
					$has_visibility = true;
				}

			}elseif($file_caps == 'project_author' || $is_admin){
				$author_id = get_post_field( 'post_author', $post_id );
				if($author_id == $current_user) {
					$has_visibility = true;
				}

			}elseif($file_caps == 'specific_members'){
				$file_auth = isset($file['file_auth']) ? $file['file_auth'] : '';
				
				if($is_admin || !empty($file_auth) && in_array($current_user,$file_auth)){
					$has_visibility = true;
				}
			} elseif($is_admin){
				$has_visibility = true;
			}
		}
		return $has_visibility;
	}

	public function generate_upload_path($post_id) {

		$woffice_file_upload_path = woffice_get_theming_option('woffice_file_upload_path');
		$upload_dir = wp_upload_dir();

		if($woffice_file_upload_path == 'dynamic' && $post_id !== 0) {
			$post_title = get_the_title($post_id);
			$dynamic_folder_name = sanitize_title($post_title);
			$upload_path = $upload_dir["basedir"] . "/".$dynamic_folder_name."/";
			$upload_url = $upload_dir["baseurl"] . "/".$dynamic_folder_name."/";

			if (!file_exists($upload_path)) {
				mkdir($upload_path);
			}
		} else {
			$upload_path = $upload_dir["path"]."/";
			$upload_url = $upload_dir["url"]."/";
			if (!file_exists($upload_path)) {
				mkdir($upload_path);
			}
		}

		return array('upload_path' => $upload_path,'upload_url' => $upload_url);

	}


    public static function woffice_file_manager_messages(){

        $fileErrors = array(
            0 => __("There is no error, the file uploaded with success", 'woffice'),
            1 => __("The uploaded file exceeds the upload_max_files in server settings", 'woffice'),
            2 => __("The uploaded file exceeds the MAX_FILE_SIZE from html form", 'woffice'),
            3 => __("The uploaded file uploaded only partially", 'woffice'),
            4 => __("No file was uploaded", 'woffice'),
            6 => __("Missing a temporary folder", 'woffice'),
            7 => __("Failed to write file to disk", 'woffice'),
            8 => __("A PHP extension stoped file to upload", 'woffice'),
        );
    }

	public static function woffice_file_manager_validate_auth(){
		
		$included_members = woffice_get_theming_option('woffice_file_include_members');
		$current_user = wp_get_current_user();
		$available_roles = $current_user->roles;;

		$intersection = !empty($included_members) ? array_intersect($included_members, $available_roles) : false;
		$is_allowed = false;

		if(is_admin() || $intersection || current_user_can('edit_posts')){
			$is_allowed = true;
		}

		return $is_allowed;
	}

    public static function formatSize($type,$size) {

		$units = array('B', 'KB', 'MB', 'GB', 'TB');
		$precision = 2;
		$bytes = max($size, 0);
		$pow = floor(($bytes ? log($bytes) : 0) / log(1024));
		$pow = min($pow, count($units) - 1);

		if($type == 'outputsize') {
			return round($bytes / (pow(1024, $pow)), $precision) . ' ' . $units[$pow];
		} else if($type == 'comparesize'){
			return round($bytes / (pow(1024, $pow)), $precision);
		}
    }

	public function convertToBytes($size) {
		$unit = strtoupper(substr($size, -2));
		$value = (int)substr($size, 0, -2);
		switch ($unit) {
			case 'KB': return $value * 1024;
			case 'MB': return $value * 1024 * 1024;
			case 'GB': return $value * 1024 * 1024 * 1024;
			case 'TB': return $value * 1024 * 1024 * 1024 * 1024;
			default:   return $value;
		}
	}

	public static function woffice_file_manager_appender(){
		ob_start();
	?>
	<div class="row woffice-file-input-row">
		<div class="col-3 woffice-file-col">
			<label class="d-block">File</label>
			<input type="file" name="woffice_files[]" class="woffice_file_manager_input"/>
		</div>
		<div class="col-3 woffice-file-col">
			<label><?php __('Who can access the file?','woffice')?></label>
			<select class="woffice-file-capabilities" name="woffice_file_owner[]" id="">
				<option value="everyone"><?php _e('Everyone','woffice')?></option>
				<option value="project_members"><?php _e('Project Members','woffice') ?></option>
				<option value="task_members"><?php _e('Task Members','woffice'); ?></option>
				<option value="project_author"><?php _e('Project Author Only','woffice');?></option>
				<option value="specific_members"><?php _e('Specific Members','woffice');?></option>
			</select>	
		</div>
		<div class="col-3 woffice-file-col woffice-file-specific-members-inp d-none">
			<label for=""><?php _e('Please Select The Members','woffice');?></label>
			<select class="woffice-file-specific-members" multiple name="specific_members_select">
					<?php echo sprintf('%s',self::woffice_file_manager_get_users(0)); ?>
			</select>
		</div>
		<div class="col-3 woffice-file-col"><a href="javascript:void(0);" class="text-danger remove_file_btn"><i class="woffice-icon woffice-icon-trash"></i></a></div>
	</div>
	<?php
		return ob_get_clean();
	}
}

$Woffice_Extension_File_Manager = new Woffice_Extension_File_Manager();