<?php 

defined( 'ABSPATH' ) || exit;

/**
 * Ajax Callback when adding an answer
 */
function woffice_poll_add_answer(){
	
	if (!wp_verify_nonce( $_POST['woffice_poll_nonce_field'], 'woffice_poll_nonce')) {
		exit("No naughty business please!");
	} 

	
	global $wpdb;
	
	// DEFINE OUR CONSTANT FOR THE TABLE NAME
	$table_name = $wpdb->prefix . 'woffice_poll';
	
	$error = true;

	// GET THE ANSWERS AVAILABLE IN THE DATABASE
	$answers = Woffice_Extension_Woffice_Poll::woffice_get_poll_answers();

	if(isset($_POST['poll'])){
		foreach ($_POST['poll'] as $answer) {
		
			// Check if answer exists
			if (!in_array($answer, $answers)) {
				continue;
			}
			
			$reps = $wpdb->get_row( $wpdb->prepare( "SELECT id, reps FROM $table_name WHERE label = %s",esc_sql($answer)) );
			$new_reps = $reps->reps + 1;
			$updatte_answer = $wpdb->update($table_name,array('reps'=>$new_reps),array( 'id' => $reps->id ));
			// ADD NEW NUMBER OF REPS
		
			if($updatte_answer === FALSE || is_null($updatte_answer)){
				$error = true;
			}else {
				$error = false;
				$user_ID = get_current_user_id();
				// USER CAN'T RE-VOTE
				Woffice_Extension_Woffice_Poll::woffice_poll_add_user($user_ID);
			}	
		}
	}
	
	
	// DISPLAY MESSAGE*
	if ($error === true) {
		echo'<div class="woffice-poll-ajax-reply fail">
			<i class="fa fa-times"></i>
			<p>'.__("Error, something is wrong please refresh this page. Note that you can not vote twice.","woffice").'</p>
		</div>';
	}
	else {
		$poll_question = Woffice_Extension_Woffice_Poll::woffice_get_poll_name();

		echo'<div class="woffice-poll-ajax-reply sent">
			<i class="fa fa-check"></i>
			<p>'.__("Thanks ! Here are the results for","woffice").'</p>
			<span class="poll-question-back">'.$poll_question.'</span>
		</div>'; 

		Woffice_Extension_Woffice_Poll::woffice_poll_get_results();
	}
	
	die();
}
add_action('wp_ajax_woffice_poll_add_answer', 'woffice_poll_add_answer');
add_action('wp_ajax_nopriv_woffice_poll_add_answer', 'woffice_poll_add_answer');

/**
 * REFRESH TABLE IN THE DATABASE
 */	
function woffice_poll_refresh_table() {
	
	$delete_poll = isset($_GET["delete_poll"]) ? sanitize_text_field($_GET["delete_poll"]) : false;
	$nonce = isset($_POST['nonce']) ? sanitize_text_field($_POST['nonce']) : false;
	if (is_admin() && current_user_can('manage_options') && wp_verify_nonce( $nonce, 'poll_nonce' ) && $delete_poll == "yes") {
    
		/* We delete the entries in the database */
	    global $wpdb;
		$table_name = WOFFICE_POLL_TABLE;
		$sql = "DELETE FROM $table_name;";
		$wpdb->query($sql);
		
		/* We delete the setting in the extension */
		delete_option('woffice_poll_added_default_ans');
		if(class_exists('Redux')){			
			Redux::set_option( 'woffice_theme_options', 'woffice_poll_answers', '');
		}
		/* User array refresh */
		update_option('woffice_poll_users', array());
		
		/* We remove the GET param */
		wp_redirect(admin_url('admin.php?page=woffice_theme_options'));
		
	}
	
}
add_action('admin_init', 'woffice_poll_refresh_table');

/**
 * REFRESH TABLE IN THE DATABASE
 */	
function woffice_poll_export_table() {
	
	$export_poll = isset($_GET["export_poll"]) ? sanitize_text_field($_GET["export_poll"]) : false;
	$nonce = isset($_GET['nonce']) ? sanitize_text_field($_GET['nonce']) : false;

	if (is_admin() && current_user_can('manage_options') && wp_verify_nonce($nonce, 'poll_nonce' ) && $export_poll == "yes") {
		
		// We get the array of results
		$array_results = Woffice_Extension_Woffice_Poll::woffice_poll_get_results_backend($export_poll);

		// create a file pointer connected to the output stream
		$output = fopen('php://output', 'w');
		// HEADER READY : 
		header('Content-Type: text/csv; charset=utf-8');
		header('Content-Disposition: attachment; filename=data.csv');
		
		fputcsv($output, array(__('Results are in percentage','woffice')));
		// Output in the file : 
		foreach($array_results as $result) {
			$label = $result['label'];
			$value = strip_tags($result['html']); // Clean HTML, keep just the number or percent
			fputcsv($output, [$label, $value]); // One row with two columns
		}
		
		fclose($output);
		
		exit();
		
		wp_redirect(admin_url('admin.php?page=woffice_theme_options'));
		
	}
	
}
add_action('admin_init', 'woffice_poll_export_table');