<?php

defined( 'ABSPATH' ) || exit;

function woffice_import_files() {

    if (class_exists('OCDI_Plugin')) {
        $demo_content = array(
            array(
                'import_file_name' => 'Stellar Demo',
                'import_file_url' => esc_url('https://hub.woffice.io/storage/woffice/plugins/n1a9x/demo-content/woffice-demo-content.xml'),
                'import_widget_file_url' => esc_url('https://hub.woffice.io/storage/woffice/plugins/n1a9x/demo-content/woffice-demo-widgets.wie'),
                'import_redux' => array(
                    array(
                      'file_url'    => 'https://hub.woffice.io/storage/woffice/plugins/n1a9x/demo-content/theme-options.json',
                      'option_name' => 'woffice_theme_options',
                    ),
                ),
                'import_preview_image_url' => esc_url('https://hub.woffice.io/storage/woffice/plugins/n1a9x/demo-content/theme-options.png'),
                'preview_url' => esc_url('http://demo.woffice.io/'),
            ),
        );

        return $demo_content;
    }
}

add_filter('ocdi/import_files', 'woffice_import_files');

function woffice_plugin_page_setup( $default_settings ) {
    $default_settings['parent_slug'] = 'themes.php';
    $default_settings['page_title']  = esc_html__( 'Woffice Demo Content' , 'woffice' );
    $default_settings['menu_title']  = esc_html__( 'Woffice Demo Importer' , 'woffice' );
    $default_settings['capability']  = 'import';
    $default_settings['menu_slug']   = 'woffice-demo-import';
 
    return $default_settings;
}
add_filter( 'ocdi/plugin_page_setup', 'woffice_plugin_page_setup' );

function woffice_after_import_setup() {
    if (!current_user_can('manage_options')) {
        return;
    }

    $menu_name = 'Menu Header';
    $menu_term = get_term_by('name', sanitize_text_field($menu_name), 'nav_menu');

    $menu_id = absint($menu_term->term_id);

    $locations = get_theme_mod('nav_menu_locations');
    if (!is_array($locations)) {
        $locations = array();
    }
    $location_key = sanitize_key('primary');
    $locations[$location_key] = $menu_id;
    set_theme_mod('nav_menu_locations', $locations);

}

function woffice_replace_menu_urls() {
    if (!current_user_can('manage_options')) {
        return;
    }

    $current_site_url = esc_url_raw(home_url());

    global $wpdb;
    $postmeta_table = $wpdb->prefix . 'postmeta';

    $query = $wpdb->prepare(
        "UPDATE {$postmeta_table} SET meta_value = REPLACE(meta_value, %s, %s) 
        WHERE meta_key = '_menu_item_url' AND meta_value LIKE %s",
        esc_url_raw('https://import.woffice.io'),
        $current_site_url,
        '%https://import.woffice.io%'
    );
    
    $result = $wpdb->query($query);
}

add_action('ocdi/after_import', 'woffice_after_import_setup');
add_action('ocdi/after_import', 'woffice_replace_menu_urls');

function woffice_importer_title($plugin_title ){
    ob_start(); 
?>
		<div class="ocdi__title-container">
			<h1 class="ocdi__title-container-title"><?php esc_html_e( 'Woffice Demo Import', 'woffice' ); ?></h1>
		</div>
		<?php
	$plugin_title = ob_get_clean();

    return $plugin_title;

}

add_filter( 'ocdi/plugin_page_title','woffice_importer_title');
