<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux' ) ) {
	return;
}

if (!class_exists('Redux')) {
    return;
}

global $wp_roles;
$tt_roles = array();

foreach ($wp_roles->roles as $key=>$value){
	$tt_roles[$key] = $value['name'];
}

$tt_roles_tmp = $tt_roles;

$matching_field_options = array();

$woffice_old_tab_option = get_option('fw_theme_settings_options:woffice');

if (woffice_bp_is_active( 'xprofile' ) && function_exists('woffice_get_xprofile_table')) {
	$bp_fields_options = array();
	
	// We fetch all the BuddyPress fields :
	global $wpdb;
    $table_name = woffice_get_xprofile_table('fields');
            
	$sqlStr = "SELECT id, name, parent_id, type type FROM ".$table_name;
	$bp_fields = $wpdb->get_results($sqlStr);
    $multi_types = ['checkbox', 'selectbox', 'multiselectbox', 'radio'];

	$bp_test = array();
	
	if(is_array($bp_fields) && !empty($bp_fields) && count($bp_fields) > 0) {
		$bp_fields_options[] = array(
			'id'       => 'opt-buddypress_raw',
			'type'     => 'raw',
			'title'    => __( '<h3>Display fields in BuddyPress members directory.</h3>', 'woffice' ),
			'content'  => '',
		);

		$bp_fields_options[] = array(
			'id'       => 'buddypress_wordpress_email_display',
			'type'     => 'switch',
			'title'    =>  __('Show the WordPress email','woffice'),
			'desc'     => __('If checked the standard WordPress email (the email used to login) will be displayed on the members page.','woffice'),
			'on'       => esc_html__('Yes','woffice'),
			'off'      => esc_html__('No','woffice'),
			'default'  => isset($woffice_old_tab_option['buddypress_wordpress_email_display']) ? $woffice_old_tab_option['buddypress_wordpress_email_display'] : '',
		);

		$bp_fields_options[] = array(
			'id'       => 'buddypress_wordpress_email_add_to_search',
			'type'     => 'switch',
			'title'    =>  __('Add WordPress email to advanced search?','woffice'),
			'desc' 	   => __('If checked the field will be aded to the advanced search form in the members page.','woffice'),
			'on'       => esc_html__('Yes','woffice'),
			'off'      => esc_html__('No','woffice'),
			'default'  => isset($woffice_old_tab_option['buddypress_wordpress_email_add_to_search']) ? $woffice_old_tab_option['buddypress_wordpress_email_add_to_search'] : '',
		);

		$bp_fields_options[] = array(
			'id'       		   => 'buddypress_wordpress_email_icon',
			'type'             => 'icon_select',
			'title'            => 'Field\'s icon',
			'default'  		   => isset($woffice_old_tab_option['buddypress_wordpress_email_icon']) ? $woffice_old_tab_option['buddypress_wordpress_email_icon'] : '',
			'options'          => redux_icon_select_fa_5_free(),
			'enqueue'          => true,
			'enqueue_frontend' => true,
			'stylesheet'       => 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.9.0/css/all.css',
			'prefix'           => 'fa',
		);
		foreach ($bp_fields as $key => $bp_field) {
			if($bp_field->parent_id != 0)
				continue;

			$bp_field_name = $bp_field->name;

			if (in_array($bp_field->type, $multi_types)) {
                $matching_field_options[$bp_field->id] = $bp_field_name;
            }

			$bp_fields_options[] = array(
				'id'       => 'buddypress_'.$bp_field_name.'_display',
				'type'     => 'switch',
				'title'    =>  __('Show <code>'.$bp_field_name.'</code>','woffice'),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => isset($woffice_old_tab_option['buddypress_'.$bp_field_name.'_display']) ? $woffice_old_tab_option['buddypress_'.$bp_field_name.'_display'] : '',
				'desc' => __('If checked the field will be displayed on the members page.','woffice')
			);

			if($bp_field->type != 'datebox') {
				$bp_fields_options[] = array(
					'id'       => 'buddypress_'.$bp_field_name.'_add_to_search',
					'type'     => 'switch',
					'title'    =>  __('Add <code>'.$bp_field_name.'</code> field to advanced search?','woffice'),
					'on'       => esc_html__('Yes','woffice'),
					'off'      => esc_html__('No','woffice'),
					'default'  => isset($woffice_old_tab_option['buddypress_'.$bp_field_name.'_add_to_search']) ? $woffice_old_tab_option['buddypress_'.$bp_field_name.'_add_to_search'] : '',
					'desc' => __('If checked the field will be aded to the advanced search form in the members page.','woffice'),
				);
			}
			$bp_fields_options[] = array(
					'id'       		   => 'buddypress_'.$bp_field_name.'_icon',
					'type'             => 'icon_select',
					'title'            => 'buddypress <code>'.$bp_field_name.'</code> icon',
					'default' 		   => isset($woffice_old_tab_option['buddypress_'.$bp_field_name.'_icon']) ? $woffice_old_tab_option['buddypress_'.$bp_field_name.'_icon'] : '',
					'options'          => redux_icon_select_fa_5_free(),
					'enqueue'          => true,
					'enqueue_frontend' => true,
					'stylesheet'       => 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.9.0/css/all.css',
					'prefix'           => 'fa',
			);
		}	
	}
} else {
	$bp_fields_options = array();
}

$buddypress_tab_main_opt_fields = array(
	array(
		'id'       => 'profile_layout',
		'type'     => 'button_set',
		'title'    => esc_html__( 'Profile/Group layout', 'woffice' ),
		'desc'     => esc_html__( 'Choose the profile layout whether there is a left sidebar and the content on the right side or the sidebar is displayed horizontally.', 'woffice' ),
		'options'  => array(
			'horizontal' => 'Horizontal',
			'vertical' => 'Vertical',
		),
		'default'  => isset($woffice_old_tab_option['profile_layout']) ? $woffice_old_tab_option['profile_layout'] : 'horizontal',
	),
	array(
		'id'       => 'buddy_calendar',
		'type'     => 'switch',
		'title'    => esc_html__( 'Personal Calendar', 'woffice' ),
		'desc'	   => esc_html__( 'Show the personal calendar tab on user\'s profile.', 'woffice' ),
		'on'       => esc_html__('Show','woffice'),
		'off'      => esc_html__('Hide','woffice'),
		'default'  => isset($woffice_old_tab_option['buddy_calendar']) ? woffice_unyson_switch_to_bool($woffice_old_tab_option['buddy_calendar']) : '',
	),
	array(
		'id'       => 'buddy_notes',
		'type'     => 'switch',
		'title'    => esc_html__( 'Personal Note', 'woffice' ),
		'desc'	   => esc_html__( 'Show the personal note tab on user\'s profile', 'woffice' ),
		'on'       => esc_html__('Show','woffice'),
		'off'      => esc_html__('Hide','woffice'),
		'default'  => isset($woffice_old_tab_option['buddy_notes']) ? woffice_unyson_switch_to_bool($woffice_old_tab_option['buddy_notes']) : '',
	),
	array(
		'id'       => 'buddy_social',
		'type'     => 'switch',
		'title'    => esc_html__( 'Social Fields', 'woffice' ),
		'desc'	   => esc_html__( 'Show the social fields in the profile.', 'woffice' ),
		'on'       => esc_html__('Show','woffice'),
		'off'      => esc_html__('Hide','woffice'),
		'default'  => isset($woffice_old_tab_option['buddy_social']) ? woffice_unyson_switch_to_bool($woffice_old_tab_option['buddy_social']) : '',
	),
	array(
		'id'       => 'buddy_directory_name',
		'type'     => 'button_set',
		'title'    => esc_html__( 'User member title', 'woffice' ),
		'desc'     => esc_html__( 'This is what will be displayed for each user in the members directory.', 'woffice' ),
		'options'  => array(
			'name' => 'First & Last Names',
			'username' => 'Username',
		),
		'default'  => 'username',
		'default'  => isset($woffice_old_tab_option['buddy_directory_name']) ? $woffice_old_tab_option['buddy_directory_name'] : '',
	),
	array(
		'id'       => 'buddy_filter',
		'type'     => 'switch',
		'title'    => esc_html__( 'Roles filter', 'woffice' ),
		'desc'	   => esc_html__( 'Show the dropdown filter on the BuddyPress members directory.', 'woffice' ),
		'on'       => esc_html__('Show','woffice'),
		'off'      => esc_html__('Hide','woffice'),
		'default'  => isset($woffice_old_tab_option['buddy_filter']) ? woffice_unyson_switch_to_bool($woffice_old_tab_option['buddy_filter']) : '',
	),
	array(
		'id'       => 'buddy_advanced_search',
		'type'     => 'switch',
		'title'    => esc_html__( 'Members advanced search', 'woffice' ),
		'desc'	   => esc_html__( 'Show the extra fields to filter members (Fields have to be enabled below).', 'woffice' ),
		'on'       => esc_html__('Show','woffice'),
		'off'      => esc_html__('Hide','woffice'),
		'default'  => isset($woffice_old_tab_option['buddy_advanced_search']) ? woffice_unyson_switch_to_bool($woffice_old_tab_option['buddy_advanced_search']) : '',
	),
	array(
		'id'       => 'buddy_sort_members_by',
		'type'     => 'select',
		'title'    => esc_html__( 'Sort Members by', 'woffice' ),
		'options'  => array(
			'active' => esc_html__( 'Activity', 'woffice' ),
			'alphabetical'  => esc_html__( 'Alphabetically', 'woffice' ),
			'newest'  => esc_html__( 'Newest', 'woffice' ),
			'online' => esc_html__( 'Online', 'woffice' ),
			'popular'  => esc_html__( 'Popular', 'woffice' ),
			'random'  => esc_html__( 'Random', 'woffice' ),
		),
		'default'  => isset($woffice_old_tab_option['buddy_sort_members_by']) ? $woffice_old_tab_option['buddy_sort_members_by'] : '',
	),
	array(
		'id'       => 'buddy_members_layout',
		'type'     => 'button_set',
		'title'    => esc_html__( 'Members layout', 'woffice' ),
		'desc'     => esc_html__( 'Layout of your members directory.', 'woffice' ),
		'options'  => array(
			'cards' => 'cards',
			'table' => 'Table',
		),
		'default'  => isset($woffice_old_tab_option['buddy_members_layout']) ? $woffice_old_tab_option['buddy_members_layout'] : '',
	),
	array(
		'id'       => 'buddypress_members_per_page',
		'type'     => 'text',
		'title'    => esc_html__("Members per page", 'woffice' ),
		'validate' => array( 'numeric'),
		'default'  => isset($woffice_old_tab_option['buddypress_members_per_page']) ? $woffice_old_tab_option['buddypress_members_per_page'] : '',
	),
	array(
		'id'       => 'buddy_excluded_directory',
		'type'     => 'select',
		'multi'    => true,
		'title'    => __('Members Excluded (Directory)', 'woffice'), 
		'desc'     => __('Do you want to exclude a role from the Members directory, they won\'t be displayed on the page.', 'woffice'),
		'options'  => $tt_roles_tmp,
		'default'  => isset($woffice_old_tab_option['buddy_excluded_directory']) ? $woffice_old_tab_option['buddy_excluded_directory'] : '',
	),
	array(
		'id'       => 'buddy_directory_autolink',
		'type'     => 'switch',
		'title'    => esc_html__( 'Members Directory autolinks', 'woffice' ),
		'desc'	   => esc_html__( 'Auto search for BuddyPress fields displayed in the directory.', 'woffice' ),
		'on'       => esc_html__('Yes','woffice'),
		'off'      => esc_html__('No','woffice'),
		'default'  => isset($woffice_old_tab_option['buddy_directory_autolink']) ? woffice_unyson_switch_to_bool($woffice_old_tab_option['buddy_directory_autolink']) : '',
	),
	array(
		'id'       => 'member_matching_fields',
		'type'     => 'select',
		'multi'    => true,
		'title'    => esc_html__('Member Matching Field', 'woffice'), 
		'desc'     => esc_html__('If a field is selected, the current member will only see members having the same choice. Example, if there are two choices: A & B. If the current members select A, he\'ll see members having selected A as well. Otherwise A & B.', 'woffice'),
		'options'  => $matching_field_options,
		'default'  => isset($woffice_old_tab_option['member_matching_fields']) ? $woffice_old_tab_option['member_matching_fields'] : '',
	),
);


$buddypress_tab_creator = array(
	'id' => 'buddypress_opts-main_options',
	'title' => esc_html__('Main Options', 'woffice'),
	'desc' => esc_html__('For full documentation on this, visit: ', 'woffice') . '<a href="https://docs.woffice.io/" target="_blank">' . esc_html__('Woffice documentation', 'woffice') . '</a>',
	'subsection' => true,
	'fields' => $buddypress_tab_main_opt_fields,
);

Redux::set_section( $opt_name,$buddypress_tab_creator);

$fields = array(
	array(
		'id' => 'show_buddypress_cover',
		'type' => 'switch',
		'title' => esc_html__('Show', 'woffice'),
		'on' => esc_html__('Yes', 'woffice'),
		'off' => esc_html__('No', 'woffice'),
	),
	array(
		'id' => 'buddypress_default_cover_image',
		'type' => 'background',
		'background-color' => false,
		'url' => true,
		'title' => esc_html__('Default Image', 'woffice'),
		'desc' => esc_html__('If cover image is not added then default image is used.', 'woffice'),
		'default' => array(
			'background-repeat' => 'no-repeat',
			'background-attachment' => 'inherit',
			'background-position' => 'center center',
			'background-size' => 'cover',
		),
		'compiler' => 'true',
		'preview_size' => 'full',
	),
	array(
		'id' => 'buddypress_cover_overlay',
		'type' => 'color',
		'title' => esc_html__('Overlay Color', 'woffice'),
		'default' => 'rgba(49,70,197,0.52)',
		'transparent' => false,
		'color_alpha' => true,
	),
);

$sections = array(
	'title' => esc_html__('Cover Image', 'woffice'),
	'id' => 'buddypress_opts-buddypress_select',
	'desc' => esc_html__('For full documentation on this, visit: ', 'woffice') . '<a href="https://docs.woffice.io/" target="_blank">' . esc_html__('Woffice documentation', 'woffice') . '</a>',
	'subsection' => true,
	'fields' => $fields,
);

Redux::set_section( $opt_name,$sections);

$buddypress_dynamic_field = $bp_fields_options;

$buddypress_dynamic_section = array(
	'id' => 'buddypress_opts-buddypress_dynamic_fields',
	'title' => esc_html__('Dynamic fields', 'woffice'),
	'desc' => esc_html__('For full documentation on this, visit: ', 'woffice') . '<a href="https://docs.woffice.io/" target="_blank">' . esc_html__('Woffice documentation', 'woffice') . '</a>',
	'subsection' => true,
	'fields' => $buddypress_dynamic_field,
);

Redux::set_section( $opt_name,$buddypress_dynamic_section);

$tab_options = woffice_get_theming_option('boddypres_tab_creator');

if(!empty($woffice_old_tab_option) && isset($woffice_old_tab_option['buddypress-tabs']) && !empty($woffice_old_tab_option['buddypress-tabs']) && isset($tab_options['name']) && empty($tab_options['name'])) {
	$tabs = array();

	foreach($woffice_old_tab_option['buddypress-tabs'] as $key => $tab){
		$tabs['redux_repeater_data'][]['title'] = $tab['name'];
		$tabs['name'][] = $tab['name'];
		$tabs['content'][] = $tab['content'];
		$tabs['icon'][] = $tab['icon'];
		$tabs['action'][] = $tab['action'];
	}

	Redux::set_option( 'woffice_theme_options', 'boddypres_tab_creator', $tabs );
}

$buddypress_tab_creator_fields = array(
	array(
		'id'          => 'boddypres_tab_creator',
		'type'        => 'repeater',
		'title'       => esc_html__( 'Tabss', 'woffice' ),
		'full_width'  => false,
		'subtitle'    => '',
		'item_name'   => '',
		'sortable'    => true,
		'active'      => false,
		'collapsible' => false,
		'group_values' => true, 
		'fields'      => array(
			array(
				'id'       => 'name',
				'type'     => 'text',
				'title'    => esc_html__( 'Name', 'woffice' ),
			),
			array(
				'id'       => 'content',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Content', 'woffice' ),
			),
			array(
				'id'               => 'icon',
				'type'             => 'icon_select',
				'title'            => esc_html__( 'Legacy Icon Select', 'woffice' ),
				'options'          => redux_icon_select_fa_5_free(),
				'enqueue'          => true,
				'enqueue_frontend' => true,
				'stylesheet'       => 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.9.0/css/all.css',
				'prefix'           => 'fa',
			),
			array(
				'id'       => 'action',
				'type'     => 'text',
				'title'    => esc_html__( 'action', 'woffice' ),
				'desc'     => __('Like: <b>woffice_bp_tab_my_tab</b>. Must be unique. This advanced option let you attach any PHP function to the tab content by calling:','woffice').
									' <span class="highlight">add_action("woffice_bp_tab_my_tab", "your_callback_function")</span> '.
									__('Please see the official WordPress documentation for more details here:', 'woffice').
									' <a href="https://developer.wordpress.org/reference/functions/add_action/" target="_blank">developer.wordpress.org/reference/functions/add_action/</a>',
			),
		),
	),
);

$buddypress_tab_creator = array(
	'id' => 'buddypress_opts-buddypress_tab_creattor',
	'title' => esc_html__('Tab creator', 'woffice'),
	'desc' => esc_html__('For full documentation on this, visit: ', 'woffice') . '<a href="https://docs.woffice.io/" target="_blank">' . esc_html__('Woffice documentation', 'woffice') . '</a>',
	'subsection' => true,
	'fields' => $buddypress_tab_creator_fields,
);

Redux::set_section( $opt_name,$buddypress_tab_creator);