<?php
/**
 * Redux Framework image select config.
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

 defined( 'ABSPATH' ) || exit;

 if ( ! class_exists( 'Redux' ) ) {
	 return;
 }
$plugins_url = plugins_url();

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Copyright Bar', 'woffice' ),
		'id'         => 'footer-options-copyright_bar',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
            array(
				'id'       => 'show_copyright_bar',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => 'off',
			),
            array(
				'id'      => 'copyright_content',
				'type'    => 'editor',
				'title'   => esc_html__( 'Content', 'woffice' ),
				'default' => '© 2021 all rights reserved. Powered by <a href="//themeforest.net/user/2Fwebd">Woffice</a>.',
				'args'    => array(
					'wpautop'       => false,
					'media_buttons' => false,
					'textarea_rows' => 5,
					'teeny'         => false,
					'quicktags'     => false,
				),
			),
		),
	)
);
