<?php 
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux' ) || !class_exists('Woffice_Facebook_Signing') ) {
	return;
}

$facebook_details = woffice_get_settings_option('facebook_details');


$facebook_enabled = woffice_unyson_switch_to_bool(woffice_get_settings_option('facebook_enabled'));
$facebook_enabled_default = ($facebook_enabled) ? $facebook_enabled : false;

$facebook_app_id = woffice_get_settings_option('facebook_app_id');

$facebook_app_secret = woffice_get_settings_option('facebook_app_secret');

$facebook_callback = class_exists('Woffice_Facebook_Signing') ? Woffice_Facebook_Signing::getCallbackUrl() : '';


Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Facebook Options', 'woffice' ),
		'id'         => 'login-register-facebook_options',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,

		'fields'     => array(
			 array( 
		        'id'       => 'facebook_details',
		        'type'     => 'raw',
		        'full_width' => 'true',
		        'title'    => esc_html__('Setup', 'woffice'),
		        'desc'     => esc_html__('You will need to create a new application on Facebook from this page:', 'woffice').' <a href="https://developers.facebook.com/apps/" target="_blank">developers.facebook.com/apps/</a>',
		        'content'  => $facebook_details
		    ),
			 array(
		        'id'       => 'facebook_enabled',
		        'type'     => 'switch',
		        'title'    => esc_html__('Enable', 'woffice'),
		        'desc'     => esc_html__('You will also need to have the above options set up. This is just so you can deactivate it without loosing your settings.','woffice'),
		        'default'  => $facebook_enabled_default,
		    ),
			 array( 
		        'id'       => 'facebook_callback_url',
		        'type'     => 'raw',
		        'full_width' => 'true',
		        'title'    => esc_html__('Your callback URL', 'woffice'),
		        'content'  => '<span class="highlight">'. $facebook_callback .'</span>'
		    ),
			array(
		        'id'=>'facebook_app_id',
		        'type' => 'textarea',
		        'title' => __('App ID', 'woffice'),
		        'desc' => __('Your Facebook APP ID goes here.', 'woffice'),
		        'default' => $facebook_app_id,
		    ),
		    array(
		        'id'=>'facebook_app_secret',
		        'type' => 'textarea',
		        'title' => __('App Secret', 'woffice'),
		        'desc' => __('Your Facebook APP Secret goes here.', 'woffice'),
		        'default' => $facebook_app_secret,
		    ),
		),
	)
);
