<?php
/**
 * Redux Framework font family select config.
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

 defined( 'ABSPATH' ) || exit;

 if ( ! class_exists( 'Redux' ) ) {
	 return;
 }
$plugins_url = plugins_url();

$font_main_typography = woffice_get_settings_option('font_main_typography');
$font_headline_typography = woffice_get_settings_option('font_headline_typography');
$font_extentedlatin = woffice_get_settings_option('font_extentedlatin');
$font_headline_bold = woffice_get_settings_option('font_headline_bold');
$font_headline_uppercase = woffice_get_settings_option('font_headline_uppercase');

$font_main_typography_size = '';
if(isset($font_main_typography['size']) && !empty($font_main_typography['size'])){
	$font_main_typography_size = $font_main_typography['size'];
}
$font_main_typography_family = '';
if(isset($font_main_typography['family']) && !empty($font_main_typography['family'])){
	$font_main_typography_family = $font_main_typography['family'];
}
$font_main_typography_style = '';
if(isset($font_main_typography['style']) && !empty($font_main_typography['style'])){
	$font_main_typography_style = $font_main_typography['style'];
}

$font_headline_typography_size = '';
if(isset($font_headline_typography['size']) && !empty($font_headline_typography['size'])){
	$font_headline_typography_size = $font_headline_typography['size'];
}
$font_headline_typography_family = '';
if(isset($font_headline_typography['family']) && !empty($font_headline_typography['family'])){
	$font_headline_typography_family = $font_headline_typography['family'];
}
$font_headline_typography_style = '';
if(isset($font_headline_typography['style']) && !empty($font_headline_typography['style'])){
	$font_headline_typography_style = $font_headline_typography['style'];
}

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Font Options', 'woffice' ),
		'id'         => 'styling-options-font_options',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
			array(
				'id'                => 'font_main_typography',
				'type'              => 'typography',
				'title'             => esc_html__( 'Main Font Family', 'woffice' ),
				'subtitle'          => esc_html__( 'Used for the main texts (content, menu, footer ...).', 'woffice' ),
				'google'            => true,
				'font_family_clear' => false,
                'color'             => false,
                'text-align'        => false,
                'subsets'           => false,
                'default'           => array(
					'font-size'   => $font_main_typography_size,
					'font-family' => $font_main_typography_family,
					'font-weight' => filter_var($font_main_typography_style, FILTER_SANITIZE_NUMBER_INT),
				),
			),
            array(
				'id'                => 'font_headline_typography',
				'type'              => 'typography',
				'title'             => esc_html__( 'Headlines Font Family', 'woffice' ),
				'subtitle'          => esc_html__( 'Used for all the headlines. The size set here does not matters.', 'woffice' ),
				'google'            => true,
				'font_family_clear' => false,
                'color'             => false,
                'text-align'        => false,
                'font-size'         => false,
                'subsets'           => false,
                'default'           => array(
					'font-size'   => $font_headline_typography_size,
					'font-family' => $font_headline_typography_family,
					'font-weight' => filter_var($font_headline_typography_style, FILTER_SANITIZE_NUMBER_INT),
				),
			),
            array(
				'id'       => 'font_extentedlatin',
				'type'     => 'switch',
				'title'    => esc_html__( 'Extended latin', 'woffice' ),
				'desc'     => esc_html__( 'This is for some fonts in some language (polish for example).', 'woffice' ),
                'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $font_extentedlatin,
			),
            array(
				'id'       => 'font_headline_bold',
				'type'     => 'switch',
				'title'    => esc_html__( 'Bold Headlines', 'woffice' ),
				'desc'     => esc_html__( 'This is a global option for most of the titles, you will have something similar to the demo.', 'woffice' ),
                'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $font_headline_bold,
			),
            array(
				'id'       => 'font_headline_uppercase',
				'type'     => 'switch',
				'title'    => esc_html__( 'Uppercase Headlines', 'woffice' ),
				'desc'     => esc_html__( 'This is a global theme option.', 'woffice' ),
                'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $font_headline_uppercase,
			),
		),
	)
);
