<?php
/**
 * Redux Framework image select config.
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

 defined( 'ABSPATH' ) || exit;

 if ( ! class_exists( 'Redux' ) ) {
	 return;
 }
$plugins_url = plugins_url();

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Footer Hero', 'woffice' ),
		'id'         => 'footer-options-footer_hero',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
            array(
				'id'       => 'show_footer_hero',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => 'off',
			),
            array(
				'id'           => 'footer_hero_image',
				'type'         => 'media',
				'url'          => true,
				'title'        => esc_html__( 'Background Image', 'woffice' ),
				'compiler'     => 'true',
				'preview_size' => 'full',
			),
            array(
                'id'       => 'footer_hero_overlay',
                'type'     => 'color',
                'title'    => esc_html__( 'Background Image Overlay Color', 'woffice' ),
                'default'  => 'rgba(135,135,135,0.52)',
                'transparent' => false,
                'color_alpha' => true
            ),
			array(
				'id'      => 'footer_hero_content',
				'type'    => 'editor',
				'title'   => esc_html__( 'Content', 'woffice' ),
				'default' => 'We are more than 35 around the world !',
				'args'    => array(
					'wpautop'       => false,
					'media_buttons' => false,
					'textarea_rows' => 5,
					'teeny'         => false,
					'quicktags'     => false,
				),
			),
		),
	)
);
