<?php
/**
 * Redux Framework image select config.
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

 defined( 'ABSPATH' ) || exit;

 if ( ! class_exists( 'Redux' ) ) {
	 return;
 }
$plugins_url = plugins_url() . '/woffice-core/theme-options/options/img/footer-layouts/';

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Footer Layout', 'woffice' ),
		'id'         => 'footer-options-footer_layout',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
            array(
				'id'       => 'show_footer',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => 'off',
			),
			array(
				'id'       => 'footer_layout',
				'type'     => 'image_select',
            	'title'    => esc_html__( 'Select Layout', 'woffice' ),
				'presets'    => false,
				'options'  => array(
                    '6-6' => array(
						'alt' => '6-6',
						'img' => $plugins_url .'6-6.png',
					),
					'4-4-4' => array(
						'alt' => '4-4-4',
						'img' => $plugins_url .'4-4-4.png',
					),
                    '3-3-3-3' => array(
						'alt' => '3-3-3-3',
						'img' => $plugins_url .'3-3-3-3.png',
					),
					'2-2-2-2-2-2' => array(
						'alt' => '2-2-2-2-2-2',
						'img' => $plugins_url .'2-2-2-2-2-2.png',
					),
                    '4-8' => array(
						'alt' => '4-8',
						'img' => $plugins_url .'4-8.png',
					),
					'8-4' => array(
						'alt' => '8-4',
						'img' => $plugins_url .'8-4.png',
					),
                    '3-3-6' => array(
						'alt' => '3-3-6',
						'img' => $plugins_url .'3-3-6.png',
					),
					'6-3-3' => array(
						'alt' => '6-3-3',
						'img' => $plugins_url .'6-3-3.png',
					),
                    '3-6-3' => array(
						'alt' => '3-6-3',
						'img' => $plugins_url .'3-6-3.png',
					),
					'3-4-5' => array(
						'alt' => '3-4-5',
						'img' => $plugins_url .'3-4-5.png',
					),
                    '5-4-3' => array(
						'alt' => '5-4-3',
						'img' => $plugins_url .'5-4-3.png',
					),
					'2-2-2-6' => array(
						'alt' => '2-2-2-6',
						'img' => $plugins_url .'2-2-2-6.png',
					),
                    '2-2-4-4' => array(
						'alt' => '2-2-4-4',
						'img' => $plugins_url .'2-2-4-4.png',
					),
					'2-4-2-4' => array(
						'alt' => '2-4-2-4',
						'img' => $plugins_url .'2-4-2-4.png',
					),
                    '2-4-4-2' => array(
						'alt' => '2-4-4-2',
						'img' => $plugins_url .'2-4-4-2.png',
					),
					'4-2-4-2' => array(
						'alt' => '4-2-4-2',
						'img' => $plugins_url .'4-2-4-2.png',
					),
                    '4-4-2-2' => array(
						'alt' => '4-4-2-2',
						'img' => $plugins_url .'4-4-2-2.png',
					),
					'6-2-2-2' => array(
						'alt' => '6-2-2-2',
						'img' => $plugins_url .'6-2-2-2.png',
					),
                    '2-2-2-3-3' => array(
						'alt' => '2-2-2-3-3',
						'img' => $plugins_url .'2-2-2-3-3.png',
					),
					'2-3-2-3-2' => array(
						'alt' => '2-3-2-3-2',
						'img' => $plugins_url .'2-3-2-3-2.png',
					),
                    '3-3-2-2-2' => array(
						'alt' => '3-3-2-2-2',
						'img' => $plugins_url .'3-3-2-2-2.png',
					),
					'3-2-2-2-3' => array(
						'alt' => '3-2-2-2-3',
						'img' => $plugins_url .'3-2-2-2-3.png',
					),
				),
				'default'  => '4-4-4',
			)
		),
	)
);
