<?php
/**
 * Redux Framework font family select config.
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

defined( 'ABSPATH' ) || exit;
$plugins_url = plugins_url();

// PHP VERSION :
$php_version_class = (PHP_VERSION > 5.3) ? 'yes' : 'no';
$php_version = '<i class="dashicons dashicons-'.$php_version_class.'"></i><b>'.PHP_VERSION.'</b>';
// PHP ZIP EXTENSION :
$php_zip_extension_class = (extension_loaded('zip')) ? 'yes' : 'no';
$php_zip_extension_label = (extension_loaded('zip')) ? 'Enabled' : 'Disabled';
$php_zip_extension = '<i class="dashicons dashicons-'.$php_zip_extension_class.'"></i><b>'.$php_zip_extension_label.'</b>';
// PHP Memory limit :
$php_memory_limit_data = ini_get('memory_limit');
$php_memory_limit_data = substr_replace($php_memory_limit_data, "", -1);
$php_memory_limit_class = ($php_memory_limit_data > 32) ? 'yes' : 'no';
$php_memory_limit = '<i class="dashicons dashicons-'.$php_memory_limit_class.'"></i><b>'.$php_memory_limit_data.' MB</b>';
// PHP Get Content function :
$php_file_content_class = (ini_get('allow_url_fopen')) ? 'yes' : 'no';
$php_file_content_label = (ini_get('allow_url_fopen')) ? 'Enabled' : 'Disabled';
$php_file_content = '<i class="dashicons dashicons-'.$php_file_content_class.'"></i><b>'.$php_file_content_label.'</b>';


Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Server Status', 'woffice' ),
		'id'         => 'system-status_server_status',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
		    array( 
		        'id'       => 'php_version',
		        'type'     => 'raw',
		        'full_width' => 'true',
		        'title'    => esc_html__('PHP Version', 'woffice'),
		        'desc'     => esc_html__('This is the version of the PHP installed on your server.', 'woffice'),
		        'content'  => $php_version
		    ),
		    array( 
		        'id'       => 'php_zip_extension',
		        'type'     => 'raw',
		        'full_width' => 'true',
		        'title'    => esc_html__('PHP Zip Extension', 'woffice'),
		        'desc'     => esc_html__('This PHP extension is required by Wordpress to install our demo content and other plugins.', 'woffice'),
		        'content'  => $php_zip_extension
		    ),
		    array( 
		        'id'       => 'php_memory_limit',
		        'type'     => 'raw',
		        'full_width' => 'true',
		        'title'    => esc_html__('PHP Memory Limit', 'woffice'),
		        'desc'     => esc_html__('The Memory limit allowed by your php.ini file on your server.', 'woffice'),
		        'content'  => $php_memory_limit
		    ),
		    array( 
		        'id'       => 'php_file_content',
		        'type'     => 'raw',
		        'full_width' => 'true',
		        'title'    => esc_html__('PHP Remote URL Calls', 'woffice'),
		        'desc'     => esc_html__('Whether your server allow us to make API calls or not, you need it enabled for the Members map.', 'woffice'),
		        'content'  => $php_file_content
		    ),
		    
		),
	)
);
