<?php
/**
 * Redux Framework header bar config.
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

defined( 'ABSPATH' ) || exit;
$plugins_url = plugins_url();

$sidebar_show = woffice_unyson_switch_to_bool(woffice_get_settings_option('sidebar_show'));
$sidebar_only_logged = woffice_unyson_switch_to_bool(woffice_get_settings_option('sidebar_only_logged'));
$sidebar_buddypress = woffice_unyson_switch_to_bool(woffice_get_settings_option('sidebar_buddypress'));
$sidebar_blog = woffice_unyson_switch_to_bool(woffice_get_settings_option('sidebar_blog'));
$sidebar_state = woffice_unyson_switch_to_bool(woffice_get_settings_option('sidebar_state'));
$sidebar_mobile = woffice_unyson_switch_to_bool(woffice_get_settings_option('sidebar_mobile'));
$sidebar_min = woffice_get_settings_option('sidebar_min');
$sidebar_scroll = woffice_unyson_switch_to_bool(woffice_get_settings_option('sidebar_scroll'));
$sidebar_scroll_inner = woffice_unyson_switch_to_bool(woffice_get_settings_option('sidebar_scroll_inner'));

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Sidebar', 'woffice' ),
		'id'         => 'select-sidebar-options',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
		    array(
				'id'       => 'sidebar_show',
				'type'     => 'switch',
				'title'    => esc_html__( 'Display the Sidebar on pages.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $sidebar_show,
			),
            array(
				'id'       => 'sidebar_only_logged',
				'type'     => 'switch',
				'title'    => esc_html__( 'Only for logged users?', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $sidebar_only_logged,
			),
            array(
				'id'       => 'sidebar_buddypress',
				'type'     => 'switch',
				'title'    => esc_html__( 'Sidebar on Group & Member pages?', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $sidebar_buddypress,
			),
            array(
				'id'       => 'sidebar_blog',
				'type'     => 'switch',
				'title'    => esc_html__( 'Sidebar on Blog pages ?', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $sidebar_blog,
			),
            array(
				'id'       => 'sidebar_state',
				'type'     => 'switch',
				'title'    => esc_html__( 'Open the sidebar by default', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $sidebar_state,
			),
            array(
				'id'       => 'sidebar_mobile',
				'type'     => 'switch',
				'title'    => esc_html__( 'Display the Sidebar on mobiles', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $sidebar_mobile,
			),
            array(
                'id'       => 'sidebar_min',
                'type'     => 'text', 
                'title'    => esc_html__('Minimum sidebar height', 'woffice'),
                'desc' => esc_html__('You can set here a minimum height for the sidebar, it may looks weird but that is better for the layout and prevent some javascript bugs.', 'woffice'),
                'hint'     => array(
                    'content' => esc_html__('A value in Pixel but no needs for the px.', 'woffice'),
                ),
                'default'  => $sidebar_min,
            ),
            array(
				'id'       => 'sidebar_scroll_inner',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show scroll arrow in the sidebar ?', 'woffice' ),
                'desc'    => esc_html__( 'Do you want to display at the bottom of the right sidebar an arrow to help user navigation.', 'woffice' ),
				'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
				'default'  => $sidebar_scroll_inner,
			),
		),
	)
);