<?php
/**
 * Redux Framework checkbox config.
 * For full documentation, please visit: http://devs.redux.io/
 *
 * @package Redux Framework
 */

defined( 'ABSPATH' ) || exit;

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Theme Color', 'woffice' ),
		'id'         => 'styling-options-theme_color',
        'icon'       => 'el el-brush',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
			array(
				'id'          => 'primary-color',
				'type'        => 'color',
				'output'      => array(
					'color'     => '',
					'important' => true,
				),
				'title'       => esc_html__( 'Primary Color', 'woffice' ),
				'subtitle'    => esc_html__( 'Your brand color.', 'woffice' ),
				'default'     => '#3146c5',
				'transparent' => false,
				'color_alpha' => true
			),
			array(
				'id'       => 'bgcolor-dark',
				'type'     => 'color',
				'title'    => esc_html__( 'Background Color Dark', 'woffice' ),
				'subtitle' => esc_html__( 'For sidebars and widgets.', 'woffice' ),
				'default'  => '#f7f8fa',
				'transparent' => false,
				'color_alpha' => true
			),
            array(
				'id'       => 'bgcolor-light',
				'type'     => 'color',
				'title'    => esc_html__( 'Background Color Light', 'woffice' ),
				'subtitle' => esc_html__( 'For whole content.', 'woffice' ),
				'default'  => '#ffffff',
				'transparent' => false,
				'color_alpha' => true
			),
            array(
				'id'       => 'text-color-dark',
				'type'     => 'color',
				'title'    => esc_html__( 'Text Color Dark', 'woffice' ),
				'subtitle' => esc_html__( 'For Headings.', 'woffice' ),
				'default'  => '#2d3342',
				'transparent' => false,
				'color_alpha' => true
			),
            array(
				'id'       => 'text-color-light',
				'type'     => 'color',
				'title'    => esc_html__( 'Text Color Light', 'woffice' ),
				'subtitle' => esc_html__( 'For Paragraphs.', 'woffice' ),
				'default'  => '#8993BA',
				'transparent' => false,
				'color_alpha' => true
			)
		),
	)
);
