<?php

defined( 'ABSPATH' ) || exit;
$plugins_url = plugins_url();

if (!function_exists('redux_icon_select_fa_5_free')) {
    require_once WOFFICE_CORE_PATH . 'libs/redux-framework/redux-core/inc/extensions/icon_select/font-awesome-5-free.php';
}

$old_options = get_option('fw_theme_settings_options:woffice');

Redux::set_section(
	$opt_name,
	array(
		'title'      => esc_html__( 'Woffice OKRs', 'woffice' ),
		'id'         => 'option-woffice_okr_options',
		'desc'       => esc_html__( 'For full documentation on this, visit: ', 'woffice' ) . '<a href="https://docs.woffice.io/" target="_blank">'.esc_html__('Woffice documentation','woffice').'</a>',
		'subsection' => true,
		'fields'     => array(
            array(
				'id'       => 'okr_progress_notification',
				'type'     => 'switch',
				'title'    => esc_html__( 'OKR Notification For Users', 'woffice' ),
                'desc'    => esc_html__( 'OKR Daily/Weekly/Monthly Notification Reminder', 'woffice' ),
				'default'  => isset($old_options['okr_progress_notification']) ? $old_options['okr_progress_notification'] : false,
                'on'       => esc_html__('Yes','woffice'),
				'off'      => esc_html__('No','woffice'),
			),
            array(
				'id'       => 'okr_notification_type',
				'type'     => 'select',
				'title'    => esc_html__( 'Notification Frequency for Users', 'woffice' ),
                'desc'    => esc_html__( 'Send notification daily,weekly or monthly', 'woffice' ),
				'options'  => array(
					'daily' => esc_html__( 'Daily', 'woffice' ),
					'weekly'  => esc_html__( 'Weekly', 'woffice' ),
                    'monthly'  => esc_html__( 'Monthly', 'woffice' ),
				),
                'default'  => isset($old_options['okr_notification_type']) ? $old_options['okr_notification_type'] : 'weekly',
			),
            array(
				'id'       => 'okr_objective_notification_subject',
				'type'     => 'text',
				'title'    => esc_html__( 'Objective Notification Subject', 'woffice' ),
                'desc'     => esc_html__( 'This is the subject for OKR Objective notificatio.', 'woffice' ),
				'default'  => isset($old_options['okr_objective_notification_subject']) ? $old_options['okr_objective_notification_subject'] : 'OKR Reminder',
			),
            array(
				'id'      => 'okr_objective_notification_content',
				'type'    => 'editor',
				'title'   => esc_html__('Objective Notification Content', 'woffice' ),
                'desc'     => esc_html__('This is the content of the email before the task name. Dynamic variables that will be replaced automatically: {objective_list}', 'woffice' ),
                'default' => isset($old_options['okr_objective_notification_content']) ? $old_options['okr_objective_notification_content'] :  'Hey {user_name},<br/> <p>You have a below Objectives in your bucket.</p> <p> Your Objectives are as below.</p> {objective_list}',
				'args'    => array(
					'wpautop'       => false,
					'media_buttons' => false,
					'textarea_rows' => 5,
					'teeny'         => false,
					'quicktags'     => false,
				),
			),
            array(
				'id'       => 'okr_keyres_notification_subject',
				'type'     => 'text',
				'title'    => esc_html__( 'Key result Notification Subject', 'woffice' ),
                'desc'     => esc_html__( 'This is the subject for OKR Key result notificatio.', 'woffice' ),
				'default'  => isset($old_options['okr_keyres_notification_subject']) ? $old_options['okr_keyres_notification_subject'] : 'OKR Reminder',
			),
            array(
				'id'      => 'okr_keyres_notification_content',
				'type'    => 'editor',
				'title'   => esc_html__('Key result Notification Content', 'woffice' ),
                'desc'     => esc_html__('This is the content of the email before the task name. Dynamic variables that will be replaced automatically: {keyresult_list}', 'woffice' ),
                'default' => isset($old_options['okr_keyres_notification_content']) ? $old_options['okr_keyres_notification_content'] : 'Hey {user_name},<br/> <p>You have a below Key Result in your bucket.</p> <p>Your Key Result are as below.</p> {keyresult_list}.',
				'args'    => array(
					'wpautop'       => false,
					'media_buttons' => false,
					'textarea_rows' => 5,
					'teeny'         => false,
					'quicktags'     => false,
				),
			),
            array(
                'id' => 'okr_okrfront_icon',
                'type' => 'icon_select',
                'title' => esc_html__('OKR Icon', 'woffice'),
                'desc'  => esc_html__('Select icon which is show on OKR','woffice'),
                'default' => '',
                'options' => redux_icon_select_fa_5_free(),
                'enqueue' => true,
                'enqueue_frontend' => true,
                'stylesheet' => 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.9.0/css/all.css',
				'default' => isset($old_options['okr_okrfront_icon']) ? $old_options['okr_okrfront_icon'] :  '',
                'prefix' => 'fa',
            ),
            array(
                'id' => 'okr_objective_icon',
                'type' => 'icon_select',
                'title' => esc_html__('Legacy Icon Select', 'woffice'),
                'desc'  => esc_html__('Select icon which is show on Objective','woffice'),
                'default' => '',
                'options' => redux_icon_select_fa_5_free(),
                'enqueue' => true,
                'enqueue_frontend' => true,
                'stylesheet' => 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.9.0/css/all.css',
				'default' => isset($old_options['okr_objective_icon']) ? $old_options['okr_objective_icon'] :  '',
                'prefix' => 'fa',
            ),
		),
	)
);