<?php
/**
 * Redux Framework Sample Metabox Config File
 * For full documentation, please visit: http:https://devs.redux.io/
 * Metabox Lite support the following fields only:  checkbox, radio, text, textarea, media, & color
 * Post Format and Post Template options are not avaialble in Metabox Lite.
 * These advanced options are available in Redux Pro.
 *
 * @package Redux Framework
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux_Metaboxes' ) ) {
	return;
}

if ( ! function_exists( 'redux_icon_select_fa_5_free' ) ) {
	require_once(WOFFICE_CORE_PATH . 'libs/redux-framework/redux-core/inc/extensions/icon_select/font-awesome-5-free.php');
}


$post_id = isset($_GET['post']) ? intval($_GET['post']) : 0;
$is_directory = get_post_type($post_id);
$default_opt = get_option('fw_ext_settings_options:woffice-directory');

if($post_id !== 0 && $is_directory == 'directory' || isset($_POST['post_type']) && $_POST['post_type'] == 'directory' || isset($_GET['post_type']) && $_GET['post_type'] == 'directory') {
    if(!empty($is_directory) && $is_directory == 'directory') {
        add_action('admin_enqueue_scripts', function() {
            wp_deregister_style('font-awesome');
            wp_deregister_style('rs-icon-set-fa-icon');
            wp_dequeue_style('rs-icon-set-fa-icon' );
        });
    }
}

    $directory_old_meta = get_post_meta($post_id,'fw_options',true);
    $item_fields = ( function_exists( 'get_post_meta' ) ) ? get_post_meta(get_the_ID(), 'directory_items_fields',true) : '';
    $default_fields = function_exists('woffice_get_theming_option') ? woffice_get_theming_option('directory_default_fields') : '';

    $item_location = isset($directory_old_meta['item_location']) && !empty($directory_old_meta['item_location']) ? $directory_old_meta['item_location'] : '';
    $item_button_text = isset($directory_old_meta['item_button_text']) && !empty($directory_old_meta['item_button_text']) ? $directory_old_meta['item_button_text'] : '';
    $item_button_link = isset($directory_old_meta['item_button_link']) && !empty($directory_old_meta['item_button_link']) ? $directory_old_meta['item_button_link'] : '';
    $item_button_icon = isset($directory_old_meta['item_button_icon']) && !empty($directory_old_meta['item_button_icon']) ? $directory_old_meta['item_button_icon'] : '';

    // Standard metabox.
    Redux_Metaboxes::set_box(
        $opt_name,
        array(
            'id'         => 'opt-directory-meta',
            'title'      => esc_html__( 'Item Settings', 'woffice' ),
            'post_types' => array('directory'),
            'position'   => 'normal', // normal, advanced, side.
            'priority'   => 'high',   // high, core, default, low.
            'metaboxes_save_defaults' => true,
            'sections'   => array(
                array(
                    'id'   => 'opt-divide-directory-meta',
                    'type' => 'divide',
                ),
                array(
                    'title'  => esc_html__( 'Item Settings', 'woffice' ),
                    'id'     => 'directory-fields',
                    'icon'   => 'el-icon-cogs',
                    'fields' => array(
                        array(
                            'id'       => 'disable_directory_sidebar',
                            'type'     => 'switch',
                            'title'    => esc_html__( 'Disable Right Sidebar ?', 'woffice' ),
                            'desc'     => esc_html__( 'If this is checked, this will disbale the right sidebar for this page.', 'woffice' ),
                            'on'       => esc_html__('Yes','woffice'),
                            'off'      => esc_html__('No','woffice'),
                            'default'  => false,
                        ),
                        array(
                            'id'           => 'directory_item_location',
                            'type'         => 'google_maps',
                            'title'        => esc_html__( 'Location', 'woffice' ),
                            'subtitle'     => esc_html__( 'This map is set using only address information with a zoom factor of 3.  Lat/Long is returned automatically.', 'woffice' ),
                            'show_api_key' => false,
                            'show_marker_info' => false,
                            'scroll_wheel' => false,
                            'api_key' => isset($default_opt['map_key']) ? $default_opt['map_key'] : woffice_get_theming_option('gmap_api_key'),
                            'default'      => array(
                                'zoom'                        => '', // Zoom far: 3 zoom close 17.
                                'street_number'               => isset($item_location['venue']) && !empty($item_location['venue']) ? $item_location['venue'] : '',
                                'route'                       => isset($item_location['address']) && !empty($item_location['address']) ? $item_location['address'] : '',
                                'locality'                    => isset($item_location['city']) && !empty($item_location['city']) ? $item_location['city'] : '',
                                'administrative_area_level_1' => isset($item_location['state']) && !empty($item_location['state']) ? $item_location['state'] : '',
                                'postal_code'                 => isset($item_location['zip']) && !empty($item_location['zip']) ? $item_location['zip'] : '',
                                'country'                     => isset($item_location['country']) && !empty($item_location['country']) ? $item_location['country'] : '',
                                'latitude'  => isset($item_location['coordinates']['lat']) && !empty($item_location['coordinates']['lat']) ? $item_location['coordinates']['lat'] : '',
                                'longitude' => isset($item_location['coordinates']['lng']) && !empty($item_location['coordinates']['lng']) ? $item_location['coordinates']['lng'] : '',
                            ),
                        ),
                        array(
                            'id'       => 'directory_item_button_text',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Button text', 'woffice' ),
                            'default'  =>  $item_button_text,
                        ),
                        array(
                            'id'       => 'directory_item_button_link',
                            'type'     => 'text',
                            'title'    => esc_html__( 'Button link', 'woffice' ),
                            'default'  => $item_button_link,
                            'validate' => 'url',
                        ),
                        array(
                            'id'               => 'directory_item_button_icon',
                            'type'             => 'icon_select',
                            'title'            => esc_html__( 'Button Icon', 'woffice' ),
                            'options'          => redux_icon_select_fa_5_free(),
                            'enqueue'          => true,
                            'enqueue_frontend' => true,
                            'default'          => $item_button_icon,
                            'stylesheet'       => 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.9.0/css/all.css',
                            'prefix'           => 'fa',
                        ),
                        array(
                            'id'          => 'directory_items_fields',
                            'type'        => 'repeater',
                            'title'       => esc_html__( 'Custom fields', 'woffice' ),
                            'full_width'  => false,
                            'subtitle'    => '',
                            'item_name'   => '',
                            'group_values' => true, 
                            'sortable'    => true,
                            'active'      => false,
                            'collapsible' => false,
                            'fields'      => array(
                                array(
                                    'id'       => 'title',
                                    'type'     => 'text',
                                    'title'    => esc_html__( 'Content', 'woffice' ),
                                    'default'  => '',
                                ),
                                array(
                                    'id'               => 'icon',
                                    'type'             => 'icon_select',
                                    'title'            => esc_html__( 'Icon', 'woffice' ),
                                    'default'          => '',
                                    'options'          => redux_icon_select_fa_5_free(),
                                    'enqueue'          => true,
                                    'enqueue_frontend' => false,
                                    'stylesheet'       => 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.9.0/css/all.css',
                                    'prefix'           => 'fa',
                                ),
                            ),
                        ),
                    ),
                ),
            ),
        )
    );